/*********************************************************************
Movie Manager installation
*********************************************************************/

'@ECHO OFF'
'cls'
say "Movie Manager Installation"
say "----------------------"

/*********************************************************************
Initialization
*********************************************************************/
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

instdrive = ''
instpath = ''
bootdrive = Substr(Translate(Value('PATH',,'OS2ENVIRONMENT')),Pos('\OS2\SYSTEM',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2)

/*********************************************************************
Get the installation drive
*********************************************************************/
say ""
say "Please enter the drive to install upon: (ie. C:)"
parse Upper Pull instdrive
if instdrive == '' then do
  instdrive=bootdrive
end
if right(instdrive, 1)<>':' then do
  instdrive=instdrive||':'
end

/*********************************************************************
Get the installation path
*********************************************************************/
/*
say ""
say "Movie Manager creates a subdirectory called MOVIEMGR for it's files."
say "Please enter the directory where MOVIEMGR should be placed: (blank for root)"
parse Upper Pull intpath
if intpath <> '' then do
  if left(intpath, 1) <> '\' then do
    intpath='\'||intpath
  end
end
intpath=instdrive||intpath
instpath=intpath||"\MOVIEMGR"
*/
instpath=instdrive||"\MOVIEMGR"

/*********************************************************************
verify installation drive and path
*********************************************************************/
say ""
say "Movie Manager will be installed in: " instpath
say "Is this correct? (Y/N)"
parse Upper Pull response
if response <> 'Y' then do
  say "Movie Manager installation aborted.  Nothing installed."
  exit 1
end

/*********************************************************************
ask about wps objects
*********************************************************************/
/*
say ""
say "Create the desktop Movie Manager Workplace Shell objects? (Y/N)"
parse Upper Pull wpsind
say ""
*/
wpsind = "Y"
/* 'md ' intpath  ' 1>nul 2>nul'  */

parse Upper source sourceline
parse Upper Var sourceline os2 type curdir
SourceDrive = FILESPEC("drive",curdir)
SourcePath = FILESPEC("path",curdir)
SourceDrivePath = SourceDrive||SourcePath

'md ' instpath ' 1>nul 2>nul'
say "Installing Movie Manager files..."
'copy '||SourceDrivePath||'readme.txt ' instpath ' 1>nul'
'copy '||SourceDrivePath||'order.frm ' instpath ' 1>nul'
/* 'copy '||SourceDrivePath||'install.cmd ' instpath ' 1>nul' */
'unpack '||SourceDrivePath||'bundle ' instpath ' 1>nul'
'touch '||instpath||'\MOVIEMGR.CAT'
if rc <> 0 then do
  say "Problem copying files to " instpath
  exit 1
end

/*********************************************************************
Define and Create the Folder
*********************************************************************/
if wpsind == 'Y' then do
  say "Creating WorkPlace objects..."

  foldobj='<MovieMgr>'
  foldtitle='Movie Manager'
  foldicon='mmfoldr.ico'

  call SysCreateObject 'WPFolder', foldtitle,'<WP_DESKTOP>','OBJECTID='||foldobj||';ICONFILE='||instpath||'\'||foldicon||';','R'

  /*********************************************************************
  Create Reference Program ICONs in the Folder
  *********************************************************************/
  progobj='MovieMgr_Info'
  progname='view.exe'
  progtitle='Information'
  progpath=bootdrive||'\os2'
  progtype='PM'
  progparm='moviemgr.inf'
  call CreateProgram

  progobj='Movie_Mgr'
  progname='moviemgr.exe'
  progtitle='Movie Manager'
  progpath=instpath
  progtype='PM'
  progparm=''
  call CreateProgram
end

/*********************************************************************
let em know everything ok
*********************************************************************/
say ""
say "Movie Manager sucessfully installed."
exit 0

/*********************************************************************
create a program object in a folder
*********************************************************************/
CreateProgram:
  call SysCreateObject 'WPProgram',progtitle,foldobj,'OBJECTID='||progobj||';EXENAME='||progpath||'\'||progname||';PROGTYPE='||progtype||';PARAMETERS='||progparm||';STARTUPDIR='||instpath||';','R'
  return
