/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;

class JFrame
extends Frame
implements ActionListener,
WindowListener {
    static String fname;
    static String dir;
    static Label statusbar;
    boolean vollbild = false;
    boolean fenster_anpassen = false;
    public Image img = null;
    public Menu M_Datei;
    public Menu M_Optionen;
    public MenuItem M_Vollbild;
    public MenuItem M_Rahmen;
    public Menu M_Hilfe;
    public MenuBar menubar;
    public Info info;
    final int cyMenu = 20;
    final int xMenu = 3;

    public JFrame() {
        super("Java-Viewer");
        this.setLayout(new BorderLayout());
        this.menu();
        this.status();
        this.icon();
        this.addWindowListener(this);
        this.pack();
        this.LoadConfig();
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.M_Datei) {
            if ("Oeffnen".equals(actionEvent.getActionCommand())) {
                this.oeffnen();
            } else if ("Verlassen".equals(actionEvent.getActionCommand())) {
                this.windowClosing(null);
            }
        } else if (actionEvent.getSource() == this.M_Optionen) {
            if ("Vollbild".equals(actionEvent.getActionCommand())) {
                this.setVollbild();
            }
            if ("Fenster anpassen".equals(actionEvent.getActionCommand())) {
                this.setRahmen();
            }
        } else if (actionEvent.getSource() == this.M_Hilfe && "Info".equals(actionEvent.getActionCommand())) {
            this.info = new Info(this);
        }
    }

    void icon() {
        Image image = this.getToolkit().getImage(this.getClass().getResource("jview.jpg"));
        if (image != null) {
            this.setIconImage(image);
        }
    }

    void imgLaden() {
        this.img = this.getToolkit().getImage(String.valueOf(dir) + fname);
        this.repaint();
    }

    void LoadConfig() {
        BufferedReader bufferedReader = null;
        boolean bl = false;
        try {
            this.setStatus("Einstellungen laden...");
            bufferedReader = new BufferedReader(new FileReader("jview.ini"));
            String string = new String();
            Integer n = new Integer(400);
            Integer n2 = new Integer(300);
            while ((string = bufferedReader.readLine()) != null) {
                if (string.substring(0, 6).equals("Size_X")) {
                    n = Integer.valueOf(string.substring(7));
                    bl = true;
                } else if (string.substring(0, 6).equals("Size_Y")) {
                    n2 = Integer.valueOf(string.substring(7));
                    bl = true;
                } else if (string.substring(0, 8).equals("Vollbild")) {
                    if (string.substring(9).equals("1")) {
                        this.vollbild = true;
                    }
                } else if (string.substring(0, 8).equals("Last_Dir")) {
                    dir = string.substring(9);
                } else if (string.substring(0, 16).equals("Fenster_anpassen") && string.substring(17).equals("1")) {
                    this.fenster_anpassen = true;
                }
                if (string != null) continue;
            }
            bufferedReader.close();
            ((Component)this).setBackground(Color.black);
            this.setForeground(Color.white);
            if (bl) {
                ((Component)this).setSize(n, n2);
            }
            this.setStatus("Fertig.");
        }
        catch (Exception exception) {
            ((Component)this).setSize(400, 300);
            ((Component)this).setBackground(Color.black);
            this.setForeground(Color.white);
            this.vollbild = false;
            this.fenster_anpassen = false;
            this.setStatus("Fehler beim einlesen der Programmeinstellungen!");
        }
    }

    void menu() {
        this.menubar = new MenuBar();
        this.M_Datei = new Menu("Datei");
        this.M_Datei.add(new MenuItem("Oeffnen"));
        this.M_Datei.add(new MenuItem("Verlassen"));
        this.menubar.add(this.M_Datei);
        this.M_Datei.addActionListener(this);
        this.M_Optionen = new Menu("Optionen");
        this.M_Vollbild = new MenuItem("Vollbild");
        this.M_Rahmen = new MenuItem("Fenster anpassen");
        this.M_Optionen.add(this.M_Vollbild);
        this.M_Optionen.add(this.M_Rahmen);
        this.menubar.add(this.M_Optionen);
        this.M_Optionen.addActionListener(this);
        this.M_Hilfe = new Menu("Hilfe");
        this.M_Hilfe.add(new MenuItem("Info"));
        this.menubar.add(this.M_Hilfe);
        this.M_Hilfe.addActionListener(this);
        this.setMenuBar(this.menubar);
    }

    void oeffnen() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Oeffnen", 0);
        if (!dir.equals("")) {
            fileDialog.setDirectory(dir);
        }
        fileDialog.setFile("*.gif;*.jpg;*.jpeg");
        fileDialog.show();
        fname = fileDialog.getFile();
        if (fname != null) {
            dir = fileDialog.getDirectory();
            if (this.img != null) {
                this.img.flush();
            }
            this.imgLaden();
        }
    }

    public void paint(Graphics graphics) {
        if (fname.equals("")) {
            return;
        }
        int n = JFrame.statusbar.getSize().height;
        int n2 = this.img.getWidth(this);
        int n3 = this.img.getHeight(this);
        if (this.vollbild) {
            graphics.drawImage(this.img, 0, 41, this.getSize().width, this.getSize().height - 40 - n, ((Component)this).getBackground(), this);
        } else if (!this.fenster_anpassen) {
            graphics.drawImage(this.img, (this.getSize().width - n2) / 2, (this.getSize().height - n3) / 2, this);
        } else {
            graphics.drawImage(this.img, 4, 41, this);
            ((Component)this).setSize(n2 + 6, n3 + n + 40);
        }
        this.setStatus(String.valueOf(dir) + fname + " (" + String.valueOf(n2) + " x " + String.valueOf(n3) + ") ");
        super.paint(graphics);
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            if ("WINDOW_ACTIVATED".equals(windowEvent.paramString())) {
                this.windowActivated(windowEvent);
            }
            if ("WINDOW_CLOSED".equals(windowEvent.paramString())) {
                this.windowClosed(windowEvent);
            }
            if ("WINDOW_CLOSING".equals(windowEvent.paramString())) {
                this.windowClosing(windowEvent);
            }
            if ("WINDOW_DEACTIVATED".equals(windowEvent.paramString())) {
                this.windowDeactivated(windowEvent);
            }
            if ("WINDOW_DEICONIFIED".equals(windowEvent.paramString())) {
                this.windowDeiconified(windowEvent);
            }
            if ("WINDOW_ICONIFIED".equals(windowEvent.paramString())) {
                this.windowIconified(windowEvent);
            }
            if ("WINDOW_OPENED".equals(windowEvent.paramString())) {
                this.windowOpened(windowEvent);
            }
        }
    }

    void SaveConfig() {
        DataOutputStream dataOutputStream = null;
        try {
            this.setStatus("Einstellungen sichern...");
            dataOutputStream = new DataOutputStream(new FileOutputStream("jview.ini"));
            if (this.fenster_anpassen) {
                dataOutputStream.writeBytes("Fenster_anpassen=1\n");
            } else {
                dataOutputStream.writeBytes("Fenster_anpassen=0\n");
            }
            if (this.vollbild) {
                dataOutputStream.writeBytes("Vollbild=1\n");
            } else {
                dataOutputStream.writeBytes("Vollbild=0\n");
            }
            if (!dir.equals("")) {
                dataOutputStream.writeBytes("Last_Dir=" + dir + "\n");
            }
            dataOutputStream.writeBytes("Size_X=" + this.getSize().width + "\n");
            dataOutputStream.writeBytes("Size_Y=" + this.getSize().height + "\n");
            dataOutputStream.close();
            this.setStatus("Fertig.");
        }
        catch (Exception exception) {
            System.exit(1);
        }
    }

    void setRahmen() {
        this.fenster_anpassen = !this.fenster_anpassen;
        this.repaint();
    }

    void setStatus(Integer n) {
        statusbar.setText(new String(String.valueOf(n)));
    }

    void setStatus(String string) {
        statusbar.setText(string);
    }

    void setVollbild() {
        this.vollbild = !this.vollbild;
        this.repaint();
    }

    void status() {
        statusbar = new Label();
        statusbar.setBackground(Color.lightGray);
        statusbar.setSize(this.getSize().width, 19);
        this.add((Component)statusbar, "South");
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.img != null) {
            this.img.flush();
        }
        this.SaveConfig();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

