/******************************************************************************
    Directory Compare

    This program illustrates running command files to produce listings
    which are then opened and compared...
    The author offes No Guarantee as to the functionality of this program,
    you can use this file as you see fit. If you destroy anything by using 
    it you have only yourself to blame.
    compiled using:-  "icc /ss dircomp.c"

    This_area_is_copyright_and_must_not_be_removed_from_an_unmodified_file(c)
        {
            Created by Peter Koller 1995. This Program is FREEWARE
            All Rights Reserved.
        }

example usage:-

a)  dircmp c:\apath
    compares this directory with apath directory eg c:\apath\* with .\*

b)  dircmp /f listing               compare listing with .\*
    dircmp c:\apath c:\bpath        compare c:\apath\* with c:\bpath\*

c)  dircomp /f listing c:\apath
    dircomp c:\apath /f listing     compare listing with c:\apath\*

    create a listing using....> dir /b /o:n c:\apath >listing
******************************************************************************/
#define     TRUE    1
#define     FALSE   0
#include    <string.h>
#include    <stdio.h>
#include    <stdlib.h>

typedef unsigned long BOOL;

void    main(int argc,char *argv[]);

int     UseFile = 0;
int     fcount = 0,
        bcount = 0;
BOOL    flag = FALSE;
BOOL    IsEOF = FALSE;
char    *FilePathA;
char    *FilePathB;
char    Here[] = ".";

char    Envir[512];
char    Batch[512];
char    AFile[512];
char    BFile[512];
char    Temp[512];
char    *FileToOpen;
FILE    *one;
FILE    *two;

/**** Main Program Entry ****/
void    main(int argc,char *argv[])
    {
        int     x;


        /**** Get the TMP Envrionment path ****/
        strcpy(Envir,getenv("TMP"));
        if(strcmp(Envir,"") == 0)
            {
                printf("Error - Missing TMP environment setting");
                goto done;
            }

        /**** Parse the command line ****/
        for(x = 1; x < argc; x++)
            {
                if ( strnicmp("/f", argv[x], 2) == 0 ) UseFile = x;
            }
        switch(argc)
            {
                case 1:
                    printf("Error - Too few arguments \n");
                    goto done;
                    break;
                case 2:
                    if(UseFile)
                        {
                            printf("Error - Too few arguments \n");
                            goto done;
                        }
                    else
                        {
                            FilePathA = argv[1];
                            FilePathB = Here;
                        }
                    break;
                case 3:
                    switch(UseFile)
                        {
                            case 0:
                                FilePathA = argv[1];
                                FilePathB = argv[2];
                                break;
                            case 1:
                                FilePathA = argv[2];
                                FilePathB = Here;
                                break;
                            case 2:
                                printf("Error - Inconsistent argument order \n");
                                goto done;
                                break;
                        }
                    break;
                case 4:
                    switch(UseFile)
                        {
                            case 0:
                                printf("Error - Too many arguments \n");
                                goto done;
                                break;
                            case 1:
                                FilePathA = argv[UseFile + 1];
                                FilePathB = argv[UseFile + 2];
                                break;
                            case 2:
                                FilePathA = argv[UseFile + 1];
                                FilePathB = argv[1];
                                break;
                            case 3:
                                printf("Error - Inconsistent argument order \n");
                                goto done;
                                break;
                        }
                default:
                    printf("Error - Too many arguments \n");
                    goto done;
                    break;
            }

        /**** Create a command file to DIR the directories ****/
        sprintf(Batch,"%s\\%s",Envir,"DIRC~~~~.CMD");
        if(UseFile)
            {
                sprintf(AFile,"%s",FilePathA); //a listing file

                /**** write batch file ****/
                one = fopen(Batch,"w");
                fprintf(one, "@dir /b /o:n %s >%s\\DC~~CMP.DC~\n", FilePathB, Envir);
                fclose(one);

                /**** run batch file ****/
                system(Batch);

                /**** create tidyup batch file ****/
                one = fopen(Batch,"w");
                fprintf(one, "@del %s\\DC~~CMP.DC~\n",Envir);
                fclose(one);
            }
        else
            {
                sprintf(AFile,"%s\\DD~~CMP.DC~",Envir); //a temp file

                /**** write batch file ****/
                one = fopen(Batch,"w");
                fprintf(one, "@dir /b /o:n %s >%s\\DD~~CMP.DC~\n", FilePathA, Envir);
                fprintf(one, "@dir /b /o:n %s >%s\\DC~~CMP.DC~\n", FilePathB, Envir);
                fclose(one);

                /**** run batch file ****/
                system(Batch);

                /**** create tidyup batch file ****/
                one = fopen(Batch,"w");
                fprintf(one, "@del %s\\DD~~CMP.DC~\n", Envir);
                fprintf(one, "@del %s\\DC~~CMP.DC~\n", Envir);
                fclose(one);
            }

        sprintf(BFile, "%s\\DC~~CMP.DC~", Envir); //a temp file

        /**** I now have two temporary files to compare... ****/
        printf("Finding files in  %s missing in %s \n", FilePathA, FilePathB);

        one = fopen(AFile,"r");
        two = fopen(BFile,"r");
        *(AFile) = '\0';
        *(BFile) = '\0';

        /**** First compare one with two... ****/
        while(!IsEOF)
            {
                /**** Get Filename in one ****/
                fgets(AFile,511,one);               //get a filename
                IsEOF = (BOOL)(feof(one) != 0);     // EOF ?

                /**** Find Filename in two ****/
                flag = FALSE;                       //default file not found
                rewind(two);                        //goto start of two
                while(!flag && (feof(two) == 0) && !IsEOF)
                    {
                        fgets(BFile,511,two);
                        if(strcmpi(AFile,BFile) == 0)flag = TRUE;
                    }

                /**** Not found so report it ****/
                if(!flag && !IsEOF)
                    {
                        fcount++;
                        *(AFile + (strlen(AFile) - 1)) = '\0';
                        printf("Forward:%d = %s\\%s missing in %s \n",
                                fcount, FilePathA, AFile, FilePathB);
                    }
            }

        rewind(two);
        IsEOF = FALSE;

        /**** Then compare two with one... ****/
        while(!IsEOF)
            {
                /**** Get Filename in two ****/
                fgets(BFile,511,two);               //get a filename
                IsEOF = (BOOL)(feof(two) != 0);     // EOF ?

                /**** Find Filename in one ****/
                flag = FALSE;                       //default file not found
                rewind(one);                        //goto start of one
                while(!flag && (feof(one) == 0) && !IsEOF)
                    {
                        fgets(AFile,511,one);
                        if(strcmpi(AFile,BFile) == 0)flag = TRUE;
                    }

                /**** Not found so report it ****/
                if(!flag && !IsEOF)
                    {
                        fcount++;
                        *(BFile + (strlen(BFile) - 1)) = '\0';
                        printf("Backward:%d = %s\\%s missing in %s \n",
                                fcount, FilePathB, BFile, FilePathA);
                    }
            }

        /**** all done ****/
        fclose(one);
        fclose(two);
        system(Batch);                  //delete temp files
        sprintf(Temp,"del %s",Batch);   //delete batch file
        system(Temp);
        done:
            return;
    }
