  
  rem Programm         :   Kundenverwaltung
  rem Programmierer    :   JK & HW
  rem Datum            :   01.07.95
  rem Hauptprogramm    :   KUNDEN.KIM
  rem Includeprogramme :   KUNDEN.INC *
  
  
  rem --------------------------------------------------------------------
  rem ffnen oder erstellen der Datenbank
  rem --------------------------------------------------------------------
  MODUL db_oeffnen()
    
    DEFFLOAT a
    DEFSTRING expr
    defstring datei
    defstring _icreate_sep
    _icreate_sep=";"
    
    exist "verz.dat",a
    if a=1 then
      loadarray "verz.dat",_verz,1,2,a
    else
      _verz1=""
      _verz2=""
    endif
    
    DEFINE kun1,  10 as KUNDENNR
    DEFINE kun2,  30 as ZUSATZ
    DEFINE kun3,   6 as ANREDE
    DEFINE kun4,  20 as VORNAME
    DEFINE kun5,  30 as ZUNAME
    DEFINE kun6,  40 as STRASSE
    DEFINE kun7,   7 as PLZ
    DEFINE kun8,  40 as ORT
    DEFINE kun9,  20 as ANSPRECH
    DEFINE kun10, 30 as DURCHWAHL
    DEFINE kun11, 20 as ZENTRALE
    DEFINE kun12, 30 as TELEFAX
    DEFINE kun13, 40 as KREDITINST
    DEFINE kun14, 12 as KONTONR
    DEFINE kun15, 12 as BANKLEITZ
    DEFINE kun16,  5 as WAEHRUNG
    DEFINE kun17,  1 as MWST
    DEFINE kun18,  1 as EGAUSLAND
    DEFINE kun19, 20 as USTID
    DEFINE kun20, 10 as KREDITLIMIT
    DEFINE kun21, 30 as ZAHLUNGSBED
    DEFINE kun22, 10 as LKONTAKT
    DEFINE kun23, 10 as NKONTAKT
    DIMMEMO kun24, 10000
    DEFINE kun25, 10 as Skontokonto
    DEFINE kun26, 10 as Skonto
    DEFINE kun27, 10 as Erloeskonto
    DEFINE kun28, 10 as Bilanzkonto
    DEFINE kun29, 1  as Mahnsperre
    DEFINE kun30, 1  as Mahnstatus
    DEFINE kun31, 1  as Gebuehr
    DEFINE kun32, 1  as Zins
    DEFINE kun33, 1  as Saldovortrag
    DEFINE kun34, 12 as ASoll
    DEFINE kun35, 12 as AHaben
    DEFINE kun36, 12 as Soll
    DEFINE kun37, 12 as Haben
    DEFINE kun38, 1  as Bebucht
    DEFINE kun39,  7 as Rabatt
    DEFINE kun40, 12 as Zahlziel
    DEFINE kun41,  6 as LANREDE
    DEFINE kun42, 30 as LVORNAME
    DEFINE kun43, 30 as LZUNAME
    DEFINE kun44, 40 as LSTRASSE
    DEFINE kun45,  7 as LPLZ
    DEFINE kun46, 40 as LORT
    DEFINE kun47, 12 as Istkonti
    DEFINE kun48, 12 as umsjan
    DEFINE kun49, 12 as umsfeb
    DEFINE kun50, 12 as umsmer
    DEFINE kun51, 12 as umsapr
    DEFINE kun52, 12 as umsmai
    DEFINE kun53, 12 as umsjun
    DEFINE kun54, 12 as umsjul
    DEFINE kun55, 12 as umsaug
    DEFINE kun56, 12 as umssep
    DEFINE kun57, 12 as umsokt
    DEFINE kun58, 12 as umsnov
    DEFINE kun59, 12 as umsdez
    DEFINE kun60, 12 as umsges
    DEFINE kun61, 60 as Bemerk1
    DEFINE kun62, 60 as Bemerk2
    DEFINE kun63, 10 as ulfnr
    
    rem Kohle Juni 95
    rem Frei-Definierbare Felder
    
    DEFINE kun64, 40 as var1
    DEFINE kun65, 40 as var2
    DEFINE kun66, 40 as var3
    DEFINE kun67, 40 as var4
    
    DEFINE hist1, 10 as hkdnr
    DEFINE hist2, 10 as hdatum
    DEFINE hist3, 15 as hstatus
    DEFINE hist4, 10 as hbearb
    DEFINE hist5, 10 as hbeleg
    DEFINE hist6, 10 as hbetrag
    DEFINE hist7,  1 as hmahnfl
    
    REM----- Prfen ob Datenbank schon existiert
    datei=_verz2+"kunden.dbf"
    exist datei,a
    IF a<>1 THEN
      dim feld,1,100
      dim index,1,100
      
      REM-----Bezeichnung       Typ    Lnge   Nachkommastellen
      
      feld1 =" KUNDENNR      ;   N  ;  10  ;   0"
      feld2 =" ZUSATZ        ;   C  ;  30  ;   0"
      feld3 =" ANREDE        ;   C  ;   6  ;   0"
      feld4 =" VORNAME       ;   C  ;  20  ;   0"
      feld5 =" ZUNAME        ;   C  ;  30  ;   0"
      feld6 =" STRASSE       ;   C  ;  40  ;   0"
      feld7 =" PLZ           ;   C  ;   7  ;   0"
      feld8 =" ORT           ;   C  ;  40  ;   0"
      feld9 =" ANSPRECH      ;   C  ;  20  ;   0"
      feld10=" DURCHWAHL     ;   C  ;  30  ;   0"
      feld11=" ZENTRALE      ;   C  ;  20  ;   0"
      feld12=" TELEFAX       ;   C  ;  30  ;   0"
      feld13=" KREDITINST    ;   C  ;  40  ;   0"
      feld14=" KONTONR       ;   N  ;  12  ;   0"
      feld15=" BANKLEITZ     ;   N  ;  12  ;   0"
      feld16=" WAEHRUNG      ;   C  ;   5  ;   0"
      feld17=" MWST          ;   N  ;   1  ;   0"
      feld18=" EGAUSLAND     ;   N  ;   1  ;   0"
      feld19=" USID          ;   C  ;  20  ;   0"
      feld20=" KREDITLIMIT   ;   N  ;  10  ;   2"
      feld21=" ZAHLUNGSBED   ;   C  ;  30  ;   0"
      feld22=" LKONTAKT      ;   C  ;  10  ;   0"
      feld23=" NKONTAKT      ;   C  ;  10  ;   0"
      feld24=" BEM_MEMO      ;   M  ;10000 ;   0"
      feld25=" Skontokonto   ;   N  ;  10  ;   0"
      feld26=" Skonto        ;   N  ;  10  ;   2"
      feld27=" Erloeskonto   ;   N  ;  10  ;   0"
      feld28=" Bilanzkonto   ;   N  ;  10  ;   0"
      feld29=" Mahnsperre    ;   N  ;  1   ;   0"
      feld30=" Mahnstatus    ;   N  ;  1   ;   0"
      feld31=" Gebuehr       ;   N  ;  1   ;   0"
      feld32=" Zins          ;   N  ;  1   ;   0"
      feld33=" Saldovortrag  ;   N  ;  1   ;   0"
      feld34=" ASoll         ;   N  ;  12  ;   2"
      feld35=" AHaben        ;   N  ;  12  ;   2"
      feld36=" Soll          ;   N  ;  12  ;   2"
      feld37=" Haben         ;   N  ;  12  ;   2"
      feld38=" Bebucht       ;   N  ;  12  ;   2"
      feld39=" Rabatt        ;   N  ;  12  ;   2"
      feld40=" Zahlziel      ;   C  ;  12  ;   0"
      feld41=" LANREDE       ;   C  ;   6  ;   0"
      feld42=" LVORNAME      ;   C  ;  30  ;   0"
      feld43=" LZUNAME       ;   C  ;  30  ;   0"
      feld44=" LSTRASSE      ;   C  ;  40  ;   0"
      feld45=" LPLZ          ;   C  ;   7  ;   0"
      feld46=" LORT          ;   C  ;  40  ;   0"
      feld47=" Istkonti      ;   N  ;  12  ;   2"
      feld48=" umsjan        ;   N  ;  12  ;   2"
      feld49=" umsfeb        ;   N  ;  12  ;   2"
      feld50=" umsmer        ;   N  ;  12  ;   2"
      feld51=" umsapr        ;   N  ;  12  ;   2"
      feld52=" umsmai        ;   N  ;  12  ;   2"
      feld53=" umsjun        ;   N  ;  12  ;   2"
      feld54=" umsjul        ;   N  ;  12  ;   2"
      feld55=" umsaug        ;   N  ;  12  ;   2"
      feld56=" umssep        ;   N  ;  12  ;   2"
      feld57=" umsokt        ;   N  ;  12  ;   2"
      feld58=" umsnov        ;   N  ;  12  ;   2"
      feld59=" umsdez        ;   N  ;  12  ;   2"
      feld60=" umsges        ;   N  ;  12  ;   2"
      feld61=" Bemerk1       ;   C  ;  60  ;   0"
      feld62=" Bemerk2       ;   C  ;  60  ;   0"
      feld63=" ulfnr         ;   C  ;  10  ;   0"
      
      rem Neu Juni 95 Kohle
      feld64=" var1          ;   C  ;  60  ;   0"
      feld65=" var2          ;   C  ;  60  ;   0"
      feld66=" var3          ;   C  ;  60  ;   0"
      feld67=" var4          ;   C  ;  60  ;   0"
      
      
      
      REM---Bezeichnung Ausdruck Filter    Unique ja/nein    Ab/Aufsteigend
      index1='tag1 ; KUNDENNR          ; DEL()<>"*" ;    1;    0'
      index2='tag2 ; UPPER(ZUSATZ)     ; DEL()<>"*" ;    0;    0'
      index3='tag3 ; UPPER(ZUNAME)     ; DEL()<>"*" ;    0;    0'
      index4='tag4 ; PLZ               ; DEL()<>"*" ;    0;    0'
      index5='tag5 ; umsges            ; DEL()<>"*" ;    0;    0'
      index6=""
      
      datei=_verz2+"kunden.dbf" : kill datei
      datei=_verz2+"kunden.mdx" : kill datei
      datei=_verz2+"kunden.dbt" : kill datei
      
      datei=_verz2+"kunden"
      icreate datei,feld,index
      
      IOPEN 1,datei
      IOPEN_INDEX 1,datei
      ISET 1,"tag1",expr
      ISTART 1,kun
      IADD 1,kun
      ICLOSE 1
    ENDIF
    
    datei=_verz2+"kunhis.dbf"
    exist datei,a
    IF a<>1 THEN
      dim fld,1,10
      dim ind,1,10
      
      fld1 =" hkdnr    ;   C  ;  10  ;   0"
      fld2 =" hdatum   ;   C  ;  10  ;   0"
      fld3 =" hstatus  ;   C  ;  15  ;   0"
      fld4 =" hbearb   ;   C  ;  10  ;   0"
      fld5 =" hbeleg   ;   N  ;  10  ;   0"
      fld6 =" hbetrag  ;   N  ;  10  ;   2"
      fld7 =" hmahnfl  ;   C  ;   1  ;   0"
      fld8 =""
      
      REM---Bezeichnung Ausdruck Filter    Unique ja/nein    Ab/Aufsteigend
      ind1='tag1 ; hkdnr+hdatum ; DEL()<>"*" ;    0;    1'
      ind2=""
      
      datei=_verz2+"kunhis.dbf" : kill datei
      datei=_verz2+"kunhis.mdx" : kill datei
      datei=_verz2+"kunhis.dbt" : kill datei
      
      datei=_verz2+"kunhis"
      icreate datei,fld,ind
      
      IOPEN 1,datei
      IOPEN_INDEX 1,datei
      ISET 1,"tag1",expr
      ISTART 1,hist
      IADD 1,hist
      ICLOSE 1
      
    ENDIF
    
    datei=_verz2+"kunden"
    IOPEN 1,datei
    IOPEN_INDEX 1,datei
    ISET 1,"tag1",expr
    ISTART 1,kun
    
    IOPEN 2,datei
    IOPEN_INDEX 2,datei
    ISET 2,"tag1",expr
    ISTART 2,kun
    
    datei=_verz2+"kunhis"
    IOPEN 3,datei
    IOPEN_INDEX 3,datei
    ISET 3,"tag1",expr
    ISTART 3,hist
    
    _ind_bez="Kundennummer"
    
  ENDMOD
  
  rem --------------------------------------------------------------------
  rem Maske der ersten Seite
  rem --------------------------------------------------------------------
  MODUL fenster_inhalt()
    defstring inhalt,datei
    deffloat a
    
    def_window "window",0,0,75,15;"modal"
    def_border "rand"
    def_titel "titel","Kundenstammverwaltung";"center"
    def_max_button "max"
    def_scrollbar "jk_scroll_w",1,0,0,0,0
    def_toolbar   "jk_tool_w",0,0,0,0;"region off"
    add_item "window","rand","max","titel","jk_scroll_w"
    
    def_prompt     "aus1",1,1,  "Kundennr. ";""
    def_prompt     "aus3",1,2,  "Anrede         ";""
    def_prompt     "aus5",1,3,  "Firmenname 1   ";""
    def_prompt     "aus2",1,4,  "Firmenname 2   ";""
    def_prompt     "aus6",1,5,  "Strasse        ";""
    def_prompt     "aus7",1,6,  "Plz            ";""
    def_prompt     "aus8",30,6, "Ort            ";""
    def_prompt     "aus9",1,7,  "Kontaktperson  ";""
    def_prompt     "aus10",39,7,"Durchwahl      ";""
    def_prompt     "aus11",1,8, "Zentrale       ";""
    def_prompt     "aus12",44,8,"Fax            ";""
    def_prompt     "aus13",1,9, "Kreditinstitut ";""
    def_prompt     "aus14",1,10, "Kontonummer    ";""
    def_prompt     "aus15",37,10,"Bankleitzahl   ";""
    def_prompt     "aus16",64,10,"Waehrung  "     ;""
    def_prompt     "aus17",1,11,"MwSt pflichtig ";""
    def_prompt     "aus18",37,11,"EG-Ausland    ";""
    def_prompt     "aus19",54,11,"USID          ";""
    def_prompt     "aus20",1,12,"Kreditlimit    ";""
    def_prompt     "aus21",30,12,"Letzter Kontakt ";""
    
    
    def_prompt     "aus24",20,11,"<-1=Ja/0=Nein->"  ;""
    
    def_string     "inp1"   ,17,1,10,kun1,13  ;"border","right"
    def_string     "inp2"   ,17,4,30,kun2,34  ;"border"
    def_string     "inp3"   ,17,2,6 ,kun3, 8  ;"border"
    def_string     "inp5"   ,17,3,30,kun5,34  ;"border"
    def_string     "inp6"   ,17,5,40,kun6,45  ;"border"
    def_string     "inp7"   ,17,6, 7,kun7, 9  ;"border"
    def_string     "inp8"   ,35,6,40,kun8,47  ;"border"
    def_string     "inp9"   ,17,7,20,kun9,22  ;"border"
    def_string     "inp10",50, 7,30,kun10,32  ;"border"
    def_string     "inp11",17, 8,20,kun11,22  ;"border"
    def_string     "inp12",50, 8,30,kun12,32  ;"border"
    def_string     "inp13",17, 9,40,kun13,45  ;"border"
    def_number     "inp14",17,10,12,kun14,""  ;"decimal 0","right","clear","border"
    def_number     "inp15",49,10,12,kun15,"";"decimal 0","right","clear","border"
    def_string     "inp16",75,10, 5,kun16, 7  ;"border"
    def_string     "inp17",17,11, 3,kun17, 3 ;"border","clear"
    def_string     "inp18",49,11, 3,kun18, 3 ;"border","clear"
    def_string     "inp19",60,11,20,kun19,22  ;"border"
    
    def_number     "inp20",17,12,12,kun10,"0..99.99";"decimal 2","right","clear","border"
    def_input_date "inp22",47,12,12,kun22,"" ;"border"
    
    
    
    
    set 15,_ind_bez
    def_prompt     "aus23",22,17,"Sortiert nach"  ;""
    def_prompt     "inp70",37,17,_ind_bez;"border"
    add_item "window","aus23","inp70"
    
    
    rem vier Felder mit variabler Position
    rem Positionsdaten werden geladen
    
    def_string     "inp64",_j_x5,_j_y5,_j_l5,kun64  ;"border"
    def_string     "inp65",_j_x6,_j_y6,_j_l6,kun65  ;"border"
    def_string     "inp66",_j_x7,_j_y7,_j_l7,kun66  ;"border"
    def_string     "inp67",_j_x8,_j_y8,_j_l8,kun67  ;"border"
    
    def_prompt     "j_aus64",_j_x1,_j_y1,_j_var1
    def_prompt     "j_aus65",_j_x2,_j_y2,_j_var2
    def_prompt     "j_aus66",_j_x3,_j_y3,_j_var3
    def_prompt     "j_aus67",_j_x4,_j_y4,_j_var4
    
    DEF_BUTTON     "Button1", 1 ,0 ,14,"","Seite &2"
    DEF_BUTTON     "Button2", 16,0 ,14,"","Seite &3"
    DEF_BUTTON     "Button4", 32,0 ,14,"","Seite &4"
    DEF_BUTTON     "Button3", 48,0 ,14,"","U&msatz"
    
    
    add_item_array "window","aus",1,3
    add_item_array "window","aus",5,21
    add_item "window","aus24"
    add_item_array "window","j_aus",64,67
    
    datei=_verz2+"reihe.dat"
    exist datei,a
    if a=1 then
      call jk_reihe_laden()
    else
      add_item "window","inp1"
      add_item "window","inp3","inp5","inp2"
      add_item_array "window","inp",6,20
      add_item_array "window","inp",64,67
      add_item "window","inp22"
    endif
    add_item "jk_tool_w","Button1","Button2","Button4","Button3"
    add_item "window","jk_tool_w"
    
  ENDMOD
  
  rem --------------------------------------------------------------------
  rem Vor Blttern , automatisch speichern wenn Satz gendert
  rem --------------------------------------------------------------------
  modul vor_blaettern()
    deffloat a
    if _neu=1 then
      call jk_lock(1)
      if _jk_ok=1 then
        call daten_schreiben()
        imodrec 1,kun
        rem iunlock 1,_jk_ok
        _neu=0
      endif
    endif
    inext 1,a,kun
    if a=3 then
      beep
      iprev 1,a,kun
      call daten_setzen()
    else
      call daten_setzen()
    endif
    add_item "window","inp1"
    call jk_lock(1)
  endmod
  
  rem --------------------------------------------------------------------
  rem Zurckblttern , speichern wenn gendert
  rem --------------------------------------------------------------------
  modul zur_blaettern()
    deffloat a
    if _neu=1 then
      call jk_lock(1)
      if _jk_ok=1 then
        call daten_schreiben()
        imodrec 1,kun
        rem iunlock 1,_jk_ok
        _neu=0
      endif
    endif
    iprev 1,a,kun
    if a=4 then
      beep
    else
      call daten_setzen()
    endif
    add_item "window","inp1"
    call jk_lock(1)
  endmod
  
  rem --------------------------------------------------------------------
  rem Suchen nach verschiedenen Indizes
  rem --------------------------------------------------------------------
  MODUL suche_nach(char ind)
    deffloat ok,db_nummer
    defstring index,expr
    
    iget_nr 1,db_nummer
    stradd index,"tag",ind
    iset 1,index,expr
    istart 1,kun
    if ind ="1" then
      call dbliste(ok,1,"1+5+2","10+30+30",3,0)
    else
      if ind ="2" then
        call dbliste(ok,1,"2+5+1","30+30+10",3,2)
      else
        if ind ="3" then
          call dbliste(ok,1,"5+1+2","30+10+30",3,2)
        else
          call dbliste(ok,1,"7+8+1","7+40+10",3,0)
        endif
      endif
    endif
    if ok<>1 then
      igo_nr 1,db_nummer
    endif
    call index_anzeige(expr)
    call daten_setzen()
    setfocus "inp1"
  ENDMOD
  
  rem --------------------------------------------------------------------
  rem Men definieren
  rem --------------------------------------------------------------------
  MODUL def_menu()
    
    def_pulldown_item "ma","&Datei   ",1
    def_pulldown_item "mb","&Suchen   ",1
    def_pulldown_item "mc","Dr&ucken   ",1
    def_pulldown_item "md"," <<&L  ",0
    def_pulldown_item "me"," >>&R  ",0
    def_pulldown_item "mf","  &History ",0
    
    def_popup_item "ma1","&Neu        F2"
    def_popup_item "ma2","&Speichern  F3"
    def_popup_item "ma3","&Lschen "
    def_popup_item "ma5","&Zusatztext F6"
    def_popup_item "ma4","&Ende       F9"
    def_popup_item "ma6"," "
    def_popup_item "ma7","";"sep on"
    def_popup_item "ma8","Feldreihenfolge ndern"
    
    def_popup_item "mb1","&Kundennummer    "
    def_popup_item "mb3","Firmenname &1    "
    def_popup_item "mb2","Firmenname &2    "
    def_popup_item "mb4","&Postleitzahl    "
    
    def_popup_item "mc1","&Kundenliste"
    def_popup_item "mc2","&Telefonliste"
    def_popup_item "mc3","&Umsatzliste"
    
    add_item "ma","ma1","ma2","ma3","ma5","ma6","ma7","ma8","ma4"
    add_item "mb","mb1","mb3","mb2","mb4"
    add_item "mc","mc1","mc2","mc3"
    
    def_pulldown_menu "Menu",1
    ADD_ITEM "Menu","ma","mb","mc","md","me","mf"
    ADD_ITEM "window","Menu"
    
  ENDMOD
  
  rem --------------------------------------------------------------------
  rem Zusatzinformationen auf Fenster 2
  rem --------------------------------------------------------------------
  MODUL fenster2()
    
    def_window "window2",2,2,75,16;"modal","move off"
    def_border "rand2"
    def_titel "titel2","Kundenverwaltung Seite 2";"center"
    def_max_button "max2"
    add_item "window2","rand2","max2","titel2"
    
    DEF_PROMPT "Feldname1",1,1,"Skonto-Konto  ";""
    DEF_PROMPT "Feldname2",37,1,"Skonto  ";""
    DEF_PROMPT "Feldname3",1,2,"Erlskonto  ";""
    DEF_PROMPT "Feldname4",1,3,"Bilanzkonto  ";""
    DEF_PROMPT "Feldname5",1,6,"Mahnsperre  ";""
    DEF_PROMPT "Feldname6",1,7,"Mahnstatus  ";""
    DEF_PROMPT "Feldname7",29,6,"Gebhr  ";""
    DEF_PROMPT "Feldname8",49,6,"Zins  ";""
    DEF_PROMPT "Feldname9",1,8,"Saldovortrag  ";""
    DEF_PROMPT "Feldname10",1,9,"Anfang Soll  ";""
    DEF_PROMPT "Feldname11",37,9,"Anfang Haben  ";""
    DEF_PROMPT "Feldname12",1,10,"Soll  ";""
    DEF_PROMPT "Feldname13",37,10,"Haben  ";""
    DEF_PROMPT "Feldname14",1,11,"Bebucht j/n  ";""
    DEF_PROMPT "Feldname15",37,2,"Rabatt  ";""
    DEF_PROMPT "Feldname16",37,3,"Zahlungsziel  ";""
    
    DEF_STRING "inp25",18,1,15,"";"border"
    def_number "inp26",50,1,12,kun26,""   ;"decimal 2","right","clear","border"
    DEF_STRING "inp27",18,2,15,"";"border"
    DEF_STRING "inp28",18,3,15,"";"border"
    DEF_STRING "inp29",18,6,3,"";"border"
    DEF_STRING "inp30",18,7,3,"";"border"
    DEF_STRING "inp31",40,6,3,"";"border"
    DEF_STRING "inp32",58,6,3,"";"border"
    DEF_STRING "inp33",18,8,3,"";"border"
    DEF_STRING "inp34",18,9,15,"";"border"
    DEF_STRING "inp35",55,9,15,"";"border"
    DEF_STRING "inp36",18,10,15,"";"border"
    DEF_STRING "inp37",55,10,15,"";"border"
    DEF_STRING "inp38",18,11,15,"";"border"
    def_number "inp39",50,2, 7,kun39,""   ;"decimal 2","right","clear","border"
    DEF_STRING "inp40",50,3,12,"";"border"
    
    DEF_BUTTON "PushButton1",1,13,16,"","Seite &1";""
    
    add_item_array "window2","Feldname",1,16
    
    add_item "window2","inp25","inp26","inp27","inp39","inp28","inp40"
    add_item_array "window2","inp",29,38
    
    add_item "window2","PushButton1"
    
    deffloat y,t,a
    defstring obj
    
    set_item_array "inp",kun,25,40
    win_paint "window2"
    add_item "window2","inp25"
    
    while y<>1000
      win_ev y
      get_item_pos obj,t
      if t=13 or t=_ENTER then
        if obj="PushButton1" then y=1000 :endif
      endif
      find_item "window2",a
      if a=-1 then
        y=1000
      endif
    wend
    
    get_item_array "inp",kun,1,3
    get_item_array "inp",kun,5,20
    kun21=""
    get_item "inp22",kun22
    kun23=""
    get_item_array "inp",kun,25,40
    imodrec 1,kun
    if a<>-1 then
      event_on_item "window2","end"
    endif
  ENDMOD
  
  rem --------------------------------------------------------------------
  rem Zusatzinformationen auf Fenster 3 ( Lieferanschrift )
  rem --------------------------------------------------------------------
  MODUL fenster3()
    
    def_window "window3",2,2,70,11;"modal","move off"
    def_border "rand3"
    def_titel "titel3","Lieferanschrift  Kundenverwaltung Seite 3";"center"
    def_max_button "max3"
    add_item "window3","rand3","max3","titel3"
    
    def_prompt     "aus42",1,1,  "Anrede         ";""
    def_prompt     "aus43",1,2,  "Firmenname 1   ";""
    def_prompt     "aus70",1,3,  "Firmenname 2   ";""
    def_prompt     "aus44",1,4,  "Strasse        ";""
    def_prompt     "aus45",1,5,  "Plz            ";""
    def_prompt     "aus46",1,6,  "Ort            ";""
    
    def_string     "inp41"   ,17,1,6 ,kun41, 8  ;"border","clear"
    def_string     "inp43"   ,17,2,30,kun43,34  ;"border","clear"
    def_string     "inp44"   ,17,4,40,kun44,45  ;"border","clear"
    def_string     "inp45"   ,17,5, 7,kun45, 9  ;"border","clear"
    def_string     "inp46"   ,17,6,40,kun46,47  ;"border","clear"
    def_string     "inp70"   ,17,3,30,kun42,34  ;"border","clear"
    
    DEF_BUTTON "PushButton2", 2,8,16,"","Seite &1";""
    
    add_item_array "window3","aus",42,46
    add_item "window3","inp41","inp43","inp70"
    add_item_array "window3","inp",44,46
    add_item "window3","PushButton2","aus70"
    
    deffloat y,t,a
    defstring obj,old
    
    set_item_array "inp",kun,43,46
    set_item "inp70",kun42
    set_item "inp41",kun41
    win_paint "window3"
    add_item "window3","inp41"
    
    while y<>1000
      win_ev y
      get_item_pos obj,t,old
      if t=13 or t=_ENTER then
        if obj="PushButton2" then y=1000 :endif
      endif
      if old="PushButton2" then
        add_item "window3","inp41"
      endif
      find_item "window3",a
      if a=-1 then
        y=1000
      endif
    wend
    get_item_array "inp",kun,43,46
    get_item "inp70",kun42
    get_item "inp41",kun41
    _neu=0
    imodrec 1,kun
    if a<>-1 then
      event_on_item "window3","end"
    endif
  ENDMOD
  
  rem --------------------------------------------------------------------
  rem Zusatzinformationen auf Fenster 4 ( Umstze )
  rem --------------------------------------------------------------------
  MODUL fenster4()
    deffloat druck
    
    def_window "window4",1,1,47,18;"modal"
    def_border "rand4"
    def_titel "titel4","Kundenumsatz";"center"
    add_item "window4","rand4","titel4"
    
    DEF_PROMPT "aus47",1,1,"Januar  ";""
    DEF_PROMPT "aus48",1,2,"Februar ";""
    DEF_PROMPT "aus49",1,3,"Maerz  ";""
    DEF_PROMPT "aus50",1,4,"April  ";""
    DEF_PROMPT "aus51",1,5,"Mai  ";""
    DEF_PROMPT "aus52",1,6,"Juni  ";""
    DEF_PROMPT "aus53",1,7,"Juli  ";""
    DEF_PROMPT "aus54",1,8,"August ";""
    DEF_PROMPT "aus55",1,9,"September  ";""
    DEF_PROMPT "aus56",1,10,"Oktober  ";""
    DEF_PROMPT "aus57",1,11,"November  ";""
    DEF_PROMPT "aus58",1,12,"Dezember  ";""
    DEF_PROMPT "aus72",1,13,"Gesamt    ";""
    
    DEF_PROMPT "aus59",37,1,"DM  ";""
    DEF_PROMPT "aus60",37,2,"DM  ";""
    DEF_PROMPT "aus61",37,3,"DM  ";""
    DEF_PROMPT "aus62",37,4,"DM  ";""
    DEF_PROMPT "aus63",37,5,"DM  ";""
    DEF_PROMPT "aus64",37,6,"DM  ";""
    DEF_PROMPT "aus65",37,7,"DM  ";""
    DEF_PROMPT "aus66",37,8,"DM  ";""
    DEF_PROMPT "aus67",37,9,"DM  ";""
    DEF_PROMPT "aus68",37,10,"DM  ";""
    DEF_PROMPT "aus69",37,11,"DM  ";""
    DEF_PROMPT "aus70",37,12,"DM  ";""
    DEF_PROMPT "aus71",37,13,"DM  ";""
    
    DEF_STRING "inp48",24,1,13,"";"border","view only"
    def_string "inp49",24,2,13,"";"border","view only"
    DEF_STRING "inp50",24,3,13,"";"border","view only"
    DEF_STRING "inp51",24,4,13,"";"border","view only"
    DEF_STRING "inp52",24,5,13,"";"border","view only"
    DEF_STRING "inp53",24,6,13,"";"border","view only"
    DEF_STRING "inp54",24,7,13,"";"border","view only"
    DEF_STRING "inp55",24,8,13,"";"border","view only"
    DEF_STRING "inp56",24,9,13,"";"border","view only"
    DEF_STRING "inp57",24,10,13,"";"border","view only"
    DEF_STRING "inp58",24,11,13,"";"border","view only"
    DEF_STRING "inp59",24,12,13,"";"border","view only"
    DEF_STRING "inp60",24,13,13,"";"border","view only"
    
    DEF_BUTTON "PushButton1", 4,15,16,"","Seite &1";""
    DEF_BUTTON "PushButton2",24,15,16,"","&Drucken";""
    
    add_item_array "window4","aus",47,72
    
    add_item_array "window4","inp",48,60
    add_item "window4","PushButton1","PushButton2"
    
    set_item_array "inp",kun,48,60
    
    deffloat y,t,i,erg_fl,summe,a
    defstring obj
    
    win_paint "window4"
    add_item "window4","PushButton1"
    
    i=48
    while i<=59
      val kun[i],erg_fl
      change kun[i],46,44
      summe=summe+erg_fl
      i=i+1
    wend
    form summe,kun60,2,12
    change kun60,46,44
    set_item "inp60",kun60
    imodrec 1,kun
    
    while y<>1000
      win_ev y
      get_item_pos obj,t
      if obj="PushButton2" and t = 13 then
        druck=1
        y=1000
      endif
      if obj="PushButton2" and t = _ENTER then
        druck=1
        y=1000
      endif
      if obj="PushButton1" and t = 13 then
        druck=0
        y=1000
      endif
      if obj="PushButton1" and t = _f9 then
        druck=0
        y=1000
      endif
      if obj="PushButton1" and t = _ENTER then
        druck=0
        y=1000
      endif
      find_item "window4",a
      if a=-1 then
        y=1000
      endif
    wend
    if a<>-1 then
      event_on_item "window4","end"
    endif
    if druck=1 then
      call umsatz_einzel_druck()
    endif
    
  ENDMOD
  
  rem --------------------------------------------------------------------
  rem Zusatzinformationen auf Fenster 4 ( Bemerkungen )
  rem --------------------------------------------------------------------
  MODUL fenster5()
    def_window "window5",2,2,70,11;"modal","move off"
    def_border "rand5"
    def_titel "titel5","Bemerkungen";"center"
    def_max_button "max5"
    add_item "window5","rand5","max5","titel5"
    
    def_prompt     "aus22",1,1,  "Bemerkungen ";""
    def_text       "inp24",1,2,65,6,1000,kun24 ;"border"
    
    DEF_BUTTON "PushButton5", 2,8,16,"","Seite &1";""
    
    add_item "window5","aus22","inp24","PushButton5"
    
    deffloat y,t,a
    defstring obj,old
    
    
    set_item "inp24",kun24
    win_paint "window5"
    add_item "window5","inp24"
    
    while y<>1000
      win_ev y
      get_item_pos obj,t,old
      if t=13 or t=_ENTER then
        if obj="PushButton5" then y=1000 :endif
      endif
      if old="PushButton5" then
        add_item "window5","inp24"
      endif
      find_item "window5",a
      if a=-1 then
        y=1000
      endif
    wend
    
    get_item "inp24",kun24
    _neu=0
    imodrec 1,kun
    if a<>-1 then
      event_on_item "window5","end"
    endif
  ENDMOD
  
  
  rem --------------------------------------------------------------------
  rem Parameter fr var. Felder holen
  rem --------------------------------------------------------------------
  modul jk_var_holen()
    dim _j_var,1,8
    dimfloat _j_x,1,8
    dimfloat _j_y,1,8
    dimfloat _j_l,1,8
    
    defstring datei
    deffloat a,i
    datei=_verz2+"kuvar.dat"
    exist datei,a
    if a=1 then
      open 9,datei,"r"
      for i=1 to 8
        gets 9,_j_var[i]
        gets 9,_j_x[i]
        gets 9,_j_y[i]
        gets 9,_j_l[i]
        set _j_l[i],_j_var[i]
      next
      close 9
    else
      
      rem Feldbeschreibungen
      
      _j_var1="Bemerk 1       "
      _j_x1  =1
      _j_y1  =13
      _j_l1  =15
      _j_var2="Bemerk 2       "
      _j_x2  =1
      _j_y2  =14
      _j_l2  =15
      
      _j_var3="Bemerk 4       "
      _j_x3  =1
      _j_y3  =15
      _j_l3  =15
      
      _j_var4="Bemerk 5       "
      _j_x4  =1
      _j_y4  =16
      _j_l4  =15
      
      rem Eingabefelder
      _j_var5=""
      _j_x5  =17
      _j_y5  =13
      _j_l5  =60
      
      _j_var6=""
      _j_x6  =17
      _j_y6  =14
      _j_l6  =60
      
      _j_var7=""
      _j_x7  =17
      _j_y7  =15
      _j_l7  =60
      
      _j_var8=""
      _j_x8  =17
      _j_y8  =16
      _j_l8  =60
      
    endif
    
  endmod
  
  rem --------------------------------------------------------------------
  rem Paramter der var. Felder in Datei speichern
  rem --------------------------------------------------------------------
  modul jk_var_schreiben()
    
    defstring datei
    deffloat a,i,vor,nach
    datei=_verz2+"kuvar.dat"
    kill datei
    open 9,datei
    for i=1 to 8
      puts 9,_j_var[i]
      frac _j_x[i],vor,nach
      puts 9,vor
      frac _j_y[i],vor,nach
      puts 9,vor
      frac _j_l[i],vor,nach
      puts 9,vor
    next
    close 9
  endmod
  
  rem --------------------------------------------------------------------
  rem Bewegbare Objekte im Fenster fixieren
  rem --------------------------------------------------------------------
  modul jk_fixiere_objekte()
    
    deffloat i,x,y,breite,hoehe,br,ho,z
    defstring obj$,zahl$
    z=0
    
    for i=64 to 67
      z=z+1
      form i,zahl$,0,1
      
      rem Prompts
      
      obj$="j_aus"+zahl$
      set_item_status obj$,1,"editmode"
      set_item_status obj$,0,"select off","view only"
      textwidth  obj$,"W",breite
      textheight obj$,"I",hoehe
      hoehe=24
      get_item_xy obj$,x,y,br,ho
      _j_x[z]=x/breite
      _j_y[z]=y/hoehe
      _j_l[z]=br/breite
      rem _h_pos[_ob_anzahl]=(ho/hoehe)
    next
    
    z=4
    for i=64 to 67
      z=z+1
      form i,zahl$,0,1
      obj$="inp"+zahl$
      set_item_status obj$,1,"editmode"
      textwidth  obj$,"X",breite
      textheight obj$,"X",hoehe
      hoehe=24
      get_item_xy obj$,x,y,br,ho
      _j_x[z]=x/breite
      _j_y[z]=y/hoehe
      _j_l[z]=br/breite
    next
    event_on_item "window","redisplay"
  endmod
  
  rem --------------------------------------------------------------------
  rem Fixierte Objekte bewegbar machen
  rem --------------------------------------------------------------------
  modul jk_neupos_objekte()
    deffloat i,x,y,breite,hoehe,br,ho
    defstring obj$,zahl$
    for i=64 to 67
      form i,zahl$,0,1
      rem Prompts
      obj$="j_aus"+zahl$
      set_item_status obj$,0,"editmode"
      set_item_status obj$,1,"select off","view only"
      rem Strings
      obj$="inp"+zahl$
      color_item obj$,3
      set_item_status obj$,0,"editmode"
    next
    event_on_item "window","redisplay"
  endmod
  
  rem --------------------------------------------------------------------
  rem Bilden einer Liste der Eingabereihenfolge
  rem --------------------------------------------------------------------
  modul jk_reihe_erstellen()
    defstring datei,text
    deffloat i,c,x
    datei=_verz2+"reihe.dat"
    kill datei
    open 9,datei
    rem Erst prfen der belegten Felder
    for i=1 to 24
      get_item _reiheA[i],text
      val text,c
      if c>0 and c<25 then
        _reiheB[c]=_reiheA[i]
      else
        set_item _reiheA[i],""
      endif
    next
    rem Nun prfen der unblegten Felder
    for i=1 to 24
      get_item _reiheA[i],text
      val text,c
      if c=0 then
        for x=1 to 24
          compress _reiheB[x]
          if _reiheB[x]="" then
            _reiheB[x]=_reiheA[i]
            x=25
          endif
        next
      endif
    next
    for i=1 to 24
      puts 9,_reiheB[i]
    next
    close 9
  endmod
  
  rem --------------------------------------------------------------------
  rem Eingabereihenfolge aus Datei laden
  rem --------------------------------------------------------------------
  modul jk_reihe_laden()
    
    deffloat i,y,x,ok
    defstring datei,text,textakt
    
    datei=_verz2+"reihe.dat"
    exist datei,ok
    if ok=1 then
      open 9,datei,"r"
      for i=1 to 24
        gets 9,text
        add_item "window",text
        if i=1 then
          textakt=text
        endif
      next
      add_item "window",textakt
      close 9
    endif
    
  endmod
  
  rem --------------------------------------------------------------------
  rem Reihenfolge am Bildschirm darstellen
  rem --------------------------------------------------------------------
  modul jk_reihe_zeigen()
    
    deffloat i,y,x,ok
    defstring datei,text,wert$
    
    datei=_verz2+"reihe.dat"
    exist datei,ok
    if ok=1 then
      open 9,datei,"r"
      for i=1 to 24
        gets 9,text
        for x=1 to 24
          if text=_reiheA[x] then
            form x,wert$,0,1
            set_item text,wert$
            x=25
          endif   
        next
      next
      close 9
    endif
  endmod
  
  
  
  
