/******************************* REXX *********************************/
/*  REXX Function to calculate and return Gregorian (Calendar)        */
/*  dates.  This is a port of an ANSI COBOL program which calculated  */
/*  Gregorian dates base on passed Julian dates.  The original        */
/*  program and the REXX port were both done by Jaime A. Cruz, Jr.    */
/*  This program is released to the public domain.  You may contact   */
/*  the author at 72267.1372@compuserve.com, or jcruz@ibm.net         */
/**********************************************************************/
/*                   Table of days in each month.                     */
/**********************************************************************/
month.0 = 12
month.1 = 31
month.2 = 28
month.3 = 31
month.4 = 30
month.5 = 31
month.6 = 30
month.7 = 31
month.8 = 31
month.9 = 30
month.10 = 31
month.11 = 30
month.12 = 31
 
/**********************************************************************/
/*        Argument passed must be in yyddd or yyyyddd format          */
/**********************************************************************/
Parse Upper Arg jul_date, .
Select
/**********************************************************************/
/*  If a five-digit Julian Date was passed, extract the century from  */
/*  the system, and set a flag indicating the short form was used.    */
/**********************************************************************/
   When Length(jul_date) = 5 Then
      Do
         Parse Value jul_date With 1 jul_year 3 ,
                                   3 jul_day 6
         jul_cent = Left(Date('S'), 2)
         short = 1
      End
/**********************************************************************/
/*  If a seven-digit Julian Date was passed, we will use the century  */
/*  the user specified.                                               */
/**********************************************************************/
   When Length(jul_date) = 7 Then
      Do
         Parse Value jul_date With 1 jul_cent 3 ,
                                   3 jul_year 5 ,
                                   5 jul_day 8
         short = 0
      End
/**********************************************************************/
/*  If an unrecognized date format was used, then we'll default to    */
/*  today's date.                                                     */
/**********************************************************************/
   Otherwise
      Do
         jul_day = Date('D')
         jul_cent = Left(Date('S'), 2)
         jul_year = Left(Date('O'), 2)
         short = 0
      End
End
 
If JCLepYer(jul_cent || jul_year) Then
   month.2 = 29
 
/**********************************************************************/
/*         Build the Gregorian year (short or long format).           */
/**********************************************************************/
If short Then
   greg_year = Right(jul_year, 2, '0')
Else
   greg_year = Right(jul_cent, 2, '0') || Right(jul_year, 2, '0')
 
/**********************************************************************/
/*                   Calculate the month and day.                     */
/**********************************************************************/
Do i = 1 To 12 Until jul_day < 1
   jul_day = jul_day - month.i
End
jul_day = jul_day + month.i
greg_day = Right(jul_day, 2, '0')
greg_month = Right(i, 2, '0')
 
/**********************************************************************/
/*        Return the calculated Gregorian date to the invoker         */
/**********************************************************************/
Return greg_month || '/' || greg_day || '/' || greg_year
