/******************************* REXX *********************************/
/*     REXX program to calculate and display current date and         */
/*     time, and pop up daily reminders.                              */
/**********************************************************************/
/*  This program is a port of a program originally written in ANSI    */
/*  COBOL.   The original COBOL program and this REXX port were done  */
/*  by the same programmer, Jaime A. Cruz, Jr.  This program will     */
/*  read an ASCII flat file and produce a pop-up window with an       */
/*  appropriate greeting followed by a list of reminders.  For more   */
/*  information on the flat file, view HELLO.DAT, which contains      */
/*  some sample dates and directions on how to add your own.  There   */
/*  are several external subroutines invoked by this program.  Refer  */
/*  to JCCalJul, JCDoM, JCDoW, JCEaster, JCJulCal, JCLepYer, and      */
/*  JCSort for further information.                                   */
/*                                                                    */
/*  This program is released to the public domain.  Share it with     */
/*  your friends.  It is easy enough to port to other platforms.      */
/*  For  example, the author also has a mainframe version that runs   */
/*  under TSO/E.  Use "EXECIO" instead of "LineIn" to process the     */
/*  data.  Don't forget to allocate the file before issuing the       */
/*  EXECIO commands.  The allocation step is not necessary for a      */
/*  VM/CMS port.  Enjoy!  The author may be contacted at              */
/*  72267.1372@compuserve.com, or jcruz@ibm.net                       */
/**********************************************************************/
quit_hour = '17'                 /* Default hour for quitting time    */
quit_min = '00'                  /* Default minutes for quitting time */
data = 'C:\HELLO.DAT'            /* File containing red-letter dates  */
outline. = ''
outline.max = 0                  /* Maximum length of output line     */
outline.0 = 0                    /* Table of output lines             */
 
/**********************************************************************/
/*                          Table of months                           */
/**********************************************************************/
month.0 = 12
month.1 = 'January'
month.2 = 'February'
month.3 = 'March'
month.4 = 'April'
month.5 = 'May'
month.6 = 'June'
month.7 = 'July'
month.8 = 'August'
month.9 = 'September'
month.10 = 'October'
month.11 = 'November'
month.12 = 'December'
 
/**********************************************************************/
/*          Table of comments to make based on day of week.           */
/**********************************************************************/
comment.0 = 7
comment.1 = 'Happy Monday!  <GROAN...>'
comment.2 = 'I think you''ll make it...'
comment.3 = 'It''s all downhill from here'
comment.4 = 'Hang in there, Baby, Friday''s coming'
comment.5 = ''
comment.6 = 'You''re working on a weekend?'
comment.7 = comment.6
 
/**********************************************************************/
/*                Set up some initial default values.                 */
/**********************************************************************/
day = Date('S')
Parse Value day With 1 year 5 ,
                     5 mm 7 ,
                     7 dd 9
mm = Strip(mm, 'L', '0')
dd = Strip(dd, 'L', '0')
century = Left(year, 2) || '00'
today = Left(year, 2) || JCCalJul(Date('U'))
current = Time('C')
Parse Value current With hh ':' min
min = Left(min, 2)
d_o_w = (Date('B') // 7) + 1                /* Calculates day of week */
 
/**********************************************************************/
/*            Determine the appropriate greeting to use.              */
/**********************************************************************/
If Right(current, 2) = 'pm' Then
   Do
      If hh \= 12 Then
         hours = hh + 12
      Else
         hours = hh
      If hh < 6 | hh = 12 Then
         day_greet = 'afternoon'
      Else
         day_greet = 'evening'
   End
Else
   Do
      day_greet = 'morning'
      If hh \= 12 Then
         hours = hh
      Else
         hours = 0
   End
 
/**********************************************************************/
/*          Calculate the quitting time into civilian-speak           */
/**********************************************************************/
If quit_hour > 12 Then
   Do
      q_hour = quit_hour - 12
      am_or_pm = 'pm'
   End
Else
   Do
      q_hour = quit_hour
      am_or_pm = 'am'
   End
 
/**********************************************************************/
/*                   Display the initial greeting.                    */
/**********************************************************************/
Call PutLine 'Good' day_greet || '!  Today is' Date('W') || ',' ,
             month.mm dd || ',' year || ','
Call PutLine 'and it is now' current || '.'
Call PutLine 'If your quitting time is' q_hour || ':' || quit_min || ,
             am_or_pm 'then'
 
/**********************************************************************/
/*          Display an appropriate "Quitting Time" remark.            */
/**********************************************************************/
If (hours > quit_hour) | ,
   ((hours = quit_hour) & ,
    (min > quit_min)) Then
   Call PutLine 'you shouldn''t even be here!'
Else
   If (hours = quit_hour) & ,
      (min = quit_min) Then
      Call PutLine 'you can leave now!'
   Else
      Do
         If min > quit_min Then
            Do
               quit_min = quit_min + 60
               quit_hour = quit_hour - 1
            End
         quit_hour = quit_hour - hours
         quit_min = quit_min - min
         If quit_min = 1 Then
            sm = ''
         Else
            sm = 's'
         If quit_hour = 1 Then
            sh = ''
         Else
            sh = 's'
         If (quit_hour > 0) & ,
            (quit_min > 0) Then
            Call PutLine 'you only have' quit_hour 'hour' || sh ,
                         'and' quit_min 'minute' || sm 'left to go!'
         Else
            If quit_min = 0 Then
               Call PutLine 'you only have' quit_hour 'hour' || sh ,
                            'to go!'
            Else
               Call PutLine 'you only have' quit_min 'minute' || sm ,
                            'to go!'
      End
 
/**********************************************************************/
/*         Display an appropriate "Time till Friday" remark.          */
/**********************************************************************/
If d_o_w = 5 Then
   Call PutLine 'Thank God it''s Friday!  Have a good weekend.'
Else
   Do
      x = 5 - d_o_w
      If x < 0 Then
         x = x + 7
      If x > 1 Then
         sd = 's'
      Else
         sd = ''
      Call PutLine 'Only' x 'more day' || sd 'to Friday (' || ,
                   comment.d_o_w || ').'
   End
 
/**********************************************************************/
/*     Here's the biggie.  Read in the file containing red-letter     */
/*     dates, and load up a table with this information.              */
/**********************************************************************/
x = 0
Do While Lines(data) > 0
   line = Linein(data)
   perpdate = 0
   Parse Value line With 1 cardgdat 9 ,
                         9 cardtrgr 11 ,
                         11 cardday 72 .
   Select
      When Datatype(Left(cardgdat, 2), 'N') Then
         Nop                                   /* Valid Calendar date */   
      When Translate(Left(cardgdat, 1)) = '*' Then
         Iterate                                /* Skip comment lines */
      When Translate(Left(cardgdat, 1)) = 'R' Then
         Do                                  /* Relative day of month */
            tmp = JCDoM(Substr(cardgdat, 2, 4))
            cardgdat = Left(tmp, 6) || Right(tmp, 2)
         End
      When Translate(Left(cardgdat, 1)) = 'E'  Then
         Do                                /* Date relative to Easter */
            If easter = 'EASTER' Then
               easter = Right(JCEaster(year), 5)
            offset = Strip(Substr(cardgdat, 2, 3))
            If offset = '' Then
               offset = 0
            cardgdat = JCJulCal(easter + offset)
         End
      Otherwise
         Nop
   End
   If Right(cardgdat, 2) = '  ' Then
      Do
         cardgdat = Left(cardgdat, 5) || '/' || year
         perpdate = 1
      End
   Else
      Do
         tmp = Right(cardgdat, 2)
         tmp = century + tmp
         cardgdat = Left(cardgdat, 6) || tmp
      End
   jul_date = JCCalJul(cardgdat)
   trig_year = Left(jul_date, 4)
   trig_day = Right(jul_date, 3)
   cardtrgr = Strip(cardtrgr)
   If Datatype(cardtrgr, 'N') Then
      trigger = cardtrgr
   Else
      trigger = 14
   trig_day = trig_day - trigger
   If trig_day < 1 Then
      Do
         e_o_y = 1
         trig_day = Right(jul_date, 3)
         If \ perpdate Then
            trig_year = trig_year - 1
         If JCLepYer(trig_year) Then
            trig_day = trig_day + 366
         Else
            trig_day = trig_day + 365
         y = Right(trig_year, 4, '0') || Right(trig_day, 3, '0')
         dummy_entry = y - trigger
         dummy_entry = dummy_entry y
         date_trigger = Left(jul_date, 4) || ,
                        '001'
      End
   Else
      Do
         e_o_y = 0
         date_trigger = Right(trig_year, 4, '0') || ,
                        Right(trig_day, 3, '0')
      End
   If date_trigger <= today & ,
      jul_date >= today Then
      Do
         x = x + 1
         table.x = date_trigger ,
                   jul_date ,
                   Strip(cardday)
      End
   If e_o_y Then
      Do
         x = x + 1
         table.x = dummy_entry ,
                         Strip(cardday)
      End
End
line = Lineout(data)
table.0 = x
 
/**********************************************************************/
/*       Table has been loaded.  Sort into ascending sequence         */
/**********************************************************************/
Do x = 0 To table.0
   Queue table.x
End
Call JCSort
Do x = 0 To table.0
   Parse Pull table.x
End
 
/**********************************************************************/
/*                Display upcoming red-letter dates.                  */
/**********************************************************************/
Do x = 1 To table.0
   Parse Var table.x trig_date actual_date holiday_name
   If trig_date > today Then
      Leave
   If actual_date >= today Then
      Do
         If actual_date = today Then
            Call PutLine 'Happy' holiday_name
         Else
            Do
               y = actual_date - today
               weeks_left = y % 7
               days_left = y // 7
               If days_left = 1 & ,
                  weeks_left = 0 Then
                  Call PutLine 'Tomorrow is' holiday_name
               Else
                  Do
                     If days_left = 1 Then
                        sd = ''
                     Else
                        sd = 's'
                     If weeks_left = 1 Then
                        sw = ''
                     Else
                        sw = 's'
                     If weeks_left \= 0 & ,
                        days_left \= 0 Then
                        Call PutLine 'Only' weeks_left 'week' || sw ,
                                     'and' days_left 'day' || sd ,
                                     'till' holiday_name
                     Else
                        If weeks_left = 0 Then
                           Call PutLine 'Only' days_left 'more days' ,
                                        'till' holiday_name
                        Else
                           Call PutLine 'Only' weeks_left ,
                                        'more week' || sw 'till' ,
                                        holiday_name
                  End
            End
      End
End
 
/**********************************************************************/
/*     Display the information in a pop-up message box for user       */
/**********************************************************************/
Call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
initcode = VInit()
If initcode \= 'ERROR' Then
   Do
      Call VDialogPos 50, 50
      done = 0
      x = 0
      msg.0 = 10                     /* Maximum ten lines for display */
      Do Until done
         Do y = 1 To msg.0
            x = x + 1
            msg.y = Left(outline.x, outline.max)
         End
         Call VMsgBox 'Hello!', msg, 1
         If x >= outline.0 Then
            done = 1
      End
   End
Call VExit
Exit
 
/**********************************************************************/
/*           Subroutine to display information to the user            */
/**********************************************************************/
PutLine:
   Procedure Expose outline.
   Parse Arg line_out
   outline.0 = outline.0 + 1
   x = outline.0
   outline.x = line_out
   If Length(line_out) > outline.max Then
      outline.max = Length(line_out)
Return 0
