/******************************* REXX *********************************/
/*            REXX subroutine to sort items in the stack.             */
/*  This simple sort algorithm is based on a "3-index sort" I         */
/*  learned way back in school at the Grumman Data Systems            */
/*  Institute.  The table will be sorted in one complete pass.  All   */
/*  items to be sorted should be placed into the REXX stack.  The     */
/*  first item in the stack to be read should contain the number of   */
/*  elements in the stack.  Upon return to the calling routine, all   */
/*  items in the stack will be sorted in ascending sequence.  This    */
/*  code is released to the public domain by the author.  The author  */
/*  may be contacted at 72267.1372@compuserve.com, or jcruz@ibm.net.  */
/*  Enjoy!                                                            */
/**********************************************************************/
/*               Load items in the stack into a table.                */
/**********************************************************************/
Parse Pull table.0
Do x = 1 To table.0
   Parse Pull table.x
End
 
/**********************************************************************/
/*    If there is more than one element in the stack, sort them.      */
/**********************************************************************/
If table.0 > 1 Then
   Do x = 1 To table.0
      y = x
      Do z = (x + 1) To table.0
         If table.y > table.z Then
            y = z
      End
      If x <> y Then
         Do
            Push table.x
            table.x = table.y
            Parse Pull table.y
         End
   End
 
/**********************************************************************/
/*        Dump the sorted elements back on to the stack FIFO          */
/**********************************************************************/
Do x = 0 To table.0
   Queue table.x
End
Return 0
