/******************************* REXX *********************************/
/*  This is an external function, written in REXX, that will return   */
/*  the Julian date for Easter of any given year.                     */
/*  Invocation:                                                       */
/*       east_sun = JCEaster(xxxx)                                    */
/*  Where:                                                            */
/*       xxxx = The year in question.  If this is omitted, the        */
/*              current year is assumed.                              */
/*       east_sun = the returned value in the form yyyyddd            */
/**********************************************************************/
Parse Arg year, .
If year = '' Then
   year = Left(Date('S'), 4)
 
/**********************************************************************/
/*  Table to determine the calendar date of the Paschal Full Moon     */
/*  (not necessarily the astronomical full moon)                      */
/**********************************************************************/
easter.0 = 19
easter.1 = '04/14'
easter.2 = '04/03'
easter.3 = '03/23'
easter.4 = '04/11'
easter.5 = '03/31'
easter.6 = '04/18'
easter.7 = '04/08'
easter.8 = '03/28'
easter.9 = '04/16'
easter.10 = '04/05'
easter.11 = '03/25'
easter.12 = '03/13'
easter.13 = '04/02'
easter.14 = '03/22'
easter.15 = '04/10'
easter.16 = '03/30'
easter.17 = '04/17'
easter.18 = '04/07'
easter.19 = '03/27'
 
/**********************************************************************/
/*  Determine the date of the Paschal Full Moon by dividing the year  */
/*  by 19.  The remainder is used as an index into the table defined  */
/*  above.                                                            */
/**********************************************************************/
i = (year // 19) + 1
 
/**********************************************************************/
/*  Convert the resulting calendar date of the Paschal Full Moon      */
/*  into Julian format, which is an easier form with which to         */
/*  perform date calculations.  Determine the day of the week upon    */
/*  which the Paschal Full Moon falls.                                */
/**********************************************************************/
pfm = JCCalJul(easter.i || '/' || year)
day = 8 - JCDoW(pfm)
 
/**********************************************************************/
/*  Easter falls on the first Sunday AFTER the Paschal Full Moon.     */
/*  If the Paschal Full Moon is a Sunday, then Easter is the          */
/*  following Sunday.  Return the extended Julian date for Easter to  */
/*  the invoking program.                                             */
/**********************************************************************/
easter_sunday = pfm + day
Return easter_sunday
