
#define VAR_SCOPE extern
 
#include "fsp.h"
 
//*** typedefs **************************************************************
 
typedef struct _FINDREC 
{
   MINIRECORDCORE  crecCore;
   PUSEREC         prec;
 
}  FINDREC, *PFINDREC;
 
//*** Prototypes ************************************************************
 
VOID             pfnTreeDrop     ( HWND, PCNRDRAGINFO );
MRESULT EXPENTRY pfndpTreeSearch ( HWND, ULONG, MPARAM, MPARAM );
BOOL             pfnTreeStat     ( PUSEREC );
VOID             pfnTreeMenu     ( HWND, SHORT );
BOOL             pfnIsAncestor   ( HWND, PUSEREC, PUSEREC );
HPOINTER         pfnWhichIcon    ( PUSEREC );
 
/***************************************************************************/
/* Main ( Tree ) Window Proc                                               */
/***************************************************************************/
MRESULT EXPENTRY pfnwpMainWin    ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   //LONG    lKeyState;
   //CHAR   ach80[81];
    
   PUSEREC  pRecBA;
   HWND     hwndEnt;
    
   //static ULONG  ulc;
    
   switch ( msg ) 
   {
   case WM_CREATE: 
   {
      CNRINFO    cnrinf;

      hwndS = WinLoadDlg ( HWND_DESKTOP, HWND_DESKTOP, pfndpStats, 0L, DLG_STATS, NULL );
       
      //*** Set Globals **************************************************
       
      fbModified = FALSE;
      fbEditing  = FALSE;
      fbSaving   = FALSE;
      fbReading  = FALSE;
      fbClosing  = FALSE;
      fbSftK     = FALSE;
       
      //fbUnregistered = UNREGSTRD;
       
      ulRelRev = REL_REV;
       
      hwndOwn = HWND_DESKTOP;
       
      //*** Create & Init Container **************************************
       
      hwndC = WinCreateWindow ( hwnd, WC_CONTAINER, NULL,
                                WS_VISIBLE | CCS_AUTOPOSITION | CCS_EXTENDSEL,
                                0,0,0,0, hwnd, HWND_TOP,
                                WID_CONT, NULL, NULL );
       
      cnrinf.pszCnrTitle  = " ";
      cnrinf.flWindowAttr = CV_TREE;
      //cnrinf.flWindowAttr = CV_TREE | CV_ICON | CA_TREELINE;
       
      if ( ulTreeOpts & SCB_ICONED )
         cnrinf.flWindowAttr |= CV_ICON;
      else
         cnrinf.flWindowAttr |= CV_TEXT;

      if ( ulTreeOpts & SCB_TREELIN )
         cnrinf.flWindowAttr |= CA_TREELINE;

      pRecAll = malloc ( sizeof ( USEREC ) );
       
      pRecAll->pdr = malloc ( sizeof ( DATREC ) );
       
      pRecAll->pdr->hwndE = hwndC;   // Tree shift problem ???

      if ( ulTreeOpts & SCB_STATED ) 
      {
         //cnrinf.flWindowAttr |= CA_CONTAINERTITLE | CA_TITLESEPARATOR | CA_TITLEREADONLY;
          
         WinShowWindow ( hwndS, TRUE );
      }
       
      WinSendMsg ( hwndC, CM_SETCNRINFO, &cnrinf,
                   MPFROMLONG ( CMA_FLWINDOWATTR | CMA_CNRTITLE ) );
       
       
      //*** Load Pointers ************************************************
       
      /*WinSendMsg ( hwndC, CM_QUERYCNRINFO,
                   MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
       
      ulc = cnrinf.cyLineSpacing;*/
       
      hptr = WinLoadPointer ( HWND_DESKTOP, 0, WID_MAIN );
       
      hptrMain = WinLoadPointer ( HWND_DESKTOP, 0, WID_MAIN );
      hptrText = WinLoadPointer ( HWND_DESKTOP, 0, WID_TEXT );
      hptrAddr = WinLoadPointer ( HWND_DESKTOP, 0, WID_ADDR );
      hptrToDo = WinLoadPointer ( HWND_DESKTOP, 0, WID_TODO );
//      hptrList = WinLoadPointer ( HWND_DESKTOP, 0, WID_LIST );
      hptrMini = WinLoadPointer ( HWND_DESKTOP, 0, WID_MINI );
      hptrPrnt = WinLoadPointer ( HWND_DESKTOP, 0, WID_PRNT );
      hptrRefr = WinLoadPointer ( HWND_DESKTOP, 0, WID_REFR );
   }
   break;
    
   case WM_ACTIVATE:
       
      if ( SHORT1FROMMP ( mp1 ) ) 
      {
         hwndFoc = HWNDFROMMP ( mp2 );
          
         WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
      }
      else 
      {
         hwndFoc = HWNDFROMMP ( mp2 );
          
         WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                      NULL, NULL );
      }
       
   break;
    
   case WM_SIZE:  
       
      WinSetWindowPos ( hwndC, 0, 0, 0,
                        SHORT1FROMMP ( mp2 ),
                        SHORT2FROMMP ( mp2 ),
                        SWP_SIZE | SWP_MOVE );
       
   break;
    
   case WM_INITMENU:
   {
      HWND    hwndMenu;

      WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                   MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                   MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
       
      hwndMenu = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU);
       
      pfnTreeMenu ( hwndMenu, SHORT1FROMMP ( mp1 ) );
   }
   break;
    
   case WM_HELP:
   {
      SHORT   sId;

      sId = WinQueryWindowUShort ( hwnd, QWS_ID );

      WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                   MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
   }
   break;
    
   case WM_COMMAND:   
       
      if ( SHORT1FROMMP(mp1) != MID_TREE_NAME && fbEditing )
         WinSendMsg ( hwndC, CM_CLOSEEDIT, NULL, NULL );
       
      switch ( SHORT1FROMMP ( mp1 ) ) 
      {
      case MID_TREE_SHOWTREE:
      {
         SWP   swp;
         HWND  hwndFrame = WinQueryWindow ( hwnd, QW_PARENT );

         WinQueryWindowPos ( hwndFrame, &swp );
          
         if ( pRec->pdr->swp.fl & SWP_MINIMIZE ) 
         {
            WinSetWindowPos ( hwndFrame, HWND_TOP, 0, 0, 0, 0,
                              SWP_ZORDER | SWP_SHOW | SWP_RESTORE | SWP_ACTIVATE );
         }
         else 
         {
            WinSetWindowPos ( hwndFrame, HWND_TOP, 0, 0, 0, 0,
                              SWP_ZORDER | SWP_SHOW | SWP_RESTORE | SWP_ACTIVATE );
         }
      }
      break;

      case MID_MAIN_NEW:
      {
         USHORT usResp;

         usResp = pfnMaybeSave ();
          
         if ( usResp == MBID_CANCEL )
            break;
          
         pfnNewBook ( hwnd, NULL );
          
         pfnTreeStat ( pRecFoc );
      }
      break;
       
      case MID_MAIN_OPEN:
      {
         USHORT usResp;
         PSZ      pszFileTmp;
          
         pszFileTmp = pfnFileNameBuf ( "*.scb" );

         if ( pfnFileDialog ( hwnd, "Open", TRUE, pszFileTmp ) )
         {
            usResp = pfnMaybeSave ();
             
            if ( usResp == MBID_CANCEL )
               break;
             
            //WinEnableWindowUpdate ( hwndC, FALSE );
             
            pfnReadFile ( hwnd, pszFileTmp );
             
            //WinEnableWindowUpdate ( hwndC, TRUE );
             
            pfnTreeStat ( pRecFoc );
         }

         free ( pszFileTmp );
      }
      break;
       
      case MID_MAIN_SAVE_AS:
      {
         PSZ      pszFileTmp;
          
         pszFileTmp = pfnFileNameBuf ( "*.scb" );

         if ( pfnFileDialog ( hwnd, "Save as", FALSE, pszFileTmp ) )
         {
            pfnSaveFile ( hwnd, pszFileTmp );
             
            fbModified = FALSE;
         }

         free ( pszFileTmp );
      }
      break;
       
      case MID_MAIN_SAVE:
          
         if ( *pszCurrFile )
         {
            pfnSaveFile ( hwnd, pszCurrFile );
             
            fbModified = FALSE;
         }
         else 
            WinSendMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( MID_MAIN_SAVE_AS, 0 ), NULL );
          
      break;
       
      case MID_MAIN_EXIT:

         WinPostMsg ( WinQueryWindow(hwnd,QW_PARENT), WM_SYSCOMMAND, MPFROM2SHORT ( SC_CLOSE, 0 ), NULL );

      break;
       
      case MID_MAIN_SAVE_EXIT:

         if ( *pszCurrFile )
         {
            pfnSaveFile ( hwnd, pszCurrFile );
             
            fbModified = FALSE;
         }
         else 
            WinSendMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( MID_MAIN_SAVE_AS, 0 ), NULL );
          
         if ( ! fbModified )
            WinPostMsg ( WinQueryWindow(hwnd,QW_PARENT), WM_SYSCOMMAND, MPFROM2SHORT ( SC_CLOSE, 0 ), NULL );

      break;
       
      case MID_MAIN_DELETE:
          
         if ( *pszCurrFile )
         {
            if ( pfnMsgYesNo ( hwnd, APP_TITLE,
                               "Are you sure you want to delete this scrapbook from your disk ?" ) )
            {
               if ( DosDelete ( pszCurrFile ) )
               {
                  pfnMsgOK ( hwnd, APP_TITLE, "Error deleting file." );
               }
               else
               {
                  fbModified = FALSE;

                  WinPostMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( MID_MAIN_NEW, 0 ), NULL );
               }
            }
         }
          
      break;
       
      case MID_MAIN_SETTINGS:
          
         WinLoadDlg ( HWND_DESKTOP, hwnd, pfndpSettings,
                      0L, DLG_SETTINGS, NULL );
          
      break;
       
      case MID_MAIN_ABOUT:   
          
         WinDlgBox ( HWND_DESKTOP, hwnd, pfndpAbout,
                     0L, DLG_ABOUT, NULL );
          
      break;
       
      case DIT_REGISTER:
          
         WinDlgBox ( HWND_DESKTOP, hwnd, pfndpRegister,
                     0L, DLG_REGISTER, NULL );
          
      break;
       
      case MID_MAIN_REGINFO:
          
         WinDlgBox ( HWND_DESKTOP, hwnd, pfndpRegInfo,
                       0L, DLG_REGINFO, NULL );
          
      break;
       
      case MID_MAIN_HLPIDX:  
          
         WinSendMsg ( hwndH, HM_HELP_INDEX, NULL, NULL );
          
      break;
       
      case MID_MAIN_HLPGEN:  
          
         WinSendMsg ( hwndH, HM_EXT_HELP, NULL, NULL );
          
      break;
       
      case MID_MAIN_HLPUSE:  
          
         WinSendMsg ( hwndH, HM_DISPLAY_HELP, NULL, NULL );
          
      break;
       
      case MID_MAIN_HLPKEY:  
          
         WinSendMsg ( hwndH, HM_KEYS_HELP, NULL, NULL );
          
      break;
       
      //*** Specials ********************************************************
          
      case MID_TREE_PROPS:
      {
         if ( pRecFoc->pdr->hwndE )
         {
            WinQueryWindowPos ( pRecFoc->pdr->hwndE, &pRecFoc->pdr->swp );
             
            if ( pRecFoc->pdr->swp.fl & SWP_MINIMIZE )
            {
               WinSetWindowPos ( pRecFoc->pdr->hwndE, HWND_TOP, 0, 0, 0, 0,
                                 SWP_ACTIVATE | SWP_ZORDER | SWP_SHOW | SWP_RESTORE );
            }
            else 
            {
               WinSetWindowPos ( pRecFoc->pdr->hwndE, HWND_TOP, 0, 0, 0, 0,
                                 SWP_ACTIVATE | SWP_ZORDER | SWP_SHOW | SWP_RESTORE );
            }
             
            break;
         }
         else
         {
            /*pRecFoc->pdr->hwndE = WinLoadDlg ( HWND_DESKTOP, hwnd, pfndpRefrProps, 0L,
                                               DLG_REFR_PROPERTIES, pRecFoc );*/
            WinDlgBox ( HWND_DESKTOP, hwnd, pfndpRefrProps,
                        0L, DLG_REFR_PROPERTIES, pRecFoc );
         }
      }
      break;
       
      //*** Add Records *****************************************************
          
      case WID_REFR:
      {
         PUSEREC  pRecScn;
         PSZ      pszFileTmp, pszScn;
          
         pszFileTmp = pfnFileNameBuf ( "*" );

         if ( pfnFileDialog ( hwnd, "Get Reference", TRUE, pszFileTmp ) )
         {
            if ( ! pfnFileExists ( pszFileTmp ) )
            {
               CHAR achBuf[CCHMAXPATH+80];
               sprintf ( achBuf, "Error ! %s not found.", pszFileTmp );
                
               pfnMsgOK ( hwnd, APP_TITLE, achBuf );
               break;
            }

            pRecFoc = WinSendMsg ( hwndC, CM_QUERYRECORDEMPHASIS,
                                   MPFROMLONG ( CMA_FIRST ),
                                   MPFROMSHORT( CRA_SELECTED ) );
             
            pRecScn = pfnAllocRec ( pRecFoc, SHORT1FROMMP ( mp1 ), 0, TRUE, TRUE );
             
            pfnCnrShowRec ( hwndC, pRecScn, TRUE );
   
            if ( pRecScn )
            {
               ++pRecAll->pdr->ulDEnt;
             
               fbModified = TRUE;
             
               pfnTreeStat ( pRecFoc );
            }

            pszScn = strrchr ( pszFileTmp, '\\' );
   
            if ( pszScn )
            {
               pRecScn->crecCore.pszTree  = realloc ( pRecScn->crecCore.pszTree, strlen ( pszScn ) );
             
               strcpy ( pRecScn->crecCore.pszTree, pszScn + 1 );
            }
             
            while ( pszScn = strstr ( pRecScn->crecCore.pszTree, "!!" ) )
                  strncpy ( pszScn, "\r\n", 2 );
   
            while ( pszScn = strstr ( pRecScn->crecCore.pszTree, "!" ) )
                  strncpy ( pszScn, "/", 1 );
   
            WinSendMsg ( hwndC, CM_INVALIDATERECORD,
                         MPFROMP ( &pRecScn ), MPFROM2SHORT ( 1, CMA_TEXTCHANGED ) );
             
            pfnRefrNewRec ( pRecScn, pszFileTmp );
         }
         /*else
         {
            free ( pszFileTmp );
            break;
         }*/

         free ( pszFileTmp );
      }
      break;
       
      case WID_BOOK:   
      case WID_CHAP:   
      case WID_SECT:   
      case WID_PAGE:   
      case WID_LIST:   
      case WID_ADDR:   
      case WID_TODO:   
      case WID_MINI:   
      case WID_TEXT:
      {
         PUSEREC      pRecScn;

         pRecFoc = WinSendMsg ( hwndC, CM_QUERYRECORDEMPHASIS,
                                MPFROMLONG ( CMA_FIRST ),
                                MPFROMSHORT( CRA_SELECTED ) );
          
         pRecScn = pfnAllocRec ( pRecFoc, SHORT1FROMMP ( mp1 ), 0, TRUE, TRUE );
          
         pfnCnrShowRec ( hwndC, pRecScn, TRUE );

         if ( pRecScn )
         {
            ++pRecAll->pdr->ulDEnt;
          
            fbModified = TRUE;
          
            pfnTreeStat ( pRecFoc );
         }
      }
      break;
       
      case MID_TREE_CLIPPED:
      {
         PVOID     pvClip;
         PUSEREC   pRecScn;

         if ( pfnIsMyClip ( hwnd, CF_TEXT ) ) 
         {
            WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
             
            pvClip = (PVOID)WinQueryClipbrdData ( WinQueryAnchorBlock ( hwnd ), CF_TEXT );
             
            //*** Alloc & Rename Entry ********************************
             
            pRecFoc = WinSendMsg ( hwndC, CM_QUERYRECORDEMPHASIS,
                                   MPFROMLONG ( CMA_FIRST ),
                                   MPFROMSHORT( CRA_SELECTED ) );
             
            pRecScn = pfnAllocRec ( pRecFoc, WID_TEXT, 0, TRUE, TRUE );
             
            pfnCnrShowRec ( hwndC, pRecScn, TRUE );

            ++pRecAll->pdr->ulDEnt;
             
            fbModified = TRUE;
             
            /*WinSendMsg ( hwndC, CM_INVALIDATERECORD,
                         MPFROMP ( &pRecScn ), MPFROM2SHORT ( 1, CMA_TEXTCHANGED ) );*/
             
            //*** Read It's File **************************************
             
            pRecScn->pdr->ulDEnt = 1;
             
            pRecScn->pdr->ulDLen = strlen ( pvClip ) + 1;
             
            pRecScn->pdr->pvDat = strdup ( pvClip );
             
            pRecScn->pdr->ulOpts = SCB_CONVERT;
             
            if ( ! pRecScn->pdr->pvDat ) 
            {
               pfnMsgOK ( hwnd, APP_TITLE, "Clipboard read failed." );
                
               pRecScn->pdr->ulDLen = 0;
               pRecScn->pdr->ulDEnt = 0;
            }
             
            WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
             
            pfnTreeStat ( pRecFoc );
         }
      }
      break;
       
      case MID_TREE_COPY: case MID_TREE_CUT:   
      {
         ULONG   ulMemSiz;
         PVOID   pvClip;
         PVOID   pvScan;

         if ( pfnEntryOpen ( pRecFoc, 0 ) )
         {
            pfnMsgOK ( hwnd, APP_TITLE, "Can't Cut/Copy an open entry. Please close it and try again." );
             
            break;
         }
         if ( pRecFoc->ulKids )
         {
            pfnMsgOK ( hwnd, APP_TITLE, "Can't Cut/Copy an entry with open children. Please close them and try again." );
             
            break;
         }


         ulMemSiz = 0;
          
         pfnTreeScan ( pRecFoc, SCB_BRANCH, SCB_SIZE, MPFROMP ( &ulMemSiz ) );
          
         pvClip = NULL;
          
         DosAllocSharedMem ( &pvClip, NULL, ulMemSiz, PAG_WRITE | PAG_COMMIT | OBJ_GIVEABLE | OBJ_GETTABLE );
          
         if ( pvClip ) //&& pbMem ) 
         {
            /*DosGetSharedMem ( pvClip, PAG_WRITE );
             
            memcpy ( pvClip, pbMem, ulMemSiz );
             
            free ( pbMem );*/
             
            pvScan = pvClip;
             
            pfnTreeScan ( pRecFoc, SCB_BRANCH, SCB_MEMORY, MPFROMP ( &pvScan ) );
             
            WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
             
            WinSetClipbrdData ( WinQueryAnchorBlock ( hwnd ), (ULONG) pvClip, atomTree, CFI_POINTER );
             
            WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
         }
         else 
         {
            pfnMsgOK ( hwnd, APP_TITLE, "Could not get memory for clipboard." );

            break;
         }
          
         if ( SHORT1FROMMP ( mp1 ) == MID_TREE_CUT ) 
            WinSendMsg ( hwndM, WM_COMMAND, MPFROM2SHORT ( MID_TREE_DELT, 0 ), NULL );
      }
      break;
       
      case MID_TREE_PASTE:   
      {
         PVOID   pvClip;

         if ( pfnIsMyClip ( hwnd, atomTree ) ) 
         {
            WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
             
            pvClip = (PVOID)WinQueryClipbrdData ( WinQueryAnchorBlock ( hwnd ), atomTree );
             
            pfnReadBufr ( hwndC, pvClip, pRecFoc, (PUSEREC) CMA_FIRST );
             
            WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
             
            pRecFoc = WinSendMsg ( hwndC, CM_QUERYRECORDEMPHASIS,
                                   MPFROMLONG ( CMA_FIRST ),
                                   MPFROMSHORT( CRA_SELECTED ) );
             
            fbModified = TRUE;

            pfnTreeStat ( pRecFoc );
         }
      }
      break;
       
      case MID_TREE_PASTE_AFT:
      {
         PVOID   pvClip;

         if ( pRecFoc == pRec )
         {
            WinAlarm ( HWND_DESKTOP, WA_NOTE );
            break;
         }

         if ( pfnIsMyClip ( hwnd, atomTree ) ) 
         {
            pRecBA = WinSendMsg ( hwndC, CM_QUERYRECORD,
                                  MPFROMP ( pRecFoc ),
                                  MPFROM2SHORT ( CMA_PARENT, CMA_ITEMORDER ) );
             
            WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
             
            pvClip = (PVOID)WinQueryClipbrdData ( WinQueryAnchorBlock ( hwnd ), atomTree );
             
            pfnReadBufr ( hwndC, pvClip, pRecBA, pRecFoc );
             
            WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
             
            pRecFoc = WinSendMsg ( hwndC, CM_QUERYRECORDEMPHASIS,
                                   MPFROMLONG ( CMA_FIRST ),
                                   MPFROMSHORT( CRA_SELECTED ) );
             
            fbModified = TRUE;

            pfnTreeStat ( pRecFoc );
         }
      }
      break;
       
      case MID_TREE_DELT:   
          
         if ( pRecFoc != pRec ) 
         {
            pfnTreeScan ( pRecFoc, SCB_BRANCH, SCB_FREE, 0 );
             
            pRecFoc = WinSendMsg ( hwndC, CM_QUERYRECORDEMPHASIS,
                                   MPFROMLONG ( CMA_FIRST ),
                                   MPFROMSHORT( CRA_SELECTED ) );
             
            --pRecAll->pdr->ulDEnt;
             
            fbModified = TRUE;

            pfnTreeStat ( pRecFoc );
         }
         else 
            WinAlarm ( HWND_DESKTOP, WA_NOTE );
          
      break;
       
      case MID_TREE_DETL:   
          
         WinPostMsg ( hwnd, UWM_DETWIN, MPFROMP ( pRecFoc ), NULL );

      break;
       
      case MID_TREE_CLOSE:
      {
         if ( hwndEnt = pfnEntryOpen ( pRecFoc, 0 ) )
         {
            WinSendMsg ( hwndEnt, WM_CLOSE, NULL, NULL );
            //pfnHaveAKid ( pRecScn, FALSE );
         }
      }
      break;
       
      case MID_TREE_ICON:   
      {
        CNRINFO    cnrinf;

         WinSendMsg ( hwndC, CM_QUERYCNRINFO,
                      MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
          
         if ( ulTreeOpts & SCB_ICONED ) 
         {
            cnrinf.flWindowAttr = CV_TREE | CV_TEXT | CA_TREELINE;
             
            ulTreeOpts &= ~SCB_ICONED;
         }
         else 
         {
            cnrinf.flWindowAttr = CV_TREE | CV_ICON | CA_TREELINE;
             
            ulTreeOpts |= SCB_ICONED;
         }
          
         WinSendMsg ( hwndC, CM_SETCNRINFO,
                      MPFROMP ( &cnrinf ),
                      MPFROMLONG ( CMA_FLWINDOWATTR ) );
          
         fbModified = TRUE;
      }
      break;
       
      case MID_TREE_FONT:   
      {
         PDATREC   pdr = pRecAll->pdr;
         HPS       hps = WinGetPS ( pdr->hwndE );

         if ( pfnGetFont ( hwnd, hps, NULLHANDLE, &pdr->fxPtSz, &pdr->fat ) )
         {
            pfnSetPPFont ( pdr->hwndE, pdr->fxPtSz, &pdr->fat );

            fbModified = TRUE;
         }

         WinReleasePS ( hps );
      }
      break;
       
      case MID_TREE_COLOR:  
          
         WinDlgBox ( HWND_DESKTOP, hwnd, pfndpColors, 0L, DLG_COLORS, &hwndC );
          
      break;
       
      case MID_TREE_NAME:   
      {
         /*CNREDITDATA    cnrEdt;

         if ( fbEditing ) 
            WinSendMsg ( hwndC, CM_CLOSEEDIT, NULL, NULL );
         else 
         {
            cnrEdt.cb         = sizeof ( CNREDITDATA );
            cnrEdt.hwndCnr    = hwndC;
            cnrEdt.pRecord    = (PRECORDCORE) pRecFoc;
            cnrEdt.pFieldInfo = NULL;
            cnrEdt.ppszText   = &pRecFoc->crecCore.pszTree;
            cnrEdt.cbText     = strlen ( pRecFoc->crecCore.pszTree ) + 1;
            cnrEdt.id         = WID_CONT;
             
            WinSendMsg ( hwndC, CM_OPENEDIT, MPFROMP ( &cnrEdt ), NULL );
         } */
         WinDlgBox ( HWND_DESKTOP, hwnd, pfndpSetTitle, 0L, DLG_SET_TITLE, pRecFoc );
             
      }
      break;
       
      case MID_TREE_SEARCH: 
          
         WinDlgBox ( HWND_DESKTOP, hwnd, pfndpTreeSearch, 0L, DLG_TREE_SEARCH, NULL );
          
      break;
       
      case MID_TREE_CLS_ALL:
          
         pfnTreeScan ( pRec, SCB_TREE, SCB_CLOSE, 0 );
          
      break;
       
      case MID_TREE_SAV_ALL:
          
         pfnTreeScan ( pRec, SCB_TREE, SCB_SAVE, 0 );
          
      break;
       
      case MID_TREE_EXP_ALL:
          
         pfnTreeScan ( pRec, SCB_TREE, SCB_EXPALL, 0 );
          
      break;
       
      case MID_TREE_CLP_ALL:
          
         pfnTreeScan ( pRec, SCB_TREE, SCB_COLALL, 0 );
          
      break;
       
      case MID_MAIN_PROT:   
          
         WinAlarm ( HWND_DESKTOP, WA_NOTE );
          
         if ( ulRelRev > 5000 ) 
         {
            ulRelRev -= 5000;
         }
         else 
         {
            ulRelRev += 5000;
         }
          
      break;
       
      case MID_MAIN_PSAV:   
          
         WinAlarm ( HWND_DESKTOP, WA_NOTE );
          
         if ( *pszCurrFile )
         {
            pfnSaveFile ( hwnd, pszCurrFile );
             
            fbModified = FALSE;
         }
          
      break;
      }
       
   break;
    
   case WM_CONTROL:   
       
      switch ( SHORT1FROMMP ( mp1 ) ) 
      {
      case WID_CONT:  
          
         switch ( SHORT2FROMMP ( mp1 ) ) 
         {
         case CN_CONTEXTMENU:   
         {
            PUSEREC   pRecScn;
            HWND      hwndMenu;
            POINTL    ptl;
            LONG      lItem;

            pRecScn = PVOIDFROMMP ( mp2 );
             
            if ( ! pRecScn ) 
            {
               hwndMenu = WinLoadMenu ( hwnd, 0, WID_MAIN );

               lItem = MID_MAIN_FILE;
            }
            else 
            {
               pRecFoc = pRecScn;
                
               WinSendMsg ( hwndC, CM_SETRECORDEMPHASIS,
                            MPFROMP ( pRecScn ),
                            MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                
               hwndMenu = WinLoadMenu ( hwnd, 0, WID_TREE );

               lItem = MID_TREE_ADD;
            }
             
            pfnTreeMenu ( hwndMenu, MID_TREE_ADD  );
            pfnTreeMenu ( hwndMenu, MID_TREE_EDIT );

            WinQueryPointerPos ( HWND_DESKTOP, &ptl );
             
            WinMapWindowPoints ( HWND_DESKTOP, hwndM, &ptl, 1 );
             
            WinPopupMenu ( hwnd, hwndM, hwndMenu,
                           (SHORT)ptl.x, (SHORT)ptl.y,
                           lItem,
                           PU_POSITIONONITEM | //PU_HCONSTRAIN | PU_VCONSTRAIN |
                           PU_MOUSEBUTTON1 | PU_MOUSEBUTTON2 | PU_KEYBOARD );
         }
         return ( MRESULT ) TRUE;
          
         case CN_EMPHASIS:   
         {
            PNOTIFYRECORDEMPHASIS pcnrEmf;

            pcnrEmf = PVOIDFROMMP ( mp2 );
             
            if ( pcnrEmf->fEmphasisMask & CRA_SELECTED ) 
            {
               pRecFoc = (PUSEREC) pcnrEmf->pRecord;
                
               //WinPostMsg ( hwndS, UWM_PARAMS, MPFROMP ( pRecFoc ), NULL );
                
               if ( pRecFoc ) 
                  pfnTreeStat ( pRecFoc );
            }
         }
         break;
          
         case CN_BEGINEDIT:  
             
            fbEditing = TRUE;
             
         return ( MRESULT ) TRUE;
          
         case CN_REALLOCPSZ: 
         {
            PCNREDITDATA  pcnrEdt;
            PUSEREC       pRecScn;

            pcnrEdt = PVOIDFROMMP ( mp2 );
             
            pRecScn = (PUSEREC) pcnrEdt->pRecord;
             
            pRecScn->crecCore.pszTree  = realloc ( pRecScn->crecCore.pszTree,
                                                   pcnrEdt->cbText );
             
            fbModified = TRUE;
             
            pfnSetWhen ( &pRecScn->cdWri, &pRecScn->ctWri );
         }
         return ( MRESULT ) TRUE;
          
         case CN_ENDEDIT: 
         {
            PUSEREC       pRecScn;
            PCNREDITDATA  pcnrEdt;
            //PSZ           pszTtl;

            fbEditing = FALSE;
             
            pcnrEdt = PVOIDFROMMP ( mp2 );
             
            pRecScn = (PUSEREC) pcnrEdt->pRecord;
             
            if ( hwndEnt = pfnEntryOpen ( pRecScn, 0 ) )
               WinSetWindowText ( hwndEnt, pRecScn->crecCore.pszTree );
             
            fbModified = TRUE;

            if ( pRecScn == pRec ) 
            {
               /*pszTtl = malloc ( strlen ( pRecScn->crecCore.pszTree ) +
                                 strlen ( "PM Scrapbook - " ) + 1 );
                
               sprintf ( pszTtl, "PM Scrapbook - %s", pRecScn->crecCore.pszTree );
                
               WinSetWindowText ( WinQueryWindow ( hwndM, QW_PARENT ), pszTtl );
                
               free ( pszTtl );*/
                
               pfnFrameTitle ( WinQueryWindow ( hwndM, QW_PARENT ), 
                               "PM Scrapbook", pRecScn->crecCore.pszTree );
            }
         }
         return ( MRESULT ) TRUE;
          
         case CN_ENTER:   
         {
            PUSEREC             pRecScn;
            PNOTIFYRECORDENTER  pcnrEnt;

            pcnrEnt = PVOIDFROMMP ( mp2 );
             
            pRecScn = (PUSEREC) pcnrEnt->pRecord;
             
            if ( ! pRecScn ) 
               pRecScn = pRecFoc;
             
            WinPostMsg ( hwndS, UWM_PARAMS, MPFROMP ( pRecScn ), NULL );
             
            if ( fbEditing ) 
               WinSendMsg ( hwndC, CM_CLOSEEDIT,
                            NULL, NULL );
            else 
               WinPostMsg ( hwnd, UWM_DETWIN, MPFROMP ( pRecScn ), NULL );
         }
         return ( MRESULT ) TRUE;
          
         case CN_INITDRAG:
         {
            PUSEREC       pRecScn;
            PCNRDRAGINIT  pcnrDrg;
            PDRAGINFO     pdinfo;
            DRAGITEM      ditem;
            DRAGIMAGE     dimage;
            LONG          lKeyState;

            pcnrDrg = PVOIDFROMMP ( mp2 );
             
            pRecScn = (PUSEREC) pcnrDrg->pRecord;
            pRecFoc = pRecScn;
             
            if ( ! pRecScn ) 
               break;
             
            if ( pRecScn == pRec )
            {
               WinAlarm ( HWND_DESKTOP, WA_NOTE );
                
               break;
            }
             
            if ( pfnEntryOpen ( pRecScn, 0 ) )
            {
               pfnMsgOK ( hwnd, APP_TITLE, "Can't drag an open entry. Please close it and try again." );
                
               break;
            }

            if ( pRecScn->ulKids )
            {
               pfnMsgOK ( hwnd, APP_TITLE, "Can't drag an entry with open children. Please close them and try again." );
                
               break;
            }

            //*** Drag It ******************************************
             
            pdinfo = DrgAllocDraginfo ( 1 );
             
            lKeyState = WinGetKeyState ( HWND_DESKTOP, VK_CTRL );
             
            if ( lKeyState & 0x8000 )
               pdinfo->usOperation = DO_COPY;
            else
               pdinfo->usOperation = DO_MOVE;

            //pdinfo->hwndSource   = hwndC;
             
            ditem.hwndItem       = hwndC;
            ditem.ulItemID       = (ULONG)pRecScn;
            ditem.hstrType       = DrgAddStrHandle ( DRT_TREE );
            ditem.hstrRMF        = DrgAddStrHandle ( DRM_TREE );
            ditem.fsControl      = 0;
            ditem.fsSupportedOps = DO_COPYABLE | DO_MOVEABLE;
             
            DrgSetDragitem ( pdinfo, &ditem, sizeof(ditem), 0 );
             
            dimage.cb       = sizeof(DRAGIMAGE);
            dimage.cptl     = 0;
            dimage.hImage   = pRecScn->crecCore.hptrIcon;
            dimage.fl       = DRG_ICON;
            dimage.cxOffset = 0;
            dimage.cyOffset = 0;
             
            DrgDrag ( hwnd, pdinfo, &dimage, 1, VK_ENDDRAG, NULL );
             
            DrgFreeDraginfo ( pdinfo );
         }
         break;
          
         case CN_DRAGOVER:
         {
            PCNRDRAGINFO  pcnrDri;
            PDRAGINFO     pdinfo;
            PDRAGITEM     pditem;
            //LONG          lKeyState;
            USHORT        sRet;

            pcnrDri = PVOIDFROMMP ( mp2 );
             
            pdinfo = pcnrDri->pDragInfo;
             
            DrgAccessDraginfo ( pdinfo );
             
            pditem = DrgQueryDragitemPtr ( pdinfo, 0 );
             
            /*lKeyState = WinGetKeyState ( HWND_DESKTOP, VK_CTRL );
             
            if ( lKeyState & 0x8000 && pdinfo->hwndSource == hwndC )
               sRet = DO_COPY;
            else*/
               sRet = pdinfo->usOperation;//DO_MOVE;

            //*** Don't allow MOVE drop on itself ******************************

            if ( ! DrgVerifyRMF ( pditem, "DRM_PMSCRAPBOOK", "DRF_TREE" ) && sRet == DO_MOVE )
               sRet = DO_COPY;//DO_UNKNOWN;
            else if ( sRet == DO_MOVE && hwndC == pdinfo->hwndSource &&
                (PUSEREC)pditem->ulItemID == (PUSEREC)pcnrDri->pRecord )
            {
               DrgFreeDraginfo ( pdinfo );
               return ( MRFROM2SHORT ( DOR_NODROP, sRet ) );
            }

            /*if ( sRet == DO_MOVE &&
                 pfnIsAncestor   ( hwndC, (PUSEREC)pcnrDri->pRecord, (PUSEREC)pditem->ulItemID ) )
            {
               DrgFreeDraginfo ( pdinfo );
               return ( MRFROM2SHORT ( DOR_NEVERDROP, sRet ) );
            }*/


            DrgFreeDraginfo ( pdinfo );

            return ( MRFROM2SHORT ( DOR_DROP, sRet ) );

            /*if ( DrgVerifyRMF ( pditem, "DRM_PMSCRAPBOOK", "DRF_TREE" ) )
            {
               DrgFreeDraginfo ( pdinfo );
                
               return ( MRFROM2SHORT ( DOR_DROP, DO_MOVE ) );
                
            }
            else if ( DrgVerifyRMF ( pditem, "DRM_OS2FILE", "DRF_TEXT" ) )
            {
               DrgFreeDraginfo ( pdinfo );
                
               return ( MRFROM2SHORT ( DOR_DROP, DO_MOVE ) );
            }
            else 
            {
               DrgFreeDraginfo ( pdinfo );
                
               return ( MRFROM2SHORT ( DOR_NEVERDROP, 0 ) );
            }*/
         }
         //break;
          
         case CN_DROP:   
             
            pfnTreeDrop ( hwnd, PVOIDFROMMP ( mp2 ) );
             
            fbModified = TRUE;

         break;
          
         case CN_HELP:   
             
            WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                         MPFROMSHORT ( HID_TREE ), MPFROMSHORT ( HM_RESOURCEID ) );
             
         break;
         }
      break;
      }
   break;
    
   case DM_RENDERPREPARE:
   {
      PDRAGTRANSFER pdxfer;
      PDRAGITEM     pditem;
      ULONG         ulMemSiz;
      PUSEREC       pRecScn;

      pdxfer = (PDRAGTRANSFER) mp1;
       
      pditem  = pdxfer->pditem;
      pRecScn = (PUSEREC) pditem->ulItemID;
       
      ulMemSiz = 0;
       
      /*if ( pdxfer->usOperation == DO_MOVE && //pdxfer->hwndClient == hwndC &&
           pfnIsAncestor   ( hwndC, pRecDroppedOn, pRecScn ) )
      {
         return ( MRFROMLONG ( -1 ) );
      }*/

      pfnTreeScan ( pRecScn, SCB_BRANCH, SCB_SIZE, MPFROMP ( &ulMemSiz ) );

      return (MRESULT) ulMemSiz;
   }
   //break;
    
   case DM_RENDER: 
   {
      PDRAGTRANSFER pdxfer;
      PDRAGITEM     pditem;
      PUSEREC       pRecScn;
      ULONG         ulMemSiz;
      PVOID         pvClip;
      PVOID         pvScan;

      pdxfer = (PDRAGTRANSFER) mp1;
       
      pditem  = pdxfer->pditem;
      pRecScn = (PUSEREC) pditem->ulItemID;
       
      ulMemSiz = 0;
       
      pfnTreeScan ( pRecScn, SCB_BRANCH, SCB_SIZE, MPFROMP ( &ulMemSiz ) );
       
      pvClip = NULL;
       
      DosGetNamedSharedMem ( &pvClip, XFERMEM, PAG_WRITE | PAG_READ );
       
      if ( pvClip ) 
      {
         pvScan = pvClip;
          
         pfnTreeScan ( pRecScn, SCB_BRANCH, SCB_MEMORY, MPFROMP ( &pvScan ) );
          
         DosFreeMem ( pvClip );
          
         fbModified = TRUE;

         return (MRESULT) TRUE;
      }
      else 
         pfnMsgOK ( hwnd, APP_TITLE, "Could not get memory for drag/drop." );
   }
   break;
    
   case DM_ENDCONVERSATION:   
   {
      PDRAGTRANSFER pdxfer;
      PDRAGITEM     pditem;
      BOOL          fbRet;

      pdxfer = (PDRAGTRANSFER) mp1;
       
      fbRet  = (BOOL) mp2;
       
      pditem  = pdxfer->pditem;
      if ( fbRet && DrgVerifyRMF ( pditem, "DRM_PMSCRAPBOOK", "DRF_TREE" ) )
      {
         if ( pdxfer->usOperation == DO_MOVE )//&& pRecDroppedOn )//&&
             // ( pdxfer->hwndClient == hwndC  ||
               // (PUSEREC)pdxfer->hwndClient == pRecDroppedOn ) )
                //(PUSEREC)pditem->ulItemID != pRecDroppedOn ) )
         {
            //*** pRecDroppedOn is used to determine if it was an 'internal' drag ***

            if ( pRecDroppedOn && pfnIsAncestor ( hwndC, pRecDroppedOn, (PUSEREC)pditem->ulItemID ) )
            {
               pRecDroppedOn = 0;
               break;
            }
   
            pRecFoc = (PUSEREC) pditem->ulItemID;
             
            fbModified = TRUE;
   
            WinSendMsg ( hwndM, WM_COMMAND, MPFROM2SHORT ( MID_TREE_DELT, 0 ), NULL );
         }
      }

      pRecDroppedOn = 0;
   }
   break;
    
   case DM_DISCARDOBJECT:   
   {
      PDRAGINFO     pdinfo;
      PDRAGITEM     pditem;

      pdinfo = (PDRAGINFO) mp1;
       
      DrgAccessDraginfo ( pdinfo );
       
      pditem = DrgQueryDragitemPtr ( pdinfo, 0 );
       
      pRecFoc = (PUSEREC) pditem->ulItemID;
       
      WinSendMsg ( hwndM, WM_COMMAND, MPFROM2SHORT ( MID_TREE_DELT, 0 ), NULL );
   }
   return (MRESULT) DRR_SOURCE;
    
   case WM_PAINT:   
   {
      HPS    hps;
      RECTL  rcl;

      hps = WinBeginPaint ( hwnd, NULLHANDLE, &rcl );
       
      WinFillRect ( hps, &rcl, SYSCLR_WINDOW );
       
      WinEndPaint ( hps );
   }
   break;
    
   case WM_CLOSE:   
   {
      USHORT usResp;

      fbClosing = TRUE;

      usResp = pfnMaybeSave ();
       
      if ( usResp == MBID_CANCEL )
      {
         fbClosing = FALSE;

         break;
      }
       
      WinPostMsg ( hwnd, WM_QUIT, NULL, NULL );
   }
   break;//return WinDefWindowProc ( hwnd, msg, mp1, mp2 );//break;//return (MRESULT) TRUE;
    
   case WM_PRESPARAMCHANGED:   
       
      //pRecScn->pdr->fbModified = TRUE;
      fbModified = TRUE;
       
   break;
    
   case WM_ERASEBACKGROUND:   
       
   return ( MRESULT ) ( TRUE );
    
   case UWM_DETWIN:   
   {
      ULONG     flCreate;
      PUSEREC   pRecScn;

      pRecScn = PVOIDFROMMP ( mp1 );
       
      if ( pRecScn->ulType == WID_REFR )
      {
         /*CHAR buf[CCHMAXPATH+2];
         PSZ  pszBlank;
         buf[0] = 0;
         buf[1] = 0;

         if ( pszBlank = strchr ( (PSZ) pRecScn->pdr->pvDat, ' ' ) )
            buf[0] = '"';

         strcat ( buf, (PSZ) pRecScn->pdr->pvDat );

         if ( pszBlank )
            strcat ( buf, "\"" );

         pfnOpenWPSObject ( hwnd, buf );*/
         pfnOpenWPSObject ( hwnd, (PSZ) pRecScn->pdr->pvDat );
         /*WinSendMsg ( hwndC, CM_SETRECORDEMPHASIS,
                      MPFROMP ( pRecScn ),
                      MPFROM2SHORT ( TRUE, CRA_INUSE ) );*/
         break;
      }

      if ( hwndEnt = pfnEntryOpen ( pRecScn, 0 ) )
      {
         WinQueryWindowPos ( hwndEnt, &pRecScn->pdr->swp );
          
         if ( pRecScn->pdr->swp.fl & SWP_MINIMIZE ) 
         {
            WinSetWindowPos ( hwndEnt, HWND_TOP, 0, 0, 0, 0,
                              SWP_ACTIVATE | SWP_ZORDER | SWP_SHOW | SWP_RESTORE );
         }
         else 
         {
            WinSetWindowPos ( hwndEnt, HWND_TOP, 0, 0, 0, 0,
                              SWP_ACTIVATE | SWP_ZORDER | SWP_SHOW | SWP_RESTORE );
         }
          
         break;
      }
       
      switch ( pRecScn->ulType ) 
      {
      case WID_ADDR:  
          
         flCreate = FCF_SYSMENU | FCF_ACCELTABLE | FCF_TITLEBAR | FCF_MINMAX | FCF_ICON |
                    FCF_SIZEBORDER | FCF_NOBYTEALIGN;
          
         if ( ulAddrOpts & SCB_MENUED ) 
            flCreate |= FCF_MENU;
          
         if ( ulTreeOpts & SCB_WINTASK )
            flCreate |= FCF_TASKLIST;

         pRecScn->pdr->hwndD = WinCreateStdWindow ( hwndOwn, 0L, &flCreate, "PMScbAddr",
                                                    pRecScn->crecCore.pszTree,
                                                    0L, 0L, (ULONG)WID_ADDR, NULL );
      break;
       
      case WID_TODO:  
          
         flCreate = FCF_SYSMENU | FCF_ACCELTABLE | FCF_TITLEBAR | FCF_MINMAX | FCF_ICON |
                    FCF_SIZEBORDER | FCF_NOBYTEALIGN;
          
         if ( ulToDoOpts & SCB_MENUED ) 
            flCreate |= FCF_MENU;
          
         if ( ulTreeOpts & SCB_WINTASK )
            flCreate |= FCF_TASKLIST;

         pRecScn->pdr->hwndD = WinCreateStdWindow ( hwndOwn, 0L, &flCreate, "PMScbToDo",
                                                    pRecScn->crecCore.pszTree,
                                                    0L, 0L, (ULONG)WID_TODO, NULL );
      break;
       
      case WID_MINI:  
          
         flCreate = FCF_SYSMENU | FCF_ACCELTABLE | FCF_TITLEBAR | FCF_MINMAX | FCF_ICON |
                    FCF_SIZEBORDER | FCF_NOBYTEALIGN;
          
         if ( ulMiniOpts & SCB_MENUED ) 
            flCreate |= FCF_MENU;
          
         if ( ulTreeOpts & SCB_WINTASK )
            flCreate |= FCF_TASKLIST;

         pRecScn->pdr->hwndD = WinCreateStdWindow ( hwndOwn, 0L, &flCreate, "PMScbMini",
                                                    pRecScn->crecCore.pszTree,
                                                    0L, 0L, (ULONG)WID_MINI, NULL );
      break;
       
      default:
          
         flCreate = FCF_SYSMENU | FCF_ACCELTABLE | FCF_TITLEBAR | FCF_MINMAX | FCF_ICON |
                    FCF_MENU | FCF_SIZEBORDER | FCF_NOBYTEALIGN;
          
         if ( ulTreeOpts & SCB_WINTASK )
            flCreate |= FCF_TASKLIST;

         pRecScn->pdr->hwndD= WinCreateStdWindow ( hwndOwn, 0L, &flCreate, "PMScbText",
                                                   pRecScn->crecCore.pszTree,
                                                   0L, 0L, (ULONG)WID_TEXT, NULL );
      break;
      }
       
      pfnHaveAKid ( pRecScn, TRUE );

      WinPostMsg ( pRecScn->pdr->hwndD, UWM_PARAMS, MPFROMP ( pRecScn ), NULL );
       
      pfnSetWhen ( &pRecScn->cdAcc, &pRecScn->ctAcc );
       
      WinSendMsg ( hwndC, CM_SETRECORDEMPHASIS,
                   MPFROMP ( pRecScn ),
                   MPFROM2SHORT ( TRUE, CRA_INUSE ) );
   }
   break;
    
   case UWM_SETTING:  
   {
      //USHORT     usResp;
      CNRINFO    cnrinf;

      //usResp = SHORT1FROMMP ( mp2 );
       
      switch ( SHORT1FROMMP ( mp1 ) ) 
      {
      case WID_MAIN:  
      {
         switch ( SHORT2FROMMP ( mp1 ) ) 
         {
         case MID_TREE_ICON:
             
            WinSendMsg ( hwndC, CM_QUERYCNRINFO,
                         MPFROMP( &cnrinf ), 
                         MPFROMSHORT ( sizeof ( cnrinf ) ) );
             
            if ( SHORT1FROMMP ( mp2 ) ) 
            {
               cnrinf.flWindowAttr &= ~CV_TEXT;
               cnrinf.flWindowAttr |=  CV_ICON;
                
               ulTreeOpts |= SCB_ICONED;
            }
            else 
            {
               cnrinf.flWindowAttr &= ~CV_ICON;
               cnrinf.flWindowAttr |=  CV_TEXT;
                
               ulTreeOpts &= ~SCB_ICONED;
            }
             
            WinSendMsg ( hwndC, CM_SETCNRINFO, &cnrinf,
                         MPFROMLONG ( CMA_FLWINDOWATTR ) );
             
            WinUpdateWindow ( hwndC );
             
         break;
          
         case MID_MAIN_TREELINES:   
             
            WinSendMsg ( hwndC, CM_QUERYCNRINFO,
                         MPFROMP( &cnrinf ), 
                         MPFROMSHORT ( sizeof ( cnrinf ) ) );
             
            if ( SHORT1FROMMP ( mp2 ) ) 
            {
               cnrinf.flWindowAttr |= CA_TREELINE;
                
               ulTreeOpts |= SCB_TREELIN;
                
            }
            else 
            {
               cnrinf.flWindowAttr &= ~CA_TREELINE;
                
               ulTreeOpts &= ~SCB_TREELIN;
            }
             
            WinSendMsg ( hwndC, CM_SETCNRINFO, &cnrinf,
                         MPFROMLONG ( CMA_FLWINDOWATTR ) );
             
            WinUpdateWindow ( hwndC );
             
         break;
          
         case MID_MAIN_STATS: 
             
            /*WinSendMsg ( hwndC, CM_QUERYCNRINFO,
                         MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );*/
             
            if ( SHORT1FROMMP ( mp2 ) ) 
            {
               /*cnrinf.flWindowAttr |= CA_CONTAINERTITLE;
               cnrinf.flWindowAttr |= CA_TITLESEPARATOR | CA_TITLEREADONLY;*/
                
               ulTreeOpts |= SCB_STATED;
                
               WinShowWindow ( hwndS, TRUE );
            }
            else 
            {
               //cnrinf.flWindowAttr &= ~CA_CONTAINERTITLE;
                
               ulTreeOpts &= ~SCB_STATED;
                
               WinShowWindow ( hwndS, FALSE );
            }
             
            /*WinSendMsg ( hwndC, CM_SETCNRINFO, &cnrinf,
                         MPFROMLONG ( CMA_FLWINDOWATTR ) );*/
             
            pRecFoc = WinSendMsg ( hwndC, CM_QUERYRECORDEMPHASIS,
                                   MPFROMLONG ( CMA_FIRST ),
                                   MPFROMSHORT( CRA_SELECTED ) );
             
            pfnTreeStat ( pRecFoc );
             
            /*WinSendMsg ( pRecScn->pdr->hwndE, CM_SETCNRINFO, &cnrinf,
                         MPFROMLONG ( CMA_CNRTITLE ) );
             
            WinUpdateWindow ( hwndC );*/
             
         break;
          
         case MID_MAIN_MENU:  
         {
            if ( SHORT1FROMMP ( mp2 ) ) 
            {
               WinSetParent ( hwndTreeMenu, hwndFrame, FALSE );
                
               WinPostMsg ( hwndFrame, WM_UPDATEFRAME, (MPARAM) FCF_MENU, 0 );
                
               ulTreeOpts |= SCB_MENUED;
            }
            else 
            {
               WinSetParent ( hwndTreeMenu, HWND_OBJECT, FALSE );
                
               WinPostMsg ( hwndFrame, WM_UPDATEFRAME, (MPARAM) FCF_MENU, 0 );
                
               ulTreeOpts &= ~SCB_MENUED;
            }
         }
         break;
          
         case MID_MAIN_WINOWN:
             
            if ( SHORT1FROMMP ( mp2 ) ) 
            {
               hwndOwn = hwndC;
                
               ulTreeOpts |= SCB_WINOWN;
            }
            else 
            {
               hwndOwn = HWND_DESKTOP;
                
               ulTreeOpts &= ~SCB_WINOWN;
            }
             
            pfnTreeScan ( pRec, SCB_TREE, SCB_SETPAR, 0 );
             
         break;
          
         case MID_TREE_TITFILE:
             
            if ( SHORT1FROMMP ( mp2 ) )
               ulTreeOpts |= SCB_TITFILE;
            else
               ulTreeOpts &= ~SCB_TITFILE;
             
            pfnFrameTitle ( WinQueryWindow ( hwnd, QW_PARENT ), "PM Scrapbook", " " );
             
         break;

         case MID_TREE_WINTASK:
             
            if ( SHORT1FROMMP ( mp2 ) )
               ulTreeOpts |= SCB_WINTASK;
            else
               ulTreeOpts &= ~SCB_WINTASK;
             
         break;

         case MID_MAIN_DROPREFR:
             
            if ( SHORT1FROMMP ( mp2 ) )
               ulTreeOpts |= SCB_DROPREFR;
            else
               ulTreeOpts &= ~SCB_DROPREFR;
             
         break;
         }
      }
      break;
       
      case WID_ADDR:   
          
         switch ( SHORT2FROMMP ( mp1 ) ) 
         {
         case MID_ADDR_STATS:  
             
            if ( ulAddrOpts & SCB_STATED ) 
               ulAddrOpts &= ~SCB_STATED;
            else
               ulAddrOpts |= SCB_STATED;
             
            pfnTreeScan ( pRec, SCB_TREE, SCB_STAT, mp1 );
             
         break;
          
         case MID_ADDR_MENU:   
             
            if ( ulAddrOpts & SCB_MENUED ) 
               ulAddrOpts &= ~SCB_MENUED;
            else
               ulAddrOpts |= SCB_MENUED;
             
            pfnTreeScan ( pRec, SCB_TREE, SCB_MENU, mp1 );
             
         break;
          
         case DIT_ADDR_ENTER_DIAL:
             
            if ( ulAddrOpts & SCB_ENTDIAL )
               ulAddrOpts &= ~SCB_ENTDIAL;
            else
               ulAddrOpts |= SCB_ENTDIAL;
             
         break;
         }
          
      break;
       
      case WID_TODO:   
          
         switch ( SHORT2FROMMP ( mp1 ) ) 
         {
         case MID_TODO_STATS:  
             
            if ( ulToDoOpts & SCB_STATED )
               ulToDoOpts &= ~SCB_STATED;
            else 
               ulToDoOpts |= SCB_STATED;
             
            pfnTreeScan ( pRec, SCB_TREE, SCB_STAT, mp1 );
             
         break;
          
         case MID_TODO_MENU:   
             
            if ( ulToDoOpts & SCB_MENUED ) 
               ulToDoOpts &= ~SCB_MENUED;
            else
               ulToDoOpts |= SCB_MENUED;
             
            pfnTreeScan ( pRec, SCB_TREE, SCB_MENU, mp1 );
             
         break;
          
         case MID_TODO_PRICOLR:
             
            if ( ulToDoOpts & SCB_PRICOLR ) 
               ulToDoOpts &= ~SCB_PRICOLR;
            else 
               ulToDoOpts |= SCB_PRICOLR;
             
            pfnTreeScan ( pRec, SCB_TREE, SCB_PRICOL, mp1 );
             
         break;
         }
          
      break;
       
      case WID_MINI:
          
         switch ( SHORT2FROMMP ( mp1 ) ) 
         {
         case MID_MINI_STATS:
             
            if ( ulMiniOpts & SCB_STATED )
               ulMiniOpts &= ~SCB_STATED;
            else 
               ulMiniOpts |= SCB_STATED;
             
            pfnTreeScan ( pRec, SCB_TREE, SCB_STAT, mp1 );
             
         break;
          
         case MID_MINI_MENU:
             
            if ( ulMiniOpts & SCB_MENUED )
               ulMiniOpts &= ~SCB_MENUED;
            else
               ulMiniOpts |= SCB_MENUED;
             
            pfnTreeScan ( pRec, SCB_TREE, SCB_MENU, mp1 );
             
         break;
         }
          
      break;
       
      case WID_TEXT:
          
         switch ( SHORT2FROMMP ( mp1 ) ) 
         {
         case MID_TEXT_WRAP:
             
            if ( ulTextOpts & SCB_TXTWRAP )
               ulTextOpts &= ~SCB_TXTWRAP;
            else
               ulTextOpts |= SCB_TXTWRAP;
             
         break;
         }
      break;
       
      case WID_REFR:
          
         switch ( SHORT2FROMMP ( mp1 ) ) 
         {
         case DIT_REFR_DEFICO:
             
            if ( ulRefrOpts & SCB_REFR_DEFICON )
               ulRefrOpts &= ~SCB_REFR_DEFICON;
            else
               ulRefrOpts |= SCB_REFR_DEFICON;
             
         break;
         }
      break;
       
      case WID_PRNT:
          
         switch ( SHORT2FROMMP ( mp1 ) ) 
         {
            case DIT_PRTHEAD:
             
               if ( ulTreeOpts & SCB_PRTHEAD )
                  ulTreeOpts &= ~SCB_PRTHEAD;
               else
                  ulTreeOpts |= SCB_PRTHEAD;
             
            break;
            case DIT_PRTPAGE:
             
               if ( ulTreeOpts & SCB_PRTPAGE )
                  ulTreeOpts &= ~SCB_PRTPAGE;
               else
                  ulTreeOpts |= SCB_PRTPAGE;
             
            break;
         }
      break;
      }
   }
   break;
    
   default:
   return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
    
   }
    
   return ( MRESULT ) FALSE;
}
 
/***************************************************************************/
/* Stat Dialog                                                             */
/***************************************************************************/
MRESULT EXPENTRY pfndpStats      ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   PUSEREC  pRecTmp;
   CHAR     ach32[33];
    
   switch ( msg ) 
   {
   case WM_INITDLG:
       
      //sprintf ( achBuf256, "Version %s", achVersion );
       
      //WinSetWindowText ( WinWindowFromID ( hwnd, ID_EDIT ), achBuf256 );
       
   break;
    
   case UWM_PARAMS:
       
      pRecTmp = PVOIDFROMMP ( mp1 );
       
      if ( pRecTmp && pRecTmp->pdr ) 
      {
         sprintf ( ach32, "%u", pRecTmp->pdr->ulDLen );
          
         WinSetWindowText ( WinWindowFromID ( hwnd, DIT_SIZE ), ach32 );
          
         sprintf ( ach32, "%u", pRecTmp->pdr->ulDEnt );
          
         WinSetWindowText ( WinWindowFromID ( hwnd, DIT_ENTRIES ), ach32 );
          
         sprintf ( ach32, "%02u/%02u/%02u  %02u:%02u:%02u",
                          pRecTmp->cdCre.year%1900, pRecTmp->cdCre.month, pRecTmp->cdCre.day, pRecTmp->ctCre.hours, pRecTmp->ctCre.minutes, pRecTmp->ctCre.seconds );
          
         WinSetWindowText ( WinWindowFromID ( hwnd, DIT_CREATE ), ach32 );
          
         sprintf ( ach32, "%02u/%02u/%02u  %02u:%02u:%02u",
                          pRecTmp->cdWri.year%1900, pRecTmp->cdWri.month, pRecTmp->cdWri.day, pRecTmp->ctWri.hours, pRecTmp->ctWri.minutes, pRecTmp->ctWri.seconds );
          
         WinSetWindowText ( WinWindowFromID ( hwnd, DIT_WRITE ), ach32 );
          
         sprintf ( ach32, "%02u/%02u/%02u  %02u:%02u:%02u",
                          pRecTmp->cdAcc.year%1900, pRecTmp->cdAcc.month, pRecTmp->cdAcc.day, pRecTmp->ctAcc.hours, pRecTmp->ctAcc.minutes, pRecTmp->ctAcc.seconds );
          
         WinSetWindowText ( WinWindowFromID ( hwnd, DIT_ACCESS ), ach32 );
      }
       
   break;
    
   case WM_COMMAND:
       
      switch ( SHORT1FROMMP ( mp1 ) ) 
      {
            case DIT_HELP:
            {
               SHORT   sId;
      
               sId = WinQueryWindowUShort ( hwnd, QWS_ID );
      
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
             
      case DIT_OK:
             
         WinDismissDlg ( hwnd, TRUE );
             
      break;
      }
   break;
    
   default:
   return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
   }
   return ( MRESULT ) FALSE;
}
 
/***************************************************************************/
/* Tree Search Dialog                                                      */
/***************************************************************************/
MRESULT EXPENTRY pfndpTreeSearch ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   switch ( msg ) 
   {
   case WM_INITDLG:
   {
      HWND         hwndT;
      CNRINFO      cnrinf;

      //*** Set Container Attrs ******************************************
       
      hwndT = WinWindowFromID ( hwnd, DIT_FOUND );
       
      cnrinf.flWindowAttr = CV_NAME;
       
      WinSendMsg ( hwndT, CM_SETCNRINFO, &cnrinf,
                   MPFROMLONG ( CMA_FLWINDOWATTR ) );
       
      //*** Set Fields ***************************************************
       
      WinSetDlgItemText ( hwnd, DIT_SEARCH, pszSearch );
       
      WinCheckButton ( hwnd, DIT_SEARCH_CASE, ( ulTreeOpts & SCB_CASE )    ? TRUE : FALSE );
      WinCheckButton ( hwnd, DIT_SEARCH_ALL,  ( ulTreeOpts & SCB_SRCHALL ) ? TRUE : FALSE );
       
      WinSendDlgItemMsg  ( hwnd, DIT_SEARCH, EM_SETSEL, 
                           MPFROM2SHORT ( 0, strlen ( pszSearch ) ), NULL );
       
      WinSetFocus ( HWND_DESKTOP, WinWindowFromID ( hwnd, DIT_SEARCH ) );
   }
   return (MRESULT) TRUE;
    
   case WM_COMMAND:
       
      switch ( COMMANDMSG(&msg)->cmd ) 
      {
         case DIT_HELP:
         {
            SHORT   sId;
   
            sId = WinQueryWindowUShort ( hwnd, QWS_ID );
   
            WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                         MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
         }
         break;
          
         case DID_CANCEL:
             
            WinDismissDlg ( hwnd, FALSE );
             
         break;
          
         case DIT_OK:
         {
            ULONG  ulLen;
            HWND   hwndT;

            //*** Get Fields *********************************************
             
            ulLen = WinQueryDlgItemTextLength ( hwnd, DIT_SEARCH );
             
            ++ulLen;
             
            pszSearch = realloc ( pszSearch, ulLen );
             
            WinQueryDlgItemText ( hwnd, DIT_SEARCH, ulLen, pszSearch );
             
            if ( WinQueryButtonCheckstate ( hwnd, DIT_SEARCH_CASE ) ) 
               ulTreeOpts |= SCB_CASE;
            else
               ulTreeOpts &= ~SCB_CASE;
             
            if ( WinQueryButtonCheckstate ( hwnd, DIT_SEARCH_ALL ) )
               ulTreeOpts |= SCB_SRCHALL;
            else
               ulTreeOpts &= ~SCB_SRCHALL;
             
            //WinDlgBox ( HWND_DESKTOP, hwnd, pfndpTreeFound, 0L, DLG_TREE_FOUND, NULL );
            //*** Fill Container ***********************************************
             
            hwndT = WinWindowFromID ( hwnd, DIT_FOUND );

            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_OK     ), FALSE );
            WinEnableWindow ( WinWindowFromID ( hwnd, DID_CANCEL ), FALSE );
            pfnCanCloseWin ( hwnd, TRUE, FALSE );
            pfnWaitPtr ( TRUE );

            pszSearchFound = FALSE;

            if ( ulTreeOpts & SCB_SRCHALL )
               pfnTreeScan ( pRec,    SCB_BRANCH, SCB_SEARCH, MPFROMHWND ( hwndT ) );
            else
               pfnTreeScan ( pRecFoc, SCB_BRANCH, SCB_SEARCH, MPFROMHWND ( hwndT ) );
            //pfnTreeScan ( pRecFoc, SCB_TREE, SCB_SEARCH, MPFROMHWND ( hwndT ) );

            pfnWaitPtr ( FALSE );
            pfnCanCloseWin ( hwnd, TRUE, TRUE );
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_OK     ), TRUE  );
            WinEnableWindow ( WinWindowFromID ( hwnd, DID_CANCEL ), TRUE  );

            if ( ! pszSearchFound )
            {
               pfnMsgOK ( hwnd, APP_TITLE, "Text not found." );
            }
         }
         break;
      }
   break;
    
   case WM_CONTROL:
       
      if ( SHORT1FROMMP ( mp1 ) == DIT_FOUND )
      {
         switch ( SHORT2FROMMP ( mp1 ) ) 
         {
            case CN_ENTER:
            {
               PFINDREC     pRecFnd;
               PNOTIFYRECORDENTER    pcnrEnt;

               pcnrEnt = PVOIDFROMMP ( mp2 );
                   
               pRecFnd = (PFINDREC) pcnrEnt->pRecord;
                   
               if ( ! pRecFnd )
                  break;
                   
               WinPostMsg ( hwndM, UWM_DETWIN, MPFROMP ( pRecFnd->prec ), NULL );
            }
            return ( MRESULT ) TRUE;
         }
         //break;
      }
   break;
   default:
   return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
   }
    
     return FALSE;
}
 
/***************************************************************************/
/* Allocate Record                                                         */
/***************************************************************************/
PUSEREC          pfnAllocRec     ( PUSEREC pRecPar, ULONG ulType, ULONG ulReal, BOOL fbInsert, BOOL fbInit ) 
{
   PUSEREC       pRecNew;
   RECORDINSERT  recins;
   ULONG         ulSize;
   BOOL          fb;
   DEFAULTREC    defRec;
   PSZ           pszKey;
   ERRORID       lastError;
    
lastError = WinGetLastError ( WinQueryAnchorBlock ( hwndFrame ) );

   pRecNew = WinSendMsg ( hwndC, CM_ALLOCRECORD,
                          MPFROMLONG (sizeof(USEREC)-sizeof(RECORDCORE)),
                          MPFROMSHORT( 1 ) );

lastError = WinGetLastError ( WinQueryAnchorBlock ( hwndFrame ) );


   pRecNew->ulType = ulType;
   pRecNew->ulKids = 0;

   if ( ulType == WID_BOOK || ulType == WID_SECT || 
        ulType == WID_CHAP || ulType == WID_PAGE )
   {
      ulType = WID_TEXT;
      ulReal = WID_TEXT;
   }

   pRecNew->ulReal = /*( ulReal ) ? ulReal : */ulType;
    
   if ( ulType != WID_REFR )
      pRecNew->crecCore.hptrIcon = pfnWhichIcon ( pRecNew );
   else
      pRecNew->crecCore.hptrIcon = 0;
    
   pRecNew->crecCore.flRecordAttr = CRA_DROPONABLE;
    
   pRecNew->pdr = malloc ( sizeof (DATREC ) );
    
   memset ( pRecNew->pdr, 0, sizeof ( DATREC ) );
    
   //*** Init ***************************************************************
    
   if ( fbInit ) 
   {
      pRecNew->pdr->ulRelRev = REL_REV;
   
      pfnSetWhen ( &pRecNew->cdCre, &pRecNew->ctCre );
      //pfnSetWhen ( &pRecNew->cdWri, &pRecNew->ctWri );
      //pfnSetWhen ( &pRecNew->cdAcc, &pRecNew->ctAcc );
       
      //pRecNew->crecCore.pszTree  = malloc ( 9 );
       
      //sprintf ( pRecNew->crecCore.pszTree, "#%d", ulCnt++ );
       
      pRecNew->crecCore.pszTree  = strdup ( DEF_ENT_NAME );
       
      switch ( ulType )
      {
         case WID_TREE:
            pszKey = TREE_KEY;
         break;
         case WID_ADDR:
            pszKey = ADDR_KEY;
         break;
         case WID_TODO:
            pszKey = TODO_KEY;
         break;
         case WID_MINI:
            pszKey = MINI_KEY;
         break;
         case WID_TEXT:
            pszKey = TEXT_KEY;
         break;
         case WID_REFR:
            pszKey = REFR_KEY;
         break;
      }

      if ( ulType != WID_REFR )
      {
          ulSize = sizeof ( DEFAULTREC );
           
          fb = PrfQueryProfileData ( HINI_USERPROFILE, PRG_TITLE, pszKey,
                                     &defRec, &ulSize );
    
          if ( fb )
          {
             pRecNew->pdr->fat    = defRec.fat;
             pRecNew->pdr->fxPtSz = defRec.fxPtSz;
              
             pRecNew->pdr->ulNBClr = defRec.ulNBClr;
             pRecNew->pdr->ulNFClr = defRec.ulNFClr;
             pRecNew->pdr->ulHBClr = defRec.ulHBClr;
             pRecNew->pdr->ulHFClr = defRec.ulHFClr;
          }
          else
          {
             pfnGetDefFattrs ( WinQueryWindow ( hwndM, QW_PARENT ), NULLHANDLE, 
                               &pRecNew->pdr->fat, &pRecNew->pdr->fxPtSz );
              
             pRecNew->pdr->ulNBClr = CLR_BACKGROUND;
             pRecNew->pdr->ulNFClr = CLR_NEUTRAL;
             pRecNew->pdr->ulHBClr = CLR_DARKGRAY;
             pRecNew->pdr->ulHFClr = CLR_BACKGROUND;
          }
      }
   }
    
   //*** Insert *************************************************************
    
   if ( fbInsert ) 
   {
      recins.cb                = sizeof ( RECORDINSERT );
      recins.pRecordParent     = (PRECORDCORE) pRecPar;
      recins.pRecordOrder      = (PRECORDCORE) CMA_END;
      recins.zOrder            = CMA_TOP;
      recins.cRecordsInsert    = 1;
      recins.fInvalidateRecord = TRUE;
       
      WinSendMsg ( hwndC, CM_INSERTRECORD,
                   MPFROMP( pRecNew ), MPFROMP ( &recins ) );
       
      WinSendMsg ( hwndC, CM_EXPANDTREE,
                   MPFROMP( pRecPar ), NULL );
   }
    
   return pRecNew;
}
 
/***************************************************************************/
/* Set the Icon                                                            */
/***************************************************************************/
HPOINTER         pfnWhichIcon    ( PUSEREC pRecScn )
{
   ULONG    ulType;
   HPOINTER hptrIcon = 0;
    
   ulType = pRecScn->ulType;

   switch ( ulType ) 
   {
   case WID_BOOK:
   case WID_CHAP:
   case WID_SECT:
   case WID_PAGE:
   case WID_TEXT:
       
      hptrIcon = hptrText;
       
   break;
    
   case WID_LIST:
       
      hptrIcon = hptrMini;
       
   break;
    
   case WID_ADDR:
       
      hptrIcon = hptrAddr;
       
   break;
    
   case WID_TODO:
       
      hptrIcon = hptrToDo;
       
   break;
    
   case WID_MINI:
       
      hptrIcon = hptrMini;
       
   break;
    
   case WID_REFR:
   {
      if ( pRecScn->pdr->pvDat )
      {
         if ( pfnRefrIcon ( pRecScn ) )
            hptrIcon = pRecScn->crecCore.hptrIcon;
         else
            hptrIcon = hptrRefr;
      }
   }
   break;
    
   default:
   {
      hptrIcon = hptr;
   }
   break;
       
   }
    
   return hptrIcon;
    
}
 
/***************************************************************************/
/* Read from a Buffer                                                      */
/***************************************************************************/
BOOL             pfnReadBufr     ( HWND hwnd, PBYTE pbMem, PUSEREC pRecPar, PUSEREC pRecAft ) 
{
   BOOL         fbFirst = TRUE;
   TREEIO       treeio;
   DATAIO       dataio;
   PUSEREC      pRecTmp;
   PDATREC      pdr;
   PUSEREC     *pParStack = NULL;
   RECORDINSERT recins;
   HWND         hwndEnt;
    
   //WinEnableWindowUpdate ( hwndC, FALSE );
    
   //*** Read  Data *********************************************************
    
   memcpy ( &treeio, pbMem, sizeof ( TREEIO ) );
    
   while ( treeio.lLvl != SCB_BRANCH ) 
   {
      //*** Alloc Record & Read *********************************************
       
      pRecTmp = pfnAllocRec ( pRec, treeio.ulType, treeio.ulReal, FALSE, FALSE );
       
      pRecTmp->ulOpts = treeio.ulOpts;
      pRecTmp->ulReal = treeio.ulReal;
      pRecTmp->cdCre  = treeio.cdCre;
      pRecTmp->ctCre  = treeio.ctCre;
      pRecTmp->cdWri  = treeio.cdWri;
      pRecTmp->ctWri  = treeio.ctWri;
      pRecTmp->cdAcc  = treeio.cdAcc;
      pRecTmp->ctAcc  = treeio.ctAcc;
       
      pbMem += sizeof ( TREEIO );
       
      pRecTmp->crecCore.pszTree  = malloc ( treeio.ulNLen );
      memcpy ( pRecTmp->crecCore.pszTree, pbMem, treeio.ulNLen );
      pbMem += treeio.ulNLen;
       
      //*** Detail **********************************************************
       
      pdr = pRecTmp->pdr;
       
      pdr->ulDLen = treeio.ulDLen;
       
      memcpy ( &dataio, pbMem, sizeof ( DATAIO ) );
       
      pdr->swp       = dataio.swp;
      pdr->fat       = dataio.fat;
      pdr->fxPtSz    = dataio.fxPtSz;
      pdr->fatPrt    = dataio.fatPrt;
      pdr->fxPtSzPrt = dataio.fxPtSzPrt;
      pdr->ulRelRev  = dataio.ulRelRev;
      pdr->ulOpts    = dataio.ulOpts;
      pdr->ulStyl    = dataio.ulStyl;
      pdr->ulDEnt    = dataio.ulDEnt;
      pdr->ulXVS     = dataio.ulXVS;
      pdr->ulNBClr   = dataio.ulNBClr;
      pdr->ulNFClr   = dataio.ulNFClr;
      pdr->ulHBClr   = dataio.ulHBClr;
      pdr->ulHFClr   = dataio.ulHFClr;
      pdr->pvDat     = 0;
          
         pbMem += sizeof ( DATAIO );
          
      if ( pdr->ulDLen ) 
      {
         pdr->pvDat = malloc ( pdr->ulDLen );
         memcpy ( pdr->pvDat, pbMem, pdr->ulDLen );
         pbMem += pdr->ulDLen;
      }
       
      //*** First ? *********************************************************
       
      if ( fbFirst ) 
         pParStack = malloc ( sizeof ( PUSEREC ) );
       
      //*** Parent ? ********************************************************
       
      if ( pRecTmp->ulOpts & SCB_PARENT ) 
      {
         pParStack = realloc ( pParStack, (treeio.lLvl+1) * sizeof(PUSEREC) );
          
         pParStack[treeio.lLvl] = pRecTmp;
      }
       
      //*** Child ? *********************************************************
       
      if ( ! fbFirst )
         pRecPar = ( treeio.lLvl ) ? pParStack[+treeio.lLvl-1] : NULL;
       
      //*** Reference ? *****************************************************
       
      if ( pRecTmp->ulType == WID_REFR )
         pfnRefrIcon ( pRecTmp );
       
      //*** Insert **********************************************************
       
      if ( fbFirst ) 
         fbFirst = FALSE;
      else
         pRecAft = (PUSEREC) CMA_END;
       
      recins.cb                = sizeof ( RECORDINSERT );
      recins.pRecordParent     = (PRECORDCORE) pRecPar;
      recins.pRecordOrder      = (PRECORDCORE) pRecAft;
      recins.zOrder            = CMA_TOP;
      recins.cRecordsInsert    = 1;
      recins.fInvalidateRecord = TRUE;
       
      WinSendMsg ( hwnd, CM_INSERTRECORD,
                   MPFROMP( pRecTmp ), MPFROMP ( &recins ) );
       
      //*** Expand ? ********************************************************
       
      /*if ( pRecTmp->ulOpts & SCB_EXPAND )
         WinSendMsg ( hwnd, CM_EXPANDTREE, MPFROMP( pRecTmp ), NULL );*/
       
      //*** Open ? **********************************************************
       
      if ( pRecTmp->pdr->ulOpts & SCB_OPENED )
      {
         if ( treeio.hwndSource == hwndC )
         {
            LONG editor;
            if ( hwndEnt = pfnEntryOpen ( pRecTmp, &editor ) )
            {
               WinPostMsg ( hwndEnt, UWM_SETRECPTR, MPFROMP( pRecTmp ), NULL );
            //if ( pdr->hwndE && editor | 2 )
               WinPostMsg ( /*pdr->*/hwndEnt, UWM_SETRECPTR, MPFROMP( pRecTmp ), NULL );
            }
            WinSendMsg ( hwndC, CM_SETRECORDEMPHASIS,
                         MPFROMP ( pRecTmp ),
                         MPFROM2SHORT ( FALSE, CRA_INUSE ) );
         }
         else
            pRecTmp->pdr->ulOpts &= ~SCB_OPENED;
      }
       
      //*** ???? ? **********************************************************
       
      memcpy ( &treeio, pbMem, sizeof ( TREEIO ) );
   }
    
   //WinEnableWindowUpdate ( hwndC, TRUE );
    
   if ( pParStack )
      free ( pParStack );
    
   return TRUE;
}
 
/***************************************************************************/
/* See if look for is parent/grandparent                                   */
/***************************************************************************/
BOOL             pfnIsAncestor   ( HWND hwnd, PUSEREC startAt, PUSEREC lookFor)
{
   PUSEREC pRecTmp;
   pRecTmp = WinSendMsg ( hwnd, CM_QUERYRECORD,
                          MPFROMP ( startAt ),
                          MPFROM2SHORT ( CMA_PARENT, CMA_ITEMORDER ) );
    
   while ( pRecTmp ) 
   {
      if ( pRecTmp == lookFor )
         return TRUE;

      pRecTmp = WinSendMsg ( hwnd, CM_QUERYRECORD,
                             MPFROMP ( pRecTmp ),
                             MPFROM2SHORT ( CMA_PARENT, CMA_ITEMORDER ) );
   }

   return FALSE;
}
/***************************************************************************/
/* Is Entry Open ?                                                         */
/***************************************************************************/
HWND             pfnEntryOpen    ( PUSEREC pRecScn, PLONG plFlags )
{
   if ( plFlags )
      *plFlags = 0;

   if ( pRecScn->ulType != WID_REFR )//&& pRecScn->pdr->hwndD )
   {
      if ( pRecScn->pdr->hwndE )
         if ( plFlags )
            *plFlags |= 0x00000001;

      return pRecScn->pdr->hwndD;
   }

   if ( plFlags )
      *plFlags |= 0x00000002;

   return pRecScn->pdr->hwndE;
 
         //pdr->hwndE = hwnd;//WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU );
}

/***************************************************************************/
/* Scan the Tree and ...                                                   */
/***************************************************************************/
VOID             pfnTreeScan     ( PUSEREC pRecScn, LONG lLvl, LONG lFunc, MPARAM mp )
{
   ULONG    ul;
   ULONG    ulBytesWrit;
   LONG     lType;
    
   PDATREC  pdr;
    
   HFILE    hfil;
   PULONG   pulSize;
   PBYTE    *pbMem;
    
   HWND     hwndT;
   HWND     hwndEnt;
    
   //ULONG    ulRet;

   /* Container Stuff */
    
   CNRINFO      cnrinf;
   RECORDINSERT recins;
   PUSEREC      pRecTmp;
   PFINDREC     pRecFnd;
   TREEIO       treeio;
   DATAIO       dataio;
    
   /* Debug */
/*   
   PSZ      psz;
   CHAR     ach80[81];

   psz = &ach80[0];
    
   sprintf ( psz, "%d %s", lLvl, pRecScn->crecCore.pszTree );*/
    
   //ulRet = 0;

   pRecTmp = WinSendMsg ( hwndC, CM_QUERYRECORD,
                          MPFROMP ( pRecScn ),
                          MPFROM2SHORT ( CMA_FIRSTCHILD, CMA_ITEMORDER ) );

   if ( (LONG) pRecTmp == -1 )
      pRecTmp = NULL;

   switch ( lFunc ) 
   {
       
   case SCB_WRITE:   //*****************************************************
       
      hfil = (HFILE) mp;
       
      if ( hwndEnt = pfnEntryOpen ( pRecScn, 0 ) )
         WinSendMsg ( hwndEnt, UWM_SAVE, NULL, NULL );
       
      //*** Parent Flag, Level, Type & Options *****************************
       
      DosWrite ( hfil, &lLvl,            sizeof ( lLvl ),  &ulBytesWrit );
      DosWrite ( hfil, &pRecScn->ulType, sizeof ( ULONG ), &ulBytesWrit );
       
      ul = pRecScn->ulOpts;
       
      if ( pRecTmp ) 
         ul |= SCB_PARENT;
      else
         ul&= ~SCB_PARENT;
       
      if ( pRecScn->crecCore.flRecordAttr & CRA_EXPANDED )
         ul |= SCB_EXPAND;
      else
         ul &= ~SCB_EXPAND;
       
      DosWrite ( hfil, &ul,              sizeof ( ul ),    &ulBytesWrit );
    //DosWrite ( hfil, &pRecScn->ulOpts, sizeof ( ULONG ), &ulBytesWrit );
      DosWrite ( hfil, &pRecScn->ulReal, sizeof ( ULONG ), &ulBytesWrit );
       
      /* Dates */
       
      DosWrite ( hfil, &pRecScn->cdCre, sizeof ( CDATE ), &ulBytesWrit );
      DosWrite ( hfil, &pRecScn->ctCre, sizeof ( CTIME ), &ulBytesWrit );
      DosWrite ( hfil, &pRecScn->cdWri, sizeof ( CDATE ), &ulBytesWrit );
      DosWrite ( hfil, &pRecScn->ctWri, sizeof ( CTIME ), &ulBytesWrit );
      DosWrite ( hfil, &pRecScn->cdAcc, sizeof ( CDATE ), &ulBytesWrit );
      DosWrite ( hfil, &pRecScn->ctAcc, sizeof ( CTIME ), &ulBytesWrit );
       
      /* Name */
       
      ul = strlen ( pRecScn->crecCore.pszTree );
       
      ++ul;
       
      DosWrite ( hfil, &ul,                       sizeof ( ul ), &ulBytesWrit );
      DosWrite ( hfil, pRecScn->crecCore.pszTree, ul,            &ulBytesWrit );
       
      /* Detail */
       
      pdr = pRecScn->pdr;
       
      DosWrite ( hfil, &pdr->ulDLen, sizeof ( ULONG ), &ulBytesWrit );
       
      if ( pdr->ulDLen ) 
      {
         DosWrite ( hfil, &pdr->ulDEnt,   sizeof ( ULONG ),  &ulBytesWrit );
         DosWrite ( hfil, &pdr->ulRelRev, sizeof ( ULONG ),  &ulBytesWrit );
         DosWrite ( hfil, pdr->pvDat,     pdr->ulDLen,       &ulBytesWrit );
         DosWrite ( hfil, &pdr->ulOpts,   sizeof ( ULONG ),  &ulBytesWrit );
         DosWrite ( hfil, &pdr->ulStyl,   sizeof ( ULONG ),  &ulBytesWrit );
         DosWrite ( hfil, &pdr->swp,      sizeof ( SWP ),    &ulBytesWrit );
         DosWrite ( hfil, &pdr->fat,      sizeof ( FATTRS ), &ulBytesWrit );
         //DosWrite ( hfil, &pdr->sPtSize,  sizeof ( SHORT ),  &ulBytesWrit );
         DosWrite ( hfil, &pdr->fxPtSz,   sizeof ( FIXED ),  &ulBytesWrit );
         DosWrite ( hfil, &pdr->ulXVS,    sizeof ( ULONG ),  &ulBytesWrit );
         DosWrite ( hfil, &pdr->ulNBClr,  sizeof ( ULONG ),  &ulBytesWrit );
         DosWrite ( hfil, &pdr->ulNFClr,  sizeof ( ULONG ),  &ulBytesWrit );
         DosWrite ( hfil, &pdr->ulHBClr,  sizeof ( ULONG ),  &ulBytesWrit );
         DosWrite ( hfil, &pdr->ulHFClr,  sizeof ( ULONG ),  &ulBytesWrit );
         DosWrite ( hfil, &pdr->fatPrt,   sizeof ( FATTRS ), &ulBytesWrit );
         DosWrite ( hfil, &pdr->fxPtSzPrt,sizeof ( FIXED ),  &ulBytesWrit );
      }
   break;
    
   case SCB_SIZE:   //*******************************************************
       
      pulSize = PVOIDFROMMP ( mp );
       
      *pulSize += ( sizeof ( TREEIO ) +
                    strlen ( pRecScn->crecCore.pszTree ) + 1 );
       
      //if ( pRecScn->pdr->ulDLen )
         *pulSize += ( sizeof ( DATAIO ) + pRecScn->pdr->ulDLen );
       
   break;
    
   case SCB_MEMORY:   //*****************************************************
       
      pbMem = PVOIDFROMMP ( mp );
       
      //*** Tree IO ***************************************
       
      treeio.hwndSource = hwndC;

      treeio.lLvl   = lLvl + 1;
      treeio.ulType = pRecScn->ulType;
      treeio.ulReal = pRecScn->ulReal;
      treeio.ulOpts = pRecScn->ulOpts;
       
      if ( pRecTmp )
         treeio.ulOpts |= SCB_PARENT;
      else
         treeio.ulOpts &= ~SCB_PARENT;
       
      if ( pRecScn->crecCore.flRecordAttr & CRA_EXPANDED )
         treeio.ulOpts |= SCB_EXPAND;
      else
         treeio.ulOpts &= ~SCB_EXPAND;
       
      treeio.cdCre = pRecScn->cdCre;
      treeio.ctCre = pRecScn->ctCre;
      treeio.cdWri = pRecScn->cdWri;
      treeio.ctWri = pRecScn->ctWri;
      treeio.cdAcc = pRecScn->cdAcc;
      treeio.ctAcc = pRecScn->ctAcc;
       
      treeio.ulNLen = strlen ( pRecScn->crecCore.pszTree ) + 1;
      treeio.ulDLen = pRecScn->pdr->ulDLen;
       
      memcpy ( *pbMem, &treeio, sizeof ( TREEIO ) );
      *pbMem += sizeof ( TREEIO );
       
      memcpy ( (PVOID)*pbMem, pRecScn->crecCore.pszTree, treeio.ulNLen );
      *pbMem += treeio.ulNLen;
       
      //*** Data ********************************************************
       
      pdr = pRecScn->pdr;
       
      if ( pdr->ulDLen ) 
      {
         LONG editor;

         dataio.hwndD     = pfnEntryOpen ( pRecScn, &editor );
         dataio.hwndE     = ( editor | 2 ) ? pdr->hwndE : 0;   // ???
         dataio.swp       = pdr->swp;
         dataio.fat       = pdr->fat;
         dataio.fxPtSz    = pdr->fxPtSz;
         dataio.fatPrt    = pdr->fatPrt;
         dataio.fxPtSzPrt = pdr->fxPtSzPrt;
         dataio.ulRelRev  = pdr->ulRelRev;
         dataio.ulOpts    = pdr->ulOpts;
         dataio.ulStyl    = pdr->ulStyl;
         dataio.ulDEnt    = pdr->ulDEnt;
         dataio.ulXVS     = pdr->ulXVS;
         dataio.ulNBClr   = pdr->ulNBClr;
         dataio.ulNFClr   = pdr->ulNFClr;
         dataio.ulHBClr   = pdr->ulHBClr;
         dataio.ulHFClr   = pdr->ulHFClr;
          
         memcpy ( *pbMem, &dataio, sizeof ( DATAIO ) );
         *pbMem += sizeof ( DATAIO );
          
         memcpy ( *pbMem, pdr->pvDat, pdr->ulDLen );
         *pbMem += pdr->ulDLen;
      }
      else
      {
         /*ULONG      ulSize;
         DEFAULTREC defRec;

         ulSize = sizeof ( DEFAULTREC );
          
         PrfQueryProfileData ( HINI_USERPROFILE, PRG_TITLE, TEXT_KEY,
                               &defRec, &ulSize );*/
   
         /*pRecNew->pdr->fat    = defRec.fat;     from pfnAllocRec
         pRecNew->pdr->fxPtSz = defRec.fxPtSz;*/
          
         dataio.ulNBClr = CLR_BACKGROUND;
         dataio.ulNFClr = CLR_NEUTRAL;   
         dataio.ulHBClr = CLR_DARKGRAY;  
         dataio.ulHFClr = CLR_BACKGROUND;
         //dataio.swp       = pdr->swp;
         /*dataio.fat       = defRec.fat;
         dataio.fxPtSz    = defRec.fxPtSz;
         dataio.fatPrt    = defRec.fat;
         dataio.fxPtSzPrt = defRec.fxPtSz;
         dataio.ulRelRev  = ulRelRev;
         dataio.ulOpts    = defRec.ulOpts;
         dataio.ulStyl    = defRec.ulStyl;
         dataio.ulDEnt    = 0;
         dataio.ulXVS     = 0;//ulXVS;
         dataio.ulNBClr   = defRec.ulNBClr;
         dataio.ulNFClr   = defRec.ulNFClr;
         dataio.ulHBClr   = defRec.ulHBClr;
         dataio.ulHFClr   = defRec.ulHFClr;*/
          
         memcpy ( *pbMem, &dataio, sizeof ( DATAIO ) );
         *pbMem += sizeof ( DATAIO );
          
         /*memcpy ( *pbMem, pdr->pvDat, pdr->ulDLen );   ulDLen is zero here
         *pbMem += pdr->ulDLen;*/
      }
       
   break;
    
   case SCB_FREE:   //*******************************************************
       
      if ( pRecScn->pdr )
      {
         if ( hwndEnt = pfnEntryOpen ( pRecScn, 0 ) )
         {
            pfnHaveAKid ( pRecScn, FALSE );
            /*if ( pRecScn->ulType == WID_REFR )
               WinSendMsg ( hwndEnt, WM_CLOSE, NULL, NULL );
            else*/
            {
               WinEnableWindowUpdate ( pRecScn->pdr->hwndE, FALSE );
   
               pfnNodeScan  ( pRecScn->pdr->hwndE, SCB_FREE, 
                              pRecScn->ulType, pRecScn->pdr->pvDat );
   
               WinDestroyWindow ( hwndEnt );
            }
         }
       
         if ( pRecScn->pdr->pvDat )
            free ( pRecScn->pdr->pvDat );
       
         free ( pRecScn->pdr );
       
         pRecScn->pdr->pvDat = NULL;
       
         pRecScn->pdr = NULL;
      }
   break;
    
   case SCB_SETPAR:   //*****************************************************
       
      if ( hwndEnt = pfnEntryOpen ( pRecScn, 0 ) )
         WinSetParent ( hwndEnt, hwndOwn, TRUE );
       
   break;
    
   case SCB_SEARCH:   //*****************************************************
       
      if ( pfnNodeUtil ( pRecScn, SCB_SEARCH, 0L, NULL ) ) 
      {
         pszSearchFound = TRUE;

         hwndT = (ULONG) mp;
          
         //*** Allocate *****************************************************
          
         pRecFnd = WinSendMsg ( hwndT, CM_ALLOCRECORD,
                                MPFROMLONG (sizeof(FINDREC)-sizeof(MINIRECORDCORE)),
                                MPFROMSHORT( 1 ) );
          
         pRecFnd->crecCore.pszIcon  = strdup ( pRecScn->crecCore.pszTree );
         pRecFnd->crecCore.hptrIcon = pRecScn->crecCore.hptrIcon;
          
         pRecFnd->prec = pRecScn;
          
         //*** Insert *******************************************************
          
         recins.cb                = sizeof ( RECORDINSERT );
         recins.pRecordParent     = NULL;
         recins.pRecordOrder      = (PRECORDCORE) CMA_END;
         recins.zOrder            = CMA_TOP;
         recins.cRecordsInsert    = 1;
         recins.fInvalidateRecord = TRUE;
          
         WinSendMsg ( hwndT, CM_INSERTRECORD,
                      MPFROMP( pRecFnd ), MPFROMP ( &recins ) );
      }
   break;
    
   case SCB_REFRESH:   //****************************************************
       
      WinSendMsg ( hwndC, CM_INVALIDATERECORD,
                   MPFROMP ( &pRecScn ), MPFROM2SHORT ( 1, CMA_REPOSITION | CMA_TEXTCHANGED ) );
       
   break;
    
   case SCB_STAT:   //*******************************************************
   {
      LONG editor;

      if ( hwndEnt = pfnEntryOpen ( pRecScn, &editor ) )
      {
         if ( editor | 0x0000002 )
            break;

         lType = SHORT1FROMMP ( mp );
          
         if ( lType == (LONG) WinQueryWindowUShort ( hwndEnt, QWS_ID ) )
         {
            WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYCNRINFO,
                         MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
             
            if ( cnrinf.flWindowAttr & CA_CONTAINERTITLE ) 
            {
               cnrinf.flWindowAttr &= ~CA_CONTAINERTITLE;
            }
            else 
            {
               cnrinf.flWindowAttr |= CA_CONTAINERTITLE;
               cnrinf.flWindowAttr |= CA_TITLESEPARATOR | CA_TITLEREADONLY;
            }
             
            WinSendMsg ( pRecScn->pdr->hwndE, CM_SETCNRINFO, &cnrinf,
                         MPFROMLONG ( CMA_FLWINDOWATTR ) );
         }
      }
   }
   break;
    
   case SCB_MENU:   //*******************************************************
   {
      if ( hwndEnt = pfnEntryOpen ( pRecScn, 0 ) )
      {
         lType = SHORT1FROMMP ( mp );
          
         if ( lType == (LONG) WinQueryWindowUShort ( hwndEnt, QWS_ID ) )
         {
            if ( WinWindowFromID ( hwndEnt, FID_MENU ) )
            {
               //WinQueryWindow ( pRecScn->pdr->hwndM, QW_PARENT ) != HWND_OBJECT ) 
                
               WinSetParent ( pRecScn->pdr->hwndM, HWND_OBJECT, FALSE );
                
               WinSendMsg ( hwndEnt, WM_UPDATEFRAME,
                            (MPARAM) FCF_MENU, 0 );
            }
            else 
            {
               WinSetParent ( pRecScn->pdr->hwndM, hwndEnt, FALSE );
                
               WinSendMsg ( hwndEnt, WM_UPDATEFRAME,
                            (MPARAM) FCF_MENU, 0 );
            }
         }
      }
   }
   break;
    
   case SCB_CLOSE:   //******************************************************
   {
      LONG editor;

      if ( hwndEnt = pfnEntryOpen ( pRecScn, &editor ) )
      {
         //pfnHaveAKid ( pRecScn, FALSE );
         //if ( ! ( editor | 0x0000002 ) )
            WinSendMsg ( hwndEnt, WM_CLOSE, NULL, NULL );
         //else
           // WinSendMsg ( /*pRecScn->pdr->*/hwndEnt, WM_COMMAND, MPFROM2SHORT(DID_CANCEL, 0), NULL );
      }

   }
   break;
    
   case SCB_UPDATED: //******************************************************
   {
      LONG editor;

      if ( hwndEnt = pfnEntryOpen ( pRecScn, &editor ) && pRecScn->pdr->fbModified )
      {
         ++ulEntryUpdates;
      }
   }
   break;
    
   case SCB_SAVE:    //******************************************************
   {
      if ( hwndEnt = pfnEntryOpen ( pRecScn, 0 ) )
      {
         WinSendMsg ( hwndEnt, UWM_SAVE, NULL, NULL );
      }
   }
   break;
    
   case SCB_EXPALL:  //******************************************************
       
      if ( pRecTmp ) 
         WinSendMsg ( hwndC, CM_EXPANDTREE, MPFROMP( pRecScn ), NULL );
       
   break;
    
   case SCB_COLALL:  //******************************************************
       
      if ( pRecTmp ) 
         WinSendMsg ( hwndC, CM_COLLAPSETREE, MPFROMP( pRecScn ), NULL );
       
   break;
    
   case SCB_PRICOL:  //******************************************************
       
      if ( hwndEnt = pfnEntryOpen ( pRecScn, 0 ) )
      {
         lType = SHORT1FROMMP ( mp );
          
         if ( lType == (LONG) WinQueryWindowUShort ( hwndEnt, QWS_ID ) )
         {
            WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );
             
            WinInvalidateRect ( pRecScn->pdr->hwndE, NULL, TRUE );
         }
      }
       
   break;
    
   default:          //******************************************************
   return;
   }
    
   if ( pRecTmp ) 
   {
      pfnTreeScan ( pRecTmp, ++lLvl, lFunc, mp );
       
      --lLvl;
   }
    
   pRecTmp = WinSendMsg ( hwndC, CM_QUERYRECORD,
                          MPFROMP ( pRecScn ),
                          MPFROM2SHORT ( CMA_NEXT, CMA_ITEMORDER ) );
    
   if ( (LONG) pRecTmp == -1 )
      pRecTmp = NULL;

   if ( pRecTmp && lLvl != SCB_BRANCH )
      pfnTreeScan ( pRecTmp, lLvl, lFunc, mp );
    
   switch ( lFunc ) 
   {
   case SCB_MEMORY:
       
      pbMem = PVOIDFROMMP ( mp );
       
      treeio.lLvl   = SCB_BRANCH;
       
      memcpy ( *pbMem, &treeio, sizeof ( TREEIO ) );
       
   break;
    
   case SCB_FREE:
       
      WinSendMsg ( hwndC, CM_REMOVERECORD,
                   MPFROMP ( &pRecScn ),
                   MPFROM2SHORT( 1, CMA_FREE | CMA_INVALIDATE ) );
       
   break;
   }
    
   return;
    
}
 
/***************************************************************************/
/* Tell All Parents there's a Child Open/Closed                            */
/***************************************************************************/
PUSEREC          pfnHaveAKid     ( PUSEREC pRecScn, BOOL iAmOpen )
{
   PUSEREC pRecPar;
   PUSEREC pRecLast = NULLHANDLE;

   pRecPar = WinSendMsg ( hwndC, CM_QUERYRECORD,
                          MPFROMP      ( pRecScn ),
                          MPFROM2SHORT ( CMA_PARENT, CMA_ITEMORDER ) );

   while ( pRecPar )//&& pRecPar != pRec )
   {
      pRecLast = pRecPar;

      if ( iAmOpen )
         ++pRecPar->ulKids;
      else
         --pRecPar->ulKids;
   
      pRecPar = WinSendMsg ( hwndC, CM_QUERYRECORD,
                             MPFROMP      ( pRecPar ),
                             MPFROM2SHORT ( CMA_PARENT, CMA_ITEMORDER ) );
   }

   return pRecLast;
}
 
/***************************************************************************/
/* Something Dropped on Tree                                               */
/***************************************************************************/
VOID             pfnTreeDrop     ( HWND hwnd, PCNRDRAGINFO pcnrDri ) 
{
   LONG          lKeyState;
   ULONG         ulMemSiz;
   ULONG         ulType;
   PSZ           pszTtl;
   PSZ           pszSrc;
   BOOL          fbRet;
   PVOID         pvClip;
   USHORT        usX, usY;
   CHAR          achBuf[CCHMAXPATH + 32];
    
   PUSEREC       pRecScn;
   PUSEREC       pRecHit;
   PUSEREC       pRecBA;
    
   PDRAGINFO     pdinfo;
   PDRAGITEM     pditem;
   PDRAGTRANSFER pdxfer;
    
   //WinEnableWindowUpdate ( hwndC, FALSE );
    
   //*** Prepare Drop **********************************************
    
   pdinfo = pcnrDri->pDragInfo;
    
   DrgAccessDraginfo ( pdinfo );
    
   pditem = DrgQueryDragitemPtr ( pdinfo, 0 );
    
   if ( DrgVerifyRMF ( pditem, "DRM_PMSCRAPBOOK", "DRF_TREE" ) ) 
   {
      pdxfer                   = DrgAllocDragtransfer ( 1 );
      pdxfer->cb               = sizeof(DRAGTRANSFER);
      pdxfer->hwndClient       = hwnd;
      pdxfer->pditem           = pditem;
      pdxfer->hstrSelectedRMF  = DrgAddStrHandle ( DRM_TREE );
      pdxfer->hstrRenderToName = DrgAddStrHandle ( XFERMEM );
      pdxfer->ulTargetInfo     = 0;
       
      lKeyState = WinGetKeyState ( HWND_DESKTOP, VK_CTRL );
       
      if ( lKeyState & 0x8000 )
         pdxfer->usOperation = DO_COPY;
      else
      {
         pdxfer->usOperation = DO_MOVE;
      }
       
      ulMemSiz = DrgQueryNativeRMFLen(pditem) + 1;
       
      // rc = DosAllocMem(pMem, (PVOID *) pszBuffer, cb);
       
      pszTtl = malloc ( ulMemSiz );
      DrgQueryNativeRMF(pditem, ulMemSiz, pszTtl);
       
      //*** Memory & Communication *************************************************
       
      ulMemSiz = (ULONG) DrgSendTransferMsg ( pdinfo->hwndSource, DM_RENDERPREPARE,
                                              (PVOID) pdxfer, 0 );
       
      if ( ! ulMemSiz ) 
      {
         pfnMsgOK ( hwnd, APP_TITLE, "Drag/Drop render prepare failed" );
         return;
      }
      if ( (LONG) ulMemSiz < 0 )
      {
         pfnMsgOK ( hwnd, APP_TITLE, "Can't drop object within it's branch." );
         return;
      }
       
      pvClip = NULL;
       
      DosAllocSharedMem ( &pvClip, XFERMEM, ulMemSiz, PAG_READ | PAG_WRITE | PAG_COMMIT );
       
      if ( ! pvClip ) 
      {
         pfnMsgOK ( hwnd, APP_TITLE, "Drag/Drop mem alloc failed" );
         return;
      }
       
      fbRet = (BOOL) DrgSendTransferMsg ( pdinfo->hwndSource, DM_RENDER,
                                          (PVOID) pdxfer, 0 );
       
      if ( ! fbRet ) 
      {
         pfnMsgOK ( hwnd, APP_TITLE, "Drag/Drop render failed." );
         return;
      }
       
      //*** Drop ***********************************************************
       
      pRecScn = (PUSEREC) pcnrDri->pRecord;
       
      if ( ! pRecScn )
         pRecScn = pRec;
       
      lKeyState = WinGetKeyState ( HWND_DESKTOP, VK_SHIFT );
       
      fbRet = TRUE;
       
      if ( lKeyState & 0x8000 ) 
      {
         if ( pRecScn == pRec ) 
         {
            WinAlarm ( HWND_DESKTOP, WA_NOTE );
             
            fbRet = FALSE;
         }
         else 
         {
            pRecBA = WinSendMsg ( hwndC, CM_QUERYRECORD,
                                  MPFROMP ( pRecScn ),
                                  MPFROM2SHORT ( CMA_PARENT, CMA_ITEMORDER ) );
             
            pfnReadBufr ( hwndC, pvClip, pRecBA, pRecScn );
         }
      }
      else
         pfnReadBufr ( hwndC, pvClip, pRecScn, (PUSEREC) CMA_FIRST );
       
      //*** Clean Up  ************************************************
       
      pRecDroppedOn = pRecScn;

      DosFreeMem ( pvClip );
       
      DrgSendTransferMsg ( pdinfo->hwndSource, DM_ENDCONVERSATION,
                           (PVOID) pdxfer, (PVOID) fbRet );
       
      DrgFreeDraginfo     ( pdinfo );
      DrgFreeDragtransfer ( pdxfer );
   }
   else 
   {
      PSZ  pszScn;

      pszSrc = malloc ( CCHMAXPATH + 1 );
       
      pRecHit = (PUSEREC) pcnrDri->pRecord;
       
      if ( ! pRecHit )
         pRecHit = pRec;
       
      for ( usX = 0; usX < pdinfo->cditem; ++usX ) 
      {
         pditem = DrgQueryDragitemPtr ( pdinfo, usX );
          
         //*** Get Dragged File Name ***************************************
          
         DrgQueryStrName ( pditem->hstrContainerName, CCHMAXPATH+1, pszSrc );
          
         pszTtl = pszSrc + strlen ( pszSrc );
          
         /*if ( pszTtl > pszSrc && *( pszTtl - 1 ) != '\\' )
            *(pszTtl)++ = '\\';*/
          
         DrgQueryStrName ( pditem->hstrSourceName,
                           CCHMAXPATH + 1 - strlen ( pszSrc ), pszTtl );
          
         /*for ( usY = 0; usY < strlen ( pszSrc ); ++usY )
            if ( pszSrc[usY] == '!' )
               pszSrc[usY] = '/';*/

         //*** Alloc & Rename Entry ******************************************
          
         if ( ulTreeOpts & SCB_DROPREFR || pdinfo->usOperation == DO_LINK ||
              ! DrgVerifyType ( pditem, DRT_TEXT ) )
            ulType = WID_REFR;
         else
         {
            if ( ! pfnFileExists ( pszSrc ) )
               ulType = WID_REFR;
            else
               ulType = WID_TEXT;
         }
       
         pRecScn = pfnAllocRec ( pRecHit, ulType, 0, TRUE, TRUE );
          
         ++pRecAll->pdr->ulDEnt;
          
         fbModified = TRUE;

         //*** Fix up and Display Tree Text **********************************
          
         pszScn = strrchr ( pszSrc, '\\' );

         if ( pszScn )
         {
            pRecScn->crecCore.pszTree  = realloc ( pRecScn->crecCore.pszTree, strlen ( pszScn ) );
          
            strcpy ( pRecScn->crecCore.pszTree, pszScn + 1 );
         }
          
         while ( pszScn = strstr ( pRecScn->crecCore.pszTree, "!!" ) )
               strncpy ( pszScn, "\r\n", 2 );

         while ( pszScn = strstr ( pRecScn->crecCore.pszTree, "!" ) )
               strncpy ( pszScn, "/", 1 );

         WinSendMsg ( hwndC, CM_INVALIDATERECORD,
                      MPFROMP ( &pRecScn ), MPFROM2SHORT ( 1, CMA_TEXTCHANGED ) );
          
         if ( ulType == WID_REFR ) //ulTreeOpts & SCB_DROPREFR )
         {
            pfnRefrNewRec ( pRecScn, pszSrc );
         }
         else
         {
            //*** Read It's File *********************************************
             
            pRecScn->pdr->pvDat = pfnFileReadAll ( pszSrc, &pRecScn->pdr->ulDLen );
             
            pRecScn->pdr->ulDEnt = 1;
             
            pRecScn->pdr->ulOpts = SCB_CONVERT;
             
            if ( ! pRecScn->pdr->pvDat ) 
            {
               sprintf ( achBuf, "Error reading %s.", pszSrc );
   
               pfnMsgOK ( hwnd, APP_TITLE, achBuf );
                
               pRecScn->pdr->ulDLen = 0;
               pRecScn->pdr->ulDEnt = 0;
            }
         }
          
         //*** Done **********************************************************
          
         DrgSendTransferMsg ( pditem->hwndItem, DM_ENDCONVERSATION,
                              MPFROMLONG ( pditem->ulItemID ),
                              MPFROMLONG ( DMFL_TARGETSUCCESSFUL ) );
      }
       
      DrgDeleteDraginfoStrHandles ( pdinfo );
       
      DrgFreeDraginfo ( pdinfo );
       
      free ( pszSrc );
   }
    
   //WinEnableWindowUpdate ( hwndC, TRUE );
    
   return;
}
 
/***************************************************************************/
/* Status Information                                                      */
/***************************************************************************/
BOOL             pfnTreeStat     ( PUSEREC pRecScn ) 
{
   //CNRINFO               cnrinf;
   if ( fbClosing )
      return FALSE;

   WinPostMsg ( hwndS, UWM_PARAMS, MPFROMP ( pRecScn ), NULL );
    
   /*
   if ( ! pRec || ! pRec->pdr || ! pRec->pdr->pszStat || ! pRecScn || ! pRecScn->pdr ) {
       
      return FALSE;
       
   }
    
   sprintf ( pRec->pdr->pszStat,
             "Size: %d \nEntries: %d",
             pRecScn->pdr->ulDLen,
             pRecScn->pdr->ulDEnt );
    
   cnrinf.pszCnrTitle  = pRec->pdr->pszStat;
    
   WinSendMsg ( hwndC, CM_SETCNRINFO, &cnrinf,
                MPFROMLONG ( CMA_CNRTITLE ) );*/
    
   return TRUE;
    
}

//****************************************************************************
// Init Menu
//****************************************************************************
VOID             pfnTreeMenu  ( HWND hwndMenu, SHORT sMID )
{
   switch ( sMID )
   {
      case MID_MAIN_FILE:   
          
         if ( ulRelRev > 5000 ) 
         {
            WinEnableMenuItem ( hwndMenu, MID_MAIN_SAVE,    FALSE );
            WinEnableMenuItem ( hwndMenu, MID_MAIN_SAVE_AS, FALSE );
         }
         else 
         {
            WinEnableMenuItem ( hwndMenu, MID_MAIN_SAVE,    TRUE );
            WinEnableMenuItem ( hwndMenu, MID_MAIN_SAVE_AS, TRUE );
         }
          
      break;
       
      case MID_TREE_ADD:   
          
         /*if ( fbUnregistered && pRecAll->pdr->ulDEnt > UNREG_MAX ) {
             
            WinEnableMenuItem ( hwndMenu, WID_BOOK, FALSE );
            WinEnableMenuItem ( hwndMenu, WID_CHAP, FALSE );
            WinEnableMenuItem ( hwndMenu, WID_SECT, FALSE );
            WinEnableMenuItem ( hwndMenu, WID_TEXT, FALSE );
            WinEnableMenuItem ( hwndMenu, WID_ADDR, FALSE );
            WinEnableMenuItem ( hwndMenu, WID_TODO, FALSE );
             
            }
            else {
           */
            WinEnableMenuItem ( hwndMenu, WID_BOOK, TRUE );
            WinEnableMenuItem ( hwndMenu, WID_CHAP, TRUE );
            WinEnableMenuItem ( hwndMenu, WID_SECT, TRUE );
            WinEnableMenuItem ( hwndMenu, WID_TEXT, TRUE );
            WinEnableMenuItem ( hwndMenu, WID_ADDR, TRUE );
            WinEnableMenuItem ( hwndMenu, WID_TODO, TRUE );
            WinEnableMenuItem ( hwndMenu, WID_REFR, TRUE );
             
            WinEnableMenuItem ( hwndMenu, MID_TREE_CLIPPED,
                                pfnIsMyClip ( hwndMenu, CF_TEXT ) );
         //}
          
      break;
       
      case MID_TREE_EDIT:  
          
         if (  pfnIsMyClip ( hwndMenu, atomTree ) )
         {
            WinEnableMenuItem ( hwndMenu, MID_TREE_PASTE,     TRUE );
            WinEnableMenuItem ( hwndMenu, MID_TREE_PASTE_AFT, ( pRecFoc != pRec ) );
         }
         else 
         {
            WinEnableMenuItem ( hwndMenu, MID_TREE_PASTE,     FALSE );
            WinEnableMenuItem ( hwndMenu, MID_TREE_PASTE_AFT, FALSE );
         }
          
         if (  pRecFoc != pRec && ! pfnEntryOpen ( pRecFoc, 0 ) && ! pRecFoc->ulKids )
         {
            WinEnableMenuItem ( hwndMenu, MID_TREE_CUT,  ( pRecFoc != pRec ) );
            WinEnableMenuItem ( hwndMenu, MID_TREE_COPY, TRUE );
         }
         else 
         {
            WinEnableMenuItem ( hwndMenu, MID_TREE_CUT,  FALSE );
            WinEnableMenuItem ( hwndMenu, MID_TREE_COPY, FALSE );
         }
          
         WinEnableMenuItem ( hwndMenu, MID_TREE_DELT, ( pRecFoc != pRec ) );
          
         if (  pfnEntryOpen ( pRecFoc, 0 ) )
            WinEnableMenuItem ( hwndMenu, MID_TREE_CLOSE,  TRUE );
         else
            WinEnableMenuItem ( hwndMenu, MID_TREE_CLOSE,  FALSE );
          
         if (  pRecFoc->ulType == WID_REFR )
            WinEnableMenuItem ( hwndMenu, MID_TREE_PROPS,  TRUE );
         else
            WinEnableMenuItem ( hwndMenu, MID_TREE_PROPS,  FALSE );
          
      break;
   }
}
