 
#define INCL_GPIPATHS

#define VAR_SCOPE extern
 
#include "fsp.h"
 
//*** Prototypes ************************************************************ */
 
BOOL             pfnToDoStat     ( PUSEREC );
VOID             pfnToDoCont     ( HWND, PUSEREC );
VOID             pfnToDoMenu     ( PUSEREC, HWND, SHORT );
VOID             pfnToDoNewPage  ( BOOL );
VOID             pfnToDoPrintInit( VOID );
SHORT   APIENTRY pfnToDoSort     ( PRECORDCORE, PRECORDCORE, PVOID );
VOID             pfnToDoPrtThd   ( PVOID );
 
VOID             pfnDrawCheckMark( HPS, PRECTL, PFONTMETRICS );

/***************************************************************************/
/* To-Do Window Proc                                                       */
/***************************************************************************/
MRESULT EXPENTRY pfnwpToDoWin ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   PUSEREC     pRecScn = WinQueryWindowPtr ( hwnd, 0 );
    
   switch ( msg ) 
   {
      case WM_CREATE:
          
      break;
       
      case WM_ACTIVATE:
          
         if ( SHORT1FROMMP ( mp1 ) ) 
         {
            hwndFoc = HWNDFROMMP ( mp2 );
             
            WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                         MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                         MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
         }
         else 
         {
            hwndFoc = HWNDFROMMP ( mp2 );
             
            WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                         NULL, NULL );
         }
          
      break;
       
      case WM_DRAWITEM:
      {
         POWNERITEM        poi;
         PCNRDRAWITEMINFO  pcdi;
         PTODOREC          pToDoFoc;

         poi = PVOIDFROMMP ( mp2 );
          
         if ( ! poi->hItem )
            break;
          
         pcdi     = (PCNRDRAWITEMINFO) poi->hItem;
         pToDoFoc = (PTODOREC)         pcdi->pRecord;
          
         if ( ! pToDoFoc )
            break;
          
         if ( ulToDoOpts & SCB_PRICOLR ) 
         {
            if ( pcdi->pFieldInfo->offStruct == FIELDOFFSET ( TODOREC, pszPr ) ) 
            {
               switch ( pToDoFoc->ulPri ) 
               {
                  case SCB_TODO_PRI5:
                      
                     WinFillRect ( poi->hps, &poi->rclItem, 0x00FF0000 );//CLR_RED );
                      
                  break;
                   
                  case SCB_TODO_PRI4:
                      
                     WinFillRect ( poi->hps, &poi->rclItem, 0x00FFFF00 );//CLR_PINK ); Yellow
                      
                  break;
                   
                  case SCB_TODO_PRI3:
                      
                     WinFillRect ( poi->hps, &poi->rclItem, 0x000000FF );//CLR_BLUE );
                      
                  break;
                   
                  case SCB_TODO_PRI2:
                      
                     WinFillRect ( poi->hps, &poi->rclItem, 0x0000FFFF );//CLR_CYAN );
                      
                  break;
                   
                  case SCB_TODO_PRI1:
                      
                     WinFillRect ( poi->hps, &poi->rclItem, 0x00FFFFFF );//CLR_WHITE );
                      
                  break;
               }
               return ( MRESULT ) TRUE;
            }
         }

         if ( pcdi->pFieldInfo->offStruct == FIELDOFFSET ( TODOREC, pszFn ) )
         {
            if ( pToDoFoc->ulOpt & SCB_TODO_DONE )
            {
               poi->rclItem.xLeft += pRecScn->pdr->fat.lAveCharWidth;

               pfnDrawCheckMark ( poi->hps, &poi->rclItem, NULL );
            }
            else
               WinFillRect ( poi->hps, &poi->rclItem, 0x00FFFFFF );//CLR_WHITE );

            return ( MRESULT ) TRUE;
         }
      }
      break;
       
      case WM_SIZE:
          
         if ( pRecScn )
            WinSetWindowPos ( pRecScn->pdr->hwndE, 0, 0, 0,
                              SHORT1FROMMP ( mp2 ),
                              SHORT2FROMMP ( mp2 ),
                              SWP_SHOW | SWP_SIZE | SWP_MOVE );
      break;
       
      case UWM_SETRECPTR: //*** Store Data Pointer **************************
      {
         pRecScn = PVOIDFROMMP ( mp1 );
          
         WinSetWindowPtr ( hwnd, 0, pRecScn );
      }
      break;

      case UWM_PARAMS:
      {
         PDATREC        pdr;
         ULONG          ulOff;
         PBYTE          pbDat;
         ULONG          ulLen;
         PTODOREC       pToDoNew;
         RECORDINSERT   recins;
         HWND           hwndMenu;

         //*** Store Data Pointer *******************************************
          
         pRecScn = PVOIDFROMMP ( mp1 );
          
         WinSetWindowPtr ( hwnd, 0, pRecScn );
          
         pdr = pRecScn->pdr;
          
         //*** Frame ********************************************************
          
         pfnSetWinPos ( hwnd, pdr );
          
         pdr->hwndM = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU );
          
         pdr->pszStat = malloc ( 80 );
          
         if ( ( ulRelRev % 5000 ) < 110 || ! pdr->ulDEnt )
            pRecScn->pdr->ulStyl = TODO_STY_SHOWENTR | TODO_STY_SHOWTARG |
                                   TODO_STY_SHOWDONE | TODO_STY_SHOWPRIO |
                                   TODO_STY_SHOWCHEK | TODO_STY_SHOWTASK;

         pfnToDoCont ( hwnd, pRecScn );

         hwndMenu = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU);

         if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWENTR )
            WinCheckMenuItem ( hwndMenu, MID_TODO_SHOWENTR, TRUE );

         if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWTARG )
            WinCheckMenuItem ( hwndMenu, MID_TODO_SHOWTARG, TRUE );

         if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWDONE )
            WinCheckMenuItem ( hwndMenu, MID_TODO_SHOWDONE, TRUE );

         if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWPRIO )
            WinCheckMenuItem ( hwndMenu, MID_TODO_SHOWPRIO, TRUE );

         if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWCHEK )
            WinCheckMenuItem ( hwndMenu, MID_TODO_SHOWCHEK, TRUE );

         if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWTASK )
            WinCheckMenuItem ( hwndMenu, MID_TODO_SHOWTASK, TRUE );

         //*** Insert Data **************************************************
          
         pbDat = pdr->pvDat;

         /* pdr->colInfo[TODO_ENTR].ulPels = 10;
            pdr->colInfo[TODO_TARG].ulPels = 10;
            pdr->colInfo[TODO_DONE].ulPels = 10;
            pdr->colInfo[TODO_PRIO].ulPels =  5;
            pdr->colInfo[TODO_CHEK].ulPels =  5;
            pdr->colInfo[TODO_TASK].ulPels = 60;*/

         if ( pdr->ulDEnt && pdr->ulRelRev >= 114 )
            for ( ulOff = 0; ulOff < TODO_COLS; ++ulOff )
            {
               memcpy ( &pdr->colInfo[ulOff].ulPels, pbDat, sizeof ( ULONG ) );
               pbDat += sizeof ( ULONG );
            }

         pdr->ulCntr = 0;
          
         for ( ulOff = 0; ulOff < pdr->ulDEnt; ++ulOff ) 
         {
            pToDoNew = WinSendMsg ( pdr->hwndE, CM_ALLOCRECORD,
                                    MPFROMLONG (sizeof(TODOREC)-sizeof(RECORDCORE)),
                                    MPFROMSHORT( 1 ) );
             
            //*** Init Record ***********************************************
             
            memcpy ( &pToDoNew->cdEnt, pbDat, sizeof ( CDATE ) );
            pbDat += sizeof ( CDATE );
             
            memcpy ( &pToDoNew->cdFin, pbDat, sizeof ( CDATE ) );
            pbDat += sizeof ( CDATE );
             
            memcpy ( &pToDoNew->cdTrg, pbDat, sizeof ( CDATE ) );
            pbDat += sizeof ( CDATE );
             
            memcpy ( &pToDoNew->ulOpt, pbDat, sizeof ( ULONG ) );
            pbDat += sizeof ( ULONG );
             
            pToDoNew->pszPr = malloc ( 2 );
             
            if ( ( ulRelRev % 5000 ) < 110 ) 
            {
               if ( pToDoNew->ulOpt ) 
               {
                  pToDoNew->ulOpt = SCB_TODO_DONE;
                  pToDoNew->ulPri = 0;
                   
                  strcpy ( pToDoNew->pszPr, "5" );
               }
            }
            else 
            {
               pToDoNew->ulPri = pToDoNew->ulOpt & 0x0000000F;
                
               switch ( pToDoNew->ulPri ) 
               {
                  case SCB_TODO_PRI5:
                      
                     strcpy ( pToDoNew->pszPr, "1" );
                      
                  break;
                   
                  case SCB_TODO_PRI4:
                      
                     strcpy ( pToDoNew->pszPr, "2" );
                      
                  break;
                   
                  case SCB_TODO_PRI3:
                      
                     strcpy ( pToDoNew->pszPr, "3" );
                      
                  break;
                   
                  case SCB_TODO_PRI2:
                      
                     strcpy ( pToDoNew->pszPr, "4" );
                      
                  break;
                   
                  case SCB_TODO_PRI1:
                      
                     strcpy ( pToDoNew->pszPr, "5" );
                      
                  break;
                   
               }
                
            }
             
            ulLen = strlen ( pbDat ) + 1;
            pToDoNew->pszDo = malloc ( ulLen );
            strcpy ( pToDoNew->pszDo, pbDat );
            pbDat += ulLen;
             
            pToDoNew->pszFn = malloc ( 2 );
             
            if ( pToDoNew->ulOpt & SCB_TODO_DONE ) 
            {
               //sprintf ( pToDoNew->pszFn, "%c", 251 );
               strcpy ( pToDoNew->pszFn, "X" );
                
               ++pRecScn->pdr->ulCntr;
            }
            else
               strcpy ( pToDoNew->pszFn, " " );
             
            //*** Insert ****************************************************
             
            recins.cb                = sizeof ( RECORDINSERT );
            recins.pRecordParent     = (PRECORDCORE) NULL;
            recins.pRecordOrder      = (PRECORDCORE) CMA_END;
            recins.zOrder            = CMA_TOP;
            recins.cRecordsInsert    = 1;
            recins.fInvalidateRecord = TRUE;
             
            WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                         MPFROMP( pToDoNew ), MPFROMP ( &recins ) );
         }
          
         //*** Create & Date Edit *******************************************
          
         pdr->pdDate = malloc ( sizeof ( DATEREC ) );
          
         memset ( pdr->pdDate, 0, sizeof ( DATEREC ) );
          
         pdr->pdDate->pszTtl = malloc ( 80 );
          
         pdr->ulOpts |= SCB_OPENED;
          
         pdr->fbModified = FALSE;
          
         pfnToDoStat ( pRecScn );

         //*** Create & Init Search *****************************************
          
         pRecScn->pdr->psSrch = malloc ( sizeof ( SRCHREC ) );
          
         memset ( pRecScn->pdr->psSrch, 0, sizeof ( SRCHREC ) );
          
         pRecScn->pdr->psSrch->hwndE = hwnd;
          
         pRecScn->pdr->psSrch->fbIsCn = TRUE;
          
         pRecScn->pdr->psSrch->pszFnd = malloc ( 1 );

         *pRecScn->pdr->psSrch->pszFnd = 0;
      }
      break;
       
      case WM_INITMENU:
      {
         HWND    hwndMenu;

         WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
          
         hwndMenu = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU);

         pfnToDoMenu ( pRecScn, hwndMenu, SHORT1FROMMP ( mp1 ) );
      }
      break;
       
      case WM_HELP:
      {
         SHORT   sId;

         sId = WinQueryWindowUShort ( hwnd, QWS_ID );

         WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                      MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
      }
      break;
       
      case WM_COMMAND:
          
         if ( SHORT1FROMMP(mp1) != MID_TODO_TASK && pRecScn->pdr->fbEditing )
            WinSendMsg ( pRecScn->pdr->hwndE, CM_CLOSEEDIT, NULL, NULL );
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case MID_TODO_SAVE:
                
               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
                
            break;
             
            case MID_TODO_EXIT:

               WinPostMsg ( WinQueryWindow(hwnd,QW_PARENT), WM_SYSCOMMAND, MPFROM2SHORT ( SC_CLOSE, 0 ), NULL );

            break;
             
            case MID_TODO_SAVE_EXIT:

               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
               WinPostMsg ( WinQueryWindow(hwnd,QW_PARENT), WM_SYSCOMMAND, MPFROM2SHORT ( SC_CLOSE, 0 ), NULL );

            break;
             
            case MID_TODO_FIND:
                
               WinLoadDlg ( HWND_DESKTOP, hwnd, pfndpSearch, 0L, DLG_SEARCH, 
                            pRecScn->pdr->psSrch );
                
            break;
             
            case MID_TODO_FNDNXT:
                
               WinPostMsg ( hwnd, UWM_SEARCH, NULL, NULL );
                
            break;
             
            case MID_TODO_COPY: case MID_TODO_CUT:
            {
               PVOID       pvClip;
               ULONG       ulSize;
               PBYTE       pbScn;
               PTODOREC    pToDoFoc;

               pToDoFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               //*** Alloc & Init Mem ***************************************
                
               ulSize  = sizeof ( CDATE );
               ulSize += sizeof ( CDATE );
               ulSize += sizeof ( CDATE );
               ulSize += sizeof ( BOOL );
               ulSize += strlen ( pToDoFoc->pszDo ) + 1;
                
               DosAllocSharedMem ( &pvClip, NULL, ulSize, PAG_WRITE | PAG_COMMIT | OBJ_GIVEABLE | OBJ_GETTABLE );
                
               DosGetSharedMem ( pvClip, PAG_WRITE );
                
               pbScn = pvClip;
                
               memcpy ( pbScn, &pToDoFoc->cdEnt, sizeof ( CDATE ) );
               pbScn  += sizeof ( CDATE );
                
               memcpy ( pbScn, &pToDoFoc->cdFin, sizeof ( CDATE ) );
               pbScn  += sizeof ( CDATE );
                
               memcpy ( pbScn, &pToDoFoc->cdTrg, sizeof ( CDATE ) );
               pbScn  += sizeof ( CDATE );
                
               memcpy ( pbScn, &pToDoFoc->ulOpt, sizeof ( ULONG ) );
               pbScn  += sizeof ( ULONG );
                
               strcpy ( pbScn, pToDoFoc->pszDo );
               pbScn  += strlen ( pToDoFoc->pszDo ) + 1;
                
               //*** Clipboard it *******************************************
                
               WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                
               WinSetClipbrdData ( WinQueryAnchorBlock ( hwnd ), (ULONG) pvClip, atomToDo, CFI_POINTER );
                
               WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                
               if ( SHORT1FROMMP ( mp1 ) == MID_TODO_CUT )
                  WinSendMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( MID_TODO_DELT, 0 ), NULL );
            }
            break;
             
            case MID_TODO_PASTE:
            {
               PVOID          pvClip;
               PBYTE          pbScn;
               PTODOREC       pToDoNew;
               PTODOREC       pToDoFoc;
               RECORDINSERT   recins;

               if ( pfnIsMyClip ( hwnd, atomToDo ) ) 
               {
                  WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                   
                  pvClip = (PVOID)WinQueryClipbrdData ( WinQueryAnchorBlock ( hwnd ), atomToDo );
                   
                  pbScn = pvClip;
                   
                  //*** Allocate & Init Rec *********************************
                   
                  pToDoFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                          MPFROMLONG ( CMA_FIRST ),
                                          MPFROMSHORT( CRA_SELECTED ) );
                   
                  pToDoNew = WinSendMsg ( pRecScn->pdr->hwndE, CM_ALLOCRECORD,
                                          MPFROMLONG (sizeof(TODOREC)-sizeof(RECORDCORE)),
                                          MPFROMSHORT( 1 ) );
                   
                  //*** Init Record *****************************************
                   
                  memcpy ( &pToDoNew->cdEnt, pbScn, sizeof ( CDATE ) );
                  pbScn  += sizeof ( CDATE );
                   
                  memcpy ( &pToDoNew->cdFin, pbScn, sizeof ( CDATE ) );
                  pbScn  += sizeof ( CDATE );
                   
                  memcpy ( &pToDoNew->cdTrg, pbScn, sizeof ( CDATE ) );
                  pbScn  += sizeof ( CDATE );
                   
                  memcpy ( &pToDoNew->ulOpt, pbScn, sizeof ( ULONG ) );
                  pbScn  += sizeof ( ULONG );
                   
                  pToDoNew->pszDo = malloc ( strlen ( pbScn ) + 1 );
                  strcpy ( pToDoNew->pszDo, pbScn );
                  pbScn  += strlen ( pToDoNew->pszDo ) + 1;
                   
                  pToDoNew->pszFn = malloc ( 2 );
                   
                  if ( pToDoNew->ulOpt & SCB_TODO_DONE ) 
                  {
                     //sprintf ( pToDoNew->pszFn, "%c", 251 );
                     strcpy ( pToDoNew->pszFn, "X" );
                      
                     ++pRecScn->pdr->ulCntr;
                  }
                  else
                     strcpy ( pToDoNew->pszFn, " " );
                   
                  pToDoNew->ulPri = pToDoNew->ulOpt & 0x0000000F;
                   
                  pToDoNew->pszPr = malloc ( 2 );
                   
                  switch ( pToDoNew->ulPri ) 
                  {
                     case SCB_TODO_PRI5:
                         
                        strcpy ( pToDoNew->pszPr, "1" );
                         
                     break;
                      
                     case SCB_TODO_PRI4:
                         
                        strcpy ( pToDoNew->pszPr, "2" );
                         
                     break;
                      
                     case SCB_TODO_PRI3:
                         
                        strcpy ( pToDoNew->pszPr, "3" );
                         
                     break;
                      
                     case SCB_TODO_PRI2:
                         
                        strcpy ( pToDoNew->pszPr, "4" );
                         
                     break;
                      
                     case SCB_TODO_PRI1:
                         
                        strcpy ( pToDoNew->pszPr, "5" );
                         
                     break;
                      
                  }
                   
                  //*** Insert **********************************************
                   
                  recins.cb                = sizeof ( RECORDINSERT );
                  recins.pRecordParent     = NULL;
                   
                  if ( pToDoFoc )
                     recins.pRecordOrder = (PRECORDCORE) pToDoFoc;
                  else 
                     recins.pRecordOrder = (PRECORDCORE) CMA_END;
                   
                  recins.zOrder            = CMA_TOP;
                  recins.cRecordsInsert    = 1;
                  recins.fInvalidateRecord = TRUE;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                               MPFROMP( pToDoNew ), MPFROMP ( &recins ) );
                   
                  pRecScn->pdr->fbModified = TRUE;
                  //fbModified = TRUE;
                   
                  ++pRecScn->pdr->ulDEnt;
                   
                  pfnToDoStat ( pRecScn );
                   
                  WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
               }
            }
            break;
             
            case MID_TODO_ADD:
            {
               PTODOREC       pToDoNew;
               PTODOREC       pToDoFoc;
               RECORDINSERT   recins;

               //*** Allocate & Init Rec ************************************
                
               pToDoFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               pToDoNew = WinSendMsg ( pRecScn->pdr->hwndE, CM_ALLOCRECORD,
                                       MPFROMLONG (sizeof(TODOREC)-sizeof(RECORDCORE)),
                                       MPFROMSHORT( 1 ) );
                
               //*** Init Record ********************************************
                
               pToDoNew->pszDo = malloc ( 1 );
                
               *pToDoNew->pszDo = 0;
                
               pfnSetWhen ( &pToDoNew->cdEnt, NULL );
                
               memset ( &pToDoNew->cdFin, 0, sizeof ( CDATE ) );
               memset ( &pToDoNew->cdTrg, 0, sizeof ( CDATE ) );
                
               pToDoNew->ulOpt = 0;
                
               pToDoNew->pszFn = malloc ( 2 );
                
               strcpy ( pToDoNew->pszFn, " " );
                
               pToDoNew->pszPr = malloc ( 2 );

               pToDoNew->ulOpt |= SCB_TODO_PRI5;
                
               pToDoNew->ulPri = SCB_TODO_PRI5;
                
               strcpy ( pToDoNew->pszPr, "1" );
                
               //*** Insert *************************************************
                
               recins.cb                = sizeof ( RECORDINSERT );
               recins.pRecordParent     = NULL;
                
               if ( pToDoFoc )
                  recins.pRecordOrder = (PRECORDCORE) pToDoFoc;
               else
                  recins.pRecordOrder = (PRECORDCORE) CMA_END;
                
               recins.zOrder            = CMA_TOP;
               recins.cRecordsInsert    = 1;
               recins.fInvalidateRecord = TRUE;
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                            MPFROMP( pToDoNew ), MPFROMP ( &recins ) );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
               ++pRecScn->pdr->ulDEnt;
                
               pfnToDoStat ( pRecScn );
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                            MPFROMP ( pToDoNew ),
                            MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                
               WinPostMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( MID_TODO_TASK, 0 ), NULL );
            }
            break;
             
            case MID_TODO_DELT:
            {
               PTODOREC   pToDoFoc;

               pToDoFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               if ( pToDoFoc->ulOpt & SCB_TODO_DONE )
                  --pRecScn->pdr->ulCntr;
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_REMOVERECORD,
                            MPFROMP ( &pToDoFoc ),
                            MPFROM2SHORT( 1, CMA_FREE | CMA_INVALIDATE ) );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
               --pRecScn->pdr->ulDEnt;
                
               pfnToDoStat ( pRecScn );
            }
            break;
             
            case MID_TODO_FONT:
            {
               PDATREC   pdr = pRecScn->pdr;
               HPS       hps = WinGetPS ( pdr->hwndE );

               if ( pfnGetFont ( hwnd, hps, NULLHANDLE, &pdr->fxPtSz, &pdr->fat ) )
               {
                  pfnSetPPFont ( pdr->hwndE, pdr->fxPtSz, &pdr->fat );
               }

               WinReleasePS ( hps );
            }
            break;
             
            case MID_TODO_COLOR:
            {
               PDATREC   pdr;

               pdr = pRecScn->pdr;
                
               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpColors, 0L, DLG_COLORS, &pdr->hwndE );
            }
            break;
             
            case MID_TODO_TITLE:
            {
               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpSetTitle, 0L, DLG_SET_TITLE, pRecScn );
            }
            break;
             
            case MID_TODO_PRINT:
            {
               pRecPrt = pRecScn;

               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpPrint,  0L,
                           DLG_PRINT, (PVOID) pfnToDoPrtThd );
            }
            break;
             
            case MID_TODO_SORT_ED: case MID_TODO_SORT_TD: case MID_TODO_SORT_FD:
            case MID_TODO_SORT_TA: case MID_TODO_SORT_PR: case MID_TODO_SORT_DN:
            {
               ULONG    ulOff;

               ulOff = SHORT1FROMMP ( mp1 );
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_SORTRECORD,
                            MPFROMP ( pfnToDoSort ),
                            MPFROMP ( &ulOff ) );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
            }
            break;
             
            case MID_TODO_ENTD: case MID_TODO_TRGD: case MID_TODO_DUND:
            {
               PTODOREC  pToDoFoc;
               PDATREC   pdr;

               pToDoFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               pdr = pRecScn->pdr;
                
               switch ( SHORT1FROMMP ( mp1 ) ) 
               {
                  case MID_TODO_ENTD:
                      
                     pdr->pdDate->pcdate = &pToDoFoc->cdEnt;
                      
                     strcpy ( pdr->pdDate->pszTtl, "Entry Date" );
                      
                  break;
                   
                  case MID_TODO_TRGD:
                      
                     pdr->pdDate->pcdate = &pToDoFoc->cdTrg;
                      
                     strcpy ( pdr->pdDate->pszTtl, "Target Date" );
                      
                  break;
                   
                  case MID_TODO_DUND:
                      
                     pdr->pdDate->pcdate = &pToDoFoc->cdFin;
                      
                     strcpy ( pdr->pdDate->pszTtl, "Completion Date" );
                      
                  break;
                   
               }
                
               if ( WinDlgBox ( HWND_DESKTOP, hwnd, pfndpEditDate, 0L, DLG_DATE, pdr->pdDate ) ) 
               {
                  WinSendMsg ( pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );
                   
                  pdr->fbModified = TRUE;
                  //fbModified = TRUE;
               }
            }
            break;
             
            case MID_TODO_TASK:
            {
               PTODOREC       pToDoFoc;
               CNREDITDATA    cnrEdt;

               if ( pRecScn->pdr->fbEditing ) 
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_CLOSEEDIT, NULL, NULL );
               else 
               {
                  pToDoFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                          MPFROMLONG ( CMA_FIRST ),
                                          MPFROMSHORT( CRA_SELECTED ) );
                   
                  cnrEdt.cb         = sizeof ( CNREDITDATA );
                  cnrEdt.hwndCnr    = pRecScn->pdr->hwndE;
                  cnrEdt.pRecord    = (PRECORDCORE) pToDoFoc;
                  cnrEdt.pFieldInfo = pRecScn->pdr->colInfo[TODO_TASK].pfinf;
                  cnrEdt.ppszText   = NULL;
                  cnrEdt.cbText     = 0;
                  cnrEdt.id         = CID_RIGHTDVWND;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_OPENEDIT,
                               MPFROMP ( &cnrEdt ), NULL );
               }
            }
            break;
             
            case MID_TODO_PRI5:
            {
               PTODOREC   pToDoFoc;

               pToDoFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               if ( ! pToDoFoc )
                  break;
                
               pToDoFoc->ulOpt &= 0xFFFFFFF0;
                
               pToDoFoc->ulOpt |= SCB_TODO_PRI5;
                
               pToDoFoc->ulPri = SCB_TODO_PRI5;
                
               strcpy ( pToDoFoc->pszPr, "1" );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );
            }
            break;
            case MID_TODO_PRI4:
            {
               PTODOREC   pToDoFoc;

               pToDoFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               if ( ! pToDoFoc )
                  break;
                
               pToDoFoc->ulOpt &= 0xFFFFFFF0;
                
               pToDoFoc->ulOpt |= SCB_TODO_PRI4;
                
               pToDoFoc->ulPri = SCB_TODO_PRI4;
                
               strcpy ( pToDoFoc->pszPr, "2" );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );
            }
            break;
            case MID_TODO_PRI3:
            {
               PTODOREC   pToDoFoc;

               pToDoFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               if ( ! pToDoFoc )
                  break;
                
               pToDoFoc->ulOpt &= 0xFFFFFFF0;
                
               pToDoFoc->ulOpt |= SCB_TODO_PRI3;
                
               pToDoFoc->ulPri = SCB_TODO_PRI3;
                
               strcpy ( pToDoFoc->pszPr, "3" );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );
            }
            break;
            case MID_TODO_PRI2:
            {
               PTODOREC   pToDoFoc;

               pToDoFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               if ( ! pToDoFoc )
                  break;
                
               pToDoFoc->ulOpt &= 0xFFFFFFF0;
                
               pToDoFoc->ulOpt |= SCB_TODO_PRI2;
                
               pToDoFoc->ulPri = SCB_TODO_PRI2;
                
               strcpy ( pToDoFoc->pszPr, "4" );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );
            }
            break;
            case MID_TODO_PRI1:
            {
               PTODOREC   pToDoFoc;

               pToDoFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               if ( ! pToDoFoc )
                  break;
                
               pToDoFoc->ulOpt &= 0xFFFFFFF0;
                
               pToDoFoc->ulOpt |= SCB_TODO_PRI1;
                
               pToDoFoc->ulPri = SCB_TODO_PRI1;
                
               strcpy ( pToDoFoc->pszPr, "5" );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );
            }
            break;
             
            case MID_TODO_SHOWENTR:
                
               if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWENTR )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, TODO_ENTR, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, TODO_ENTR, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;
            case MID_TODO_SHOWTARG:
                
               if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWTARG )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, TODO_TARG, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, TODO_TARG, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;
            case MID_TODO_SHOWDONE:
                
               if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWDONE )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, TODO_DONE, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, TODO_DONE, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;
            case MID_TODO_SHOWPRIO:
                
               if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWPRIO )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, TODO_PRIO, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, TODO_PRIO, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;
            case MID_TODO_SHOWCHEK:
                
               if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWCHEK )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, TODO_CHEK, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, TODO_CHEK, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;
            case MID_TODO_SHOWTASK:
                
               if ( pRecScn->pdr->ulStyl & TODO_STY_SHOWTASK )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, TODO_TASK, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, TODO_TASK, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;

            default:
               WinPostMsg ( hwndM, msg, mp1, mp2 );
         }
          
      break;
       
      case WM_CONTROL:
          
         if ( SHORT1FROMMP ( mp1 ) == WID_CONT )
         {
            //case WID_CONT:
            switch ( SHORT2FROMMP ( mp1 ) ) 
            {
               case CN_BEGINEDIT:
                   
                  pRecScn->pdr->fbEditing = TRUE;
                   
               return ( MRESULT ) TRUE;
                
               case CN_ENDEDIT:
                   
                  pRecScn->pdr->fbEditing = FALSE;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );

               return ( MRESULT ) TRUE;
                
               case CN_CONTEXTMENU:
               {
                  HWND       hwndMenu;
                  POINTL     ptl;
                  PTODOREC   pToDoNew;

                  pToDoNew = PVOIDFROMMP ( mp2 );
                   
                  hwndMenu = WinLoadMenu ( hwnd, 0, WID_TODO );
                   
                  if ( ! pToDoNew )
                     WinEnableMenuItem ( hwndMenu, MID_TODO_DELT, FALSE );
                  else 
                  {
                     WinEnableMenuItem ( hwndMenu, MID_TODO_DELT, TRUE );
                      
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                                  MPFROMP ( pToDoNew ),
                                  MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                  }

                  pfnToDoMenu ( pRecScn, hwndMenu, MID_TODO_EDIT );

                  WinQueryPointerPos ( HWND_DESKTOP, &ptl );
                   
                  WinMapWindowPoints ( HWND_DESKTOP, hwnd, &ptl, 1 );
                   
                  WinPopupMenu ( pRecScn->pdr->hwndE, hwnd, hwndMenu,
                                 (SHORT)ptl.x, (SHORT)ptl.y,
                                 MID_TODO_EDIT,
                                 PU_POSITIONONITEM | //PU_HCONSTRAIN | PU_VCONSTRAIN |
                                 PU_MOUSEBUTTON1 | PU_MOUSEBUTTON2 | PU_KEYBOARD );
               }
               return ( MRESULT ) TRUE;
                
               case CN_REALLOCPSZ:
               {
                  PTODOREC       pToDoNew;
                  PCNREDITDATA   pcnrEdt;

                  pcnrEdt = PVOIDFROMMP ( mp2 );
                   
                  pToDoNew = (PTODOREC) pcnrEdt->pRecord;
                   
                  pToDoNew->pszDo = realloc ( pToDoNew->pszDo, pcnrEdt->cbText );
                   
                  pRecScn->pdr->fbModified = TRUE;
                  //fbModified = TRUE;
                   
                  pfnSetWhen ( &pToDoNew->cdEnt, NULL );
               }
               return ( MRESULT ) TRUE;
                
               case CN_ENTER:
               {
                  PTODOREC              pToDoNew;
                  PNOTIFYRECORDENTER    pcnrEnt;

                  pcnrEnt = PVOIDFROMMP ( mp2 );
                   
                  pToDoNew = (PTODOREC) pcnrEnt->pRecord;
                   
                  if ( pToDoNew ) 
                  {
                     if ( pToDoNew->ulOpt & SCB_TODO_DONE ) 
                     {
                        pToDoNew->ulOpt &= ~SCB_TODO_DONE;
                         
                        --pRecScn->pdr->ulCntr;
                         
                        strcpy ( pToDoNew->pszFn, " " );
                     }
                     else 
                     {
                        pToDoNew->ulOpt |= SCB_TODO_DONE;
                         
                        //sprintf ( pToDoNew->pszFn, "%c", 251 );
                        strcpy ( pToDoNew->pszFn, "X" );
                         
                        ++pRecScn->pdr->ulCntr;
                         
                        pRecScn->pdr->fbModified = TRUE;
                        pfnSetWhen ( &pToDoNew->cdFin, NULL );
                     }
                      
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );

                     pfnToDoStat ( pRecScn );
                  }
               }
               return ( MRESULT ) TRUE;
                
               case CN_INITDRAG:
               {
                  PTODOREC      pRecDrg;
                  PCNRDRAGINIT  pcnrDrg;
                  PDRAGINFO     pdinfo;
                  DRAGITEM      ditem;
                  DRAGIMAGE     dimage;
      
                  pcnrDrg = PVOIDFROMMP ( mp2 );
                   
                  pRecDrg = (PTODOREC) pcnrDrg->pRecord;
                   
                  if ( ! pRecDrg )
                     break;
                   
                  //*** Drag It ******************************************
                   
                  pdinfo = DrgAllocDraginfo ( 1 );
                   
                  ditem.hwndItem       = hwnd;
                  ditem.ulItemID       = (ULONG)pRecDrg;
                  ditem.hstrType       = DrgAddStrHandle ( DRT_TREE );
                  ditem.hstrRMF        = DrgAddStrHandle ( DRM_TODO );
                  ditem.fsControl      = 0;
                  ditem.fsSupportedOps = DO_COPYABLE | DO_MOVEABLE;
                   
                  DrgSetDragitem ( pdinfo, &ditem, sizeof(ditem), 0 );
                   
                  dimage.cb       = sizeof(DRAGIMAGE);
                  dimage.cptl     = 0;
                  dimage.hImage   = hptrToDo;
                  dimage.fl       = DRG_ICON;
                  dimage.cxOffset = 0;
                  dimage.cyOffset = 0;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                               MPFROMP ( pRecDrg ),
                               MPFROM2SHORT ( TRUE, 0x00004000 ) );//CRA_CURSORED ) );
                   
                  DrgDrag ( hwnd, pdinfo, &dimage, 1, VK_ENDDRAG, NULL );
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                               MPFROMP ( pRecDrg ),
                               MPFROM2SHORT ( FALSE, 0x00004000 ) );//CRA_CURSORED ) );
                   
                  DrgFreeDraginfo ( pdinfo );
               }
               break;
                
               case CN_DRAGAFTER:
               {
                  PCNRDRAGINFO  pcnrDri;
                  PDRAGINFO     pdinfo;
                  PDRAGITEM     pditem;
      
                  pcnrDri = PVOIDFROMMP ( mp2 );
                   
                  pdinfo = pcnrDri->pDragInfo;
                   
                  DrgAccessDraginfo ( pdinfo );
                   
                  pditem = DrgQueryDragitemPtr ( pdinfo, 0 );
                   
                  if ( pditem->hwndItem != hwnd )
                  {
                     DrgFreeDraginfo ( pdinfo );

                     return ( MRFROM2SHORT ( DOR_NEVERDROP, 0 ) );
                  }
                  else if ( DrgVerifyRMF ( pditem, "DRM_PMSCRAPBOOK", "DRF_TODO" ) )
                  { 
                     DrgFreeDraginfo ( pdinfo );
                      
                     return ( MRFROM2SHORT ( DOR_DROP, DO_MOVE ) );
                      
                  }
                  else 
                  {
                     DrgFreeDraginfo ( pdinfo );
                      
                     return ( MRFROM2SHORT ( DOR_NEVERDROP, 0 ) );
                  }
               }
                
               case CN_DROP:
               {
                  PCNRDRAGINFO  pcnrDri;
                  PDRAGINFO     pdinfo;
                  PDRAGITEM     pditem;
                  PTODOREC      pRecDrp;
                  PTODOREC      pRecAft;
                  RECORDINSERT  recins;
      
                  pcnrDri = PVOIDFROMMP ( mp2 );
                   
                  pdinfo = pcnrDri->pDragInfo;
                   
                  DrgAccessDraginfo ( pdinfo );
                   
                  pditem = DrgQueryDragitemPtr ( pdinfo, 0 );
                   
                  pRecDrp = (PTODOREC) pditem->ulItemID;
                  pRecAft = (PTODOREC) pcnrDri->pRecord;
                   
                  if ( ! pRecAft || pRecDrp == pRecAft )
                  {
                     DrgFreeDraginfo ( pdinfo );
                     break;
                  }
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_REMOVERECORD,
                               MPFROMP ( &pRecDrp ),
                               MPFROM2SHORT( 1, 0 ) );//CMA_INVALIDATE ) );
                   
                  //*** Insert *************************************************
                   
                  recins.cb                = sizeof ( RECORDINSERT );
                  recins.pRecordParent     = NULL;
                  recins.pRecordOrder      = (PRECORDCORE) pRecAft;
                  recins.zOrder            = CMA_TOP;
                  recins.cRecordsInsert    = 1;
                  recins.fInvalidateRecord = TRUE;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                               MPFROMP( pRecDrp ), MPFROMP ( &recins ) );
                   
                  pRecScn->pdr->fbModified = TRUE;
                  //fbModified = TRUE;
               }
               break;
                
               case CN_HELP:
                   
                  WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                               MPFROMSHORT ( HID_TODO ), MPFROMSHORT ( HM_RESOURCEID ) );
                   
               break;
                
            }
            //break;
         }
          
      break;
       
      case UWM_SAVE:
      {
         CNRINFO   cnrinf;
         PDATREC   pdr;

         pdr = pRecScn->pdr;
          
         pdr->ulRelRev = REL_REV;

         pdr->ulDLen = pfnNodeScan  ( pdr->hwndE, SCB_SIZE, WID_TODO, pdr->pvDat );
          
         pdr->pvDat = realloc ( pdr->pvDat, pdr->ulDLen );
          
         pdr->ulDEnt = pfnNodeScan  ( pdr->hwndE, SCB_WRITE, WID_TODO, pdr->pvDat );
          
         pdr->fbModified = FALSE;
          
         //*** Set Completion States ****************************************
          
         pfnSetWhen ( &pRecScn->cdWri, &pRecScn->ctWri );
          
         pfnGetWinPos ( hwnd, pdr );
          
         //pdr->sPtSize = pfnFmToFat ( pdr->hwndE, &pdr->fat );
         //pfnGetDefFattrs ( pdr->hwndE, NULLHANDLE, &pdr->fat, &pdr->fxPtSz );
          
         pfnGetPresColors ( pdr->hwndE, &pdr->ulNBClr, &pdr->ulNFClr, &pdr->ulHBClr, &pdr->ulHFClr );
          
         WinSendMsg ( pdr->hwndE, CM_QUERYCNRINFO,
                      MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
          
         pdr->ulXVS = cnrinf.xVertSplitbar;
          
         fbModified = TRUE;
      }
      break;
       
      case UWM_SEARCH:
      {
         PTODOREC         pFoc;
         PDATREC          pdr;
         SEARCHSTRING     cnrsd;

         pdr = pRecScn->pdr;
          
         cnrsd.cb              = sizeof ( SEARCHSTRING );
         cnrsd.pszSearch       = pdr->psSrch->pszFnd;
         cnrsd.fsPrefix        = FALSE;
         cnrsd.fsCaseSensitive = ( pdr->psSrch->fbCase ) ? TRUE : FALSE;
         cnrsd.usView          = CV_DETAIL;

         pFoc = WinSendMsg ( pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                             MPFROMLONG ( CMA_FIRST ),
                             MPFROMSHORT( CRA_SELECTED ) );
          
         if ( ! pFoc )
         {
            pfnMsgOK ( hwnd, APP_TITLE, "Text not found." );
            break;
         }

         if ( pdr->psSrch->fbFirst )
         {
            if ( pFoc == pfnGetCnrRec ( pdr->hwndE, NULL ) )
               pFoc = (PTODOREC) CMA_FIRST;
            
            pdr->psSrch->fbFirst = FALSE;
         }
         
         pFoc = WinSendMsg ( pdr->hwndE, CM_SEARCHSTRING,
                             MPFROMP ( &cnrsd ), MPFROMP ( pFoc ) );

         if ( pFoc )
         {
            pfnCnrShowRec ( pdr->hwndE, pFoc, TRUE );

            if ( pFoc != pfnGetCnrRec ( pdr->hwndE, NULL ) )
               pdr->psSrch->fbFirst = TRUE;
         }
         else
         {
            pdr->psSrch->fbFirst = TRUE;
            pfnMsgOK ( hwnd, APP_TITLE, "Text not found." );
         }
      }
      break;
       
      case WM_CLOSE:
      {
         PDATREC   pdr;

         pdr = pRecScn->pdr;
          
         if ( pdr->fbModified ) 
         {
            if ( pfnMsgYesNo ( hwnd, APP_TITLE,
                               "This entry has been modified. Save changes ?" ) )
               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
         }
          
         pdr->ulOpts &= ~SCB_OPENED;
          
         pdr->hwndD   = 0;
         pfnHaveAKid ( pRecScn, FALSE );
          
         WinEnableWindowUpdate ( pdr->hwndE, FALSE );

         pfnNodeScan  ( pdr->hwndE, SCB_FREE, 
                        pRecScn->ulType, pRecScn->pdr->pvDat );

         free ( pdr->pdDate->pszTtl );
         free ( pdr->pdDate );
         free ( pdr->psSrch->pszFnd );
         free ( pdr->psSrch );
         free ( pdr->pszStat );
          
         WinSendMsg ( hwndC, CM_SETRECORDEMPHASIS,
                      MPFROMP ( pRecScn ),
                      MPFROM2SHORT ( FALSE, CRA_INUSE ) );
          
         WinDestroyWindow ( WinQueryWindow ( hwnd, QW_PARENT ) );
      }
      break;
       
      case WM_PRESPARAMCHANGED:
          
         pRecScn->pdr->fbModified = TRUE;
         //fbModified = TRUE;
          
      break;
       
      case WM_ERASEBACKGROUND:
          
      return ( MRESULT ) ( TRUE );
       
      default:
      return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
       
   }
    
   return ( MRESULT ) FALSE;
}
 
/***************************************************************************/
/* To-Do Sort                                                              */
/***************************************************************************/
SHORT   APIENTRY pfnToDoSort  ( PRECORDCORE pRec1, PRECORDCORE pRec2, PVOID pv ) 
{
   PULONG    pulTyp;
   SHORT     sRet;
    
   PTODOREC  pToDo1;
   PTODOREC  pToDo2;
   PCDATE    pcdate1;
   PCDATE    pcdate2;
    
   pToDo1 = (PTODOREC) pRec1;
   pToDo2 = (PTODOREC) pRec2;
    
   pulTyp = (PULONG) pv;
    
   switch ( *pulTyp ) 
   {
      case MID_TODO_SORT_ED:
          
         pcdate1 = &pToDo1->cdEnt;
         pcdate2 = &pToDo2->cdEnt;
          
      break;
       
      case MID_TODO_SORT_TD:
          
         pcdate1 = &pToDo1->cdTrg;
         pcdate2 = &pToDo2->cdTrg;
          
      break;
       
      case MID_TODO_SORT_FD:
          
         pcdate1 = &pToDo1->cdFin;
         pcdate2 = &pToDo2->cdFin;
          
      break;
       
      case MID_TODO_SORT_TA:
          
         sRet = stricmp ( pToDo1->pszDo, pToDo2->pszDo );
          
         if ( sRet )
            return sRet;
          
         sRet = stricmp ( pToDo1->pszPr, pToDo2->pszPr );
          
         if ( sRet )
            return sRet;
          
         sRet = stricmp ( pToDo1->pszFn, pToDo2->pszFn );
          
         sRet *= (-1);
          
      return sRet;
       
      case MID_TODO_SORT_PR:
          
         sRet = stricmp ( pToDo1->pszPr, pToDo2->pszPr );
          
         if ( sRet )
            return sRet;
          
         sRet = stricmp ( pToDo1->pszFn, pToDo2->pszFn );
          
         if ( sRet )
            return ( sRet * (-1) );
          
         sRet = stricmp ( pToDo1->pszDo, pToDo2->pszDo );
          
         if ( sRet )
            return sRet;
          
      return sRet;
       
      case MID_TODO_SORT_DN:
          
         sRet = stricmp ( pToDo1->pszFn, pToDo2->pszFn );
          
         if ( sRet )
            return ( sRet * (-1) );
          
         sRet = stricmp ( pToDo1->pszPr, pToDo2->pszPr );
          
         if ( sRet )
            return sRet;
          
         sRet = stricmp ( pToDo1->pszDo, pToDo2->pszDo );
          
         if ( sRet )
            return sRet;
          
      return sRet;
       
   }
    
   if ( pcdate1->year < pcdate2->year )
      sRet = -1;
   else if ( pcdate1->year > pcdate2->year )
      sRet = 1;
   else if ( pcdate1->month < pcdate2->month )
      sRet = -1;
   else if ( pcdate1->month > pcdate2->month )
      sRet = 1;
   else if ( pcdate1->day < pcdate2->day )
      sRet = -1;
   else if ( pcdate1->day > pcdate2->day )
      sRet = 1;
   else 
      sRet = 0;
    
   return sRet;
}
 
/***************************************************************************/
/* To-Do Stat                                                              */
/***************************************************************************/
BOOL             pfnToDoStat  ( PUSEREC pRecScn ) 
{
   //CNRINFO               cnrinf;
    
   if ( pRecScn->pdr->ulDEnt ) 
      sprintf ( pRecScn->pdr->pszStat, "%d entries - %d (%d%%) complete",
                pRecScn->pdr->ulDEnt,
                pRecScn->pdr->ulCntr,
                pRecScn->pdr->ulCntr * 100 / pRecScn->pdr->ulDEnt );
   else
      sprintf ( pRecScn->pdr->pszStat, "%d entries - %d (%d%%) complete",
                pRecScn->pdr->ulDEnt,
                pRecScn->pdr->ulCntr,
                0 );
    
   pfnCnrTitle ( pRecScn->pdr->hwndE, pRecScn->pdr->pszStat );

   //cnrinf.pszCnrTitle  = pRecScn->pdr->pszStat;
    
   //WinSendMsg ( pRecScn->pdr->hwndE, CM_SETCNRINFO, &cnrinf,
     //           MPFROMLONG ( CMA_CNRTITLE ) );
    
   return TRUE;
}
 
/***************************************************************************/
/* Create To-Do Container                                                  */
/***************************************************************************/
VOID             pfnToDoCont  ( HWND hwnd, PUSEREC pRecScn )
{
   PDATREC           pdr;
   CNRINFO           cnrinf;
   MRESULT           mr;
   SWP               swp;
    
   pdr = pRecScn->pdr;

   pdr->hwndE = WinCreateWindow ( hwnd, WC_CONTAINER, NULL,
                                  CCS_SINGLESEL,
                                  0,0,0,0, hwnd, HWND_TOP,
                                  WID_CONT, NULL, NULL );
    
   WinSetWindowPtr ( pdr->hwndE, 0, pRecScn );
    
   cnrinf.pszCnrTitle  = pdr->pszStat;
   //cnrinf.flWindowAttr = CV_DETAIL | CA_DETAILSVIEWTITLES | CA_OWNERDRAW | CA_ORDEREDTARGETEMPH;
   cnrinf.flWindowAttr = CV_DETAIL | CA_DETAILSVIEWTITLES | CA_ORDEREDTARGETEMPH;
    
   if ( ulToDoOpts & SCB_STATED )
      cnrinf.flWindowAttr |= CA_CONTAINERTITLE | CA_TITLESEPARATOR | CA_TITLEREADONLY;
    
   WinSendMsg ( pdr->hwndE, CM_SETCNRINFO, &cnrinf,
                MPFROMLONG ( CMA_FLWINDOWATTR ) );
    
   pfnSetPPFont ( pdr->hwndE, pdr->fxPtSz, &pdr->fat );
    
   pfnSetPresColors ( pdr->hwndE, pdr->ulNBClr, pdr->ulNFClr, pdr->ulHBClr, pdr->ulHFClr );
    
   WinSendMsg ( pdr->hwndE, CM_QUERYCNRINFO,
                MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
    
   //*** Allocate & Init Field Info ***********************************
    
   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszToDoEntr, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_DATE | CFA_TOP | CFA_RIGHT |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( TODOREC, cdEnt ) );
         
   pdr->colInfo[TODO_ENTR].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[TODO_ENTR].fbVisible        = TRUE;
   pdr->colInfo[TODO_ENTR].ulShowMask       = TODO_STY_SHOWENTR;
   pdr->colInfo[TODO_ENTR].pfinf->pUserData = &usLeftDvWnd;

   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszToDoTarg, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_DATE | CFA_TOP | CFA_RIGHT |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( TODOREC, cdTrg ) );
         
   pdr->colInfo[TODO_TARG].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[TODO_TARG].fbVisible        = TRUE;
   pdr->colInfo[TODO_TARG].ulShowMask       = TODO_STY_SHOWTARG;
   pdr->colInfo[TODO_TARG].pfinf->pUserData = &usLeftDvWnd;

    
   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszToDoDone, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_DATE | CFA_TOP | CFA_RIGHT |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( TODOREC, cdFin ) );
         
   pdr->colInfo[TODO_DONE].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[TODO_DONE].fbVisible        = TRUE;
   pdr->colInfo[TODO_DONE].ulShowMask       = TODO_STY_SHOWDONE;
   pdr->colInfo[TODO_DONE].pfinf->pUserData = &usLeftDvWnd;

    
   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszToDoPrio, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_STRING | CFA_TOP | CFA_CENTER |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( TODOREC, pszPr ) );
         
   pdr->colInfo[TODO_PRIO].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[TODO_PRIO].fbVisible        = TRUE;
   pdr->colInfo[TODO_PRIO].ulShowMask       = TODO_STY_SHOWPRIO;
   pdr->colInfo[TODO_PRIO].pfinf->pUserData = &usRightDvWnd;

   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszToDoIDid, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_STRING | CFA_TOP | CFA_CENTER |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( TODOREC, pszFn ) );
         
   pdr->colInfo[TODO_CHEK].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[TODO_CHEK].fbVisible        = TRUE;
   pdr->colInfo[TODO_CHEK].ulShowMask       = TODO_STY_SHOWCHEK;
   pdr->colInfo[TODO_CHEK].pfinf->pUserData = &usRightDvWnd;

    
   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszToDoTask, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_STRING | CFA_TOP | CFA_LEFT |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( TODOREC, pszDo ) );
         
   pdr->colInfo[TODO_TASK].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[TODO_TASK].fbVisible        = TRUE;
   pdr->colInfo[TODO_TASK].ulShowMask       = TODO_STY_SHOWTASK;
   pdr->colInfo[TODO_TASK].pfinf->pUserData = &usRightDvWnd;

   //*** Hide Hidden Columns ******************************************

   if ( ! ( pdr->ulStyl & TODO_STY_SHOWENTR ) )
   {
      pdr->colInfo[TODO_ENTR].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[TODO_ENTR].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   if ( ! ( pdr->ulStyl & TODO_STY_SHOWTARG ) )
   {
      pdr->colInfo[TODO_TARG].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[TODO_TARG].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   if ( ! ( pdr->ulStyl & TODO_STY_SHOWDONE ) )
   {
      pdr->colInfo[TODO_DONE].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[TODO_DONE].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   if ( ! ( pdr->ulStyl & TODO_STY_SHOWPRIO ) )
   {
      pdr->colInfo[TODO_PRIO].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[TODO_PRIO].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   if ( ! ( pdr->ulStyl & TODO_STY_SHOWCHEK ) )
   {
      pdr->colInfo[TODO_CHEK].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[TODO_CHEK].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   if ( ! ( pdr->ulStyl & TODO_STY_SHOWTASK ) )
   {
      pdr->colInfo[TODO_TASK].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[TODO_TASK].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   //*** Position Container *******************************************
    
   WinQueryWindowPos ( hwnd, &swp );
    
   WinSetWindowPos ( pdr->hwndE, HWND_TOP,
                     0, 0,
                     swp.cx,
                     swp.cy,
                     SWP_SIZE | SWP_MOVE | SWP_SHOW );
    
   WinSetFocus ( HWND_DESKTOP, pdr->hwndE );
    
   //*** Set up Splitbar **********************************************
    
   if ( ! pdr->ulDLen ) 
      pdr->ulXVS = swp.cx / 4 * 3;
    
   pfnCnrSplit ( pdr->hwndE,
                 pdr->colInfo[TODO_DONE].pfinf,
                 pdr->ulXVS );
}

//****************************************************************************
// Init Menu
//****************************************************************************
VOID             pfnToDoMenu  ( PUSEREC pRecScn, HWND hwndMenu, SHORT sMID )
{
   PTODOREC   pFoc;

   switch ( sMID )
   {
      case MID_TODO_FILE:
         if ( pqi.pDriverData )
            WinEnableMenuItem ( hwndMenu, MID_TODO_PRINT, TRUE  );
         else
            WinEnableMenuItem ( hwndMenu, MID_TODO_PRINT, FALSE );
      break;
          
      case MID_TODO_EDIT:
          
         if (  pfnIsMyClip ( hwndMenu, atomToDo ) )
            WinEnableMenuItem ( hwndMenu, MID_TODO_PASTE, TRUE );
         else
            WinEnableMenuItem ( hwndMenu, MID_TODO_PASTE, FALSE );
          
         pFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                             MPFROMLONG ( CMA_FIRST ),
                             MPFROMSHORT( CRA_SELECTED ) );
          
         if (  pFoc ) 
         {
            WinEnableMenuItem ( hwndMenu, MID_TODO_CUT,  TRUE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_COPY, TRUE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_DELT, TRUE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_ENTD, TRUE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_TRGD, TRUE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_DUND, TRUE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_TASK, TRUE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_PRIO, TRUE );
         }
         else 
         {
            WinEnableMenuItem ( hwndMenu, MID_TODO_CUT,  FALSE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_COPY, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_DELT, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_ENTD, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_TRGD, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_DUND, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_TASK, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_TODO_PRIO, FALSE );
         }
          
         if ( pRecScn->pdr->psSrch->hwndS  || ! pFoc )
            WinEnableMenuItem ( hwndMenu, MID_TODO_FIND, FALSE );
         else 
            WinEnableMenuItem ( hwndMenu, MID_TODO_FIND, TRUE  );
          
         if ( *pRecScn->pdr->psSrch->pszFnd && pFoc )
            WinEnableMenuItem ( hwndMenu, MID_TODO_FNDNXT, TRUE );
         else 
            WinEnableMenuItem ( hwndMenu, MID_TODO_FNDNXT, FALSE );
      break;
   }
}

//****************************************************************************
// Print Thread
//****************************************************************************
VOID             pfnToDoPrtThd       ( PVOID pv )
{
   HMQ         hmq;
   PDATREC     pdr;
   PTODOREC    pPrt;
   ULONG       ulPrinted = 0;
   LONG        lCharsOut;
   LONG        lCharsLeft = 1;
   LONG        lNewBottom;
   LONG        lLowBottom;
   BOOL        fbCausePage = FALSE;
   FONTMETRICS fm;
   RECTL       rclText;
   POINTL      pt;
   SHORT       sColsDone;
   SHORT       sCurCol;
   SHORT       sX;
   CHAR        ach32[32];

   hmq = WinCreateMsgQueue ( WinQueryAnchorBlock ( hwndM ), 0 );

   pdr = pprtCtl->pPrtRec->pdr;

   ++pprtCtl->ulPrtPage;

   pdr->ulPrtPage = pprtCtl->ulPrtPage;

   pfnToDoPrintInit ();

   fm = pprtCtl->fmAll;

   //*** Print Entry ********************************************************

   rclText.yBottom = pprtCtl->rclBody.yBottom;
   rclText.yTop    = rclText.yBottom;

   sColsDone = pprtCtl->sVisCols;

   for ( sX = 0; sX < pprtCtl->sVisCols; ++sX )
   {
      pprtCtl->abfinf[sX]   = TRUE;
      pprtCtl->apszfinf[sX] = NULL;
   }

   pPrt = pfnGetCnrRec ( pdr->hwndE, NULL );
    
   while ( pPrt && fbPrinting )
   {
      if ( rclText.yTop - fm.lMaxBaselineExt < rclText.yBottom )
      {
         pfnToDoNewPage ( fbCausePage );

         fbCausePage = TRUE;
         rclText.yTop = pprtCtl->arclfinf[0].yBottom - fm.lMaxDescender;
         lLowBottom   = rclText.yTop;
         lNewBottom   = lLowBottom;
      }

      sCurCol = 0;

      //*** Print Entry Date ************************************************

      if ( pdr->ulStyl & TODO_STY_SHOWENTR )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            pfnNLSDate ( &ci, ach32,
                         pPrt->cdEnt.year,
                         pPrt->cdEnt.month, pPrt->cdEnt.day );
 
            pfnPaintText ( pprtCtl->hpsPrinter, ach32, 
                           &rclText, &pprtCtl->fmAll,
                           DT_RIGHT | DT_TOP, TRUE, FALSE );

            --sColsDone;
            pprtCtl->abfinf[sCurCol] = FALSE;

            if ( lNewBottom && lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }
      //*** Print Target Date ***********************************************

      if ( pdr->ulStyl & TODO_STY_SHOWTARG )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            pfnNLSDate ( &ci, ach32,
                         pPrt->cdTrg.year,
                         pPrt->cdTrg.month, pPrt->cdTrg.day );
 
            pfnPaintText ( pprtCtl->hpsPrinter, ach32, 
                           &rclText, &pprtCtl->fmAll,
                           DT_RIGHT | DT_TOP, TRUE, FALSE );

            --sColsDone;
            pprtCtl->abfinf[sCurCol] = FALSE;

            if ( lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }
      //*** Print Completion Date *******************************************

      if ( pdr->ulStyl & TODO_STY_SHOWDONE )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            pfnNLSDate ( &ci, ach32,
                         pPrt->cdFin.year,
                         pPrt->cdFin.month, pPrt->cdFin.day );
 
            pfnPaintText ( pprtCtl->hpsPrinter, ach32, 
                           &rclText, &pprtCtl->fmAll,
                           DT_RIGHT | DT_TOP, TRUE, FALSE );

            --sColsDone;
            pprtCtl->abfinf[sCurCol] = FALSE;

            if ( lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }
      //*** Print Priority **************************************************

      if ( pdr->ulStyl & TODO_STY_SHOWPRIO )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            if ( ! pprtCtl->apszfinf[sCurCol] )
               pprtCtl->apszfinf[sCurCol] = pPrt->pszPr;

            pfnPaintText ( pprtCtl->hpsPrinter, pprtCtl->apszfinf[sCurCol], 
                           &rclText, &pprtCtl->fmAll,
                           DT_CENTER | DT_TOP, TRUE, FALSE );

            /*lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter,
                                           pprtCtl->apszfinf[sCurCol],
                                           &rclText, &pprtCtl->fmAll,
                                           &lNewBottom, &lCharsLeft, 
                                           DT_CENTER | DT_VCENTER,
                                           TRUE, FALSE, FALSE );
      
            if ( lCharsLeft )
               pprtCtl->apszfinf[sCurCol] += lCharsOut;
            else*/
            {
               --sColsDone;
               pprtCtl->abfinf[sCurCol] = FALSE;
            }

            if ( lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }
      //*** Print Completion Flag *******************************************

      if ( pdr->ulStyl & TODO_STY_SHOWCHEK )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            if ( ! pprtCtl->apszfinf[sCurCol] )
               pprtCtl->apszfinf[sCurCol] = pPrt->pszFn;

            pfnPaintText ( pprtCtl->hpsPrinter, pprtCtl->apszfinf[sCurCol], 
                           &rclText, &pprtCtl->fmAll,
                           DT_CENTER | DT_TOP, TRUE, FALSE );

            /*lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter,
                                           pprtCtl->apszfinf[sCurCol],
                                           &rclText, &pprtCtl->fmAll,
                                           &lNewBottom, &lCharsLeft, 
                                           DT_CENTER | DT_VCENTER,
                                           TRUE, FALSE, FALSE );
      
            if ( lCharsLeft )
               pprtCtl->apszfinf[sCurCol] += lCharsOut;
            else*/
            {
               --sColsDone;
               pprtCtl->abfinf[sCurCol] = FALSE;
            }

            if ( lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }
      //*** Print Task ******************************************************

      if ( pdr->ulStyl & TODO_STY_SHOWTASK )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            if ( ! pprtCtl->apszfinf[sCurCol] )
               pprtCtl->apszfinf[sCurCol] = pPrt->pszDo;

            lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter,
                                           pprtCtl->apszfinf[sCurCol],
                                           &rclText, &pprtCtl->fmAll,
                                           &lNewBottom, &lCharsLeft, 
                                           DT_LEFT | DT_VCENTER,
                                           TRUE, FALSE, TRUE );
      
            if ( lCharsLeft && lCharsOut )
               pprtCtl->apszfinf[sCurCol] += lCharsOut;
            else
            {
               --sColsDone;
               pprtCtl->abfinf[sCurCol] = FALSE;
            }

            if ( lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }

      //*** End of Record Processing ****************************************

      rclText.yTop  = lLowBottom;
      rclText.yTop -= fm.lMaxDescender;

      if ( ! sColsDone )
      {
         if ( rclText.yTop - ( fm.lMaxBaselineExt + fm.lMaxDescender ) > 
              rclText.yBottom )
         {
            pt.y = rclText.yTop;
            pt.x = pprtCtl->rclPage.xLeft;
   
            GpiMove ( pprtCtl->hpsPrinter, &pt );
   
            pt.x = pprtCtl->rclPage.xRight;
   
            GpiLine ( pprtCtl->hpsPrinter, &pt );
         }

         rclText.yTop -= fm.lMaxDescender;

         sColsDone = pprtCtl->sVisCols;
      
         for ( sX = 0; sX < pprtCtl->sVisCols; ++sX )
         {
            pprtCtl->abfinf[sX]   = TRUE;
            pprtCtl->apszfinf[sX] = NULL;
         }
      
         WinPostMsg ( pprtCtl->hwndPrtDlg, UWM_STAT, 
                      MPFROMLONG ( ++ulPrinted ),
                      MPFROMLONG ( pdr->ulDEnt ) );

         pPrt = pfnGetCnrRec ( pdr->hwndE, pPrt );
      }
   }
   //*** Clear Out **********************************************************

   /*if ( pbBuf )
      free ( pbBuf );*/

   if ( fbPrinting )
      WinPostMsg ( pprtCtl->hwndPrtDlg, UWM_DONE, NULL, NULL );

   WinDestroyMsgQueue ( hmq );

   DosPostEventSem ( evtThdDone );

   //DosExit ( EXIT_THREAD, 0 );
   _endthread();
}

//****************************************************************************
// Print New Page
//****************************************************************************
VOID             pfnToDoNewPage      ( BOOL fbCausePage )
{
   PDATREC     pdr;
   LONG        lCharsOut;
   LONG        lCharsLeft;
   LONG        lNewBottom;
   SHORT       sX;
   CHAR        ach32[32];
   POINTL      pt;

   pdr = pprtCtl->pPrtRec->pdr;

   lNewBottom = pprtCtl->rclPage.yTop;

   //*** Print Heading ***************************************************

   if ( fbCausePage )
   {
      pfnPrintPageEject ( pdr->hwndD, pprtCtl->hpsPrinter );

      ++pprtCtl->ulPrtPage;
   }

   else if ( ulTreeOpts & SCB_PRTHEAD )
   {
      pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                        &pprtCtl->defPrtHed.fat, FONTID_HED );

      lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter, 
                                     pprtCtl->pPrtRec->crecCore.pszTree,
                                     &pprtCtl->rclPage, &pprtCtl->fmHed,
                                     &lNewBottom, &lCharsLeft, 
                                     DT_LEFT | DT_VCENTER,
                                     FALSE, FALSE, FALSE );
   
   }

   //*** Adjust to Printed Heading Height First Time Through *************

   if ( ! fbCausePage )
   {
      pprtCtl->rclBody.yTop = lNewBottom - pprtCtl->fmAll.lMaxBaselineExt;

      for ( sX = 0; sX < pprtCtl->sVisCols; ++sX )
      {
         pprtCtl->arclfinf[sX].yTop    = pprtCtl->rclBody.yTop;
         pprtCtl->arclfinf[sX].yBottom = pprtCtl->rclBody.yTop -
                                        ( pprtCtl->fmAll.lMaxBaselineExt * pprtCtl->lHedLines );
      }
   }

   //*** Print Page Number ***********************************************

   if ( ulTreeOpts & SCB_PRTPAGE )
   {
      pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                        &pprtCtl->defPrtCnt.fat, FONTID_CNT );


      sprintf ( ach32, "-  %d  -", pprtCtl->ulPrtPage );
   
      pfnPaintText ( pprtCtl->hpsPrinter, ach32, 
                     &pprtCtl->rclFoot, &pprtCtl->fmCnt,
                     DT_CENTER | DT_BOTTOM, FALSE, FALSE );
   }

   //*** Print Column Headings *******************************************

   pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                     &pprtCtl->defPrtAll.fat, FONTID_ALL );

   pfnPaintBox ( pprtCtl->hpsPrinter, &pprtCtl->rclBody );

   lCharsOut = pprtCtl->fmAll.lMaxBaselineExt / 2;

   for ( sX = 0; sX < pprtCtl->sVisCols; ++sX )
   {
      pprtCtl->arclfinf[sX].yTop -= lCharsOut;

      pfnPaintTextRect ( pprtCtl->hpsPrinter,
                         (PSZ)pdr->colInfo[pprtCtl->alIds[sX]].pfinf->pTitleData,
                         &pprtCtl->arclfinf[sX], 
                         &pprtCtl->fmAll,
                         &lNewBottom, &lCharsLeft, 
                         DT_CENTER | DT_VCENTER,
                         FALSE, FALSE, FALSE );

      pprtCtl->arclfinf[sX].yTop += lCharsOut;

      pt.x = pprtCtl->arclfinf[sX].xLeft;
      pt.y = pprtCtl->rclBody.yTop;

      GpiMove ( pprtCtl->hpsPrinter, &pt );

      pt.y = pprtCtl->rclBody.yBottom;

      GpiLine ( pprtCtl->hpsPrinter, &pt );
   }

   pt.x = pprtCtl->rclPage.xLeft;
   pt.y = pprtCtl->arclfinf[0].yBottom;

   GpiMove ( pprtCtl->hpsPrinter, &pt );

   pt.x = pprtCtl->rclPage.xRight;

   GpiLine ( pprtCtl->hpsPrinter, &pt );

}

//****************************************************************************
// Print Initialization
//****************************************************************************
VOID             pfnToDoPrintInit    (  )
{
   PDATREC     pdr;
   SHORT       sVisCols;
   LONG        lLeft;
   SHORT       sX;
   LONG        lDateLen;
   LONG        lCharLen;
   LONG        lUsedPels;
   LONG        colLines;
   PSZ         psz;

   pdr = pprtCtl->pPrtRec->pdr;

   //*** Set Entry Font *****************************************************

   if ( pprtCtl->fbNewFont )
   {
      pdr->fxPtSzPrt = pprtCtl->defPrtAll.fxPtSz;
      pdr->fatPrt    = pprtCtl->defPrtAll.fat;
   }

   if ( pdr->fxPtSzPrt )
   {
      pprtCtl->defPrtAll.fxPtSz = pdr->fxPtSzPrt;
      pprtCtl->defPrtAll.fat    = pdr->fatPrt;
   }

   pfnCvtVecFont     ( pprtCtl->hpsPrinter, 
                       pprtCtl->defPrtAll.fxPtSz,
                       &pprtCtl->defPrtAll.fat );

   pfnSetPaintFont   ( pdr->hwndD, pprtCtl->hpsPrinter, 
                       &pprtCtl->defPrtAll.fat, FONTID_ALL );

   GpiQueryFontMetrics ( pprtCtl->hpsPrinter, sizeof ( FONTMETRICS ), 
                         &pprtCtl->fmAll );

   //*** Column Setup *******************************************************

   lDateLen  = pfnStrPelLen ( pprtCtl->hpsPrinter, "55-55-5555" );
   lDateLen += ( pprtCtl->fmAll.lAveCharWidth * 2 );

   lCharLen  = pfnStrPelLen ( pprtCtl->hpsPrinter, "X" );
   lCharLen += ( pprtCtl->fmAll.lAveCharWidth * 2 );

   lUsedPels = 0;

   sVisCols = 0;

   if ( pdr->hwndD )
   {
      if ( pdr->ulStyl & TODO_STY_SHOWENTR )
      {
         pprtCtl->alfinf[sVisCols] = lDateLen; /*pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[TODO_ENTR].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         lUsedPels += pprtCtl->alfinf[sVisCols];

         pprtCtl->alIds[sVisCols]   = TODO_ENTR;
   
         ++sVisCols;
      }
      if ( pdr->ulStyl & TODO_STY_SHOWTARG )
      {
         pprtCtl->alfinf[sVisCols] = lDateLen; /*pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[TODO_TARG].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         lUsedPels += pprtCtl->alfinf[sVisCols];

         pprtCtl->alIds[sVisCols]   = TODO_TARG;
   
         ++sVisCols;
      }
      if ( pdr->ulStyl & TODO_STY_SHOWDONE )
      {
         pprtCtl->alfinf[sVisCols] = lDateLen; /*pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[TODO_DONE].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         lUsedPels += pprtCtl->alfinf[sVisCols];

         pprtCtl->alIds[sVisCols]   = TODO_DONE;
   
         ++sVisCols;
      }
      if ( pdr->ulStyl & TODO_STY_SHOWPRIO )
      {
         pprtCtl->alfinf[sVisCols] = lCharLen; /*pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[TODO_PRIO].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         lUsedPels += pprtCtl->alfinf[sVisCols];

         pprtCtl->alIds[sVisCols]   = TODO_PRIO;
   
         ++sVisCols;
      }
      if ( pdr->ulStyl & TODO_STY_SHOWCHEK )
      {
         pprtCtl->alfinf[sVisCols] = lCharLen; /*pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[TODO_CHEK].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         lUsedPels += pprtCtl->alfinf[sVisCols];

         pprtCtl->alIds[sVisCols]   = TODO_CHEK;
   
         ++sVisCols;
      }
      if ( pdr->ulStyl & TODO_STY_SHOWTASK )
      {
         pprtCtl->alfinf[sVisCols] = pprtCtl->rclPage.xRight - pprtCtl->rclPage.xLeft - lUsedPels;
         /*pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[TODO_TASK].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         pprtCtl->alIds[sVisCols]   = TODO_TASK;
   
         ++sVisCols;
      }
   }

   pprtCtl->sVisCols = sVisCols;

/*   pprtCtl->rclPage.xRight = pfnPrintALScale ( pprtCtl->rclPage.xRight -
                                               pprtCtl->rclPage.xLeft,
                                               sVisCols, 
                                               pprtCtl->alfinf );*/

   pprtCtl->rclBody.xRight = pprtCtl->rclPage.xRight;
   pprtCtl->rclFoot.xRight = pprtCtl->rclPage.xRight;

   //*** Column Headings Setup ********************************************** */

   lLeft = pprtCtl->rclPage.xLeft;

   for ( sX = 0; sX < sVisCols; ++sX )
   {
      pprtCtl->arclfinf[sX].xLeft  = lLeft;
      pprtCtl->arclfinf[sX].xRight = lLeft + pprtCtl->alfinf[sX];

      lLeft = pprtCtl->arclfinf[sX].xRight;
   }

   pprtCtl->arclfinf[sVisCols-1].xRight = pprtCtl->rclPage.xRight;

   pprtCtl->lHedLines = 1;

   for ( sX = 0, colLines = 1, psz = colStrs.pszToDoEntr; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   for ( sX = 0, colLines = 1, psz = colStrs.pszToDoTarg; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   for ( sX = 0, colLines = 1, psz = colStrs.pszToDoDone; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   for ( sX = 0, colLines = 1, psz = colStrs.pszToDoPrio; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   for ( sX = 0, colLines = 1, psz = colStrs.pszToDoIDid; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   for ( sX = 0, colLines = 1, psz = colStrs.pszToDoTask; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   ++pprtCtl->lHedLines;
}

//****************************************************************************
// Draw a Check Mark
//****************************************************************************
VOID             pfnDrawCheckMark    ( HPS hps, PRECTL pRecIn, PFONTMETRICS pfm )
{
   RECTL  rclChk;
   POINTL aptl[6];

   LONG   xWork,
          x3rd,
          y3rd;

   BOOL   pfmLocal = FALSE;

   if ( ! pfm )
   {
      pfm = (PFONTMETRICS) malloc ( sizeof ( FONTMETRICS ) );

      GpiQueryFontMetrics ( hps, sizeof ( FONTMETRICS ), pfm );

      pfmLocal = TRUE;
   }
   rclChk.yBottom = pRecIn->yTop - pfm->lMaxAscender;
   rclChk.yTop    = rclChk.yBottom + pfm->lLowerCaseAscent;

   xWork = pfm->lMaxCharInc - 6;

   rclChk.xLeft   = pRecIn->xLeft + 3;
   rclChk.xRight  = rclChk.xLeft + xWork;

   x3rd = xWork / 3;
   y3rd = ( rclChk.yTop - rclChk.yBottom ) / 3;

   aptl[0].x = rclChk.xLeft;
   aptl[0].y = rclChk.yBottom + y3rd;

   aptl[1].x = rclChk.xLeft + x3rd;
   aptl[1].y = rclChk.yBottom;

   aptl[2].x = rclChk.xLeft + x3rd + 3;
   aptl[2].y = rclChk.yBottom;

   aptl[3].x = rclChk.xRight;
   aptl[3].y = rclChk.yTop;

   aptl[4].x = rclChk.xLeft   + x3rd + 1;
   aptl[4].y = rclChk.yBottom + y3rd - 1;

   aptl[5] = aptl[0];

   GpiSetColor ( hps, CLR_DEFAULT ) ;

   GpiBeginPath ( hps, 1 );

   GpiMove ( hps, &aptl[0] ) ;

   GpiPolyLine ( hps, 6, aptl );

   GpiEndPath ( hps );

   GpiFillPath ( hps, 1, FPATH_ALTERNATE );

   if ( pfmLocal )
   {
      free ( pfm );
   }
}
