
#define VAR_SCOPE extern
 
#include "fsp.h"
 
//*** Prototypes *************************************************************

MRESULT EXPENTRY pfndpRefrProps  ( HWND, ULONG, MPARAM, MPARAM );

VOID             pfnShowEAs      ( HWND, PREFRREC, BOOL );
VOID             pfnCleanUp      ( PUSEREC, BOOL );
 
//*** Globals ****************************************************************

//****************************************************************************
// Reference Properties Dialog
//****************************************************************************

MRESULT EXPENTRY pfndpRefrProps      ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   PUSEREC     pRecScn;
    
   pRecScn = (PUSEREC) WinQueryWindowULong ( hwnd, QWL_USER );
    
   switch ( msg ) 
   {
       
      case WM_INITDLG:
      {
         PDATREC  pdr;
         PREFRREC prr;
         PBYTE    pbScn;

         pRecScn = PVOIDFROMMP ( mp2 );
          
         WinSetWindowULong ( hwnd, QWL_USER, (ULONG) pRecScn );
          
         pdr = pRecScn->pdr;
          
         pdr->hwndE = hwnd;//WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU );
         pfnHaveAKid ( pRecScn, TRUE );

         pdr->pszStat = malloc ( 80 );

         pdr->pvWork  = malloc ( sizeof ( REFRREC ) );

         prr = (PREFRREC) pdr->pvWork;

         //*** Load Stored Data *********************************************

         pbScn = (PBYTE) pdr->pvDat;

         prr->pszFileName = (PSZ) malloc ( strlen ( pbScn ) + 1 );
         strcpy ( prr->pszFileName, (PSZ) pbScn );
         pbScn += strlen ( prr->pszFileName ) + 1;

         prr->pszIconFile = (PSZ) malloc ( strlen ( pbScn ) + 1 );
         strcpy ( prr->pszIconFile, (PSZ) pbScn );
         pbScn += strlen ( prr->pszIconFile ) + 1;

         memcpy ( &prr->cdUpd, pbScn, sizeof ( CDATE ) );
         pbScn += sizeof ( CDATE );
          
         memcpy ( &prr->ulOpt, pbScn, sizeof ( ULONG ) );
         pbScn += sizeof ( ULONG );

         //*** Init Dialog **************************************************

         WinCheckButton    ( hwnd, DIT_REFR_DEFICON, ( prr->ulOpt & SCB_REFR_DEFICON ) ? TRUE : FALSE );

         WinSetDlgItemText ( hwnd, DIT_REFR_FILENAME, prr->pszFileName );
         WinSetDlgItemText ( hwnd, DIT_REFR_ICONFILE, prr->pszIconFile );

         //*** Load EA's from Disk and Display Them *************************

         pfnShowEAs ( hwnd, prr, FALSE );

         pfnSelEntry ( hwnd, DIT_REFR_SUBJECT );

         WinEnableControl ( hwnd, DID_OK, FALSE );
      }
      return (MRESULT)TRUE;//break;
       
      case UWM_SETRECPTR: //*** Store Data Pointer **************************
      {
         pRecScn = PVOIDFROMMP ( mp1 );
          
         WinSetWindowPtr ( hwnd, 0, pRecScn );
      }
      break;

      case UWM_SAVE:
      {
         pfnRefrSave ( pRecScn, hwnd, TRUE);
      }
      break;

      case WM_HELP:
      {
         SHORT   sId;

         sId = WinQueryWindowUShort ( hwnd, QWS_ID );

         WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                      MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
      }
      break;
       
      case WM_CONTROL:
      {
         if ( SHORT2FROMMP ( mp1 ) == EN_CHANGE || SHORT2FROMMP ( mp1 ) == MLN_CHANGE ||
              ( SHORT2FROMMP ( mp1 ) == BN_CLICKED && SHORT1FROMMP ( mp1 ) == DIT_REFR_DEFICON ) )
            if ( ! WinIsControlEnabled ( hwnd, DID_OK ) )
            {
               WinEnableControl ( hwnd, DID_OK, TRUE );
               pRecScn->pdr->fbModified = TRUE;
            }
         if ( WinSendDlgItemMsg ( hwnd, DIT_REFR_DEFICON, BM_QUERYCHECK, NULL, NULL ) )
         {
            WinEnableControl ( hwnd, DIT_REFR_ICONFILE_GET, FALSE );
            WinEnableControl ( hwnd, DIT_REFR_ICONFILE,     FALSE );
         }
         else
         {
            WinEnableControl ( hwnd, DIT_REFR_ICONFILE_GET, TRUE );
            WinEnableControl ( hwnd, DIT_REFR_ICONFILE,     TRUE );
         }
      }
      break;
       
      case WM_CLOSE:
      {
         WinSendMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( DID_CANCEL, 0 ), NULL );
      }
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
      case WM_COMMAND:
      {
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case DIT_REFR_ICONFILE_GET:
            {
               PSZ      pszFileTmp;
               PDATREC  pdr;
               PREFRREC prr;
                
               pdr = pRecScn->pdr;
             
               prr = (PREFRREC) pdr->pvWork;
             
               /*if ( *prr->pszFileName )
                  pszFileTmp = pfnFileNameBuf ( "prr->pszFileName" );
               else*/
                  pszFileTmp = pfnFileNameBuf ( "*" );
      
               if ( pfnFileDialog ( hwnd, "Get Reference Icon File", TRUE, pszFileTmp ) )
               {
                  if ( ! strlen ( pszFileTmp ) )
                  {
                     break;
                  }

                  if ( ! pfnFileExists ( pszFileTmp ) )
                  {
                     CHAR achBuf[CCHMAXPATH+80];
                     sprintf ( achBuf, "Error ! Icon file: %s not found.", pszFileTmp );
                      
                     pfnMsgOK ( hwnd, APP_TITLE, achBuf );
                     break;
                  }

                  pdr->fbModified = TRUE;

                  prr->pszIconFile = realloc ( prr->pszIconFile, strlen ( pszFileTmp ) + 1 );

                  strcpy ( prr->pszIconFile, pszFileTmp );

                  WinSetDlgItemText ( hwnd, DIT_REFR_ICONFILE, prr->pszIconFile );

                  WinEnableControl ( hwnd, DID_OK, TRUE );
               }
      
               free ( pszFileTmp );
            }
            break;
             
            case DID_CANCEL:
            {
               if ( WinIsControlEnabled ( hwnd, DID_OK ) )
               {
                  if (  pfnMsgYesNo ( hwnd, APP_TITLE,
                                      "This entry has been modified. Save changes ?" ) )
                  {
                     WinSendMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( DID_OK, 0 ), NULL );
                     break;
                  }
               }
                
               pfnCleanUp ( pRecScn, FALSE );

               WinDismissDlg ( hwnd, FALSE );
            }
            break;
             
            case DID_OK:
            {
               if ( pfnRefrSave ( pRecScn, hwnd, FALSE) )
                  WinDismissDlg ( hwnd, TRUE );
            }
            break;
             
         };
      }
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
   return (MRESULT) FALSE;
}
 
//****************************************************************************
// Show EA's
//****************************************************************************
VOID             pfnShowEAs      ( HWND hwnd, PREFRREC prr, BOOL FirstFree )
{
   if ( FirstFree )
   {
      free ( prr->pszSub      );
      free ( prr->pszKey      );
      free ( prr->pszCom      );
   }

   prr->pszSub = 0;
   prr->pszKey = 0;
   prr->pszCom = 0;

   if ( ! pfnGetStdEAs ( prr->pszFileName, &prr->pszSub, &prr->pszCom, &prr->pszKey ) )
   {
      pfnMsgOK ( hwnd, APP_TITLE,
                 "Could not get extended attributes." );
   }
   else
   {
      if ( prr->pszSub )
         WinSetDlgItemText ( hwnd, DIT_REFR_SUBJECT,  prr->pszSub      );

      if ( prr->pszKey )
         pfnImportToMLE    ( hwnd, DIT_REFR_KEYWRDS,  prr->pszKey      );
      if ( prr->pszCom )
         pfnImportToMLE    ( hwnd, DIT_REFR_COMMNTS,  prr->pszCom      );
   }
    
}

//****************************************************************************
// Save the Entry
//****************************************************************************
BOOL             pfnRefrSave         ( PUSEREC pRecScn, HWND hwnd, BOOL force )
{
   if ( hwnd )
   {
      PDATREC  pdr;
      PREFRREC prr;
      ULONG    ulLen;
      
      pdr = pRecScn->pdr;
       
      prr = (PREFRREC) pdr->pvWork;
      
      //*** File Name *************************************************
       
      /*if ( pfnExportFromEF ( hwnd, DIT_REFR_FILENAME, &prr->pszFileName, &ulLen, force ) )
      {
         if ( ulLen < 2 && ! force )
         {
            pfnMsgOK ( hwnd, APP_TITLE, "File name must be specified." );
            pfnSelEntry ( hwnd, DIT_REFR_FILENAME );
            return FALSE;
         }
      
         ++ulLen;
          
         prr->pszFileName = realloc ( prr->pszFileName, ulLen );
          
         WinQueryDlgItemText ( hwnd, DIT_REFR_FILENAME, ulLen, prr->pszFileName );
      
         pdr->ulOpts &= ~SCB_REFR_ISFILE;
         pdr->ulOpts &= ~SCB_REFR_ISPATH;

         if ( pfnFileExists ( prr->pszFileName ) )
            pdr->ulOpts |=  SCB_REFR_ISFILE;
         else if ( pfnPathExists ( prr->pszFileName ) )
            pdr->ulOpts |=  SCB_REFR_ISPATH;
         else
         {
            CHAR achBuf[CCHMAXPATH+80];
            sprintf ( achBuf, "Error ! %s not found.", prr->pszFileName );
             
            pfnMsgOK ( hwnd, APP_TITLE, achBuf );
            pfnSelEntry ( hwnd, DIT_REFR_FILENAME );
            return FALSE;
         }
      
         pdr->fbModified = TRUE;
         fbModified = TRUE;
      }*/
       
      //*** Icon File *************************************************
       
      ulLen = 0;

      if ( WinQueryButtonCheckstate ( hwnd, DIT_REFR_DEFICON ) )
         prr->ulOpt |= SCB_REFR_DEFICON;

      else if ( pfnExportFromEF ( hwnd, DIT_REFR_ICONFILE, &prr->pszIconFile, &ulLen, force ) )
      {
         if ( ulLen > 1 && ! pfnFileExists ( prr->pszIconFile ) )
         {
            CHAR achBuf[CCHMAXPATH+80];
            sprintf ( achBuf, "Error ! %s not found.", prr->pszIconFile );
             
            pfnMsgOK ( hwnd, APP_TITLE, achBuf );
            pfnSelEntry ( hwnd, DIT_REFR_ICONFILE );
            pdr->fbModified = FALSE;
            return FALSE;
         }
         else if ( ulLen )
            prr->ulOpt &= ~SCB_REFR_DEFICON;
      
         pdr->fbModified = TRUE;
         fbModified = TRUE;
      }
       
      //*** Subject ***************************************************
       
      if ( pfnExportFromEF ( hwnd, DIT_REFR_SUBJECT, &prr->pszSub, &ulLen, FALSE ) )
         pfnPutStdEA ( prr->pszFileName, ".SUBJECT", prr->pszSub );
       
      //*** Key Phrases ***********************************************
       
      if ( pfnExportFromMLE ( hwnd, DIT_REFR_KEYWRDS, &prr->pszKey, &ulLen, FALSE ) )
         pfnPutStdEA ( prr->pszFileName, ".KEYPHRASES", prr->pszKey );
       
      //*** Comments **************************************************
       
      if ( pfnExportFromMLE ( hwnd, DIT_REFR_COMMNTS, &prr->pszCom, &ulLen, FALSE ) )
         pfnPutStdEA ( prr->pszFileName, ".COMMENTS", prr->pszCom );
       
      pfnCleanUp ( pRecScn, TRUE );
   }

   return TRUE;
}

//****************************************************************************
// Clean Up from Properties Dialog
//****************************************************************************
VOID             pfnCleanUp          ( PUSEREC pRecScn, BOOL SaveIt )
{
   PDATREC  pdr;
   PREFRREC prr;
   PBYTE    pbScn;

   pdr = pRecScn->pdr;
    
   prr = (PREFRREC) pdr->pvWork;

   //*** Save the Entry ******************************************************

   if ( SaveIt )
   {
      pdr->ulDLen = strlen ( prr->pszFileName ) + 1 +
                    strlen ( prr->pszIconFile ) + 1 +
                    sizeof ( CDATE ) +
                    sizeof ( ULONG );

      pdr->pvDat = realloc ( pdr->pvDat, pdr->ulDLen );

      pbScn = (PBYTE) pdr->pvDat;

      memcpy ( pbScn, prr->pszFileName, strlen ( prr->pszFileName ) + 1 );
      pbScn += strlen ( prr->pszFileName ) + 1;
       
      memcpy ( pbScn, prr->pszIconFile, strlen ( prr->pszIconFile ) + 1 );
      pbScn += strlen ( prr->pszIconFile ) + 1;
       
      pfnSetWhen ( &prr->cdUpd, NULL );

      memcpy ( pbScn, &prr->cdUpd, sizeof ( CDATE ) );
      pbScn += sizeof ( CDATE );
       
      memcpy ( pbScn, &prr->ulOpt, sizeof ( ULONG ) );
      pbScn += sizeof ( ULONG );

      //*** Update Tree View Icon ********************************************

      if ( pdr->fbModified )
      {
         pfnRefrIcon ( pRecScn );

         WinSendMsg ( hwndC, CM_INVALIDATERECORD,
                      MPFROMP ( &pRecScn ), MPFROM2SHORT ( 1, CMA_NOREPOSITION ) );

         pdr->fbModified = FALSE;
      }
   }

   //*** Clean Up Tree Display ***********************************************

   //pdr->ulOpts &= ~SCB_OPENED;
    
   pdr->hwndD   = 0;
   pdr->hwndE   = 0;
   pfnHaveAKid ( pRecScn, FALSE );
    
   WinEnableWindowUpdate ( pdr->hwndE, FALSE );

   //pfnNodeScan  ( pdr->hwndE, SCB_FREE,
   //               pRecScn->ulType, pRecScn->pdr->pvDat );

   //free ( pdr->psSrch->pszFnd );
   //free ( pdr->psSrch );
   //free ( pdr->pszStat );
    
   /*WinSendMsg ( hwndC, CM_SETRECORDEMPHASIS,
                MPFROMP ( pRecScn ),
                MPFROM2SHORT ( FALSE, CRA_INUSE ) );*/
    
   //*** Free the Memory *****************************************************

   free ( prr->pszFileName );
   free ( prr->pszIconFile );
   free ( prr->pszSub      );
   free ( prr->pszKey      );
   free ( prr->pszCom      );

   free ( pdr->pszStat );
   free ( pdr->pvWork  );
}

//****************************************************************************
// Create New Record
//****************************************************************************
BOOL             pfnRefrNewRec   ( PUSEREC pRecScn, PSZ pszFileName )
{
   PDATREC  pdr;
   PBYTE    pbScn;
   CDATE    cdUpd;
   PULONG   pulOpts;

   pdr = pRecScn->pdr;
    
   pdr->ulDLen = strlen ( pszFileName ) + 1 +
                 1 +
                 sizeof ( CDATE ) +
                 sizeof ( ULONG );

   pdr->pvDat = (PVOID) malloc ( pdr->ulDLen );

   pbScn = (PBYTE) pdr->pvDat;

   memcpy ( pbScn, pszFileName, strlen ( pszFileName ) + 1 );
   pbScn += strlen ( pszFileName ) + 1;
    
   memcpy ( pbScn, "\0", 1 );
   pbScn += 1;
    
   pfnSetWhen ( &cdUpd, NULL );

   memcpy ( pbScn, &cdUpd, sizeof ( CDATE ) );
   pbScn += sizeof ( CDATE );
    
   pulOpts = (PULONG) pbScn;
   memcpy ( pbScn, &ulRefrOpts, sizeof ( ULONG ) );
   pbScn += sizeof ( ULONG );

 
   if ( pfnFileExists ( pszFileName ) )
   {
      *pulOpts |= SCB_REFR_ISFILE;
   }
   else if ( pfnPathExists ( pszFileName ) )
   {
      *pulOpts |= SCB_REFR_ISPATH;
   }

   if ( pfnRefrIcon ( pRecScn ) )
      WinSendMsg ( hwndC, CM_INVALIDATERECORD,
                   MPFROMP ( &pRecScn ), MPFROM2SHORT ( 1, CMA_NOREPOSITION ) );

   return TRUE;
}

//****************************************************************************
// Load Record Info Structure
//****************************************************************************
PREFRREC         pfnRefrLoadEntry    ( PUSEREC pRecScn )
{
   PDATREC  pdr;
   PREFRREC prr = 0;
   PBYTE    pbScn;

   pdr = pRecScn->pdr;
    
   prr  = (PREFRREC) malloc ( sizeof ( REFRREC ) );

   memset ( prr, 0, sizeof ( REFRREC ) );

   //*** Load Stored Data *********************************************

   pbScn = (PBYTE) pdr->pvDat;

   prr->pszFileName = (PSZ) malloc ( strlen ( pbScn ) + 1 );
   strcpy ( prr->pszFileName, (PSZ) pbScn );
   pbScn += strlen ( prr->pszFileName ) + 1;

   prr->pszIconFile = (PSZ) malloc ( strlen ( pbScn ) + 1 );
   strcpy ( prr->pszIconFile, (PSZ) pbScn );
   pbScn += strlen ( prr->pszIconFile ) + 1;

   memcpy ( &prr->cdUpd, pbScn, sizeof ( CDATE ) );
   pbScn += sizeof ( CDATE );
    
   memcpy ( &prr->ulOpt, pbScn, sizeof ( ULONG ) );
   pbScn += sizeof ( ULONG );

   //*** Load EA's from Disk ******************************************

   if ( ! pfnGetStdEAs ( prr->pszFileName, &prr->pszSub, &prr->pszCom, &prr->pszKey ) )
   {
      free ( prr );
      return 0;
   }

   //*** Done ****************************************************************

   return prr;
}

//****************************************************************************
// Free Record Info Structure
//****************************************************************************
VOID             pfnRefrFreeEntry    ( PREFRREC pr )
{
   if ( ! pr )
      return;

   if ( pr->pszFileName )
      free ( pr->pszFileName );
   if ( pr->pszIconFile )
      free ( pr->pszIconFile );
   if ( pr->pszSub )
      free ( pr->pszSub );
   if ( pr->pszKey )
      free ( pr->pszKey );
   if ( pr->pszCom )
      free ( pr->pszCom );

   free ( pr );
}

//****************************************************************************
// Clean Up from Properties Dialog
//****************************************************************************
BOOL             pfnRefrIcon         ( PUSEREC pRecScn )
{
   PSZ      pszFile;
   PSZ      pszIcon;
   PULONG   theOpts;

   pszFile = (PSZ) pRecScn->pdr->pvDat;

   pszIcon = (PSZ) ((PBYTE)pRecScn->pdr->pvDat + strlen ( pszFile ) + 1 );

   theOpts = (PULONG) ((PBYTE)pRecScn->pdr->pvDat + 
                              strlen ( pszFile ) + 1 + 
                              strlen ( pszIcon ) + 1 + sizeof (CDATE) );

   if ( *theOpts & SCB_REFR_DEFICON )
      pRecScn->crecCore.hptrIcon = hptrRefr;
   else if (*pszIcon)
      pRecScn->crecCore.hptrIcon = WinLoadFileIcon ( pszIcon, FALSE );
   else
      pRecScn->crecCore.hptrIcon = WinLoadFileIcon ( pszFile, FALSE );

   if ( pRecScn->crecCore.hptrIcon == NULLHANDLE )
      pRecScn->crecCore.hptrIcon = hptrRefr;

   return ( pRecScn->crecCore.hptrIcon != NULLHANDLE );
}

