 
#define VAR_SCOPE extern
 
#include "fsp.h"
 
VOID    FAR      pfnTextPrtThd   ( PVOID pv );

/***************************************************************************/
/* Text Window Proc                                                        */
/***************************************************************************/
MRESULT EXPENTRY pfnwpTextWin ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   PUSEREC    pRecScn = WinQueryWindowPtr ( hwnd, 0 );
    
   switch ( msg ) 
   {
      case WM_CREATE:
          
      break;
       
      case WM_ACTIVATE:
          
         if ( SHORT1FROMMP ( mp1 ) ) 
         {
            hwndFoc = HWNDFROMMP ( mp2 );
             
            WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                         MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                         MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
         }
         else 
         {
            hwndFoc = HWNDFROMMP ( mp2 );
             
            WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                         NULL, NULL );
         }
          
      break;
       
      case WM_SIZE:
          
         if ( pRecScn )
            WinSetWindowPos ( pRecScn->pdr->hwndE, 0, 0, 0,
                              SHORT1FROMMP ( mp2 ),
                              SHORT2FROMMP ( mp2 ),
                              SWP_SHOW | SWP_SIZE | SWP_MOVE );
      break;
       
      case UWM_SETRECPTR: //*** Store Data Pointer **************************
      {
         pRecScn = PVOIDFROMMP ( mp1 );
          
         WinSetWindowPtr ( hwnd, 0, pRecScn );
      }
      break;

      case UWM_PARAMS:
      {
         PDATREC  pdr;
         MRESULT  mres;
         SWP      swp;
         IPT      ipt;
         BOOL     fbRet;
         PBYTE    pbyte;
         PBYTE    pbScn;
         ULONG    ulFLen;
         ULONG    ulDLen;
         ULONG    ulELen;

         pRecScn = PVOIDFROMMP ( mp1 );
          
         WinSetWindowPtr ( hwnd, 0, pRecScn );
          
         pdr = pRecScn->pdr;
          
         pfnSetWinPos ( hwnd, pdr );
          
         pdr->hwndM = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU );
          
         pdr->pszStat = malloc ( 80 );
          
         //*** Hack Tree Shift Bug ******************************************
         if ( pRecScn == pRec )
         {
         RECTL rcl;
         WinQueryWindowRect ( hwndM, &rcl);
         WinSetWindowPos ( hwndC, 0, 0, 0,
                           rcl.xRight,
                           rcl.yTop,
                           SWP_SIZE | SWP_MOVE );
         }
         //*** Create & Init Edit *******************************************
          
         pdr->hwndE = WinCreateWindow ( hwnd, WC_MLE, NULL,
                                        MLS_VSCROLL | MLS_HSCROLL,
                                        0,0,0,0, hwnd, HWND_TOP, WID_CONT, NULL, NULL );
          
         WinQueryWindowPos ( hwnd, &swp );
          
         WinSetWindowPos ( pdr->hwndE, HWND_TOP,
                           0, 0,
                           swp.cx,
                           swp.cy,
                           SWP_SIZE | SWP_MOVE | SWP_SHOW );
         //2
         if ( pdr->ulOpts & SCB_CONVERT ) 
            WinSendMsg ( pdr->hwndE, MLM_FORMAT, MPFROMLONG ( MLFIE_CFTEXT ), NULL );
         else
            WinSendMsg ( pdr->hwndE, MLM_FORMAT, MPFROMLONG ( MLFIE_NOTRANS ), NULL );
          
         WinSendMsg ( pdr->hwndE, MLM_SETFONT, MPFROMP ( &pdr->fat ), NULL );
          
         WinSendMsg ( pdr->hwndE, MLM_SETTEXTLIMIT, MPFROMLONG ( -1 ), NULL );

         pfnSetPresColors ( pdr->hwndE, pdr->ulNBClr, pdr->ulNFClr, pdr->ulHBClr, pdr->ulHFClr );
          
         if ( ! pdr->ulDLen )
         {
            if ( ulTextOpts & SCB_TXTWRAP )
            {
               WinSendMsg ( pdr->hwndE, MLM_SETWRAP, MPFROMSHORT ( 1 ), NULL );
               pdr->ulOpts |= SCB_TXTWRAP;
            }
            else
               WinSendMsg ( pdr->hwndE, MLM_SETWRAP, MPFROMSHORT ( 0 ), NULL );
         }
         else
         {
            if ( pRecScn->pdr->ulOpts & SCB_TXTWRAP )
               WinSendMsg ( pdr->hwndE, MLM_SETWRAP, MPFROMSHORT ( 1 ), NULL );
            else
               WinSendMsg ( pdr->hwndE, MLM_SETWRAP, MPFROMSHORT ( 0 ), NULL );
         }

         //*** Set Text *****************************************************
          
         ulDLen = min ( 64000, pdr->ulDLen );
          
         pbyte = malloc ( 64000 );
          
         pbScn = pdr->pvDat;
          
         WinSendMsg ( pdr->hwndE, MLM_SETIMPORTEXPORT,
                      MPFROMP ( pbyte ),
                      MPFROMLONG ( ulDLen ) );
          
         ipt = 0L;
          
         ulFLen = 0;
          
         fbRet = TRUE;
          
         while ( fbRet ) 
         {
            memcpy ( pbyte, pbScn, ulDLen );
             
            mres = WinSendMsg ( pdr->hwndE, MLM_IMPORT,
                                MPFROMP ( &ipt ), MPFROMP ( ulDLen ) );
             
            ulELen = LONGFROMMR ( mres );
             
            if ( pdr->ulOpts & SCB_CONVERT )
               ulELen += pfnStrChrCnt ( pbyte, ulDLen, '\r' );
             
            ulFLen += ulELen;
             
            pbScn += ulELen;
             
            ulDLen = min ( 64000, ( pdr->ulDLen - ulFLen ) );
             
            if ( ! ulELen )
               fbRet = FALSE;
             
            if ( ulFLen >= pdr->ulDLen ) 
               fbRet = FALSE;
            else if ( ( ulFLen + 32000 ) > pdr->ulDLen )
               ulDLen = pdr->ulDLen - ulFLen;
         }
          
         free ( pbyte );
          
         WinSendMsg ( pdr->hwndE, MLM_SETCHANGED, MPFROMSHORT ( FALSE ), NULL );
          
         WinSendMsg ( pdr->hwndE, MLM_FORMAT, MPFROMLONG ( MLFIE_NOTRANS ), NULL );
          
         WinSetFocus ( HWND_DESKTOP, pdr->hwndE );

         //*** Create & Init Search *****************************************
          
         pdr->psSrch = malloc ( sizeof ( SRCHREC ) );
          
         memset ( pdr->psSrch, 0, sizeof ( SRCHREC ) );
          
         pdr->psSrch->hwndE = hwnd;
          
         pdr->psSrch->pszFnd = malloc ( 1 );

         *pdr->psSrch->pszFnd = 0;

         pdr->ulOpts |= SCB_OPENED;
      }
      break;
       
      case WM_INITMENU:
      {
         HWND    hwndMenu;

         WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
          
         hwndMenu = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU );
          
         if ( pRecScn->pdr->ulOpts & SCB_TXTWRAP )
            WinCheckMenuItem ( hwndMenu, MID_TEXT_WRAP, TRUE );
         else
            WinCheckMenuItem ( hwndMenu, MID_TEXT_WRAP, FALSE );
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case MID_TEXT_FILE:
               if ( pqi.pDriverData )
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_PRINT, TRUE  );
               else
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_PRINT, FALSE );
            break;
                
            case MID_TEXT_EDIT:
            {
               SHORT    sRc1;
               SHORT    sRc2;

               if (  pfnIsMyClip ( hwnd, CF_TEXT ) )
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_PASTE, TRUE );
               else
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_PASTE, FALSE );
                
               sRc1 = (SHORT) WinSendMsg ( pRecScn->pdr->hwndE, MLM_QUERYSEL,
                                           MPFROMSHORT ( MLFQS_MINSEL ), NULL );
                
               sRc2 = (SHORT) WinSendMsg ( pRecScn->pdr->hwndE, MLM_QUERYSEL,
                                           MPFROMSHORT ( MLFQS_MAXSEL ), NULL );
                
               if (  sRc1 != sRc2 ) 
               {
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_CUT,   TRUE );
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_COPY,  TRUE );
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_CLEAR, TRUE );
               }
               else 
               {
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_CUT,   FALSE );
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_COPY,  FALSE );
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_CLEAR, FALSE );
               }
                
               if ( pRecScn->pdr->psSrch->hwndS )
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_FIND, FALSE );
               else 
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_FIND, TRUE  );
                
               if ( *pRecScn->pdr->psSrch->pszFnd ) 
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_FNDNXT, TRUE );
               else 
                  WinEnableMenuItem ( hwndMenu, MID_TEXT_FNDNXT, FALSE );
            }
            break;
             
         }
      }
      break;
       
      case WM_HELP:
      {
         SHORT   sId;

         sId = WinQueryWindowUShort ( hwnd, QWS_ID );

         WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                      MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
      }
      break;
       
      case WM_COMMAND:
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case MID_TEXT_IMP:
            {
               PDATREC  pdr;
               PSZ      pszFileTmp;
               MRESULT  mres;
               IPT      ipt;
               PBYTE    pbyte;
               HFILE    hfil;
               APIRET   apiret;
               ULONG    ulBytesRead;
                
               pszFileTmp = pfnFileNameBuf ( "*.*" );
      
               if ( pfnFileDialog ( hwnd, "Import", TRUE, pszFileTmp ) )
               {
                  pdr = pRecScn->pdr;
                   
                  pbyte = malloc ( 64000 );
                   
                  WinSendMsg ( pdr->hwndE, MLM_FORMAT, MPFROMLONG ( MLFIE_CFTEXT ), NULL );
                   
                  WinSendMsg ( pdr->hwndE, MLM_SETIMPORTEXPORT,
                               MPFROMP ( pbyte ),
                               MPFROMLONG ( 1024 ) );
                   
                  mres = WinSendMsg ( pdr->hwndE, MLM_QUERYSEL, MPFROMLONG ( MLFQS_CURSORSEL ), NULL );
                   
                  ipt = LONGFROMMR ( mres );
                   
                  apiret = DosOpen ( pszFileTmp, &hfil, &ulBytesRead, 0L, 0L,
                                     OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                                     OPEN_SHARE_DENYNONE|OPEN_ACCESS_READONLY, 0L );
                   
                  if ( apiret ) 
                  {
                     pfnMsgOK (  hwnd, APP_TITLE, "Could not open file." );

                     break;
                  }
                   
                   
                  DosRead ( hfil, pbyte, 1024, &ulBytesRead );
                   
                  WinSendMsg ( pdr->hwndE, MLM_DISABLEREFRESH, NULL, NULL );
                   
                  while ( ulBytesRead ) 
                  {
                     mres = WinSendMsg ( pdr->hwndE, MLM_IMPORT,
                                         MPFROMP ( &ipt ),
                                         MPFROMLONG ( ulBytesRead /*ulFLen */ ) );
                      
                     DosRead ( hfil, pbyte, 1024, &ulBytesRead );
                  }
                   
                  DosClose ( hfil );
                   
                  free ( pbyte );
                   
                  WinSendMsg ( pdr->hwndE, MLM_ENABLEREFRESH, NULL, NULL );
                   
                  WinSendMsg ( pdr->hwndE, MLM_SETCHANGED, MPFROMSHORT ( TRUE ), NULL );
                   
                  pdr->fbModified = TRUE;
                  //fbModified      = TRUE;
                   
                  WinSendMsg ( pdr->hwndE, MLM_FORMAT, MPFROMLONG ( MLFIE_NOTRANS ), NULL );
                   
               }

               free ( pszFileTmp );
            }
            break;
             
            case MID_TEXT_EXP:
            {
               PDATREC  pdr;
               PSZ      pszFileTmp;
               MRESULT  mres;
               IPT      ipt;
               BOOL     fbRet;
               PBYTE    pbyte;
               APIRET   apiret;
               HFILE    hfil;
               ULONG    ulBytesWrit;
               ULONG    ulFLen;
               ULONG    ulDLen;
               ULONG    ulELen;
                
               pszFileTmp = pfnFileNameBuf ( "*.txt" );
      
               if ( pfnFileDialog ( hwnd, "Export", FALSE, pszFileTmp ) )
               {
                  pdr = pRecScn->pdr;
                   
                  /* Open File */
                   
                  ulBytesWrit = 0;
                   
                  apiret = DosOpen ( pszFileTmp, &hfil, &ulBytesWrit, 0L, 0L,
                                     OPEN_ACTION_REPLACE_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW,
                                     OPEN_SHARE_DENYREADWRITE|OPEN_ACCESS_WRITEONLY, 0L );
                   
                  if ( apiret ) 
                  {
                     pfnMsgOK ( hwnd, APP_TITLE, "Could not open file." );

                     break;
                  }
                   
                  //*** Get Length & Alloc **********************************
                   
                  WinSendMsg ( pdr->hwndE, MLM_FORMAT, MPFROMLONG ( MLFIE_CFTEXT ), NULL );
                   
                  mres = WinSendMsg ( pdr->hwndE, MLM_QUERYTEXTLENGTH, NULL, NULL );
                   
                  ipt = LONGFROMMR ( mres );
                   
                  mres = WinSendMsg ( pdr->hwndE, MLM_QUERYFORMATTEXTLENGTH,
                                      MPFROMLONG ( 0 ), MPFROMLONG ( ipt ) );
                   
                  ipt = LONGFROMMR ( mres );
                   
                  pdr->ulDLen = ipt;
                   
                  //*** Get Text ********************************************
                   
                  ulDLen = min ( 64000, pdr->ulDLen );
                  ipt    = 0;
                  ulFLen = 0;
                  pbyte  = malloc ( 64000 );
                  fbRet  = TRUE;
                   
                  WinSendMsg ( pdr->hwndE, MLM_SETIMPORTEXPORT,
                               MPFROMP ( pbyte ), MPFROMLONG ( 64000 ) );
                   
                  while ( fbRet ) 
                  {
                     mres = WinSendMsg ( pdr->hwndE, MLM_EXPORT,
                                         MPFROMP ( &ipt ), 
                                         MPFROMP ( &ulDLen ) );
                      
                     ulELen = LONGFROMMR ( mres );
                      
                     DosWrite ( hfil, pbyte, ulELen, &ulBytesWrit );
                      
                     ulFLen += ulELen;
                      
                     ulDLen = min ( 64000, ( pdr->ulDLen - ulFLen ) );
                      
                     if ( ulFLen >= pdr->ulDLen )
                        fbRet = FALSE;
                     else if ( ( ulFLen + ulDLen ) > pdr->ulDLen )
                        ulDLen = pdr->ulDLen - ulFLen;
                  }
                   
                  free ( pbyte );
                   
                  DosClose ( hfil );
                   
                  WinSendMsg ( pdr->hwndE, MLM_FORMAT, MPFROMLONG ( MLFIE_NOTRANS ), NULL );
                   
               }
               free ( pszFileTmp );
            }
            break;
             
            case MID_TEXT_SAVE:
                
               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
                
            break;
             
            case MID_TEXT_EXIT:

               WinPostMsg ( WinQueryWindow(hwnd,QW_PARENT), WM_SYSCOMMAND, MPFROM2SHORT ( SC_CLOSE, 0 ), NULL );

            break;
             
            case MID_TEXT_SAVE_EXIT:

               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
               WinPostMsg ( WinQueryWindow(hwnd,QW_PARENT), WM_SYSCOMMAND, MPFROM2SHORT ( SC_CLOSE, 0 ), NULL );

            break;
             
            case MID_TEXT_FONT:
            {
               PDATREC   pdr;
               HPS       hps;

               pdr = pRecScn->pdr;
               hps = WinGetPS ( pdr->hwndE );
      
               if ( pfnGetFont ( hwnd, hps, NULLHANDLE, &pdr->fxPtSz, &pdr->fat ) )
               {
                  WinSendMsg ( pdr->hwndE, MLM_SETFONT,
                               MPFROMP ( &pdr->fat ), NULL );

                  pdr->fbModified = TRUE;
               }
      
               WinReleasePS ( hps );
            }
            break;
             
            case MID_TEXT_COLOR:
                
               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpColors, 0L,
                           DLG_COLORS, &pRecScn->pdr->hwndE );
                
            break;
             
            case MID_TEXT_TITLE:
            {
               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpSetTitle, 0L, DLG_SET_TITLE, pRecScn );
            }
            break;
             
            case MID_TEXT_PRINT:
            {
               pRecPrt = pRecScn;

               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpPrint,  0L,
                           DLG_PRINT, (PVOID) pfnTextPrtThd );
            }
            break;
             
            case MID_TEXT_WRAP:
            {
               PDATREC   pdr;

               pdr = pRecScn->pdr;
                
               if ( pdr->ulOpts & SCB_TXTWRAP ) 
               {
                  pdr->ulOpts &= ~SCB_TXTWRAP;
                   
                  WinSendMsg ( pdr->hwndE, MLM_SETWRAP, MPFROMSHORT ( 0 ), NULL );
               }
               else 
               {
                  pdr->ulOpts |= SCB_TXTWRAP;
                   
                  WinSendMsg ( pdr->hwndE, MLM_SETWRAP, MPFROMSHORT ( 1 ), NULL );
               }

               pdr->fbModified = TRUE;
            }
            break;
             
            case MID_TEXT_FIND:
               
               WinLoadDlg ( HWND_DESKTOP, hwnd, pfndpSearch, 0L, DLG_SEARCH, 
                            pRecScn->pdr->psSrch );
                
            break;
             
            case MID_TEXT_FNDNXT:
                
               WinPostMsg ( hwnd, UWM_SEARCH, NULL, NULL );
                
            break;
             
            case MID_TEXT_CUT:
                
               WinSendMsg ( pRecScn->pdr->hwndE, MLM_CUT, NULL, NULL );
                
               pRecScn->pdr->fbModified = TRUE;

            break;
             
            case MID_TEXT_COPY:
                
               WinSendMsg ( pRecScn->pdr->hwndE, MLM_COPY, NULL, NULL );
                
            break;
             
            case MID_TEXT_PASTE:
                
               WinSendMsg ( pRecScn->pdr->hwndE, MLM_PASTE, NULL, NULL );
                
               pRecScn->pdr->fbModified = TRUE;

            break;
             
            case MID_TEXT_CLEAR:
                
               WinSendMsg ( pRecScn->pdr->hwndE, MLM_CLEAR, NULL, NULL );
                
               pRecScn->pdr->fbModified = TRUE;

            break;

            default:
               WinPostMsg ( hwndM, msg, mp1, mp2 );
         }
          
      break;
       
/*      case WM_CONTROL:
          
         if ( SHORT1FROMMP ( mp1 ) == WID_CONT )
         {
            switch ( SHORT2FROMMP ( mp1 ) ) 
            {
               case MLN_CHANGE:
               {
                  pRecScn->pdr->fbModified = TRUE;
                  fbModified = TRUE;
               }
               return ( MRESULT ) TRUE;
                
            }
         }
      break;*/
       
      case UWM_SAVE:
      {
         PDATREC  pdr;
         MRESULT  mres;
         IPT      ipt;
         BOOL     fbRet;
         PBYTE    pbyte;
         PBYTE    pbScn;
         ULONG    ulFLen;
         ULONG    ulDLen;
         ULONG    ulELen;

         pdr = pRecScn->pdr;
          
         pdr->ulRelRev = REL_REV;

         //*** Get Length & Alloc *******************************************
          
         //1WinSendMsg ( pdr->hwndE, MLM_FORMAT, MPFROMLONG ( MLFIE_NOTRANS ), NULL );
          
         mres = WinSendMsg ( pdr->hwndE, MLM_QUERYTEXTLENGTH, NULL, NULL );
          
         ipt = LONGFROMMR ( mres );
          
         if ( ! ( pdr->ulOpts & SCB_CONVERT ) ) 
         {
            mres = WinSendMsg ( pdr->hwndE, MLM_QUERYFORMATTEXTLENGTH,
                                MPFROMLONG ( 0 ), MPFROMLONG ( ipt ) );
             
            ipt = LONGFROMMR ( mres );
         }
          
         pdr->pvDat = realloc ( pdr->pvDat, ipt );
          
         pbScn = pdr->pvDat;
          
         pdr->ulDLen = ipt;
          
         pdr->ulDEnt = 1;
          
         //*** Get Text *****************************************************
          
         ulDLen = min ( 64000, pdr->ulDLen );
          
         ipt = 0L;
          
         ulFLen = 0;
          
         pbyte = malloc ( 64000 );
          
         WinSendMsg ( pdr->hwndE, MLM_SETIMPORTEXPORT,
                      MPFROMP ( pbyte ),
                      MPFROMLONG ( 64000 ) );
          
         fbRet = TRUE;
          
         while ( fbRet ) 
         {
            mres = WinSendMsg ( pdr->hwndE, MLM_EXPORT,
                                MPFROMP ( &ipt ),
                                MPFROMP ( &ulDLen ) );
             
            ulELen = LONGFROMMR ( mres );
             
            memcpy ( pbScn, pbyte, ulELen );
             
            ulFLen += ulELen;
            pbScn  += ulELen;
            ulDLen  = min ( 64000, ( pdr->ulDLen - ulFLen ) );
             
            if ( ulFLen >= pdr->ulDLen )
               fbRet = FALSE;
            else if ( ( ulFLen + ulDLen ) > pdr->ulDLen )
               ulDLen = pdr->ulDLen - ulFLen;
         }
          
         free ( pbyte );
          
         //2WinSendMsg ( pdr->hwndE, MLM_FORMAT, MPFROMLONG ( MLFIE_CFTEXT ), NULL );
          
         //*** Set Completion States ****************************************
          
         pdr->fbModified = FALSE;
         pfnSetWhen ( &pRecScn->cdWri, &pRecScn->ctWri );
          
         pfnGetWinPos ( hwnd, pdr );
          
         //pdr->sPtSize = pfnFmToFat ( pdr->hwndE, &pdr->fat );
         //pfnGetDefFattrs ( pdr->hwndE, NULLHANDLE, &pdr->fat, &pdr->fxPtSz );
          
         pfnGetPresColors ( pdr->hwndE, &pdr->ulNBClr, &pdr->ulNFClr, &pdr->ulHBClr, &pdr->ulHFClr );
          
         pdr->ulOpts &= ~SCB_CONVERT;
          
         fbModified = TRUE;
          
         WinSendMsg ( pdr->hwndE, MLM_SETCHANGED, MPFROMSHORT ( FALSE ), NULL );
      }
      break;
       
      case UWM_SEARCH:
      {
         PDATREC          pdr;
         MLE_SEARCHDATA   mlesd;
         ULONG            ulSrchHow;
         //MRESULT          mr;

         pdr = pRecScn->pdr;
          
         mlesd.cb        = sizeof ( MLE_SEARCHDATA );
         mlesd.pchFind   = pdr->psSrch->pszFnd;
         mlesd.cchFind   = strlen ( pdr->psSrch->pszFnd );
         mlesd.iptStart  = -1;
         mlesd.iptStop   = -1;
          
         ulSrchHow = MLFSEARCH_SELECTMATCH;
          
         if ( pdr->psSrch->fbCase )
            ulSrchHow |= MLFSEARCH_CASESENSITIVE;
          
         if ( !  WinSendMsg ( pdr->hwndE, MLM_SEARCH,
                              MPFROMLONG ( ulSrchHow ), MPFROMP ( &mlesd ) ) )
            pfnMsgOK ( hwnd, APP_TITLE, "Text not found." );
          
         /*if ( ! mlesd.cchFound && pdr->psSrch->fbWrap )
         {
            WinSendMsg ( pdr->hwndE, MLM_SETFIRSTCHAR,
                         MPFROMLONG ( 0 ), NULL );
             
            mlesd.iptStart  = -1;
            mlesd.iptStop   = -1;
             
            WinSendMsg ( pdr->hwndE, MLM_SEARCH,
                         MPFROMLONG ( ulFLen ), MPFROMP ( &mlesd ) );
             
            //WinPostMsg ( hwnd, UWM_SEARCH, NULL, NULL );
         }
          
         if ( ! mlesd.cchFound )
         {
            pfnMsgOK ( hwnd, APP_TITLE, "Text not found." );
         }*/
      }
      break;
       
      case WM_CLOSE:
      {
         PDATREC  pdr;

         pdr = pRecScn->pdr;
          
         if ( WinSendMsg ( pdr->hwndE, MLM_QUERYCHANGED, NULL, NULL ) || pdr->fbModified )
         {
            if ( pfnMsgYesNo ( hwnd, APP_TITLE,
                               "This entry has been modified. Save changes ?" ) )
               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
         }
          
         pdr->ulOpts &= ~SCB_OPENED;
          
         pdr->hwndD   = 0;
         pfnHaveAKid ( pRecScn, FALSE );
          
         free ( pdr->psSrch->pszFnd );
         free ( pdr->psSrch );
         free ( pdr->pszStat );
          
         WinSendMsg ( hwndC, CM_SETRECORDEMPHASIS,
                      MPFROMP ( pRecScn ),
                      MPFROM2SHORT ( FALSE, CRA_INUSE ) );
          
         WinDestroyWindow ( WinQueryWindow ( hwnd, QW_PARENT ) );
      }
      break;
       
      case WM_PRESPARAMCHANGED:
          
         pRecScn->pdr->fbModified = TRUE;
         fbModified = TRUE;
          
      break;
       
      case WM_ERASEBACKGROUND:
          
      return ( MRESULT ) ( TRUE );
       
      default:
      return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
       
   }
    
   return ( MRESULT ) FALSE;
    
}
//****************************************************************************
// Print Thread
//****************************************************************************
VOID    FAR      pfnTextPrtThd       ( PVOID pv )
{
   HMQ         hmq;
   PDATREC     pdr;
   LONG        lCharsOut;
   LONG        lCharsLeft = 1;
   LONG        lNewBottom;
   PSZ         psz;
   BOOL        fbCauseText = FALSE;
   CHAR        ach32[32];
   PBYTE       pbBuf;

   hmq = WinCreateMsgQueue ( WinQueryAnchorBlock ( hwndM ), 0 );

   pdr = pprtCtl->pPrtRec->pdr;

   ++pprtCtl->ulPrtPage;

   pdr->ulPrtPage = pprtCtl->ulPrtPage;

   //*** Set Entry Font *****************************************************

   if ( pprtCtl->fbNewFont )
   {
      pdr->fxPtSzPrt = pprtCtl->defPrtAll.fxPtSz;
      pdr->fatPrt    = pprtCtl->defPrtAll.fat;
   }

   if ( pdr->fxPtSzPrt )
   {
      pprtCtl->defPrtAll.fxPtSz = pdr->fxPtSzPrt;
      pprtCtl->defPrtAll.fat    = pdr->fatPrt;
   }

   pfnCvtVecFont     ( pprtCtl->hpsPrinter, 
                       pprtCtl->defPrtAll.fxPtSz,
                       &pprtCtl->defPrtAll.fat );

   pfnSetPaintFont   ( pdr->hwndD, pprtCtl->hpsPrinter, 
                       &pprtCtl->defPrtAll.fat, FONTID_ALL );

   GpiQueryFontMetrics ( pprtCtl->hpsPrinter, sizeof ( FONTMETRICS ), 
                         &pprtCtl->fmAll );

   //*** Get Text to Print **************************************************

   pbBuf = NULL;

   if ( ! pdr->hwndD )
   {
      if ( pdr->ulDLen )
         psz = (PSZ) pdr->pvDat;
      else
         psz = " ";
   }
   else
   {
      MRESULT  mres;
      IPT      ipt;
      BOOL     fbRet;
      PBYTE    pbyte;
      PBYTE    pbScn;
      ULONG    ulFLen;
      ULONG    ulDLen;
      ULONG    ulELen;
      ULONG    ulTLen;

      //*** Get Length & Alloc *******************************************
       
      //1WinSendMsg ( pdr->hwndE, MLM_FORMAT, MPFROMLONG ( MLFIE_NOTRANS ), NULL );
       
      mres = WinSendMsg ( pdr->hwndE, MLM_QUERYTEXTLENGTH, NULL, NULL );
       
      ipt = LONGFROMMR ( mres );
       
      if ( ! ( pdr->ulOpts & SCB_CONVERT ) ) 
      {
         mres = WinSendMsg ( pdr->hwndE, MLM_QUERYFORMATTEXTLENGTH,
                             MPFROMLONG ( 0 ), MPFROMLONG ( ipt ) );
          
         ipt = LONGFROMMR ( mres );
      }
       
      pbBuf = malloc ( ipt );
       
      pbScn = pbBuf;
       
      psz = pbBuf;

      ulTLen = ipt;
       
      //pdr->ulDEnt = 1;
       
      //*** Get Text *****************************************************
       
      ulDLen = min ( 64000, ulTLen );
       
      ipt = 0L;
       
      ulFLen = 0;
       
      pbyte = malloc ( 64000 );
       
      WinSendMsg ( pdr->hwndE, MLM_SETIMPORTEXPORT,
                   MPFROMP ( pbyte ),
                   MPFROMLONG ( 64000 ) );
       
      fbRet = TRUE;
       
      while ( fbRet ) 
      {
         mres = WinSendMsg ( pdr->hwndE, MLM_EXPORT,
                             MPFROMP ( &ipt ),
                             MPFROMP ( &ulDLen ) );
          
         ulELen = LONGFROMMR ( mres );
          
         memcpy ( pbScn, pbyte, ulELen );
          
         ulFLen += ulELen;
         pbScn  += ulELen;
         ulDLen  = min ( 64000, ( ulTLen - ulFLen ) );
          
         if ( ulFLen >= ulTLen )
            fbRet = FALSE;
         else if ( ( ulFLen + ulDLen ) > ulTLen )
            ulDLen = ulTLen - ulFLen;
      }
       
      free ( pbyte );
   }

   //*** Print the Text *****************************************************

   while ( lCharsLeft && fbPrinting )
   {
      //*** Print Heading ***************************************************

      if ( fbCauseText )
      {
         pfnPrintPageEject ( pdr->hwndD, pprtCtl->hpsPrinter );

         ++pprtCtl->ulPrtPage;
      }
      else
      {
         fbCauseText = TRUE;

         if ( ulTreeOpts & SCB_PRTHEAD )
         {
            pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                              &pprtCtl->defPrtHed.fat, FONTID_HED );
      
            lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter, 
                                           pprtCtl->pPrtRec->crecCore.pszTree,
                                           &pprtCtl->rclPage, &pprtCtl->fmHed,
                                           &lNewBottom, &lCharsLeft, 
                                           DT_LEFT | DT_VCENTER,
                                           FALSE, FALSE, FALSE );
      
            if ( ! lCharsOut )
               lCharsLeft = 0;

            pprtCtl->rclBody.yTop = lNewBottom - pprtCtl->fmAll.lMaxBaselineExt;
         }
      }

      //*** Print Text ******************************************************

      pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                        &pprtCtl->defPrtAll.fat, FONTID_ALL );


      lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter, psz,
                                     &pprtCtl->rclBody, &pprtCtl->fmAll,
                                     &lNewBottom, &lCharsLeft, 
                                     DT_LEFT | DT_VCENTER,
                                     FALSE, FALSE, FALSE );
   
      if ( lCharsLeft )
         psz += lCharsOut;

      //*** Print Text Number ***********************************************

      if ( ulTreeOpts & SCB_PRTPAGE )
      {
         pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                           &pprtCtl->defPrtCnt.fat, FONTID_CNT );
   
   
         sprintf ( ach32, "-  %d  -", pprtCtl->ulPrtPage );
      
         pfnPaintText ( pprtCtl->hpsPrinter, ach32, 
                        &pprtCtl->rclFoot, &pprtCtl->fmCnt,
                        DT_CENTER | DT_BOTTOM, FALSE, FALSE );
      }
   }

   //*** Clear Out **********************************************************

   if ( pbBuf )
      free ( pbBuf );

   if ( fbPrinting )
      WinPostMsg ( pprtCtl->hwndPrtDlg, UWM_DONE, NULL, NULL );

   WinDestroyMsgQueue ( hmq );

   DosPostEventSem ( evtThdDone );

   //DosExit ( EXIT_THREAD, 0 );
   _endthread ();
}
