 
#define VAR_SCOPE extern
 
#include "fsp.h"
 
//*** #define's ************************************************************* */
 
#define UWM_SHOW    WM_USER + 2
 
/***************************************************************************/
/* Set Title Dialog Proc                                                   */
/***************************************************************************/
MRESULT EXPENTRY pfndpSetTitle ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   PUSEREC  pR = (PUSEREC) WinQueryWindowULong ( hwnd, QWL_USER );
   HWND     hwndEnt;

   switch ( msg ) 
   {
      case WM_INITDLG:
      {
         HWND hwndE;

         pR = PVOIDFROMMP ( mp2 );
          
         WinSetWindowULong ( hwnd, QWL_USER, (ULONG) pR );
          
         hwndE = WinWindowFromID ( hwnd, DIT_TITLE );
          
         WinSendMsg ( hwndE, MLM_FORMAT, MPFROMLONG ( MLFIE_CFTEXT ), NULL );
          
         WinSendMsg ( hwndE, MLM_SETTEXTLIMIT, MPFROMLONG ( -1 ), NULL );
          
         if ( strcmp ( pR->crecCore.pszTree, DEF_ENT_NAME ) )
         {
            ULONG ulLen;
            IPT   ipt;

            ulLen = strlen ( pR->crecCore.pszTree );
             
            WinSendMsg ( hwndE, MLM_SETIMPORTEXPORT,
                         MPFROMP ( pR->crecCore.pszTree ), MPFROMLONG ( ulLen ) );
             
            ipt = 0;
             
            WinSendMsg ( hwndE, MLM_IMPORT, MPFROMP ( &ipt ), MPFROMLONG ( ulLen ) );
         }
      }
      break;//return (MRESULT) TRUE;
       
      case WM_HELP:
      {
         SHORT   sId;

         sId = WinQueryWindowUShort ( hwnd, QWS_ID );

         WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                      MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
      }
      break;
       
      case WM_COMMAND:
          
         switch ( COMMANDMSG(&msg)->cmd ) {
             
            case DIT_HELP:
            {
               SHORT   sId;
      
               sId = WinQueryWindowUShort ( hwnd, QWS_ID );
      
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
             
            case DID_CANCEL:

               WinDismissDlg ( hwnd, FALSE );
                
            break;
             
            case DID_OK:
            {
               HWND   hwndE = WinWindowFromID ( hwnd, DIT_TITLE );
                
               if ( WinSendMsg ( hwndE, MLM_QUERYCHANGED, NULL, NULL ) ) 
               {
                  MRESULT   mres;
                  IPT       ipt;
                  ULONG     ulLen;

                  mres = WinSendMsg ( hwndE, MLM_QUERYTEXTLENGTH, NULL, NULL );
                   
                  ipt = LONGFROMMR ( mres );
                   
                  mres = WinSendMsg ( hwndE, MLM_QUERYFORMATTEXTLENGTH,
                                      MPFROMLONG ( 0 ), MPFROMLONG ( ipt ) );
                   
                  ipt = LONGFROMMR ( mres );
                   
                  ulLen = (ULONG) ipt;
                   
                  pR->crecCore.pszTree = realloc ( pR->crecCore.pszTree, ulLen + 1 );
                   
                  pR->crecCore.pszTree[ulLen] = 0;
                   
                  WinSendMsg ( hwndE, MLM_SETIMPORTEXPORT,
                               MPFROMP ( pR->crecCore.pszTree ), MPFROMLONG ( ipt ) );
                   
                  ipt = 0;
                   
                  mres = WinSendMsg ( hwndE, MLM_EXPORT, MPFROMP ( &ipt ), MPFROMP ( &ulLen ) );
                   
                  if ( hwndEnt = pfnEntryOpen ( pR, 0 ) )
                     WinSetWindowText ( hwndEnt, pR->crecCore.pszTree );
                   
                  WinSendMsg ( hwndC, CM_INVALIDATERECORD,
                             MPFROMP ( &pR ), MPFROM2SHORT ( 1, CMA_TEXTCHANGED ) );

                  fbModified = TRUE;
      
                  if ( pR == pRec ) 
                  {
                     pfnFrameTitle ( WinQueryWindow ( hwndM, QW_PARENT ), 
                                     "PM Scrapbook", pR->crecCore.pszTree );
                  }
               }

               WinDismissDlg ( hwnd, TRUE );
            }
            break;
             
         };
          
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
    
     return FALSE;
}
 
/***************************************************************************/
/* Color Dialog Window Proc                                                */
/***************************************************************************/
MRESULT EXPENTRY pfndpColors      ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   HWND      hwndE;
   HWND      hwndV;
   MRESULT   mres;
   USHORT    usX;
   USHORT    usY;
   ULONG     ulVal;
    
   static PULONG    pulSel;
   static ULONG     ulNBOrg;
   static ULONG     ulNFOrg;
   static ULONG     ulHBOrg;
   static ULONG     ulHFOrg;
    
   hwndE = (HWND) WinQueryWindowULong ( hwnd, QWL_USER );
    
   switch ( msg ) 
   {
      case WM_INITDLG:
          
         pulSel = PVOIDFROMMP ( mp2 );
          
         hwndE = (HWND) *pulSel;
          
         WinSetWindowULong ( hwnd, QWL_USER, (ULONG) hwndE );
          
         hwndV = WinWindowFromID ( hwnd, DIT_VALSET );
          
         //*** Set Value Set ************************************************
          
         ulVal = 0;
          
         for ( usX = 0; usX < 2; ++usX ) 
         {
            for ( usY = 0; usY < 8; ++usY ) 
            {
               WinSendMsg ( hwndV, VM_SETITEM, MPFROM2SHORT ( (usX+1), (usY+1) ), MPFROMLONG ( ulVal ) );
                
               ++ulVal;
            }
         }
          
         //*** Get Current Pres Colors *************************************/
          
         WinQueryPresParam ( hwndE, PP_BACKGROUNDCOLORINDEX,       0, NULL, 4L, &ulNBOrg, QPF_NOINHERIT );
         WinQueryPresParam ( hwndE, PP_FOREGROUNDCOLORINDEX,       0, NULL, 4L, &ulNFOrg, QPF_NOINHERIT );
         WinQueryPresParam ( hwndE, PP_HILITEBACKGROUNDCOLORINDEX, 0, NULL, 4L, &ulHBOrg, QPF_NOINHERIT );
         WinQueryPresParam ( hwndE, PP_HILITEFOREGROUNDCOLORINDEX, 0, NULL, 4L, &ulHFOrg, QPF_NOINHERIT );
          
         //*** Set Sample Fields ********************************************
          
         pulSel = &ulNBOrg;
          
         WinCheckButton ( hwnd, DIT_NBG, TRUE );
          
         WinSendMsg ( hwnd, UWM_SHOW, NULL, NULL );
          
      break;//return (MRESULT) FALSE;
       
      case WM_HELP:
      {
         SHORT   sId;

         sId = WinQueryWindowUShort ( hwnd, QWS_ID );

         WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                      MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
      }
      break;
       
      case UWM_SHOW:
          
         WinSetPresParam ( WinWindowFromID ( hwnd, DIT_N_SAMP ), PP_BACKGROUNDCOLORINDEX, 4L, &ulNBOrg );
         WinSetPresParam ( WinWindowFromID ( hwnd, DIT_N_SAMP ), PP_FOREGROUNDCOLORINDEX, 4L, &ulNFOrg );
         WinSetPresParam ( WinWindowFromID ( hwnd, DIT_H_SAMP ), PP_BACKGROUNDCOLORINDEX, 4L, &ulHBOrg );
         WinSetPresParam ( WinWindowFromID ( hwnd, DIT_H_SAMP ), PP_FOREGROUNDCOLORINDEX, 4L, &ulHFOrg );
          
         usX = ( (*pulSel) < 8 ) ? 1 : 2;
         usY = ( (*pulSel) % 8 ) + 1;
          
         usY = (*pulSel);
          
          
         if ( usY < 8 ) 
            ++usY;
         else
            usY -= 7;
          
         WinSendMsg ( WinWindowFromID ( hwnd, DIT_VALSET ), VM_SELECTITEM, MPFROM2SHORT ( usX, usY ), 0L );
          
      break;
       
      case WM_CONTROL:
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case DIT_VALSET://VN_SELECT:
                
               if ( SHORT2FROMMP ( mp1 ) != VN_SELECT ) 
                  break;
                
               mres = WinSendDlgItemMsg ( hwnd, DIT_VALSET, VM_QUERYSELECTEDITEM, NULL, NULL );
                
               if ( WinQueryButtonCheckstate ( hwnd, DIT_NBG ) )
                  pulSel = &ulNBOrg;
               else if ( WinQueryButtonCheckstate ( hwnd, DIT_NFG ) )
                  pulSel = &ulNFOrg;
               else if ( WinQueryButtonCheckstate ( hwnd, DIT_HBG ) )
                  pulSel = &ulHBOrg;
               else
                  pulSel = &ulHFOrg;
                
               usX = SHORT1FROMMR ( mres );
               usY = SHORT2FROMMR ( mres );
                
               *pulSel = ( ( usX - 1 ) * 8 ) + ( usY - 1 );
                
               WinSendMsg ( hwnd, UWM_SHOW, NULL, NULL );
                
               //pfnSetPresColors ( hwndE, ulNBOrg, ulNFOrg, ulHBOrg, ulHFOrg );
                
            break;
             
            case DIT_NBG: case DIT_NFG: case DIT_HBG: case DIT_HFG://BM_SETHILITE://SETCHECK://CLICK:
                
               if ( WinQueryButtonCheckstate ( hwnd, DIT_NBG ) )
                  pulSel = &ulNBOrg;
               else if ( WinQueryButtonCheckstate ( hwnd, DIT_NFG ) )
                  pulSel = &ulNFOrg;
               else if ( WinQueryButtonCheckstate ( hwnd, DIT_HBG ) )
                  pulSel = &ulHBOrg;
               else
                  pulSel = &ulHFOrg;
                
               WinSendMsg ( hwnd, UWM_SHOW, NULL, NULL );
                
            break;
             
         };
          
      break;
       
      case WM_COMMAND:
          
         switch ( COMMANDMSG(&msg)->cmd ) 
         {
            case DIT_HELP:
            {
               SHORT   sId;
      
               sId = WinQueryWindowUShort ( hwnd, QWS_ID );
      
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
             
            case DID_CANCEL:
                
               WinDismissDlg ( hwnd, FALSE );
                
            break;
             
            case DIT_OK:
                
               pfnSetPresColors ( hwndE, ulNBOrg, ulNFOrg, ulHBOrg, ulHFOrg );
                
               WinDismissDlg ( hwnd, TRUE );
                
            break;
             
         };
          
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
    
     return FALSE;
}
 
/***************************************************************************/
/* Search Dialog Proc                                                      */
/***************************************************************************/
MRESULT EXPENTRY pfndpSearch  ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   PSRCHREC  ps = (PSRCHREC) WinQueryWindowULong ( hwnd, QWL_USER );
    
   switch ( msg ) 
   {
      case WM_INITDLG:
          
         ps = PVOIDFROMMP ( mp2 );
          
         ps->hwndS = hwnd;

         ps->fbFirst = TRUE;

         WinSetWindowULong ( hwnd, QWL_USER, (ULONG) ps );
          
         if ( *ps->pszFnd )
            WinSetDlgItemText ( hwnd, DIT_FIND, ps->pszFnd );
         else
            WinSetDlgItemText ( hwnd, DIT_FIND, pszSearch );
          
         WinSendDlgItemMsg ( hwnd, DIT_CASE, BM_SETCHECK,
                             MPFROMLONG ( ps->fbCase ), NULL );
          
         WinSendDlgItemMsg ( hwnd, DIT_WRAP, BM_SETCHECK,
                             MPFROMLONG ( ps->fbWrap ), NULL );
          
         pfnSelEntry ( hwnd, DIT_FIND );

      return (MRESULT) TRUE;
       
      case WM_HELP:
      {
         SHORT   sId;

         sId = WinQueryWindowUShort ( hwnd, QWS_ID );

         WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                      MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
      }
      break;
       
      case WM_COMMAND:
          
         switch ( COMMANDMSG(&msg)->cmd ) {
             
            case DIT_HELP:
            {
               SHORT   sId;
      
               sId = WinQueryWindowUShort ( hwnd, QWS_ID );
      
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
             
            case DID_CANCEL:

               ps->hwndS = NULLHANDLE;

               WinDismissDlg ( hwnd, FALSE );
                
            break;
             
            case DIT_OK:
            {
               ULONG     ulLen;

               ulLen = WinQueryDlgItemTextLength ( hwnd, DIT_FIND );
                
               ++ulLen;
                
               ps->pszFnd = realloc ( ps->pszFnd, ulLen );
                
               WinQueryDlgItemText ( hwnd, DIT_FIND, ulLen, ps->pszFnd );
                
               ps->fbCase = FALSE;
               ps->fbWrap = FALSE;
                
               if ( WinSendDlgItemMsg ( hwnd, DIT_CASE,  BM_QUERYCHECK, NULL, NULL ) )
                  ps->fbCase = TRUE;
                
               if ( WinSendDlgItemMsg ( hwnd, DIT_WRAP,  BM_QUERYCHECK, NULL, NULL ) ) 
                  ps->fbWrap = TRUE;
                
               WinPostMsg ( ps->hwndE, UWM_SEARCH, PVOIDFROMMP ( ps ), NULL );
            }
            break;
             
         };
          
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
    
     return FALSE;
}
 
/***************************************************************************/
/* Date Edit Dialog Window Proc                                            */
/***************************************************************************/
MRESULT EXPENTRY pfndpEditDate    ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   ULONG     ulVal;
   PDATEREC  pd;
   CDATE     cd;
    
   pd = (PDATEREC) WinQueryWindowULong ( hwnd, QWL_USER );
    
   switch ( msg ) 
   {
      case WM_INITDLG:
          
         pd = PVOIDFROMMP ( mp2 );
          
         WinSetWindowULong ( hwnd, QWL_USER, (ULONG) pd );
          
         WinSetWindowText ( hwnd, pd->pszTtl );
          
         if ( ! pd->pcdate->year ) 
            pfnSetWhen ( &cd, NULL );
         else 
            cd = *pd->pcdate;
          
         WinSendDlgItemMsg ( hwnd, DIT_YEAR,  SPBM_SETLIMITS, MPFROMLONG ( 3000L ), MPFROMLONG ( 1900L ) );
         WinSendDlgItemMsg ( hwnd, DIT_YEAR,  SPBM_SETCURRENTVALUE, (MPARAM) cd.year, NULL );
          
         WinSendDlgItemMsg ( hwnd, DIT_MONTH, SPBM_SETLIMITS, MPFROMLONG ( 12L ), MPFROMLONG ( 1L ) );
         WinSendDlgItemMsg ( hwnd, DIT_MONTH, SPBM_SETCURRENTVALUE, (MPARAM) cd.month, NULL );
          
         WinSendDlgItemMsg ( hwnd, DIT_DAY,   SPBM_SETLIMITS, MPFROMLONG ( 31L ), MPFROMLONG ( 1L ) );
         WinSendDlgItemMsg ( hwnd, DIT_DAY,   SPBM_SETCURRENTVALUE, (MPARAM) cd.day, NULL );
          
      return (MRESULT) TRUE;
       
      case WM_HELP:
      {
         SHORT   sId;

         sId = WinQueryWindowUShort ( hwnd, QWS_ID );

         WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                      MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
      }
      break;
       
      case WM_COMMAND:
          
         switch ( COMMANDMSG(&msg)->cmd ) 
         {
            case DIT_HELP:
            {
               SHORT   sId;
      
               sId = WinQueryWindowUShort ( hwnd, QWS_ID );
      
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
             
            case DID_CANCEL:
                
               WinDismissDlg ( hwnd, FALSE );
                
            break;
             
            case DIT_OK:
                
               ulVal = 0;
                
               WinSendDlgItemMsg ( hwnd, DIT_YEAR,  SPBM_QUERYVALUE, MPFROMP ( &ulVal ), MPFROM2SHORT ( NULL, SPBQ_UPDATEIFVALID ) );
               pd->pcdate->year = ulVal;
                
               WinSendDlgItemMsg ( hwnd, DIT_MONTH, SPBM_QUERYVALUE, MPFROMP ( &ulVal ), MPFROM2SHORT ( NULL, SPBQ_UPDATEIFVALID ) );
               pd->pcdate->month = ulVal;
                
               WinSendDlgItemMsg ( hwnd, DIT_DAY,   SPBM_QUERYVALUE, MPFROMP ( &ulVal ), MPFROM2SHORT ( NULL, SPBQ_UPDATEIFVALID ) );
               pd->pcdate->day = ulVal;
                
               WinDismissDlg ( hwnd, TRUE );
                
            break;
             
         };
          
      break;
       
      case WM_CONTROL:
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case DIT_MONTH: case DIT_DAY:
                
               switch ( SHORT2FROMMP ( mp1 ) ) 
               {
                  case SPBN_CHANGE:
                      
                     WinSendDlgItemMsg ( hwnd, DIT_MONTH, SPBM_QUERYVALUE, MPFROMP ( &ulVal ), MPFROM2SHORT ( NULL, SPBQ_UPDATEIFVALID ) );
                     cd.month = ulVal;
                      
                     switch ( cd.month ) 
                     {
                        case 1: case 3: case 5: case 7: case 8: case 10: case 12:
                            
                           WinSendDlgItemMsg ( hwnd, DIT_DAY,   SPBM_SETLIMITS, MPFROMLONG ( 31L ), MPFROMLONG ( 1L ) );
                            
                        break;
                         
                        case 2:
                            
                           WinSendDlgItemMsg ( hwnd, DIT_YEAR,  SPBM_QUERYVALUE, MPFROMP ( &ulVal ), MPFROM2SHORT ( NULL, SPBQ_UPDATEIFVALID ) );
                            
                           if ( ( ulVal % 4 ) ) 
                              WinSendDlgItemMsg ( hwnd, DIT_DAY,   SPBM_SETLIMITS, MPFROMLONG ( 29L ), MPFROMLONG ( 1L ) );
                           else 
                              WinSendDlgItemMsg ( hwnd, DIT_DAY,   SPBM_SETLIMITS, MPFROMLONG ( 28L ), MPFROMLONG ( 1L ) );
                            
                        break;
                         
                        default:
                            
                           WinSendDlgItemMsg ( hwnd, DIT_DAY,   SPBM_SETLIMITS, MPFROMLONG ( 30L ), MPFROMLONG ( 1L ) );
                            
                        break;
                         
                     }
                      
                  break;
                   
               }
                
            break;
             
         }
          
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
    
     return FALSE;
}

//****************************************************************************
// About Proc
//****************************************************************************
MRESULT EXPENTRY pfndpAbout          ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
    
   switch ( msg ) {
       
      case WM_INITDLG:
          
         WinSetWindowText ( WinWindowFromID ( hwnd, DIT_VERSION ),
                            VERSION_STR );

         if ( fbUnregistered )
            WinSetWindowText ( WinWindowFromID ( hwnd, DIT_REGISTERED ),
                               "Unregistered Copy" );
         else
         {
            WinSetWindowText ( WinWindowFromID ( hwnd, DIT_REGISTERED ),
                               "Registered Copy - Thanks !" );

            WinShowWindow ( WinWindowFromID ( hwnd, DIT_REGINFO ), FALSE );
         }
          
      break;
       
      case WM_COMMAND:
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case DIT_HELP:
            {
               SHORT   sId;
      
               sId = WinQueryWindowUShort ( hwnd, QWS_ID );
      
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
             
            case DID_OK:
                
               WinDismissDlg ( hwnd, TRUE );
                
            break;

            case DIT_REGINFO:
                
               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpRegInfo,
                           0L, DLG_REGINFO, NULL );
            break;

            case DIT_REGISTER:
               if ( WinDlgBox ( HWND_DESKTOP, hwnd, pfndpRegister,
                           0L, DLG_REGISTER, NULL ) )
                  WinDismissDlg ( hwnd, TRUE );

            break;
             
         }
          
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
    
     return ( MRESULT ) FALSE;
}
 
//****************************************************************************
// Registration Info
//****************************************************************************
MRESULT EXPENTRY pfndpRegInfo        ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    
   switch ( msg ) {
       
      case WM_INITDLG:
          
      break;
       
      case WM_COMMAND:
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case DIT_HELP:
            {
               SHORT   sId;
      
               sId = WinQueryWindowUShort ( hwnd, QWS_ID );
      
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
             
            case DID_OK:
                
               WinDismissDlg ( hwnd, TRUE );
                
            break;
         }
          
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
    
     return ( MRESULT ) FALSE;
}
 
/***************************************************************************/
/* Guess a Printer Font                                                    */
/***************************************************************************/
VOID             pfnGuessPrintFattr( PFATTRS pfat )
{
   memset ( pfat, 0, sizeof ( FATTRS ) );

   pfat->usRecordLength = sizeof ( FATTRS );
   pfat->fsSelection    = 64;
   pfat->lMatch         = 0;
   pfat->idRegistry     = 0;
   pfat->usCodePage     = 850;
   pfat->lMaxBaselineExt= 10;
   pfat->lAveCharWidth  = 10;
   pfat->fsType         = 0;
   pfat->fsFontUse      = 4;

   strcpy ( pfat->szFacename, "Times New Roman" );
}
 
/***************************************************************************/
/* Setup New Print Control Record                                          */
/***************************************************************************/
VOID             pfnNewPrintCtl   ( HWND hwnd )
{
   ULONG   ulSize;

   pprtCtl = (PPRINTCTL) malloc ( sizeof ( PRINTCTL ) );

   memset ( pprtCtl, 0, sizeof ( PRINTCTL ) );

   pprtCtl->hwndPrtDlg = hwnd;
   pprtCtl->ulPrtPage  = 0;
   pprtCtl->pPrtRec    = pRecPrt;
    
   //*** Default All Font ***************************************************

   ulSize = sizeof ( DEFAULTREC );

   if ( ! PrfQueryProfileData ( HINI_USERPROFILE, PRG_TITLE, FONT_ALL_KEY,
                                &pprtCtl->defPrtAll, &ulSize ) )
   {
      //pfnGetDefFattrs ( WinQueryWindow ( hwndM, QW_PARENT ), NULLHANDLE,
        //                &pprtCtl->defPrtAll.fat, &pprtCtl->defPrtAll.fxPtSz );

      pfnGuessPrintFattr ( &pprtCtl->defPrtAll.fat );
      pprtCtl->defPrtAll.fxPtSz = 0x000A0000;
       
      pprtCtl->defPrtAll.ulOpts  = 0;
      pprtCtl->defPrtAll.ulStyl  = 0;
       
      pprtCtl->defPrtAll.ulNBClr = CLR_BACKGROUND;
      pprtCtl->defPrtAll.ulNFClr = CLR_NEUTRAL;
      pprtCtl->defPrtAll.ulHBClr = CLR_DARKGRAY;
      pprtCtl->defPrtAll.ulHFClr = CLR_BACKGROUND;
   }

   pprtCtl->defPrtTmp.fat    = pprtCtl->defPrtAll.fat;
   pprtCtl->defPrtTmp.fxPtSz = pprtCtl->defPrtAll.fxPtSz;
       
   //*** Default Heading Font ***********************************************

   ulSize = sizeof ( DEFAULTREC );

   if ( ! PrfQueryProfileData ( HINI_USERPROFILE, PRG_TITLE, FONT_HED_KEY,
                                &pprtCtl->defPrtHed, &ulSize ) )
   {
      //pfnGetDefFattrs ( WinQueryWindow ( hwndM, QW_PARENT ), NULLHANDLE,
        //                &pprtCtl->defPrtHed.fat, &pprtCtl->defPrtHed.fxPtSz );

      pfnGuessPrintFattr ( &pprtCtl->defPrtHed.fat );
      pprtCtl->defPrtHed.fxPtSz = 0x00120000;
       
      pprtCtl->defPrtHed.ulOpts  = 0;
      pprtCtl->defPrtHed.ulStyl  = 0;
       
      pprtCtl->defPrtHed.ulNBClr = CLR_BACKGROUND;
      pprtCtl->defPrtHed.ulNFClr = CLR_NEUTRAL;
      pprtCtl->defPrtHed.ulHBClr = CLR_DARKGRAY;
      pprtCtl->defPrtHed.ulHFClr = CLR_BACKGROUND;
   }

   //*** Default Contents Font **********************************************

   ulSize = sizeof ( DEFAULTREC );

   if ( ! PrfQueryProfileData ( HINI_USERPROFILE, PRG_TITLE, FONT_CNT_KEY,
                                &pprtCtl->defPrtCnt, &ulSize ) )
   {
      //pfnGetDefFattrs ( WinQueryWindow ( hwndM, QW_PARENT ), NULLHANDLE,
        //                &pprtCtl->defPrtCnt.fat, &pprtCtl->defPrtCnt.fxPtSz );

      pfnGuessPrintFattr ( &pprtCtl->defPrtCnt.fat );
      pprtCtl->defPrtCnt.fxPtSz = 0x00120000;
       
      pprtCtl->defPrtCnt.ulOpts  = 0;
      pprtCtl->defPrtCnt.ulStyl  = 0;
       
      pprtCtl->defPrtCnt.ulNBClr = CLR_BACKGROUND;
      pprtCtl->defPrtCnt.ulNFClr = CLR_NEUTRAL;
      pprtCtl->defPrtCnt.ulHBClr = CLR_DARKGRAY;
      pprtCtl->defPrtCnt.ulHFClr = CLR_BACKGROUND;
   }
}
 
/***************************************************************************/
/* Setup Print Boundries                                                   */
/***************************************************************************/
VOID             pfnPrintBounds   ( HWND hwnd )
{
   pprtCtl->rclPage.xLeft   = pprtCtl->hci.xLeftClip;
   pprtCtl->rclPage.xRight  = pprtCtl->hci.xRightClip;
   pprtCtl->rclPage.yBottom = pprtCtl->hci.yBottomClip;
   pprtCtl->rclPage.yTop    = pprtCtl->hci.yTopClip;

   pprtCtl->rclBody = pprtCtl->rclPage;
   pprtCtl->rclFoot = pprtCtl->rclPage;

   if ( ulTreeOpts & SCB_PRTPAGE )
   {
      pprtCtl->rclFoot.yTop    = pprtCtl->rclFoot.yBottom +
                                 pprtCtl->defPrtCnt.fat.lMaxBaselineExt * 2;

      pprtCtl->rclBody.yBottom = pprtCtl->rclFoot.yTop;
   }
}
/***************************************************************************/
/* Set Current Date and/or Time                                            */
/***************************************************************************/
VOID             pfnSetWhen       ( PCDATE pcd, PCTIME pct ) 
{
   DATETIME ddt;
    
   DosGetDateTime ( &ddt );
    
   if ( pcd ) 
   {
      pcd->day   = ddt.day;
      pcd->month = ddt.month;
      pcd->year  = ddt.year;
   }
    
   if ( pct ) 
   {
      pct->hours   = ddt.hours;
      pct->minutes = ddt.minutes;
      pct->seconds = ddt.seconds;
   }
    
   return;
}

//****************************************************************************
// Fix Container Columns
//****************************************************************************
VOID             pfnFixCnrCols       ( PUSEREC pRecIn, USHORT usId, BOOL fbVisible )
{
   FIELDINFOINSERT   fInfIns;
   SHORT             sX;
   PDATREC           pdr;
    
   pdr = pRecIn->pdr;
    
   pdr->colInfo[usId].fbVisible = fbVisible;

   if ( ! fbVisible )
   {
      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[usId].pfinf ),
                   MPFROM2SHORT ( 1, CMA_INVALIDATE ) );
   }
   else
   {
      fInfIns.cb                   = sizeof ( FIELDINFOINSERT );
      fInfIns.pFieldInfoOrder      = NULL;//(PFIELDINFO)CMA_END;
      fInfIns.cFieldInfoInsert     = 1;
      fInfIns.fInvalidateFieldInfo = TRUE;
      
      if ( ! usId )
         fInfIns.pFieldInfoOrder = (PFIELDINFO)CMA_FIRST;
      else
         for ( sX = usId - 1; sX >= 0 && ! fInfIns.pFieldInfoOrder; --sX )
            if ( pdr->colInfo[sX].fbVisible )
               fInfIns.pFieldInfoOrder = pdr->colInfo[sX].pfinf;
      
      if ( ! fInfIns.pFieldInfoOrder )
         fInfIns.pFieldInfoOrder = (PFIELDINFO)CMA_FIRST;

      WinSendMsg ( pdr->hwndE, CM_INSERTDETAILFIELDINFO,
                   MPFROMP ( pdr->colInfo[usId].pfinf ), MPFROMP ( &fInfIns ) );
   }

   if ( fbVisible )
      pdr->ulStyl |= pdr->colInfo[usId].ulShowMask;
   else
      pdr->ulStyl &= ~pdr->colInfo[usId].ulShowMask;

   return;
}

/***************************************************************************/
/* Set Window Position                                                     */
/***************************************************************************/
VOID             pfnSetWinPos     ( HWND hwnd, PDATREC pdr ) 
{
   SWP  swp;
   HWND hwndPar;
   BOOL fbSet = FALSE;
   //CHAR ach80[81];
    
   if ( pdr->ulDLen ) 
   {
      pdr->swp.fl |= ( SWP_SHOW | SWP_ZORDER | SWP_SIZE | SWP_MOVE | SWP_ACTIVATE );
      pdr->swp.fl &= ~SWP_RESTORE;

      pdr->swp.hwndInsertBehind = NULLHANDLE;

      WinQueryWindowPos ( WinQueryWindow ( pdr->hwndD, QW_PARENT ), &swp );
       
      if ( ( pdr->swp.x + pdr->swp.cx ) > ( swp.x + swp.cx ) ||
           ( pdr->swp.y + pdr->swp.cy ) > ( swp.x + swp.cy ) ||
           ( pdr->swp.y < 0          ) || ( swp.x < 0      ) )
      {
         //if ( ulTreeOpts & SCB_WINOWN )
            fbSet = FALSE;
         /*else
            fbSet = TRUE;*/
      }
      else if ( ( ! pdr->swp.cx ) || ( ! swp.cy ) ) 
         fbSet = FALSE;
      else if ( WinSetWindowPos ( pdr->hwndD, HWND_TOP,
                             pdr->swp.x,
                             pdr->swp.y,
                             pdr->swp.cx,
                             pdr->swp.cy,
                             pdr->swp.fl ) ) 
      {
         fbSet = TRUE;
          
         if ( (pdr->swp.fl & SWP_MINIMIZE) || (pdr->swp.fl & SWP_MAXIMIZE) ) 
         {
            WinSetWindowUShort ( WinQueryWindow ( pdr->hwndD, QW_PARENT ), QWS_XRESTORE,  pdr->swp.x  );
            WinSetWindowUShort ( WinQueryWindow ( pdr->hwndD, QW_PARENT ), QWS_YRESTORE,  pdr->swp.y  );
            WinSetWindowUShort ( WinQueryWindow ( pdr->hwndD, QW_PARENT ), QWS_CXRESTORE, pdr->swp.cx );
            WinSetWindowUShort ( WinQueryWindow ( pdr->hwndD, QW_PARENT ), QWS_CYRESTORE, pdr->swp.cy );
         }
      }
      else 
         fbSet = FALSE;
   }
    
   if ( ! fbSet ) 
   {
      WinQueryWindowPos ( WinQueryWindow ( pdr->hwndD, QW_PARENT ), &pdr->swp );
       
      if ( ( ! pdr->swp.cx ) || ( ! swp.cy ) ||
           (pdr->swp.fl & SWP_MINIMIZE) || (pdr->swp.fl & SWP_MAXIMIZE)) 
      {
         hwndPar = WinQueryWindow ( pdr->hwndD, QW_PARENT );
          
         pdr->swp.x  = WinQueryWindowUShort ( hwndPar, QWS_XRESTORE  );
         pdr->swp.y  = WinQueryWindowUShort ( hwndPar, QWS_YRESTORE  );
         pdr->swp.cx = WinQueryWindowUShort ( hwndPar, QWS_CXRESTORE );
         pdr->swp.cy = WinQueryWindowUShort ( hwndPar, QWS_CYRESTORE );

         WinQueryWindowPos ( hwndPar, &pdr->swp );
      }
       
      pdr->swp.x = pdr->swp.cx / 4;
      pdr->swp.y = pdr->swp.cy / 4;
      pdr->swp.cx /= 2;
      pdr->swp.cy /= 4;
      pdr->swp.cy *= 3;
       
      WinSetWindowPos ( pdr->hwndD, HWND_TOP,
                        pdr->swp.x,
                        pdr->swp.y,
                        pdr->swp.cx,
                        pdr->swp.cy,
                        SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ZORDER);
   }
    
   return;
}
 
/***************************************************************************/
/* Get Window Position                                                     */
/***************************************************************************/
VOID             pfnGetWinPos     ( HWND hwnd, PDATREC pdr ) 
{
   WinQueryWindowPos ( pdr->hwndD, &pdr->swp );
    
   if ( (pdr->swp.fl & SWP_MINIMIZE) || (pdr->swp.fl & SWP_MAXIMIZE) ) 
   {
      pdr->swp.x  = WinQueryWindowUShort ( pdr->hwndD, QWS_XRESTORE  );
      pdr->swp.y  = WinQueryWindowUShort ( pdr->hwndD, QWS_YRESTORE  );
      pdr->swp.cx = WinQueryWindowUShort ( pdr->hwndD, QWS_CXRESTORE );
      pdr->swp.cy = WinQueryWindowUShort ( pdr->hwndD, QWS_CYRESTORE );
   }
    
   return;
}
 
/***************************************************************************/
/* Set Presentation Colors                                                 */
/***************************************************************************/
BOOL             pfnSetPresColors ( HWND hwnd, ULONG ulNB, ULONG ulNF, ULONG ulHB, ULONG ulHF ) 
{
   LONG nbRGB, nfRGB, hbRGB, hfRGB;

   HPS hps = WinGetPS ( hwnd );

   nbRGB = GpiQueryRGBColor ( hps, 0, PP_BACKGROUNDCOLORINDEX       );
   nfRGB = GpiQueryRGBColor ( hps, 0, PP_FOREGROUNDCOLORINDEX       );
   hbRGB = GpiQueryRGBColor ( hps, 0, PP_HILITEBACKGROUNDCOLORINDEX );
   hfRGB = GpiQueryRGBColor ( hps, 0, PP_HILITEFOREGROUNDCOLORINDEX );

   if ( ( nbRGB == nfRGB ) || ( hbRGB == hfRGB ) )
      pfnMsgOK ( hwnd, APP_TITLE, 
                 "Entry colors may require adjusting. Non-contrasting colors found." );

   WinReleasePS ( hps );

   WinSetPresParam ( hwnd, PP_BACKGROUNDCOLORINDEX,       4L, &ulNB );
    
   WinSetPresParam ( hwnd, PP_FOREGROUNDCOLORINDEX,       4L, &ulNF );
    
   WinSetPresParam ( hwnd, PP_HILITEBACKGROUNDCOLORINDEX, 4L, &ulHB );
    
   WinSetPresParam ( hwnd, PP_HILITEFOREGROUNDCOLORINDEX, 4L, &ulHF );
    
   return TRUE;
}
 
/***************************************************************************/
/* Get Presentation Colors                                                 */
/***************************************************************************/
BOOL             pfnGetPresColors ( HWND hwnd, PULONG pulNB, PULONG pulNF, PULONG pulHB, PULONG pulHF ) 
{
   if ( pulNB )
      WinQueryPresParam ( hwnd, PP_BACKGROUNDCOLORINDEX,       0, NULL, 4L, pulNB, QPF_NOINHERIT );
    
   if ( pulNF )
      WinQueryPresParam ( hwnd, PP_FOREGROUNDCOLORINDEX,       0, NULL, 4L, pulNF, QPF_NOINHERIT );
    
   if ( pulHB )
      WinQueryPresParam ( hwnd, PP_HILITEBACKGROUNDCOLORINDEX, 0, NULL, 4L, pulHB, QPF_NOINHERIT );
    
   if ( pulHF )
      WinQueryPresParam ( hwnd, PP_HILITEFOREGROUNDCOLORINDEX, 0, NULL, 4L, pulHF, QPF_NOINHERIT );
    
   return TRUE;
}
 
/***************************************************************************/
/* Set Frame Title                                                         */
/***************************************************************************/
BOOL             pfnFrameTitle    ( HWND hwnd, PSZ pszApp, PSZ pszHuh ) 
{
   ULONG   ulLen;
   PSZ     pszBuf;
    
   ulLen = strlen ( pszApp ) + 8;
    
   if ( pszHuh )
      ulLen += CCHMAXPATH;
   else
      ulLen += CCHMAXPATH;

   pszBuf = malloc ( ulLen );
    
   if ( ( ulTreeOpts & SCB_TITFILE ) && *pszCurrFile )
      sprintf ( pszBuf, "%s - %s", pszApp, pszCurrFile );
   else
      sprintf ( pszBuf, "%s - %s", pszApp, pRec->crecCore.pszTree );
    
   WinSetWindowText ( hwnd, pszBuf );
    
   free ( pszBuf );
    
   return TRUE;
}

/***************************************************************************/
/* Search a String for a String                                            */
/***************************************************************************/
PSZ              pfnStrSearch     ( PSZ pszBuf, ULONG ulBLen, PSZ pszStr, ULONG ulSLen, BOOL fbCase ) 
{
   ULONG       ulX;
   PSZ         pszScn;
   PSZ         pszRet;
    
   //*** Get Sizes **********************************************************
    
   if ( ! pszBuf || ! pszStr ) 
      return NULL;
    
   if ( ! ulBLen )
      ulBLen = strlen ( pszBuf );
    
   if ( ! ulSLen )
      ulSLen = strlen ( pszStr );
    
   if ( ! ulBLen || ! ulSLen )
      return NULL;
    
   if ( ulSLen > ulBLen )
      return NULL;
    
   //*** Get Ready **********************************************************
    
   pszRet = NULL;
   pszScn = pszBuf;
   ulX    = 0;
    
   while ( ulX <= ( ulBLen - ulSLen ) && ! pszRet )
   {
      if ( fbCase ) 
      {
         if ( ! strncmp ( pszScn, pszStr, ulSLen ) ) 
         {
            pszRet = pszScn;
             
         }
      }
      else 
      {
         if ( ! strnicmp ( pszScn, pszStr, ulSLen ) ) 
         {
            pszRet = pszScn;
         }
      }
       
      ++ulX;
      ++pszScn;
       
   }
    
   return pszRet;
}
 
/***************************************************************************/
/* Count Occurrences of a Character in a String                            */
/***************************************************************************/
ULONG            pfnStrChrCnt     ( PSZ pszBuf, ULONG ulBLen, CHAR chHuh ) 
{
   ULONG       ulX;
   ULONG       ulRet;
   PSZ         pszScn;
    
   if ( ! pszBuf )
      return 0;
    
   if ( ! ulBLen )
      ulBLen = strlen ( pszBuf );
    
   pszScn = pszBuf;
   ulRet  = 0;
   ulX    = 0;
    
   while ( ulX < ulBLen ) 
   {
      if ( *pszScn == chHuh ) 
         ++ulRet;
       
      ++ulX;
      ++pszScn;
   }
    
   return ulRet;
}
 
/***************************************************************************/
/* Register the Product                                                    */
/***************************************************************************/
MRESULT EXPENTRY pfndpRegister  ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{      
   MRESULT mr = MRFROMLONG ( FALSE );

   switch ( msg )
   {
      case WM_INITDLG:
      {
         //mr = MRFROMLONG ( TRUE );
      }
      break;
       
      case WM_COMMAND:
      {
         CHAR theName[80];
         CHAR theCode[80];

         switch ( SHORT1FROMMP ( mp1 ) )
         {
            case DID_CANCEL:
            {
               WinDismissDlg ( hwnd, FALSE );
            }
            break;

            case DID_OK:
            {
               WinQueryDlgItemText ( hwnd, DIT_CUSTOMER, 80, theName );
               WinQueryDlgItemText ( hwnd, DIT_KEY,      80, theCode );

               if ( keyIsValid ( theName, theCode ) )
               {
                  //WinSetDlgItemText   ( hwnd, DIT_MSG, "Key matches." );
                  colStrs.regCode = REGED_CODE;
                  if ( pfnSaveOpts () )
                  {
                     pfnMsgOK ( hwnd, APP_TITLE, "Thank you for registering PM Scrapbook !" );
                     WinDismissDlg ( hwnd, TRUE );
                  }
                  else
                     pfnMsgOK ( hwnd, APP_TITLE, "An error occurred registering PM Scrapbook !" );
               }
               else
                  pfnMsgOK ( hwnd, APP_TITLE, "Invalid name and/or key entered. Please try again." );
                  //WinSetDlgItemText   ( hwnd, DIT_MSG, "Invalid key !" );
            }
            break;
         }
      }
      break;

      default:
      {
         mr = WinDefDlgProc ( hwnd, msg, mp1, mp2 );
      }
      break;           
   }
   return mr;
}
