 
#define VAR_SCOPE extern
 
#include "fsp.h"
 
//*** #define's ************************************************************* */
 
#define UWM_SHOW    WM_USER+1
 
#define MINI_ATTR   1
#define MINI_SHOW   2
 
//*** typedef's ************************************************************* */
 
typedef struct _MAINTREC 
{
   MINIRECORDCORE  crecCore;
   //ULONG           ulX;
   PMCOLREC    pcol;

}  MAINTREC, *PMAINTREC;
 
//*** Prototypes ************************************************************ */

MRESULT EXPENTRY pfndpColMaint   ( HWND, ULONG, MPARAM, MPARAM );
 
BOOL             pfnSetSplit     ( HWND, PDATREC, BOOL );
USHORT           pfnWhichSplit   ( HWND, PDATREC, SHORT, PMCTLREC );
PFIELDINFO       pfnCol2FInfo    ( HWND, PMCOLREC, PFIELDINFO, PFIELDINFO );
ULONG            pfnMiniRecMem   ( HWND, PMINIREC, ULONG, PBYTE );
 
BOOL             pfnMiniStat     ( PUSEREC );
PBYTE            pfnMiniCont     ( HWND, PUSEREC );
VOID             pfnMiniMenu     ( PUSEREC, HWND, SHORT );
VOID             pfnInitStrings  ( PMINIREC );
 
VOID             pfnMiniNewPage  ( BOOL );
VOID             pfnMiniPrintInit( VOID );

SHORT   APIENTRY pfnMiniSort     ( PRECORDCORE, PRECORDCORE, PVOID );
VOID             pfnMiniPrtThd   ( PVOID );
 
/***************************************************************************/
/* Mini Window Proc                                                        */
/***************************************************************************/
MRESULT EXPENTRY pfnwpMiniWin ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   PUSEREC    pRecScn = WinQueryWindowPtr ( hwnd, 0 );
    
   switch ( msg ) 
   {
      case WM_CREATE:
          
      break;
       
      case WM_ACTIVATE:
          
         if ( SHORT1FROMMP ( mp1 ) ) 
         {
            hwndFoc = HWNDFROMMP ( mp2 );
             
            WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                         MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                         MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
         }
         else 
         {
            hwndFoc = HWNDFROMMP ( mp2 );
             
            WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                         NULL, NULL );
         }
          
      break;
       
      case WM_SIZE:
          
         if ( pRecScn )
            WinSetWindowPos ( pRecScn->pdr->hwndE, 0, 0, 0,
                              SHORT1FROMMP ( mp2 ),
                              SHORT2FROMMP ( mp2 ),
                              SWP_SHOW | SWP_SIZE | SWP_MOVE );
          
      break;
       
      case UWM_SETRECPTR: //*** Store Data Pointer **************************
      {
         pRecScn = PVOIDFROMMP ( mp1 );
          
         WinSetWindowPtr ( hwnd, 0, pRecScn );
      }
      break;

      case UWM_PARAMS:                  
      {
         ULONG             ulX;
         PBYTE             pbDat;
         ULONG             ulLen;
         PMINIREC          pNew;
         RECORDINSERT      recins;
         PDATREC           pdr;

         //*** Store Data Pointer *******************************************
          
         pRecScn = PVOIDFROMMP ( mp1 );
          
         WinSetWindowPtr ( hwnd, 0, pRecScn );
          
         pdr = pRecScn->pdr;
          
         pdr->pvWork = malloc ( sizeof ( MCTLREC ) );
          
         memset ( pdr->pvWork, 0, sizeof ( MCTLREC ) );
          
         //*** Frame ********************************************************
          
         pfnSetWinPos ( hwnd, pdr );
          
         pdr->hwndM = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU );
          
         pdr->pszStat = malloc ( 80 );
          
         pbDat = pfnMiniCont ( hwnd, pRecScn );

         //*** Insert Data **************************************************
          
         for ( ulX = 0; ulX < pdr->ulDEnt; ++ulX )
         {
            pNew = WinSendMsg ( pRecScn->pdr->hwndE, CM_ALLOCRECORD,
                                MPFROMLONG (sizeof(MINIREC)-sizeof(RECORDCORE)),
                                MPFROMSHORT( 1 ) );
             
            //*** Init Record ***********************************************
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz01 = malloc ( ulLen );
            strcpy ( pNew->psz01, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz02 = malloc ( ulLen );
            strcpy ( pNew->psz02, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz03 = malloc ( ulLen );
            strcpy ( pNew->psz03, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz04 = malloc ( ulLen );
            strcpy ( pNew->psz04, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz05 = malloc ( ulLen );
            strcpy ( pNew->psz05, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz06 = malloc ( ulLen );
            strcpy ( pNew->psz06, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz07 = malloc ( ulLen );
            strcpy ( pNew->psz07, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz08 = malloc ( ulLen );
            strcpy ( pNew->psz08, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz09 = malloc ( ulLen );
            strcpy ( pNew->psz09, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz10 = malloc ( ulLen );
            strcpy ( pNew->psz10, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz11 = malloc ( ulLen );
            strcpy ( pNew->psz11, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz12 = malloc ( ulLen );
            strcpy ( pNew->psz12, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz13 = malloc ( ulLen );
            strcpy ( pNew->psz13, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz14 = malloc ( ulLen );
            strcpy ( pNew->psz14, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz15 = malloc ( ulLen );
            strcpy ( pNew->psz15, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pNew->psz16 = malloc ( ulLen );
            strcpy ( pNew->psz16, pbDat );
            pbDat += ulLen;
             
            memcpy ( &pNew->cdUpd, pbDat, sizeof ( CDATE ) );
            pbDat += sizeof ( CDATE );
             
            memcpy ( &pNew->ulOpt, pbDat, sizeof ( ULONG ) );
            pbDat += sizeof ( ULONG );

            //*** Insert ****************************************************
             
            recins.cb                = sizeof ( RECORDINSERT );
            recins.pRecordParent     = (PRECORDCORE) NULL;
            recins.pRecordOrder      = (PRECORDCORE) CMA_END;
            recins.zOrder            = CMA_TOP;
            recins.cRecordsInsert    = 1;
            recins.fInvalidateRecord = TRUE;
             
            WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                         MPFROMP( pNew ), MPFROMP ( &recins ) );
         }
          
         pdr->ulOpts |= SCB_OPENED;
          
         pdr->fbModified = FALSE;
          
         pfnMiniStat ( pRecScn );

         //*** Create & Init Search *****************************************
          
         pRecScn->pdr->psSrch = malloc ( sizeof ( SRCHREC ) );
          
         memset ( pRecScn->pdr->psSrch, 0, sizeof ( SRCHREC ) );
          
         pRecScn->pdr->psSrch->hwndE = hwnd;
          
         pRecScn->pdr->psSrch->fbIsCn = TRUE;
          
         pRecScn->pdr->psSrch->pszFnd = malloc ( 1 );

         *pRecScn->pdr->psSrch->pszFnd = 0;
      }
      break;
       
      case WM_INITMENU:
      {
         HWND    hwndMenu;

         WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
          
         hwndMenu = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU);

         pfnMiniMenu ( pRecScn, hwndMenu, SHORT1FROMMP ( mp1 ) );
      }
      break;
       
      case WM_HELP:
      {
         SHORT   sId;

         sId = WinQueryWindowUShort ( hwnd, QWS_ID );

         WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                      MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
      }
      break;
       
      case WM_COMMAND:
          
         if ( SHORT1FROMMP(mp1) != MID_MINI_NEXT &&
              SHORT1FROMMP(mp1) != MID_MINI_PREV &&
              SHORT1FROMMP(mp1) != MID_MINI_STOP &&
              pRecScn->pdr->fbEditing ) {
             
            WinSendMsg ( pRecScn->pdr->hwndE, CM_CLOSEEDIT, NULL, NULL );
             
         }
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case MID_MINI_SAVE:
                
               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
                
            break;
             
            case MID_MINI_EXIT:

               WinPostMsg ( WinQueryWindow(hwnd,QW_PARENT), WM_SYSCOMMAND, MPFROM2SHORT ( SC_CLOSE, 0 ), NULL );

            break;
             
            case MID_MINI_SAVE_EXIT:

               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
               WinPostMsg ( WinQueryWindow(hwnd,QW_PARENT), WM_SYSCOMMAND, MPFROM2SHORT ( SC_CLOSE, 0 ), NULL );

            break;
             
            case MID_MINI_SETTINGS:
                
               if ( WinDlgBox ( HWND_DESKTOP, hwnd, pfndpColMaint,
                                0L, DLG_COLMAINT, pRecScn ) ) 
               {
                  pRecScn->pdr->fbModified = TRUE;
                  //fbModified = TRUE;
               }
                
            break;
             
            case MID_MINI_ADD:
            {
               PMINIREC           pNew;
               PMINIREC           pFoc;
               RECORDINSERT       recins;

               //*** Allocate & Init Rec ************************************
                
               pFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                   MPFROMLONG ( CMA_FIRST ),
                                   MPFROMSHORT( CRA_SELECTED ) );
                
               pNew = WinSendMsg ( pRecScn->pdr->hwndE, CM_ALLOCRECORD,
                                   MPFROMLONG (sizeof(MINIREC)-sizeof(RECORDCORE)),
                                   MPFROMSHORT( 1 ) );

               pfnInitStrings ( pNew );
                
               pfnSetWhen ( &pNew->cdUpd, NULL );

               pNew->ulOpt = 0;

               //*** Insert *************************************************
                
               recins.cb                = sizeof ( RECORDINSERT );
               recins.pRecordParent     = NULL;
                
               if ( pFoc )
                  recins.pRecordOrder = (PRECORDCORE) pFoc;
               else 
                  recins.pRecordOrder = (PRECORDCORE) CMA_END;
                
               recins.zOrder            = CMA_TOP;
               recins.cRecordsInsert    = 1;
               recins.fInvalidateRecord = TRUE;
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                            MPFROMP( pNew ), MPFROMP ( &recins ) );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
               ++pRecScn->pdr->ulDEnt;
                
               pfnMiniStat ( pRecScn );
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                            MPFROMP ( pNew ),
                            MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                
               WinPostMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( MID_MINI_BEGN, 0 ), NULL );
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );
            }
            break;
             
            case MID_MINI_DELT:
            {
               PMINIREC           pFoc;

               pFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                   MPFROMLONG ( CMA_FIRST ),
                                   MPFROMSHORT( CRA_SELECTED ) );
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_REMOVERECORD,
                            MPFROMP ( &pFoc ),
                            MPFROM2SHORT( 1, CMA_FREE | CMA_INVALIDATE ) );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
               --pRecScn->pdr->ulDEnt;
                
               pfnMiniStat ( pRecScn );
            }
            break;
             
            case MID_MINI_SORT:
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_SORTRECORD,
                            MPFROMP ( pfnMiniSort ),
                            MPFROMP ( pRecScn->pdr->pvWork ) );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
            break;
             
            case MID_MINI_FONT:
            {
               PDATREC   pdr = pRecScn->pdr;
               HPS       hps = WinGetPS ( pdr->hwndE );

               if ( pfnGetFont ( hwnd, hps, NULLHANDLE, &pdr->fxPtSz, &pdr->fat ) )
               {
                  pfnSetPPFont ( pdr->hwndE, pdr->fxPtSz, &pdr->fat );
               }

               WinReleasePS ( hps );
            }
            break;
             
            case MID_MINI_COLOR:
            {
               PDATREC            pdr;

               pdr = pRecScn->pdr;
                
               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpColors, 0L, DLG_COLORS, &pdr->hwndE );
            }
            break;
             
            case MID_MINI_TITLE:
            {
               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpSetTitle, 0L, DLG_SET_TITLE, pRecScn );
            }
            break;
             
            case MID_MINI_PRINT:
            {
               pRecPrt = pRecScn;

               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpPrint,  0L,
                           DLG_PRINT, (PVOID) pfnMiniPrtThd );
            }
            break;
             
            case MID_MINI_FIND:
                
               WinLoadDlg ( HWND_DESKTOP, hwnd, pfndpSearch, 0L, DLG_SEARCH, 
                            pRecScn->pdr->psSrch );
                
            break;
             
            case MID_MINI_FNDNXT:
                
               WinPostMsg ( hwnd, UWM_SEARCH, NULL, NULL );
                
            break;
             
            case MID_MINI_COPY: case MID_MINI_CUT:
            {
               PBYTE              pbDat;
               ULONG              ulLen;
               PVOID              pvClip;
               PMCTLREC           pctl;
               PMINIREC           pFoc;
               PDATREC            pdr;

               pdr = pRecScn->pdr;
                
               pFoc = WinSendMsg ( pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                   MPFROMLONG ( CMA_FIRST ),
                                   MPFROMSHORT( CRA_SELECTED ) );
                
               ulLen = pfnMiniRecMem ( pdr->hwndE, pFoc, 0, NULL );
                
               ulLen += sizeof (ULONG);
                
               pvClip = NULL;
                
               DosAllocSharedMem ( &pvClip, NULL, ulLen, PAG_WRITE | PAG_COMMIT | OBJ_GIVEABLE | OBJ_GETTABLE );
                
               if ( pvClip ) //&& pbMem )
               {
                  pctl = ( PMCTLREC ) pdr->pvWork;
                   
                  pbDat = pvClip;
                   
                  memcpy ( pbDat, &pctl->ulCols, sizeof (ULONG) );
                   
                  pfnMiniRecMem ( pdr->hwndE, pFoc, ulLen, pbDat + sizeof (ULONG) );
                   
                  WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                   
                  WinSetClipbrdData ( WinQueryAnchorBlock ( hwnd ), (ULONG) pvClip, atomMini, CFI_POINTER );
                   
                  WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
               }
               else 
               {
                  pfnMsgOK ( hwnd, APP_TITLE, "Could not get memory for clipboard." );
                  break;
               }
                
               if ( SHORT1FROMMP ( mp1 ) == MID_MINI_CUT ) 
               {
                  WinSendMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( MID_MINI_DELT, 0 ), NULL );
                   
                  pfnMiniStat ( pRecScn );
               }
            }
            break;
             
            case MID_MINI_PASTE:
            {
               PBYTE              pbDat;
               ULONG              ulCols;
               ULONG              ulLen;
               ULONG              ulX;
               PVOID              pvClip;
               PSZ               *ppsz;
               PMCOLREC           pcol;
               PFIELDINFO         pfinf;
               PMINIREC           pNew;
               PMINIREC           pFoc;
               RECORDINSERT       recins;
               PDATREC            pdr;

               if ( pfnIsMyClip ( hwnd, atomMini ) ) 
               {
                  pdr = pRecScn->pdr;
                   
                  WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                   
                  pvClip = (PVOID)WinQueryClipbrdData ( WinQueryAnchorBlock ( hwnd ), atomMini );
                   
                  memcpy ( &ulCols, pvClip, sizeof ( ULONG ) );
                   
                  pbDat = pvClip;
                   
                  pbDat += sizeof (ULONG );
                   
                  //*** Allocate & Init Rec *********************************
                   
                  pFoc = WinSendMsg ( pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                      MPFROMLONG ( CMA_FIRST ),
                                      MPFROMSHORT( CRA_SELECTED ) );
                   
                  pNew = WinSendMsg ( pdr->hwndE, CM_ALLOCRECORD,
                                      MPFROMLONG (sizeof(MINIREC)-sizeof(RECORDCORE)),
                                      MPFROMSHORT( 1 ) );
                   
                  pfnInitStrings ( pNew );

                  //*** Init Record *****************************************
                   
                  pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                       //MPFROMP ( pfinf ),
                                       NULL, MPFROMSHORT( CMA_FIRST ) );
                   
                  for ( ulX = 0; ulX < MINI_COLS; ++ulX )
                  {
                     pcol = (PMCOLREC) pfinf->pUserData;
                      
                    if ( pcol->ulOpts & SCB_MINI_USED )
                    {
                        ppsz = &pNew->psz01;
                         
                        ppsz += ( pcol->ulX );
                         
                        ulLen = strlen ( pbDat ) + 1;
                         
                        (*ppsz) = realloc ( *ppsz, ulLen );
                         
                        strcpy ( *ppsz, pbDat );
                         
                        pbDat += ulLen;
                     }
                      
                     pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                          MPFROMP ( pfinf ),
                                          MPFROMSHORT( CMA_NEXT ) );
                  }
                   
                  pfnSetWhen ( &pNew->cdUpd, NULL );

                  pbDat += sizeof ( CDATE );

                  memcpy ( &pNew->ulOpt, pbDat, sizeof ( ULONG ) );

                  //*** Insert **********************************************
                   
                  recins.cb                = sizeof ( RECORDINSERT );
                  recins.pRecordParent     = NULL;
                   
                  if ( pFoc )
                     recins.pRecordOrder = (PRECORDCORE) pFoc;
                  else
                     recins.pRecordOrder = (PRECORDCORE) CMA_END;
                   
                  recins.zOrder            = CMA_TOP;
                  recins.cRecordsInsert    = 1;
                  recins.fInvalidateRecord = TRUE;
                   
                  WinSendMsg ( pdr->hwndE, CM_INSERTRECORD,
                               MPFROMP( pNew ), MPFROMP ( &recins ) );
                   
                  pRecScn->pdr->fbModified = TRUE;
                  //fbModified = TRUE;
                   
                  ++pdr->ulDEnt;
                   
                  pfnMiniStat ( pRecScn );
                   
                  WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                   
                  pfnMiniStat ( pRecScn );
               }
            }
            break;
             
            case MID_MINI_BEGN:
            {
               PMINIREC      pFoc;
               CNREDITDATA   cnrEdt;

               pFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                   MPFROMLONG ( CMA_FIRST ),
                                   MPFROMSHORT( CRA_SELECTED ) );
                
               if ( ! pFoc || pRecScn->pdr->fbEditing ) {
                   
                  break;//WinSendMsg ( hwndC, CM_CLOSEEDIT, NULL, NULL );
                   
               }
               //else {
                   
                  pRecScn->pdr->pfi =
                          WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                       MPFROMP ( pRecScn->pdr->pfi ),
                                       MPFROMSHORT( CMA_FIRST ) );
                   
                  cnrEdt.cb         = sizeof ( CNREDITDATA );
                  cnrEdt.hwndCnr    = pRecScn->pdr->hwndE;
                  cnrEdt.pRecord    = (PRECORDCORE) pFoc;
                  cnrEdt.pFieldInfo = pRecScn->pdr->pfi;
                  cnrEdt.ppszText   = NULL;
                  cnrEdt.cbText     = 0;
                  cnrEdt.id         = usLeftDvWnd;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_OPENEDIT,
                               MPFROMP ( &cnrEdt ), NULL );
                   
                  //pRecScn->pdr->fbEditing = TRUE;
                   
               //}
            }
            break;
             
            case MID_MINI_NEXT: case MID_MINI_PREV:
            {
               PMINIREC           pFoc;
               PMCTLREC           pctl;
               PMCOLREC           pcol;
               CNREDITDATA        cnrEdt;
               PDATREC            pdr;

               if ( pRecScn->pdr->fbEditing ) 
               {
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_CLOSEEDIT, NULL, NULL );
                   
                  pdr = pRecScn->pdr;
                   
                  pctl = ( PMCTLREC ) pdr->pvWork;
                   
                  if ( ! pdr->pfi ) 
                     pdr->pfi = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                             MPFROMP ( pdr->pfi ),
                                             MPFROMSHORT( CMA_FIRST ) );
                   
                  pFoc = WinSendMsg ( pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                      MPFROMLONG ( CMA_FIRST ),
                                      MPFROMSHORT( CRA_SELECTED ) );
                   
                  cnrEdt.id = pfnWhichSplit ( pdr->hwndE, pdr, SHORT1FROMMP ( mp1 ), pctl );
                   
                  if ( pdr->pfi ) 
                  {
                     cnrEdt.cb         = sizeof ( CNREDITDATA );
                     cnrEdt.hwndCnr    = pdr->hwndE;
                     cnrEdt.pRecord    = (PRECORDCORE) pFoc;
                     cnrEdt.pFieldInfo = pdr->pfi;
                     cnrEdt.ppszText   = NULL;
                     cnrEdt.cbText     = 0;
                      
                     //pcol = (PMCOLREC) pdr->pfi->pUserData;
                      
                     WinSendMsg ( pdr->hwndE, CM_OPENEDIT,
                                  MPFROMP ( &cnrEdt ), NULL );
                      
                  }
                  else 
                  {
                     WinSendMsg ( pdr->hwndE, CM_CLOSEEDIT, NULL, NULL );
                  }
               }
            }
            break;
             
            case MID_MINI_STOP:
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_CLOSEEDIT, NULL, NULL );
                
            break;

            default:
               WinPostMsg ( hwndM, msg, mp1, mp2 );
         }
          
      break;
       
      case WM_CONTROL:
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case WID_CONT:
                
               switch ( SHORT2FROMMP ( mp1 ) ) 
               {
                  case CN_BEGINEDIT:
                  {
                     PCNREDITDATA     pcnrEdt;

                     pRecScn->pdr->fbEditing = TRUE;
                      
                     pcnrEdt = PVOIDFROMMP ( mp2 );
                      
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                                  MPFROMP ( pcnrEdt->pRecord ),
                                  MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                      
                     pRecScn->pdr->pfi = pcnrEdt->pFieldInfo;
                  }
                  return ( MRESULT ) TRUE;
                   
                  case CN_ENDEDIT:
                      
                     pRecScn->pdr->fbEditing = FALSE;
                      
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );
   
                  return ( MRESULT ) TRUE;
                   
                  case CN_CONTEXTMENU:
                  {
                     HWND          hwndMenu;
                     POINTL        ptl;
                     PMINIREC      pNew;

                     pNew = PVOIDFROMMP ( mp2 );
                      
                     hwndMenu = WinLoadMenu ( hwnd, 0, WID_MINI );
                      
                     if ( ! pNew )
                        WinEnableMenuItem ( hwndMenu, MID_MINI_DELT, FALSE );
                     else 
                     {
                        WinEnableMenuItem ( hwndMenu, MID_MINI_DELT, TRUE );
                         
                        WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                                     MPFROMP ( pNew ),
                                     MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                     }

                     pfnMiniMenu ( pRecScn, hwndMenu, MID_MINI_EDIT );

                     WinQueryPointerPos ( HWND_DESKTOP, &ptl );
                      
                     WinMapWindowPoints ( HWND_DESKTOP, hwnd, &ptl, 1 );
                      
                     WinPopupMenu ( pRecScn->pdr->hwndE, hwnd, hwndMenu,
                                    (SHORT)ptl.x, (SHORT)ptl.y,
                                    MID_MINI_EDIT,
                                    PU_POSITIONONITEM | //PU_HCONSTRAIN | PU_VCONSTRAIN |
                                    PU_MOUSEBUTTON1 | PU_MOUSEBUTTON2 | PU_KEYBOARD );
                  }
                  return ( MRESULT ) TRUE;
                   
                  case CN_REALLOCPSZ:
                  {
                     //ULONG            ulOff;
                     PSZ             *ppsz;
                     PMCOLREC         pcol;
                     PFIELDINFO       pfinf;
                     PMINIREC         pNew;
                     PCNREDITDATA     pcnrEdt;

                     pcnrEdt = PVOIDFROMMP ( mp2 );
                      
                     pNew = (PMINIREC) pcnrEdt->pRecord;
                      
                     //ulOff = pcnrEdt->pFieldInfo->offStruct;
                      
                     pfinf = pcnrEdt->pFieldInfo;
                      
                     pcol = (PMCOLREC) pfinf->pUserData;
                      
                     if ( ! pNew )
                        return (MRESULT) FALSE;
                      
                     ppsz = &pNew->psz01;
                      
                     ppsz += pcol->ulX;
                      
                     (*ppsz) = realloc ( *ppsz, pcnrEdt->cbText );
                      
                     pRecScn->pdr->fbModified = TRUE;
                     //fbModified = TRUE;
                      
                     pfnSetWhen ( &pNew->cdUpd, NULL );
                  }
                  return ( MRESULT ) TRUE;
                   
                  case CN_INITDRAG:
                  {
                     PMINIREC      pRecDrg;
                     PCNRDRAGINIT  pcnrDrg;
                     PDRAGINFO     pdinfo;
                     DRAGITEM      ditem;
                     DRAGIMAGE     dimage;
         
                     pcnrDrg = PVOIDFROMMP ( mp2 );
                      
                     pRecDrg = (PMINIREC) pcnrDrg->pRecord;
                      
                     if ( ! pRecDrg )
                        break;
                      
                     //*** Drag It ******************************************
                      
                     pdinfo = DrgAllocDraginfo ( 1 );
                      
                     ditem.hwndItem       = hwnd;
                     ditem.ulItemID       = (ULONG)pRecDrg;
                     ditem.hstrType       = DrgAddStrHandle ( DRT_TREE );
                     ditem.hstrRMF        = DrgAddStrHandle ( DRM_MINI );
                     ditem.fsControl      = 0;
                     ditem.fsSupportedOps = DO_COPYABLE | DO_MOVEABLE;
                      
                     DrgSetDragitem ( pdinfo, &ditem, sizeof(ditem), 0 );
                      
                     dimage.cb       = sizeof(DRAGIMAGE);
                     dimage.cptl     = 0;
                     dimage.hImage   = hptrMini;
                     dimage.fl       = DRG_ICON;
                     dimage.cxOffset = 0;
                     dimage.cyOffset = 0;
                      
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                                  MPFROMP ( pRecDrg ),
                                  MPFROM2SHORT ( TRUE, 0x00004000 ) );//CRA_CURSORED ) );
                      
                     DrgDrag ( hwnd, pdinfo, &dimage, 1, VK_ENDDRAG, NULL );
                      
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                                  MPFROMP ( pRecDrg ),
                                  MPFROM2SHORT ( FALSE, 0x00004000 ) );//CRA_CURSORED ) );
                      
                     DrgFreeDraginfo ( pdinfo );
                  }
                  break;
                   
                  case CN_DRAGAFTER:
                  {
                     PCNRDRAGINFO  pcnrDri;
                     PDRAGINFO     pdinfo;
                     PDRAGITEM     pditem;
         
                     pcnrDri = PVOIDFROMMP ( mp2 );
                      
                     pdinfo = pcnrDri->pDragInfo;
                      
                     DrgAccessDraginfo ( pdinfo );
                      
                     pditem = DrgQueryDragitemPtr ( pdinfo, 0 );
                      
                     if ( pditem->hwndItem != hwnd )
                     {
                        DrgFreeDraginfo ( pdinfo );
   
                        return ( MRFROM2SHORT ( DOR_NEVERDROP, 0 ) );
                     }
                     else if ( DrgVerifyRMF ( pditem, "DRM_PMSCRAPBOOK", "DRF_MINI" ) )
                     { 
                        DrgFreeDraginfo ( pdinfo );
                         
                        return ( MRFROM2SHORT ( DOR_DROP, DO_MOVE ) );
                         
                     }
                     else 
                     {
                        DrgFreeDraginfo ( pdinfo );
                         
                        return ( MRFROM2SHORT ( DOR_NEVERDROP, 0 ) );
                     }
                  }
                   
                  case CN_DROP:
                  {
                     PCNRDRAGINFO  pcnrDri;
                     PDRAGINFO     pdinfo;
                     PDRAGITEM     pditem;
                     PMINIREC      pRecDrp;
                     PMINIREC      pRecAft;
                     RECORDINSERT  recins;
         
                     pcnrDri = PVOIDFROMMP ( mp2 );
                      
                     pdinfo = pcnrDri->pDragInfo;
                      
                     DrgAccessDraginfo ( pdinfo );
                      
                     pditem = DrgQueryDragitemPtr ( pdinfo, 0 );
                      
                     pRecDrp = (PMINIREC) pditem->ulItemID;
                     pRecAft = (PMINIREC) pcnrDri->pRecord;
                      
                     if ( ! pRecAft || pRecDrp == pRecAft )
                     {
                        DrgFreeDraginfo ( pdinfo );
                        break;
                     }
                      
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_REMOVERECORD,
                                  MPFROMP ( &pRecDrp ),
                                  MPFROM2SHORT( 1, 0 ) );//CMA_INVALIDATE ) );
                      
                     //*** Insert *************************************************
                      
                     recins.cb                = sizeof ( RECORDINSERT );
                     recins.pRecordParent     = NULL;
                     recins.pRecordOrder      = (PRECORDCORE) pRecAft;
                     recins.zOrder            = CMA_TOP;
                     recins.cRecordsInsert    = 1;
                     recins.fInvalidateRecord = TRUE;
                      
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                                  MPFROMP( pRecDrp ), MPFROMP ( &recins ) );
                      
                     pRecScn->pdr->fbModified = TRUE;
                     //fbModified = TRUE;
                  }
                  break;
                   
                  case CN_HELP:
                      
                     WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                                  MPFROMSHORT ( HID_MINI ), MPFROMSHORT ( HM_RESOURCEID ) );
                      
                  break;
                   
               }
                
            break;
             
         }
          
      break;
       
      case UWM_SAVE:
      {
         ULONG              ulOff;
         ULONG              ulLen;
         ULONG              ulX;
         ULONG              ulAdd;
         PBYTE              pbScn;
         PMCTLREC           pctl;
         PMCOLREC           pcol;
         CNRINFO            cnrinf;
         PFIELDINFO         pfinf;
         PDATREC            pdr;

         pdr = pRecScn->pdr;
          
         pdr->ulRelRev = REL_REV;

         pctl = (PMCTLREC ) pdr->pvWork;
          
         pdr->ulDLen = pfnNodeScan  ( pdr->hwndE, SCB_SIZE, WID_MINI, pdr->pvDat );
          
         pdr->ulDLen += ( sizeof ( ULONG ) * 2 );
          
         pdr->ulDLen += ( sizeof ( BYTE ) * MINI_SORTS );
          
         pdr->ulDLen += ( sizeof ( BYTE ) * MINI_SORTS );
          
         pdr->ulDLen += ( sizeof ( MCOLREC ) * MINI_COLS );
          
         for ( ulX = 0; ulX < MINI_COLS; ++ulX )
            pdr->ulDLen += ( strlen ( pctl->mcols[ulX].pszTitl ) + 1 );
          
         pdr->pvDat = realloc ( pdr->pvDat, pdr->ulDLen );
          
         //*** Write Control Header *****************************************
          
         pbScn = pdr->pvDat;
          
         //*** # Cols *******************************************************
          
         memcpy ( pbScn, &pctl->ulCols, sizeof ( ULONG ) );
          
         pbScn += sizeof ( ULONG );
          
         //*** Split ********************************************************
          
         if ( pctl->ulSplit ) 
         {
            pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                 NULL, MPFROMSHORT( CMA_FIRST ) );
             
            for ( ulX = 0; ulX < MINI_COLS; ++ulX )
            {
               pcol = (PMCOLREC) pfinf->pUserData;
                
               if ( pcol->ulOpts & SCB_MINI_SPLT )
               //if ( pcol->ulX == ( pctl->ulSplit - 1 ) )
               {
                  ulOff = ulX + 1;
                   
                  break;
               }
                
               pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                    MPFROMP ( pfinf ),
                                    MPFROMSHORT( CMA_NEXT ) );
            }
             
         }
         else 
         {
            ulOff = 0;
         }
          
         memcpy ( pbScn, &ulOff, sizeof ( ULONG ) );
          
         pbScn += sizeof ( ULONG );
          
         //*** Sort *********************************************************
          
         memcpy ( pbScn, pctl->abSort, sizeof ( BYTE ) * MINI_SORTS );
          
         pbScn += ( sizeof ( BYTE ) * MINI_SORTS );
          
         memcpy ( pbScn, pctl->abSOpt, sizeof ( BYTE ) * MINI_SORTS );
          
         pbScn += ( sizeof ( BYTE ) * MINI_SORTS );
          
         //*** Col Data *****************************************************
          
         pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                              NULL,
                              MPFROMSHORT( CMA_FIRST ) );
          
         for ( ulX = 0; ulX < MINI_COLS; ++ulX )
         {
            pcol = (PMCOLREC) pfinf->pUserData;
             
            pcol->ulChrs = pfnCnrColPels ( pdr->hwndE, pfinf );

            memcpy ( pbScn, pcol, sizeof ( MCOLREC ) );
             
            pbScn += sizeof ( MCOLREC );
             
            pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                 MPFROMP ( pfinf ),
                                 MPFROMSHORT( CMA_NEXT ) );
         }
          
         //*** Titles *******************************************************
          
         pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                              MPFROMP ( pfinf ),
                              MPFROMSHORT( CMA_FIRST ) );
          
         ulAdd = 0;

         for ( ulX = 0; ulX < MINI_COLS; ++ulX )
         {
            pcol = (PMCOLREC) pfinf->pUserData;
             
         /*  if ( pcol->ulOpts & SCB_MINI_USED )
           {*/
               ulLen = strlen ( pcol->pszTitl ) + 1;
             
               memcpy ( pbScn, pcol->pszTitl, ulLen );
             
               pbScn += ulLen;
            /*}
            else
               ++ulAdd;*/
             
            pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                 MPFROMP ( pfinf ),
                                 MPFROMSHORT( CMA_NEXT ) );
         }

         pdr->ulDEnt = pfnNodeScan  ( pdr->hwndE, SCB_WRITE, WID_MINI, pbScn );
          
         //*** Set Completion States ****************************************
          
         pdr->fbModified = FALSE;
          
         pfnSetWhen ( &pRecScn->cdWri, &pRecScn->ctWri );
          
         pfnGetWinPos ( hwnd, pdr );
          
         //pfnGetDefFattrs ( pdr->hwndE, NULLHANDLE, &pdr->fat, &pdr->fxPtSz );
          
         pfnGetPresColors ( pdr->hwndE, &pdr->ulNBClr, &pdr->ulNFClr, &pdr->ulHBClr, &pdr->ulHFClr );
          
         WinSendMsg ( pdr->hwndE, CM_QUERYCNRINFO,
                      MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
          
         pdr->ulXVS = cnrinf.xVertSplitbar;
          
         fbModified = TRUE;
      }
      break;
       
      case UWM_SEARCH:
      {
         PMINIREC         pFoc;
         PDATREC          pdr;
         SEARCHSTRING     cnrsd;

         pdr = pRecScn->pdr;
          
         cnrsd.cb              = sizeof ( SEARCHSTRING );
         cnrsd.pszSearch       = pdr->psSrch->pszFnd;
         cnrsd.fsPrefix        = FALSE;
         cnrsd.fsCaseSensitive = ( pdr->psSrch->fbCase ) ? TRUE : FALSE;
         cnrsd.usView          = CV_DETAIL;

         pFoc = WinSendMsg ( pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                             MPFROMLONG ( CMA_FIRST ),
                             MPFROMSHORT( CRA_SELECTED ) );
          
         if ( ! pFoc )
         {
            pfnMsgOK ( hwnd, APP_TITLE, "Text not found." );
            break;
         }

         if ( pdr->psSrch->fbFirst )
         {
            if ( pFoc == pfnGetCnrRec ( pdr->hwndE, NULL ) )
               pFoc = (PMINIREC) CMA_FIRST;
            
            pdr->psSrch->fbFirst = FALSE;
         }
         
         pFoc = WinSendMsg ( pdr->hwndE, CM_SEARCHSTRING,
                             MPFROMP ( &cnrsd ), MPFROMP ( pFoc ) );

         if ( pFoc )
         {
            pfnCnrShowRec ( pdr->hwndE, pFoc, TRUE );

            if ( pFoc != pfnGetCnrRec ( pdr->hwndE, NULL ) )
               pdr->psSrch->fbFirst = TRUE;
         }
         else
         {
            pdr->psSrch->fbFirst = TRUE;
            pfnMsgOK ( hwnd, APP_TITLE, "Text not found." );
         }
      }
      break;
       
      case WM_CLOSE:
      {
         PDATREC            pdr;

         pdr = pRecScn->pdr;
          
         if ( pdr->fbModified ) 
         {
            if ( pfnMsgYesNo ( hwnd, APP_TITLE,
                               "This entry has been modified. Save changes ?" ) )

               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
         }
          
         pdr->ulOpts &= ~SCB_OPENED;
          
         pdr->hwndD   = 0;
         pfnHaveAKid ( pRecScn, FALSE );
          
         WinEnableWindowUpdate ( pdr->hwndE, FALSE );

         pfnNodeScan  ( pdr->hwndE, SCB_FREE, 
                        pRecScn->ulType, pRecScn->pdr->pvDat );

         free ( pdr->psSrch->pszFnd );
         free ( pdr->psSrch );
         free ( pdr->pszStat );
          
         WinSendMsg ( hwndC, CM_SETRECORDEMPHASIS,
                      MPFROMP ( pRecScn ),
                      MPFROM2SHORT ( FALSE, CRA_INUSE ) );
          
         WinDestroyWindow ( WinQueryWindow ( hwnd, QW_PARENT ) );
      }
      break;
       
      case WM_PRESPARAMCHANGED:
          
         pRecScn->pdr->fbModified = TRUE;
         //fbModified = TRUE;
          
      break;
       
      case WM_ERASEBACKGROUND:
          
      return ( MRESULT ) ( TRUE );
       
      default:
      return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
       
   }
    
   return ( MRESULT ) FALSE;
    
}
 
/***************************************************************************/
/* Mini Columns Maintenance Window Proc                                    */
/***************************************************************************/
MRESULT EXPENTRY pfndpColMaint( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   PUSEREC    pRecScn = (PUSEREC) WinQueryWindowULong ( hwnd, QWL_USER );
    
   switch ( msg ) 
   {
      case WM_INITDLG:
      {
         CNRINFO      cnrinf;
         HWND         hwndP;
         ULONG        ulX;
         PDATREC      pdr;
         PMAINTREC    prec;
         PFIELDINFO   pfiBfr;
         PMCTLREC     pctl;
         PMCOLREC     pcol;
         RECORDINSERT recins;

         pRecScn = (PUSEREC) PVOIDFROMMP ( mp2 );
          
         pdr = pRecScn->pdr;
          
         pctl = ( PMCTLREC ) pdr->pvWork;
          
         WinSetWindowULong ( hwnd, QWL_USER, (ULONG) pRecScn );
          
         //*** Set Container Attrs ******************************************
          
         hwndP = WinWindowFromID ( hwnd, DIT_COLLIST );
          
         cnrinf.flWindowAttr = CV_TEXT | CA_ORDEREDTARGETEMPH;
          
         WinSendMsg ( hwndP, CM_SETCNRINFO, &cnrinf,
                      MPFROMLONG ( CMA_FLWINDOWATTR ) );
          
         //*** Fill Container ***********************************************
          
         pfiBfr = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                               MPFROMP ( pRecScn->pdr->pfi ),
                               MPFROMSHORT( CMA_FIRST ) );
          
         for ( ulX = 0; ulX < MINI_COLS; ++ulX )
         {
            pcol = (PMCOLREC) pfiBfr->pUserData;
             
            if ( pcol->ulOpts & SCB_MINI_USED )
            {
               //*** Allocate **************************************************
                
               prec = WinSendMsg ( hwndP, CM_ALLOCRECORD,
                                   MPFROMLONG (sizeof(MAINTREC)-sizeof(MINIRECORDCORE)),
                                   MPFROMSHORT( 1 ) );
                
               prec->crecCore.pszIcon = strdup ( pcol->pszTitl );
                
               //prec->ulX = pcol->ulX;
               prec->pcol = pcol;
                
               //*** Insert ****************************************************
                
               recins.cb                = sizeof ( RECORDINSERT );
               recins.pRecordParent     = NULL;
               recins.pRecordOrder      = (PRECORDCORE) CMA_END;
               recins.zOrder            = CMA_TOP;
               recins.cRecordsInsert    = 1;
               recins.fInvalidateRecord = TRUE;
                
               WinSendMsg ( hwndP, CM_INSERTRECORD,
                            MPFROMP( prec ), MPFROMP ( &recins ) );
            }
             
            pfiBfr = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                  MPFROMP ( pfiBfr ),
                                  MPFROMSHORT( CMA_NEXT ) );
         }
          
         prec = WinSendMsg ( hwndP, CM_QUERYRECORD,
                             MPFROMP ( NULL ),
                             MPFROM2SHORT ( CMA_FIRST, CMA_ITEMORDER ) );
          
         WinSendMsg ( hwnd, UWM_SHOW, MPFROMP ( prec ), NULL );
          
         WinSendMsg ( hwndP, CM_SETRECORDEMPHASIS,
                      MPFROMP ( prec ),
                      MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
      }
      break;
       
      case UWM_SHOW:
      {
         HWND         hwndP;
         PDATREC      pdr;
         PMAINTREC    precTmp;
         PMAINTREC    prec;
         PMCTLREC     pctl;
         PMCOLREC     pcol;
          
         prec = (PMAINTREC) PVOIDFROMMP ( mp1 );
          
         if ( ! prec )
            break;
          
         pdr = pRecScn->pdr;
          
         pctl = ( PMCTLREC ) pdr->pvWork;
          
         //pcol = &pctl->mcols[prec->ulX];
         pcol = prec->pcol;
          
         hwndP = WinWindowFromID ( hwnd, DIT_COLLIST );
          
         //*** ADDs, DELETEs and SPLITs *************************************
          
         if ( pcol->ulOpts & SCB_MINI_MLE )
            WinCheckButton ( hwnd, DIT_COLMLE, TRUE );
         else 
            WinCheckButton ( hwnd, DIT_COLMLE, FALSE );
          
         if ( pctl->ulCols <= 1 )
            WinCheckButton ( hwnd, DIT_COLDELT, FALSE );
         else
            WinCheckButton ( hwnd, DIT_COLDELT, TRUE );
          
         if ( pctl->ulCols == MINI_COLS )
            WinCheckButton ( hwnd, DIT_COLADD, FALSE );
         else
            WinCheckButton ( hwnd, DIT_COLADD, TRUE );
          
         //if ( pcol->ulX == ( pctl->ulSplit - 1 ) )
         if ( pcol->ulOpts & SCB_MINI_SPLT )
            WinCheckButton ( hwnd, DIT_COLSPLITCOL, TRUE );
         else
            WinCheckButton ( hwnd, DIT_COLSPLITCOL, FALSE );
          
         //*** Alignment ****************************************************
          
         if ( pcol->ulCHOpts & CFA_LEFT )
            WinCheckButton ( hwnd, DIT_COLLEFT, TRUE );
         else if ( pcol->ulCHOpts & CFA_RIGHT )
            WinCheckButton ( hwnd, DIT_COLRIGHT, TRUE );
         else
            WinCheckButton ( hwnd, DIT_COLCENTER, TRUE );
          
         if ( pcol->ulCHOpts & CFA_TOP )
            WinCheckButton ( hwnd, DIT_COLTOP, TRUE );
         else if ( pcol->ulCHOpts & CFA_BOTTOM )
            WinCheckButton ( hwnd, DIT_COLBOTTOM, TRUE );
         else
            WinCheckButton ( hwnd, DIT_COLVCENTER, TRUE );
          
         if ( pcol->ulCDOpts & CFA_LEFT )
            WinCheckButton ( hwnd, DIT_DATLEFT, TRUE );
         else if ( pcol->ulCDOpts & CFA_RIGHT )
            WinCheckButton ( hwnd, DIT_DATRIGHT, TRUE );
         else
            WinCheckButton ( hwnd, DIT_DATCENTER, TRUE );
          
         if ( pcol->ulCDOpts & CFA_TOP )
            WinCheckButton ( hwnd, DIT_DATTOP, TRUE );
         else if ( pcol->ulCDOpts & CFA_BOTTOM )
            WinCheckButton ( hwnd, DIT_DATBOTTOM, TRUE );
         else
            WinCheckButton ( hwnd, DIT_DATVCENTER, TRUE );
          
         //*** Position *****************************************************
          
         precTmp = WinSendMsg ( hwndP, CM_QUERYRECORD,
                                MPFROMP ( prec ),
                                MPFROM2SHORT ( CMA_NEXT, CMA_ITEMORDER ) );
          
         if ( ! precTmp ) 
         {
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_DOWN ), FALSE );
             
            //WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSPLITCOL ), FALSE );
         }
         else 
         {
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_DOWN ), TRUE );
             
            //WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSPLITCOL ), TRUE );
         }
          
         precTmp = WinSendMsg ( hwndP, CM_QUERYRECORD,
                                MPFROMP ( prec ),
                                MPFROM2SHORT ( CMA_PREV, CMA_ITEMORDER ) );
          
         if ( ! precTmp ) 
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_UP ), FALSE );
         else
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_UP ), TRUE );
          
         //*** Sorts ********************************************************
          
         WinCheckButton ( hwnd, DIT_COLSORT1, FALSE );
         WinCheckButton ( hwnd, DIT_COLSORT2, FALSE );
         WinCheckButton ( hwnd, DIT_COLSORT3, FALSE );
         WinCheckButton ( hwnd, DIT_COLSORT4, FALSE );
          
         WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT1_DEC ), FALSE );
         WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT2_DEC ), FALSE );
         WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT3_DEC ), FALSE );
         WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT4_DEC ), FALSE );
          
         if ( pcol->ulX == ( pctl->abSort[0] - 1 ) ) 
         {
            WinCheckButton ( hwnd, DIT_COLSORT1, TRUE );
             
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT1_DEC ), TRUE );
         }
         else if ( pcol->ulX == ( pctl->abSort[1] - 1 ) ) 
         {
            WinCheckButton ( hwnd, DIT_COLSORT2, TRUE );
             
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT2_DEC ), TRUE );
         }
         else if ( pcol->ulX == ( pctl->abSort[2] - 1 ) ) 
         {
            WinCheckButton ( hwnd, DIT_COLSORT3, TRUE );
             
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT3_DEC ), TRUE );
         }
         else if ( pcol->ulX == ( pctl->abSort[3] - 1 ) ) 
         {
            WinCheckButton ( hwnd, DIT_COLSORT4, TRUE );
             
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT4_DEC ), TRUE );
         }
          
         WinCheckButton ( hwnd, DIT_COLSORT1_DEC, FALSE );
         WinCheckButton ( hwnd, DIT_COLSORT2_DEC, FALSE );
         WinCheckButton ( hwnd, DIT_COLSORT3_DEC, FALSE );
         WinCheckButton ( hwnd, DIT_COLSORT4_DEC, FALSE );
          
         if ( pcol->ulX == ( pctl->abSort[0] - 1 ) ) 
         {
            if ( pctl->abSOpt[0] & SCB_MINI_DESC )
               WinCheckButton ( hwnd, DIT_COLSORT1_DEC, TRUE );
         }
         else if ( pcol->ulX == ( pctl->abSort[1] - 1 ) ) 
         {
            if ( pctl->abSOpt[1] & SCB_MINI_DESC )
               WinCheckButton ( hwnd, DIT_COLSORT2_DEC, TRUE );
         }
         else if ( pcol->ulX == ( pctl->abSort[2] - 1 ) ) 
         {
            if ( pctl->abSOpt[2] & SCB_MINI_DESC )
               WinCheckButton ( hwnd, DIT_COLSORT3_DEC, TRUE );
         }
         else if ( pcol->ulX == ( pctl->abSort[3] - 1 ) ) 
         {
            if ( pctl->abSOpt[3] & SCB_MINI_DESC )
               WinCheckButton ( hwnd, DIT_COLSORT4_DEC, TRUE );
         }
          
         WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT2 ), TRUE );
         WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT3 ), TRUE );
         WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT4 ), TRUE );
          
         if ( pctl->ulCols < 2 ) 
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT2 ), FALSE );
          
         if ( pctl->ulCols < 3 ) 
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT3 ), FALSE );
          
         if ( pctl->ulCols < 4 ) 
            WinEnableWindow ( WinWindowFromID ( hwnd, DIT_COLSORT4 ), FALSE );
          
      }
      break;
       
      /*case WM_CLOSE:
      {
         pRecScn->pdr->fbModified = TRUE;
      }
      break;*/
       
      case WM_COMMAND:
      {
         HWND         hwndP;
         PDATREC      pdr;
         PMAINTREC    precTmp;
         PFIELDINFO   pfiBfr;
         PFIELDINFO   pfiAft;
         PMAINTREC    prec;
         PMCTLREC     pctl;
         PMCOLREC     pcol;
         RECORDINSERT recins;

         hwndP = WinWindowFromID ( hwnd, DIT_COLLIST );
          
         if ( pRecScn->pdr->fbEditing && SHORT1FROMMP ( mp1 ) == DIT_COLNAME )
         {
            WinSendMsg ( hwndP, CM_CLOSEEDIT, NULL, NULL );
            break;
         }
         else if ( pRecScn->pdr->fbEditing )
            WinSendMsg ( hwndP, CM_CLOSEEDIT, NULL, NULL );
          
         prec = WinSendMsg ( hwndP, CM_QUERYRECORDEMPHASIS,
                             MPFROMLONG ( CMA_FIRST ), MPFROMSHORT( CRA_SELECTED ) );
          
         if ( ! prec ) 
         {
            WinAlarm ( HWND_DESKTOP, WA_NOTE );
             
            break;
         }
          
         pdr = pRecScn->pdr;
          
         pctl = ( PMCTLREC ) pdr->pvWork;
          
         pcol = prec->pcol;//&pctl->mcols[prec->ulX];
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case DIT_OK:
                
               WinDismissDlg ( hwnd, TRUE );
                
            break;
             
            case DIT_HELP:
            {
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( DLG_COLMAINT, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
             
            case DIT_COLNAME:
            {
               CNREDITDATA    cnrEdt;

               cnrEdt.cb         = sizeof ( CNREDITDATA );
               cnrEdt.hwndCnr    = hwndP;
               cnrEdt.pRecord    = (PRECORDCORE) prec;
               cnrEdt.pFieldInfo = NULL;
               cnrEdt.ppszText   = &prec->crecCore.pszIcon;
               cnrEdt.cbText     = strlen ( prec->crecCore.pszIcon ) + 1;
               cnrEdt.id         = DIT_COLLIST;//CID_LEFTDVWND;//0;
                
               WinSendMsg ( hwndP, CM_OPENEDIT, MPFROMP ( &cnrEdt ), NULL );
            }
            break;
             
            case DIT_COLDELT:
            {
               PMINIREC  pRecTmp;
               PSZ      *ppsz;

               --pctl->ulCols;
                
               pcol->ulOpts &= ~SCB_MINI_USED;
                
               pfnSetSplit ( pdr->hwndE, pdr, FALSE );
                
               //*** Free Strings *******************************************
                
               free ( prec->crecCore.pszIcon );
                
               pRecTmp = WinSendMsg ( pdr->hwndE, CM_QUERYRECORD,
                                      MPFROMP ( NULL ),
                                      MPFROM2SHORT ( CMA_FIRST, CMA_ITEMORDER ) );
                
               while ( pRecTmp ) 
               {
                  ppsz = &pRecTmp->psz01;
                   
                  ppsz += pcol->ulX;
                   
                  (*ppsz) = realloc ( *ppsz, 1 );
                   
                  //*ppsz = 0;
                  strcpy ( *ppsz, "" );

                  pRecTmp = WinSendMsg ( pdr->hwndE, CM_QUERYRECORD,
                                         MPFROMP ( pRecTmp ),
                                         MPFROM2SHORT ( CMA_NEXT, CMA_ITEMORDER ) );
               }

               //*** Remove/Hide Records ************************************
                
               pcol->pfi->flData |= CFA_INVISIBLE;

               WinSendMsg ( hwndP, CM_REMOVERECORD,
                            MPFROMP ( &prec ),
                            MPFROM2SHORT( 1, CMA_INVALIDATE ) );
                
               prec = WinSendMsg ( WinWindowFromID ( hwnd, DIT_COLLIST ), CM_QUERYRECORDEMPHASIS,
                                   MPFROMLONG ( CMA_FIRST ), MPFROMSHORT( CRA_SELECTED ) );
                
               WinSendMsg ( hwnd, UWM_SHOW, MPFROMP ( prec ), NULL );
                
               pfnSetSplit ( pdr->hwndE, pdr, TRUE );
            }
            break;
             
            case DIT_COLADD:
            {
               ULONG     ulX;
               PFIELDINFO   pfiBfr;

               pfiBfr = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                     NULL,
                                     MPFROMSHORT( CMA_FIRST ) );
                
               for ( ulX = 0; ulX < MINI_COLS; ++ulX )
               {
                  pcol = (PMCOLREC) pfiBfr->pUserData;
                   
                  if ( ! ( pcol->ulOpts & SCB_MINI_USED ) )
                  {
                     ++pctl->ulCols;
                      
                     pfnSetSplit ( pdr->hwndE, pdr, FALSE );
                      
                     //*** Add Editor Column ********************************
                      
                     pcol->ulOpts |= SCB_MINI_USED;
                      
                     pcol->ulCHOpts = CFA_TOP | CFA_CENTER | CFA_FITITLEREADONLY;
                     pcol->ulCDOpts = CFA_STRING | CFA_TOP | CFA_LEFT | CFA_HORZSEPARATOR | CFA_SEPARATOR;
                     pcol->ulStyl   = 0;
                     pcol->pszTitl  = strdup ( "New Column" );
                      
                     pcol->pfi = pfnCol2FInfo ( pdr->hwndE, pcol, pcol->pfi, (PFIELDINFO)CMA_END );
                      
                     //*** Allocate Settings Record *************************
                      
                     prec = WinSendMsg ( hwndP, CM_ALLOCRECORD,
                                         MPFROMLONG (sizeof(MAINTREC)-sizeof(MINIRECORDCORE)),
                                         MPFROMSHORT( 1 ) );
                      
                     prec->crecCore.pszIcon = strdup ( pcol->pszTitl );
                      
                     //prec->ulX = ulX;
                     prec->pcol = pcol;
                      
                     //*** Insert *******************************************
                      
                     recins.cb                = sizeof ( RECORDINSERT );
                     recins.pRecordParent     = NULL;
                     recins.pRecordOrder      = (PRECORDCORE) CMA_END;
                     recins.zOrder            = CMA_TOP;
                     recins.cRecordsInsert    = 1;
                     recins.fInvalidateRecord = TRUE;
                      
                     WinSendMsg ( hwndP, CM_INSERTRECORD,
                                  MPFROMP( prec ), MPFROMP ( &recins ) );
                      
                     pfnSetSplit ( pdr->hwndE, pdr, TRUE );
                      
                     WinSendMsg ( hwnd, UWM_SHOW, MPFROMP ( prec ), NULL );
                      
                     WinSendMsg ( hwndP, CM_SETRECORDEMPHASIS,
                                  MPFROMP ( prec ),
                                  MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                      
                     break;
                  }
                  pfiBfr = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                        MPFROMP ( pfiBfr ),
                                        MPFROMSHORT( CMA_NEXT ) );
               }
            }
            break;
             
         }
      }
      break;
       
      case WM_CONTROL:
      {
         ULONG        ulCmd;
         HWND         hwndP;
         PDATREC      pdr;
         PMAINTREC    prec = NULL;
         PMAINTREC    precX;
         PMCTLREC     pctl;
         PMCOLREC     pcol;

         ulCmd = 0;
          
         if ( SHORT1FROMMP ( mp1 ) == DIT_COLLIST )
         {
            hwndP = WinWindowFromID ( hwnd, DIT_COLLIST );

            switch ( SHORT2FROMMP ( mp1 ) ) 
            {
               case CN_EMPHASIS:
               {
                  PNOTIFYRECORDEMPHASIS pcnrEmf;

                  pcnrEmf = PVOIDFROMMP ( mp2 );
                   
                  if ( pcnrEmf && pcnrEmf->fEmphasisMask & CRA_SELECTED )
                     WinSendMsg ( hwnd, UWM_SHOW, MPFROMP ( pcnrEmf->pRecord ), NULL );
               }
               break;
                
               case CN_INITDRAG:
               {
                  PCNRDRAGINIT  pcnrDrg;
                  PDRAGINFO     pdinfo;
                  DRAGITEM      ditem;
                  DRAGIMAGE     dimage;
      
                  pcnrDrg = PVOIDFROMMP ( mp2 );
                   
                  prec = (PMAINTREC) pcnrDrg->pRecord;
                   
                  if ( ! prec )
                     break;
                   
                  //*** Drag It ******************************************
                   
                  pdinfo = DrgAllocDraginfo ( 1 );
                   
                  ditem.hwndItem       = hwnd;
                  ditem.ulItemID       = (ULONG)prec;
                  ditem.hstrType       = DrgAddStrHandle ( DRT_TREE );
                  ditem.hstrRMF        = DrgAddStrHandle ( "<PM_SCRAPBOOK,DRF_COLMAINT>" );
                  ditem.fsControl      = 0;
                  ditem.fsSupportedOps = DO_COPYABLE | DO_MOVEABLE;
                   
                  DrgSetDragitem ( pdinfo, &ditem, sizeof(ditem), 0 );
                   
                  dimage.cb       = sizeof(DRAGIMAGE);
                  dimage.cptl     = 0;
                  dimage.hImage   = hptrMini;
                  dimage.fl       = DRG_ICON;
                  dimage.cxOffset = 0;
                  dimage.cyOffset = 0;
                   
                  WinSendMsg ( hwndP, CM_SETRECORDEMPHASIS,
                               MPFROMP ( prec ),
                               MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                   
                  DrgDrag ( hwnd, pdinfo, &dimage, 1, VK_ENDDRAG, NULL );
                   
                  WinSendMsg ( hwndP, CM_SETRECORDEMPHASIS,
                               MPFROMP ( prec ),
                               MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                   
                  //WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                    //           MPFROMP ( pRecDrg ),
                      //         MPFROM2SHORT ( FALSE, 0x00004000 ) );//CRA_CURSORED ) );
                   
                  DrgFreeDraginfo ( pdinfo );
               }
               break;
                
               case CN_DRAGAFTER:
               {
                  PCNRDRAGINFO  pcnrDri;
                  PDRAGINFO     pdinfo;
                  PDRAGITEM     pditem;
      
                  pcnrDri = PVOIDFROMMP ( mp2 );
                   
                  pdinfo = pcnrDri->pDragInfo;
                   
                  DrgAccessDraginfo ( pdinfo );
                   
                  pditem = DrgQueryDragitemPtr ( pdinfo, 0 );
                   
                  if ( pditem->hwndItem != hwnd )
                  {
                     DrgFreeDraginfo ( pdinfo );

                     return ( MRFROM2SHORT ( DOR_NEVERDROP, 0 ) );
                  }
                  else if ( DrgVerifyRMF ( pditem, "PM_SCRAPBOOK", "DRF_COLMAINT" ) )
                  { 
                     DrgFreeDraginfo ( pdinfo );
                      
                     return ( MRFROM2SHORT ( DOR_DROP, DO_MOVE ) );
                      
                  }
                  else 
                  {
                     DrgFreeDraginfo ( pdinfo );
                      
                     return ( MRFROM2SHORT ( DOR_NEVERDROP, 0 ) );
                  }
               }
                
               case CN_DROP:
               {
                  PCNRDRAGINFO  pcnrDri;
                  PDRAGINFO     pdinfo;
                  PDRAGITEM     pditem;
                  PFIELDINFO    pfiAft;
                  RECORDINSERT  recins;
      
                  pcnrDri = PVOIDFROMMP ( mp2 );
                   
                  pdinfo = pcnrDri->pDragInfo;
                   
                  DrgAccessDraginfo ( pdinfo );
                   
                  pditem = DrgQueryDragitemPtr ( pdinfo, 0 );
                   
                  prec  = (PMAINTREC) pditem->ulItemID;
                  precX = (PMAINTREC) pcnrDri->pRecord;
                   
                  if ( ! precX || prec == precX )
                  {
                     DrgFreeDraginfo ( pdinfo );
                     break;
                  }
                   
                  WinSendMsg ( hwndP, CM_REMOVERECORD,
                               MPFROMP ( &prec ),
                               MPFROM2SHORT( 1, CMA_INVALIDATE ) );
                   
                  //*** Insert *************************************************
                   
                  recins.cb                = sizeof ( RECORDINSERT );
                  recins.pRecordParent     = NULL;
                  recins.pRecordOrder      = (PRECORDCORE) precX;
                  recins.zOrder            = CMA_TOP;
                  recins.cRecordsInsert    = 1;
                  recins.fInvalidateRecord = TRUE;
                   
                  WinSendMsg ( hwndP, CM_INSERTRECORD,
                               MPFROMP( prec ), MPFROMP ( &recins ) );

                  //*** Editor *************************************************
                   
                  pdr = pRecScn->pdr;

                  pfnSetSplit ( pdr->hwndE, pdr, FALSE );

                  pctl = ( PMCTLREC ) pdr->pvWork;
                   
                  pcol = prec->pcol;//&pctl->mcols[prec->ulX];
                   
                  if ( CMA_FIRST == (LONG) precX )
                     pfiAft = (PFIELDINFO) CMA_FIRST;
                  else
                     pfiAft = precX->pcol->pfi;//pctl->mcols[precX->ulX].pfi;
                   
                  //*** Remove *************************************************

                  WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                               MPFROMP ( &pcol->pfi ),
                               MPFROM2SHORT ( 1, CMA_INVALIDATE ) );
                   
                  pcol->pfi = pfnCol2FInfo ( pdr->hwndE, pcol, pcol->pfi/*NULL*/, pfiAft );
                   
                  pfnSetSplit ( pdr->hwndE, pdr, TRUE );
               }
               break;
                
               case CN_BEGINEDIT:
               {
                  //PCNREDITDATA   pcnrEdt;

                  pRecScn->pdr->fbEditing = TRUE;
                   
                  WinSetDlgItemText ( hwnd, DIT_COLNAME, "~End Edit" );
                   
                  /*pcnrEdt = PVOIDFROMMP ( mp2 );
                   
                  WinSendMsg ( WinWindowFromID ( hwnd, DIT_COLLIST ), CM_SETRECORDEMPHASIS,
                               MPFROMP ( pcnrEdt->pRecord ),
                               MPFROM2SHORT ( TRUE, CRA_SELECTED ) );*/
               }
               break;//return ( MRESULT ) TRUE;
                
               case CN_ENDEDIT:
               {
                  PCNREDITDATA     pcnrEdt;

                  pcnrEdt = PVOIDFROMMP ( mp2 );
                   
                  pRecScn->pdr->fbEditing = FALSE;
                   
                  WinSetDlgItemText ( hwnd, DIT_COLNAME, "~Edit Name" );

                  //*** Setup to Process Column Change *************************

                  ulCmd = MINI_ATTR;

                  prec = (PMAINTREC) pcnrEdt->pRecord;

                  pdr = pRecScn->pdr;
                   
                  pctl = ( PMCTLREC ) pdr->pvWork;
                   
                  pcol = prec->pcol;//&pctl->mcols[prec->ulX];

                  if ( pcnrEdt->cbText )
                  {
                     pcol->pszTitl = realloc ( pcol->pszTitl, pcnrEdt->cbText );
                     strcpy ( pcol->pszTitl, pcnrEdt->pRecord->pszIcon );
                  }
               }
               break;
                
               case CN_REALLOCPSZ:
               {
                  PMAINTREC        pNew;
                  PCNREDITDATA     pcnrEdt;

                  pcnrEdt = PVOIDFROMMP ( mp2 );
                   
                  prec = (PMAINTREC) pcnrEdt->pRecord;

                  pdr = pRecScn->pdr;
                   
                  pctl = ( PMCTLREC ) pdr->pvWork;
                   
                  pcol = prec->pcol;//&pctl->mcols[prec->ulX];
                   
                  pcol->pszTitl = realloc ( pcol->pszTitl, pcnrEdt->cbText );
                  strcpy ( pcol->pszTitl, pcnrEdt->pRecord->pszIcon );
                   
                  pRecScn->pdr->fbModified = TRUE;
                  //fbModified = TRUE;
                   
                  //ulCmd = MINI_ATTR;
                   
                  pcnrEdt->pRecord->pszIcon = realloc ( pcnrEdt->pRecord->pszIcon, pcnrEdt->cbText );
               }
               return ( MRESULT ) TRUE;
                
            }
            //break;
         }
         else
         {
            //if ( ! pRecScn->pdr->fbEditing )
                
            prec = WinSendMsg ( WinWindowFromID ( hwnd, DIT_COLLIST ), CM_QUERYRECORDEMPHASIS,
                                MPFROMLONG ( CMA_FIRST ), MPFROMSHORT( CRA_SELECTED ) );
             
            if ( ! prec ) 
            {
               WinAlarm ( HWND_DESKTOP, WA_NOTE );
                
               break;
            }
             
            pdr = pRecScn->pdr;
             
            pctl = ( PMCTLREC ) pdr->pvWork;
             
            pcol = prec->pcol;//&pctl->mcols[prec->ulX];
             
            switch ( SHORT1FROMMP ( mp1 ) ) 
            {
               case DIT_COLSPLITCOL:
               {
                  ULONG ulX;

                  for ( ulX = 0; ulX < MINI_COLS; ++ulX )
                  {
                     pctl->mcols[ulX].ulOpts &= ~SCB_MINI_SPLT;
                     pctl->mcols[ulX].ulOpts &= ~SCB_MINI_LEFT;
                  }

                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLSPLITCOL ) )
                  {
                     pctl->ulSplit = prec->pcol->ulX + 1;
                     pcol->ulOpts |= SCB_MINI_SPLT;
                  }
                  else
                  {
                     pctl->ulSplit = 0;
                  }
                  /*   pctl->ulSplit = prec->pcol->ulX + 1;
                  else
                     pctl->ulSplit = 0;*/
                   
                  pfnSetSplit ( pdr->hwndE, pdr, TRUE );
               }
               break;
                
               //*** Sort Fields ***********************************************
                
               case DIT_COLSORT1:
               {
                  ULONG     ulX;
   
                  ulCmd = MINI_SHOW;
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLSORT1 ) ) 
                  {
                     for ( ulX = 0; ulX < MINI_SORTS; ++ulX ) 
                     {
                        if ( ( pctl->abSort[ulX] - 1 ) == pcol->ulX )
                           pctl->abSort[ulX] = 0;
                     }
                      
                     pctl->abSort[0] = pcol->ulX + 1;
                      
                  }
                  else 
                     pctl->abSort[0] = 0;
               }
               break;
                
               case DIT_COLSORT2:
               {
                  ULONG     ulX;
   
                  ulCmd = MINI_SHOW;
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLSORT2 ) ) 
                  {
                     for ( ulX = 0; ulX < MINI_SORTS; ++ulX ) 
                     {
                        if ( ( pctl->abSort[ulX] - 1 ) == pcol->ulX ) 
                           pctl->abSort[ulX] = 0;
                     }
                      
                     pctl->abSort[1] = pcol->ulX + 1;
                  }
                  else 
                     pctl->abSort[1] = 0;
               }
               break;
                
               case DIT_COLSORT3:
               {
                  ULONG     ulX;
   
                  ulCmd = MINI_SHOW;
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLSORT3 ) ) 
                  {
                     for ( ulX = 0; ulX < MINI_SORTS; ++ulX ) 
                     {
                        if ( ( pctl->abSort[ulX] - 1 ) == pcol->ulX ) 
                           pctl->abSort[ulX] = 0;
                     }
                      
                     pctl->abSort[2] = pcol->ulX + 1;
                  }
                  else
                     pctl->abSort[2] = 0;
               }
               break;
                
               case DIT_COLSORT4:
               {
                  ULONG     ulX;
   
                  ulCmd = MINI_SHOW;
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLSORT4 ) ) 
                  {
                     for ( ulX = 0; ulX < MINI_SORTS; ++ulX ) 
                     {
                        if ( ( pctl->abSort[ulX] - 1 ) == pcol->ulX ) 
                           pctl->abSort[ulX] = 0;
                     }
                      
                     pctl->abSort[3] = pcol->ulX + 1;
                  }
                  else
                     pctl->abSort[3] = 0;
               }
               break;
                
               case DIT_COLSORT1_DEC:
                   
                  ulCmd = MINI_SHOW;
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLSORT1_DEC ) )
                     pctl->abSOpt[0] |= SCB_MINI_DESC;
                  else
                     pctl->abSOpt[0] &= ~SCB_MINI_DESC;
                   
               break;
                
               case DIT_COLSORT2_DEC:
                   
                  ulCmd = MINI_SHOW;
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLSORT2_DEC ) )
                     pctl->abSOpt[1] |= SCB_MINI_DESC;
                  else
                     pctl->abSOpt[1] &= ~SCB_MINI_DESC;
                   
               break;
                
               case DIT_COLSORT3_DEC:
                   
                  ulCmd = MINI_SHOW;
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLSORT3_DEC ) )
                     pctl->abSOpt[2] |= SCB_MINI_DESC;
                  else
                     pctl->abSOpt[2] &= ~SCB_MINI_DESC;
                   
               break;
                
               case DIT_COLSORT4_DEC:
                   
                  ulCmd = MINI_SHOW;
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLSORT4_DEC ) )
                     pctl->abSOpt[3] |= SCB_MINI_DESC;
                  else
                     pctl->abSOpt[3] &= ~SCB_MINI_DESC;
                   
               break;
                
                
               //*** Alignment Attrs *******************************************
                
               case DIT_COLLEFT:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLLEFT ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCHOpts &= ~CFA_RIGHT;
                     pcol->ulCHOpts &= ~CFA_CENTER;
                      
                     pcol->ulCHOpts |= CFA_LEFT;
                  }
                   
               break;
                
               case DIT_COLRIGHT:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLRIGHT ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCHOpts &= ~CFA_LEFT;
                     pcol->ulCHOpts &= ~CFA_CENTER;
                      
                     pcol->ulCHOpts |= CFA_RIGHT;
                  }
                   
               break;
                
               case DIT_COLCENTER:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLCENTER ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCHOpts &= ~CFA_LEFT;
                     pcol->ulCHOpts &= ~CFA_RIGHT;
                      
                     pcol->ulCHOpts |= CFA_CENTER;
                  }
                   
               break;
                
               case DIT_COLTOP:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLTOP ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCHOpts &= ~CFA_BOTTOM;
                     pcol->ulCHOpts &= ~CFA_VCENTER;
                      
                     pcol->ulCHOpts |= CFA_TOP;
                  }
                   
               break;
                
               case DIT_COLBOTTOM:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLBOTTOM ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCHOpts &= ~CFA_TOP;
                     pcol->ulCHOpts &= ~CFA_VCENTER;
                      
                     pcol->ulCHOpts |= CFA_BOTTOM;
                  }
                   
               break;
                
               case DIT_COLVCENTER:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_COLVCENTER ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCHOpts &= ~CFA_TOP;
                     pcol->ulCHOpts &= ~CFA_BOTTOM;
                      
                     pcol->ulCHOpts |= CFA_VCENTER;
                  }
                   
               break;
                
               case DIT_DATLEFT:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_DATLEFT ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCDOpts &= ~CFA_RIGHT;
                     pcol->ulCDOpts &= ~CFA_CENTER;
                      
                     pcol->ulCDOpts |= CFA_LEFT;
                  }
                   
               break;
                
               case DIT_DATRIGHT:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_DATRIGHT ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCDOpts &= ~CFA_LEFT;
                     pcol->ulCDOpts &= ~CFA_CENTER;
                      
                     pcol->ulCDOpts |= CFA_RIGHT;
                  }
                   
               break;
                
               case DIT_DATCENTER:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_DATCENTER ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCDOpts &= ~CFA_LEFT;
                     pcol->ulCDOpts &= ~CFA_RIGHT;
                      
                     pcol->ulCDOpts |= CFA_CENTER;
                  }
                   
               break;
                
               case DIT_DATTOP:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_DATTOP ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCDOpts &= ~CFA_BOTTOM;
                     pcol->ulCDOpts &= ~CFA_VCENTER;
                      
                     pcol->ulCDOpts |= CFA_TOP;
                  }
                   
               break;
                
               case DIT_DATBOTTOM:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_DATBOTTOM ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCDOpts &= ~CFA_TOP;
                     pcol->ulCDOpts &= ~CFA_VCENTER;
                      
                     pcol->ulCDOpts |= CFA_BOTTOM;
                  }
                   
               break;
                
               case DIT_DATVCENTER:
                   
                  if ( prec && WinQueryButtonCheckstate ( hwnd, DIT_DATVCENTER ) ) 
                  {
                     ulCmd = MINI_ATTR;
                      
                     pcol->ulCDOpts &= ~CFA_TOP;
                     pcol->ulCDOpts &= ~CFA_BOTTOM;
                      
                     pcol->ulCDOpts |= CFA_VCENTER;
                  }
                   
               break;
                
            }
         }
         switch ( ulCmd ) 
         {
            case MINI_ATTR:
                
               pfnSetSplit ( pdr->hwndE, pdr, FALSE );
                
               hwndP = pdr->hwndE;//WinWindowFromID ( hwnd, DIT_COLLIST );
                
               pdr->pfi = WinSendMsg ( hwndP, CM_QUERYDETAILFIELDINFO,
                                       MPFROMP ( pcol->pfi ),
                                       MPFROMSHORT( CMA_PREV ) );
                
               if ( ! pdr->pfi )
                  pdr->pfi = (PFIELDINFO)CMA_FIRST;
                
               //*** Remove *************************************************
                
               /*WinSendMsg ( hwndP, CM_REMOVEDETAILFIELDINFO,
                            MPFROMP ( &pcol->pfi ),
                            MPFROM2SHORT ( 1, CMA_INVALIDATE ) );*/
                
               pcol->pfi = pfnCol2FInfo ( hwndP, pcol, pcol->pfi/*NULL*/, pdr->pfi );
                
               pfnSetSplit ( pdr->hwndE, pdr, TRUE );
                
            break;
             
            case MINI_SHOW:
                
               WinSendMsg ( hwnd, UWM_SHOW, MPFROMP ( prec ), NULL );
                
            break;
             
         }
      }
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
    
     return ( MRESULT ) FALSE;
}
 
/***************************************************************************/
/* Set the Split Bar                                                       */
/***************************************************************************/
BOOL             pfnSetSplit  ( HWND hwndP, PDATREC pdr, BOOL fbSplit ) 
{
   ULONG        ulX;
   PMCTLREC     pctl;
   PFIELDINFO   pfinf;
   PMCOLREC     pcol;
   CNRINFO      cnrinf;
   ULONG        ulSide;
    
   pctl = (PMCTLREC) pdr->pvWork;
    
   cnrinf.pFieldInfoLast = NULL;
    
   cnrinf.xVertSplitbar = -1;
    
   ulSide = SCB_MINI_LEFT;

   if ( fbSplit ) 
   {
      pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                           NULL, MPFROMSHORT( CMA_FIRST ) );
       
      pctl->ulSplit = 0;

      for ( ulX = 0; ulX < MINI_COLS; ++ulX )
      {
         pcol = (PMCOLREC) pfinf->pUserData;
          
         pcol->ulOpts |= ulSide;

         //if ( pcol->ulX == ( pctl->ulSplit - 1 ) )
         if ( pcol->ulOpts & SCB_MINI_SPLT )
         {
            if ( pcol->ulOpts & SCB_MINI_USED )
            {
               cnrinf.pFieldInfoLast = pcol->pfi;
                
               cnrinf.xVertSplitbar = pdr->ulXVS;

               pctl->ulSplit = pcol->ulX + 1;
         
               ulSide = 0;
            }
            /*else
               pctl->ulSplit = 0;*/
             
            break;
         }
         pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                              MPFROMP ( pfinf ),
                              MPFROMSHORT( CMA_NEXT ) );
      }
   }
   else 
   {
      WinSendMsg ( hwndP, CM_QUERYCNRINFO,
                   MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
       
      pdr->ulXVS = cnrinf.xVertSplitbar;
   }
    
   WinSendMsg ( hwndP, CM_SETCNRINFO,
                MPFROMP ( &cnrinf ),
                MPFROMLONG ( CMA_PFIELDINFOLAST | CMA_XVERTSPLITBAR ) );
    
   return TRUE;
}
 
/***************************************************************************/
/* See Which Side of Split Bar We're On                                    */
/***************************************************************************/
USHORT           pfnWhichSplit( HWND hwndP, PDATREC pdr, SHORT cmd, PMCTLREC pctl )
{
   ULONG        ulX;
   USHORT       usWhich;
   PMCOLREC     pcolScn;
   CNRINFO      cnrinf;
   PFIELDINFO   pfinf;
   BOOL         foundIt = FALSE;
    
   WinSendMsg ( hwndP, CM_QUERYCNRINFO,
                MPFROMP( &cnrinf ), MPFROMSHORT ( 16 ) );

   usWhich = usLeftDvWnd;
    
   //*** Find Next/Previous Visible Column *************************************

   if ( cmd == MID_MINI_NEXT )
      pdr->pfi = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                              MPFROMP ( pdr->pfi ),
                              MPFROMSHORT( CMA_NEXT ) );
   else
      pdr->pfi = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                              MPFROMP ( pdr->pfi ),
                              MPFROMSHORT( CMA_PREV ) );
    
   for ( ulX = 0; ulX < MINI_COLS && pdr->pfi; ++ulX )
   {
      pcolScn = (PMCOLREC) pdr->pfi->pUserData;
       
      if ( pcolScn->ulOpts & SCB_MINI_USED )
      {
         if ( pcolScn->ulOpts & SCB_MINI_LEFT )
            return usLeftDvWnd;
         else
            return usRightDvWnd;
         /*if ( ! pctl->ulSplit )
         {
            usWhich = usLeftDvWnd;
      
            return usWhich;
         }
          
         if ( foundIt )
         {
            usWhich = usRightDvWnd;
            break;
         }
          
         if ( cnrinf.pFieldInfoLast == pdr->pfi )
         {
            usWhich = usLeftDvWnd;
            foundIt = TRUE;
         } */
      }
       
      if ( cmd == MID_MINI_NEXT )
         pdr->pfi = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                 MPFROMP ( pdr->pfi ),
                                 MPFROMSHORT( CMA_NEXT ) );
      else
         pdr->pfi = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                 MPFROMP ( pdr->pfi ),
                                 MPFROMSHORT( CMA_PREV ) );
   }
    
   return usWhich;
}
 
/***************************************************************************/
/* Convert Column to Field Info Structure                                  */
/***************************************************************************/
PFIELDINFO       pfnCol2FInfo ( HWND hwndP, PMCOLREC pcol, 
                                PFIELDINFO pfiTo, PFIELDINFO pfiAft )
{
   FIELDINFOINSERT       fInfIns;
    
   if ( ! pfiTo )
      pfiTo = WinSendMsg ( hwndP, CM_ALLOCDETAILFIELDINFO, 
                           MPFROMLONG ( 1 ), NULL);

   WinSendMsg ( hwndP, CM_REMOVEDETAILFIELDINFO,
                MPFROMP ( &pfiTo ),
                MPFROM2SHORT ( 1, CMA_INVALIDATE ) );
    
   pfiTo->cb         = sizeof ( FIELDINFO );
   pfiTo->flData     = pcol->ulCDOpts;
   pfiTo->flTitle    = pcol->ulCHOpts;
   pfiTo->pTitleData = pcol->pszTitl;
   pfiTo->offStruct  = pcol->ulOffset;
   pfiTo->pUserData  = pcol;
    
   //*** Insert ? ************************************************
    
   if ( pfiAft ) 
   {
      fInfIns.cb                   = sizeof ( FIELDINFOINSERT );
      fInfIns.pFieldInfoOrder      = pfiAft;
      fInfIns.cFieldInfoInsert     = 1;
      fInfIns.fInvalidateFieldInfo = TRUE;
       
      WinSendMsg ( hwndP, CM_INSERTDETAILFIELDINFO,
                   MPFROMP ( pfiTo ),
                   MPFROMP ( &fInfIns ) );
   }
    
   return pfiTo;
    
}
 
/***************************************************************************/
/* Copy Data to Memory                                                     */
/***************************************************************************/
ULONG            pfnMiniRecMem( HWND hwnd, PMINIREC pRecIn, ULONG ulSize, PBYTE pbDat ) 
{
   PSZ         *ppszX;
   ULONG        ulX;
   PFIELDINFO   pfi;
   PMCOLREC     pcol;
    
   ULONG        ulLen;
    
   if ( ! ulSize ) 
   {
      pfi = WinSendMsg ( hwnd, CM_QUERYDETAILFIELDINFO,
                         MPFROMP ( NULL ),
                         MPFROMSHORT( CMA_FIRST ) );
       
      for ( ulX = 0; ulX < MINI_COLS; ++ulX ) 
      {
         pcol = (PMCOLREC) pfi->pUserData;
          
         if ( pcol->ulOpts & SCB_MINI_USED )
         {
            ppszX = &pRecIn->psz01;
             
            ppszX += ( pcol->ulX );

            ulSize += strlen ( *ppszX ) + 1;
         }
          
         pfi = WinSendMsg ( hwnd, CM_QUERYDETAILFIELDINFO,
                            MPFROMP ( pfi ),
                            MPFROMSHORT( CMA_NEXT ) );
      }

      ulSize += sizeof ( CDATE );
      ulSize += sizeof ( ULONG );
   }
   else 
   {
      ulSize = 0;
       
      pfi = WinSendMsg ( hwnd, CM_QUERYDETAILFIELDINFO,
                         MPFROMP ( NULL ),
                         MPFROMSHORT( CMA_FIRST ) );
       
      for ( ulX = 0; pfi && ulX < MINI_COLS; ++ulX ) 
      {
         pcol = (PMCOLREC) pfi->pUserData;
          
         if ( pcol->ulOpts & SCB_MINI_USED )
         {
            ppszX = &pRecIn->psz01;
             
            ppszX += ( pcol->ulX );

            ulLen = strlen ( *ppszX ) + 1;
            memcpy ( pbDat, *ppszX, ulLen );
            pbDat += ulLen;
             
            ulSize += ulLen;
         }
          
         pfi = WinSendMsg ( hwnd, CM_QUERYDETAILFIELDINFO,
                            MPFROMP ( pfi ),
                            MPFROMSHORT( CMA_NEXT ) );
      }

      memcpy ( pbDat, &pRecIn->cdUpd, sizeof ( CDATE ) );
      pbDat += sizeof ( CDATE );

      memcpy ( pbDat, &pRecIn->ulOpt, sizeof ( ULONG ) );
      pbDat += sizeof ( ULONG );
   }
    
   return ulSize;
    
}
 
/***************************************************************************/
/* Mini  Sort                                                              */
/***************************************************************************/
SHORT   APIENTRY pfnMiniSort  ( PRECORDCORE pRec1, PRECORDCORE pRec2, PVOID pv ) 
{
   PMINIREC  p1;
   PMINIREC  p2;
    
   PMCTLREC  pctl;
    
   SHORT     sRC;
   SHORT     sX;
    
   PSZ       *ppsz1;
   PSZ       *ppsz2;
   PSZ       psz1;
   PSZ       psz2;
    
   p1 = (PMINIREC) pRec1;
   p2 = (PMINIREC) pRec2;
    
   pctl = ( PMCTLREC) pv;
    
   sRC = 0;
    
   ppsz1 = &p1->psz01;
   ppsz2 = &p2->psz01;
    
   for ( sX = 0; sX < MINI_SORTS && sX < pctl->ulCols; ++sX ) 
   {
      if ( ( ! sRC ) && pctl->abSort[sX] ) 
      {
         psz1 = ppsz1[pctl->abSort[sX]-1];
         psz2 = ppsz2[pctl->abSort[sX]-1];
          
         sRC = stricmp ( psz1, psz2 );
          
         if ( pctl->abSOpt[sX] & SCB_MINI_DESC ) 
         {
            sRC *= (-1);
         }
      }
   }
    
   return sRC;
    
}
 
/***************************************************************************/
/* Mini  Stat                                                              */
/***************************************************************************/
BOOL             pfnMiniStat  ( PUSEREC pRecScn ) 
{
   //CNRINFO               cnrinf;
    
   sprintf ( pRecScn->pdr->pszStat, "%d entries", pRecScn->pdr->ulDEnt );
    
   pfnCnrTitle ( pRecScn->pdr->hwndE, pRecScn->pdr->pszStat );

   //cnrinf.pszCnrTitle  = pRecScn->pdr->pszStat;
    
   //WinSendMsg ( pRecScn->pdr->hwndE, CM_SETCNRINFO, &cnrinf,
     //           MPFROMLONG ( CMA_CNRTITLE ) );
    
   return TRUE;
}
 
/***************************************************************************/
/* Create Mini Container                                                   */
/***************************************************************************/
PBYTE            pfnMiniCont  ( HWND hwnd, PUSEREC pRecScn )
{
   PDATREC           pdr;
   PMCTLREC          pctl;
   CNRINFO           cnrinf;
   PFIELDINFO        pfinf;
   PFIELDINFO        pfinfScn;
   FIELDINFOINSERT   fInfIns;
   SWP               swp;
   ULONG             ulX;
   ULONG             ulLen;
   PBYTE             pbDat;
   PCHAR             pchDat;
   ULONG             ulSide;
    
   pdr = pRecScn->pdr;

   pdr->hwndE = WinCreateWindow ( hwnd, WC_CONTAINER, NULL,
                                  CCS_SINGLESEL,
                                  0,0,0,0, hwnd, HWND_TOP,
                                  WID_CONT, NULL, NULL );
    
   WinSetWindowPtr ( pdr->hwndE, 0, pRecScn );
    
   cnrinf.pszCnrTitle  = pdr->pszStat;
   cnrinf.flWindowAttr = CV_DETAIL | CA_DETAILSVIEWTITLES | CA_ORDEREDTARGETEMPH;
    
   if ( ulMiniOpts & SCB_STATED )
      cnrinf.flWindowAttr |= CA_CONTAINERTITLE | CA_TITLESEPARATOR | CA_TITLEREADONLY;
    
   WinSendMsg ( pdr->hwndE, CM_SETCNRINFO, &cnrinf,
                MPFROMLONG ( CMA_FLWINDOWATTR ) );
    
   pfnSetPPFont ( pdr->hwndE, pdr->fxPtSz, &pdr->fat );
    
   pfnSetPresColors ( pdr->hwndE, pdr->ulNBClr, pdr->ulNFClr, pdr->ulHBClr, pdr->ulHFClr );
    
   WinSendMsg ( pdr->hwndE, CM_QUERYCNRINFO,
                MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
    
   //*** Allocate & Init Field Info ***********************************
    
   pctl = ( PMCTLREC ) pdr->pvWork;
    
   pbDat = pdr->pvDat;

   for ( ulX = 0; ulX < MINI_COLS; ++ulX ) 
   {
      memset ( &pctl->mcols[ulX], 0, sizeof ( MCOLREC ) );

      pctl->mcols[ulX].ulX = ulX;
   }
    
   pfinf = WinSendMsg ( pdr->hwndE, CM_ALLOCDETAILFIELDINFO,
                        MPFROMLONG ( MINI_COLS ), NULL);
   pfinfScn = pfinf;
    
   if ( ! pdr->ulDLen ) 
   {
      pctl->ulCols  = ulMDefCols;
      pctl->ulSplit = 2;
       
      pctl->abSort[0] = 1;
      pctl->abSort[1] = 2;
      pctl->abSort[2] = 3;
      pctl->abSort[3] = 0;
       
      pctl->abSOpt[0] = 0;
      pctl->abSOpt[1] = 0;
      pctl->abSOpt[2] = 0;
      pctl->abSOpt[3] = 0;
       
      for ( ulX = 0; ulX < MINI_COLS; ++ulX ) 
      {
         pctl->mcols[ulX].ulCHOpts = CFA_TOP | CFA_CENTER | CFA_FITITLEREADONLY;
         pctl->mcols[ulX].ulCDOpts = CFA_STRING | CFA_TOP | CFA_LEFT | CFA_HORZSEPARATOR | CFA_SEPARATOR;
         pctl->mcols[ulX].ulOffset = ( ( FIELDOFFSET ( MINIREC, psz01 ) ) + ( ulX * sizeof ( PSZ) ) );
         pctl->mcols[ulX].ulOpts   = 0;
         pctl->mcols[ulX].ulStyl   = 0;
         pctl->mcols[ulX].ulChrs   = 0;
         pctl->mcols[ulX].ulX      = ulX;
         pctl->mcols[ulX].pszTitl  = strdup ( "Title" );
         pctl->mcols[ulX].pfi      = 0;
          
         pfinfScn->cb         = sizeof ( FIELDINFO );
         pfinfScn->flData     = pctl->mcols[ulX].ulCDOpts;
         pfinfScn->flTitle    = pctl->mcols[ulX].ulCHOpts;
         pfinfScn->pTitleData = strdup ( pctl->mcols[ulX].pszTitl );
         pfinfScn->offStruct  = pctl->mcols[ulX].ulOffset;
         pfinfScn->pUserData  = &pctl->mcols[ulX];
          
         if ( ulX < pctl->ulCols )
         {
            pctl->mcols[ulX].ulOpts   = SCB_MINI_USED;

            if ( ulX <= ( pctl->ulSplit - 1 ) )
               pctl->mcols[ulX].ulOpts  |= SCB_MINI_LEFT;

            if ( ulX == ( pctl->ulSplit - 1 ) )
            {
               cnrinf.pFieldInfoLast = pfinfScn;
               pctl->mcols[ulX].ulOpts  |= SCB_MINI_SPLT;
            }
         }
         else
         {
            pfinfScn->flData        |= CFA_INVISIBLE;
         }

         pctl->mcols[ulX].pfi      = pfinfScn;
          
         pfinfScn             = pfinfScn->pNextFieldInfo;
      }
       
      //*** Insert ****************************************************
       
      fInfIns.cb                   = sizeof ( FIELDINFOINSERT );
      fInfIns.pFieldInfoOrder      = (PFIELDINFO)CMA_FIRST;
      fInfIns.cFieldInfoInsert     = MINI_COLS;
      fInfIns.fInvalidateFieldInfo = TRUE;
       
      WinSendMsg ( pdr->hwndE, CM_INSERTDETAILFIELDINFO,
                   MPFROMP ( pfinf ),
                   MPFROMP ( &fInfIns ) );
   }
   else 
   {
       
      memcpy ( &pctl->ulCols, pbDat, sizeof ( ULONG ) );
       
      pbDat += sizeof ( ULONG );
       
      memcpy ( &pctl->ulSplit, pbDat, sizeof ( ULONG ) );
       
      pbDat += sizeof ( ULONG );
       
      memcpy ( &pctl->abSort, pbDat, sizeof ( BYTE ) * MINI_SORTS );
       
      pbDat += ( sizeof ( BYTE ) * MINI_SORTS );
       
      memcpy ( &pctl->abSOpt, pbDat, sizeof ( BYTE ) * MINI_SORTS );
       
      pbDat += ( sizeof ( BYTE ) * MINI_SORTS );
       
      for ( ulX = 0; ulX < MINI_COLS; ++ulX )
      {
         memcpy ( &pctl->mcols[ulX], pbDat, sizeof ( MCOLREC ) );
          
         pbDat += sizeof ( MCOLREC );
      }

      ulSide = SCB_MINI_LEFT;

      for ( ulX = 0; ulX < MINI_COLS; ++ulX )
      {
         pchDat = (PCHAR) pbDat;

         pctl->mcols[ulX].pfi = pfinf;
          
         //*** Get Title **********************************************
          
         ulLen = strlen ( pchDat ) + 1;
          
         pctl->mcols[ulX].pszTitl = malloc ( ulLen );
          
         memcpy ( pctl->mcols[ulX].pszTitl, pchDat, ulLen );
          
         pbDat += ulLen;
          
         //*** Init Field Info ****************************************
          
         pfinfScn->cb         = sizeof ( FIELDINFO );
         pfinfScn->flData     = pctl->mcols[ulX].ulCDOpts;
         pfinfScn->flTitle    = pctl->mcols[ulX].ulCHOpts;
         pfinfScn->pTitleData = pctl->mcols[ulX].pszTitl;
         pfinfScn->pUserData  = &pctl->mcols[ulX];
          
         pfinfScn->offStruct  = pctl->mcols[ulX].ulOffset;
          
         if ( ! ( pctl->mcols[ulX].ulOpts & SCB_MINI_USED ) )
            pfinfScn->flData |= CFA_INVISIBLE;
         else
         {
            pctl->mcols[ulX].ulOpts |= ulSide;

            if ( pctl->mcols[ulX].ulOpts & SCB_MINI_SPLT )
            {
               cnrinf.pFieldInfoLast = pfinfScn;
               ulSide = 0;
            }
         }

         pctl->mcols[ulX].pfi = pfinfScn;
          
         pfinfScn = pfinfScn->pNextFieldInfo;
      }
       
      //*** Insert ****************************************************
       
      fInfIns.cb                   = sizeof ( FIELDINFOINSERT );
      fInfIns.pFieldInfoOrder      = (PFIELDINFO)CMA_FIRST;
      fInfIns.cFieldInfoInsert     = MINI_COLS;
      fInfIns.fInvalidateFieldInfo = TRUE;
       
      WinSendMsg ( pdr->hwndE, CM_INSERTDETAILFIELDINFO,
                   MPFROMP ( pfinf ),
                   MPFROMP ( &fInfIns ) );
       
      //if ( pctl->ulSplit )
        // cnrinf.pFieldInfoLast = pctl->mcols[pctl->ulSplit-1].pfi;
   }
    
   //*** Position Container *******************************************
    
   if ( pctl->ulSplit )
      WinSendMsg ( pdr->hwndE, CM_SETCNRINFO,
                   MPFROMP ( &cnrinf ),
                   MPFROMLONG ( CMA_PFIELDINFOLAST ) );
    
   WinQueryWindowPos ( hwnd, &swp );
    
   WinSetWindowPos ( pdr->hwndE, HWND_TOP,
                     0, 0,
                     swp.cx,
                     swp.cy,
                     SWP_SIZE | SWP_MOVE | SWP_SHOW );
    
   WinSetFocus ( HWND_DESKTOP, pdr->hwndE );
    
   //*** Set up Splitbar **********************************************
    
   if ( (LONG) pdr->ulXVS <= 0 )
      pdr->ulXVS = swp.cx / 4 * 3;
    
   if ( pctl->ulSplit ) 
   {
      cnrinf.xVertSplitbar = pdr->ulXVS;
       
      WinSendMsg ( pdr->hwndE, CM_SETCNRINFO,
                   MPFROMP ( &cnrinf ),
                   MPFROMLONG ( CMA_XVERTSPLITBAR ) );
   }

   return pbDat;
}

//****************************************************************************
// Init Menu
//****************************************************************************
VOID             pfnMiniMenu  ( PUSEREC pRecScn, HWND hwndMenu, SHORT sMID )
{
   PMINIREC   pFoc;

   switch ( sMID )
   {
      case MID_MINI_FILE:
         if ( pqi.pDriverData )
            WinEnableMenuItem ( hwndMenu, MID_MINI_PRINT, TRUE  );
         else
            WinEnableMenuItem ( hwndMenu, MID_MINI_PRINT, FALSE );
      break;
          
      case MID_MINI_EDIT:
          
         if (  pfnIsMyClip ( hwndMenu, atomMini ) )
            WinEnableMenuItem ( hwndMenu, MID_MINI_PASTE, TRUE );
         else
            WinEnableMenuItem ( hwndMenu, MID_MINI_PASTE, FALSE );
          
         pFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                             MPFROMLONG ( CMA_FIRST ),
                             MPFROMSHORT( CRA_SELECTED ) );
          
         if (  pFoc ) 
         {
            WinEnableMenuItem ( hwndMenu, MID_MINI_CUT,  TRUE );
            WinEnableMenuItem ( hwndMenu, MID_MINI_COPY, TRUE );
            WinEnableMenuItem ( hwndMenu, MID_MINI_DELT, TRUE );
         }
         else 
         {
            WinEnableMenuItem ( hwndMenu, MID_MINI_CUT,  FALSE );
            WinEnableMenuItem ( hwndMenu, MID_MINI_COPY, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_MINI_DELT, FALSE );
         }
          
         if ( pRecScn->pdr->psSrch->hwndS  || ! pFoc )
            WinEnableMenuItem ( hwndMenu, MID_MINI_FIND, FALSE );
         else 
            WinEnableMenuItem ( hwndMenu, MID_MINI_FIND, TRUE  );
          
         if ( *pRecScn->pdr->psSrch->pszFnd && pFoc )
            WinEnableMenuItem ( hwndMenu, MID_MINI_FNDNXT, TRUE );
         else 
            WinEnableMenuItem ( hwndMenu, MID_MINI_FNDNXT, FALSE );
      break;
   }
}

//****************************************************************************
// Init Mini Strings
//****************************************************************************
VOID             pfnInitStrings( PMINIREC pNew )
{
   pNew->psz01 = malloc ( 1 );
   pNew->psz02 = malloc ( 1 );
   pNew->psz03 = malloc ( 1 );
   pNew->psz04 = malloc ( 1 );
   pNew->psz05 = malloc ( 1 );
   pNew->psz06 = malloc ( 1 );
   pNew->psz07 = malloc ( 1 );
   pNew->psz08 = malloc ( 1 );
   pNew->psz09 = malloc ( 1 );
   pNew->psz10 = malloc ( 1 );
   pNew->psz11 = malloc ( 1 );
   pNew->psz12 = malloc ( 1 );
   pNew->psz13 = malloc ( 1 );
   pNew->psz14 = malloc ( 1 );
   pNew->psz15 = malloc ( 1 );
   pNew->psz16 = malloc ( 1 );
    
   *pNew->psz01 = 0;
   *pNew->psz02 = 0;
   *pNew->psz03 = 0;
   *pNew->psz04 = 0;
   *pNew->psz05 = 0;
   *pNew->psz06 = 0;
   *pNew->psz07 = 0;
   *pNew->psz08 = 0;
   *pNew->psz09 = 0;
   *pNew->psz10 = 0;
   *pNew->psz11 = 0;
   *pNew->psz12 = 0;
   *pNew->psz13 = 0;
   *pNew->psz14 = 0;
   *pNew->psz15 = 0;
   *pNew->psz16 = 0;
}

//****************************************************************************
// Print Thread
//****************************************************************************
VOID             pfnMiniPrtThd       ( PVOID pv )
{
   HMQ         hmq;
   PDATREC     pdr;
   PMINIREC    pPrt;
   ULONG       ulPrinted = 0;
   LONG        lCharsOut;
   LONG        lCharsLeft = 1;
   LONG        lNewBottom;
   LONG        lLowBottom;
   BOOL        fbCausePage = FALSE;
   FONTMETRICS fm;
   RECTL       rclText;
   POINTL      pt;
   SHORT       sColsDone;
   SHORT       sCurCol;
   SHORT       sX;
   //CHAR        ach32[32];
   PSZ        *ppszX;
   PFIELDINFO  pfinf;
   PMCOLREC    pcol;

   hmq = WinCreateMsgQueue ( WinQueryAnchorBlock ( hwndM ), 0 );

   pdr = pprtCtl->pPrtRec->pdr;

   ++pprtCtl->ulPrtPage;

   pdr->ulPrtPage = pprtCtl->ulPrtPage;

   pfnMiniPrintInit ();

   fm = pprtCtl->fmAll;

   //*** Print Entry ********************************************************

   rclText.yBottom = pprtCtl->rclBody.yBottom;
   rclText.yTop    = rclText.yBottom;

   sColsDone = pprtCtl->sVisCols;

   for ( sX = 0; sX < MINI_COLS; ++sX )
   {
      pprtCtl->abfinf[sX]   = TRUE;
      pprtCtl->apszfinf[sX] = NULL;
   }

   pPrt = pfnGetCnrRec ( pdr->hwndE, NULL );
    
   while ( pPrt && fbPrinting )
   {
      if ( rclText.yTop - fm.lMaxBaselineExt < rclText.yBottom )
      {
         pfnMiniNewPage ( fbCausePage );

         fbCausePage = TRUE;
         rclText.yTop = pprtCtl->arclfinf[0].yBottom - fm.lMaxDescender;
         lLowBottom   = rclText.yTop;
         lNewBottom   = lLowBottom;
      }

      sCurCol = 0;

      //*** Print Columns ***************************************************

      pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                           MPFROMP ( NULL ),
                           MPFROMSHORT( CMA_FIRST ) );
       
      for ( sX = 0; sX < MINI_COLS; ++sX )
      {
         pcol = (PMCOLREC) pfinf->pUserData;
          
         if ( pcol->ulOpts & SCB_MINI_USED )
         {
            if ( pprtCtl->abfinf[sCurCol] )
            {
               rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
               rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;
   
               if ( ! pprtCtl->apszfinf[sCurCol] )
               {
                  ppszX = &pPrt->psz01;
   
                  ppszX += ( pcol->ulX /*- 1*/ );
   
                  pprtCtl->apszfinf[sCurCol] = *ppszX;
               }
   
               lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter,
                                              pprtCtl->apszfinf[sCurCol],
                                              &rclText, &pprtCtl->fmAll,
                                              &lNewBottom, &lCharsLeft, 
                                              pprtCtl->alFmt[sCurCol],//DT_LEFT | DT_VCENTER,
                                              TRUE, FALSE, TRUE );
         
               if ( lCharsLeft && lCharsOut )
                  pprtCtl->apszfinf[sCurCol] += lCharsOut;
               else
               {
                  --sColsDone;
                  pprtCtl->abfinf[sCurCol] = FALSE;
               }
   
               if ( lNewBottom && lLowBottom > lNewBottom )
                  lLowBottom = lNewBottom;
            }
         }

         ++sCurCol;

         pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                              MPFROMP ( pfinf ),
                              MPFROMSHORT( CMA_NEXT ) );
          
      }

      //*** End of Record Processing ****************************************

      rclText.yTop  = lLowBottom;
      rclText.yTop -= fm.lMaxDescender;

      if ( ! sColsDone )
      {
         if ( rclText.yTop - ( fm.lMaxBaselineExt + fm.lMaxDescender ) > 
              rclText.yBottom )
         {
            pt.y = rclText.yTop;
            pt.x = pprtCtl->rclPage.xLeft;
   
            GpiMove ( pprtCtl->hpsPrinter, &pt );
   
            pt.x = pprtCtl->rclPage.xRight;
   
            GpiLine ( pprtCtl->hpsPrinter, &pt );
         }

         rclText.yTop -= fm.lMaxDescender;

         sColsDone = pprtCtl->sVisCols;
      
         for ( sX = 0; sX < MINI_COLS; ++sX )
         {
            pprtCtl->abfinf[sX]   = TRUE;
            pprtCtl->apszfinf[sX] = NULL;
         }
      
         WinPostMsg ( pprtCtl->hwndPrtDlg, UWM_STAT, 
                      MPFROMLONG ( ++ulPrinted ),
                      MPFROMLONG ( pdr->ulDEnt ) );

         pPrt = pfnGetCnrRec ( pdr->hwndE, pPrt );
      }
   }
   //*** Clear Out **********************************************************

   /*if ( pbBuf )
      free ( pbBuf );*/

   if ( fbPrinting )
      WinPostMsg ( pprtCtl->hwndPrtDlg, UWM_DONE, NULL, NULL );

   WinDestroyMsgQueue ( hmq );

   DosPostEventSem ( evtThdDone );

   //DosExit ( EXIT_THREAD, 0 );
   _endthread();
}

//****************************************************************************
// Print New Page
//****************************************************************************
VOID             pfnMiniNewPage      ( BOOL fbCausePage )
{
   PDATREC     pdr;
   LONG        lCharsOut;
   LONG        lCharsLeft;
   LONG        lNewBottom;
   SHORT       sX;
   CHAR        ach32[32];
   POINTL      pt;
   PFIELDINFO  pfinf;
   PMCOLREC    pcol;

   pdr = pprtCtl->pPrtRec->pdr;

   lNewBottom = pprtCtl->rclPage.yTop;

   //*** Print Heading ***************************************************

   if ( fbCausePage )
   {
      pfnPrintPageEject ( pdr->hwndD, pprtCtl->hpsPrinter );

      ++pprtCtl->ulPrtPage;
   }

   else if ( ulTreeOpts & SCB_PRTHEAD )
   {
      pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                        &pprtCtl->defPrtHed.fat, FONTID_HED );

      lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter, 
                                     pprtCtl->pPrtRec->crecCore.pszTree,
                                     &pprtCtl->rclPage, &pprtCtl->fmHed,
                                     &lNewBottom, &lCharsLeft, 
                                     DT_LEFT | DT_VCENTER,
                                     FALSE, FALSE, FALSE );
   
   }

   //*** Adjust to Printed Heading Height First Time Through *************

   if ( ! fbCausePage )
   {
      pprtCtl->rclBody.yTop = lNewBottom - pprtCtl->fmAll.lMaxBaselineExt;

      for ( sX = 0; sX < MINI_COLS; ++sX )
      {
         pprtCtl->arclfinf[sX].yTop    = pprtCtl->rclBody.yTop;
         pprtCtl->arclfinf[sX].yBottom = pprtCtl->rclBody.yTop -
                                         ( pprtCtl->fmAll.lMaxBaselineExt * 
                                           pprtCtl->lHedLines );
      }
   }

   //*** Print Page Number ***********************************************

   if ( ulTreeOpts & SCB_PRTPAGE )
   {
      pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                        &pprtCtl->defPrtCnt.fat, FONTID_CNT );


      sprintf ( ach32, "-  %d  -", pprtCtl->ulPrtPage );
   
      pfnPaintText ( pprtCtl->hpsPrinter, ach32, 
                     &pprtCtl->rclFoot, &pprtCtl->fmCnt,
                     DT_CENTER | DT_BOTTOM, FALSE, FALSE );
   }

   //*** Print Column Headings *******************************************

   pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                     &pprtCtl->defPrtAll.fat, FONTID_ALL );

   pfnPaintBox ( pprtCtl->hpsPrinter, &pprtCtl->rclBody );

   lCharsOut = pprtCtl->fmAll.lMaxBaselineExt / 2;

   pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                        MPFROMP ( NULL ),
                        MPFROMSHORT( CMA_FIRST ) );
    
   for ( sX = 0; sX < MINI_COLS; ++sX )
   {
      pcol = (PMCOLREC) pfinf->pUserData;
       
      if ( pcol->ulOpts & SCB_MINI_USED )
      {
         pprtCtl->arclfinf[sX].yTop -= lCharsOut;
   
         pfnPaintTextRect ( pprtCtl->hpsPrinter,
                            (PSZ)pfinf->pTitleData,
                            &pprtCtl->arclfinf[sX], 
                            &pprtCtl->fmAll,
                            &lNewBottom, &lCharsLeft, 
                            DT_CENTER | DT_VCENTER,
                            FALSE, FALSE, FALSE );
   
         pprtCtl->arclfinf[sX].yTop += lCharsOut;
   
         pt.x = pprtCtl->arclfinf[sX].xLeft;
         pt.y = pprtCtl->rclBody.yTop;
   
         GpiMove ( pprtCtl->hpsPrinter, &pt );
   
         pt.y = pprtCtl->rclBody.yBottom;
   
         GpiLine ( pprtCtl->hpsPrinter, &pt );
      }

      pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                           MPFROMP ( pfinf ),
                           MPFROMSHORT( CMA_NEXT ) );
   }

   pt.x = pprtCtl->rclPage.xLeft;
   pt.y = pprtCtl->arclfinf[0].yBottom;

   GpiMove ( pprtCtl->hpsPrinter, &pt );

   pt.x = pprtCtl->rclPage.xRight;

   GpiLine ( pprtCtl->hpsPrinter, &pt );

}

//****************************************************************************
// Print Initialization
//****************************************************************************
VOID             pfnMiniPrintInit    (  )
{
   PDATREC     pdr;
   PMCTLREC    pctl;
   PMCOLREC    pcol;
   LONG        lLeft;
   SHORT       sX;
   RECTL       rclCalc;
   LONG        lNumLines;
   PFIELDINFO  pfinf;
   PFIELDINFO  pfinfLast;
   SHORT       sXLast;

   pdr = pprtCtl->pPrtRec->pdr;

   pctl = ( PMCTLREC ) pdr->pvWork;

   //*** Set Entry Font *****************************************************

   if ( pprtCtl->fbNewFont )
   {
      pdr->fxPtSzPrt = pprtCtl->defPrtAll.fxPtSz;
      pdr->fatPrt    = pprtCtl->defPrtAll.fat;
   }

   if ( pdr->fxPtSzPrt )
   {
      pprtCtl->defPrtAll.fxPtSz = pdr->fxPtSzPrt;
      pprtCtl->defPrtAll.fat    = pdr->fatPrt;
   }

   pfnCvtVecFont     ( pprtCtl->hpsPrinter, 
                       pprtCtl->defPrtAll.fxPtSz,
                       &pprtCtl->defPrtAll.fat );

   pfnSetPaintFont   ( pdr->hwndD, pprtCtl->hpsPrinter, 
                       &pprtCtl->defPrtAll.fat, FONTID_ALL );

   GpiQueryFontMetrics ( pprtCtl->hpsPrinter, sizeof ( FONTMETRICS ), 
                         &pprtCtl->fmAll );

   //*** Column Setup ******************************************************* */

   pprtCtl->sVisCols = 0;

   if ( pdr->hwndD )
   {
      pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                           MPFROMP ( NULL ),
                           MPFROMSHORT( CMA_FIRST ) );
       
      for ( sX = 0; sX < MINI_COLS; ++sX )
      {
         pcol = (PMCOLREC) pfinf->pUserData;
          
         if ( pcol->ulOpts & SCB_MINI_USED )
         {
            ++pprtCtl->sVisCols;

            //pdr->colInfo[sX].pfinf = pfinf; ???
   
            pprtCtl->alfinf[sX] = pfnCnrColPels ( pdr->hwndE, pfinf );
      
            pprtCtl->alfinf[sX] += ( pprtCtl->fmAll.lAveCharWidth * 2 );
      
            pprtCtl->alIds[sX]   = pcol->ulX + 1;
             
            if ( pcol->ulCDOpts & CFA_LEFT )
               pprtCtl->alFmt[sX] = DT_LEFT | DT_TOP;
            else if ( pcol->ulCDOpts & CFA_CENTER )
               pprtCtl->alFmt[sX] = DT_CENTER | DT_TOP;
            else
               pprtCtl->alFmt[sX] = DT_RIGHT | DT_TOP;
         }
         else
         {
            pprtCtl->alfinf[sX] = 0;
         }
          
         pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                              MPFROMP ( pfinf ),
                              MPFROMSHORT( CMA_NEXT ) );
      }
       
   }

   /*pprtCtl->rclPage.xRight = */pfnPrintALScale ( pprtCtl->rclPage.xRight -
                                               pprtCtl->rclPage.xLeft,
                                               MINI_COLS,//pctl->ulCols,
                                               pprtCtl->alfinf );

   pprtCtl->rclBody.xRight = pprtCtl->rclPage.xRight;
   pprtCtl->rclFoot.xRight = pprtCtl->rclPage.xRight;

   //*** Column Headings Setup ********************************************** */

   lLeft = pprtCtl->rclPage.xLeft;

   pprtCtl->lHedLines = 0;

   pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                        MPFROMP ( NULL ),
                        MPFROMSHORT( CMA_FIRST ) );
    
   for ( sX = 0; sX < MINI_COLS; ++sX )
   {
      pcol = (PMCOLREC) pfinf->pUserData;
       
      if ( pcol->ulOpts & SCB_MINI_USED )
      {
         pprtCtl->arclfinf[sX].yBottom = pprtCtl->rclPage.yBottom;
         pprtCtl->arclfinf[sX].yTop    = pprtCtl->rclPage.yTop;
   
         pprtCtl->arclfinf[sX].xLeft  = lLeft;
         pprtCtl->arclfinf[sX].xRight = lLeft + pprtCtl->alfinf[sX];
   
         lLeft = pprtCtl->arclfinf[sX].xRight;
   
         //*** Calc Deepest Column *********************************************
   
         pfnPaintCalcRect ( pprtCtl->hpsPrinter,
                            (PSZ)pfinf->pTitleData,
                            &pprtCtl->arclfinf[sX], 
                            &pprtCtl->fmAll,
                            &rclCalc,
                            &lNumLines,
                            DT_CENTER | DT_VCENTER,
                            FALSE, FALSE );
   
         if ( lNumLines > pprtCtl->lHedLines )
            pprtCtl->lHedLines = lNumLines;
   
         pfinfLast = pfinf;
         sXLast    = sX;
      }

      pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                           MPFROMP ( pfinf ),
                           MPFROMSHORT( CMA_NEXT ) );
   }

   pprtCtl->arclfinf[sXLast].xRight = pprtCtl->rclPage.xRight;

   pfnPaintCalcRect ( pprtCtl->hpsPrinter,
                      (PSZ)pfinfLast->pTitleData,
                      &pprtCtl->arclfinf[sXLast],
                      &pprtCtl->fmAll,
                      &rclCalc,
                      &lNumLines,
                      DT_CENTER | DT_VCENTER,
                      FALSE, FALSE );

   if ( lNumLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = lNumLines;

   ++pprtCtl->lHedLines;
}

//****************************************************************************
// Convert Old 2-Column Lists to MiniBases
//****************************************************************************
BOOL             pfnLst2MiniBase     ( PUSEREC pRecIn )
{
   PDATREC    pdr;
   PBYTE      pbDat;
   ULONG      ulLen;
   ULONG      ulTmp;
   ULONG      ulOff;
   ULONG      ulX;

   ULONG      ulNewSize;
   PVOID      pvDat;
   PBYTE      pbDatNew;

   PMCTLREC   pctl;
   //PMCOLREC   pcol;

   pdr = pRecIn->pdr;

   //*** Get Data Record Size ***********************************************

   ulLen = 0;

   pbDat = pdr->pvDat;

   //*** Title Lengths *********************************************************

   ulTmp  = strlen ( pbDat ) + 1;
   pbDat += ulTmp;
   ulLen += ulTmp;
       
   ulTmp  = strlen ( pbDat ) + 1;
   pbDat += ulTmp;
   ulLen += ulTmp;
       
   ulLen += ( ( MINI_COLS - 2 ) * 5 );

   //*** Data Lengths **********************************************************

   for ( ulOff = 0; ulOff < pdr->ulDEnt; ++ulOff ) 
   {
      ulTmp  = strlen ( pbDat ) + 1;
      pbDat += ulTmp;
      ulLen += ulTmp;
          
      ulTmp  = strlen ( pbDat ) + 1;
      pbDat += ulTmp;
      ulLen += ulTmp;
          
      ulTmp  = sizeof ( CDATE );
      pbDat += ulTmp;
      ulLen += ulTmp;

      ulLen  = sizeof ( ULONG );   // New Empty Options
      ulLen += ( MINI_COLS - 2 );  // New empty columns
   }

   //*** Calc MiniBase Size *************************************************

   ulNewSize  = sizeof ( ULONG ) * 4;
   ulNewSize += ( sizeof ( MCOLREC ) * MINI_COLS );
   ulNewSize += ulLen;
   //ulNewSize += ( pdr->ulDEnt * ( sizeof ( ULONG ) + 14 ) );

   //*** Convert Data *******************************************************

   pvDat = malloc ( ulNewSize );

   if ( ! pvDat )
      return FALSE;

   pbDatNew = (PBYTE) pvDat;
   pctl     = (PMCTLREC) pvDat;

   pctl->ulCols    = 2;
   pctl->ulSplit   = 1;
   pctl->abSort[0] = 1;
   pctl->abSort[1] = 2;
   pctl->abSort[2] = 3;
   pctl->abSort[3] = 0;
    
   pctl->abSOpt[0] = 0;
   pctl->abSOpt[1] = 0;
   pctl->abSOpt[2] = 0;
   pctl->abSOpt[3] = 0;
    
   for ( ulX = 0; ulX < MINI_COLS; ++ulX ) 
   {
      memset ( &pctl->mcols[ulX], 0, sizeof ( MCOLREC ) );

      pctl->mcols[ulX].ulCHOpts = CFA_TOP | CFA_CENTER | CFA_FITITLEREADONLY; 
      pctl->mcols[ulX].ulCDOpts = CFA_STRING | CFA_TOP | CFA_LEFT | CFA_HORZSEPARATOR | CFA_SEPARATOR; 
      pctl->mcols[ulX].ulOpts   = (ulX < 2 ) ? SCB_MINI_USED : 0;
      pctl->mcols[ulX].ulStyl   = 0;
      pctl->mcols[ulX].ulOffset = ( ( FIELDOFFSET ( MINIREC, psz01 ) ) + ( ulX * sizeof ( PSZ) ) );
      pctl->mcols[ulX].ulChrs   = 0;
      pctl->mcols[ulX].pfi      = NULL;
      pctl->mcols[ulX].pszTitl  = NULL;
      pctl->mcols[ulX].ulX      = ulX;
   }
    
   pctl->mcols[0].ulOpts |= ( SCB_MINI_LEFT | SCB_MINI_SPLT );

   pbDatNew  = (PBYTE) pvDat;
   pbDatNew += 16;//( sizeof ( MCTLREC ) - sizeof ( PVOID ) );
   pbDatNew += ( sizeof ( MCOLREC ) * MINI_COLS );
       
   pbDat = pdr->pvDat;

   ulLen = strlen ( pbDat ) + 1;
   strcpy ( pbDatNew, pbDat );
   pbDat    += ulLen;
   pbDatNew += ulLen;
    
   ulLen = strlen ( pbDat ) + 1;
   strcpy ( pbDatNew, pbDat );
   pbDat    += ulLen;
   pbDatNew += ulLen;
    
   for ( ulOff = 0; ulOff < MINI_COLS - 2; ++ulOff )
   {
      ulLen = strlen ( "Name" ) + 1;
      strcpy ( pbDatNew, "Name" );
      pbDatNew += ulLen;
   }
    
   for ( ulOff = 0; ulOff < pdr->ulDEnt; ++ulOff ) 
   {
      ulLen = strlen ( pbDat ) + 1;
      strcpy ( pbDatNew, pbDat );
      pbDat    += ulLen;
      pbDatNew += ulLen;

      ulLen = strlen ( pbDat ) + 1;
      strcpy ( pbDatNew, pbDat );
      pbDat    += ulLen;
      pbDatNew += ulLen;

      memset ( pbDatNew, 0, 14 );
      pbDatNew += 14;

      ulLen  = sizeof ( CDATE );
      memcpy ( pbDatNew, pbDat, ulLen );
      pbDat    += ulLen;
      pbDatNew += ulLen;

      memset ( pbDatNew, 0, 4 );
      pbDatNew += 4;
   }

   //*** Replace Data Pointer ***********************************************

   free ( pdr->pvDat );

   pdr->pvDat = pvDat;

   pRecIn->ulType = WID_MINI;
   pRecIn->ulReal = WID_MINI;

   fbModified = TRUE;

   return TRUE;
}

//****************************************************************************
/* Record Layout:

   ulCols
   ulSplit
   abSort
   abSOpt
   MCOLREC[MINI_COLS]
   pszTitle ( * MINICOLS )
   entries:
      psz01 to psz16
      CDATE
      ULONG
*/
