 
#define VAR_SCOPE
 
#include "fsp.h"
 
//*** Prototypes ************************************************************ */
 
BOOL             pfnDefTree   ( PUSEREC );
BOOL             pfnLoadOpts  ( VOID );
MRESULT EXPENTRY pfndpNotebook( HWND, ULONG, MPARAM, MPARAM );
 
/***************************************************************************/
/* Main Entry Point                                                        */
/***************************************************************************/
INT              main         ( USHORT usArgc, PSZ psz[] ) 
{
   HAB      habMain;
   HMQ      hmqMain;
   QMSG     qmsg;
    
   HELPINIT help;
    
   ULONG    flCreate;
    
   SWP      swp;
   ULONG    ulWid;
    
   HATOMTBL hatSysAtom;
    
   BOOL     fbDoSettings = FALSE;

   //*** PM *****************************************************************
    
   habMain = WinInitialize ( ( USHORT ) NULL );
    
   hmqMain = WinCreateMsgQueue ( habMain, 0 );
    
   //*** Suicide Run ? ******************************************************
 
   if ( usArgc == 2 ) 
   {
      if ( ! stricmp ( psz[1], "REMOVE_PMSB_NOW" ) )
      {
         if ( pfnMsgYesNo ( HWND_DESKTOP, APP_TITLE,
                            "Remove PM Scrapbook Settings ?" ) )
         {
            PrfWriteProfileData ( HINI_USERPROFILE, PRG_TITLE, NULL, NULL, 0 );
             
            DosExit ( EXIT_PROCESS, 0 );
         }
      }
   }
 
   //*** INI ****************************************************************
    
   pszQueueName  = malloc ( QNAME_LEN );
   *pszQueueName = 0;

   fbUnregistered = UNREGSTRD;

   if ( ! pfnLoadOpts () )
      fbDoSettings = TRUE;
    
   if ( fbUnregistered || fbDoSettings )
      WinDlgBox ( HWND_DESKTOP, HWND_DESKTOP, pfndpAbout,
                  0L, DLG_ABOUT, NULL );
    
   //*** Main Window ********************************************************
    
   WinRegisterClass ( habMain, "PMScrapBook", pfnwpMainWin, 0L, 4 );
    
   flCreate = FCF_SYSMENU | FCF_TITLEBAR | FCF_ACCELTABLE | FCF_MINMAX | FCF_ICON | FCF_MENU |
              FCF_TASKLIST | FCF_SIZEBORDER | FCF_NOBYTEALIGN | FCF_SHELLPOSITION;
    
   hwndFrame = WinCreateStdWindow ( HWND_DESKTOP, 0L, &flCreate,
                                    "PMScrapBook",
                                    "PM Scrapbook",
                                    0L, 0L, (ULONG)WID_MAIN, &hwndM );
    
   hwndTreeMenu = WinWindowFromID ( hwndFrame, FID_MENU );

   if ( ! ( ulTreeOpts & SCB_MENUED ) )
   {
      WinSetParent ( hwndTreeMenu, HWND_OBJECT, FALSE );
       
      WinSendMsg ( hwndFrame, WM_UPDATEFRAME, (MPARAM) FCF_MENU, 0 );
   }

   //*** Help Init **********************************************************
    
   help.cb                       = sizeof (HELPINIT);
   help.ulReturnCode             = 0;
   help.pszTutorialName          = NULL;
   help.phtHelpTable             = (PHELPTABLE) ( 0xFFFF0000 | WID_HELP );
   help.hmodHelpTableModule      = 0;
   help.hmodAccelActionBarModule = 0;
   help.idAccelTable             = 0;
   help.idActionBar              = 0;
   help.fShowPanelId             = CMIC_HIDE_PANEL_ID;
   help.pszHelpWindowTitle       = "PM Scrapbook Help";
   help.pszHelpLibraryName       = "PMScrpBk.hlp";
    
   hwndH = WinCreateHelpInstance ( habMain, &help );
    
   if ( hwndH ) 
      WinAssociateHelpInstance ( hwndH, hwndFrame );
   else 
   {
      help.pszHelpLibraryName = "PMScrpBk.hlp";
       
      hwndH = WinCreateHelpInstance ( habMain, &help );
       
      if ( hwndH )
         WinAssociateHelpInstance ( hwndH, hwndFrame );
      else 
      {
         WinAlarm ( HWND_DESKTOP, WA_NOTE );
         /*WinMessageBox ( HWND_DESKTOP, hwndFrame,
                        "Could not open help file.",
                        "PM Scrapbook ERROR", 0, MB_OK | MB_ICONEXCLAMATION );*/
      }
   }
    
   //*** Window Sizes & Positions *******************************************
    
   WinQueryTaskSizePos ( habMain, 0, &swp );
    
   WinSetWindowPos ( hwndFrame, HWND_TOP, swp.x, swp.y, swp.cx, swp.cy, SWP_MOVE | SWP_SIZE | SWP_SHOW );
    
   WinQueryWindowPos ( hwndM, &swp );
    
   /*WinSetWindowPos ( WinQueryWindow ( hwndT, QW_PARENT ), HWND_TOP,
                     0,
                     swp.cy / 4,
                     swp.cx / 2,
                     swp.cy / 4 * 3,
                     SWP_SIZE | SWP_MOVE | SWP_SHOW );*/
   ulWid = swp.cx;
    
   WinQueryWindowPos ( hwndS, &swp );
    
   WinSetWindowPos ( hwndS, HWND_TOP,
                     ulWid - swp.cx, 0, 0, 0,
                     SWP_MOVE );
    
   //*** Window Classes *****************************************************
    
   WinRegisterClass ( habMain, "PMScbText", pfnwpTextWin, 0L, 4 );
   WinRegisterClass ( habMain, "PMScbAddr", pfnwpAddrWin, 0L, 4 );
   WinRegisterClass ( habMain, "PMScbToDo", pfnwpToDoWin, 0L, 4 );
//   WinRegisterClass ( habMain, "PMScbLst2", pfnwpLst2Win, 0L, 4 );
   WinRegisterClass ( habMain, "PMScbMini", pfnwpMiniWin, 0L, 4 );
    
    
   //*** Clipboard Formats **************************************************
    
   hatSysAtom = WinQuerySystemAtomTable ();
    
   atomTree = WinAddAtom ( hatSysAtom, "Get Organized ! Tree" );
   atomAddr = WinAddAtom ( hatSysAtom, "Get Organized ! Addr" );
   atomToDo = WinAddAtom ( hatSysAtom, "Get Organized ! ToDo" );
//   atomLst2 = WinAddAtom ( hatSysAtom, "Get Organized ! Lst2" );
   atomMini = WinAddAtom ( hatSysAtom, "Get Organized ! Mini" );
    
   //*** Misc Inits *********************************************************
    
   //pRecAll = malloc ( sizeof ( USEREC ) );
    
   //pRecAll->pdr = malloc ( sizeof ( DATREC ) );
    
   pszSearch = malloc ( 32 );
   *pszSearch = 0;
    
   DosCreateEventSem ( NULL, &evtThdDone, 0, FALSE );

   pszCurrFile = pfnFileNameBuf ( NULL );

   usLeftDvWnd  = CID_LEFTDVWND;
   usRightDvWnd = CID_RIGHTDVWND;
    
   WinSetFocus ( HWND_DESKTOP, hwndC );
    
   fbGotModem = FALSE;

   /*hfilModem = pfnDialOpen ( achComX );

   if ( hfilModem )
   {
      if ( pfnDialTest ( hfilModem ) )
         fbGotModem = TRUE;

      DosClose ( hfilModem );
   } */

   hfilModem = NULLHANDLE;

   ctrycode.country  = 0;
   ctrycode.codepage = 0;
    
   DosQueryCtryInfo ( sizeof(COUNTRYINFO), &ctrycode, &ci, &flCreate );

   //*** Parse Arg Line *****************************************************
    
   pRec = 0;

   if ( usArgc == 2 ) 
      pfnReadFile ( hwndM, psz[1] );
   else
      WinPostMsg ( hwndM, WM_COMMAND, MPFROM2SHORT ( MID_MAIN_NEW, 0 ), NULL );
    
   if ( fbDoSettings )
      WinPostMsg ( hwndM, WM_COMMAND, MPFROM2SHORT ( MID_MAIN_SETTINGS, 0 ), NULL );

   while ( WinGetMsg ( habMain, &qmsg, 0L, 0L, 0L ) )
           WinDispatchMsg ( habMain, ( PQMSG ) &qmsg );
    
   //*** Clean Up ***********************************************************
    
   free ( pszSearch );
   free ( pszCurrFile );
   free ( pszQueueName );
    
   free ( pRecAll->pdr );
    
   free ( pRecAll );
    
   WinDestroyHelpInstance ( hwndH );
    
   WinDeleteAtom ( hatSysAtom, atomTree );
   WinDeleteAtom ( hatSysAtom, atomAddr );
   WinDeleteAtom ( hatSysAtom, atomToDo );
   WinDeleteAtom ( hatSysAtom, atomLst2 );
   WinDeleteAtom ( hatSysAtom, atomMini );
    
   WinDestroyWindow ( hwndFrame );
    
   WinDestroyMsgQueue ( hmqMain );
    
   WinTerminate ( habMain );
    
   DosExit ( EXIT_PROCESS, 0 );
    
   return 0;
}
 
/***************************************************************************/
/* Initialize New Scrapbook                                                */
/***************************************************************************/
BOOL             pfnNewBook   ( HWND hwnd, PSZ pszInFile )
{
   PDATREC    pdr;
   PSZ        pszTmp;
    
   //*** Reset Set Tree State, Fonts & Colors *******************************
    
   pfnDefTree ( pRecAll );
    
   pdr = pRecAll->pdr;
    
   pdr->ulDEnt = 1; // 112
    
   //pfnSetPresFont ( hwndC, pdr->sPtSize, pdr->fat.szFacename );
   pfnSetPPFont ( hwndC, pdr->fxPtSz, &pdr->fat );
    
   pfnSetPresColors ( hwndC, pdr->ulNBClr, pdr->ulNFClr, pdr->ulHBClr, pdr->ulHFClr );
    
   //*** Allocate & Init Root Rec *******************************************
    
   pRec = pfnAllocRec ( NULL, WID_TREE, 0, TRUE, TRUE );
    
   pRecFoc = pRec;
    
   pRec->pdr->hwndE = hwndC;

   if ( pRec->pdr->pszStat )
      free ( pRec->pdr->pszStat );
    
   pRec->pdr->pszStat = malloc ( 256 );
    
   //*** Set Globals ********************************************************
    
   fbModified = FALSE;
   fbEditing  = FALSE;
   fbSaving   = FALSE;
   fbDialing  = FALSE;
   fbReading  = FALSE;
    
   ulRelRev = REL_REV;
    
   if ( pszInFile )
   {
      strcpy ( pszCurrFile, pszInFile );
       
      pszTmp = strrchr ( pszInFile, '\\' );
       
      if ( pszTmp )
         ++pszTmp;
      else 
         pszTmp = pszInFile;
       
      pfnFrameTitle ( WinQueryWindow ( hwnd, QW_PARENT ), "PM Scrapbook", pszTmp );
   }
   else 
   {
      *pszCurrFile = 0;
       
      pfnFrameTitle ( WinQueryWindow ( hwnd, QW_PARENT ), "PM Scrapbook", "?" );
   }
    
   return TRUE;
}
 
/***************************************************************************/
/* See if Scrapbook has changed                                            */
/***************************************************************************/
USHORT           pfnMaybeSave (  ) 
{
   USHORT  usResp = MBID_YES;
    
   ulEntryUpdates = 0;

   if ( pRec )
      pfnTreeScan ( pRec, SCB_TREE, SCB_UPDATED, 0 );

   if ( fbModified || ulEntryUpdates )
   {
      usResp = pfnMsgYesNoCan ( hwndM, APP_TITLE,
                               "This scrapbook has been modified. Save changes ?" );
       
      if ( usResp == MBID_YES ) 
         WinSendMsg ( hwndM, WM_COMMAND, MPFROM2SHORT ( MID_MAIN_SAVE, 0 ), NULL );
      else if ( usResp != MBID_CANCEL ) 
         fbModified = FALSE;
   }
    
   /* Free Containers */
    
   if ( pRec ) 
   {
      if ( usResp != MBID_CANCEL ) 
      {
         WinEnableWindowUpdate ( hwndC, FALSE );
          
         pfnTreeScan ( pRec, SCB_TREE, SCB_FREE, 0 );
          
         WinEnableWindowUpdate ( hwndC, TRUE );
      }
   }
    
   return usResp;
}
 
/***************************************************************************/
/* Save Scrapbook to Disk                                                  */
/***************************************************************************/
BOOL             pfnSaveFile  ( HWND hwnd, PSZ pszToFile )
{
   HFILE   hfil;
   ULONG   ulBytesWrit;
    
   DATREC  dr;
   PDATREC pdr;
    
   APIRET  apiret;
   PSZ     pszTmp;
    
   //*** Open File **********************************************************
    
   ulBytesWrit = 0;
    
   apiret = DosOpen ( pszToFile, &hfil, &ulBytesWrit, 0L, 0L,
                      OPEN_ACTION_REPLACE_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW,
                      OPEN_SHARE_DENYREADWRITE|OPEN_ACCESS_WRITEONLY, 0L );
    
   if ( apiret ) 
   {
      pfnMsgOK ( hwnd, APP_TITLE, "Could not open file." );

      return FALSE;
   }
       
   //*** Set Main Title *****************************************************
    
   strcpy ( pszCurrFile, pszToFile );
    
   pszTmp = strrchr ( pszToFile, '\\' );
    
   if ( pszTmp )
      ++pszTmp;
   else
      pszTmp = pszToFile;
    
   //pfnFrameTitle ( WinQueryWindow ( hwndM, QW_PARENT ), "PM Scrapbook", pszTmp );
    
   //*** Save All Entries ***************************************************
    
   pfnTreeScan ( pRec, SCB_TREE, SCB_SAVE, 0 );

   //*** Write Header *******************************************************
    
   DosWrite ( hfil, "PMSCB", 5, &ulBytesWrit );
    
   ulRelRev = REL_REV;
    
   DosWrite ( hfil, &ulRelRev, sizeof ( ULONG ), &ulBytesWrit );
    
   dr.hwndD = WinQueryWindow ( hwndM, QW_PARENT );
    
   dr.ulDLen = 1;
    
   pfnGetWinPos ( dr.hwndD, &dr );
    
   DosWrite ( hfil, &dr.swp, sizeof ( SWP ), &ulBytesWrit );
    
   //dr.hwndD = hwndT;
   dr.hwndD = WinQueryWindow ( hwndM, QW_PARENT );
    
   dr.ulDLen = 1;
    
   pfnGetWinPos ( dr.hwndD, &dr );
    
   pdr = pRecAll->pdr;
    
   //pdr->sPtSize = pfnFmToFat ( hwndC, &pdr->fat );

   //pfnGetDefFattrs ( hwndC, NULLHANDLE, &pdr->fat, &pdr->fxPtSz );
    
   pfnGetPresColors ( hwndC, &pdr->ulNBClr, &pdr->ulNFClr, &pdr->ulHBClr, &pdr->ulHFClr );
    
   DosWrite ( hfil, &dr.swp,                 sizeof ( SWP ),    &ulBytesWrit );
   DosWrite ( hfil, &pRecAll->pdr->fat,      sizeof ( FATTRS ), &ulBytesWrit );
//   DosWrite ( hfil, &pRecAll->pdr->sPtSize, sizeof ( SHORT ),  &ulBytesWrit );
   DosWrite ( hfil, &pRecAll->pdr->fxPtSz,   sizeof ( FIXED ),  &ulBytesWrit );
   DosWrite ( hfil, &pRecAll->pdr->ulDLen,   sizeof ( ULONG ),  &ulBytesWrit );
   DosWrite ( hfil, &pRecAll->pdr->ulDEnt,   sizeof ( ULONG ),  &ulBytesWrit );
   DosWrite ( hfil, &pRecAll->pdr->ulOpts,   sizeof ( ULONG ),  &ulBytesWrit );
   DosWrite ( hfil, &pRecAll->pdr->ulStyl,   sizeof ( ULONG ),  &ulBytesWrit );
   DosWrite ( hfil, &pRecAll->pdr->ulNBClr,  sizeof ( ULONG ),  &ulBytesWrit );
   DosWrite ( hfil, &pRecAll->pdr->ulNFClr,  sizeof ( ULONG ),  &ulBytesWrit );
   DosWrite ( hfil, &pRecAll->pdr->ulHBClr,  sizeof ( ULONG ),  &ulBytesWrit );
   DosWrite ( hfil, &pRecAll->pdr->ulHFClr,  sizeof ( ULONG ),  &ulBytesWrit );
    
   DosWrite ( hfil, &pRecAll->pdr->fatPrt,   sizeof ( FATTRS ), &ulBytesWrit );
   DosWrite ( hfil, &pRecAll->pdr->fxPtSzPrt,sizeof ( FIXED ),  &ulBytesWrit );

   pfnTreeScan ( pRec, SCB_TREE, SCB_WRITE, MPFROMLONG ( hfil ) );
    
   //*** Close File & Clean Up **********************************************
    
   DosClose ( hfil );
    
   return TRUE;
}
 
/***************************************************************************/
/* Read Scrapbook from Disk                                                */
/***************************************************************************/
BOOL             pfnReadFile  ( HWND hwnd, PSZ pszOfFile )
{
   HFILE   hfil;
   ULONG   ulBytesRead;
   ULONG   ul;
   LONG    lRLvl;
   LONG    lExpnd;
   LONG    lX;
   ULONG   ulOpts;
   ULONG   ulReal;
    
   APIRET  apiret;
    
   CHAR    ach[CCHMAXPATH+80];
    
   //PSZ     pszTtl;
   PSZ     pszTmp;
   SHORT   sPtSz;

   DATREC  dr;
    
   /* Container Stuff */
    
   PUSEREC      pRecTmp;
   PUSEREC      pRecPar;
   PDATREC      pdr;
   PUSEREC     *pParStack;
   PUSEREC     *pParExpnd;
   //CNRINFO      cnrinf;
   RECORDINSERT recins;
    
   if ( ! pfnFileExists ( pszOfFile ) )
   {
      pfnNewBook ( hwnd, pszOfFile );
       
      return TRUE;
   }
    
   //*** Open File **********************************************************
    
   ulBytesRead = 0;
    
   apiret = DosOpen ( pszOfFile, &hfil, &ulBytesRead, 0L, 0L,
                      OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
   //                   OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                      OPEN_SHARE_DENYNONE|OPEN_ACCESS_READONLY, 0L );
    
   if ( apiret ) 
   {
      pszTmp = malloc ( 80 );
       
      sprintf ( pszTmp, "Open Fail RC = %d", apiret );
       
      pfnMsgOK ( hwnd, APP_TITLE, pszTmp );
       
      free ( pszTmp );
       
      pfnNewBook ( hwnd, NULL );
       
      //if ( apiret != ERROR_FILE_NOT_FOUND ) {
          
         return FALSE;
          
      //}
   }
    
   //*** Init ***************************************************************
    
   pfnNewBook ( hwnd, pszOfFile );
    
   WinSendMsg ( hwndC, CM_REMOVERECORD,
                MPFROMP ( &pRec ),
                MPFROM2SHORT( 1, CMA_FREE | CMA_INVALIDATE ) );
    
   pRec = NULL;    // Free HERE
    
   pfnDefTree ( pRecAll );
    
   //WinEnableWindowUpdate ( hwndC, FALSE );
    
   //*** Read Header ********************************************************
    
   DosRead ( hfil, ach, 5, &ulBytesRead );
    
   if ( strncmp ( ach, "PMSCB", 5 ) ) 
   {
      pfnMsgOK ( hwnd, APP_TITLE, "Not a PM Scrapbook file." );
       
      DosClose ( hfil );
       
      pfnNewBook ( hwnd, NULL );
       
      return FALSE;
       
   }
    
   DosRead ( hfil, &ulRelRev, sizeof ( ULONG ), &ulBytesRead );
   DosRead ( hfil, &dr.swp,   sizeof ( SWP ),   &ulBytesRead );
    
   //dr.hwndD = hwndM;
   dr.hwndD = WinQueryWindow ( hwndM, QW_PARENT );
    
   dr.ulDLen = 1;
    
   pfnSetWinPos ( dr.hwndD, &dr );
    
   DosRead ( hfil, &dr.swp,                sizeof ( SWP ),    &ulBytesRead );
   DosRead ( hfil, &pRecAll->pdr->fat,     sizeof ( FATTRS ), &ulBytesRead );

   if ( ( ulRelRev % 5000 ) <= 112 )
   {
      DosRead ( hfil, &sPtSz, sizeof ( SHORT ),  &ulBytesRead );
      pRecAll->pdr->fxPtSz = MAKEFIXED ( sPtSz, 0 );
   }
   else
      DosRead ( hfil, &pRecAll->pdr->fxPtSz, sizeof ( FIXED ),  &ulBytesRead );
    
   if ( ( ulRelRev % 5000 ) > 111 ) 
   {
      DosRead ( hfil, &pRecAll->pdr->ulDLen,  sizeof ( ULONG ), &ulBytesRead );
      DosRead ( hfil, &pRecAll->pdr->ulDEnt,  sizeof ( ULONG ), &ulBytesRead );
      DosRead ( hfil, &pRecAll->pdr->ulOpts,  sizeof ( ULONG ), &ulBytesRead );
      DosRead ( hfil, &pRecAll->pdr->ulStyl,  sizeof ( ULONG ), &ulBytesRead );
      DosRead ( hfil, &pRecAll->pdr->ulNBClr, sizeof ( ULONG ), &ulBytesRead );
      DosRead ( hfil, &pRecAll->pdr->ulNFClr, sizeof ( ULONG ), &ulBytesRead );
      DosRead ( hfil, &pRecAll->pdr->ulHBClr, sizeof ( ULONG ), &ulBytesRead );
      DosRead ( hfil, &pRecAll->pdr->ulHFClr, sizeof ( ULONG ), &ulBytesRead );
   }
    
   if ( ( ulRelRev % 5000 ) > 112 )
   {
      DosRead ( hfil, &pRecAll->pdr->fatPrt,   sizeof ( FATTRS ), &ulBytesRead );
      DosRead ( hfil, &pRecAll->pdr->fxPtSzPrt,sizeof ( FIXED ),  &ulBytesRead );
   }

   //*** Set Tree Fonts & Colors ********************************************
    
   pdr = pRecAll->pdr;
    
   pfnSetPPFont ( hwndC, pdr->fxPtSz, &pdr->fat );
    
   pfnSetPresColors ( hwndC, pdr->ulNBClr, pdr->ulNFClr, pdr->ulHBClr, pdr->ulHFClr );
    
   //*** Read  Data *********************************************************
    
   DosRead ( hfil, &lRLvl, sizeof ( lRLvl ), &ulBytesRead );
    
   while ( ulBytesRead ) 
   {
      //*** Alloc Record & Read *********************************************
       
      DosRead ( hfil, &ul,     sizeof ( ULONG ), &ulBytesRead );
      DosRead ( hfil, &ulOpts, sizeof ( ULONG ), &ulBytesRead );
      DosRead ( hfil, &ulReal, sizeof ( ULONG ), &ulBytesRead );
       
      pRecTmp = pfnAllocRec ( pRec, ul, ulReal, FALSE, TRUE );
       
      pRecTmp->ulOpts = ulOpts;
       
      //pRecTmp->ulReal = ulReal;
       
      //*** Dates ***********************************************************
       
      DosRead ( hfil, &pRecTmp->cdCre, sizeof ( CDATE ), &ulBytesRead );
      DosRead ( hfil, &pRecTmp->ctCre, sizeof ( CTIME ), &ulBytesRead );
      DosRead ( hfil, &pRecTmp->cdWri, sizeof ( CDATE ), &ulBytesRead );
      DosRead ( hfil, &pRecTmp->ctWri, sizeof ( CTIME ), &ulBytesRead );
      DosRead ( hfil, &pRecTmp->cdAcc, sizeof ( CDATE ), &ulBytesRead );
      DosRead ( hfil, &pRecTmp->ctAcc, sizeof ( CTIME ), &ulBytesRead );
       
      //*** Entry Name ******************************************************
       
      DosRead ( hfil, &ul, sizeof ( ul ), &ulBytesRead );
       
      pRecTmp->crecCore.pszTree  = malloc ( ul );
       
      DosRead ( hfil, pRecTmp->crecCore.pszTree, ul, &ulBytesRead );
       
      //*** Detail **********************************************************
       
      pdr = pRecTmp->pdr;
       
      DosRead ( hfil, &pdr->ulDLen, sizeof ( ULONG ), &ulBytesRead );
       
      if ( pdr->ulDLen ) 
      {
         pdr->pvDat = malloc ( pdr->ulDLen );
          
         DosRead ( hfil, &pdr->ulDEnt,  sizeof ( ULONG ),  &ulBytesRead );

         if ( ( ulRelRev % 5000 ) < 114 )
         {
            pdr->ulRelRev = ( ulRelRev % 5000 );
         }
         else
            DosRead ( hfil, &pdr->ulRelRev, sizeof ( ULONG ),  &ulBytesRead );

         DosRead ( hfil, pdr->pvDat,    pdr->ulDLen,       &ulBytesRead );
         DosRead ( hfil, &pdr->ulOpts,  sizeof ( ULONG ),  &ulBytesRead );
         DosRead ( hfil, &pdr->ulStyl,  sizeof ( ULONG ),  &ulBytesRead );
         DosRead ( hfil, &pdr->swp,     sizeof ( SWP ),    &ulBytesRead );
         DosRead ( hfil, &pdr->fat,     sizeof ( FATTRS ), &ulBytesRead );
      
         //DosRead ( hfil, &pdr->sPtSize, sizeof ( SHORT ),  &ulBytesRead );
         if ( ( ulRelRev % 5000 ) <= 112 )
         {
            DosRead ( hfil, &sPtSz, sizeof ( SHORT ),  &ulBytesRead );
            pdr->fxPtSz = MAKEFIXED ( sPtSz, 0 );
         }
         else
            DosRead ( hfil, &pdr->fxPtSz, sizeof ( FIXED ),  &ulBytesRead );
          
         DosRead ( hfil, &pdr->ulXVS,   sizeof ( ULONG ),  &ulBytesRead );
          
         if ( ( ulRelRev % 5000 ) > 111 ) 
         {
            DosRead ( hfil, &pdr->ulNBClr, sizeof ( ULONG ), &ulBytesRead );
            DosRead ( hfil, &pdr->ulNFClr, sizeof ( ULONG ), &ulBytesRead );
            DosRead ( hfil, &pdr->ulHBClr, sizeof ( ULONG ), &ulBytesRead );
            DosRead ( hfil, &pdr->ulHFClr, sizeof ( ULONG ), &ulBytesRead );
         }

         if ( ( ulRelRev % 5000 ) > 112 )
         {
            DosRead ( hfil, &pdr->fatPrt,   sizeof ( FATTRS ), &ulBytesRead );
            DosRead ( hfil, &pdr->fxPtSzPrt,sizeof ( FIXED ),  &ulBytesRead );
         }

         //*** Convert Lst2's ***********************************************

         if ( pRecTmp->ulType == WID_LIST )
            pfnLst2MiniBase ( pRecTmp );

         //*** Load Reference Icons ? ***************************************

         if ( pRecTmp->ulType == WID_REFR )
            if ( ! pfnRefrIcon ( pRecTmp ) )
               pfnMsgOK ( hwnd, APP_TITLE, "Error loading icon file." );
            else
               WinSendMsg ( hwndC, CM_INVALIDATERECORD,
                            MPFROMP ( &pRecTmp ), MPFROM2SHORT ( 1, CMA_NOREPOSITION ) );

      }
       
      //*** Root ? **********************************************************
       
      if ( ! pRec ) 
      {
         pRec = pRecTmp;
          
         pRecFoc = pRec;
          
         pParStack = malloc ( sizeof ( PUSEREC ) );
         pParExpnd = malloc ( sizeof ( PUSEREC ) );
          
         lExpnd = 0;
          
         pRec->pdr->hwndE = hwndC;   // Tree shift problem ???

         if ( ( ulRelRev % 5000 ) < 112 ) 
         {
            pRecAll->pdr->ulDEnt = pRec->pdr->ulDEnt;
             
            pRec->pdr->ulDEnt = 1;
         }

         pfnFrameTitle ( WinQueryWindow ( hwndM, QW_PARENT ), 
                         "PM Scrapbook", pRec->crecCore.pszTree );
      }
       
      //*** Parent ? ********************************************************
       
      if ( pRecTmp->ulOpts & SCB_PARENT ) 
      {
         pParStack = realloc ( pParStack, (lRLvl+1) * sizeof(PUSEREC) );
          
         pParStack[lRLvl] = pRecTmp;
      }
       
      //*** Child ? *********************************************************
       
      pRecPar = ( lRLvl ) ? pParStack[+lRLvl-1] : NULL;
       
      //*** Insert **********************************************************
       
      recins.cb                = sizeof ( RECORDINSERT );
      recins.pRecordParent     = (PRECORDCORE) pRecPar;
      recins.pRecordOrder      = (PRECORDCORE) CMA_END;
      recins.zOrder            = CMA_TOP;
      recins.cRecordsInsert    = 1;
      recins.fInvalidateRecord = TRUE; //FALSE;
       
      WinSendMsg ( hwndC, CM_INSERTRECORD,
                   MPFROMP( pRecTmp ), MPFROMP ( &recins ) );
       
      //*** Expand ? ********************************************************
       
      if ( pRecTmp->ulOpts & SCB_EXPAND ) 
      {
         //WinSendMsg ( hwndC, CM_EXPANDTREE, MPFROMP( pRecTmp ), NULL );
          
         if ( pRecPar ) 
         {
            if ( pRecPar->ulOpts & SCB_EXPAND ) 
            {
               pParExpnd = realloc ( pParExpnd, (lExpnd+1) * sizeof(PUSEREC) );
                
               pParExpnd[lExpnd] = pRecTmp;
                
               ++lExpnd;
            }
         }
         else if ( pRecTmp == pRec ) 
         {
            if ( pRecTmp->ulOpts & SCB_EXPAND ) 
            {
               pParExpnd = realloc ( pParExpnd, (lExpnd+1) * sizeof(PUSEREC) );
                
               pParExpnd[lExpnd] = pRecTmp;
                
               ++lExpnd;
            }
         }
      }
       
      //*** Open ? **********************************************************
       
      if ( pRecTmp->pdr->ulOpts & SCB_OPENED ) 
      {
         WinSendMsg ( hwndM, UWM_DETWIN, MPFROMP( pRecTmp ), NULL );
      }
       
      //*** Count ***********************************************************
       
      ++pRecAll->pdr->ulDEnt;
       
      //*** Next ************************************************************
       
      DosRead ( hfil, &lRLvl, sizeof ( lRLvl ), &ulBytesRead );
   }
    
   //pfnTreeScan ( pRec, SCB_TREE, SCB_REFRESH, 0 );
    
   //cnrinf.flWindowAttr = CV_TREE | CV_ICON | CA_TREELINE;
    
   /*WinSendMsg ( hwndC, CM_SETCNRINFO, &cnrinf,
                MPFROMLONG ( CMA_FLWINDOWATTR | CMA_CNRTITLE ) );*/
    
   //WinSendMsg ( hwndC, CM_EXPANDTREE, MPFROMP( pRec ), NULL );
    
   //*** Expand Saved Entries ***********************************************

   for ( lX = 0; lX < lExpnd; ++lX ) 
   {
      WinSendMsg ( hwndC, CM_EXPANDTREE, MPFROMP( pParExpnd[lX] ), NULL );
   }
    
   //*** Close File & Clean Up **********************************************
    
   DosClose ( hfil );
    
   free ( pParStack );
   free ( pParExpnd );
    
   //WinEnableWindowUpdate ( hwndC, TRUE );
    
   return TRUE;
}
 
/***************************************************************************/
/* Entry Scan Functions                                                    */
/***************************************************************************/
ULONG            pfnNodeScan  ( HWND hwnd, LONG lFunc, LONG lType, PBYTE pbDat ) 
{
   ULONG    ulSize;
   ULONG    ulLen;
   ULONG    ulX;
   PSZ      *ppszX;
    
   PUSEREC  pRecTmp;
   PUSEREC  pRecScn;
   PADDRREC pAddr;
   PTODOREC pToDo;
   PLST2REC pLst2;
   PMINIREC pMini;
    
   PDATREC  pdr;
   PMCTLREC pctl;
   PMCOLREC pcol;
    
   PFIELDINFO pfi;
    
   ulSize = 0;
    
   //*** Write Column Widths ************************************************

   if ( ( lType == WID_ADDR || lType == WID_TODO ) && lFunc == SCB_WRITE )
   {
      pRecScn = WinQueryWindowPtr ( hwnd, 0 );
       
      pdr = pRecScn->pdr;

      ulSize = ( lType == WID_ADDR ) ? ADDR_COLS : TODO_COLS;

      for ( ulX = 0; ulX < ulSize; ++ulX )
      {
         if ( pdr->colInfo[ulX].fbVisible )
            pdr->colInfo[ulX].ulPels = pfnCnrColPels( pdr->hwndE,
                                                      pdr->colInfo[ulX].pfinf );
         else
            pdr->colInfo[ulX].ulPels = 0;

         memcpy ( pbDat, &pdr->colInfo[ulX].ulPels, sizeof ( ULONG ) );
         pbDat += sizeof ( ULONG );
      }
   }

   if ( ( lType == WID_ADDR || lType == WID_TODO ) && lFunc == SCB_SIZE )
   {
      if ( lType == WID_ADDR ) 
         ulSize = ADDR_COLS * sizeof ( ULONG );
      else
         ulSize = TODO_COLS * sizeof ( ULONG );
   }
   else
      ulSize = 0;

   //*** Scan Entry Entries *************************************************

   pRecTmp = WinSendMsg ( hwnd, CM_QUERYRECORD,
                          MPFROMP ( NULL ),
                          MPFROM2SHORT ( CMA_FIRST, CMA_ITEMORDER ) );
    
   while ( pRecTmp ) 
   {
      switch ( lFunc ) 
      {
         case SCB_SIZE:

            switch ( lType ) 
            {
               case WID_ADDR:
                   
                  pAddr = (PADDRREC) pRecTmp;
                   
                  ulSize += strlen ( pAddr->pszFN ) + 1;
                  ulSize += strlen ( pAddr->pszAC ) + 1;
                  ulSize += strlen ( pAddr->pszPN ) + 1;
                  ulSize += strlen ( pAddr->pszEx ) + 1;
                  ulSize += strlen ( pAddr->pszAd ) + 1;
                  ulSize += strlen ( pAddr->pszNt ) + 1;
                   
                  ulSize += sizeof ( CDATE );
                  ulSize += sizeof ( ULONG );

                  ulSize += ( sizeof ( ULONG ) * ADDR_COLS );
                   
               break;
                
               case WID_TODO:
                   
                  pToDo = (PTODOREC) pRecTmp;
                   
                  ulSize += sizeof ( CDATE );
                  ulSize += sizeof ( CDATE );
                  ulSize += sizeof ( CDATE );
                  ulSize += sizeof ( BOOL );
                  ulSize += strlen ( pToDo->pszDo ) + 1;

                  ulSize += ( sizeof ( ULONG ) * TODO_COLS );
                   
               break;
                
               case WID_LIST:
                   
                  pLst2 = (PLST2REC) pRecTmp;
                   
                  ulSize += strlen ( pLst2->psz1 ) + 1;
                  ulSize += strlen ( pLst2->psz2 ) + 1;
                   
                  ulSize += sizeof ( CDATE );
                   
               break;
                
               case WID_MINI:
                   
                  pMini = (PMINIREC) pRecTmp;
                   
                  ppszX = &pMini->psz01;
                   
                  pfi = WinSendMsg ( hwnd, CM_QUERYDETAILFIELDINFO,
                                     NULL,
                                     MPFROMSHORT( CMA_FIRST ) );
                   
                  for ( ulX = 0; ulX < MINI_COLS; ++ulX ) 
                  {
                     ulSize += strlen ( *ppszX ) + 1;
                      
                     ++ppszX;

                     pfi = WinSendMsg ( hwnd, CM_QUERYDETAILFIELDINFO,
                                        MPFROMP ( pfi ),
                                        MPFROMSHORT( CMA_NEXT ) );
                  }

                  ulSize += sizeof ( CDATE );
                  ulSize += sizeof ( ULONG );

               break;
                
            }
             
         break;
          
         case SCB_WRITE:
             
            switch ( lType ) 
            {
               case WID_ADDR:
                   
                  pAddr = (PADDRREC) pRecTmp;
                   
                  ulLen = strlen ( pAddr->pszFN ) + 1;
                  memcpy ( pbDat, pAddr->pszFN, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = strlen ( pAddr->pszAC ) + 1;
                  memcpy ( pbDat, pAddr->pszAC, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = strlen ( pAddr->pszPN ) + 1;
                  memcpy ( pbDat, pAddr->pszPN, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = strlen ( pAddr->pszEx ) + 1;
                  memcpy ( pbDat, pAddr->pszEx, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = strlen ( pAddr->pszAd ) + 1;
                  memcpy ( pbDat, pAddr->pszAd, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = strlen ( pAddr->pszNt ) + 1;
                  memcpy ( pbDat, pAddr->pszNt, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = sizeof ( CDATE );
                  memcpy ( pbDat, &pAddr->cdUpd, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = sizeof ( ULONG );
                  memcpy ( pbDat, &pAddr->ulOpt, ulLen );
                  pbDat += ulLen;
                   
                  ++ulSize;
                   
               break;
                
               case WID_TODO:
                   
                  pToDo = (PTODOREC) pRecTmp;
                   
                  ulLen = sizeof ( CDATE );
                  memcpy ( pbDat, &pToDo->cdEnt, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = sizeof ( CDATE );
                  memcpy ( pbDat, &pToDo->cdFin, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = sizeof ( CDATE );
                  memcpy ( pbDat, &pToDo->cdTrg, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = sizeof ( ULONG );
                  memcpy ( pbDat, &pToDo->ulOpt, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = strlen ( pToDo->pszDo ) + 1;
                  memcpy ( pbDat, pToDo->pszDo, ulLen );
                  pbDat += ulLen;
                   
                  ++ulSize;
                   
               break;
                
               case WID_LIST:
                   
                  pLst2 = (PLST2REC) pRecTmp;
                   
                  ulLen = strlen ( pLst2->psz1 ) + 1;
                  memcpy ( pbDat, pLst2->psz1, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = strlen ( pLst2->psz2 ) + 1;
                  memcpy ( pbDat, pLst2->psz2, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = sizeof ( CDATE );
                  memcpy ( pbDat, &pLst2->cdCur, ulLen );
                  pbDat += ulLen;
                   
                  ++ulSize;
                   
               break;
                
               case WID_MINI:
                   
                  pMini = (PMINIREC) pRecTmp;
                   
                  pfi = WinSendMsg ( hwnd, CM_QUERYDETAILFIELDINFO,
                                     NULL,
                                     MPFROMSHORT( CMA_FIRST ) );
                   
                  ppszX = &pMini->psz01;
                   
                  for ( ulX = 0; ulX < MINI_COLS; ++ulX ) 
                  {
                     ulLen = strlen ( *ppszX ) + 1;
                     memcpy ( pbDat, *ppszX, ulLen );
                     pbDat += ulLen;
                      
                     ++ppszX;

                     pfi = WinSendMsg ( hwnd, CM_QUERYDETAILFIELDINFO,
                                        MPFROMP ( pfi ),
                                        MPFROMSHORT( CMA_NEXT ) );
                  }

                  ulLen = sizeof ( CDATE );
                  memcpy ( pbDat, &pMini->cdUpd, ulLen );
                  pbDat += ulLen;
                   
                  ulLen = sizeof ( ULONG );
                  memcpy ( pbDat, &pMini->ulOpt, ulLen );
                  pbDat += ulLen;
                   
                  ++ulSize;
                   
               break;
                
            }
             
         break;
          
         case SCB_FREE:
             
            switch ( lType ) 
            {
               case WID_ADDR:
                   
                  pAddr = (PADDRREC) pRecTmp;
                   
                  free ( pAddr->pszFN );
                  free ( pAddr->pszAC );
                  free ( pAddr->pszPN );
                  free ( pAddr->pszEx );
                  free ( pAddr->pszAd );
                  free ( pAddr->pszNt );
                   
               break;
                
               case WID_TODO:
                   
                  pToDo = (PTODOREC) pRecTmp;
                   
                  free ( pToDo->pszDo );
                   
               break;
                
               case WID_LIST:
                   
                  pLst2 = (PLST2REC) pRecTmp;
                   
                  free ( pLst2->psz1 );
                  free ( pLst2->psz2 );
                   
               break;
                
               case WID_MINI:
                   
                  pMini = (PMINIREC) pRecTmp;
                   
                  ppszX = &pMini->psz01;
                   
                  for ( ulX = 0; ulX < MINI_COLS; ++ulX ) 
                  {
                     free ( *ppszX );
                      
                     ++ppszX;
                  }
                   
               break;
                
            }
             
         break;
          
      }
       
      pRecTmp = WinSendMsg ( hwnd, CM_QUERYRECORD,
                             MPFROMP ( pRecTmp ),
                             MPFROM2SHORT ( CMA_NEXT, CMA_ITEMORDER ) );
   }
    
   return ulSize;
    
}
 
/***************************************************************************/
/* Entry Utilities                                                         */
/***************************************************************************/
ULONG            pfnNodeUtil  ( PUSEREC pRecIn, LONG lFunc, LONG lType, MPARAM mp ) 
{
   ULONG          ulSize;
   ULONG          ulLen;
   BOOL           fbCase;
   PBYTE          pbDat;
   ULONG          ulOff;
   PDATREC        pdr;
   HWND           hwndEnt;
    
   /* Container Stuff */
    
   /*PUSEREC  pRecTmp;
   PADDRREC pAddr;
   PTODOREC pToDo;
   PLST2REC pLst2;*/
    
   ulSize = 0;
    
   pdr = pRecIn->pdr;
    
   pbDat = pdr->pvDat;
    
   switch ( lFunc ) 
   {
      case SCB_SEARCH:
      {
         SEARCHSTRING   cnrsd;
         MLE_SEARCHDATA mlesd;
         ULONG          ulSrchHow;

         mlesd.cb        = sizeof ( MLE_SEARCHDATA );
         mlesd.pchFind   = pszSearch;
         mlesd.cchFind   = strlen ( pszSearch );
         mlesd.iptStart  = 0;
         mlesd.iptStop   = -1;
          
         if ( ulTreeOpts & SCB_CASE )
            ulSrchHow = MLFSEARCH_CASESENSITIVE;
         else
            ulSrchHow = 0;//MLFSEARCH_SELECTMATCH;
          
         cnrsd.cb              = sizeof ( SEARCHSTRING );
         cnrsd.pszSearch       = pszSearch;
         cnrsd.fsPrefix        = FALSE;
         cnrsd.fsCaseSensitive = ( ulTreeOpts & SCB_CASE ) ? TRUE : FALSE;
         cnrsd.usView          = CV_DETAIL;

         switch ( pRecIn->ulType ) 
         {
            case WID_REFR:
            {
               PSZ   psz;

               if ( hwndEnt = pfnEntryOpen ( pRecIn, 0 ) )
               {
                  //*** Search EA's *****************************************************
                  ulLen = 0;
                  psz = 0;
                  pfnExportFromEF ( pRecIn->pdr->hwndE, DIT_REFR_SUBJECT, &psz, &ulLen, TRUE );

                  if ( pfnStrSearch ( psz, ulLen, pszSearch, 0, fbCase ) )
                     ulSize = 1L;

                  else if ( WinSendDlgItemMsg ( pRecIn->pdr->hwndE, DIT_REFR_KEYWRDS, MLM_SEARCH,
                                    MPFROMLONG ( ulSrchHow ), 
                                    MPFROMP ( &mlesd ) ) )
                     ulSize = 1L;

                  else if ( WinSendDlgItemMsg ( pRecIn->pdr->hwndE, DIT_REFR_COMMNTS, MLM_SEARCH,
                                    MPFROMLONG ( ulSrchHow ), 
                                    MPFROMP ( &mlesd ) ) )
                     ulSize = 1L;
               }
               else
               {
                  PREFRREC prr;

                  prr = pfnRefrLoadEntry ( pRecIn );

                  if ( ! prr )
                     ulSize = 0;
                  else
                  {
                     if ( pfnStrSearch ( prr->pszSub, 0, pszSearch, 0, fbCase ) )
                        ulSize = 1L;

                     else if ( pfnStrSearch ( prr->pszKey, 0, pszSearch, 0, fbCase ) )
                        ulSize = 1L;

                     else if ( pfnStrSearch ( prr->pszCom, 0, pszSearch, 0, fbCase ) )
                        ulSize = 1L;

                     pfnRefrFreeEntry ( prr );
                  }
               }
            }
            break;

            case WID_ADDR:
                
               if ( hwndEnt = pfnEntryOpen ( pRecIn, 0 ) )
               {
                  if ( WinSendMsg ( pRecIn->pdr->hwndE, CM_SEARCHSTRING,
                                    MPFROMP ( &cnrsd ), 
                                    MPFROMLONG ( CMA_FIRST ) ) )
                     return 1L;
                  else
                     return 0;
               }

               //pAddr = (PADDRREC) pRecIn;
                
               fbCase = ( ulTreeOpts & SCB_CASE ) ? TRUE : FALSE;
                
               pdr = pRecIn->pdr;
                
               pbDat = pdr->pvDat;
                
               if ( ! pdr->ulDEnt )
                  break;
                
               for ( ulOff = 0; ulOff < pdr->ulDEnt; ++ulOff ) 
               {
                  //*** pszFN ***********************************************
                   
                  ulLen = strlen ( pbDat ) + 1;     // pszFN
                   
                  if ( pfnStrSearch ( pbDat, ulLen, pszSearch, 0, fbCase ) )
                     return 1L;
                   
                  pbDat += ulLen;
                   
                  //*** pszAC ***********************************************
                   
                  ulLen = strlen ( pbDat ) + 1;     // pszAC
                   
                  if ( pfnStrSearch ( pbDat, ulLen, pszSearch, 0, fbCase ) )
                     return 1L;
                   
                  pbDat += ulLen;
                   
                  //*** pszPN ***********************************************
                   
                  ulLen = strlen ( pbDat ) + 1;     // pszPN
                   
                  if ( pfnStrSearch ( pbDat, ulLen, pszSearch, 0, fbCase ) )
                     return 1L;
                   
                  pbDat += ulLen;
                   
                  //*** pszEx ***********************************************
                   
                  ulLen = strlen ( pbDat ) + 1;     // pszEx
                   
                  if ( pfnStrSearch ( pbDat, ulLen, pszSearch, 0, fbCase ) )
                     return 1L;
                   
                  pbDat += ulLen;
                   
                  //*** pszAd ***********************************************
                   
                  ulLen = strlen ( pbDat ) + 1;     // pszAd
                   
                  if ( pfnStrSearch ( pbDat, ulLen, pszSearch, 0, fbCase ) )
                     return 1L;
                   
                  pbDat += ulLen;
                   
                  //*** pszNt ***********************************************
                   
                  ulLen = strlen ( pbDat ) + 1;     // pszNt
                   
                  if ( pfnStrSearch ( pbDat, ulLen, pszSearch, 0, fbCase ) )
                     return 1L;
                   
                  pbDat += ulLen;
                   
                  //*** cdUpd ***********************************************
                   
                  pbDat += sizeof ( CDATE );
               }
                
            break;
             
            case WID_TODO:
                
               //pAddr = (PADDRREC) pRecIn;
                
               if ( hwndEnt = pfnEntryOpen ( pRecIn, 0 ) )
               {
                  if ( WinSendMsg ( pRecIn->pdr->hwndE, CM_SEARCHSTRING,
                                    MPFROMP ( &cnrsd ), 
                                    MPFROMLONG ( CMA_FIRST ) ) )
                     return 1L;
                  else
                     return 0;
               }

               fbCase = ( ulTreeOpts & SCB_CASE ) ? TRUE : FALSE;
                
               pdr = pRecIn->pdr;
                
               pbDat = pdr->pvDat;
                
               if ( ! pdr->ulDEnt )
                  break;
                
               for ( ulOff = 0; ulOff < pdr->ulDEnt; ++ulOff ) 
               {
                  //*** cdEnt ***********************************************
                   
                  pbDat += sizeof ( CDATE );
                   
                  //*** cdFin ***********************************************
                   
                  pbDat += sizeof ( CDATE );
                   
                  //*** cdTrg ***********************************************
                   
                  pbDat += sizeof ( CDATE );
                   
                  //*** pszDo ***********************************************
                   
                  ulLen = strlen ( pbDat ) + 1;
                   
                  if ( pfnStrSearch ( pbDat, ulLen, pszSearch, 0, fbCase ) ) 
                     return 1L;
                   
                  pbDat += ulLen;
               }
                
            break;
             
            case WID_MINI:
            {
               ULONG   ulCols;
               ULONG   ulX;
               ULONG   ulY;
               //ULONG   ulLen;

               //pAddr = (PADDRREC) pRecIn;
                
               if ( hwndEnt = pfnEntryOpen ( pRecIn, 0 ) )
               {
                  if ( WinSendMsg ( pRecIn->pdr->hwndE, CM_SEARCHSTRING,
                                    MPFROMP ( &cnrsd ), 
                                    MPFROMLONG ( CMA_FIRST ) ) )
                     return 1L;
                  else
                     return 0;
               }

               fbCase = ( ulTreeOpts & SCB_CASE ) ? TRUE : FALSE;
                
               pdr = pRecIn->pdr;
                
               pbDat = pdr->pvDat;
                
               if ( ! pdr->ulDEnt )
                  break;
                
               memcpy ( &ulCols, pbDat, sizeof ( ULONG ) );
                
               pbDat += sizeof ( ULONG );                 //*** ulCols
               pbDat += sizeof ( ULONG );                 //*** ulSplit
               pbDat += ( sizeof ( BYTE ) * MINI_SORTS ); //*** Sorts
               pbDat += ( sizeof ( BYTE ) * MINI_SORTS ); //*** Sort Opts
                
               for ( ulX = 0; ulX < MINI_COLS; ++ulX )
                  pbDat += sizeof ( MCOLREC );            //*** Col Recs
                
               for ( ulX = 0; ulX < MINI_COLS; ++ulX )
                  pbDat += strlen ( pbDat ) + 1;          //*** Col Titles
            
               for ( ulX = 0; ulX < pdr->ulDEnt; ++ulX )
               {
                  for ( ulY = 0; ulY < MINI_COLS; ++ulY )
                  {
                     ulLen = strlen ( pbDat ) + 1;
                      
                     if ( pfnStrSearch ( pbDat, ulLen, pszSearch, 0, fbCase ) )
                        return 1L;
                      
                     pbDat += ulLen;
                  }
               }
            }
            break;
             
            default:
                
               //pAddr = (PADDRREC) pRecIn;
                
               if ( hwndEnt = pfnEntryOpen ( pRecIn, 0  ) )
               {
                  if ( WinSendMsg ( pRecIn->pdr->hwndE, MLM_SEARCH,
                                    MPFROMLONG ( ulSrchHow ), 
                                    MPFROMP ( &mlesd ) ) )
                     return 1L;
                  else
                     return 0;
               }

               fbCase = ( ulTreeOpts & SCB_CASE ) ? TRUE : FALSE;
                
               pdr = pRecIn->pdr;
                
               pbDat = pdr->pvDat;
                
               if ( ! pdr->ulDLen )
                  break;
                
               if ( pfnStrSearch ( pbDat, pdr->ulDLen, pszSearch, 0, fbCase ) )
                  return 1L;
                
            break;
         }
      }
      break;
       
   }
    
   return ulSize;
}
 
/***************************************************************************/
/* Set Default Tree Attributes                                             */
/***************************************************************************/
BOOL             pfnDefTree   ( PUSEREC pRecIn ) 
{
   PDATREC     pdr;
   ULONG       ulSize;
   DEFAULTREC  defRec;
   BOOL        fb;
    
   pdr = pRecIn->pdr;
    
   pdr->ulDLen  = 0;
   pdr->ulDEnt  = 0;
   pdr->ulOpts  = 0;
   pdr->ulStyl  = 0;
    
   ulSize = sizeof ( DEFAULTREC );
    
   fb = PrfQueryProfileData ( HINI_USERPROFILE, PRG_TITLE, TREE_KEY,
                              &defRec, &ulSize );

   if ( fb )
   {
      pdr->fat    = defRec.fat;
      pdr->fxPtSz = defRec.fxPtSz;
       
      pdr->ulNBClr = defRec.ulNBClr;
      pdr->ulNFClr = defRec.ulNFClr;
      pdr->ulHBClr = defRec.ulHBClr;
      pdr->ulHFClr = defRec.ulHFClr;
   }
   else
   {
      pdr->ulNBClr = CLR_BACKGROUND;
      pdr->ulNFClr = CLR_NEUTRAL;
      pdr->ulHBClr = CLR_DARKGRAY;
      pdr->ulHFClr = CLR_BACKGROUND;
       
      pfnGetDefFattrs ( WinQueryWindow ( hwndM, QW_PARENT ), 
                        NULLHANDLE, &pdr->fat, &pdr->fxPtSz );
       
   }
   return TRUE;
}
 
/***************************************************************************/
/* Load Options from OS2.INI                                               */
/***************************************************************************/
BOOL             pfnLoadOpts  ( ) 
{
   ULONG    ulSize;
   BOOL     fb;
   ULONG    aulOpts[12];
   PBYTE    pBuf;
    
   ulSize = 12 * sizeof ( ULONG );
    
   fb = PrfQueryProfileData ( HINI_USERPROFILE, PRG_TITLE, OPTS_KEY,
                              aulOpts, &ulSize );
   ulMDefCols = 3;
    
   if ( ! fb ) 
   {
      fb = FALSE;
       
      ulTreeOpts = SCB_ICONED  | SCB_TREELIN | SCB_MENUED |
                   SCB_PRTCONT | SCB_PRTHEAD | SCB_PRTPAGE| SCB_WINTASK;
      ulTextOpts = SCB_MENUED | SCB_TXTWRAP;
      ulAddrOpts = SCB_MENUED;
      ulToDoOpts = SCB_MENUED | SCB_STATED;// | SCB_PRICOLR;
      ulMiniOpts = SCB_MENUED;
      ulRefrOpts = SCB_REFR_DEFICON;
   }
   else 
   {
      fb = TRUE;
       
      ulTreeOpts = aulOpts[0];
      ulTextOpts = aulOpts[1];
      ulAddrOpts = aulOpts[2];
      ulToDoOpts = aulOpts[3];
      ulMiniOpts = aulOpts[5];
      ulRefrOpts = aulOpts[6];
   }
    
   PrfQueryProfileString ( HINI_USERPROFILE, PRG_TITLE, MOD_POR_KEY, "COM1",
                           achComX, 8 );

   PrfQueryProfileString ( HINI_USERPROFILE, PRG_TITLE, MOD_SET_KEY, "AT",
                           achComSet, 80 );

   PrfQueryProfileString ( HINI_USERPROFILE, PRG_TITLE, PRTQ_KEY, "",
                           pszQueueName, QNAME_LEN );

   pfnPrintInfo ( WinQueryWindow ( hwndM, QW_PARENT ), pszQueueName, &pqi );
    
   /*fb = */PrfQueryProfileSize ( HINI_USERPROFILE, PRG_TITLE, COL_LISTS, &ulSize );

   if ( /*! fb || */! ulSize )
   {
      colStrs.version = REL_REV;
      colStrs.regCode = UNREG_CODE;

      fbUnregistered = TRUE;
      fb = TRUE;

      colStrs.pszAddrName = strdup ( ADDR_COLTXT_NAME );
      colStrs.pszAddrArea = strdup ( ADDR_COLTXT_AREA );
      colStrs.pszAddrFone = strdup ( ADDR_COLTXT_FONE );
      colStrs.pszAddrExtn = strdup ( ADDR_COLTXT_EXTN );
      colStrs.pszAddrAddr = strdup ( ADDR_COLTXT_ADDR );
      colStrs.pszAddrNote = strdup ( ADDR_COLTXT_NOTE );
      colStrs.pszAddrDate = strdup ( ADDR_COLTXT_DATE );
      colStrs.ulAddrName  =          ADDR_COLLEN_NAME;
      colStrs.ulAddrArea  =          ADDR_COLLEN_AREA;
      colStrs.ulAddrFone  =          ADDR_COLLEN_FONE;
      colStrs.ulAddrExtn  =          ADDR_COLLEN_EXTN;
      colStrs.ulAddrAddr  =          ADDR_COLLEN_ADDR;
      colStrs.ulAddrNote  =          ADDR_COLLEN_NOTE;
      colStrs.ulAddrDate  =          ADDR_COLLEN_DATE;

      colStrs.pszToDoEntr = strdup ( TODO_COLTXT_ENTR );
      colStrs.pszToDoTarg = strdup ( TODO_COLTXT_TARG );
      colStrs.pszToDoDone = strdup ( TODO_COLTXT_DONE );
      colStrs.pszToDoPrio = strdup ( TODO_COLTXT_PRIO );
      colStrs.pszToDoIDid = strdup ( TODO_COLTXT_IDID );
      colStrs.pszToDoTask = strdup ( TODO_COLTXT_TASK );
      colStrs.pszToDoNote = strdup ( TODO_COLTXT_NOTE );
      colStrs.ulToDoEntr  =          TODO_COLLEN_ENTR;
      colStrs.ulToDoTarg  =          TODO_COLLEN_TARG;
      colStrs.ulToDoDone  =          TODO_COLLEN_DONE;
      colStrs.ulToDoPrio  =          TODO_COLLEN_PRIO;
      colStrs.ulToDoIDid  =          TODO_COLLEN_IDID;
      colStrs.ulToDoTask  =          TODO_COLLEN_TASK;
      colStrs.ulToDoNote  =          TODO_COLLEN_NOTE;
   }
   else
   {
      PBYTE pScn;

      pBuf = (PBYTE) malloc ( ulSize );

      fb = PrfQueryProfileData ( HINI_USERPROFILE, PRG_TITLE, COL_LISTS,
                                 pBuf, &ulSize );
   
      colStrs.version = ((PCOLSTRS)pBuf)->version;
      colStrs.regCode = ((PCOLSTRS)pBuf)->regCode;

      if ( colStrs.regCode == UNREG_CODE )
         fbUnregistered = TRUE;
      else
         fbUnregistered = FALSE;

      pScn = pBuf;

      pScn += ( sizeof ( ULONG ) * 2 );

      colStrs.ulAddrName  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulAddrArea  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulAddrFone  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulAddrExtn  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulAddrAddr  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulAddrNote  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulAddrDate  = *((PULONG)pScn); pScn += sizeof (ULONG);

      colStrs.ulToDoEntr  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulToDoTarg  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulToDoDone  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulToDoPrio  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulToDoIDid  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulToDoTask  = *((PULONG)pScn); pScn += sizeof (ULONG);
      colStrs.ulToDoNote  = *((PULONG)pScn); pScn += sizeof (ULONG);

      colStrs.pszAddrName = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszAddrName ) + 1 );
      colStrs.pszAddrArea = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszAddrArea ) + 1 );
      colStrs.pszAddrFone = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszAddrFone ) + 1 );
      colStrs.pszAddrExtn = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszAddrExtn ) + 1 );
      colStrs.pszAddrAddr = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszAddrAddr ) + 1 );
      colStrs.pszAddrNote = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszAddrNote ) + 1 );
      colStrs.pszAddrDate = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszAddrDate ) + 1 );
                                                                                      
      colStrs.pszToDoEntr = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszToDoEntr ) + 1 );
      colStrs.pszToDoTarg = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszToDoTarg ) + 1 );
      colStrs.pszToDoDone = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszToDoDone ) + 1 );
      colStrs.pszToDoPrio = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszToDoPrio ) + 1 );
      colStrs.pszToDoIDid = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszToDoIDid ) + 1 );
      colStrs.pszToDoTask = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszToDoTask ) + 1 );
      colStrs.pszToDoNote = strdup ( (PSZ)pScn ); pScn += ( strlen ( colStrs.pszToDoNote ) + 1 );

      free ( pBuf );
   }

   return fb;
}
 
/***************************************************************************/
/* Save Options to OS2.INI                                                 */
/***************************************************************************/
BOOL             pfnSaveOpts  ( ) 
{
   ULONG    ulSize;
   ULONG    aulOpts[12];
   PBYTE    pBuf, pScn;
    
   aulOpts[0]  = ulTreeOpts;
   aulOpts[1]  = ulTextOpts;
   aulOpts[2]  = ulAddrOpts;
   aulOpts[3]  = ulToDoOpts;
   aulOpts[4]  = 0;//ulListOpts;
   aulOpts[5]  = ulMiniOpts;
   aulOpts[6]  = ulRefrOpts;
   aulOpts[7]  = 0;
   aulOpts[8]  = 0;
   aulOpts[9]  = 0;
   aulOpts[10] = 0;
   aulOpts[11] = 0;
    
   ulSize = 12 * sizeof ( ULONG );
    
   PrfWriteProfileData ( HINI_USERPROFILE, PRG_TITLE, OPTS_KEY,
                         aulOpts, ulSize );
    
   ulSize = sizeof ( ULONG ) * 16 +
            strlen ( colStrs.pszAddrName ) + 1 +
            strlen ( colStrs.pszAddrArea ) + 1 +
            strlen ( colStrs.pszAddrFone ) + 1 +
            strlen ( colStrs.pszAddrExtn ) + 1 +
            strlen ( colStrs.pszAddrAddr ) + 1 +
            strlen ( colStrs.pszAddrNote ) + 1 +
            strlen ( colStrs.pszAddrDate ) + 1 +
               
            strlen ( colStrs.pszToDoEntr ) + 1 +
            strlen ( colStrs.pszToDoTarg ) + 1 +
            strlen ( colStrs.pszToDoDone ) + 1 +
            strlen ( colStrs.pszToDoPrio ) + 1 +
            strlen ( colStrs.pszToDoIDid ) + 1 +
            strlen ( colStrs.pszToDoTask ) + 1 +
            strlen ( colStrs.pszToDoNote ) + 1;

   pBuf = (PBYTE) malloc ( ulSize );

   ((PCOLSTRS)pBuf)->version = REL_REV;
   ((PCOLSTRS)pBuf)->regCode = colStrs.regCode;

   if ( colStrs.regCode == UNREG_CODE )
      fbUnregistered = TRUE;
   else
      fbUnregistered = FALSE;

   pScn = pBuf;

   pScn += ( sizeof ( ULONG ) * 2 );

   *((PULONG)pScn) = colStrs.ulAddrName;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulAddrArea;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulAddrFone;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulAddrExtn;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulAddrAddr;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulAddrNote;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulAddrDate;  pScn += sizeof (ULONG);
                                        
   *((PULONG)pScn) = colStrs.ulToDoEntr;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulToDoTarg;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulToDoDone;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulToDoPrio;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulToDoIDid;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulToDoTask;  pScn += sizeof (ULONG);
   *((PULONG)pScn) = colStrs.ulToDoNote;  pScn += sizeof (ULONG);

   strcpy ( (PSZ)pScn, colStrs.pszAddrName ); pScn += ( strlen ( colStrs.pszAddrName ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszAddrArea ); pScn += ( strlen ( colStrs.pszAddrArea ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszAddrFone ); pScn += ( strlen ( colStrs.pszAddrFone ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszAddrExtn ); pScn += ( strlen ( colStrs.pszAddrExtn ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszAddrAddr ); pScn += ( strlen ( colStrs.pszAddrAddr ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszAddrNote ); pScn += ( strlen ( colStrs.pszAddrNote ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszAddrDate ); pScn += ( strlen ( colStrs.pszAddrDate ) + 1 );
                                                                                    
   strcpy ( (PSZ)pScn, colStrs.pszToDoEntr ); pScn += ( strlen ( colStrs.pszToDoEntr ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszToDoTarg ); pScn += ( strlen ( colStrs.pszToDoTarg ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszToDoDone ); pScn += ( strlen ( colStrs.pszToDoDone ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszToDoPrio ); pScn += ( strlen ( colStrs.pszToDoPrio ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszToDoIDid ); pScn += ( strlen ( colStrs.pszToDoIDid ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszToDoTask ); pScn += ( strlen ( colStrs.pszToDoTask ) + 1 );
   strcpy ( (PSZ)pScn, colStrs.pszToDoNote ); pScn += ( strlen ( colStrs.pszToDoNote ) + 1 );

   PrfWriteProfileData ( HINI_USERPROFILE, PRG_TITLE, COL_LISTS,
                         pBuf, ulSize );
    
   free ( pBuf );

   return TRUE;
}
 
/***************************************************************************/
/* Settings Notebook Setup                                                 */
/***************************************************************************/
MRESULT EXPENTRY pfndpSettings( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   //POINTERINFO  pi;
    
   static HWND    hwndNB;
   static ULONG   ulIdMain;
   static ULONG   ulIdText;
   static ULONG   ulIdAddr;
   static ULONG   ulIdToDo;
   static ULONG   ulIdMini;
   static ULONG   ulIdRefr;
   static ULONG   ulIdPrnt;

   static ULONG   ulIdAddrCol;
   static ULONG   ulIdToDoCol;
    
   switch ( msg ) 
   {
      case WM_INITDLG:
      {
         ULONG        ulId;
         HWND         hwndTmp;

         hwndNB = WinWindowFromID ( hwnd, DIT_NBK );
          
         ulId = WinQueryWindowULong ( hwndNB, QWL_STYLE );
         ulId |= BKS_SPIRALBIND;
         WinSetWindowULong ( hwndNB, QWL_STYLE, ulId );

         WinSendMsg ( hwndNB, BKM_SETNOTEBOOKCOLORS,
                      MPFROMLONG ( SYSCLR_DIALOGBACKGROUND ),
                      MPFROMLONG ( BKA_BACKGROUNDPAGECOLOR ) );
         WinSendMsg ( hwndNB, BKM_SETNOTEBOOKCOLORS,
                      MPFROMLONG ( SYSCLR_DIALOGBACKGROUND ),
                      MPFROMLONG ( BKA_BACKGROUNDMAJORCOLOR ) );
         WinSendMsg ( hwndNB, BKM_SETNOTEBOOKCOLORS,
                      MPFROMLONG ( SYSCLR_DIALOGBACKGROUND ),
                      MPFROMLONG ( BKA_BACKGROUNDMINORCOLOR ) );
          
         WinSendMsg ( hwndNB, BKM_SETDIMENSIONS,
                      MPFROM2SHORT ( WinQuerySysValue ( HWND_DESKTOP, SV_CXICON ) +
                                     WinQuerySysValue ( HWND_DESKTOP, SV_CXICON ) / 4,
                                     WinQuerySysValue ( HWND_DESKTOP, SV_CYICON ) +
                                     WinQuerySysValue ( HWND_DESKTOP, SV_CYICON ) / 4 ),
                      MPFROMSHORT ( BKA_MAJORTAB ) );
          
         WinSendMsg ( hwndNB, BKM_SETDIMENSIONS,
                      MPFROM2SHORT ( WinQuerySysValue ( HWND_DESKTOP, SV_CXICON ) +
                                     WinQuerySysValue ( HWND_DESKTOP, SV_CXICON ) / 4,
                                     WinQuerySysValue ( HWND_DESKTOP, SV_CYICON ) +
                                     WinQuerySysValue ( HWND_DESKTOP, SV_CYICON ) / 4 ),
                      MPFROMSHORT ( BKA_MINORTAB ) );
          
         inSettingsInit = TRUE;

         //*** Tree Window Page *********************************************
          
         ulId = (ULONG) WinSendMsg ( hwndNB, BKM_INSERTPAGE,
                                     NULL,
                                     MPFROM2SHORT ( BKA_MAJOR | BKA_AUTOPAGESIZE,// | BKA_STATUSTEXTON,
                                                    BKA_LAST ) );
          
         hwndTmp = WinLoadDlg ( hwnd, hwnd, pfndpNotebook, 0, DLG_NBK_MAIN, NULL );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEWINDOWHWND,
                      MPFROMLONG ( ulId ), MPFROMLONG ( hwndTmp ) );
          
         WinSendMsg ( hwndNB, BKM_SETSTATUSLINETEXT,
                      MPFROMLONG ( ulId ), MPFROMP ( " " ) );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEDATA,
                      MPFROMLONG ( ulId ), MPFROMLONG ( DLG_NBK_MAIN ) );
          
         ulIdMain = ulId;

          
         /*WinQueryPointerInfo ( hptr, &pi );
          
         WinSendMsg ( hwndNB, BKM_SETTABBITMAP,
                      MPFROMLONG ( ulId ), MPFROMLONG ( pi.hbmColor));//hbmPointer is small
         */
          
         //*** Text Editor Page *********************************************
          
         ulId = (ULONG) WinSendMsg ( hwndNB, BKM_INSERTPAGE,
                                     NULL,
                                     MPFROM2SHORT ( BKA_MAJOR | BKA_AUTOPAGESIZE,// | //BKA_STATUSTEXTON,
                                                    BKA_LAST ) );
          
         hwndTmp = WinLoadDlg ( hwnd, hwnd, pfndpNotebook, 0, DLG_NBK_TEXT, NULL );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEWINDOWHWND,
                      MPFROMLONG ( ulId ), MPFROMLONG ( hwndTmp ) );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEDATA,
                      MPFROMLONG ( ulId ), MPFROMLONG ( DLG_NBK_TEXT ) );
          
         ulIdText = ulId;
          
         /*WinQueryPointerInfo ( hptrText, &pi );
          
         WinSendMsg ( hwndNB, BKM_SETTABBITMAP,
                      MPFROMLONG ( ulId ), MPFROMLONG ( pi.hbmColor ));
         */
          
         //*** Address Book Page ********************************************
          
         ulId = (ULONG) WinSendMsg ( hwndNB, BKM_INSERTPAGE,
                                     NULL,
                                     MPFROM2SHORT ( BKA_MAJOR | BKA_AUTOPAGESIZE,// | //BKA_STATUSTEXTON,
                                                    BKA_LAST ) );
          
         hwndTmp = WinLoadDlg ( hwnd, hwnd, pfndpNotebook, 0, DLG_NBK_ADDR, NULL );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEWINDOWHWND,
                      MPFROMLONG ( ulId ), MPFROMLONG ( hwndTmp ) );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEDATA,
                      MPFROMLONG ( ulId ), MPFROMLONG ( DLG_NBK_ADDR ) );
          
         ulIdAddr = ulId;
          
         /*WinQueryPointerInfo ( hptrAddr, &pi );
          
         WinSendMsg ( hwndNB, BKM_SETTABBITMAP,
                      MPFROMLONG ( ulId ), MPFROMLONG ( pi.hbmColor ));
         */
          
          
         ulId = (ULONG) WinSendMsg ( hwndNB, BKM_INSERTPAGE,
                                     NULL,
                                     MPFROM2SHORT ( BKA_MINOR | BKA_AUTOPAGESIZE,// | //BKA_STATUSTEXTON,
                                                    BKA_LAST ) );
          
         hwndTmp = WinLoadDlg ( hwnd, hwnd, pfndpNotebook, 0, DLG_NBK_ADDR_COL, NULL );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEWINDOWHWND,
                      MPFROMLONG ( ulId ), MPFROMLONG ( hwndTmp ) );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEDATA,
                      MPFROMLONG ( ulId ), MPFROMLONG ( DLG_NBK_ADDR_COL ) );
          
         ulIdAddrCol = ulId;
          
          
         //*** To-Do List Page **********************************************
          
         ulId = (ULONG) WinSendMsg ( hwndNB, BKM_INSERTPAGE,
                                     NULL,
                                     MPFROM2SHORT ( BKA_MAJOR | BKA_AUTOPAGESIZE,// | //BKA_STATUSTEXTON,
                                                    BKA_LAST ) );
          
         hwndTmp = WinLoadDlg ( hwnd, hwnd, pfndpNotebook, 0, DLG_NBK_TODO, NULL );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEWINDOWHWND,
                      MPFROMLONG ( ulId ), MPFROMLONG ( hwndTmp ) );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEDATA,
                      MPFROMLONG ( ulId ), MPFROMLONG ( DLG_NBK_TODO ) );
          
         ulIdToDo = ulId;
          
         /*WinQueryPointerInfo ( hptrToDo, &pi );
          
         WinSendMsg ( hwndNB, BKM_SETTABBITMAP,
                      MPFROMLONG ( ulId ), MPFROMLONG ( pi.hbmColor ));
         */
          
         ulId = (ULONG) WinSendMsg ( hwndNB, BKM_INSERTPAGE,
                                     NULL,
                                     MPFROM2SHORT ( BKA_MINOR | BKA_AUTOPAGESIZE,// | //BKA_STATUSTEXTON,
                                                    BKA_LAST ) );
          
         hwndTmp = WinLoadDlg ( hwnd, hwnd, pfndpNotebook, 0, DLG_NBK_TODO_COL, NULL );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEWINDOWHWND,
                      MPFROMLONG ( ulId ), MPFROMLONG ( hwndTmp ) );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEDATA,
                      MPFROMLONG ( ulId ), MPFROMLONG ( DLG_NBK_TODO_COL ) );
          
         ulIdToDoCol = ulId;
          
          
         //*** Mini Page ****************************************************
          
         ulId = (ULONG) WinSendMsg ( hwndNB, BKM_INSERTPAGE,
                                     NULL,
                                     MPFROM2SHORT ( BKA_MAJOR | BKA_AUTOPAGESIZE,// | //BKA_STATUSTEXTON,
                                                    BKA_LAST ) );
          
         hwndTmp = WinLoadDlg ( hwnd, hwnd, pfndpNotebook, 0, DLG_NBK_MINI, NULL );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEWINDOWHWND,
                      MPFROMLONG ( ulId ), MPFROMLONG ( hwndTmp ) );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEDATA,
                      MPFROMLONG ( ulId ), MPFROMLONG ( DLG_NBK_MINI ) );
          
         ulIdMini = ulId;
          
         /*WinQueryPointerInfo ( hptrList, &pi );
          
         WinSendMsg ( hwndNB, BKM_SETTABBITMAP,
                      MPFROMLONG ( ulId ), MPFROMLONG ( pi.hbmColor ));
         */

         //*** Refr Page ****************************************************
          
         ulId = (ULONG) WinSendMsg ( hwndNB, BKM_INSERTPAGE,
                                     NULL,
                                     MPFROM2SHORT ( BKA_MAJOR | BKA_AUTOPAGESIZE,// | //BKA_STATUSTEXTON,
                                                    BKA_LAST ) );
          
         hwndTmp = WinLoadDlg ( hwnd, hwnd, pfndpNotebook, 0, DLG_NBK_REFR, NULL );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEWINDOWHWND,
                      MPFROMLONG ( ulId ), MPFROMLONG ( hwndTmp ) );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEDATA,
                      MPFROMLONG ( ulId ), MPFROMLONG ( DLG_NBK_REFR ) );
          
         ulIdRefr = ulId;
          
         /*WinQueryPointerInfo ( hptrList, &pi );
          
         WinSendMsg ( hwndNB, BKM_SETTABBITMAP,
                      MPFROMLONG ( ulId ), MPFROMLONG ( pi.hbmColor ));
         */

         //*** Print Page ***************************************************
          
         ulId = (ULONG) WinSendMsg ( hwndNB, BKM_INSERTPAGE,
                                     NULL,
                                     MPFROM2SHORT ( BKA_MAJOR | BKA_AUTOPAGESIZE,// | //BKA_STATUSTEXTON,
                                                    BKA_LAST ) );
          
         hwndTmp = WinLoadDlg ( hwnd, hwnd, pfndpNotebook, 0, DLG_NBK_PRNT, NULL );
          
         WinSendMsg ( hwndNB, BKM_SETPAGEWINDOWHWND,
                      MPFROMLONG ( ulId ), MPFROMLONG ( hwndTmp ) );
          
         ulIdPrnt = ulId;
          
         /*WinQueryPointerInfo ( hptrList, &pi );
          
         WinSendMsg ( hwndNB, BKM_SETTABBITMAP,
                      MPFROMLONG ( ulId ), MPFROMLONG ( pi.hbmColor ));
         */

         inSettingsInit = FALSE;

      }
      break;
       
      case WM_DRAWITEM:
      {
         POWNERITEM   poi;

         poi = PVOIDFROMMP ( mp2 );
          
         WinFillRect ( poi->hps, &poi->rclItem, SYSCLR_BUTTONMIDDLE );//SYSCLR_PAGEBACKGROUND );
          
         if ( poi->hItem == ulIdMain )
            WinDrawPointer ( poi->hps, poi->rclItem.xLeft, poi->rclItem.yBottom,
                             hptr, DP_NORMAL );
         else if ( poi->hItem == ulIdText )
            WinDrawPointer ( poi->hps, poi->rclItem.xLeft, poi->rclItem.yBottom,
                             hptrText, DP_NORMAL );
         else if ( poi->hItem == ulIdAddr ) 
            WinDrawPointer ( poi->hps, poi->rclItem.xLeft, poi->rclItem.yBottom,
                             hptrAddr, DP_NORMAL );
         else if ( poi->hItem == ulIdToDo ) 
            WinDrawPointer ( poi->hps, poi->rclItem.xLeft, poi->rclItem.yBottom,
                             hptrToDo, DP_NORMAL );
         else if ( poi->hItem == ulIdMini )
            WinDrawPointer ( poi->hps, poi->rclItem.xLeft, poi->rclItem.yBottom,
                             hptrMini, DP_NORMAL );
         else if ( poi->hItem == ulIdRefr )
            WinDrawPointer ( poi->hps, poi->rclItem.xLeft, poi->rclItem.yBottom,
                             hptrRefr, DP_NORMAL );
         else if ( poi->hItem == ulIdPrnt )
            WinDrawPointer ( poi->hps, poi->rclItem.xLeft, poi->rclItem.yBottom,
                             hptrPrnt, DP_NORMAL );
         else if ( poi->hItem == ulIdToDoCol || poi->hItem == ulIdAddrCol )
            WinDrawPointer ( poi->hps, poi->rclItem.xLeft, poi->rclItem.yBottom,
                             hptrText, DP_NORMAL );
      }
      return ( MRESULT ) TRUE;
       
      case WM_SIZE:
          
         WinSetWindowPos ( hwndNB, 0, 0, 0,
                           SHORT1FROMMP ( mp2 ),
                           SHORT2FROMMP ( mp2 ),
                           SWP_SIZE | SWP_MOVE );
          
      break;
       
      case WM_SYSCOMMAND:
          
         if ( LONGFROMMP ( mp1 ) == SC_CLOSE )
         {
            pfnSaveOpts ();
         }
          
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
      case UWM_PARAMS:
          
      break;
       
      case WM_COMMAND:
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case DID_OK:
            {
               WinPostMsg ( hwnd, WM_SYSCOMMAND, MPFROMLONG ( SC_CLOSE ), NULL );
            }
            break;

            case DIT_HELP:
            {
               ULONG ulPageId = (ULONG) WinSendMsg ( hwndNB, BKM_QUERYPAGEID,
                                                     MPFROMLONG ( 0 ), 
                                                     MPFROM2SHORT ( BKA_TOP, 0 ) );

               ulPageId = (ULONG) WinSendMsg ( hwndNB, BKM_QUERYPAGEDATA,
                                               MPFROMLONG ( ulPageId ), MPFROMLONG ( 0 ) );
      
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( ulPageId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
         }
          
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
    
     return ( MRESULT ) FALSE;
}
 
/***************************************************************************/
/* Settings Notebook Proc                                                  */
/***************************************************************************/

MRESULT EXPENTRY pfndpNotebook( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
    
   switch ( msg ) 
   {
      case WM_INITDLG:
      {
         USHORT usDlgID = WinQueryWindowUShort ( hwnd, QWS_ID );

         
         switch ( usDlgID ) 
         {
         case DLG_NBK_MAIN:
         WinCheckButton ( hwnd, MID_TREE_ICON,      ( ulTreeOpts & SCB_ICONED  ) ? TRUE : FALSE );
         WinCheckButton ( hwnd, MID_MAIN_TREELINES, ( ulTreeOpts & SCB_TREELIN ) ? TRUE : FALSE );
         WinCheckButton ( hwnd, MID_MAIN_STATS,     ( ulTreeOpts & SCB_STATED  ) ? TRUE : FALSE );
         WinCheckButton ( hwnd, MID_MAIN_MENU,      ( ulTreeOpts & SCB_MENUED  ) ? TRUE : FALSE );
         WinCheckButton ( hwnd, MID_MAIN_WINOWN,    ( ulTreeOpts & SCB_WINOWN  ) ? TRUE : FALSE );
         WinCheckButton ( hwnd, MID_TREE_TITFILE,   ( ulTreeOpts & SCB_TITFILE ) ? TRUE : FALSE );
         WinCheckButton ( hwnd, MID_TREE_WINTASK,   ( ulTreeOpts & SCB_WINTASK ) ? TRUE : FALSE );
         WinCheckButton ( hwnd, MID_MAIN_DROPREFR,  ( ulTreeOpts & SCB_DROPREFR) ? TRUE : FALSE );
         break;
          
         case DLG_NBK_ADDR:
         WinCheckButton ( hwnd, MID_ADDR_STATS, ( ulAddrOpts & SCB_STATED )  ? TRUE : FALSE );
         WinCheckButton ( hwnd, MID_ADDR_MENU,  ( ulAddrOpts & SCB_MENUED )  ? TRUE : FALSE );
          
         WinSendDlgItemMsg ( hwnd, DIT_ADDR_COM_PORT,  EM_SETTEXTLIMIT, MPFROMSHORT ( 8 ), NULL );
         WinSendDlgItemMsg ( hwnd, DIT_ADDR_COM_SETUP, EM_SETTEXTLIMIT, MPFROMSHORT ( 80 ), NULL );

         WinSetDlgItemText ( hwnd, DIT_ADDR_COM_PORT,  achComX );
         WinSetDlgItemText ( hwnd, DIT_ADDR_COM_SETUP, achComSet );
         break;

         case DLG_NBK_TODO:
         WinCheckButton ( hwnd, MID_TODO_STATS,  ( ulToDoOpts & SCB_STATED  )  ? TRUE : FALSE );
         WinCheckButton ( hwnd, MID_TODO_MENU,   ( ulToDoOpts & SCB_MENUED  )  ? TRUE : FALSE );
         WinCheckButton ( hwnd, MID_TODO_PRICOLR,( ulToDoOpts & SCB_PRICOLR )  ? TRUE : FALSE );
         break;
          
         case DLG_NBK_MINI:
         WinCheckButton ( hwnd, MID_MINI_STATS, ( ulMiniOpts & SCB_STATED )  ? TRUE : FALSE );
         WinCheckButton ( hwnd, MID_MINI_MENU,  ( ulMiniOpts & SCB_MENUED )  ? TRUE : FALSE );
         break;
          
         case DLG_NBK_REFR:
         WinCheckButton ( hwnd, DIT_REFR_DEFICO,( ulRefrOpts & DIT_REFR_DEFICON )  ? TRUE : FALSE );
         break;
          
         case DLG_NBK_PRNT:
         WinCheckButton ( hwnd, DIT_PRTHEAD,    ( ulTreeOpts & SCB_PRTHEAD )  ? TRUE : FALSE );
         WinCheckButton ( hwnd, DIT_PRTPAGE,    ( ulTreeOpts & SCB_PRTPAGE )  ? TRUE : FALSE );
         break;
          
         case DLG_NBK_ADDR_COL:
         pfnImportToMLE ( hwnd, DIT_ADDR_TXT_NAME,     colStrs.pszAddrName );
         pfnImportToMLE ( hwnd, DIT_ADDR_TXT_AREA,     colStrs.pszAddrArea );
         pfnImportToMLE ( hwnd, DIT_ADDR_TXT_PHONE,    colStrs.pszAddrFone );
         pfnImportToMLE ( hwnd, DIT_ADDR_TXT_EXT,      colStrs.pszAddrExtn );
         pfnImportToMLE ( hwnd, DIT_ADDR_TXT_ADDRESS,  colStrs.pszAddrAddr );
         pfnImportToMLE ( hwnd, DIT_ADDR_TXT_NOTES,    colStrs.pszAddrNote );
         //pfnImportToMLE ( hwnd, DIT_ADDR_TXT_DATE,     colStrs.pszAddrDate );
         break;

         case DLG_NBK_TODO_COL:
         pfnImportToMLE ( hwnd, DIT_TODO_TXT_ENTRY,    colStrs.pszToDoEntr );
         pfnImportToMLE ( hwnd, DIT_TODO_TXT_TARGET,   colStrs.pszToDoTarg );
         pfnImportToMLE ( hwnd, DIT_TODO_TXT_DONE,     colStrs.pszToDoDone );
         pfnImportToMLE ( hwnd, DIT_TODO_TXT_PRIORITY, colStrs.pszToDoPrio );
         pfnImportToMLE ( hwnd, DIT_TODO_TXT_ISDONE,   colStrs.pszToDoIDid );
         pfnImportToMLE ( hwnd, DIT_TODO_TXT_TASK,     colStrs.pszToDoTask );
         break;
         }
         //colStrs.pszToDoNote
      }
      break;
       
      case WM_COMMAND:
      {
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case DIT_FONTDEF_ALL: case DIT_FONTDEF_HED: case DIT_FONTDEF_CNT:
            {
               PSZ         pszKey;
               HPS         hps;
               HPS         hpsPrinter;
               DEFAULTREC  defRec;
               ULONG       ulSize;
               BOOL        fb;
      
               switch ( SHORT1FROMMP ( mp1 ) )
               {
                  case DIT_FONTDEF_ALL:
                     pszKey = FONT_ALL_KEY;
                  break;
                  case DIT_FONTDEF_HED:
                     pszKey = FONT_HED_KEY;
                  break;
                  case DIT_FONTDEF_CNT:
                     pszKey = FONT_CNT_KEY;
                  break;
               }
         
               ulSize = sizeof ( DEFAULTREC );
                
               fb = PrfQueryProfileData ( HINI_USERPROFILE, PRG_TITLE, pszKey,
                                          &defRec, &ulSize );
         
               if ( ! fb )
               {
                  pfnGetDefFattrs ( WinQueryWindow ( hwndM, QW_PARENT ), NULLHANDLE,
                                    &defRec.fat, &defRec.fxPtSz );
                   
                  defRec.ulOpts  = 0;
                  defRec.ulStyl  = 0;
                   
                  defRec.ulNBClr = CLR_BACKGROUND;
                  defRec.ulNFClr = CLR_NEUTRAL;
                  defRec.ulHBClr = CLR_DARKGRAY;
                  defRec.ulHFClr = CLR_BACKGROUND;
               }

               hps = WinGetPS ( hwnd );

               hpsPrinter = pfnCreatePS ( hwnd, &pqi );

               if ( pfnGetFont ( hwnd, hps, hpsPrinter, &defRec.fxPtSz, &defRec.fat ) )
               {
                  PrfWriteProfileData ( HINI_USERPROFILE, PRG_TITLE, pszKey,
                                        &defRec, sizeof ( DEFAULTREC ) );
               }
      
               WinReleasePS ( hps );
               pfnDestroyPS ( hpsPrinter );
            }
            break;
             
            case MID_TREE_FONT: case MID_ADDR_FONT: case MID_TODO_FONT:
            case MID_MINI_FONT: case MID_TEXT_FONT:
            {
               PSZ         pszKey;
               HPS         hps;
               DEFAULTREC  defRec;
               ULONG       ulSize;
               BOOL        fb;
      
               switch ( SHORT1FROMMP ( mp1 ) )
               {
                  case MID_TREE_FONT:
                     pszKey = TREE_KEY;
                  break;
                  case MID_ADDR_FONT:
                     pszKey = ADDR_KEY;
                  break;
                  case MID_TODO_FONT:
                     pszKey = TODO_KEY;
                  break;
                  case MID_MINI_FONT:
                     pszKey = MINI_KEY;
                  break;
                  case MID_TEXT_FONT:
                     pszKey = TEXT_KEY;
                  break;
               }
         
               ulSize = sizeof ( DEFAULTREC );
                
               fb = PrfQueryProfileData ( HINI_USERPROFILE, PRG_TITLE, pszKey,
                                          &defRec, &ulSize );
         
               if ( ! fb )
               {
                  pfnGetDefFattrs ( WinQueryWindow ( hwndM, QW_PARENT ), NULLHANDLE,
                                    &defRec.fat, &defRec.fxPtSz );
                   
                  defRec.ulOpts  = 0;
                  defRec.ulStyl  = 0;
                   
                  defRec.ulNBClr = CLR_BACKGROUND;
                  defRec.ulNFClr = CLR_NEUTRAL;
                  defRec.ulHBClr = CLR_DARKGRAY;
                  defRec.ulHFClr = CLR_BACKGROUND;
               }

               hps = WinGetPS ( hwnd );

               if ( pfnGetFont ( hwnd, hps, NULLHANDLE, &defRec.fxPtSz, &defRec.fat ) )
               {
                  PrfWriteProfileData ( HINI_USERPROFILE, PRG_TITLE, pszKey,
                                        &defRec, sizeof ( DEFAULTREC ) );
               }
      
               WinReleasePS ( hps );
            }
            break;
             
            case MID_TREE_COLOR: case MID_ADDR_COLOR: case MID_TODO_COLOR:
            case MID_MINI_COLOR: case MID_TEXT_COLOR:
            {
               PSZ         pszKey;
               DEFAULTREC  defRec;
               ULONG       ulSize;
               BOOL        fb;
               HWND        hwndTmp;
      
               switch ( SHORT1FROMMP ( mp1 ) )
               {
                  case MID_TREE_COLOR:
                     pszKey = TREE_KEY;
                  break;
                  case MID_ADDR_COLOR:
                     pszKey = ADDR_KEY;
                  break;
                  case MID_TODO_COLOR:
                     pszKey = TODO_KEY;
                  break;
                  case MID_MINI_COLOR:
                     pszKey = MINI_KEY;
                  break;
                  case MID_TEXT_COLOR:
                     pszKey = TEXT_KEY;
                  break;
               }
         
               ulSize = sizeof ( DEFAULTREC );
                
               fb = PrfQueryProfileData ( HINI_USERPROFILE, PRG_TITLE, pszKey,
                                          &defRec, &ulSize );
         
               if ( ! fb )
               {
                  pfnGetDefFattrs ( WinQueryWindow ( hwndM, QW_PARENT ), NULLHANDLE,
                                    &defRec.fat, &defRec.fxPtSz );
                   
                  defRec.ulOpts  = 0;
                  defRec.ulStyl  = 0;
                   
                  defRec.ulNBClr = CLR_BACKGROUND;
                  defRec.ulNFClr = CLR_NEUTRAL;
                  defRec.ulHBClr = CLR_DARKGRAY;
                  defRec.ulHFClr = CLR_BACKGROUND;
               }

               hwndTmp = WinCreateWindow ( hwnd, WC_STATIC, " ",
                                           SS_TEXT | DT_LEFT,
                                           0, 0, 0, 0, hwnd, HWND_TOP, 200, NULL, NULL );
          
               WinSetPresParam ( hwndTmp, PP_BACKGROUNDCOLORINDEX,       4L, &defRec.ulNBClr );
               WinSetPresParam ( hwndTmp, PP_FOREGROUNDCOLORINDEX,       4L, &defRec.ulNFClr );
               WinSetPresParam ( hwndTmp, PP_HILITEBACKGROUNDCOLORINDEX, 4L, &defRec.ulHBClr );
               WinSetPresParam ( hwndTmp, PP_HILITEFOREGROUNDCOLORINDEX, 4L, &defRec.ulHFClr );

               if ( WinDlgBox ( HWND_DESKTOP, hwnd, pfndpColors, 0L, 
                                DLG_COLORS, &hwndTmp ) )
               {
                  WinQueryPresParam ( hwndTmp, PP_BACKGROUNDCOLORINDEX,       0, NULL, 4L, &defRec.ulNBClr, QPF_NOINHERIT );
                  WinQueryPresParam ( hwndTmp, PP_FOREGROUNDCOLORINDEX,       0, NULL, 4L, &defRec.ulNFClr, QPF_NOINHERIT );
                  WinQueryPresParam ( hwndTmp, PP_HILITEBACKGROUNDCOLORINDEX, 0, NULL, 4L, &defRec.ulHBClr, QPF_NOINHERIT );
                  WinQueryPresParam ( hwndTmp, PP_HILITEFOREGROUNDCOLORINDEX, 0, NULL, 4L, &defRec.ulHFClr, QPF_NOINHERIT );

                  PrfWriteProfileData ( HINI_USERPROFILE, PRG_TITLE, pszKey,
                                        &defRec, sizeof ( DEFAULTREC ) );
               }

               WinDestroyWindow ( hwndTmp );
            }
            break;
         }

      }
      break;
       
      case WM_HELP:
      {
         SHORT   sId;

         sId = WinQueryWindowUShort ( hwnd, QWS_ID );

         WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                      MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
      }
      break;
       
      case WM_CONTROL:
      {
         USHORT  usWinType;
         USHORT  usChecked;
         ULONG   ulLen;
         USHORT  usDlgID = WinQueryWindowUShort ( hwnd, QWS_ID );

         if ( SHORT2FROMMP ( mp1 ) == BKN_HELP )
         {
            ULONG ulPageId = LONGFROMMP ( mp2 );
             
            WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                         MPFROMSHORT ( ulPageId ), MPFROMSHORT ( HM_RESOURCEID ) );
         }
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            //*** Tree Win **************************************************
                
            case MID_TREE_ICON:    case MID_MAIN_TREELINES:  case MID_MAIN_STATS:
            case MID_MAIN_MENU:    case MID_MAIN_WINOWN:     case MID_MAIN_1TXTICO:
            case MID_TREE_TITFILE: case MID_TREE_WINTASK:    case MID_MAIN_DROPREFR:
            {
               usWinType = WinQueryWindowUShort ( hwnd, QWS_ID );
                
               usWinType = WID_MAIN;
            }
            break;
             
            //*** Addr Win **************************************************
                
            case MID_ADDR_STATS: case MID_ADDR_MENU: case DIT_ADDR_ENTER_DIAL:
            {
               usWinType = WinQueryWindowUShort ( hwnd, QWS_ID );
                
               usWinType = WID_ADDR;
            }
            break;
             
            case DIT_ADDR_COM_PORT:
            {
               if ( SHORT2FROMMP ( mp1 ) == EN_KILLFOCUS &&
                    WinSendDlgItemMsg ( hwnd, SHORT1FROMMP ( mp1 ),
                                        EM_QUERYCHANGED, NULL, NULL ) )
               {
                  WinQueryDlgItemText ( hwnd, DIT_ADDR_COM_PORT, 8, achComX );
      
                  PrfWriteProfileString ( HINI_USERPROFILE, PRG_TITLE, MOD_POR_KEY,
                                          achComX );
               }
            }
            break;

            case DIT_ADDR_COM_SETUP:
            {
               if ( SHORT2FROMMP ( mp1 ) == EN_KILLFOCUS &&
                    WinSendDlgItemMsg ( hwnd, SHORT1FROMMP ( mp1 ),
                                        EM_QUERYCHANGED, NULL, NULL ) )
               {
                  WinQueryDlgItemText ( hwnd, DIT_ADDR_COM_SETUP, 80, achComSet );
      
                  PrfWriteProfileString ( HINI_USERPROFILE, PRG_TITLE, MOD_SET_KEY,
                                          achComSet );
               }
            }
            break;

            //*** Addr Columns **********************************************
                
            case DIT_ADDR_TXT_NAME:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_ADDR_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszAddrName, &ulLen, FALSE );
               }
            }
            break;
            case DIT_ADDR_TXT_AREA:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_ADDR_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszAddrArea, &ulLen, FALSE  );
               }
            }
            break;
            case DIT_ADDR_TXT_PHONE:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_ADDR_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszAddrFone, &ulLen, FALSE  );
               }
            }
            break;
            case DIT_ADDR_TXT_EXT:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_ADDR_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszAddrExtn, &ulLen, FALSE  );
               }
            }
            break;
            case DIT_ADDR_TXT_ADDRESS:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_ADDR_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszAddrAddr, &ulLen, FALSE  );
               }
            }
            break;
            case DIT_ADDR_TXT_NOTES:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_ADDR_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszAddrNote, &ulLen, FALSE  );
               }
            }
            break;

            //*** ToDo Win **************************************************
                
            case MID_TODO_STATS: case MID_TODO_MENU: case MID_TODO_PRICOLR:
            {
               usWinType = WinQueryWindowUShort ( hwnd, QWS_ID );
                
               usWinType = WID_TODO;
            }
            break;
             
            //*** ToDo Columns **********************************************
                
            case DIT_TODO_TXT_ENTRY:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_TODO_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszToDoEntr, &ulLen, FALSE  );
               }
            }
            break;
            case DIT_TODO_TXT_TARGET:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_TODO_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszToDoTarg, &ulLen, FALSE  );
               }
            }
            break;
            case DIT_TODO_TXT_DONE:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_TODO_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszToDoDone, &ulLen, FALSE  );
               }
            }
            break;
            case DIT_TODO_TXT_PRIORITY:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_TODO_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszToDoPrio, &ulLen, FALSE  );
               }
            }
            break;
            case DIT_TODO_TXT_ISDONE:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_TODO_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszToDoIDid, &ulLen, FALSE  );
               }
            }
            break;
            case DIT_TODO_TXT_TASK:
            {
               if ( SHORT2FROMMP ( mp1 ) == MLN_KILLFOCUS && ! inSettingsInit && usDlgID == DLG_NBK_TODO_COL )
               {
                  pfnExportFromMLE ( hwnd, SHORT1FROMMP(mp1), &colStrs.pszToDoTask, &ulLen, FALSE  );
               }
            }
            break;

            //*** Mini Win **************************************************
                
            case MID_MINI_STATS: case MID_MINI_MENU:
            {
               usWinType = WinQueryWindowUShort ( hwnd, QWS_ID );
                
               usWinType = WID_MINI;
            }
            break;
             
            //*** Refr Win **************************************************
                
            case DIT_REFR_DEFICO:
            {
               usWinType = WinQueryWindowUShort ( hwnd, QWS_ID );
                
               usWinType = WID_REFR;
            }
            break;
             
            //*** Text Win **************************************************
                
            case MID_TEXT_WRAP:
            {
               usWinType = WID_TEXT;
            }
            break;
             
            case DIT_PRTHEAD: case DIT_PRTPAGE:
            {
               usWinType = WID_PRNT;
            }
            break;

         }
          
         //******************************************************************
                
         if ( SHORT2FROMMP ( mp1 ) == BN_CLICKED ) 
         {
            usChecked = WinQueryButtonCheckstate ( hwnd, SHORT1FROMMP ( mp1 ) );
             
            WinSendMsg ( hwndM, UWM_SETTING,
                         MPFROM2SHORT ( usWinType, SHORT1FROMMP ( mp1 ) ),
                         MPFROM2SHORT ( usChecked, 0 ) );
         }
         else if ( SHORT2FROMMP ( mp1 ) == BKN_HELP )
         {
            ULONG ulPageId = LONGFROMMP ( mp2 );
             
            WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                         MPFROMSHORT ( ulPageId ), MPFROMSHORT ( HM_RESOURCEID ) );
         }
      }
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
    
     return ( MRESULT ) FALSE;
}
 
//****************************************************************************
// Print Dialog
//****************************************************************************
MRESULT EXPENTRY pfndpPrint     ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{      
   HWND        hwndT;
   SHORT       sX;
   MRESULT     mr   = MRFROMLONG ( FALSE );

   PPRQINFO3   ppqiScn;

   static      PPRQINFO3  ppqiBuf;
   static      TID        tid;
   static      PFNTHREAD  pfnThread;
   //static      ULONG      ulPrinted;

   switch ( msg )
   {
      case WM_INITDLG:
      {
         ULONG     ulReturned;
         ULONG     ulTotal;
         ULONG     ulBufSize;
         BOOL      fbDefFound;

         fbPrinting = FALSE;
         //ulPrinted = 0;

         pfnThread = (PFNTHREAD) PVOIDFROMMP ( mp2 );

         //*** Init Global Print Control Structure **************************

         pfnNewPrintCtl ( hwnd );

         //*** Get Queue List ***********************************************

         SplEnumQueue ( NULL, 3, NULL, 0,
                        &ulReturned, &ulTotal, &ulBufSize, NULL );

         ppqiBuf = (PPRQINFO3) malloc ( ulBufSize );

         SplEnumQueue ( NULL, 3, ppqiBuf, ulBufSize,
                        &ulReturned, &ulTotal, &ulBufSize, NULL );

         //*** Set up Queue List ********************************************

         fbDefFound = FALSE;

         hwndT = WinWindowFromID ( hwnd, DIT_QUEUES );

         ppqiScn = ppqiBuf;

         for ( sX = 0; sX < ulReturned; ++sX )
         {
            if ( *ppqiScn->pszComment )
               mr = WinSendMsg ( hwndT, LM_INSERTITEM, 
                                 MPFROMLONG ( LIT_SORTASCENDING ),
                                 MPFROMP ( ppqiScn->pszComment ) );
            else
               mr = WinSendMsg ( hwndT, LM_INSERTITEM, 
                                 MPFROMLONG ( LIT_SORTASCENDING ),
                                 MPFROMP ( ppqiScn->pszName ) );

            WinSendMsg ( hwndT, LM_SETITEMHANDLE, mr, MPFROMLONG ( sX ) );
        
            if ( ! strcmp ( ppqiScn->pszName,    pszQueueName ) )
            {
               //ppqiDef = ppqiScn;
               fbDefFound = TRUE;
               WinSendMsg ( hwndT, LM_SELECTITEM,
                            mr, MPFROMLONG ( TRUE ) );
            }

            ++ppqiScn;
         }

         //*** Init Dialog Controls *****************************************

         WinCheckButton ( hwnd, DIT_PRTHEAD, ( ulTreeOpts & SCB_PRTHEAD ) ? TRUE : FALSE );
         WinCheckButton ( hwnd, DIT_PRTPAGE, ( ulTreeOpts & SCB_PRTPAGE ) ? TRUE : FALSE );

         if ( ! fbDefFound )
            WinSendMsg ( hwndT, LM_SELECTITEM,
                         MPFROMLONG ( 0 ), MPFROMLONG ( TRUE ) );

         WinSendDlgItemMsg ( hwnd, DIT_SLDR, SLM_SETSLIDERINFO,
                             MPFROM2SHORT ( SMA_SHAFTPOSITION, 0 ), 
                             MPFROMSHORT ( 0 ) );
          
         mr = MRFROMLONG ( FALSE );//TRUE );
      }
      break;

      case WM_HELP:
      {
         SHORT   sId;

         sId = WinQueryWindowUShort ( hwnd, QWS_ID );

         WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                      MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
      }
      break;
       
      case WM_COMMAND:
      {
         switch ( SHORT1FROMMP ( mp1 ) )
         {
            case DIT_HELP:
            {
               SHORT   sId;
      
               sId = WinQueryWindowUShort ( hwnd, QWS_ID );
      
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
             
            case DIT_FONT_P:
            {
               HPS   hps = WinGetPS ( hwnd );

               pprtCtl->hpsPrinter = pfnCreatePS ( hwnd, &pqi );

               if ( pfnGetFont ( hwnd, hps, pprtCtl->hpsPrinter,
                                 &pprtCtl->defPrtAll.fxPtSz, 
                                 &pprtCtl->defPrtAll.fat ) )
               {
                  pprtCtl->fbNewFont = TRUE;
               }

               pfnDestroyPS ( pprtCtl->hpsPrinter );

               WinReleasePS ( hps );
            }
            break;
             
            case DIT_JOBPROP:
            {
               PSZ  pszDriverName;
               PSZ  pszDeviceName;
               PSZ  pszTemp;

               hwndT = WinWindowFromID ( hwnd, DIT_QUEUES );
      
               mr = WinSendMsg ( hwndT, LM_QUERYSELECTION, 
                                 MPFROMLONG ( LIT_FIRST ), NULL );
               mr = WinSendMsg ( hwndT, LM_QUERYITEMHANDLE, mr, NULL );
      
               ppqiScn = ppqiBuf;
               ppqiScn += (SHORT)mr;

               pszDriverName = strdup ( ppqiScn->pszDriverName );
               pszDeviceName = strdup ( ppqiScn->pszDriverName );

               sX = strcspn ( pszDriverName, "." );

               if ( sX )
               {
                  pszDriverName[sX] = '\0';

                  strcpy ( pszDeviceName, &pszDriverName[sX + 1] );
               }
               else
               {
                  *pszDeviceName = '\0';
               }
            
               pszTemp = strchr ( ppqiScn->pszPrinters, ',' );

               if ( pszTemp )
               {
                  *pszTemp = '\0' ;
               }
            
               DevPostDeviceModes ( WinQueryAnchorBlock ( hwnd ),
                                    ppqiScn->pDriverData,
                                    pszDriverName,
                                    pszDeviceName,
                                    ppqiScn->pszPrinters,
                                    DPDM_POSTJOBPROP );
            }
            break;

            case DID_OK:
            {
               ULONG lPelsX;
               ULONG lPelsY;

               DosResetEventSem ( evtThdDone, &lPelsY );

               WinEnableWindow ( WinWindowFromID ( hwnd, DID_OK     ), FALSE );
               WinEnableWindow ( WinWindowFromID ( hwnd, DIT_FONT_P ), FALSE );
               WinEnableWindow ( WinWindowFromID ( hwnd, DIT_JOBPROP), FALSE );
//               WinEnableWindow ( WinWindowFromID ( hwnd, DID_CANCEL ), FALSE );

               pfnCanCloseWin ( hwnd, TRUE, FALSE );

               if ( WinQueryButtonCheckstate ( hwnd, DIT_PRTHEAD ) )
                  ulTreeOpts |= SCB_PRTHEAD;
               else
                  ulTreeOpts &= ~SCB_PRTHEAD;

               if ( WinQueryButtonCheckstate ( hwnd, DIT_PRTPAGE ) )
                  ulTreeOpts |= SCB_PRTPAGE;
               else
                  ulTreeOpts &= ~SCB_PRTPAGE;

               hwndT = WinWindowFromID ( hwnd, DIT_QUEUES );

               mr = WinSendMsg ( hwndT, LM_QUERYSELECTION, 
                                 MPFROMLONG ( LIT_FIRST ), NULL );
               mr = WinSendMsg ( hwndT, LM_QUERYITEMHANDLE, mr, NULL );
      
               ppqiScn = ppqiBuf;
               ppqiScn += (SHORT)mr;

               strcpy ( pszQueueName, ppqiScn->pszName );

               PrfWriteProfileString ( HINI_USERPROFILE, PRG_TITLE, PRTQ_KEY,
                                       pszQueueName );
      
               pfnPrintQFree ( &pqi );
               pfnPrintQDupe ( &pqi, ppqiScn );

               free ( ppqiBuf );

               //*** Initialize Print Variables *****************************

               pprtCtl->hpsPrinter = pfnPrintStart ( hwnd, &pqi, APP_TITLE );
            
               if ( ! pprtCtl->hpsPrinter )
               {
                  pfnMsgOK ( hwnd, APP_TITLE, "Error starting print job." );

                  free ( ppqiBuf );
                  free ( pprtCtl );
   
                  WinDismissDlg ( hwnd, FALSE );
               }
            
               pfnPrintCurrForm  ( hwnd, pprtCtl->hpsPrinter, &pprtCtl->hci, TRUE );
               pfnPelsPerInch    ( hwnd, pprtCtl->hpsPrinter, &lPelsX, &lPelsY );
            
               if ( pprtCtl->hci.xLeftClip < lPelsX )
                  pprtCtl->hci.xLeftClip = lPelsX;
            
               if ( pprtCtl->hci.yTopClip > pprtCtl->hci.yPels - lPelsY )
                  pprtCtl->hci.yTopClip = pprtCtl->hci.yPels - lPelsY;
            

               pfnCvtVecFont     ( pprtCtl->hpsPrinter, 
                                   pprtCtl->defPrtHed.fxPtSz, 
                                   &pprtCtl->defPrtHed.fat );
               pfnSetPaintFont   ( hwnd, pprtCtl->hpsPrinter, 
                                   &pprtCtl->defPrtHed.fat, FONTID_HED );

               GpiQueryFontMetrics ( pprtCtl->hpsPrinter, sizeof ( FONTMETRICS ), 
                                     &pprtCtl->fmHed );

               pfnCvtVecFont     ( pprtCtl->hpsPrinter, 
                                   pprtCtl->defPrtCnt.fxPtSz,
                                   &pprtCtl->defPrtCnt.fat );
               pfnSetPaintFont   ( hwnd, pprtCtl->hpsPrinter, 
                                   &pprtCtl->defPrtCnt.fat, FONTID_CNT );

               GpiQueryFontMetrics ( pprtCtl->hpsPrinter, sizeof ( FONTMETRICS ), 
                                     &pprtCtl->fmCnt );

               pfnPrintBounds    ( hwnd );

               fbPrinting = TRUE;

               //DosCreateThread ( &tid, (PFNTHREAD)pfnThread, 0L, 0L, 2000000 );
               tid = _beginthread ( (VOID (*_Optlink)(PVOID))pfnThread,
                                    NULL, 
                                    1024000,
                                    NULL );

               //WinDismissDlg ( hwnd, TRUE );
            }
            break;

            case DID_CANCEL:
            {
               if ( fbPrinting )
               {
                  fbPrinting = FALSE;

                  //DosWaitThread ( &tid, DCWW_WAIT );
                  DosWaitEventSem ( evtThdDone, 20000 );
                  //if ( ! DosKillThread ( tid ) )
                     pfnPrintStop ( hwnd, pprtCtl->hpsPrinter, FALSE );
               }

               free ( ppqiBuf );
               free ( pprtCtl );

               WinDismissDlg ( hwnd, FALSE );
            }
            break;
         }
      }
      break;

      case UWM_STAT:
      {
         ULONG   ulPrinted = LONGFROMMP ( mp1 );
         ULONG   ulTotal   = LONGFROMMP ( mp2 );
             
         WinSendDlgItemMsg ( hwnd, DIT_SLDR, SLM_SETSLIDERINFO,
                             MPFROM2SHORT ( SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE ),
                             MPFROMLONG ( ulPrinted * 100L / ulTotal ) );
      }
      break;

      case UWM_DONE:
      {
         WinSendDlgItemMsg ( hwnd, DIT_SLDR, SLM_SETSLIDERINFO,
                             MPFROM2SHORT ( SMA_SHAFTPOSITION, 0 ), 
                             MPFROMLONG ( 99 ) );
          
         pfnPrintStop ( hwnd, pprtCtl->hpsPrinter, TRUE );

         free ( ppqiBuf );
         free ( pprtCtl );

         DosSleep ( 500 );

         WinDismissDlg ( hwnd, TRUE );
      }
      break;
       
      case UWM_ERROR:
      {
//         pfnMsgOK ( hwnd, APP_TITLE, "Print job terminated due to error" );

         free ( pprtCtl );

         WinDismissDlg ( hwnd, FALSE );
      }
      break;
       
      default:
      {
         mr = WinDefDlgProc ( hwnd, msg, mp1, mp2 );
      }
      break;
   }
   return mr;
}

