/* Main #define's & #include's */
 
#define VAR_SCOPE extern
 
#include "fsp.h"
 
 
/* #defines */
 
 
 
/* typedefs */
 
 
 
/* Globals */
 
 
 
/* Prototypes */
 
BOOL             pfnListStat  ( PUSEREC );
 
 
 
MRESULT EXPENTRY pfnwpLst2Win ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {
    
   /* Local Vars */
    
   SWP     swp;
   HWND    hwndMenu;
   POINTL  ptl;
   ULONG   ulOff;
   USHORT  usResp;
   PBYTE   pbDat;
   ULONG   ulLen;
   CHAR    ach24[25];
    
   PVOID   pvClip;
   ULONG   ulSize;
   PBYTE   pbScn;
    
   PSZ     pszCol;
    
   /* Container Stuff */
    
   CNRINFO               cnrinf;
   PFIELDINFO            pfinf;
   PFIELDINFO            pfinfScn;
   FIELDINFOINSERT       fInfIns;
   PUSEREC               pRecScn;
   PLST2REC              pLst2New;
   PLST2REC              pLst2Foc;
   RECORDINSERT          recins;
   PDATREC               pdr;
   PCNREDITDATA          pcnrEdt;
   CNREDITDATA           cnrEdt;
    
    
    
   pRecScn = WinQueryWindowPtr ( hwnd, 0 );
    
   switch ( msg ) {
       
      case WM_CREATE:
          
      break;
       
      case WM_ACTIVATE:
          
         if ( SHORT1FROMMP ( mp1 ) ) {
             
            hwndFoc = HWNDFROMMP ( mp2 );
             
            WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                         MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                         MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
         }
         else {
             
            hwndFoc = HWNDFROMMP ( mp2 );
             
            WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                         NULL, NULL );
         }
          
      break;
       
      case WM_SIZE:
          
         if ( pRecScn ) {
             
            WinSetWindowPos ( pRecScn->pdr->hwndE, 0, 0, 0,
                              SHORT1FROMMP ( mp2 ),
                              SHORT2FROMMP ( mp2 ),
                              SWP_SHOW | SWP_SIZE | SWP_MOVE );
         }
          
      break;
       
      case UWM_PARAMS:
          
         /* Store Data Pointer */
          
         pRecScn = PVOIDFROMMP ( mp1 );
          
         WinSetWindowPtr ( hwnd, 0, pRecScn );
          
         pdr = pRecScn->pdr;
          
          
         /* Frame */
          
         pfnSetWinPos ( hwnd, pdr );
          
         pdr->hwndM = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU );
          
         pdr->pszStat = malloc ( 80 );
          
          
          
         /* Create & Init Container */
          
         pdr->hwndE = WinCreateWindow ( hwnd, WC_CONTAINER, NULL,
                                        CCS_SINGLESEL,
                                        0,0,0,0, hwnd, HWND_TOP,
                                        WID_CONT, NULL, NULL );
          
         cnrinf.pszCnrTitle  = pdr->pszStat;
         cnrinf.flWindowAttr = CV_DETAIL | CA_DETAILSVIEWTITLES;
          
         if ( ulListOpts & SCB_STATED ) {
             
            cnrinf.flWindowAttr |= CA_CONTAINERTITLE | CA_TITLESEPARATOR | CA_TITLEREADONLY;
             
         }
          
         WinSendMsg ( pdr->hwndE, CM_SETCNRINFO, &cnrinf,
                      MPFROMLONG ( CMA_FLWINDOWATTR ) );
          
         sprintf ( ach24, "%d.%s", FIXEDINT(pdr->fxPtSz), pdr->fat.szFacename );
          
         WinSetPresParam ( pdr->hwndE, PP_FONTNAMESIZE,
                           strlen ( ach24 ) + 1, ach24 );
          
         WinSendMsg ( pdr->hwndE, CM_QUERYCNRINFO,
                      MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
          
          
          
         /* Allocate & Init Field Info */
          
         pbDat = pdr->pvDat;
          
         pfinf = WinSendMsg ( pdr->hwndE, CM_ALLOCDETAILFIELDINFO,
                              MPFROMLONG ( 3 ), NULL);
          
         pfinfScn = pfinf;
          
         cnrinf.pFieldInfoLast = pfinfScn;
          
         pRecScn->pdr->pfi    = pfinfScn;
          
         pfinfScn->cb         = sizeof ( FIELDINFO );
         pfinfScn->flData     = CFA_STRING | CFA_TOP | CFA_HORZSEPARATOR | CFA_SEPARATOR;
         pfinfScn->flTitle    = 0;
         if ( pdr->ulDLen ) {
             
            ulLen = strlen ( pbDat ) + 1;
            pfinfScn->pTitleData = malloc ( ulLen );
            strcpy ( pfinfScn->pTitleData, pbDat );
            pbDat += ulLen;
             
            }
            else {
             
            pfinfScn->pTitleData = malloc ( strlen ( "Your 1st\ncolumn title\nhere\n(Alt+Left Mouse Button)" ) );
             
            strcpy ( pfinfScn->pTitleData, "Your 1st\ncolumn title\nhere\n(Alt+Left Mouse Button)" );
             
         }
         pfinfScn->offStruct  = FIELDOFFSET ( LST2REC, psz1 );
         pfinfScn             = pfinfScn->pNextFieldInfo;
          
         pfinfScn->cb         = sizeof ( FIELDINFO );
         pfinfScn->flData     = CFA_STRING | CFA_TOP | CFA_HORZSEPARATOR | CFA_SEPARATOR;
         pfinfScn->flTitle    = 0;
         if ( pdr->ulDLen ) {
             
            ulLen = strlen ( pbDat ) + 1;
            pfinfScn->pTitleData = malloc ( ulLen );
            strcpy ( pfinfScn->pTitleData, pbDat );
            pbDat += ulLen;
             
            }
            else {
             
            pfinfScn->pTitleData = malloc ( strlen ( "Your 2nd\ncolumn title\nhere\n(Alt+Left Mouse Button)" ) );
             
            strcpy ( pfinfScn->pTitleData, "Your 2nd\ncolumn title\nhere\n(Alt+Left Mouse Button)" );
             
         }
         pfinfScn->offStruct  = FIELDOFFSET ( LST2REC, psz2 );
         pfinfScn             = pfinfScn->pNextFieldInfo;
          
         pfinfScn->cb         = sizeof ( FIELDINFO );
         pfinfScn->flData     = CFA_DATE | CFA_TOP | CFA_HORZSEPARATOR;
         pfinfScn->flTitle    = CFA_FITITLEREADONLY;
         pfinfScn->pTitleData = "Date";
         pfinfScn->offStruct  = FIELDOFFSET ( LST2REC, cdCur );
         pfinfScn             = pfinfScn->pNextFieldInfo;
          
          
         /* Insert */
          
         fInfIns.cb                   = sizeof ( FIELDINFOINSERT );
         fInfIns.pFieldInfoOrder      = (PFIELDINFO)CMA_FIRST;
         fInfIns.cFieldInfoInsert     = 2;
         fInfIns.fInvalidateFieldInfo = TRUE;
          
         WinSendMsg ( pdr->hwndE, CM_INSERTDETAILFIELDINFO,
                      MPFROMP ( pfinf ),
                      MPFROMP ( &fInfIns ) );
          
          
         /* Position Container */
          
         WinSendMsg ( pdr->hwndE, CM_SETCNRINFO,
                      MPFROMP ( &cnrinf ),
                      MPFROMLONG ( CMA_PFIELDINFOLAST ) );
          
         WinQueryWindowPos ( hwnd, &swp );
          
         WinSetWindowPos ( pdr->hwndE, HWND_TOP,
                           0, 0,
                           swp.cx,
                           swp.cy,
                           SWP_SIZE | SWP_MOVE | SWP_SHOW );
          
         WinSetFocus ( HWND_DESKTOP, pdr->hwndE );
          
          
         /* Set up Splitbar */
          
         if ( ! pdr->ulDLen ) {
             
            pdr->ulXVS = swp.cx / 2;
             
         }
          
         cnrinf.xVertSplitbar = pdr->ulXVS;
          
         WinSendMsg ( pdr->hwndE, CM_SETCNRINFO,
                      MPFROMP ( &cnrinf ),
                      MPFROMLONG ( CMA_XVERTSPLITBAR ) );
          
          
         /* Insert Data */
          
         for ( ulOff = 0; ulOff < pdr->ulDEnt; ++ulOff ) {
             
            pLst2New = WinSendMsg ( pRecScn->pdr->hwndE, CM_ALLOCRECORD,
                                    MPFROMLONG (sizeof(LST2REC)-sizeof(RECORDCORE)),
                                    MPFROMSHORT( 1 ) );
             
            /* Init Record */
             
            ulLen = strlen ( pbDat ) + 1;
            pLst2New->psz1 = malloc ( ulLen );
            strcpy ( pLst2New->psz1, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pLst2New->psz2 = malloc ( ulLen );
            strcpy ( pLst2New->psz2, pbDat );
            pbDat += ulLen;
             
            memcpy ( &pLst2New->cdCur, pbDat, sizeof ( CDATE ) );
            pbDat += sizeof ( CDATE );
             
             
            /* Insert */
             
            recins.cb                = sizeof ( RECORDINSERT );
            recins.pRecordParent     = (PRECORDCORE) NULL;
            recins.pRecordOrder      = (PRECORDCORE) CMA_END;
            recins.zOrder            = CMA_TOP;
            recins.cRecordsInsert    = 1;
            recins.fInvalidateRecord = TRUE;
             
            WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                         MPFROMP( pLst2New ), MPFROMP ( &recins ) );
             
             
         }
          
          
         pdr->ulOpts |= SCB_OPENED;
          
         pdr->fbModified = FALSE;
          
         pfnListStat ( pRecScn );
          
      break;
       
      case WM_INITMENU:
          
         WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
          
         hwndMenu = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU);
          
         switch ( SHORT1FROMMP ( mp1 ) ) {
             
            case MID_LIST_EDIT:
                
               if (  pfnIsMyClip ( hwnd, atomLst2 ) ) {
                   
                  WinEnableMenuItem ( hwndMenu, MID_LIST_PASTE, TRUE );
                   
                  }
                  else {
                   
                  WinEnableMenuItem ( hwndMenu, MID_LIST_PASTE, FALSE );
                   
               }
                
               pLst2Foc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               if (  pLst2Foc ) {
                   
                  WinEnableMenuItem ( hwndMenu, MID_LIST_CUT,  TRUE );
                  WinEnableMenuItem ( hwndMenu, MID_LIST_COPY, TRUE );
                  WinEnableMenuItem ( hwndMenu, MID_LIST_DELT, TRUE );
                  WinEnableMenuItem ( hwndMenu, MID_LIST_COL1, TRUE );
                  WinEnableMenuItem ( hwndMenu, MID_LIST_COL2, TRUE );
                   
                  }
                  else {
                   
                  WinEnableMenuItem ( hwndMenu, MID_LIST_CUT,  FALSE );
                  WinEnableMenuItem ( hwndMenu, MID_LIST_COPY, FALSE );
                  WinEnableMenuItem ( hwndMenu, MID_LIST_DELT, FALSE );
                  WinEnableMenuItem ( hwndMenu, MID_LIST_COL1, FALSE );
                  WinEnableMenuItem ( hwndMenu, MID_LIST_COL2, FALSE );
                   
               }
                
            break;
             
         }
          
      break;
       
      case WM_COMMAND:
          
         if ( pRecScn->pdr->fbEditing ) {
             
            WinSendMsg ( pRecScn->pdr->hwndE, CM_CLOSEEDIT, NULL, NULL );
             
         }
          
         switch ( SHORT1FROMMP ( mp1 ) ) {
             
            case MID_LIST_SAVE:
                
               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
                
            break;
             
            case MID_LIST_COPY: case MID_LIST_CUT:
                
               pLst2Foc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               /* Alloc & Init Mem */
                
               ulSize  = strlen ( pLst2Foc->psz1 ) + 1;
               ulSize += strlen ( pLst2Foc->psz2 ) + 1;
                
               ulSize += sizeof ( CDATE );
                
               DosAllocSharedMem ( &pvClip, NULL, ulSize, PAG_WRITE | PAG_COMMIT | OBJ_GIVEABLE | OBJ_GETTABLE );
                
               DosGetSharedMem ( pvClip, PAG_WRITE );
                
               pbScn = pvClip;
                
               strcpy ( pbScn, pLst2Foc->psz1 );
               pbScn  += strlen ( pLst2Foc->psz1 ) + 1;
                
               strcpy ( pbScn, pLst2Foc->psz2 );
               pbScn  += strlen ( pLst2Foc->psz2 ) + 1;
                
               memcpy ( pbScn, &pLst2Foc->cdCur, sizeof ( CDATE ) );
               pbScn  += sizeof ( CDATE );
                
                
               /* Clipboard it */
                
               WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                
               WinSetClipbrdData ( WinQueryAnchorBlock ( hwnd ), (ULONG) pvClip, atomLst2, CFI_POINTER );
                
               WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                
                
                
               if ( SHORT1FROMMP ( mp1 ) == MID_LIST_CUT ) {
                   
                  WinSendMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( MID_LIST_DELT, 0 ), NULL );
                   
               }
                
            break;
             
            case MID_LIST_PASTE:
                
               if ( pfnIsMyClip ( hwnd, atomLst2 ) ) {
                   
                  WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                   
                  pvClip = (PVOID)WinQueryClipbrdData ( WinQueryAnchorBlock ( hwnd ), atomLst2 );
                   
                  pbScn = pvClip;
                   
                  /* Allocate & Init Rec */
                   
                  pLst2Foc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                          MPFROMLONG ( CMA_FIRST ),
                                          MPFROMSHORT( CRA_SELECTED ) );
                   
                  pLst2New = WinSendMsg ( pRecScn->pdr->hwndE, CM_ALLOCRECORD,
                                          MPFROMLONG (sizeof(LST2REC)-sizeof(RECORDCORE)),
                                          MPFROMSHORT( 1 ) );
                   
                  /* Init Record */
                   
                  pLst2New->psz1 = malloc ( strlen ( pbScn ) + 1 );
                  strcpy ( pLst2New->psz1, pbScn );
                  pbScn  += strlen ( pLst2New->psz1 ) + 1;
                   
                  pLst2New->psz2 = malloc ( strlen ( pbScn ) + 1 );
                  strcpy ( pLst2New->psz2, pbScn );
                  pbScn  += strlen ( pLst2New->psz2 ) + 1;
                   
                  memcpy ( &pLst2New->cdCur, pbScn, sizeof ( CDATE ) );
                  pbScn  += sizeof ( CDATE );
                   
                   
                   
                  /* Insert */
                   
                  recins.cb                = sizeof ( RECORDINSERT );
                  recins.pRecordParent     = NULL;
                   
                  if ( pLst2Foc ) {
                      
                     recins.pRecordOrder = (PRECORDCORE) pLst2Foc;
                      
                     }
                     else {
                      
                     recins.pRecordOrder = (PRECORDCORE) CMA_END;
                      
                  }
                   
                  recins.zOrder            = CMA_TOP;
                  recins.cRecordsInsert    = 1;
                  recins.fInvalidateRecord = TRUE;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                               MPFROMP( pLst2New ), MPFROMP ( &recins ) );
                   
                  pRecScn->pdr->fbModified = TRUE;
                  fbModified = TRUE;
                   
                  ++pRecScn->pdr->ulDEnt;
                   
                  pfnListStat ( pRecScn );
                   
                   
                   
                   
                  WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                   
               }
                
            break;
             
            case MID_LIST_ADD:
                
               /* Allocate & Init Rec */
                
               pLst2Foc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               pLst2New = WinSendMsg ( pRecScn->pdr->hwndE, CM_ALLOCRECORD,
                                       MPFROMLONG (sizeof(LST2REC)-sizeof(RECORDCORE)),
                                       MPFROMSHORT( 1 ) );
                
               /* Init Record */
                
               pLst2New->psz1 = malloc ( 1 );
               pLst2New->psz2 = malloc ( 1 );
                
               *pLst2New->psz1 = 0;
               *pLst2New->psz2 = 0;
                
               pfnSetWhen ( &pLst2New->cdCur, NULL );
                
                
               /* Insert */
                
               recins.cb                = sizeof ( RECORDINSERT );
               recins.pRecordParent     = NULL;
                
               if ( pLst2Foc ) {
                   
                  recins.pRecordOrder = (PRECORDCORE) pLst2Foc;
                   
                  }
                  else {
                   
                  recins.pRecordOrder = (PRECORDCORE) CMA_END;
                   
               }
                
               recins.zOrder            = CMA_TOP;
               recins.cRecordsInsert    = 1;
               recins.fInvalidateRecord = TRUE;
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                            MPFROMP( pLst2New ), MPFROMP ( &recins ) );
                
               pRecScn->pdr->fbModified = TRUE;
               fbModified = TRUE;
                
               ++pRecScn->pdr->ulDEnt;
                
               pfnListStat ( pRecScn );
                
                
                
                
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                            MPFROMP ( pLst2New ),
                            MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                
               WinPostMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( MID_LIST_COL1, 0 ), NULL );
                
            break;
             
            case MID_LIST_DELT:
                
               pLst2Foc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_REMOVERECORD,
                            MPFROMP ( &pLst2Foc ),
                            MPFROM2SHORT( 1, CMA_FREE | CMA_INVALIDATE ) );
                
               pRecScn->pdr->fbModified = TRUE;
                
               fbModified = TRUE;
                
               --pRecScn->pdr->ulDEnt;
                
               pfnListStat ( pRecScn );
                
            break;
             
            case MID_LIST_SORT_C1: case MID_LIST_SORT_C2:
                
               ulOff = SHORT1FROMMP ( mp1 );
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_SORTRECORD,
                            MPFROMP ( pfnLst2Sort ),
                            MPFROMP ( &ulOff ) );
                
               pRecScn->pdr->fbModified = TRUE;
               fbModified = TRUE;
                
            break;
             
            case MID_LIST_FONT:
            {
               HPS       hps = WinGetPS ( pRecScn->pdr->hwndE );
               /*PDATREC */  pdr = pRecScn->pdr;
      
               if ( pfnGetFont ( hwnd, hps, NULLHANDLE, &pdr->fxPtSz, &pdr->fat ) )
               {
                  pfnSetPPFont ( pdr->hwndE, pdr->fxPtSz, &pdr->fat );
               }
      
               WinReleasePS ( hps );
            }
            break;
             
            case MID_LIST_COL1: case MID_LIST_COL2:
                
               if ( ! pRecScn->pdr->fbEditing ) {
                   
                  pLst2Foc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                          MPFROMLONG ( CMA_FIRST ),
                                          MPFROMSHORT( CRA_SELECTED ) );
                   
                  cnrEdt.cb         = sizeof ( CNREDITDATA );
                  cnrEdt.hwndCnr    = pRecScn->pdr->hwndE;
                  cnrEdt.pRecord    = (PRECORDCORE) pLst2Foc;
                   
                  if ( SHORT1FROMMP ( mp1 ) == MID_LIST_COL1 ) {
                      
                     cnrEdt.pFieldInfo = pRecScn->pdr->pfi;
                      
                     cnrEdt.id = CID_LEFTDVWND;
                     }
                     else {
                      
                     cnrEdt.pFieldInfo =
                             WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                          MPFROMP ( pRecScn->pdr->pfi ),
                                          MPFROMSHORT( CMA_NEXT ) );
                      
                     cnrEdt.id = CID_RIGHTDVWND;
                  }
                   
                  cnrEdt.ppszText   = NULL;
                  cnrEdt.cbText     = 0;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_OPENEDIT,
                               MPFROMP ( &cnrEdt ), NULL );
                   
               }
                
            break;
             
         }
          
      break;
       
      case WM_CONTROL:
          
         switch ( SHORT1FROMMP ( mp1 ) ) {
             
            case WID_CONT:
                
               switch ( SHORT2FROMMP ( mp1 ) ) {
                   
                  case CN_BEGINEDIT:
                      
                     pRecScn->pdr->fbEditing = TRUE;
                      
                     pcnrEdt = PVOIDFROMMP ( mp2 );
                      
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                                  MPFROMP ( pcnrEdt->pRecord ),
                                  MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                      
                     //pRecScn->pdr->pfi = pcnrEdt->pFieldInfo;
                      
                  return ( MRESULT ) TRUE;
                   
                  case CN_ENDEDIT:
                      
                     pRecScn->pdr->fbEditing = FALSE;
                      
                  return ( MRESULT ) TRUE;
                   
                  case CN_CONTEXTMENU:
                      
                     pLst2New = PVOIDFROMMP ( mp2 );
                      
                     hwndMenu = WinLoadMenu ( hwnd, 0, WID_LIST );
                      
                     if ( ! pLst2New ) {
                         
                        WinEnableMenuItem ( hwndMenu, MID_LIST_DELT, FALSE );
                         
                     }
                     else {
                         
                        WinEnableMenuItem ( hwndMenu, MID_LIST_DELT, TRUE );
                         
                        WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                                     MPFROMP ( pLst2New ),
                                     MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                     }
                      
                     WinQueryPointerPos ( HWND_DESKTOP, &ptl );
                      
                     WinMapWindowPoints ( HWND_DESKTOP, hwnd, &ptl, 1 );
                      
                     WinPopupMenu ( pRecScn->pdr->hwndE, hwnd, hwndMenu,
                                    (SHORT)ptl.x, (SHORT)ptl.y,
                                    0,
                                    PU_HCONSTRAIN | PU_VCONSTRAIN |
                                    PU_MOUSEBUTTON1 | PU_MOUSEBUTTON2 | PU_KEYBOARD );
                      
                      
                  return ( MRESULT ) TRUE;
                   
                  case CN_REALLOCPSZ:
                      
                     pcnrEdt = PVOIDFROMMP ( mp2 );
                      
                     pLst2New = (PLST2REC) pcnrEdt->pRecord;
                      
                     ulOff = pcnrEdt->pFieldInfo->offStruct;
                      
                     if ( ! pLst2New ) {
                         
                        *pcnrEdt->ppszText = realloc ( *pcnrEdt->ppszText, pcnrEdt->cbText );
                        //pcnrEdt->pFieldInfo->pTitleData = realloc ( pcnrEdt->pFieldInfo->pTitleData, pcnrEdt->cbText );
                         
                     }
                      
                     else {
                         
                        if ( ulOff == FIELDOFFSET ( LST2REC, psz1 ) ) {
                            
                           pLst2New->psz1 = realloc ( pLst2New->psz1, pcnrEdt->cbText );
                            
                        }
                        else if ( ulOff == FIELDOFFSET ( LST2REC, psz2 ) ) {
                            
                           pLst2New->psz2 = realloc ( pLst2New->psz2, pcnrEdt->cbText );
                            
                        }
                        else {
                            
                           return (MRESULT) FALSE;
                            
                        }
                         
                        pfnSetWhen ( &pLst2New->cdCur, NULL );
                         
                     }
                      
                     pRecScn->pdr->fbModified = TRUE;
                     fbModified = TRUE;
                      
                  return ( MRESULT ) TRUE;
                   
                  case CN_HELP:
                      
                     WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                                  MPFROMSHORT ( HID_LIST ), MPFROMSHORT ( HM_RESOURCEID ) );
                      
                  break;
                   
               }
                
            break;
             
         }
          
      break;
       
      case UWM_SAVE:
          
         pdr = pRecScn->pdr;
          
         pdr->ulDLen = pfnNodeScan  ( pdr->hwndE, SCB_SIZE, WID_LIST, pdr->pvDat );
          
         /* Get Column Titles */
          
         pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                              MPFROMP ( NULL ),
                              MPFROM2SHORT ( CMA_FIRST, CMA_ITEMORDER ) );
          
         pszCol = pfinf->pTitleData;
         ulLen = strlen ( pszCol ) + 1;
         pdr->ulDLen += ulLen;
          
         pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                              MPFROMP ( pfinf ),
                              MPFROM2SHORT ( CMA_NEXT, CMA_ITEMORDER ) );
          
         pszCol = pfinf->pTitleData;
         ulLen = strlen ( pszCol ) + 1;
         pdr->ulDLen += ulLen;
          
         pdr->pvDat = realloc ( pdr->pvDat, pdr->ulDLen );
          
         pbDat = pdr->pvDat;
          
         pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                              MPFROMP ( NULL ),
                              MPFROM2SHORT ( CMA_FIRST, CMA_ITEMORDER ) );
          
         pszCol = pfinf->pTitleData;
         ulLen = strlen ( pszCol ) + 1;
         memcpy ( pbDat, pszCol, ulLen );
         pbDat += ulLen;
          
         pfinf = WinSendMsg ( pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                              MPFROMP ( pfinf ),
                              MPFROM2SHORT ( CMA_NEXT, CMA_ITEMORDER ) );
          
         pszCol = pfinf->pTitleData;
         ulLen = strlen ( pszCol ) + 1;
         memcpy ( pbDat, pszCol, ulLen );
         pbDat += ulLen;
          
          
         pdr->ulDEnt = pfnNodeScan  ( pdr->hwndE, SCB_WRITE, WID_LIST, pbDat );
          
         pdr->fbModified = FALSE;
          
         /* Set Completion States */
          
         pfnSetWhen ( &pRecScn->cdWri, &pRecScn->ctWri );
          
         pfnGetWinPos ( hwnd, pdr );
          
         WinSendMsg ( pdr->hwndE, CM_QUERYCNRINFO,
                      MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
          
         pdr->ulXVS = cnrinf.xVertSplitbar;
          
         fbModified = TRUE;
          
          
      break;
       
      case WM_CLOSE:
          
         pdr = pRecScn->pdr;
          
         if ( pdr->fbModified ) {
             
            usResp = WinMessageBox ( HWND_DESKTOP, hwnd,
                                     "This entry has been modified. Save changes ?",
                                     "PM Scrapbook", 0, MB_YESNO | MB_ICONQUESTION );
             
            if ( usResp == MBID_YES ) {
                
               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
                
            }
             
         }
          
         pdr->ulOpts &= ~SCB_OPENED;
          
         pdr->hwndD   = 0;
          
         free ( pdr->pszStat );
          
         WinSendMsg ( hwndC, CM_SETRECORDEMPHASIS,
                      MPFROMP ( pRecScn ),
                      MPFROM2SHORT ( FALSE, CRA_INUSE ) );
          
         WinDestroyWindow ( WinQueryWindow ( hwnd, QW_PARENT ) );
          
      break;
       
      case WM_ERASEBACKGROUND:
          
      return ( MRESULT ) ( TRUE );
       
      default:
      return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
       
   }
    
   return ( MRESULT ) FALSE;
    
}
 
SHORT   APIENTRY pfnLst2Sort  ( PRECORDCORE pRec1, PRECORDCORE pRec2, PVOID pv ) {
    
   /* Local Vars */
    
   PULONG pulTyp;
    
   SHORT  sRet;
    
   /* Container Stuff */
    
   PLST2REC  pLst21;
   PLST2REC  pLst22;
    
    
    
   pLst21 = (PLST2REC) pRec1;
   pLst22 = (PLST2REC) pRec2;
    
   pulTyp = (PULONG) pv;
    
   if ( *pulTyp == MID_LIST_SORT_C1 ) {
       
      sRet = strcmp ( pLst21->psz1, pLst22->psz1 );
       
      }
      else {
       
      sRet = strcmp ( pLst21->psz2, pLst22->psz2 );
       
   }
    
   return sRet;
    
}
 
BOOL             pfnListStat  ( PUSEREC pRecScn ) {
    
   /* Local Vars */
    
   CNRINFO               cnrinf;
    
    
   sprintf ( pRecScn->pdr->pszStat, "%d entires", pRecScn->pdr->ulDEnt );
    
   cnrinf.pszCnrTitle  = pRecScn->pdr->pszStat;
    
   WinSendMsg ( pRecScn->pdr->hwndE, CM_SETCNRINFO, &cnrinf,
                MPFROMLONG ( CMA_CNRTITLE ) );
    
   return TRUE;
    
}
 
