 
#define VAR_SCOPE extern
 
#include "fsp.h"
 
//*** Prototypes ************************************************************ */

MRESULT EXPENTRY pfndpAddrAdd    ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpAddrDial   ( HWND, ULONG, MPARAM, MPARAM );
BOOL             pfnAddrStat     ( PUSEREC );
VOID             pfnAddrCont     ( HWND, PUSEREC );
VOID             pfnAddrMenu     ( PUSEREC, HWND, SHORT );
VOID             pfnAddrNewPage  ( BOOL );
VOID             pfnAddrPrintInit( VOID );
SHORT   APIENTRY pfnAddrSort     ( PRECORDCORE, PRECORDCORE, PVOID );
VOID             pfnAddrPrtThd   ( PVOID );
VOID             pfnDialerThread ( PVOID );
 
//*** Globals *************************************************************** */

HWND   hwndDialDlg;

/***************************************************************************/
/* Address Window Proc                                                     */
/***************************************************************************/
MRESULT EXPENTRY pfnwpAddrWin ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   //CHAR    ach24[25];
   //PUSEREC               pRecScn;
    
   PUSEREC   pRecScn = WinQueryWindowPtr ( hwnd, 0 );
    
   switch ( msg ) 
   {
      case WM_CREATE:
      break;
       
      /*case WM_ACTIVATE:
          
         if ( SHORT1FROMMP ( mp1 ) ) 
         {
            hwndFoc = HWNDFROMMP ( mp2 );
             
            WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                         MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                         MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
         }
         else 
         {
            hwndFoc = HWNDFROMMP ( mp2 );
             
            WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                         NULL, NULL );
         }
          
      break;*/
       
      case WM_SIZE:
          
         if ( pRecScn )
            WinSetWindowPos ( pRecScn->pdr->hwndE, 0, 0, 0,
                              SHORT1FROMMP ( mp2 ),
                              SHORT2FROMMP ( mp2 ),
                              SWP_SHOW | SWP_SIZE | SWP_MOVE );
      break;
       
      case UWM_SETRECPTR: //*** Store Data Pointer **************************
      {
         pRecScn = PVOIDFROMMP ( mp1 );
          
         WinSetWindowPtr ( hwnd, 0, pRecScn );
      }
      break;

      case UWM_PARAMS:
      {
         ULONG             ulOff;
         PBYTE             pbDat;
         ULONG             ulLen;
         PADDRREC          pAddrNew;
         PDATREC           pdr;
         RECORDINSERT      recins;
         HWND              hwndMenu;
          
         //*** Store Data Pointer *******************************************
          
         pRecScn = PVOIDFROMMP ( mp1 );
          
         WinSetWindowPtr ( hwnd, 0, pRecScn );
          
         //*** Frame ********************************************************
          
         pfnSetWinPos ( hwnd, pRecScn->pdr );
          
         pRecScn->pdr->hwndM = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU );
          
         pRecScn->pdr->pszStat = malloc ( 80 );
          
         if ( ! pRecScn->pdr->ulStyl )
            pRecScn->pdr->ulStyl = ADDR_STY_SHOWNAME | ADDR_STY_SHOWAREA |
                                   ADDR_STY_SHOWFONE | ADDR_STY_SHOWEXTN |
                                   ADDR_STY_SHOWADDR | ADDR_STY_SHOWNOTE |
                                   ADDR_STY_SHOWDATE;

         pfnAddrCont  ( hwnd, pRecScn );
         
         hwndMenu = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU);

         if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWNAME )
            WinCheckMenuItem ( hwndMenu, MID_ADDR_SHOWNAME, TRUE );

         if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWAREA )
            WinCheckMenuItem ( hwndMenu, MID_ADDR_SHOWAREA, TRUE );

         if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWFONE )
            WinCheckMenuItem ( hwndMenu, MID_ADDR_SHOWFONE, TRUE );

         if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWEXTN )
            WinCheckMenuItem ( hwndMenu, MID_ADDR_SHOWEXTN, TRUE );

         if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWADDR )
            WinCheckMenuItem ( hwndMenu, MID_ADDR_SHOWADDR, TRUE );

         if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWNOTE )
            WinCheckMenuItem ( hwndMenu, MID_ADDR_SHOWNOTE, TRUE );

         if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWDATE )
            WinCheckMenuItem ( hwndMenu, MID_ADDR_SHOWDATE, TRUE );

         //*** Insert Data **************************************************
          
         pbDat = pRecScn->pdr->pvDat;
          
         pdr   = pRecScn->pdr;
          
         /* pdr->colInfo[ADDR_NAME].ulPels = 50;
            pdr->colInfo[ADDR_AREA].ulPels =  5;
            pdr->colInfo[ADDR_FONE].ulPels = 10;
            pdr->colInfo[ADDR_EXTN].ulPels =  5;
            pdr->colInfo[ADDR_ADDR].ulPels = 50;
            pdr->colInfo[ADDR_NOTE].ulPels = 40;
            pdr->colInfo[ADDR_DATE].ulPels = 10; */

         if ( pdr->ulDEnt && pdr->ulRelRev >= 114 )
            for ( ulOff = 0; ulOff < ADDR_COLS; ++ulOff )
            {
               memcpy ( &pdr->colInfo[ulOff].ulPels, pbDat, sizeof ( ULONG ) );
               pbDat += sizeof ( ULONG );
            }

         for ( ulOff = 0; ulOff < pRecScn->pdr->ulDEnt; ++ulOff )
         {
            pAddrNew = WinSendMsg ( pRecScn->pdr->hwndE, CM_ALLOCRECORD,
                                    MPFROMLONG (sizeof(ADDRREC)-sizeof(RECORDCORE)),
                                    MPFROMSHORT( 1 ) );
             
            pAddrNew->crecCore.flRecordAttr = CRA_DROPONABLE;

            //*** Init Record ***********************************************
             
            ulLen = strlen ( pbDat ) + 1;
            pAddrNew->pszFN = malloc ( ulLen );
            strcpy ( pAddrNew->pszFN, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pAddrNew->pszAC = malloc ( ulLen );
            strcpy ( pAddrNew->pszAC, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pAddrNew->pszPN = malloc ( ulLen );
            strcpy ( pAddrNew->pszPN, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pAddrNew->pszEx = malloc ( ulLen );
            strcpy ( pAddrNew->pszEx, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pAddrNew->pszAd = malloc ( ulLen );
            strcpy ( pAddrNew->pszAd, pbDat );
            pbDat += ulLen;
             
            ulLen = strlen ( pbDat ) + 1;
            pAddrNew->pszNt = malloc ( ulLen );
            strcpy ( pAddrNew->pszNt, pbDat );
            pbDat += ulLen;
             
            memcpy ( &pAddrNew->cdUpd, pbDat, sizeof ( CDATE ) );
            pbDat += sizeof ( CDATE );
             
            if ( pRecScn->pdr->ulRelRev >= 114 )
            {
               memcpy ( &pAddrNew->ulOpt, pbDat, sizeof ( ULONG ) );
               pbDat += sizeof ( ULONG );
            }
            else
               pAddrNew->ulOpt = 0;

            //*** Insert ****************************************************
             
            recins.cb                = sizeof ( RECORDINSERT );
            recins.pRecordParent     = (PRECORDCORE) NULL;
            recins.pRecordOrder      = (PRECORDCORE) CMA_END;
            recins.zOrder            = CMA_TOP;
            recins.cRecordsInsert    = 1;
            recins.fInvalidateRecord = TRUE;
             
            WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                         MPFROMP( pAddrNew ), MPFROMP ( &recins ) );
         }
          
         pRecScn->pdr->ulOpts |= SCB_OPENED;
          
         pRecScn->pdr->fbModified = FALSE;
          
         pfnAddrStat ( pRecScn );

         //*** Create & Init Search *****************************************
          
         pRecScn->pdr->psSrch = malloc ( sizeof ( SRCHREC ) );
          
         memset ( pRecScn->pdr->psSrch, 0, sizeof ( SRCHREC ) );
          
         pRecScn->pdr->psSrch->hwndE = hwnd;
          
         pRecScn->pdr->psSrch->fbIsCn = TRUE;
          
         pRecScn->pdr->psSrch->pszFnd = malloc ( 1 );

         *pRecScn->pdr->psSrch->pszFnd = 0;
      }
      break;
       
      case WM_INITMENU:
      {
         HWND       hwndMenu;

         WinSendMsg ( WinQueryHelpInstance ( hwnd ), HM_SET_ACTIVE_WINDOW,
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ),
                      MPFROMLONG ( WinQueryWindow ( hwnd, QW_PARENT ) ) );
          
         hwndMenu = WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU);
          
         pfnAddrMenu ( pRecScn, hwndMenu, SHORT1FROMMP ( mp1 ) );
      }
      break;
       
      case WM_HELP:
      {
         SHORT   sId;

         sId = WinQueryWindowUShort ( hwnd, QWS_ID );

         WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                      MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
      }
      break;
       
      case WM_COMMAND:
          
         if ( SHORT1FROMMP(mp1) != MID_ADDR_NEXT &&
              SHORT1FROMMP(mp1) != MID_ADDR_PREV &&
              SHORT1FROMMP(mp1) != MID_ADDR_STOP &&
              pRecScn->pdr->fbEditing ) {
             
            WinSendMsg ( pRecScn->pdr->hwndE, CM_CLOSEEDIT, NULL, NULL );
             
         }
          
         switch ( SHORT1FROMMP ( mp1 ) ) 
         {
            case MID_ADDR_SAVE:
                
               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
                
            break;
             
            case MID_ADDR_EXIT:

               WinPostMsg ( WinQueryWindow(hwnd,QW_PARENT), WM_SYSCOMMAND, MPFROM2SHORT ( SC_CLOSE, 0 ), NULL );

            break;
             
            case MID_ADDR_SAVE_EXIT:

               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
               WinPostMsg ( WinQueryWindow(hwnd,QW_PARENT), WM_SYSCOMMAND, MPFROM2SHORT ( SC_CLOSE, 0 ), NULL );

            break;
             
            case MID_ADDR_FIND:
                
               WinLoadDlg ( HWND_DESKTOP, hwnd, pfndpSearch, 0L, DLG_SEARCH, 
                            pRecScn->pdr->psSrch );
                
            break;
             
            case MID_ADDR_FNDNXT:
                
               WinPostMsg ( hwnd, UWM_SEARCH, NULL, NULL );
                
            break;
             
            case MID_ADDR_COPY: case MID_ADDR_CUT:
            {
               PVOID      pvClip;
               ULONG      ulSize;
               PBYTE      pbScn;
               PADDRREC   pAddrFoc;

               pAddrFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               //*** Alloc & Init Mem ***************************************
                
               ulSize  = strlen ( pAddrFoc->pszFN ) + 1;
               ulSize += strlen ( pAddrFoc->pszAC ) + 1;
               ulSize += strlen ( pAddrFoc->pszPN ) + 1;
               ulSize += strlen ( pAddrFoc->pszEx ) + 1;
               ulSize += strlen ( pAddrFoc->pszAd ) + 1;
               ulSize += strlen ( pAddrFoc->pszNt ) + 1;
                
               ulSize += sizeof ( CDATE );
               ulSize += sizeof ( ULONG );
                
               DosAllocSharedMem ( &pvClip, NULL, ulSize, PAG_WRITE | PAG_COMMIT | OBJ_GIVEABLE | OBJ_GETTABLE );
                
               DosGetSharedMem ( pvClip, PAG_WRITE );
                
               pbScn = pvClip;
                
               strcpy ( pbScn, pAddrFoc->pszFN );
               pbScn  += strlen ( pAddrFoc->pszFN ) + 1;
                
               strcpy ( pbScn, pAddrFoc->pszAC );
               pbScn  += strlen ( pAddrFoc->pszAC ) + 1;
                
               strcpy ( pbScn, pAddrFoc->pszPN );
               pbScn  += strlen ( pAddrFoc->pszPN ) + 1;
                
               strcpy ( pbScn, pAddrFoc->pszEx );
               pbScn  += strlen ( pAddrFoc->pszEx ) + 1;
                
               strcpy ( pbScn, pAddrFoc->pszAd );
               pbScn  += strlen ( pAddrFoc->pszAd ) + 1;
                
               strcpy ( pbScn, pAddrFoc->pszNt );
               pbScn  += strlen ( pAddrFoc->pszNt ) + 1;
                
               memcpy ( pbScn, &pAddrFoc->cdUpd, sizeof ( CDATE ) );
               pbScn  += sizeof ( CDATE );
                
               memcpy ( pbScn, &pAddrFoc->ulOpt, sizeof ( ULONG ) );
               pbScn  += sizeof ( ULONG );
                
               //*** Clipboard it *******************************************
                
               WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                
               WinSetClipbrdData ( WinQueryAnchorBlock ( hwnd ), (ULONG) pvClip, atomAddr, CFI_POINTER );
                
               WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                
               if ( SHORT1FROMMP ( mp1 ) == MID_ADDR_CUT )
                  WinSendMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( MID_ADDR_DELT, 0 ), NULL );
            }
            break;
             
            case MID_ADDR_PASTE:
            {
               PVOID             pvClip;
               PBYTE             pbScn;
               PADDRREC          pAddrNew;
               PADDRREC          pAddrFoc;
               RECORDINSERT      recins;

               if ( pfnIsMyClip ( hwnd, atomAddr ) ) 
               {
                  WinOpenClipbrd ( WinQueryAnchorBlock ( hwnd ) );
                   
                  pvClip = (PVOID)WinQueryClipbrdData ( WinQueryAnchorBlock ( hwnd ), atomAddr );
                   
                  pbScn = pvClip;
                   
                  //*** Allocate & Init Rec *********************************
                   
                  pAddrFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                          MPFROMLONG ( CMA_FIRST ),
                                          MPFROMSHORT( CRA_SELECTED ) );
                   
                  pAddrNew = WinSendMsg ( pRecScn->pdr->hwndE, CM_ALLOCRECORD,
                                          MPFROMLONG (sizeof(ADDRREC)-sizeof(RECORDCORE)),
                                          MPFROMSHORT( 1 ) );
                   
                  pAddrNew->crecCore.flRecordAttr = CRA_DROPONABLE;
                   
                  //*** Init Record *****************************************
                   
                  pAddrNew->pszFN = malloc ( strlen ( pbScn ) + 1 );
                  strcpy ( pAddrNew->pszFN, pbScn );
                  pbScn  += strlen ( pAddrNew->pszFN ) + 1;
                   
                  pAddrNew->pszAC = malloc ( strlen ( pbScn ) + 1 );
                  strcpy ( pAddrNew->pszAC, pbScn );
                  pbScn  += strlen ( pAddrNew->pszAC ) + 1;
                   
                  pAddrNew->pszPN = malloc ( strlen ( pbScn ) + 1 );
                  strcpy ( pAddrNew->pszPN, pbScn );
                  pbScn  += strlen ( pAddrNew->pszPN ) + 1;
                   
                  pAddrNew->pszEx = malloc ( strlen ( pbScn ) + 1 );
                  strcpy ( pAddrNew->pszEx, pbScn );
                  pbScn  += strlen ( pAddrNew->pszEx ) + 1;
                   
                  pAddrNew->pszAd = malloc ( strlen ( pbScn ) + 1 );
                  strcpy ( pAddrNew->pszAd, pbScn );
                  pbScn  += strlen ( pAddrNew->pszAd ) + 1;
                   
                  pAddrNew->pszNt = malloc ( strlen ( pbScn ) + 1 );
                  strcpy ( pAddrNew->pszNt, pbScn );
                  pbScn  += strlen ( pAddrNew->pszNt ) + 1;
                   
                  memcpy ( &pAddrNew->cdUpd, pbScn, sizeof ( CDATE ) );
                  pbScn  += sizeof ( CDATE );
                   
                  memcpy ( &pAddrNew->ulOpt, pbScn, sizeof ( ULONG ) );
                  pbScn  += sizeof ( ULONG );
                   
                  //*** Insert **********************************************
                   
                  recins.cb                = sizeof ( RECORDINSERT );
                  recins.pRecordParent     = NULL;
                   
                  if ( pAddrFoc ) 
                     recins.pRecordOrder = (PRECORDCORE) pAddrFoc;
                  else
                     recins.pRecordOrder = (PRECORDCORE) CMA_END;
                   
                  recins.zOrder            = CMA_TOP;
                  recins.cRecordsInsert    = 1;
                  recins.fInvalidateRecord = TRUE;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                               MPFROMP( pAddrNew ), MPFROMP ( &recins ) );
                   
                  pRecScn->pdr->fbModified = TRUE;
                  //fbModified = TRUE;
                   
                  ++pRecScn->pdr->ulDEnt;
                   
                  pfnAddrStat ( pRecScn );
                   
                  WinCloseClipbrd ( WinQueryAnchorBlock ( hwnd ) );
               }
            }
            break;
             
            case MID_ADDR_ADD:
            {
               PADDRREC          pAddrNew;
               PADDRREC          pAddrFoc;
               RECORDINSERT      recins;

               //*** Allocate & Init Rec ************************************
                
               pAddrFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               pAddrNew = WinSendMsg ( pRecScn->pdr->hwndE, CM_ALLOCRECORD,
                                       MPFROMLONG (sizeof(ADDRREC)-sizeof(RECORDCORE)),
                                       MPFROMSHORT( 1 ) );
                
               pAddrNew->crecCore.flRecordAttr = CRA_DROPONABLE;
                
               //*** Init Record ********************************************
                
               pAddrNew->pszFN = malloc ( 1 );
               pAddrNew->pszAC = malloc ( 1 );
               pAddrNew->pszPN = malloc ( 1 );
               pAddrNew->pszEx = malloc ( 1 );
               pAddrNew->pszAd = malloc ( 1 );
               pAddrNew->pszNt = malloc ( 1 );
                
               *pAddrNew->pszFN = 0;
               *pAddrNew->pszAC = 0;
               *pAddrNew->pszPN = 0;
               *pAddrNew->pszEx = 0;
               *pAddrNew->pszAd = 0;
               *pAddrNew->pszNt = 0;
                
               pfnSetWhen ( &pAddrNew->cdUpd, NULL );

               pAddrNew->ulOpt = 0;

               //*** Insert *************************************************
                
               recins.cb                = sizeof ( RECORDINSERT );
               recins.pRecordParent     = NULL;
                
               if ( pAddrFoc ) 
                  recins.pRecordOrder = (PRECORDCORE) pAddrFoc;
               else
                  recins.pRecordOrder = (PRECORDCORE) CMA_END;
                
               recins.zOrder            = CMA_TOP;
               recins.cRecordsInsert    = 1;
               recins.fInvalidateRecord = TRUE;
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                            MPFROMP( pAddrNew ), MPFROMP ( &recins ) );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
               ++pRecScn->pdr->ulDEnt;
                
               pfnAddrStat ( pRecScn );
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                            MPFROMP ( pAddrNew ),
                            MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                
               //WinPostMsg ( hwnd, WM_COMMAND, MPFROM2SHORT ( MID_ADDR_BEGN, 0 ), NULL );
                
               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpAddrAdd, 0L, DLG_ADDR_ADD, pAddrNew );
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );
            }
            break;
             
            case MID_ADDR_DELT:
            {
               PADDRREC   pAddrFoc;

               pAddrFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_REMOVERECORD,
                            MPFROMP ( &pAddrFoc ),
                            MPFROM2SHORT( 1, CMA_FREE | CMA_INVALIDATE ) );
                
               pRecScn->pdr->fbModified = TRUE;
                
               //fbModified = TRUE;
                
               --pRecScn->pdr->ulDEnt;
                
               pfnAddrStat ( pRecScn );
            }
            break;
             
            case MID_ADDR_DIAL:
            {
               PADDRREC          pAddrFoc;

               //*** Set Globals ********************************************
                
               pAddrFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               if ( pAddrFoc )
                  WinLoadDlg ( HWND_DESKTOP, hwnd, pfndpAddrDial, 0L, 
                               DLG_ADDR_DIAL, pAddrFoc );
            }
            break;
             
            case MID_ADDR_SORT:
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_SORTRECORD,
                            MPFROMP ( pfnAddrSort ),
                            MPFROMP ( NULL ) );
                
               pRecScn->pdr->fbModified = TRUE;
               //fbModified = TRUE;
                
            break;
             
            case MID_ADDR_FONT:
            {
               PDATREC   pdr = pRecScn->pdr;
               HPS       hps = WinGetPS ( pdr->hwndE );
      
               if ( pfnGetFont ( hwnd, hps, NULLHANDLE, &pdr->fxPtSz, &pdr->fat ) )
               {
                  pfnSetPPFont ( pdr->hwndE, pdr->fxPtSz, &pdr->fat );
               }
      
               WinReleasePS ( hps );
            }
            break;
             
            case MID_ADDR_COLOR:
            {
               PDATREC           pdr;

               pdr = pRecScn->pdr;
                
               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpColors, 0L, DLG_COLORS, &pdr->hwndE );
            }
            break;
             
            case MID_ADDR_TITLE:
            {
               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpSetTitle, 0L, DLG_SET_TITLE, pRecScn );
            }
            break;
             
            case MID_ADDR_PRINT:
            {
               pRecPrt = pRecScn;

               WinDlgBox ( HWND_DESKTOP, hwnd, pfndpPrint,  0L,
                           DLG_PRINT, (PVOID) pfnAddrPrtThd );
            }
            break;
             
            case MID_ADDR_BEGN:
            {
               PADDRREC      pAddrFoc;
               CNREDITDATA   cnrEdt;

               pAddrFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                       MPFROMLONG ( CMA_FIRST ),
                                       MPFROMSHORT( CRA_SELECTED ) );
                
               if ( ! pAddrFoc || pRecScn->pdr->fbEditing ) {
                   
                  break;//WinSendMsg ( hwndC, CM_CLOSEEDIT, NULL, NULL );
                   
               }
               //else {
                   
                  pRecScn->pdr->pfi =
                          WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                       MPFROMP ( pRecScn->pdr->pfi ),
                                       MPFROMSHORT( CMA_FIRST ) );
                   
                  cnrEdt.cb         = sizeof ( CNREDITDATA );
                  cnrEdt.hwndCnr    = pRecScn->pdr->hwndE;
                  cnrEdt.pRecord    = (PRECORDCORE) pAddrFoc;
                  cnrEdt.pFieldInfo = pRecScn->pdr->pfi;
                  cnrEdt.ppszText   = NULL;
                  cnrEdt.cbText     = 0;
                  cnrEdt.id         = *(PUSHORT)pRecScn->pdr->pfi->pUserData;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_OPENEDIT,
                               MPFROMP ( &cnrEdt ), NULL );
                   
                  //pRecScn->pdr->fbEditing = TRUE;
                   
               //}
            }
            break;
             
            case MID_ADDR_NEXT: case MID_ADDR_PREV:
            {
               PADDRREC      pAddrFoc;
               CNREDITDATA   cnrEdt;

               if ( pRecScn->pdr->fbEditing ) 
               {
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_CLOSEEDIT, NULL, NULL );
                   
                  pAddrFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                                          MPFROMLONG ( CMA_FIRST ),
                                          MPFROMSHORT( CRA_SELECTED ) );
                   
                  if ( SHORT1FROMMP ( mp1 ) == MID_ADDR_NEXT )
                     pRecScn->pdr->pfi =
                             WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                          MPFROMP ( pRecScn->pdr->pfi ),
                                          MPFROMSHORT( CMA_NEXT ) );
                  else
                     pRecScn->pdr->pfi =
                             WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYDETAILFIELDINFO,
                                          MPFROMP ( pRecScn->pdr->pfi ),
                                          MPFROMSHORT( CMA_PREV ) );
                   
                  if ( pRecScn->pdr->pfi && pRecScn->pdr->pfi->pUserData ) 
                  {
                     cnrEdt.cb         = sizeof ( CNREDITDATA );
                     cnrEdt.hwndCnr    = pRecScn->pdr->hwndE;
                     cnrEdt.pRecord    = (PRECORDCORE) pAddrFoc;
                     cnrEdt.pFieldInfo = pRecScn->pdr->pfi;
                     cnrEdt.ppszText   = NULL;
                     cnrEdt.cbText     = 0;
                     cnrEdt.id         = *(PUSHORT)pRecScn->pdr->pfi->pUserData;
                      
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_OPENEDIT,
                                  MPFROMP ( &cnrEdt ), NULL );
                      
                  }
                  else
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_CLOSEEDIT, NULL, NULL );
               }
            }
            break;
             
            case MID_ADDR_STOP:
                
               WinSendMsg ( pRecScn->pdr->hwndE, CM_CLOSEEDIT, NULL, NULL );
                
            break;
             
            case MID_ADDR_SHOWNAME:
                
               if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWNAME )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, ADDR_NAME, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, ADDR_NAME, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;
            case MID_ADDR_SHOWAREA:
                
               if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWAREA )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, ADDR_AREA, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, ADDR_AREA, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;
            case MID_ADDR_SHOWFONE:
                
               if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWFONE )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, ADDR_FONE, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, ADDR_FONE, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;
            case MID_ADDR_SHOWEXTN:
                
               if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWEXTN )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, ADDR_EXTN, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, ADDR_EXTN, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;
            case MID_ADDR_SHOWADDR:
                
               if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWADDR )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, ADDR_ADDR, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, ADDR_ADDR, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;
            case MID_ADDR_SHOWNOTE:
                
               if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWNOTE )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, ADDR_NOTE, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, ADDR_NOTE, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;
            case MID_ADDR_SHOWDATE:
                
               if ( pRecScn->pdr->ulStyl & ADDR_STY_SHOWDATE )
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), FALSE );

                  pfnFixCnrCols ( pRecScn, ADDR_DATE, FALSE );
               }
               else
               {
                  WinCheckMenuItem ( WinWindowFromID ( WinQueryWindow ( hwnd, QW_PARENT ), FID_MENU ),
                                     SHORT1FROMMP ( mp1 ), TRUE );

                  pfnFixCnrCols ( pRecScn, ADDR_DATE, TRUE );
               }
               pRecScn->pdr->fbModified = TRUE;
            break;

            default:
               WinPostMsg ( hwndM, msg, mp1, mp2 );
         }
          
      break;
       
      case WM_CONTROL:
          
         if ( SHORT1FROMMP ( mp1 ) == WID_CONT )
         {
            switch ( SHORT2FROMMP ( mp1 ) ) 
            {
               case CN_ENTER:   
               {
                  PADDRREC            pAddr;
                  PNOTIFYRECORDENTER  pcnrEnt;

                  if ( fbDialing )
                     break;

                  pcnrEnt = PVOIDFROMMP ( mp2 );
                   
                  pAddr = (PADDRREC) pcnrEnt->pRecord;
                   
                  if ( ! pAddr )
                     break;
                   
                  WinPostMsg ( hwnd, WM_COMMAND, 
                               MPFROM2SHORT ( MID_ADDR_DIAL, 0 ), NULL );
               }
               return ( MRESULT ) TRUE;
                
               case CN_BEGINEDIT:
               {
                  PCNREDITDATA    pcnrEdt;

                  pRecScn->pdr->fbEditing = TRUE;
                   
                  pcnrEdt = PVOIDFROMMP ( mp2 );
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                               MPFROMP ( pcnrEdt->pRecord ),
                               MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                   
                  pRecScn->pdr->pfi = pcnrEdt->pFieldInfo;
               }
               return ( MRESULT ) TRUE;
                
               case CN_ENDEDIT:
                   
                  pRecScn->pdr->fbEditing = FALSE;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );

               return ( MRESULT ) TRUE;
                
               case CN_CONTEXTMENU:
               {
                  HWND       hwndMenu;
                  POINTL     ptl;
                  PADDRREC   pAddrNew;

                  pAddrNew = PVOIDFROMMP ( mp2 );
                   
                  hwndMenu = WinLoadMenu ( hwnd, 0, WID_ADDR );
                   
                  if ( ! pAddrNew )
                     WinEnableMenuItem ( hwndMenu, MID_ADDR_DELT, FALSE );
                  else 
                  {
                     WinEnableMenuItem ( hwndMenu, MID_ADDR_DELT, TRUE );
                      
                     WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                                  MPFROMP ( pAddrNew ),
                                  MPFROM2SHORT ( TRUE, CRA_SELECTED ) );
                  }
                   
                  pfnAddrMenu ( pRecScn, hwndMenu, MID_ADDR_EDIT );

                  WinQueryPointerPos ( HWND_DESKTOP, &ptl );
                   
                  WinMapWindowPoints ( HWND_DESKTOP, hwnd, &ptl, 1 );
                   
                  WinPopupMenu ( pRecScn->pdr->hwndE, hwnd, hwndMenu,
                                 (SHORT)ptl.x, (SHORT)ptl.y,
                                 MID_ADDR_EDIT,
                                 PU_POSITIONONITEM | //PU_HCONSTRAIN | PU_VCONSTRAIN |
                                 PU_MOUSEBUTTON1 | PU_MOUSEBUTTON2 | PU_KEYBOARD );
               }
               return ( MRESULT ) TRUE;
                
               case CN_REALLOCPSZ:
               {
                  ULONG           ulOff;
                  PADDRREC        pAddrNew;
                  PCNREDITDATA    pcnrEdt;

                  pcnrEdt = PVOIDFROMMP ( mp2 );
                   
                  pAddrNew = (PADDRREC) pcnrEdt->pRecord;
                   
                  ulOff = pcnrEdt->pFieldInfo->offStruct;
                   
                  if ( ! pAddrNew )
                     return (MRESULT) FALSE;
                   
                  //*** ReAlloc String ***********************************
                   
                  if ( ulOff == FIELDOFFSET ( ADDRREC, pszFN ) ) 
                     pAddrNew->pszFN = realloc ( pAddrNew->pszFN, pcnrEdt->cbText );
                  else if ( ulOff == FIELDOFFSET ( ADDRREC, pszAC ) )
                     pAddrNew->pszAC = realloc ( pAddrNew->pszAC, pcnrEdt->cbText );
                  else if ( ulOff == FIELDOFFSET ( ADDRREC, pszPN ) )
                     pAddrNew->pszPN = realloc ( pAddrNew->pszPN, pcnrEdt->cbText );
                  else if ( ulOff == FIELDOFFSET ( ADDRREC, pszEx ) )
                     pAddrNew->pszEx = realloc ( pAddrNew->pszEx, pcnrEdt->cbText );
                  else if ( ulOff == FIELDOFFSET ( ADDRREC, pszAd ) )
                     pAddrNew->pszAd = realloc ( pAddrNew->pszAd, pcnrEdt->cbText );
                  else if ( ulOff == FIELDOFFSET ( ADDRREC, pszNt ) )
                     pAddrNew->pszNt = realloc ( pAddrNew->pszNt, pcnrEdt->cbText );
                   
                  pRecScn->pdr->fbModified = TRUE;
                  //fbModified = TRUE;
                   
                  pfnSetWhen ( &pAddrNew->cdUpd, NULL );
               }
               return ( MRESULT ) TRUE;
                
               case CN_INITDRAG:
               {
                  PADDRREC      pRecDrg;
                  PCNRDRAGINIT  pcnrDrg;
                  PDRAGINFO     pdinfo;
                  DRAGITEM      ditem;
                  DRAGIMAGE     dimage;
      
                  pcnrDrg = PVOIDFROMMP ( mp2 );
                   
                  pRecDrg = (PADDRREC) pcnrDrg->pRecord;
                   
                  if ( ! pRecDrg )
                     break;
                   
                  //*** Drag It ******************************************
                   
                  pdinfo = DrgAllocDraginfo ( 1 );
                   
                  ditem.hwndItem       = hwnd;
                  ditem.ulItemID       = (ULONG)pRecDrg;
                  ditem.hstrType       = DrgAddStrHandle ( DRT_TREE );
                  ditem.hstrRMF        = DrgAddStrHandle ( DRM_ADDR );
                  ditem.fsControl      = 0;
                  ditem.fsSupportedOps = DO_COPYABLE | DO_MOVEABLE;
                   
                  DrgSetDragitem ( pdinfo, &ditem, sizeof(ditem), 0 );
                   
                  dimage.cb       = sizeof(DRAGIMAGE);
                  dimage.cptl     = 0;
                  dimage.hImage   = hptrAddr;
                  dimage.fl       = DRG_ICON;
                  dimage.cxOffset = 0;
                  dimage.cyOffset = 0;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                               MPFROMP ( pRecDrg ),
                               MPFROM2SHORT ( TRUE, 0x00004000 ) );//CRA_CURSORED ) );
                   
                  DrgDrag ( hwnd, pdinfo, &dimage, 1, VK_ENDDRAG, NULL );
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_SETRECORDEMPHASIS,
                               MPFROMP ( pRecDrg ),
                               MPFROM2SHORT ( FALSE, 0x00004000 ) );//CRA_CURSORED ) );
                   
                  DrgFreeDraginfo ( pdinfo );
               }
               break;
                
               case CN_DRAGAFTER:
               {
                  PCNRDRAGINFO  pcnrDri;
                  PDRAGINFO     pdinfo;
                  PDRAGITEM     pditem;
      
                  pcnrDri = PVOIDFROMMP ( mp2 );
                   
                  pdinfo = pcnrDri->pDragInfo;
                   
                  DrgAccessDraginfo ( pdinfo );
                   
                  pditem = DrgQueryDragitemPtr ( pdinfo, 0 );
                   
                  if ( pditem->hwndItem != hwnd )
                  {
                     DrgFreeDraginfo ( pdinfo );

                     return ( MRFROM2SHORT ( DOR_NEVERDROP, 0 ) );
                  }
                  else if ( DrgVerifyRMF ( pditem, "DRM_PMSCRAPBOOK", "DRF_ADDR" ) )
                  { 
                     DrgFreeDraginfo ( pdinfo );
                      
                     return ( MRFROM2SHORT ( DOR_DROP, DO_MOVE ) );
                      
                  }
                  else 
                  {
                     DrgFreeDraginfo ( pdinfo );
                      
                     return ( MRFROM2SHORT ( DOR_NEVERDROP, 0 ) );
                  }
               }
                
               case CN_DROP:
               {
                  PCNRDRAGINFO  pcnrDri;
                  PDRAGINFO     pdinfo;
                  PDRAGITEM     pditem;
                  PADDRREC      pRecDrp;
                  PADDRREC      pRecAft;
                  RECORDINSERT  recins;
      
                  pcnrDri = PVOIDFROMMP ( mp2 );
                   
                  pdinfo = pcnrDri->pDragInfo;
                   
                  DrgAccessDraginfo ( pdinfo );
                   
                  pditem = DrgQueryDragitemPtr ( pdinfo, 0 );
                   
                  pRecDrp = (PADDRREC) pditem->ulItemID;
                  pRecAft = (PADDRREC) pcnrDri->pRecord;
                   
                  if ( ! pRecAft || pRecDrp == pRecAft )
                  {
                     DrgFreeDraginfo ( pdinfo );
                     break;
                  }
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_REMOVERECORD,
                               MPFROMP ( &pRecDrp ),
                               MPFROM2SHORT( 1, 0 ) );//CMA_INVALIDATE ) );
                   
                  //*** Insert *************************************************
                   
                  recins.cb                = sizeof ( RECORDINSERT );
                  recins.pRecordParent     = NULL;
                  recins.pRecordOrder      = (PRECORDCORE) pRecAft;
                  recins.zOrder            = CMA_TOP;
                  recins.cRecordsInsert    = 1;
                  recins.fInvalidateRecord = TRUE;
                   
                  WinSendMsg ( pRecScn->pdr->hwndE, CM_INSERTRECORD,
                               MPFROMP( pRecDrp ), MPFROMP ( &recins ) );
                   
                  pRecScn->pdr->fbModified = TRUE;
                  //fbModified = TRUE;
               }
               break;
                
               case CN_HELP:
                   
                  WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                               MPFROMSHORT ( HID_ADDR ), MPFROMSHORT ( HM_RESOURCEID ) );
               break;
            }
            //break;
         }
      break;
       
      case UWM_SAVE:
      {
         CNRINFO   cnrinf;
         PDATREC   pdr;

         pdr = pRecScn->pdr;

         pdr->ulRelRev = REL_REV;

         pdr->ulDLen = pfnNodeScan  ( pdr->hwndE, SCB_SIZE, WID_ADDR, pdr->pvDat );
          
         pdr->pvDat = realloc ( pdr->pvDat, pdr->ulDLen );
          
         pdr->ulDEnt = pfnNodeScan  ( pdr->hwndE, SCB_WRITE, WID_ADDR, pdr->pvDat );
          
         //*** Set Completion States ****************************************
          
         pdr->fbModified = FALSE;
          
         pfnSetWhen ( &pRecScn->cdWri, &pRecScn->ctWri );
          
         pfnGetWinPos ( hwnd, pdr );
          
         //pdr->sPtSize = pfnFmToFat ( pdr->hwndE, &pdr->fat );
         //pfnGetDefFattrs ( pdr->hwndE, NULLHANDLE, &pdr->fat, &pdr->fxPtSz );
          
         pfnGetPresColors ( pdr->hwndE, &pdr->ulNBClr, &pdr->ulNFClr, &pdr->ulHBClr, &pdr->ulHFClr );
          
         WinSendMsg ( pdr->hwndE, CM_QUERYCNRINFO,
                      MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
          
         pdr->ulXVS = cnrinf.xVertSplitbar;
          
         fbModified = TRUE;
      }
      break;
       
      case UWM_SEARCH:
      {
         PADDRREC         pFoc;
         PDATREC          pdr;
         SEARCHSTRING     cnrsd;

         pdr = pRecScn->pdr;
          
         cnrsd.cb              = sizeof ( SEARCHSTRING );
         cnrsd.pszSearch       = pdr->psSrch->pszFnd;
         cnrsd.fsPrefix        = FALSE;
         cnrsd.fsCaseSensitive = ( pdr->psSrch->fbCase ) ? TRUE : FALSE;
         cnrsd.usView          = CV_DETAIL;

         pFoc = WinSendMsg ( pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                             MPFROMLONG ( CMA_FIRST ),
                             MPFROMSHORT( CRA_SELECTED ) );
          
         if ( ! pFoc )
         {
            pfnMsgOK ( hwnd, APP_TITLE, "Text not found." );
            break;
         }

         if ( pdr->psSrch->fbFirst )
         {
            if ( pFoc == pfnGetCnrRec ( pdr->hwndE, NULL ) )
               pFoc = (PADDRREC) CMA_FIRST;
            
            pdr->psSrch->fbFirst = FALSE;
         }
         
         pFoc = WinSendMsg ( pdr->hwndE, CM_SEARCHSTRING,
                             MPFROMP ( &cnrsd ), MPFROMP ( pFoc ) );

         if ( pFoc )
         {
            pfnCnrShowRec ( pdr->hwndE, pFoc, TRUE );

            if ( pFoc != pfnGetCnrRec ( pdr->hwndE, NULL ) )
               pdr->psSrch->fbFirst = TRUE;
         }
         else
         {
            pdr->psSrch->fbFirst = TRUE;
            pfnMsgOK ( hwnd, APP_TITLE, "Text not found." );
         }
      }
      break;
       
      case WM_CLOSE:
      {
         PDATREC   pdr;

         pdr = pRecScn->pdr;
          
         if ( pdr->fbModified ) 
         {
            if (  pfnMsgYesNo ( hwnd, APP_TITLE,
                                "This entry has been modified. Save changes ?" ) )
               WinSendMsg ( hwnd, UWM_SAVE, NULL, NULL );
         }
          
         pdr->ulOpts &= ~SCB_OPENED;
          
         pdr->hwndD   = 0;
         pfnHaveAKid ( pRecScn, FALSE );
          
         WinEnableWindowUpdate ( pdr->hwndE, FALSE );

         pfnNodeScan  ( pdr->hwndE, SCB_FREE, 
                        pRecScn->ulType, pRecScn->pdr->pvDat );

         free ( pdr->psSrch->pszFnd );
         free ( pdr->psSrch );
         free ( pdr->pszStat );
          
         WinSendMsg ( hwndC, CM_SETRECORDEMPHASIS,
                      MPFROMP ( pRecScn ),
                      MPFROM2SHORT ( FALSE, CRA_INUSE ) );
          
         WinDestroyWindow ( WinQueryWindow ( hwnd, QW_PARENT ) );
      }
      break;
       
      case WM_PRESPARAMCHANGED:
          
         pRecScn->pdr->fbModified = TRUE;
         //fbModified = TRUE;
          
      break;
       
      case WM_ERASEBACKGROUND:
          
      return ( MRESULT ) ( TRUE );
       
      default:
      return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
       
   }
    
   return ( MRESULT ) FALSE;
}
 
/***************************************************************************/
/* Address Entry Dialog Proc                                               */
/***************************************************************************/
MRESULT EXPENTRY pfndpAddrAdd ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) 
{
   ULONG   ulLen;
   MRESULT mres;
   IPT     ipt;
    
   static PADDRREC pAddr;
    
   switch ( msg ) 
   {
      case WM_INITDLG:
          
         pAddr = PVOIDFROMMP ( mp2 );
          
         WinSetFocus ( HWND_DESKTOP, WinWindowFromID ( hwnd, DIT_NAME ) );
          
      return (MRESULT) TRUE;
       
      case WM_COMMAND:
          
         switch ( COMMANDMSG(&msg)->cmd ) 
         {
            case DIT_HELP:
            {
               SHORT   sId;
      
               sId = WinQueryWindowUShort ( hwnd, QWS_ID );
      
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
             
            case DIT_OK:
                
               //*** Entry Fields *******************************************
                
               ulLen = WinQueryDlgItemTextLength ( hwnd, DIT_NAME );
                
               ++ulLen;
                
               pAddr->pszFN = realloc ( pAddr->pszFN, ulLen );
                
               WinQueryDlgItemText ( hwnd, DIT_NAME, ulLen, pAddr->pszFN );
                
               ulLen = WinQueryDlgItemTextLength ( hwnd, DIT_ARCD );
                
               ++ulLen;
                
               pAddr->pszAC = realloc ( pAddr->pszAC, ulLen );
                
               WinQueryDlgItemText ( hwnd, DIT_ARCD, ulLen, pAddr->pszAC );
                
               ulLen = WinQueryDlgItemTextLength ( hwnd, DIT_PHNE );
                
               ++ulLen;
                
               pAddr->pszPN = realloc ( pAddr->pszPN, ulLen );
                
               WinQueryDlgItemText ( hwnd, DIT_PHNE, ulLen, pAddr->pszPN );
                
               ulLen = WinQueryDlgItemTextLength ( hwnd, DIT_EXTN );
                
               ++ulLen;
                
               pAddr->pszEx = realloc ( pAddr->pszEx, ulLen );
                
               WinQueryDlgItemText ( hwnd, DIT_EXTN, ulLen, pAddr->pszEx );
                
               //*** Addr ***************************************************
                
               WinSendDlgItemMsg ( hwnd, DIT_ADDR, MLM_FORMAT,
                                   MPFROMLONG ( MLFIE_NOTRANS ), NULL );
                
               mres = WinSendDlgItemMsg ( hwnd, DIT_ADDR, MLM_QUERYTEXTLENGTH, NULL, NULL );
                
               ipt = LONGFROMMR ( mres );
                
               mres = WinSendDlgItemMsg ( hwnd, DIT_ADDR, MLM_QUERYFORMATTEXTLENGTH,
                                          MPFROMLONG ( 0 ), MPFROMLONG ( ipt ) );
                
               ipt = LONGFROMMR ( mres );
                
               pAddr->pszAd = realloc ( pAddr->pszAd, ipt + 1 );
                
               //pAddr->pszAd[ipt] = 0;
                
               WinSendDlgItemMsg ( hwnd, DIT_ADDR, MLM_SETIMPORTEXPORT,
                                   MPFROMP ( pAddr->pszAd ),
                                   MPFROMLONG ( ipt ) );
                
               ulLen = ipt;
               ipt   = 0;
                
               WinSendDlgItemMsg ( hwnd, DIT_ADDR, MLM_EXPORT,
                                   MPFROMP ( &ipt ),
                                   MPFROMP ( &ulLen ) );
                
               //*** Notes **************************************************
                
               WinSendDlgItemMsg ( hwnd, DIT_NOTE, MLM_FORMAT,
                                   MPFROMLONG ( MLFIE_NOTRANS ), NULL );
                
               mres = WinSendDlgItemMsg ( hwnd, DIT_NOTE, MLM_QUERYTEXTLENGTH, NULL, NULL );
                
               ipt = LONGFROMMR ( mres );
                
               mres = WinSendDlgItemMsg ( hwnd, DIT_NOTE, MLM_QUERYFORMATTEXTLENGTH,
                                          MPFROMLONG ( 0 ), MPFROMLONG ( ipt ) );
                
               ipt = LONGFROMMR ( mres );
                
               pAddr->pszNt = realloc ( pAddr->pszNt, ipt + 1 );
                
               //pAddr->pszNt[ipt] = 0;
                
               WinSendDlgItemMsg ( hwnd, DIT_NOTE, MLM_SETIMPORTEXPORT,
                                   MPFROMP ( pAddr->pszNt ),
                                   MPFROMLONG ( ipt ) );
                
               ulLen = ipt;
               ipt   = 0;
                
               WinSendDlgItemMsg ( hwnd, DIT_NOTE, MLM_EXPORT,
                                   MPFROMP ( &ipt ),
                                   MPFROMP ( &ulLen ) );
                
               WinDismissDlg ( hwnd, TRUE );
                
            break;
         };
          
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
    
   return FALSE;
}
 
/***************************************************************************/
/* Address Sort                                                            */
/***************************************************************************/
SHORT   APIENTRY pfnAddrSort  ( PRECORDCORE pRec1, PRECORDCORE pRec2, PVOID pv ) 
{
   PADDRREC  pAddr1;
   PADDRREC  pAddr2;
    
   pAddr1 = (PADDRREC) pRec1;
   pAddr2 = (PADDRREC) pRec2;
    
   return strcmp ( pAddr1->pszFN, pAddr2->pszFN );
}
 
/***************************************************************************/
/* Address Stat                                                            */
/***************************************************************************/
BOOL             pfnAddrStat  ( PUSEREC pRecScn ) 
{
   //CNRINFO               cnrinf;
    
   sprintf ( pRecScn->pdr->pszStat, "%d entries", pRecScn->pdr->ulDEnt );
    
   pfnCnrTitle ( pRecScn->pdr->hwndE, pRecScn->pdr->pszStat );

   //cnrinf.pszCnrTitle  = pRecScn->pdr->pszStat;
    
   //WinSendMsg ( pRecScn->pdr->hwndE, CM_SETCNRINFO, &cnrinf,
     //           MPFROMLONG ( CMA_CNRTITLE ) );
    
   return TRUE;
}
 
/***************************************************************************/
/* Create Address Container                                                */
/***************************************************************************/
VOID             pfnAddrCont  ( HWND hwnd, PUSEREC pRecScn )
{
   PDATREC           pdr;
   SWP               swp;
   CNRINFO           cnrinf;
   MRESULT           mr;

   pdr = pRecScn->pdr;
    
   pdr->hwndE = WinCreateWindow ( hwnd, WC_CONTAINER, NULL,
                                  CCS_SINGLESEL,
                                  0,0,0,0, hwnd, HWND_TOP,
                                  WID_CONT, NULL, NULL );
    
   WinSetWindowPtr ( pdr->hwndE, 0, pRecScn );
    
   cnrinf.pszCnrTitle  = pdr->pszStat;
   cnrinf.flWindowAttr = CV_DETAIL | CA_DETAILSVIEWTITLES | CA_ORDEREDTARGETEMPH;
    
   if ( ulAddrOpts & SCB_STATED ) 
      cnrinf.flWindowAttr |= CA_CONTAINERTITLE | CA_TITLESEPARATOR | CA_TITLEREADONLY;
    
   WinSendMsg ( pdr->hwndE, CM_SETCNRINFO, &cnrinf,
                MPFROMLONG ( CMA_FLWINDOWATTR ) );
    
   pfnSetPPFont ( pdr->hwndE, pdr->fxPtSz, &pdr->fat );
    
   pfnSetPresColors ( pdr->hwndE, pdr->ulNBClr, pdr->ulNFClr, pdr->ulHBClr, pdr->ulHFClr );
    
   WinSendMsg ( pdr->hwndE, CM_QUERYCNRINFO,
                MPFROMP( &cnrinf ), MPFROMSHORT ( sizeof ( cnrinf ) ) );
    
   //*** Allocate & Init Field Info ***********************************
    
   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszAddrName, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_STRING | CFA_TOP | CFA_LEFT |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( ADDRREC, pszFN ) );
         
   pdr->colInfo[ADDR_NAME].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[ADDR_NAME].fbVisible        = TRUE;
   pdr->colInfo[ADDR_NAME].ulShowMask       = ADDR_STY_SHOWNAME;
   pdr->colInfo[ADDR_NAME].pfinf->pUserData = &usLeftDvWnd;

   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszAddrArea, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_STRING | CFA_TOP | CFA_LEFT |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( ADDRREC, pszAC ) );
         
   pdr->colInfo[ADDR_AREA].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[ADDR_AREA].fbVisible        = TRUE;
   pdr->colInfo[ADDR_AREA].ulShowMask       = ADDR_STY_SHOWAREA;
   pdr->colInfo[ADDR_AREA].pfinf->pUserData = &usLeftDvWnd;

   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszAddrFone, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_STRING | CFA_TOP | CFA_LEFT |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( ADDRREC, pszPN ) );
         
   pdr->colInfo[ADDR_FONE].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[ADDR_FONE].fbVisible        = TRUE;
   pdr->colInfo[ADDR_FONE].ulShowMask       = ADDR_STY_SHOWFONE;
   pdr->colInfo[ADDR_FONE].pfinf->pUserData = &usLeftDvWnd;

   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszAddrExtn, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_STRING | CFA_TOP | CFA_LEFT |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( ADDRREC, pszEx ) );
         
   pdr->colInfo[ADDR_EXTN].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[ADDR_EXTN].fbVisible        = TRUE;
   pdr->colInfo[ADDR_EXTN].ulShowMask       = ADDR_STY_SHOWEXTN;
   pdr->colInfo[ADDR_EXTN].pfinf->pUserData = &usRightDvWnd;

   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszAddrAddr, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_STRING | CFA_TOP | CFA_CENTER |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( ADDRREC, pszAd ) );
         
   pdr->colInfo[ADDR_ADDR].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[ADDR_ADDR].fbVisible        = TRUE;
   pdr->colInfo[ADDR_ADDR].ulShowMask       = ADDR_STY_SHOWADDR;
   pdr->colInfo[ADDR_ADDR].pfinf->pUserData = &usRightDvWnd;

   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszAddrNote, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_STRING | CFA_TOP | CFA_LEFT |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( ADDRREC, pszNt ) );
         
   pdr->colInfo[ADDR_NOTE].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[ADDR_NOTE].fbVisible        = TRUE;
   pdr->colInfo[ADDR_NOTE].ulShowMask       = ADDR_STY_SHOWNOTE;
   pdr->colInfo[ADDR_NOTE].pfinf->pUserData = &usRightDvWnd;

   mr = pfnAddCnrCol ( pdr->hwndE, colStrs.pszAddrDate, CFA_CENTER | CFA_FITITLEREADONLY,
                       CFA_DATE | CFA_TOP | CFA_RIGHT |
                       CFA_SEPARATOR | CFA_HORZSEPARATOR,
                       FIELDOFFSET ( ADDRREC, cdUpd ) );
         
   pdr->colInfo[ADDR_DATE].pfinf            = PVOIDFROMMR ( mr );
   pdr->colInfo[ADDR_DATE].fbVisible        = TRUE;
   pdr->colInfo[ADDR_DATE].ulShowMask       = ADDR_STY_SHOWDATE;
   pdr->colInfo[ADDR_DATE].pfinf->pUserData = &usRightDvWnd;

   //*** Hide Hidden Columns ******************************************

   if ( ! ( pdr->ulStyl & ADDR_STY_SHOWNAME ) )
   {
      pdr->colInfo[ADDR_NAME].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[ADDR_NAME].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   if ( ! ( pdr->ulStyl & ADDR_STY_SHOWAREA ) )
   {
      pdr->colInfo[ADDR_AREA].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[ADDR_AREA].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   if ( ! ( pdr->ulStyl & ADDR_STY_SHOWFONE ) )
   {
      pdr->colInfo[ADDR_FONE].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[ADDR_FONE].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   if ( ! ( pdr->ulStyl & ADDR_STY_SHOWEXTN ) )
   {
      pdr->colInfo[ADDR_EXTN].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[ADDR_EXTN].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   if ( ! ( pdr->ulStyl & ADDR_STY_SHOWADDR ) )
   {
      pdr->colInfo[ADDR_ADDR].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[ADDR_ADDR].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   if ( ! ( pdr->ulStyl & ADDR_STY_SHOWNOTE ) )
   {
      pdr->colInfo[ADDR_NOTE].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[ADDR_NOTE].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   if ( ! ( pdr->ulStyl & ADDR_STY_SHOWDATE ) )
   {
      pdr->colInfo[ADDR_DATE].fbVisible = FALSE;

      WinSendMsg ( pdr->hwndE, CM_REMOVEDETAILFIELDINFO,
                   MPFROMP ( &pdr->colInfo[ADDR_DATE].pfinf ),
                   MPFROM2SHORT ( 1, 0 ) );//CMA_INVALIDATE ) );
   }

   //*** Position Container *******************************************
    
   WinQueryWindowPos ( hwnd, &swp );
    
   WinSetWindowPos ( pdr->hwndE, HWND_TOP,
                     0, 0,
                     swp.cx,
                     swp.cy,
                     SWP_SIZE | SWP_MOVE | SWP_SHOW );
    
   WinSetFocus ( HWND_DESKTOP, pdr->hwndE );
    
   //*** Set up Splitbar **********************************************
    
   if ( ! pdr->ulDLen ) 
      pdr->ulXVS = swp.cx / 4 * 3;
    
   pfnCnrSplit ( pdr->hwndE,
                 pdr->colInfo[ADDR_FONE].pfinf,
                 pdr->ulXVS );

   WinSendMsg ( pdr->hwndE, CM_INVALIDATEDETAILFIELDINFO, NULL, NULL );
}  

//****************************************************************************
// Init Menu
//****************************************************************************
VOID             pfnAddrMenu  ( PUSEREC pRecScn, HWND hwndMenu, SHORT sMID )
{
   PADDRREC   pFoc;

   switch ( sMID )
   {
      case MID_ADDR_FILE:
         if ( pqi.pDriverData )
            WinEnableMenuItem ( hwndMenu, MID_ADDR_PRINT, TRUE  );
         else
            WinEnableMenuItem ( hwndMenu, MID_ADDR_PRINT, FALSE );
      break;
          
      case MID_ADDR_EDIT:
          
         if (  pfnIsMyClip ( hwndMenu, atomAddr ) )
            WinEnableMenuItem ( hwndMenu, MID_ADDR_PASTE, TRUE );
         else
            WinEnableMenuItem ( hwndMenu, MID_ADDR_PASTE, FALSE );
          
         pFoc = WinSendMsg ( pRecScn->pdr->hwndE, CM_QUERYRECORDEMPHASIS,
                             MPFROMLONG ( CMA_FIRST ),
                             MPFROMSHORT( CRA_SELECTED ) );
          
         if (  pFoc ) 
         {
            WinEnableMenuItem ( hwndMenu, MID_ADDR_CUT,  TRUE );
            WinEnableMenuItem ( hwndMenu, MID_ADDR_COPY, TRUE );
            WinEnableMenuItem ( hwndMenu, MID_ADDR_DELT, TRUE );
            WinEnableMenuItem ( hwndMenu, MID_ADDR_BEGN, TRUE );
            if ( fbDialing )
               WinEnableMenuItem ( hwndMenu, MID_ADDR_DIAL, FALSE );
            else
               WinEnableMenuItem ( hwndMenu, MID_ADDR_DIAL, TRUE );
         }
         else 
         {
            WinEnableMenuItem ( hwndMenu, MID_ADDR_CUT,  FALSE );
            WinEnableMenuItem ( hwndMenu, MID_ADDR_COPY, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_ADDR_DELT, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_ADDR_BEGN, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_ADDR_DIAL, FALSE );
         }
          
         if (  pRecScn->pdr->fbEditing ) 
         {
            WinEnableMenuItem ( hwndMenu, MID_ADDR_NEXT, TRUE );
            WinEnableMenuItem ( hwndMenu, MID_ADDR_PREV, TRUE );
            WinEnableMenuItem ( hwndMenu, MID_ADDR_STOP, TRUE );
         }
         else 
         {
            WinEnableMenuItem ( hwndMenu, MID_ADDR_NEXT, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_ADDR_PREV, FALSE );
            WinEnableMenuItem ( hwndMenu, MID_ADDR_STOP, FALSE );
         }
          
         if ( pRecScn->pdr->psSrch->hwndS  || ! pFoc )
            WinEnableMenuItem ( hwndMenu, MID_ADDR_FIND, FALSE );
         else 
            WinEnableMenuItem ( hwndMenu, MID_ADDR_FIND, TRUE  );
          
         if ( *pRecScn->pdr->psSrch->pszFnd && pFoc )
            WinEnableMenuItem ( hwndMenu, MID_ADDR_FNDNXT, TRUE );
         else 
            WinEnableMenuItem ( hwndMenu, MID_ADDR_FNDNXT, FALSE );
      break;
   }
}

/***************************************************************************/
/* Address Dial Dialog Proc                                                */
/***************************************************************************/
MRESULT EXPENTRY pfndpAddrDial( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   static  TID  tid;

   switch ( msg ) 
   {
      case WM_INITDLG:
      {
         PADDRREC pAddr;
         ULONG    ulLen;
          
         pAddr = PVOIDFROMMP ( mp2 );
          
         hwndDialDlg = hwnd;

         fbDialing = TRUE;

         WinSetDlgItemText ( hwnd, DIT_DIAL_STAT, " " );

         WinSetDlgItemText ( hwnd, DIT_DIAL_NAME, pAddr->pszFN );

         ulLen = strlen ( pAddr->pszAC ) + strlen ( pAddr->pszPN ) + 4;

         if ( pszDialNum )
            free ( pszDialNum );

         pszDialNum = (PSZ) malloc ( ulLen );

         pszDialNum[0] = 0;

         if ( *pAddr->pszAC )
         {
            strcpy ( pszDialNum, "1" );
            strcat ( pszDialNum, pAddr->pszAC );
         }
         strcat ( pszDialNum, pAddr->pszPN );

         WinSetDlgItemText ( hwnd, DIT_DIAL_NMBR, pszDialNum );

         pfnCanCloseWin ( hwnd, TRUE, FALSE );

         WinEnableWindow ( WinWindowFromID ( hwnd, DID_CANCEL ), FALSE );

         //DosCreateThread ( &tid, (PFNTHREAD)pfnDialerThread, 0L, 0L, 10240 );
         tid = _beginthread ( /*(VOID (*_Optlink)(PVOID))*/pfnDialerThread,
                              NULL, 
                              102400,
                              NULL );
      }
      return (MRESULT) TRUE;
       
      case WM_COMMAND:
          
         switch ( COMMANDMSG(&msg)->cmd ) 
         {
            case DIT_HELP:
            {
               SHORT   sId;
      
               sId = WinQueryWindowUShort ( hwnd, QWS_ID );
      
               WinSendMsg ( hwndH, HM_DISPLAY_HELP,
                            MPFROM2SHORT ( sId, 0 ), MPFROMSHORT ( HM_RESOURCEID ) );
            }
            break;
             
            case DIT_DIAL_HANG:

               pfnDialHangup ( hfilModem );

               DosClose ( hfilModem );

               fbDialing = FALSE;

               WinDismissDlg ( hwnd, TRUE );
                
            break;

            case DID_CANCEL:

               if ( fbDialing )
               {
                  fbDialing = FALSE;
                  DosKillThread ( tid );
                  //DosWaitThread ( &tid, DCWW_WAIT );
                  pfnDialHangup ( hfilModem );
                  DosClose      ( hfilModem );

                  fbDialing = FALSE;
               }

               WinDismissDlg ( hwnd, FALSE );
                
            break;
         };
          
      break;
       
      case UWM_STAT:
          
         WinSetDlgItemText ( hwnd, DIT_DIAL_STAT, PVOIDFROMMP ( mp1 ) );
          
      break;
       
      case UWM_CONNECT:
          
         //WinAlarm ( HWND_DESKTOP, WA_NOTE );
         WinEnableWindow ( WinWindowFromID ( hwnd, DID_CANCEL ), TRUE );
          
      break;
       
      case UWM_ERROR:
          
         //WinAlarm ( HWND_DESKTOP, WA_ERROR );
         //WinAlarm ( HWND_DESKTOP, WA_ERROR );
         WinAlarm ( HWND_DESKTOP, WA_ERROR );
         WinEnableWindow ( WinWindowFromID ( hwnd, DID_CANCEL ), TRUE );
         //WinDismissDlg ( hwnd, FALSE );
          
      break;
       
      default:
      return WinDefDlgProc ( hwnd, msg, mp1, mp2 );
       
   }
    
   return FALSE;
}
 
//****************************************************************************
// Dial Thread
//****************************************************************************
VOID             pfnDialerThread     ( PVOID pv )
{
   HAB       hab;
   HMQ       hmq;
   PSZ       pszNumber;
   CHAR      achStat[80];
   BOOL      fbConnected;
   BOOL      fbError;
   LONG      lTries;
    
   hab  =  WinInitialize ( 0L );
    
   hmq  =  WinCreateMsgQueue ( hab, 0 );

   fbDialing = TRUE;

   lTries = 0;

   fbError = FALSE;

   //*** Start Dialing ******************************************************

   hfilModem = pfnDialOpen ( achComX );

   if ( hfilModem )
   {
      if ( ! fbGotModem )
      {
         if ( pfnDialTest ( hfilModem, achComSet ) )
            fbGotModem = TRUE;
         else
         {
            pfnMsgOK ( hwndDialDlg, APP_TITLE, "Error testing modem." );
            WinPostMsg ( hwndDialDlg, UWM_ERROR, NULL, NULL );
         }
      }

      if ( fbGotModem )
      {
         pszNumber = strdup ( pszDialNum );
         pfnDialParse ( pszDialNum, pszNumber );

         /*pfnDialString ( hfilModem, "ATX3\r" );
      
         DosSleep ( 200 );
      
         pfnDialClear ( hfilModem );*/
      
         WinPostMsg ( hwndDialDlg, UWM_STAT, MPFROMP ( "Dialing..." ), NULL );

         while ( fbDialing )
         {
   
            fbDialing = pfnDialNumber ( hfilModem, pszNumber );

        WinPostMsg ( hwndDialDlg, UWM_CONNECT, NULL, NULL );
            if ( fbDialing )
               fbConnected = pfnDialStatus ( hfilModem, achStat, &fbError );

            WinPostMsg ( hwndDialDlg, UWM_STAT, MPFROMP ( achStat ), NULL );

            if ( fbError )
            {
               pfnMsgOK ( hwndDialDlg, APP_TITLE, "Error dialing modem." );
               WinPostMsg ( hwndDialDlg, UWM_ERROR, NULL, NULL );
               fbDialing = FALSE;
            }
            else //if ( fbConnected )
            {
               WinPostMsg ( hwndDialDlg, UWM_CONNECT, NULL, NULL );
               fbDialing = FALSE;
            }
            /*else
               pfnDialHangup ( hfilModem );*/

            ++lTries;
         }

         free ( pszNumber );
      }
   }
   else
   {
      pfnMsgOK ( hwndDialDlg, APP_TITLE, "Error accessing modem." );
      WinPostMsg ( hwndDialDlg, UWM_ERROR, NULL, NULL );
   }

   //*** Clean Up ***********************************************************

   fbDialing = FALSE;

   DosClose ( hfilModem );

   WinDestroyMsgQueue ( hmq );
    
   WinTerminate ( hab );
    
   //DosExit ( EXIT_THREAD, 0 );
   _endthread();
}

//****************************************************************************
// Print Thread
//****************************************************************************
VOID             pfnAddrPrtThd       ( PVOID pv )
{
   HMQ         hmq;
   PDATREC     pdr;
   PADDRREC    pPrt;
   ULONG       ulPrinted = 0;
   LONG        lCharsOut;
   LONG        lCharsLeft = 1;
   LONG        lNewBottom;
   LONG        lLowBottom;
   BOOL        fbCausePage = FALSE;
   FONTMETRICS fm;
   RECTL       rclText;
   POINTL      pt;
   SHORT       sColsDone;
   SHORT       sCurCol;
   SHORT       sX;
   CHAR        ach32[32];

   hmq = WinCreateMsgQueue ( WinQueryAnchorBlock ( hwndM ), 0 );

   pdr = pprtCtl->pPrtRec->pdr;

   ++pprtCtl->ulPrtPage;

   pdr->ulPrtPage = pprtCtl->ulPrtPage;

   pfnAddrPrintInit ();

   fm = pprtCtl->fmAll;

   //*** Print Entry ********************************************************

   rclText.yBottom = pprtCtl->rclBody.yBottom;
   rclText.yTop    = rclText.yBottom;

   sColsDone = pprtCtl->sVisCols;

   for ( sX = 0; sX < pprtCtl->sVisCols; ++sX )
   {
      pprtCtl->abfinf[sX]   = TRUE;
      pprtCtl->apszfinf[sX] = NULL;
   }

   pPrt = pfnGetCnrRec ( pdr->hwndE, NULL );
    
   while ( pPrt && fbPrinting )
   {
      if ( rclText.yTop - fm.lMaxBaselineExt < rclText.yBottom )
      {
         pfnAddrNewPage ( fbCausePage );

         fbCausePage = TRUE;
         rclText.yTop = pprtCtl->arclfinf[0].yBottom - fm.lMaxDescender;
         lLowBottom   = rclText.yTop;
      }

      sCurCol = 0;

      //*** Print Name ******************************************************

      if ( pdr->ulStyl & ADDR_STY_SHOWNAME )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            if ( ! pprtCtl->apszfinf[sCurCol] )
               pprtCtl->apszfinf[sCurCol] = pPrt->pszFN;

            lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter,
                                           pprtCtl->apszfinf[sCurCol],
                                           &rclText, &pprtCtl->fmAll,
                                           &lNewBottom, &lCharsLeft, 
                                           DT_LEFT | DT_VCENTER,
                                           TRUE, FALSE, FALSE );
      
            if ( lCharsLeft && lCharsOut )
               pprtCtl->apszfinf[sCurCol] += lCharsOut;
            else
            {
               --sColsDone;
               pprtCtl->abfinf[sCurCol] = FALSE;
            }

            if ( lNewBottom && lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }
      //*** Print Area Code *************************************************

      if ( pdr->ulStyl & ADDR_STY_SHOWAREA )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            if ( ! pprtCtl->apszfinf[sCurCol] )
               pprtCtl->apszfinf[sCurCol] = pPrt->pszAC;

            lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter,
                                           pprtCtl->apszfinf[sCurCol],
                                           &rclText, &pprtCtl->fmAll,
                                           &lNewBottom, &lCharsLeft, 
                                           DT_RIGHT | DT_VCENTER,
                                           TRUE, FALSE, FALSE );
      
            if ( lCharsLeft )
               pprtCtl->apszfinf[sCurCol] += lCharsOut;
            else
            {
               --sColsDone;
               pprtCtl->abfinf[sCurCol] = FALSE;
            }

            if ( lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }
      //*** Print Phone Number **********************************************

      if ( pdr->ulStyl & ADDR_STY_SHOWFONE )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            if ( ! pprtCtl->apszfinf[sCurCol] )
               pprtCtl->apszfinf[sCurCol] = pPrt->pszPN;

            lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter,
                                           pprtCtl->apszfinf[sCurCol],
                                           &rclText, &pprtCtl->fmAll,
                                           &lNewBottom, &lCharsLeft, 
                                           DT_RIGHT | DT_VCENTER,
                                           TRUE, FALSE, FALSE );
      
            if ( lCharsLeft )
               pprtCtl->apszfinf[sCurCol] += lCharsOut;
            else
            {
               --sColsDone;
               pprtCtl->abfinf[sCurCol] = FALSE;
            }

            if ( lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }
      //*** Print Extension *************************************************

      if ( pdr->ulStyl & ADDR_STY_SHOWEXTN )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            if ( ! pprtCtl->apszfinf[sCurCol] )
               pprtCtl->apszfinf[sCurCol] = pPrt->pszEx;

            lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter,
                                           pprtCtl->apszfinf[sCurCol],
                                           &rclText, &pprtCtl->fmAll,
                                           &lNewBottom, &lCharsLeft, 
                                           DT_RIGHT | DT_VCENTER,
                                           TRUE, FALSE, FALSE );
      
            if ( lCharsLeft )
               pprtCtl->apszfinf[sCurCol] += lCharsOut;
            else
            {
               --sColsDone;
               pprtCtl->abfinf[sCurCol] = FALSE;
            }

            if ( lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }
      //*** Print Address ***************************************************

      if ( pdr->ulStyl & ADDR_STY_SHOWADDR )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            if ( ! pprtCtl->apszfinf[sCurCol] )
               pprtCtl->apszfinf[sCurCol] = pPrt->pszAd;

            lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter,
                                           pprtCtl->apszfinf[sCurCol],
                                           &rclText, &pprtCtl->fmAll,
                                           &lNewBottom, &lCharsLeft, 
                                           DT_CENTER | DT_VCENTER,
                                           TRUE, FALSE, FALSE );
      
            if ( lCharsLeft )
               pprtCtl->apszfinf[sCurCol] += lCharsOut;
            else
            {
               --sColsDone;
               pprtCtl->abfinf[sCurCol] = FALSE;
            }

            if ( lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }
      //*** Print Notes *****************************************************

      if ( pdr->ulStyl & ADDR_STY_SHOWNOTE )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            if ( ! pprtCtl->apszfinf[sCurCol] )
               pprtCtl->apszfinf[sCurCol] = pPrt->pszNt;

            lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter,
                                           pprtCtl->apszfinf[sCurCol],
                                           &rclText, &pprtCtl->fmAll,
                                           &lNewBottom, &lCharsLeft, 
                                           DT_LEFT | DT_VCENTER,
                                           TRUE, FALSE, TRUE );
      
            if ( lCharsLeft )
               pprtCtl->apszfinf[sCurCol] += lCharsOut;
            else
            {
               --sColsDone;
               pprtCtl->abfinf[sCurCol] = FALSE;
            }

            if ( lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }
      //*** Print Date ******************************************************

      if ( pdr->ulStyl & ADDR_STY_SHOWDATE )
      {
         if ( pprtCtl->abfinf[sCurCol] )
         {
            rclText.xLeft  = pprtCtl->arclfinf[sCurCol].xLeft;
            rclText.xRight = pprtCtl->arclfinf[sCurCol].xRight;

            pfnNLSDate ( &ci, ach32,
                         pPrt->cdUpd.year,
                         pPrt->cdUpd.month, pPrt->cdUpd.day );
 
            pfnPaintText ( pprtCtl->hpsPrinter, ach32, 
                           &rclText, &pprtCtl->fmAll,
                           DT_RIGHT | DT_TOP, TRUE, FALSE );

            --sColsDone;
            pprtCtl->abfinf[sCurCol] = FALSE;

            if ( lLowBottom > lNewBottom )
               lLowBottom = lNewBottom;
         }

         ++sCurCol;
      }

      //*** End of Record Processing ****************************************

      rclText.yTop  = lLowBottom;
      rclText.yTop -= fm.lMaxDescender;

      if ( ! sColsDone )
      {
         if ( rclText.yTop - ( fm.lMaxBaselineExt + fm.lMaxDescender ) > 
              rclText.yBottom )
         {
            pt.y = rclText.yTop;
            pt.x = pprtCtl->rclPage.xLeft;
   
            GpiMove ( pprtCtl->hpsPrinter, &pt );
   
            pt.x = pprtCtl->rclPage.xRight;
   
            GpiLine ( pprtCtl->hpsPrinter, &pt );
         }

         rclText.yTop -= fm.lMaxDescender;

         sColsDone = pprtCtl->sVisCols;
      
         for ( sX = 0; sX < pprtCtl->sVisCols; ++sX )
         {
            pprtCtl->abfinf[sX]   = TRUE;
            pprtCtl->apszfinf[sX] = NULL;
         }
      
         WinPostMsg ( pprtCtl->hwndPrtDlg, UWM_STAT, 
                      MPFROMLONG ( ++ulPrinted ),
                      MPFROMLONG ( pdr->ulDEnt ) );

         pPrt = pfnGetCnrRec ( pdr->hwndE, pPrt );
      }
   }
   //*** Clear Out **********************************************************

   /*if ( pbBuf )
      free ( pbBuf );*/

   if ( fbPrinting )
      WinPostMsg ( pprtCtl->hwndPrtDlg, UWM_DONE, NULL, NULL );

   WinDestroyMsgQueue ( hmq );

   DosPostEventSem ( evtThdDone );

   //DosExit ( EXIT_THREAD, 0 );
   _endthread();
}

//****************************************************************************
// Print New Page
//****************************************************************************
VOID             pfnAddrNewPage      ( BOOL fbCausePage )
{
   PDATREC     pdr;
   LONG        lCharsOut;
   LONG        lCharsLeft;
   LONG        lNewBottom;
   SHORT       sX;
   CHAR        ach32[32];
   POINTL      pt;

   pdr = pprtCtl->pPrtRec->pdr;

   lNewBottom = pprtCtl->rclPage.yTop;

   //*** Print Heading ***************************************************

   if ( fbCausePage )
   {
      pfnPrintPageEject ( pdr->hwndD, pprtCtl->hpsPrinter );

      ++pprtCtl->ulPrtPage;
   }

   else if ( ulTreeOpts & SCB_PRTHEAD )
   {
      pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                        &pprtCtl->defPrtHed.fat, FONTID_HED );

      lCharsOut = pfnPaintTextRect ( pprtCtl->hpsPrinter, 
                                     pprtCtl->pPrtRec->crecCore.pszTree,
                                     &pprtCtl->rclPage, &pprtCtl->fmHed,
                                     &lNewBottom, &lCharsLeft, 
                                     DT_LEFT | DT_VCENTER,
                                     FALSE, FALSE, FALSE );
   
   }

   //*** Adjust to Printed Heading Height First Time Through *************

   if ( ! fbCausePage )
   {
      pprtCtl->rclBody.yTop = lNewBottom - pprtCtl->fmAll.lMaxBaselineExt;

      for ( sX = 0; sX < pprtCtl->sVisCols; ++sX )
      {
         pprtCtl->arclfinf[sX].yTop    = pprtCtl->rclBody.yTop;
         pprtCtl->arclfinf[sX].yBottom = pprtCtl->rclBody.yTop -
                                        ( pprtCtl->fmAll.lMaxBaselineExt * pprtCtl->lHedLines );
      }
   }

   //*** Print Page Number ***********************************************

   if ( ulTreeOpts & SCB_PRTPAGE )
   {
      pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                        &pprtCtl->defPrtCnt.fat, FONTID_CNT );


      sprintf ( ach32, "-  %d  -", pprtCtl->ulPrtPage );
   
      pfnPaintText ( pprtCtl->hpsPrinter, ach32, 
                     &pprtCtl->rclFoot, &pprtCtl->fmCnt,
                     DT_CENTER | DT_BOTTOM, FALSE, FALSE );
   }

   //*** Print Column Headings *******************************************

   pfnSelPaintFont ( hwndM, pprtCtl->hpsPrinter, 
                     &pprtCtl->defPrtAll.fat, FONTID_ALL );

   pfnPaintBox ( pprtCtl->hpsPrinter, &pprtCtl->rclBody );

   lCharsOut = pprtCtl->fmAll.lMaxBaselineExt / 2;

   for ( sX = 0; sX < pprtCtl->sVisCols; ++sX )
   {
      pprtCtl->arclfinf[sX].yTop -= lCharsOut;

      pfnPaintTextRect ( pprtCtl->hpsPrinter,
                         (PSZ)pdr->colInfo[pprtCtl->alIds[sX]].pfinf->pTitleData,
                         &pprtCtl->arclfinf[sX], 
                         &pprtCtl->fmAll,
                         &lNewBottom, &lCharsLeft, 
                         DT_CENTER | DT_VCENTER,
                         FALSE, FALSE, FALSE );

      pprtCtl->arclfinf[sX].yTop += lCharsOut;

      pt.x = pprtCtl->arclfinf[sX].xLeft;
      pt.y = pprtCtl->rclBody.yTop;

      GpiMove ( pprtCtl->hpsPrinter, &pt );

      pt.y = pprtCtl->rclBody.yBottom;

      GpiLine ( pprtCtl->hpsPrinter, &pt );
   }

   pt.x = pprtCtl->rclPage.xLeft;
   pt.y = pprtCtl->arclfinf[0].yBottom;

   GpiMove ( pprtCtl->hpsPrinter, &pt );

   pt.x = pprtCtl->rclPage.xRight;

   GpiLine ( pprtCtl->hpsPrinter, &pt );
}

//****************************************************************************
// Print Initialization
//****************************************************************************
VOID             pfnAddrPrintInit    (  )
{
   PDATREC     pdr;
   SHORT       sVisCols;
   LONG        lLeft;
   SHORT       sX;
   LONG        lAllPels;
   LONG        lLeftPels;
   LONG        lUsedPels;
   LONG        lDatePels;
   LONG        colLines;
   PSZ         psz;

   pdr = pprtCtl->pPrtRec->pdr;

   //*** Set Entry Font *****************************************************

   if ( pprtCtl->fbNewFont )
   {
      pdr->fxPtSzPrt = pprtCtl->defPrtAll.fxPtSz;
      pdr->fatPrt    = pprtCtl->defPrtAll.fat;
   }

   if ( pdr->fxPtSzPrt )
   {
      pprtCtl->defPrtAll.fxPtSz = pdr->fxPtSzPrt;
      pprtCtl->defPrtAll.fat    = pdr->fatPrt;
   }

   pfnCvtVecFont     ( pprtCtl->hpsPrinter, 
                       pprtCtl->defPrtAll.fxPtSz,
                       &pprtCtl->defPrtAll.fat );

   pfnSetPaintFont   ( pdr->hwndD, pprtCtl->hpsPrinter, 
                       &pprtCtl->defPrtAll.fat, FONTID_ALL );

   GpiQueryFontMetrics ( pprtCtl->hpsPrinter, sizeof ( FONTMETRICS ), 
                         &pprtCtl->fmAll );

   //*** Column Setup ******************************************************* */

   lAllPels  = pprtCtl->rclPage.xRight - pprtCtl->rclPage.xLeft;
   lDatePels = pfnStrPelLen ( pprtCtl->hpsPrinter, "55-55-5555" );
   lUsedPels = 0;

   sVisCols = 0;

   if ( pdr->hwndD )
   {
      if ( pdr->ulStyl & ADDR_STY_SHOWNAME )
      {
         /*pprtCtl->alfinf[sVisCols] = pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[ADDR_NAME].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         pprtCtl->alfinf[sVisCols] = pprtCtl->fmAll.lAveCharWidth * 28;

         lUsedPels += pprtCtl->alfinf[sVisCols];

         pprtCtl->alIds[sVisCols]   = ADDR_NAME;
   
         ++sVisCols;
      }
      if ( pdr->ulStyl & ADDR_STY_SHOWAREA )
      {
         /*pprtCtl->alfinf[sVisCols] = pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[ADDR_AREA].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         pprtCtl->alfinf[sVisCols] = pprtCtl->fmAll.lAveCharWidth * 7;

         lUsedPels += pprtCtl->alfinf[sVisCols];
   
         pprtCtl->alIds[sVisCols]   = ADDR_AREA;
   
         ++sVisCols;
      }
      if ( pdr->ulStyl & ADDR_STY_SHOWFONE )
      {
         /*pprtCtl->alfinf[sVisCols] = pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[ADDR_FONE].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         pprtCtl->alfinf[sVisCols] = pprtCtl->fmAll.lAveCharWidth * 18;

         lUsedPels += pprtCtl->alfinf[sVisCols];
   
         pprtCtl->alIds[sVisCols]   = ADDR_FONE;
   
         ++sVisCols;
      }
      if ( pdr->ulStyl & ADDR_STY_SHOWEXTN )
      {
         /*pprtCtl->alfinf[sVisCols] = pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[ADDR_EXTN].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         pprtCtl->alfinf[sVisCols] = pprtCtl->fmAll.lAveCharWidth * 7;

         lUsedPels += pprtCtl->alfinf[sVisCols];
   
         pprtCtl->alIds[sVisCols]   = ADDR_EXTN;
   
         ++sVisCols;
      }

      lLeftPels = lAllPels - lUsedPels;

      if ( pdr->ulStyl & ADDR_STY_SHOWDATE )
         lLeftPels -= lDatePels;

      if ( pdr->ulStyl & ADDR_STY_SHOWADDR )
      {
         /*pprtCtl->alfinf[sVisCols] = pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[ADDR_ADDR].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         if ( pdr->ulStyl & ADDR_STY_SHOWNOTE )
            pprtCtl->alfinf[sVisCols] = lLeftPels / 2;
         else
            pprtCtl->alfinf[sVisCols] = lLeftPels;

         lUsedPels += pprtCtl->alfinf[sVisCols];
         lLeftPels -= pprtCtl->alfinf[sVisCols];
   
         pprtCtl->alIds[sVisCols]   = ADDR_ADDR;
   
         ++sVisCols;
      }
      if ( pdr->ulStyl & ADDR_STY_SHOWNOTE )
      {
         /*pprtCtl->alfinf[sVisCols] = pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[ADDR_NOTE].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         pprtCtl->alfinf[sVisCols] = lLeftPels;

         pprtCtl->alIds[sVisCols]   = ADDR_NOTE;
   
         ++sVisCols;
      }
      if ( pdr->ulStyl & ADDR_STY_SHOWDATE )
      {
         /*pprtCtl->alfinf[sVisCols] = pfnCnrColPels ( pdr->hwndE,
                                                     pdr->colInfo[ADDR_DATE].pfinf );
   
         pprtCtl->alfinf[sVisCols] += ( pprtCtl->fmAll.lAveCharWidth * 2 );*/
   
         pprtCtl->alfinf[sVisCols] = lDatePels;
   
         pprtCtl->alIds[sVisCols]   = ADDR_DATE;
   
         ++sVisCols;
      }
   }

   pprtCtl->sVisCols = sVisCols;

   /*pprtCtl->rclPage.xRight = pfnPrintALScale ( pprtCtl->rclPage.xRight -
                                               pprtCtl->rclPage.xLeft,
                                               sVisCols, 
                                               pprtCtl->alfinf );*/

   pprtCtl->rclBody.xRight = pprtCtl->rclPage.xRight;
   pprtCtl->rclFoot.xRight = pprtCtl->rclPage.xRight;

   //*** Column Headings Setup ********************************************** */

   lLeft = pprtCtl->rclPage.xLeft;

   for ( sX = 0; sX < sVisCols; ++sX )
   {
      pprtCtl->arclfinf[sX].xLeft  = lLeft;
      pprtCtl->arclfinf[sX].xRight = lLeft + pprtCtl->alfinf[sX];

      lLeft = pprtCtl->arclfinf[sX].xRight;
   }

   pprtCtl->arclfinf[sVisCols-1].xRight = pprtCtl->rclPage.xRight;

   pprtCtl->lHedLines = 1;

   for ( sX = 0, colLines = 1, psz = colStrs.pszAddrName; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   for ( sX = 0, colLines = 1, psz = colStrs.pszAddrArea; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   for ( sX = 0, colLines = 1, psz = colStrs.pszAddrFone; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   for ( sX = 0, colLines = 1, psz = colStrs.pszAddrExtn; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   for ( sX = 0, colLines = 1, psz = colStrs.pszAddrAddr; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   for ( sX = 0, colLines = 1, psz = colStrs.pszAddrNote; sX < strlen ( psz ); ++sX )
      if ( psz[sX] == '\n' )
         ++colLines;
   if ( colLines > pprtCtl->lHedLines )
      pprtCtl->lHedLines = colLines;

   ++pprtCtl->lHedLines;
}
