/***************************************************************************/
/* Revisions                                                               */
/***************************************************************************/
 
/* 2.5
** Tree:
**   Intra-process Drag/Drop fixed
*/
 
/* 2.4
** Tree:
**   Drag/Drop and Settings fixes
** Refr:
**   Added
*/

/* 2.3
** All:
**   Added F2 through F6 accelerators and functionality
**   Columns title customization for Address books and Todo lists
**   User-key registration
*/

/* 2.0
**
** Tree:
**   Re-Windowed tree & editors - No more MDI
**   Added entry from clipboard
**   Added drag drop support for tree view arranging
**   Added drag drop support for tree view import
**   Save, Close, Expand & Collapse all.
**   Removed 2 Column List option.
** Settings notebook
**   1 icon for all editors option
**   Hide menus & stats for all ( except page )
**   Default fonts & printing styles
**   Tree view icons, lines
**   Use file name or root title
**   Add editors to task list
** All:
**   Added drag drop support for editor entry order arranging ( except page )
**   Added Search function
**   Configure visible columns
**   Save Scrapbook option on menu
**   Printing
**   Added Access to Tree window, Scrapbook save and Entry title to all editors.
** Address:
**   Dial phone from address book
** Mini-Base:
**   New editor !
**   Old 2 Column Lists automatically converted
** ToDo:
**   Added Priority to ToDo
**   Added priority & task sort
**   Completion date set on ToDo double click
** Text:
**   Dropped multiple text icons
**  
*/
 
/* 1.2
**
** Added ability to choose icon
** Removed Delete hot-key tree bug/feature
**
*/
 
/* 1.1
**
** Added MID_PAGE_EXP function
** Fixed truncation problems in Page editor
** Added hot-keys for all container text edits (except list col heads)
** Fixed sporadic on-line help appearance
** Remembers tree icon/expand state
** Added accelerators for tree window
**
*/
 
/***************************************************************************/
/* Main #define's & #include's                                             */
/***************************************************************************/
 
#define INCL_WIN
 
#define INCL_GPILCIDS
#define INCL_GPIPRIMITIVES
#define INCL_GPILOGCOLORTABLE

#define INCL_DOSERRORS
#define INCL_DOSPROCESS
#define INCL_DOSNLS
#define INCL_DOSSEMAPHORES

#define INCL_SPL
#define INCL_SPLDOSPRINT

#define INCL_DEV
 
//#define INCL_BITMAPS
 
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
 
#include <pmlib.h>

#include "fspres.h"
 
/***************************************************************************/
/* #define's                                                               */
/***************************************************************************/
 
#define CMA_DATAWIDTH   0x0200
 
#define QNAME_LEN     256

#define TREE_KEY      "Tree"
#define ADDR_KEY      "Addr"
#define TODO_KEY      "ToDo"
#define MINI_KEY      "Mini"
#define TEXT_KEY      "Text"
#define REFR_KEY      "Refr"

#define OPTS_KEY      "Options"
#define PRTQ_KEY      "PrtQueue"

#define FONT_ALL_KEY  "DefAll"
#define FONT_HED_KEY  "DefHeading"
#define FONT_CNT_KEY  "DefContent"

#define MOD_POR_KEY   "ModemPort"
#define MOD_SET_KEY   "ModemSetup"
#define COL_LISTS     "Columns"

#define UNREGSTRD     TRUE
#define UNREG_MAX     6
#define UNREG_CODE    619193
#define REGED_CODE    61919361
#define REL_REV       200  //114
                      
#define ADDR_COLS     7
#define TODO_COLS     6
                      
#define MINI_COLS     16
#define MINI_SORTS    4
                      
#define MAX_COLS      MINI_COLS

#define FONTID_ALL    7
#define FONTID_HED    8
#define FONTID_CNT    9

#define UWM_PARAMS    WM_USER +  1
#define UWM_SAVE      WM_USER +  2
#define UWM_DETWIN    WM_USER +  3
#define UWM_SEARCH    WM_USER +  4
#define UWM_SETTING   WM_USER +  5
#define UWM_STAT      WM_USER +  6
#define UWM_DONE      WM_USER +  7
#define UWM_ERROR     WM_USER +  8
#define UWM_CONNECT   WM_USER +  9
#define UWM_SETRECPTR WM_USER + 10
 
#define SCB_PARENT    0x00000001
#define SCB_EXPAND    0x00000002
#define SCB_OPENED    0x00000004
#define SCB_ICONED    0x00000008
#define SCB_DETAIL    0x00000010
#define SCB_STATED    0x00000020
#define SCB_MENUED    0x00000040
#define SCB_TREELIN   0x00000080
#define SCB_WINOWN    0x00000100
#define SCB_CONVERT   0x00000200
#define SCB_CASE      0x00000400
#define SCB_NULL0     0x00000800
#define SCB_TXTWRAP   0x00001000
#define SCB_PRICOLR   0x00002000
#define SCB_ENTDIAL   0x00004000
#define SCB_SRCHALL   0x00008000
#define SCB_PRTCONT   0x00010000
#define SCB_PRTHEAD   0x00020000
#define SCB_PRTPAGE   0x00040000
#define SCB_TITFILE   0x00100000
#define SCB_WINTASK   0x00200000
#define SCB_DROPREFR  0x00400000
 
#define ADDR_NAME           0
#define ADDR_AREA           1
#define ADDR_FONE           2
#define ADDR_EXTN           3
#define ADDR_ADDR           4
#define ADDR_NOTE           5
#define ADDR_DATE           6

#define ADDR_STY_SHOWNAME   0x00000001
#define ADDR_STY_SHOWAREA   0x00000002
#define ADDR_STY_SHOWFONE   0x00000004
#define ADDR_STY_SHOWEXTN   0x00000008
#define ADDR_STY_SHOWADDR   0x00000010
#define ADDR_STY_SHOWNOTE   0x00000020
#define ADDR_STY_SHOWDATE   0x00000040

#define ADDR_COLTXT_NAME    "Name"
#define ADDR_COLTXT_AREA    "Area\nCode"
#define ADDR_COLTXT_FONE    "Phone\nNumber"
#define ADDR_COLTXT_EXTN    "Ext."
#define ADDR_COLTXT_ADDR    "Address"
#define ADDR_COLTXT_NOTE    "Notes"
#define ADDR_COLTXT_DATE    "Date"
#define ADDR_COLLEN_NAME    28
#define ADDR_COLLEN_AREA    7
#define ADDR_COLLEN_FONE    18
#define ADDR_COLLEN_EXTN    7
#define ADDR_COLLEN_ADDR    0
#define ADDR_COLLEN_NOTE    0
#define ADDR_COLLEN_DATE    12

#define TODO_ENTR           0
#define TODO_TARG           1
#define TODO_DONE           2
#define TODO_PRIO           3
#define TODO_CHEK           4
#define TODO_TASK           5

#define TODO_COLTXT_ENTR    "Entry\nDate"
#define TODO_COLTXT_TARG    "Target\nDate"
#define TODO_COLTXT_DONE    "Done\nDate"
#define TODO_COLTXT_PRIO    "!"
#define TODO_COLTXT_IDID    "?"
#define TODO_COLTXT_TASK    "Task"
#define TODO_COLTXT_NOTE    "Notes"
#define TODO_COLLEN_ENTR    12
#define TODO_COLLEN_TARG    12
#define TODO_COLLEN_DONE    12
#define TODO_COLLEN_PRIO    5
#define TODO_COLLEN_IDID    5
#define TODO_COLLEN_TASK    0
#define TODO_COLLEN_NOTE    0

#define TODO_STY_SHOWENTR   0x00000001
#define TODO_STY_SHOWTARG   0x00000002
#define TODO_STY_SHOWDONE   0x00000004
#define TODO_STY_SHOWPRIO   0x00000008
#define TODO_STY_SHOWCHEK   0x00000010
#define TODO_STY_SHOWTASK   0x00000020

#define SCB_TODO_DONE       0x00000010
#define SCB_TODO_PRI5       0x00000000
#define SCB_TODO_PRI4       0x00000001
#define SCB_TODO_PRI3       0x00000002
#define SCB_TODO_PRI2       0x00000004
#define SCB_TODO_PRI1       0x00000008
                            
#define SCB_MINI_USED       0x00000001
#define SCB_MINI_SPLT       0x00000002
#define SCB_MINI_LEFT       0x00000004
#define SCB_MINI_MLE        0x20000000
#define SCB_MINI_DELT       0x80000000
#define SCB_MINI_DESC       0x01
                            
#define SCB_REFR_DEFICON    0x00000001
#define SCB_REFR_ISFILE     0x00000002
#define SCB_REFR_ISPATH     0x00000004
 
#define SCB_BRANCH    -1L
#define SCB_TREE       0L
#define SCB_WRITE      1L
#define SCB_FREE       2L
#define SCB_ARRAY      3L
#define SCB_SIZE       4L
#define SCB_MEMORY     5L
#define SCB_REFRESH    6L
#define SCB_SETPAR     7L
#define SCB_MENU       8L
#define SCB_STAT       9L
#define SCB_NODE      10L
#define SCB_SEARCH    11L
#define SCB_NULL1     12L
#define SCB_CLOSE     13L
#define SCB_EXPALL    14L
#define SCB_COLALL    15L
#define SCB_PRICOL    16L
#define SCB_SAVE      17L
#define SCB_UPDATED   18L
#define SCB_HASOPEN   19L
                      
#define DRT_TREE      "DRT_PMSCRAPBOOK"
#define DRM_TREE      "<DRM_PMSCRAPBOOK,DRF_TREE>,<DRM_DISCARD,DRF_TREE>"

#define DRM_ADDR      "<DRM_PMSCRAPBOOK,DRF_ADDR>,<DRM_DISCARD,DRF_ADDR>"
#define DRM_TODO      "<DRM_PMSCRAPBOOK,DRF_TODO>,<DRM_DISCARD,DRF_TODO>"
#define DRM_MINI      "<DRM_PMSCRAPBOOK,DRF_MINI>,<DRM_DISCARD,DRF_MINI>"
#define DRM_REFR      "<DRM_PMSCRAPBOOK,DRF_REFR>,<DRM_DISCARD,DRF_REFR>"

//#define DRM_TREE    "(DRM_OS2FILE,DRM_PMSCRAPBOOK,DRM_DISCARD)x(DRF_TREE)"
//#define DRM_TREE    "(DRM_PMSCRAPBOOK,DRM_DISCARD)x(DRF_UNKNOWN)"
#define XFERMEM       "\\SHAREMEM\\DragXfer.mem"
 
/***************************************************************************/
/* typedef's                                                               */
/***************************************************************************/
 
typedef struct _SRCHREC 
{
   HWND        hwndS;
   HWND        hwndE;
   PSZ         pszFnd;
   PSZ         pszChg;
   BOOL        fbCase;
   BOOL        fbWrap;
   BOOL        fbIsCn;
   BOOL        fbFirst;
 
}  SRCHREC, *PSRCHREC;
 
typedef struct _DATEREC 
{
   PSZ         pszTtl;
   PCDATE      pcdate;
 
}  DATEREC, *PDATEREC;
 
typedef struct _CNRCTLREC 
{
   PFIELDINFO      pfinf;
   BOOL            fbVisible;
   ULONG           ulPels;
   ULONG           ulShowMask;
   //ULONG           ulPrntMask;
 
}  CNRCTLREC, *PCNRCTLREC;
 
typedef struct _DATREC 
{
   HWND        hwndD;
   HWND        hwndE;
   HWND        hwndM;
   ULONG       ulRelRev;
   PSZ         pszStat;
   PVOID       pvWork;
   PSRCHREC    psSrch;
   PDATEREC    pdDate;
   SWP         swp;
   FATTRS      fat;
   FIXED       fxPtSz;
   FATTRS      fatPrt;
   FIXED       fxPtSzPrt;
   ULONG       ulXVS;
   BOOL        fbModified;
   BOOL        fbEditing;
   ULONG       ulDEnt;
   ULONG       ulDLen;
   PVOID       pvDat;
   ULONG       ulOpts;
   ULONG       ulStyl;
   ULONG       ulCntr;
   PFIELDINFO  pfi;
   ULONG       ulNBClr;
   ULONG       ulNFClr;
   ULONG       ulHBClr;
   ULONG       ulHFClr;
   ULONG       ulPrtPage;
   CNRCTLREC   colInfo[MAX_COLS];
 
}  DATREC, *PDATREC;
 
typedef struct _USEREC 
{
   RECORDCORE  crecCore;
   ULONG       ulType;
   ULONG       ulOpts;
   ULONG       ulReal;
   CDATE       cdCre;
   CTIME       ctCre;
   CDATE       cdWri;
   CTIME       ctWri;
   CDATE       cdAcc;
   CTIME       ctAcc;
   PDATREC     pdr;
   ULONG       ulKids;
 
}  USEREC, *PUSEREC;
 
typedef struct _TREEIO 
{
   HWND        hwndSource;
   LONG        lLvl;
   ULONG       ulType;
   ULONG       ulOpts;
   ULONG       ulReal;
   CDATE       cdCre;
   CTIME       ctCre;
   CDATE       cdWri;
   CTIME       ctWri;
   CDATE       cdAcc;
   CTIME       ctAcc;
   ULONG       ulNLen;
   ULONG       ulDLen;
 
}  TREEIO, *PTREEIO;
 
typedef struct _REFRREC
{
   RECORDCORE  crecCore;
   PSZ         pszFileName;
   PSZ         pszIconFile;
   PSZ         pszSub;
   PSZ         pszKey;
   PSZ         pszCom;
   CDATE       cdUpd;
   ULONG       ulOpt;
 
}  REFRREC, *PREFRREC;
 
typedef struct _ADDRREC 
{
   RECORDCORE  crecCore;
   PSZ         pszFN;
   PSZ         pszAC;
   PSZ         pszPN;
   PSZ         pszEx;
   PSZ         pszAd;
   PSZ         pszNt;
   CDATE       cdUpd;
   ULONG       ulOpt;
 
}  ADDRREC, *PADDRREC;
 
typedef struct _TODOREC 
{
   RECORDCORE  crecCore;
   CDATE       cdEnt;
   CDATE       cdFin;
   CDATE       cdTrg;
   ULONG       ulOpt;
   PSZ         pszPr;
   PSZ         pszFn;
   PSZ         pszDo;
   ULONG       ulPri;
 
}  TODOREC, *PTODOREC;
 
typedef struct _LST2REC 
{
   RECORDCORE  crecCore;
   CDATE       cdCur;
   PSZ         psz1;
   PSZ         psz2;
 
}  LST2REC, *PLST2REC;
 
typedef struct _MINIREC 
{
   RECORDCORE  crecCore;
   PSZ         psz01;
   PSZ         psz02;
   PSZ         psz03;
   PSZ         psz04;
   PSZ         psz05;
   PSZ         psz06;
   PSZ         psz07;
   PSZ         psz08;
   PSZ         psz09;
   PSZ         psz10;
   PSZ         psz11;
   PSZ         psz12;
   PSZ         psz13;
   PSZ         psz14;
   PSZ         psz15;
   PSZ         psz16;
   CDATE       cdUpd;
   ULONG       ulOpt;
 
}  MINIREC, *PMINIREC;
 
typedef struct _MCOLREC 
{
   ULONG       ulCHOpts;
   ULONG       ulCDOpts;
   ULONG       ulOffset;
    
   ULONG       ulOpts;
   ULONG       ulStyl;
    
   ULONG       ulChrs;
    
   ULONG       ulX;
    
   PSZ         pszTitl;
    
   PFIELDINFO  pfi;
 
}  MCOLREC, *PMCOLREC;
 
typedef struct _MCTLREC 
{
   ULONG       ulCols;
   ULONG       ulSplit;
    
   BYTE        abSort[MINI_SORTS];
   BYTE        abSOpt[MINI_SORTS];
    
   MCOLREC     mcols[MINI_COLS];
 
}  MCTLREC, *PMCTLREC;
 
typedef struct _DATAIO 
{
   HWND        hwndD;
   HWND        hwndE;
   SWP         swp;
   FATTRS      fat;
   FIXED       fxPtSz;
   FATTRS      fatPrt;
   FIXED       fxPtSzPrt;
   ULONG       ulRelRev;
   ULONG       ulOpts;
   ULONG       ulStyl;
   ULONG       ulDEnt;
   ULONG       ulXVS;
   ULONG       ulNBClr;
   ULONG       ulNFClr;
   ULONG       ulHBClr;
   ULONG       ulHFClr;
 
}  DATAIO, *PDATAIO;
 
typedef struct _COLSTRS
{
   ULONG       version;
   ULONG       regCode;

   ULONG       ulAddrName;
   PSZ         pszAddrName;
   ULONG       ulAddrArea;
   PSZ         pszAddrArea;
   ULONG       ulAddrFone;
   PSZ         pszAddrFone;
   ULONG       ulAddrExtn;
   PSZ         pszAddrExtn;
   ULONG       ulAddrAddr;
   PSZ         pszAddrAddr;
   ULONG       ulAddrNote;
   PSZ         pszAddrNote;
   ULONG       ulAddrDate;
   PSZ         pszAddrDate;
 
   ULONG       ulToDoEntr;
   PSZ         pszToDoEntr;
   ULONG       ulToDoTarg;
   PSZ         pszToDoTarg;
   ULONG       ulToDoDone;
   PSZ         pszToDoDone;
   ULONG       ulToDoPrio;
   PSZ         pszToDoPrio;
   ULONG       ulToDoIDid;
   PSZ         pszToDoIDid;
   ULONG       ulToDoTask;
   PSZ         pszToDoTask;
   ULONG       ulToDoNote;
   PSZ         pszToDoNote;

}  COLSTRS, *PCOLSTRS;
 
typedef struct _DEFAULTREC
{
   FATTRS      fat;
   FIXED       fxPtSz;
   ULONG       ulOpts;
   ULONG       ulStyl;
   ULONG       ulNBClr;
   ULONG       ulNFClr;
   ULONG       ulHBClr;
   ULONG       ulHFClr;
 
}  DEFAULTREC, *PDEFAULTREC;
 
typedef struct _PRINTCTL
{
   HWND        hwndPrtDlg;
   PUSEREC     pPrtRec;
   HPS         hpsPrinter;
   BOOL        fbNewFont;
   ULONG       ulPrtPage;
   HCINFO      hci;
   RECTL       rclPage;
   RECTL       rclBody;
   RECTL       rclFoot;
   ULONG       ulOpts;
   LONG        lHedLines;
   DEFAULTREC  defPrtAll;
   DEFAULTREC  defPrtHed;
   DEFAULTREC  defPrtCnt;
   DEFAULTREC  defPrtTmp;
   FONTMETRICS fmAll;
   FONTMETRICS fmHed;
   FONTMETRICS fmCnt;

   SHORT       sVisCols;
   LONG        alIds[MAX_COLS];       // Column Identifier
   LONG        alFmt[MAX_COLS];       // Data Justification
   LONG        alfinf[MAX_COLS];      // Column Pels Width
   PSZ         apszfinf[MAX_COLS];    // Data Strings
   RECTL       arclfinf[MAX_COLS];    // Column Rectangles
   BOOL        abfinf[MAX_COLS];      // Need to Print Flag
 
}  PRINTCTL, *PPRINTCTL;
 
/***************************************************************************/
/* Globals                                                                 */
/***************************************************************************/
 
VAR_SCOPE PUSEREC         pRec;
VAR_SCOPE PUSEREC         pRecFoc;
VAR_SCOPE PUSEREC         pRecAll;
VAR_SCOPE PUSEREC         pRecPrt;
VAR_SCOPE PUSEREC         pRecDroppedOn;
 
VAR_SCOPE ATOM            atomTree;
VAR_SCOPE ATOM            atomAddr;
VAR_SCOPE ATOM            atomToDo;
VAR_SCOPE ATOM            atomLst2;
VAR_SCOPE ATOM            atomMini;
VAR_SCOPE ATOM            atomRefr;
 
VAR_SCOPE BOOL            fbModified;
VAR_SCOPE BOOL            fbEditing;
VAR_SCOPE BOOL            fbSaving;
VAR_SCOPE BOOL            fbPrinting;
VAR_SCOPE BOOL            fbGotModem;
VAR_SCOPE BOOL            fbDialing;
VAR_SCOPE BOOL            fbReading;
VAR_SCOPE BOOL            fbClosing;
VAR_SCOPE BOOL            fbSftK;
VAR_SCOPE BOOL            fbUnregistered;
 
VAR_SCOPE ULONG           ulRelRev;
 
VAR_SCOPE ULONG           ulTreeOpts;
VAR_SCOPE ULONG           ulTextOpts;
VAR_SCOPE ULONG           ulAddrOpts;
VAR_SCOPE ULONG           ulToDoOpts;
VAR_SCOPE ULONG           ulRefrOpts;

VAR_SCOPE ULONG           ulMiniOpts;
 
VAR_SCOPE HPOINTER        hptrMain;
//VAR_SCOPE HPOINTER        hptrList;
VAR_SCOPE HPOINTER        hptrAddr;
VAR_SCOPE HPOINTER        hptrToDo;
VAR_SCOPE HPOINTER        hptrText;
VAR_SCOPE HPOINTER        hptrMini;
VAR_SCOPE HPOINTER        hptrPrnt;
VAR_SCOPE HPOINTER        hptrRefr;
 
VAR_SCOPE ULONG           ulMDefCols;
 
VAR_SCOPE PSZ             pszCurrFile;
 
VAR_SCOPE HWND            hwndM;
VAR_SCOPE HWND            hwndH;
VAR_SCOPE HWND            hwndC;
VAR_SCOPE HWND            hwndS;
VAR_SCOPE HWND            hwndFoc;
VAR_SCOPE HWND            hwndOwn;

VAR_SCOPE HWND            hwndFrame;
VAR_SCOPE HWND            hwndTreeMenu;
 
VAR_SCOPE HPOINTER        hptr;
 
VAR_SCOPE ULONG           ulCnt;
VAR_SCOPE ULONG           ulEntryUpdates;
 
VAR_SCOPE PSZ             pszSearch;
VAR_SCOPE BOOL            pszSearchFound;

VAR_SCOPE HFILE           hfilModem;
VAR_SCOPE PSZ             pszDialNum;
VAR_SCOPE CHAR            achComX[8];
VAR_SCOPE CHAR            achComSet[80];
 
VAR_SCOPE USHORT          usLeftDvWnd;
VAR_SCOPE USHORT          usRightDvWnd;
 
VAR_SCOPE PSZ             pszQueueName;
VAR_SCOPE PRQINFO3        pqi;

VAR_SCOPE PPRINTCTL       pprtCtl;
VAR_SCOPE HEV             evtThdDone;


VAR_SCOPE COUNTRYCODE     ctrycode;
VAR_SCOPE COUNTRYINFO     ci;

VAR_SCOPE COLSTRS         colStrs;

VAR_SCOPE BOOL            inSettingsInit;

/***************************************************************************/
/* Prototypes                                                              */
/***************************************************************************/
 
MRESULT EXPENTRY pfnwpMainWin     ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfnwpTextWin     ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfnwpAddrWin     ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfnwpToDoWin     ( HWND, ULONG, MPARAM, MPARAM );
//MRESULT EXPENTRY pfnwpLst2Win     ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfnwpMiniWin     ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpRefrProps   ( HWND, ULONG, MPARAM, MPARAM );
 
MRESULT EXPENTRY pfndpStats       ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpSearch      ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpEditDate    ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpAbout       ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpRegInfo     ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpSettings    ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpSetIcon     ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpColors      ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpPrint       ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpSetTitle    ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY pfndpRegister    ( HWND, ULONG, MPARAM, MPARAM );
 
//SHORT   APIENTRY pfnLst2Sort      ( PRECORDCORE, PRECORDCORE, PVOID );
 
BOOL             pfnLst2MiniBase  ( PUSEREC );

BOOL             pfnRefrSave      ( PUSEREC, HWND, BOOL );
BOOL             pfnRefrNewRec    ( PUSEREC, PSZ );
BOOL             pfnRefrIcon      ( PUSEREC );
PREFRREC         pfnRefrLoadEntry ( PUSEREC );
VOID             pfnRefrFreeEntry ( PREFRREC );

BOOL             pfnSaveOpts      ( VOID );
PUSEREC          pfnAllocRec      ( PUSEREC, ULONG, ULONG, BOOL, BOOL );
VOID             pfnSetWhen       ( PCDATE, PCTIME );
VOID             pfnSetWinPos     ( HWND, PDATREC );
VOID             pfnGetWinPos     ( HWND, PDATREC );
 
BOOL             pfnNewBook       ( HWND, PSZ );
USHORT           pfnMaybeSave     ( VOID );
BOOL             pfnSaveFile      ( HWND, PSZ );
BOOL             pfnReadFile      ( HWND, PSZ );
BOOL             pfnReadBufr      ( HWND, PBYTE, PUSEREC, PUSEREC );
 
VOID             pfnTreeScan      ( PUSEREC, LONG, LONG, MPARAM );
ULONG            pfnNodeScan      ( HWND, LONG, LONG, PBYTE );
ULONG            pfnNodeUtil      ( PUSEREC, LONG, LONG, MPARAM );
HWND             pfnEntryOpen     ( PUSEREC, PLONG );
PUSEREC          pfnHaveAKid      ( PUSEREC, BOOL );
 
VOID             pfnNewPrintCtl   ( HWND );
VOID             pfnPrintBounds   ( HWND );

VOID             pfnFixCnrCols    ( PUSEREC, USHORT, BOOL );

BOOL             pfnSetPresColors ( HWND, ULONG, ULONG, ULONG, ULONG );
BOOL             pfnGetPresColors ( HWND, PULONG, PULONG, PULONG, PULONG );
 
BOOL             pfnFrameTitle    ( HWND, PSZ, PSZ );
 
PSZ              pfnStrSearch     ( PSZ, ULONG, PSZ, ULONG, BOOL );
ULONG            pfnStrChrCnt     ( PSZ, ULONG, CHAR );
 
