.*
:userdoc.
:title. World Clock Version 1.11
:docprof toc=123.
.nameit symbol=greename text=':hp2.:color fc=darkgreen bc=default.World Clock:color fc=default bc=default.:ehp2.'
.nameit symbol=setsave text='When finished, press :hp2.Save settings:ehp2. button, to write settings to CLOCK.INI. If you want to reset changes, press :hp2.Default:ehp2. button to use standard settings.'
.*
.* Panel definition : Introduction
.*
:h1 id=100  res=100 x=0% y=0% width=100% height=100%  group=1.Introduction
:i1 id=100.Introduction
:p.
&greename. is a highly configurable clock with Coordinated Universal Time (UTC),
Universal Date and Time (UDT), Internet time ("Swatch beat"), Daylight Savings Time,
Calendar, Stopwatch, Alarm, Program launcher, Latitudes and Longitudes, Sunrise/sunset
and day length for Warp.
.br
Time can be displayed for 1 to 9 cities from a provided list of 700 cities.
You can add new city, change properties for selected city or delete city.
.br
&greename. has included fully qualified TZ (Time Zone) environment variable and coordinates (latitude and longitude) for all cities in the list.
You can set TZ environment variable for your CONFIG.SYS, using properties for your city.
:p.
&greename. has Language support for English, Croatian, German, Polish and Swedish.
If you want to add your Language support :link refid=author reftype=fn. visit my site:elink.
and download Translation tool (translat.zip).
:p.
:hp2.Features&colon.:ehp2.
:ul compact.
:li.Various date and time display formats (ISO 8601 and country-specific)
:li.Display for each selected city&colon.
.br
 country, time, date, coordinates (latitude and longitude), sunrise, sunset and day length for current date
.br
 Universal Time (UTC) difference, Standard and Daylight Savings time descriptor, TZ environment variable
:li.Horizontal or vertical arrangement of selected cities, normal or compact display
:li.Minimized or banner view (display only cities and time)
:li.Universal date &amp. time (UDT), Coordinated Universal Time (UTC), Internet time ("Swatch beat") in title bar
:li.World time (Standard time in all Time zones) with World map
:li.Calculate distance between two selected locations on the World map
:li.Calendar for current month/year
:li.Calculate the TZ environment variable using City properties (all cities in the list have included TZ environment variable)
:li.Selectable position, size, font and fontsize
:li.Alarm and Program launcher for each city
:li.Stopwatch
:li.Add new cities (e.g your own if not in the list), or change city properties
:eul.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=110.How to get help
:elink.
:li.
:link reftype=hd res=190.History
:elink.
:li.
:link reftype=hd res=200.Installation
:elink.
:li.
:link reftype=hd res=300.World Clock
:elink.
:li.
:link reftype=hd res=350.View
:elink.
:li.
:link reftype=hd res=750.Translation tool
:elink.
:li.
:link reftype=hd res=890.Glossary
:elink.
:esl.
.*
.* Panel definition for: How to get help
.*
:h2 id=110 res=110 x=left y=bottom width=100% height=100% group=2.
How to get help
:i2 refid=100.How to get help
:i2 refid=100.Status line
:parml tsize=5.
:pt.:hp2.Status line:ehp2.
:pd.Most of windows and dialogs in &greename. have status line in the bottom of window (except World Time window - status line is in the Title bar).
If you move pointer over some control (button, checkbox, radio button, list, entry field ...), you will see short description of action you can perform if you select this control.
:pt.:hp2.Manual:ehp2.
:pd.Detailed explanation and instruction about &greename. can be found in this manual.
Colors and styles used in manual&colon.
.br
:hp2.Bold - title, important information, button or other control to be selected:ehp2.
.br
:hp4.Blue - link to related topic in this manual:ehp4.
.br
:hp8.Red - warning, caution:ehp8.
:pt.:hp2.Contacting the author:ehp2.
:pd.If you need more help, and can't find it here, or you think some important information is missing in this manual,
:link refid=author reftype=fn. contact me:elink..
:eparml.
.*
.* Panel definition : History
.*
:h2 id=190  res=190 x=0% y=0% width=100% height=100%  group=2.History
:i2 refid=100.History
:p.
:hp2.Version 1.11 (2000-04-04)&colon.:ehp2.
:sl compact.
:li.CROATIAN Language support
:li.GERMAN Language support
:li.POLISH Language support
:li.SWEDISH Language support
:li.New World maps
:li.Changed Banner and Minimized view
:li.150 new cities
:esl.
:p.
:hp2.Version 1.10 (1999-12-18)&colon.:ehp2.
:sl compact.
:li.World map
:li.Coordinates (longitude, latitude) for all cities
:li.Display sunrise, sunset and day length for selected cities
:li.Calculate distance between selected cities or locations in the world
:li.Settings notebook
:li.Enable or disable error and warning messages
:li.150 new cities
:esl.
:p.
:hp2.Version 1.01 (1999-10-23)&colon.:ehp2.
:sl compact.
:li.Universal date &amp. time
:li.Date with note in Calendar is displayed with asterisk (*)
:li.Display cities in city list sorted by City, Country, or Country, City. Display all cities or only cities in user's Time Zone
:li.Dialog with all cities is closed after city is selected
:li.Error checking for all values. If program can not find one of them in CLOCK.INI, default values are loaded.
:li.Corrected date display for December and display for year 2000 in Calendar (leap year!)
:li.Stopwatch was accidentally removed form PopUp menu - it's back now
:li.Under some environment (Warp3 with FP35 and FP38, Warp4 with FP10), &greename. was not able to find CONFIG.SYS and TZ variable - fixed
:esl.
:p.
:hp2.Version 1.00 (1999-10-10)&colon.:ehp2.
:sl compact.
:li.DSTswitch to World Clock Interface
:li.New date and time display formats (ISO 8601 Standard)
:li.Calendar for current month/year
:li.Corrected settings for TZ environment variable
:li.Added TZ environment variable for all cities
:li.Fixed bugs while running under Object Rexx
:li.Improved Install/UnInstall program
:esl.
:p.
:hp2.Version 0.98 (1999-08-28)&colon.:ehp2.
:sl compact.
:li.Set TZ environment variable using City properties
:li.Improved Install/UnInstall program
:esl.
:p.
:hp2.Version 0.97 (1999-07-30)&colon.:ehp2.
:sl compact.
:li.Banner display
:li.World Time (Standard time in all Time zones)
:li.Universal time (UTC) and Internet time ("Swatch beat") in title bar
:li.Countdown (show remaining time for Alarm execution)
:li.Corrected Launch for DOS programs
:li.While Message box is on the screen, clock is running
:li.Rearranged Cities window - easier changing of cities and city properties
:li.Improved Install/UnInstall program
:esl.
:p.
:hp2.Version 0.96 - fix 1 (1999-06-18)&colon.:ehp2.
:sl compact.
:li.Fixed bug in version 0.96 (12-hour display)
:esl.
:p.
:hp2.Version 0.96 (1999-06-15)&colon.:ehp2.
:sl compact.
:li.New Install/UnInstall program
:li.Documentation in INF format
:esl.
:p.
:hp2.Version 0.95 (1999-04-26)&colon.:ehp2.
:sl compact.
:li.Horizontal or vertical, normal or compact display
:li.Daylight Savings time
:li.Minimized view
:li.Selectable position, size, font and fontsize
:li.Alarm and Program launcher for each city
:esl.
:p.
:hp2.Version 0.90 (1999-03-26)&colon.:ehp2.
:sl compact.
:li.Initial release
:esl.
.*
.* Panel definition : Installation
.*
:h1 id=200  res=200 x=0% y=0% width=100% height=100%  group=1.Installation
:i1 id=200.Installation
:i2 refid=200.Rexx
:p.
:hp7.REXX MUST BE INSTALLED ON YOUR SYSTEM TO RUN WORLD CLOCK AND INSTALL PROGRAM.:ehp7.
:p.
Installation program (Install.exe) enables you to&colon.
:ul compact.
:li.Install &greename. to selected drive / directory. If you have previous version of &greename. (1.10) installed, you can use existing settings (Selected cities, alarms, programs to launch and notes in calendar),
:li.ReInstall &greename. after you copied/moved files to other drive/directory and refresh existing values in USER (OS2.INI) and object on Desktop,
:li.UnInstall &greename. - remove specific values from USER (OS2.INI) and destroy
objects on Desktop.
:eul.
:parml compact tsize=5.
:pt.
:hp2.Files in archive clock111.zip&colon.:ehp2.
:pd.
:dl compact tsize=15.
:dt.:hp5.File name:ehp5.
:dd.:hp5.Description:ehp5.
:dt.Install.exe
:dd.Install/UnInstall program :hp8.required!:ehp8.
:dt.INSTALL.INI
:dd.Install/UnInstall - configuration file :hp8.required!:ehp8.
:dt.Clock.exe
:dd.World Clock - program :hp8.required!:ehp8.
:dt.CLOCK.INI
:dd.World Clock - configuration file :hp8.required!:ehp8.
:dt.ENGLISH.INI
:dd.World Clock - ENGLISH language file :hp8.required!:ehp8.
:dt.CROATIAN.INI
:dd.World Clock - CROATIAN language file
:dt.GERMAN.INI
:dd.World Clock - GERMAN language file
:dt.POLISH.INI
:dd.World Clock - POLISH language file
:dt.SWEDISH.INI
:dd.World Clock - SWEDISH language file
:dt.World0.met
:dd.World map
:dt.World1.met
:dd.World map
:dt.World2.met
:dd.World map
:dt.World3.met
:dd.World map
:dt.FastIni.dll
:dd.Library for fast access to INI files :hp2.recommended:ehp2.
:dt.English.inf
:dd.World Clock - English manual
:dt.English.ipf
:dd.World Clock - source file for English manual
:dt.Swedish.inf
:dd.World Clock - Swedish manual
:dt.DSTsWClk.exe
:dd.DSTswitch to World Clock Interface.
:dt.Install.ico
:dd.Install/UnInstall icon
:dt.Clock.ico
:dd.World Clock - icon
:dt.Folder1.ico
:dd.World Clock folder - icon
:dt.Folder2.ico
:dd.World Clock folder - icon
:dt.ReadEng.1st
:dd.Latest Information about World Clock (English)
:dt.ReadSwe.1st
:dd.Latest Information about World Clock (Swedish)
:dt.file_id.diz
:dd.World Clock - short description
:edl.
:eparml.
:p.
Unzip files from archive clock111.zip to empty directory, start Install/UnInstall program (Install.exe) and select action&colon. Install or UnInstall.
:nt.
if you try to run &greename. program (Clock.exe) before installation, Install/UnInstall program will start.
.br
:hp8.DO NOT unzip archive and start Install program in ROOT DIRECTORY!:ehp8.
:ent.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=210.Install
:elink.
:li.
:link reftype=hd res=220.UnInstall
:elink.
:li.
:link reftype=hd res=510.Default settings
:elink.
:esl.
.*
.* Panel definition : Install
.*
:h2 id=210 res=210 x=0% y=0% width=100% height=100%  group=2.Install
:i2 refid=200.Install
:p.
After you pressed :hp2.Install:ehp2. button, you will see Copyright notice, License agreement and Disclaimer.
Read this carefuly and press :hp2.I agree:ehp2. button if you want to install &greename..
:p.
Install procedure will do following&colon.
:ol compact.
:li.add &greename.'s specific values in USER (OS2.INI) file,
:li.create &greename.'s folder and programs objects on Desktop,
:li.write default values to &greename.'s INI file (CLOCK.INI),
:li.use selected Cities, Alarms, Launcher and Calendar settings from previous version (if you have version 1.10 installed).
:eol.
:nt.
if you want to use settings from previous version (1.10) DO NOT UNINSTALL PREVIOUS VERSION before you install version 1.11.
After you installed &greename. 1.11, you can uninstall &greename. 1.10. You can also keep &greename. 1.10 on your computer and run both versions.
:ent.
You can install &greename.&colon.
:ul compact.
:li.to suggested directory (C&colon.\Clock111),
:li.to current directory - where you started Install program (press :hp2.Current:ehp2. button),
:li.to other drive/directory (press :hp2.Other:ehp2. button, then select drive/directory),
:li.to new directory (enter name for new directory - Install program will create new directory and copy files to this directory).
:nt.
If you selected current directory as target directory for installation and &greename. is already installed in this directory,
current settings in CLOCK.INI file will be OVERWRITTEN with default settings.
:p.
Install program can create only ONE directory - for example&colon. you can create :hp2.c&colon.\Newdir:ehp2., but not :hp8.c&colon.\Newdir1\Newdir2:ehp8..
.br
:hp8.DO NOT select ROOT DIRECTORY as target directory!:ehp8.
:p.
If Install program find files in directory where you want to install &greename., they will be OVERWRITTEN.
:ent.
:eul.
:p.
After Install procedure is finished, and :hp2.Start World Clock on exit:ehp2. checkbox is selected, when you press :hp2.Exit:ehp2. button, &greename. will start.
:p.
If you copied &greename. to new drive/directory, start Install/UnInstall program again, and select Install.
Select :hp2.Current:ehp2. directory and select :hp2.Use existing settings:ehp2. checkbox.
Program will write new values in USER (OS2.INI) file, and refresh objects on Desktop.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=220.UnInstall
:elink.
:li.
:link reftype=hd res=510.Default settings
:elink.
:li.
:link reftype=hd res=640.Select (other) city
:elink.
:esl.
.*
.* Panel definition : UnInstall
.*
:h2 id=220  res=220 x=0% y=0% width=100% height=100%  group=2.UnInstall
:i2 refid=200.UnInstall
:p.
If you don't like &greename. and want to remove it, start Install/UnInstall program and select UnInstall.
When finished, delete all files in directory where you installed &greename..
.br
:warning.
:color fc=red.
Do not remove files without UnInstall procedure.
:color fc=default.
:ewarning.
If you did it, destroy &greename. 1.11 folder and remove following values from USER (OS2.INI) file, in Application ToolsByGoran&colon.
:ul compact.
:li.WorldClock111WorkDir
:li.WorldClock111INIfile
:eul.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=210.Install
:elink.
:esl.
.*
.* Panel definition : World Clock
.*
:h1 id=300 res=300 x=0% y=0% width=100% height=100%  group=1.World Clock
:i1 id=300.World Clock
:p.
When you start &greename. you will see selected cities with their time, date, UTC difference
(+hh&colon.mm = eastern hemisphere, -hh&colon.mm = western hemisphere) and Time Zone descriptor -
for Standard time or Daylight Savings time (DST). If city has DST, there is a small circle after
DST descriptor. In title bar is displayed UDT, UTC,and/or Internet time ("Swatch beat").
:p.
:hp2.To open PopUp menu, move mouse pointer on World Clock's area and press second mouse button (right-click by default).:ehp2.
:p.
If &greename. has focus, you can use keyboard for following actions&colon.
:dl compact tsize=15.
:dt.:hp2.M, Enter:ehp2.
:dd.Open PopUp menu
:dt.:hp2.F1, H:ehp2.
:dd.Help - open &greename.'s manual
:dt.:hp2.X, Alt-F4:ehp2.
:dd.Exit &greename.
:edl.
:p.
When Installation procedure finished and &greename. starts for first time, you have to configure it.
As &greename. gets the time and date from your computer's internal clock, you first have to select your Time Zone and your current Daylight Savings Time status.
To do this, select YOUR CITY as FIRST city of possible 9.
:p.
&greename. accepts one command-line parameter&colon. d (:hp2.Clock.exe d:ehp2.). Use this parameter if you want to start &greename. with default settings.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=350.View
:elink.
:li.
:link reftype=hd res=400.PopUp menu
:elink.
:li.
:link reftype=hd res=500.Settings
:elink.
:li.
:link reftype=hd res=600.Cities
:elink.
:li.
:link reftype=hd res=710.World Time
:elink.
:li.
:link reftype=hd res=730.Stopwatch
:elink.
:li.
:link reftype=hd res=740.Calendar
:elink.
:li.
:link reftype=hd res=890.Glossary
:elink.
:esl.
.*
.* Panel definition : View
.*
:h1 id=350 res=350  x=0% y=0% width=100% height=100%  group=1.View
:i1 id=350.View
:p.
You can select how to display &greename. on the screen&colon.
:parml tsize=5.
:pt.:hp2.Standard view:ehp2.
:pd.This is default view. You can select display number (1 to 9) of 9 selected cities. For every city is displayed&colon.
.br
city and country, time zone descriptor, local time and date. You can select vertical or horizontal orientation,
normal or compact display, etc.
:pt.:hp2.Banner view:ehp2.
:pd.&greename.'s height is reduced to title bar and width is set to screen width. To set display in banner view, open Settings notebook and go to "Other" page.
You can select to display time for cities in standard view (or for all 9 selected cities) and position of banner view on the screen (top or bottom).
Display is scrolled from right to left and time is displayed in format hh&colon.mm (without seconds).
:pt.:hp2.Minimized view:ehp2.
:pd.&greename.'s height is reduced to title bar. In title bar is displayed city name and local time (for 1st city).
You can select to display time for all 9 selected cities - open Settings notebook, go to "Other" page and check :hp2.Change cities:ehp2..
Local time for every city will be displayed 10 seconds. Position of minimized view is the same as position of standard view.
:eparml.
:p.
On exit, last selected view is remembered, and when you start &greename. again, it will be displayed in last selected view.
:nt.
If you select banner or minimized view, CPU usage is lower than in standard view.
:ent.
.*
.* Panel definition : PopUp menu
.*
:h1 id=400 res=400  x=0% y=0% width=100% height=100%  group=1.PopUp menu
:i1 id=400.PopUp menu
:p.
:hp2.To open PopUp menu, press second mouse button (right-click by default) on World Clock's area,
or press M or Enter (if World Clock has focus).:ehp2.
:p.
Items in PopUp menu are&colon.
:dl compact tsize=15.
:dt.:hp2.Display:ehp2.
:dd.normal or compact, horizontal or vertical orientation
:dt.:hp2.Position:ehp2.
:dd.position on the screen (top left, top right, bottom left, bottom right, center)
:dt.:hp2.View:ehp2.
:dd.standard (display city, country, time, date, UTC difference, TZ descriptor), minimized or banner view (display only city and time)
:dt.:hp2.Settings:ehp2.
:dd.open Settings notebook - configure &greename.
:dt.:hp2.Cities:ehp2.
:dd.view/change city's properties, add new/change/delete city, set Alarm and Program launcher, set TZ environment variable
:dt.:hp2.World Time:ehp2.
:dd.display Standard time (no DST!) in ALL Time Zones, World Map and distance between selected locations
:dt.:hp2.Stopwatch:ehp2.
:dd.start Stopwatch
:dt.:hp2.Calendar:ehp2.
:dd.display Calendar for current month/year
:dt.:hp2.Universal:ehp2.
:dd.display universal date &amp. time (UDT, UTC, "Swatch beat")
:dt.:hp2.Help:ehp2.
:dd.show Help for &greename.
:dt.:hp2.About:ehp2.
:dd.Program and Author
:dt.:hp2.Exit:ehp2.
:dd.leave &greename.
:edl.
:p.
If &greename. has focus, you can use keyboard to perform following actions&colon.
:dl compact tsize=15.
:dt.:hp2.M, Enter:ehp2.
:dd.Open PopUp menu
:dt.:hp2.F1, H:ehp2.
:dd.Help - open &greename.'s manual
:dt.:hp2.X, Alt-F4:ehp2.
:dd.Exit &greename.
:edl.
.*
.* Panel definition : Settings
.*
:h1 id=500 res=500  x=0% y=0% width=100% height=100%  group=1.Settings
:i1 id=500.Settings
:p.
To open Settings notebook, press second mouse button (right-click by default) on &greename. area and select :hp2.Settings:ehp2. in PopUp menu.
All settings are grouped in following pages in Settings notebook&colon.
:dl compact tsize=15.
:dt.:hp2.General:ehp2.
:dd.Display, orientation, number of displayed cities, position, size, free space on the screen
:dt.:hp2.DateTime:ehp2.
:dd.Date and time settings
:dt.:hp2.System:ehp2.
:dd.Enable or disable various messages, Set font, Set system clock
:dt.:hp2.World:ehp2.
:dd.World Time and World map settings, select Language
:dt.:hp2.Other:ehp2.
:dd.Settings for Banner and Minimized view, Stopwatch and miscellaneous settings
:edl.
:p.
When finished , press :hp2.Save settings:ehp2. button, to write settings to CLOCK.INI.
If you want to reset changes, press :hp2.Default:ehp2. button to use &greename.'s standard settings.
:p.
To configure display in Title bar, select :hp2.Universal:ehp2. in PopUp menu and select display to see in Title bar - UDT, UTC, "Swatch beat".
:p.
If you select :hp2.Countdown:ehp2. checkbox in Alarm window, remaining time until alarm for selected city will be displayed in Titlebar - hh&colon.mm to (message) in (selected city).
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=501.General
:elink.
:li.
:link reftype=hd res=502.DateTime
:elink.
:li.
:link reftype=hd res=503.Date settings
:elink.
:li.
:link reftype=hd res=504.Time settings
:elink.
:li.
:link reftype=hd res=505.System
:elink.
:li.
:link reftype=hd res=506.World
:elink.
:li.
:link reftype=hd res=507.Other
:elink.
:li.
:link reftype=hd res=510.Default settings
:elink.
:li.
:link reftype=hd res=520.Set font and size
:elink.
:esl.
.*
.* Panel definition :General
.*
:h2 id=501 res=501  x=0% y=0% width=100% height=100%  group=2.General
:i2 refid=500.General
:p.
:hp2.Display:ehp2.
:ul compact.
:li.Normal (city and country, time, UTC difference, TZ descriptor) or Compact (city and country, time) display,
:li.Horizontal (left to right) or Vertical (top to bottom) orientation,
:li.Number of cities to display - 1 to 9
:eul.
:p.
:hp2.Position:ehp2.
:ul compact.
:li.Position on the screen (top left, top right, bottom left, bottom right or center),
:li.Size of city panel - width (200 to 400) and height (50 to 100) - depending on selected Font type and size.
:eul.
:p.
:hp2.Free space:ehp2.
:ul compact.
:li.Set space between left, bottom, right, top screen border and &greename.'s border (between 0 and 25% of screen width or height).
Use if you want LaunchPad, WarpCenter or some other program to be always visible.
:eul.
:p.
&setsave.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=500.Settings
:elink.
:li.
:link reftype=hd res=510.Default settings
:elink.
:esl.
.*
.* Panel definition : DateTime
.*
:h2 id=502 res=502  x=0% y=0% width=100% height=100%  group=2.DateTime
:i2 refid=500.DateTime
:p.
:hp2.Date:ehp2.
:ul compact.
:li.Date display format - see :link reftype=hd res=503.Date settings:elink. for more details,
:li.Select separator between year month and day - default is hyphen (-),
:li.Display (or not) separator between year month and day,
:li.Display (or not) day of week (Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday),
:li.Display (or not) leading zeroes in date,
:eul.
:p.
:hp2.Time:ehp2.
:ul compact.
:li.Time display format - see :link reftype=hd res=504.Time settings:elink. for more details,
:li.Display (or not) separator between hours minutes and seconds - separator is colon (&colon.),
:li.Display (or not) time in 12-hour (am/pm) format,
:li.Display (or not) difference between local time and UTC,
:li.Display (or not) leading zeroes in time,
:eul.
:p.
&setsave.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=500.Settings
:elink.
:li.
:link reftype=hd res=510.Default settings
:elink.
:esl.
.*
.* Panel definition : Date settings
.*
:h2 id=503 res=503  x=0% y=0% width=100% height=100%  group=2.Date settings
:i2 refid=500.Date settings
:p.
:link reftype=hd res=890.International Standard ISO 8601:elink. is based on date format represented with
the largest units given first, i.e., from left to right the ranking is year, month, week, day.
:p.
Representation of date is available in following formats, where :hp2.1999-09-14:ehp2.
is sample date, hyphen(:hp2.-:ehp2.) is default separator, comma(:hp2.,:ehp2.) is decimal
sign and symbols are&colon.
:dl compact tsize=10.
:dt.:hp2.CC:ehp2.
:dd.century
:dt.:hp2.YY:ehp2.
:dd.year
:dt.:hp2.MM:ehp2.
:dd.month
:dt.:hp2.DD:ehp2.
:dd.date
:dt.:hp2.Www:ehp2.
:dd.week designator and ordinal number of a calendar week within the year
:dt.:hp2.DDD:ehp2.
:dd.ordinal number of a day within the year
:dt.:hp2.D:ehp2.
:dd.ordinal number of a day within calendar week (Monday = 1, ... Sunday = 7)
:dt.:hp2.MON:ehp2.
:dd.name of a calendar month (1 = January, 2 = February, ... 12 = December)
:edl.
:dl compact tsize=25.
:dt. 1. :hp2.CCYY MM DD:ehp2.
:dd.Complete representation - calendar year, ordinal number of a calendar month within the calenday year and ordinal number of a day within the calendar month (:hp2.1999-09-14:ehp2.)
:dt. 2. :hp2.CCYY MM:ehp2.
:dd.Reduced precision - calendar year and ordinal number of a calendar month within the calenday year (:hp2.1999-09:ehp2.)
:dt. 3. :hp2.CCYY:ehp2.
:dd.Reduced precision - calendar year (:hp2.1999:ehp2.)
:dt. 4. :hp2.MM DD:ehp2.
:dd.Truncated representation - specific day of a month (:hp2.09-14:ehp2.)
:dt. 5. :hp2.MM:ehp2.
:dd.Truncated representation - specific month (:hp2.09:ehp2.)
:dt. 6. :hp2.DD:ehp2.
:dd.Truncated representation - specific day (:hp2.14:ehp2.)
:dt. 7. :hp2.CCYY DDD:ehp2.
:dd.Complete representation - calendar year and ordinal day of a year (:hp2.1999-257:ehp2.)
:dt. 8. :hp2.DDD:ehp2.
:dd.Truncated representation - ordinal day of a year only (:hp2.257:ehp2.)
:dt. 9. :hp2.CCYY Www D:ehp2.
:dd.Complete representation - calendar year, ordinal number of a week within the year and ordinal number of a day within the week (:hp2.1999-W38-2:ehp2.)
:dt.10. :hp2.CCYY Www:ehp2.
:dd.Reduced precission - calendar year and ordinal number of a week within the year (:hp2.1999-W38:ehp2.)
:dt.11. :hp2.Www D:ehp2.
:dd.Truncated representation - week and day of the current year (:hp2.W38-2:ehp2.)
:dt.12. :hp2.Www:ehp2.
:dd.Truncated representation - week of the current year (:hp2.W38:ehp2.)
:dt.13. :hp2.D:ehp2.
:dd.Truncated representation - day of the current week (:hp2.2:ehp2.)
:dt.14. :hp2.DD MM CCYY:ehp2.
:dd.Ordinal number of a day within the calendar month, ordinal number of a calendar month within the calenday year and calendar year (:hp2.14-09-1999:ehp2.)
:dt.15. :hp2.DD MON CCYY:ehp2.
:dd.Ordinal number of a day within the calendar month, name of a calendar month within the calenday year and calendar year (:hp2.14-Sep-1999:ehp2.)
:dt.16. :hp2.MM DD CCYY:ehp2.
:dd.Ordinal number of a calendar month within the calendar year, ordinal number of a day within the calendar month and calendar year (:hp2.09-14-1999:ehp2.)
:dt.17. :hp2.MON DD CCYY:ehp2.
:dd.Name of a calendar month within the calenday year, ordinal number of a day within the calendar month and calendar year (:hp2.Sep-14-1999:ehp2.)
:edl.
:p.
Here are options in date display (example is for 1st date format - CCYY MM DD ss)&colon.
:parml compact tsize=5.
:pt.:hp2.Separator:ehp2.
:pd.If selected, date is displayed with separator between year, month and day (:hp2.1999-09-14:ehp2.)
You can select separator (hyphen (-), dot (.), slash (/) or space.
If you unselect this checkbox, date is displayed without separator between year, month and day (:hp2.19990914:ehp2.)
:pt.:hp2.Century and year (4-digit):ehp2.
:pd.If selected, century and year is displayed (:hp2.1999-09-14:ehp2.). If you unselect this checkbox, year in current century is displayed (:hp2.99-09-14:ehp2.).
:pt.:hp2.Show day of week:ehp2.
:pd.If selected, day of week (Monday, Tuesday, ... Sunday) is displayed before date, separated with comma (:hp2.Tue, 1999-09-14:ehp2.)
:pt.:hp2.Leading zeroes:ehp2.
:pd.If selected, months, days, weeks are displayed in 2-digit format.
:eparml.
:nt.
If you select display without separator, then hours and minutes are displayed in 2-digit format (leading zeroes).
Also, if you select display without leading zeroes, separator is displayed. This is required for readable display of time.
:p.
Formats 14, 15, 16 and 17, display without leading zeroes and using other separator than hyphen
are not recommended by International Standard ISO 8601, but they are still in use in many countries.
:ent.
.*
.* Panel definition :Time settings
.*
:h2 id=504 res=504  x=0% y=0% width=100% height=100%  group=2.Time settings
:i2 refid=500.Time settings
:p.
:link reftype=hd res=890.International Standard ISO 8601:elink. is based on the 24-hour timekeeping system.
:p.
Representation of time is available in following formats, where :hp2.20&colon.42&colon.36:ehp2.
is sample time, colon(:hp2.&colon.:ehp2.) is default separator, comma(:hp2.,:ehp2.) is decimal
sign and symbols are&colon.
:dl compact tsize=10.
:dt.:hp2.hh:ehp2.
:dd.hours (represented by two digits from 00 to 23)
:dt.:hp2.hh,h:ehp2.
:dd.hours and decimal fraction of hour (represented by two digits, separator and one digit in decimal fraction from 00,0 to 23,9)
:dt.:hp2.mm:ehp2.
:dd.minutes (represented by two digits from 00 to 59)
:dt.:hp2.mm,m:ehp2.
:dd.minutes and decimal fraction of minute (represented by two digits, separator and one digit in decimal fraction from 00,0 to 59,9)
:dt.:hp2.ss:ehp2.
:dd.seconds (represented by two digits from 00 to 59)
:edl.
:dl compact tsize=20.
:dt.1.  :hp2.hh mm ss:ehp2.
:dd.Complete representation - hours, minutes and seconds (:hp2.20&colon.42&colon.36:ehp2.)
:dt.2.  :hp2.hh mm:ehp2.
:dd.Reduced precision - hours and minutes (:hp2.20&colon.42:ehp2.)
:dt.3.  :hp2.hh:ehp2.
:dd.Reduced precision - hours (:hp2.20:ehp2.)
:dt.4.  :hp2.hh mm,m:ehp2.
:dd.Decimal fractions - hours, minutes and decimal fraction of the minute (:hp2.20&colon.42,6:ehp2. - 36 seconds = 0,6 minutes)
:dt.5.  :hp2.hh,h:ehp2.
:dd.Decimal fractions - hours and decimal fraction of the hour (:hp2.20,7:ehp2. - 42 minutes = 0,7 hours)
:dt.6.  :hp2.mm ss:ehp2.
:dd.Truncated representation - minutes and seconds of the hour (:hp2.42&colon.36:ehp2.)
:dt.7.  :hp2.mm:ehp2.
:dd.Truncated representation - minutes of the hour (:hp2.42:ehp2.)
:dt.8.  :hp2.ss:ehp2.
:dd.Truncated representation - seconds of the minute (:hp2.36:ehp2.)
:dt.9.  :hp2.mm,m:ehp2.
:dd.Truncated representation - minutes of the hour and decimal fraction of the minute (:hp2.42,6:ehp2.)
:edl.
:p.
Here are options in time display (example is for 1st time format - hh mm ss)&colon.
:parml compact tsize=5.
:pt.:hp2.Separator:ehp2.
:pd.If selected, time is displayed with separator between hours, minutes and seconds (:hp2.20&colon.42&colon.36:ehp2.)
If you unselect this checkbox, time is displayed without separator between hours, minutes and seconds (:hp2.204236:ehp2.)
:pt.:hp2.12-hour format:ehp2.
:pd.If selected, hours are converted (:hp2.08&colon.42&colon.36pm:ehp2.)
:pt.:hp2.Show UTC difference:ehp2.
:pd.If selected, difference between local time and UTC is displayed (:hp2.20&colon.42&colon.36 +01&colon.00:ehp2. - for Central Europe)
:pt.:hp2.Leading zeroes:ehp2.
:pd.If selected, hours and minutes are displayed in 2-digit format - seconds are always displayed in 2-digit format.
:eparml.
:nt.
If you select display without separator, then hours and minutes are displayed in 2-digit format (leading zeroes).
Also, if you select display without leading zeroes, separator is displayed. This is required for readable display of time.
:p.
12-hour format and display without leading zeroes are not recommended by International Standard ISO 8601,
but they are still in use in many countries.
:ent.
.*
.* Panel definition : System
.*
:h2 id=505 res=505  x=0% y=0% width=100% height=100%  group=2.System
:i2 refid=500.System
:parml tsize=5.
:pt.:hp2.Enable/disable messages:ehp2.
:pd.
:dl compact tsize=30.
:dt.:hp2.Missing TZ variable:ehp2.
:dd.&greename. did not find SET TZ environment variable in CONFIG.SYS.
:dt.:hp2.Wrong TZ variable:ehp2.
:dd.SET TZ= environment variable in CONFIG.SYS is incomplete.
:dt.:hp2.Different TZ variables:ehp2.
:dd.SET TZ= environment variable in CONFIG.SYS and values for 1st of 9 selected cities are different.
:dt.:hp2.Error in CLOCK.INI:ehp2.
:dd.Some values in configuration file (CLOCK.INI) are wrong or missing. Default values will be loaded.
:dt.:hp2.New city selected:ehp2.
:dd.One of 9 selected cites is selected from the city list.
:dt.:hp2.Alarm or Program is set:ehp2.
:dd.Alarm or Program at specified time for one of 9 selected cities is set.
:dt.:hp2.World map not found:ehp2.
:dd.&greename. did not find World map (World.met).
:edl.
:pt.:hp2.Open Font Palette:ehp2.
:pd.To change &greename.'s font, press :hp2.Open Font Palette:ehp2. button, then drag and drop font you want to use with &greename. on white rectangular with Font name.
:pt.:hp2.Set computer's system clock:ehp2.
:pd.Press :hp2.Set computer's system clock:ehp2. button to open System clock, set date and/or time, close System clock and press :hp2.Refresh date and time:ehp2. to accept changes.
:eparml.
:p.
&setsave.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=500.Settings
:elink.
:li.
:link reftype=hd res=510.Default settings
:elink.
:esl.
.*
.* Panel definition : World
.*
:h2 id=506 res=506  x=0% y=0% width=100% height=100%  group=2.World
:i2 refid=500.World
:p.
:hp2.World Time:ehp2.
:ul compact.
:li.Position on the screen (top left, top right, bottom left, bottom right or center),
:li.Hide (or not) &greename. while World Time is displayed,
:li.Show (or hide) World map when World Time is displayed,
:li.Show (or hide) World map when World Time is displayed,
:eul.
:p.
:hp2.World Map:ehp2.
:ul compact.
:li.Select one of available World maps in the list to display with &greename.
:eul.
:p.
:hp2.Language:ehp2.
:ul compact.
:li.Select Language support for &greename. (available&colon. CROATIAN, ENGLISH, GERMAN, POLISH and SWEDISH, default&colon. ENGLISH).
:nt.if you change Language support and save changes, exit &greename. and start it again to accept changes.:ent.
:eul.
:p.
&setsave.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=500.Settings
:elink.
:li.
:link reftype=hd res=510.Default settings
:elink.
:esl.
.*
.* Panel definition : Other
.*
:h2 id=507 res=507  x=0% y=0% width=100% height=100%  group=2.Other
:i2 refid=500.Other
:p.
Here are other &greename.'s settings - Banner and Minimized view and Stopwatch&colon.
:p.
:hp2.Banner:ehp2.
:ul compact.
:li.Position on the screen (top, bottom),
:li.Show all 9 selected cities (or only cities displayed in &greename.)
:eul.
:p.
:hp2.Minimized:ehp2.
:ul compact.
:li.Change (or not) cities in minimized view every 10 seconds
:eul.
:p.
:hp2.Stopwatch:ehp2.
:ul compact.
:li.Position on the screen (top left, top right, bottom left, bottom right or center),
:li.Display time in Stop watch - seconds, 1/10 seconds, 1/100 seconds,
:eul.
:p.
:hp2.Miscellaneous:ehp2.
:ul compact.
:li.Set System clock to UTC - local time for cities will be calculated from computer's
time and (in most cases) local time for 1st city and computer's system time will be different,
:li.Display short names of months and days (3 characters),
:li.Enable sound on Alarm message,
:li.Enable sound on Note (in Calendar),
:eul.
:p.
&setsave.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=500.Settings
:elink.
:li.
:link reftype=hd res=510.Default settings
:elink.
:esl.
.*
.* Panel definition : Default settings
.*
:h2 id=510 res=510  x=0% y=0% width=100% height=100%  group=2.Default settings
:i2 refid=500.Default settings
:p.
After you installed &greename., default settings are written to CLOCK.INI file.
Default settings are&colon.
:p.
:hp2.General:ehp2.
:ul compact.
:li.Normal display (city, country, time, date, UTC difference, TZ descriptor)
:li.Vertical orientation (top to bottom)
:li.9 displayed cities
:li.Position - top right of the screen
:li.Width - 200, height - 50
:li.Free space - 0 for all borders
:eul.
:p.
:hp2.DateTime:ehp2.
:ul compact.
:li.Date - complete representation with separator and leading zeroes (CCYY-MM-DD)
:li.Show day of week
.br
:li.Time - complete representation - 24-hour format with separator and leading zeroes (hh&colon.mm&colon.ss)
:li.Show difference between loacl time and UTC
:eul.
:p.
:hp2.System:ehp2.
:ul compact.
:li.Show all error, warning and info messages
:li.Font - 9.WarpSans
:eul.
:p.
:hp2.World:ehp2.
:ul compact.
:li.World time position - top left of the screen
:li.Don't hide &greename. while World Time is displayed
:li.Show World map when World Time is displayed
:li.Don't show cities in World map
.br
:li.Language - ENGLISH
:eul.
:p.
:hp2.Other:ehp2.
:ul compact.
:li.Banner position - top of the screen
:li.Show all 9 cities in Banner
.br
:li.Change cities in minimized view every 10 seconds
.br
:li.Stopwatch position - top left of the screen
:li.Stopwatch display - 1/100 secs
.br
:li.System clock is set to local time (not UTC)
:li.Display short names of months and days (3 characters)
:li.Play sound when Alarm message pops up
:li.Play sound when Calendar note pops up
:eul.
:p.
:hp2.Display time in title bar:ehp2. (available in Universal window)
:ul compact.
:li.UTC (Coordinated Universal Time)
:eul.
:nt.
Default settings are also written to CLOCK.INI file, if you start &greename. with parameter d
(:hp2.Clock.exe d:ehp2.) or if you press :hp2.Default:ehp2. button in Setings notebook.
.br
If some of values in CLOCK.INI are missing or wrong, program loads default settings and writes them to CLOCK.INI.
You can open Settings notebook and change settings.
.br
If one of 9 selected cities is missing, program loads :hp5.UTC, Coordinated Universal Time:ehp5..
If values for one of 9 selected cities are missing or wrong, program loads values for :hp5.UTC, Coordinated Universal Time:ehp5..
You can select this city and write correct data.
:ent.
.*
.* Panel definition : Set font and size
.*
:h2 id=520 res=520  x=0% y=0% width=100% height=100%  group=2.Set font and size
:i2 refid=500.Set font and size
:p.
Size of city panel (width 200 and height 50) is configured for screen size 800 * 600 and font 9.WarpSans.
Width range is between 200 and 380, and height range is between 50 and 95.
:p.
If you changed font, try several combinations, until you get best view.
:p.
For example&colon.
:p.
:font facename=Helv size=20x12.
for font 10.Helv set size to 225 (width) and 50 (height),
.br
:font facename=Helv size=24x15.
for font 12.Helv set size to 300 (width) and 70 (height),
.br
:font facename=Helv size=28x18.
for font 14.Helv set size to 350 (width) and 70 (height).
:font facename=default size=0x0.
:p.
:nt.
World time window is exception because of fixed window size. If you select other font than 9.WarpSans,
World Time will use font 8.Helvetica.
:ent.
.*
.* Panel definition : Cities
.*
:h1 id=600 res=600  x=0% y=0% width=100% height=100%  group=1.Cities
:i1 id=600.Cities
:p.
To open Cities window, press second mouse button (right-click by default) on &greename. area and select Cities in PopUp menu.
Here is a list of all 9 cities with their properties&colon.
:ul compact.
:li.Sunrise, Sunset, Day length for current date - in hh&colon.mm (24-hour format) in local Standard time. For DST add one hour,
:li.Coordinates - Latitude (89&deg.59'S-89&deg.59'N) and Longitude (179&deg.59'W-179&deg.59'E)
:li.Universal Time (UTC) difference, Daylight Savings Time (DST) - start date and end date, Time Zone descriptor - for Standard and Summer (DST) time,
:li.Alarm&colon. - time, text, options,
:li.Program launcher&colon. - time, program, directory, parameters.
:eul.
:p.To see distance between 9 selected cities press :hp2.Distance:ehp2. button. Select one of cities in the list to see distance to other cities.
.br
Distance is displayed in kilometers (:hp2.km:ehp2.), miles (:hp2.mi:ehp2. = 1.609 km) or nautical miles (:hp2.nm:ehp2. = 1.852 km).
.br
To view 9 selected cities in the world map, or to calculate distance between two locations in the world, open :hp2.World Time:ehp2. window.
:p.
To add new city to list, change one of 9 selected cities (select new), select city you want
to change and press the :hp2.Select new city from list or change properties for City, Country:ehp2. button
(where City and Country is selected one).
.br
For example&colon. if you want to change 3rd city,select 3rd city in the list area and press the :hp2.Select new city from list or change properties for City, Country:ehp2. button.
:p.
New window with list of all cities will open.
:nt.
If one of 9 selected cities is missing, program loads :hp5.UTC, Coordinated Universal Time:ehp5..
.br
If values for one of 9 selected cities are missing or wrong, program loads values for :hp5.UTC, Coordinated Universal Time:ehp5..
You can later select this city and write correct data.
.br
If there are missing or wrong data for city, you will see error message.
:ent.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=610.All citiess
:elink.
:li.
:link reftype=hd res=640.Select (other) city
:elink.
:li.
:link reftype=hd res=650.Add new city / Change properties
:elink.
:li.
:link reftype=hd res=620.Alarm
:elink.
:li.
:link reftype=hd res=630.Program launcher
:elink.
:li.
:link reftype=hd res=710.World Time
:elink.
:li.
:link reftype=hd res=720.Set TZ environment variable
:elink.
:li.
:link reftype=hd res=890.Glossary
:elink.
:esl.
.*
.* Panel definition : All cities
.*
:h2 id=610 res=610  x=0% y=0% width=100% height=100%  group=2.All cities
:i2 refid=600.All cities
:p.
On the left side of this window is list of all available cities displayed in alphabetical order - City, Country.
If you want to see cities in  alphabetical order - Country, City, press :hp2.Display - Country, City:ehp2. button.
.br
If you have TZ environment variable (SET TZ=...) in CONFIG.SYS file, checkbox :hp2.Only cities in my Time Zone:ehp2. is enabled.
When you select this checkbox, new list is displayed containing  cities with same TZ environment variable as in CONFIG.SYS.
If you don't have TZ environment variable in CONFIG.SYS, or if there is no matching city, this checkbox will be disabled.
:p.
You can scroll up and down until you find city you want. For fast move press first character of city (or country) name
and first city (or country) which name begins with pressed character will be selected. To do this city list must have focus
(black text on white background).
:p.
You can change following properties for selected city&colon.
:ul compact.
:li.Coordinates - Latitude (89&deg.59' Nouth to 89&deg.59' North) and Longitude (179&deg.59' West to 179&deg.59' East),
:li.Universal Time (UTC) difference (time zone),
:li. Time Zone descriptor - for Standard and Summer (DST) time,
:li.Daylight Savings Time (DST) begin and end (week, day of week, month, time) - as you change one
of them, TZ environment variable is changed too. This option is available only if :hp2.Daylight Savings time:ehp2.
checkbox is selected.
:li.TZ environment variable is changed when you change some of values. You can also change TZ
environment variable manually. To accept changes, and adjust values, press :hp2.Refresh:ehp2. button.
:li.If you want to set properties for selected city using TZ environmet variable from CONFIG.SYS,
press :hp2.CONFIG.SYS.:ehp2. button. If you don't have TZ environment variable in CONFIG.SYS, this
button is disabled.
:li.If you want to use calculated TZ environment variable in CONFIG.SYS, press :hp2.Clipboard:ehp2.
button. Then you can use your favorite CONFIG.SYS editor and paste TZ environment variable.
.br
Don't write :hp2.SET TZ=:ehp2. statement in entry field with TZ variable. Program will add this
statement and prepare fully qualified TZ variable.
:nt.
if you changed TZ environment variable in CONFIG.SYS, :hp5.restart your computer to accept changes:ehp5..
:ent.
:eul.
:p.
When finished press :hp2.Save City, Country:ehp2. button where City and Country are name and
coutry of selected city.
:p.
If you press :hp2.New:ehp2. button, you can enter data for new city - City, Country, Standard and
Daylight Savings time values are deleted, other values are set to defaults.
:p.
If you press :hp2.Delete:ehp2. button, selected city will be removed from list.
:nt.You can't delete any of selected cities. To do this, first unselect city (select other).
.br
You can't never delete UTC, Coordinated Universal time, because it is used as default city, if
any of 9 selected cities is missing.
.br
if you change city name and/or country, it will be saved as new city and settings for old (selected) city will not be changed.
.br
:color fc=red.
BE CAREFUL: Program will write changes without warning.
:color fc=black.
:ent.
:p.
:hp5.Related topics:ehp5.
:sl compact.
:li.
:link reftype=hd res=640.Select (other) city
:elink.
:li.
:link reftype=hd res=650.Add new city / Change properties
:elink.
:li.
:link reftype=hd res=720.Set TZ environment variable
:elink.
:li.
:link reftype=hd res=890.Glossary
:elink.
:esl.
.*
.* Panel definition : Select (other) city
.*
:h2 id=640 res=640  x=0% y=0% width=100% height=100%  group=2.Select (other) city
:i2 refid=600.Select (other) city
:p.
After installation, you have to select 9 cities you want to show in &greename.. When you
start &greename. for first time UTC, Coordinated Universal Time is defined as default city.
As &greename. gets the time and date from your computer's internal clock you first have to
select your Time Zone and your current Daylight Savings Time status. To do this select
YOUR CITY as FIRST city of possible 9 in correct Time Zone. If you are using
:link reftype=hd res=870.DSTswitch to World Clock Interface.:elink.
(if you have DSTswitch installed), you can select any city in any Time Zone as 1st city.
:p.
:hp2.How to select other city (one of 9 selected)&colon. step-by-step instructions:ehp2.
:ol.
:li.Open city window (select :hp2.Cities:ehp2. from PopUp menu).
:li.Select city you want to change (between 1st and 9th) in city list.
:li.Press the :hp2.Select new city from list or change properties for City, Country:ehp2. button
(where City and Country is selected one).
:li.
In new window you will see list of all cities, sorted in ascending order,
with first city selected. On the right side are city properties
(city name, country, UTC difference - Time Zone, Daylight Savings Time start and end).
:li.
:hp2.To select other city&colon.:ehp2.
.br
Scroll list up and down until you find your city (select checkbox
:hp2.Only cities in my Time Zone:ehp2. if you want select one of cities in your Time Zone).
As you scroll list, on the button below list you will see text :hp2.Select City, Country as city x:ehp2.,
where City, Country is city name and country of currently selected city, and x is number of city
you want to show in &greename. (between 1 and 9).
.br
When you find city you want, press this button. Selected city will be displayed in &greename..
:eol.
:p.
:hp2.Repeat this procedure for all 9 cities.:ehp2.
:p.
:hp8.
:warning.
if existing city has some Alarm or Program launcher settings, and you selected other city,
Alarm and Program launcher settings will be deleted.
:ewarning.
:ehp8.
:p.
:hp5.Related topics:ehp5.
:sl compact.
:li.
:link reftype=hd res=610.All cities
:elink.
:li.
:link reftype=hd res=650.Add new city / Change properties
:elink.
:li.
:link reftype=hd res=720.Set TZ environment variable
:elink.
:li.
:link reftype=hd res=890.Glossary
:elink.
:esl.
.*
.* Panel definition : Alarm
.*
:h2 id=620 res=620  x=0% y=0% width=100% height=100%  group=2.Alarm
:i2 refid=600.Alarm
:p.
Here you can set an Alarm for each city from of the displayed cities.
&greename. will show Alarm message at the local time of the selected city.
:parml compact tsize=5.
:pt.:hp2.Example&colon.:ehp2.
:pd.
If you want to make two phone calls, one to New York City at 12&colon.00 local time and
another one to London also at 12&colon.00 local time, simply set the alarm for New York
to 12&colon.00 and for London also to 12&colon.00 as described in the following lines.
.br
&greename. will then start the first alarm at 12&colon.00 GMT (London Time = GMT)
and the second alarm at 17&colon.00 GMT (New York Time = GMT + 5 hours).
:eparml.
:p.
To :hp2.set Alarm:ehp2., set time for hours and minutes.
Write the message you want to show - it will appear in a Message box on screen
at the selected time. If you don't write any message, program will write :hp2.Alarm!:ehp2.
message.
:parml tsize=5.
:pt.:hp2.Every day:ehp2.
:pd.Starts the alarm everyday at the same time. If you don't select the Every day
checkbox, the Alarm settings will be deleted after execution. If WorldClock is not running
at the specific time, it will execute the Alarm the next time it is started at the specific time.
:pt.:hp2.Countdown:ehp2.
:pd.Remaining time until Alarm execution will be displayed in Titlebar - hh&colon.mm to
(message) in (selected city). Only 5 times can be tracked at once and they will be changed
in Titlebar every 10 seconds.
:eparml.
:p.
:hp2.TIP&colon.:ehp2. you can always set Alarm for ALL 9 cities, even if some
of them are not displayed.
.*
.* Panel definition : Program launcher
.*
:h2 id=630 res=630  x=0% y=0% width=100% height=100%  group=2.Program launcher
:i2 refid=600.Program launcher
:p.
To :hp2.set Program launcher:ehp2., set the time and select the program (or press
:hp2.Find:ehp2. button to find it via standard FileOpen dialog - you can select *.exe
or *.cmd files), the working directory and the parameters.
:ul compact.
Options are&colon.
:li.run minimized
:li.run in background
:li.run DOS program
:li.close window on exit - for VIO programs
:hp8.  Don't select this option for PM Applications - they probably won't run:ehp8.
:li.Every day - starts the chosen program every day at the same time. If you don't
 select the Every day checkbox, the Launcher settings will  be deleted after execution.
:eul.
:nt.
- if WorldClock is not running at the specific time, it will execute the Program
the next time it is started at the specific time,
.br
- DOS programs are always running in window session.
:ent.
:hp2.TIP&colon.:ehp2. you can always set Launcher for ALL 9 cities, even if
some of them are not displayed.
.*
.* Panel definition : Add new city / Change properties
.*
:h1 id=650 res=650  x=0% y=0% width=100% height=100%  group=1.Add new city / Change properties
:i1 id=650.Add new city
:p.
:hp2.How to add new city or change city properties&colon. step-by-step instructions:ehp2.
:ol.
:li.Open city window (select :hp2.Cities:ehp2. from PopUp menu).
:li.Press :hp2.Select new city from list or change properties for City, Country:ehp2. button.
:li.
In new window you will see list of all cities, sorted in ascending order,
with first city selected. On the right side are city properties
(city name, country, UTC difference - Time Zone, Daylight Savings Time start and end).
:li.
:hp2.To change city properties&colon.:ehp2.
.br
Scroll list up and down until you find your city (select checkbox
:hp2.Only cities in my Time Zone:ehp2. if you want select one of cities in your Time Zone).
 As you scroll list, on the right side are displayed properties for selected city.
.br
When you find city you want, select correct values (city name, country, latitude and longitude,
UTC difference - Time Zone, Daylight Savings Time start and end) - press up and down
arrows on spin buttons. When finished, and press :hp2.Save changes:ehp2. button.
:warning.
:color fc=red.
Program will write changes without warning.
:color fc=black.
:ewarning.
:li.
Here are two ways how :hp2.to add new city&colon.:ehp2.
:ol.
:li.
Press :hp2.New:ehp2. button.
.br
Enter city name and country, select correct values (city name, country, latitude and longitude,
UTC difference - Time Zone, Daylight Savings Time start and end) - press up and down
arrows on spin buttons. When finished, and press :hp2.Save changes:ehp2. button.
:li.
Select city in same Time Zone as city you want to add, change city name and/or country and
press :hp2.Save changes:ehp2. button.
.br
:hp5.Example&colon.:ehp5.
.br
If you want to add Manchester, England select London, England (they have same properties);
change city name to Manchester, set latitude and longitude and press :hp2.Save changes:ehp2. button.
Program will save Manchester, England as new city in CLOCK.INI. Properties for London,
England WILL NOT BE CHANGED.
:eol.
:eol.
:p.
When you save changes, they are also written to file ADDCITY.INI in &greename.'s
working directory. It would be nice if you send me this file by email, so I can update
city list with correct values.
:p.
:hp5.Related topics:ehp5.
:sl compact.
:li.
:link reftype=hd res=610.All cities
:elink.
:li.
:link reftype=hd res=640.Select (other) city
:elink.
:li.
:link reftype=hd res=720.Set TZ environment variable
:elink.
:li.
:link reftype=hd res=890.Glossary
:elink.
:esl.
.*
.* Panel definition : Set TZ environment variable
.*
:h1 id=720 res=720  x=0% y=0% width=100% height=100%  group=1.Set TZ environment variable
:i1 id=720.Set TZ environment variable
:p.
The TZ (time zone) environment variable in CONFIG.SYS controls the interpretation of the hardware clock.
This variable is used by some applications.
:p.
To enable all options in &greename. (select only cities in your Time Zone, run DSTswitch to &greename. interface ...),
fully qualified TZ environment variable must be in CONFIG.SYS (not only TZ descriptor(s) and UTC difference).
:nt.
if you are in United States or Canada, TZ environment variable in your CONFIG.SYS probably looks like&colon. SET TZ=EST5EDT (example is for USA Eastern).
If you want to keep this variable (valid for some programs, not for &greename.) in CONFIG.SYS, disable TZ related messages in Settings notebook (System page).
:ent.
To set TZ environment variable for selected city, select correct values (city name, country,
UTC difference - Time Zone, Daylight Savings Time start and end) - press up and down
arrows on spin buttons. As you change values, TZ string will be changed.
.*:hp5.Following information is used from CM2CFG.DAT (part of CM/2 - CONFIG.SYS editor) by Klaus Staedtler&colon.:ehp5.
:p.
:hp2.If you change the TZ variable manually, complete variable is&colon.:ehp2.
:p.
:font facename=Helv size=24x18.
SET TZ=STD[+|-]nDST[,DSTm,DSTw,DSTd,DSTt,STDm,STDw,STDd,STDt,shift]
:font facename=default size=0x0.
:dl compact tsize=10.
:dt.:hp2.STD:ehp2.
:dd.Standard Time Zone Descriptor (3 characters - it may contain spaces, but first must be character)
:dt.:hp2.n:ehp2.
:dd.Difference to UTC (GMT) in Hours (positive are west of 0 degree length, negative are east of 0 degree length)
:dt.:hp2.DST:ehp2.
:dd.Daylight Savings Descriptor (3 characters - it may contain spaces, but first must be character)
:dt.:hp2.DSTm:ehp2.
:dd.Month in which Daylight Savings Time starts (1=January, 2=February ... , 12=December)
:dt.:hp2.DSTw:ehp2.
:dd.Week in which Daylight Savings Time starts (positive - from the beginning of the month, negative - from the end of the month)
:dt.:hp2.DSTd:ehp2.
:dd.Day at which Daylight Savings Time starts (0=Sunday, 1=Monday ..., 6=Saturday).
:dt.:hp2.DSTt:ehp2.
:dd.Time of Daylight Savings Time start in seconds
:dt.:hp2.STDm:ehp2.
:dd.Month in which Daylight Savings Time ends (1=January, 2=February ... , 12=December)
:dt.:hp2.STDw:ehp2.
:dd.Week in which Daylight Savings Time ends (positive - from the beginning of the month, negative - from the end of the month)
:dt.:hp2.STDd:ehp2.
:dd.Day at which Daylight Savings Time ends (0=Sunday, 1=Monday ..., 6=Saturday).
:dt.:hp2.STDt:ehp2.
:dd.Time of Daylight Savings Time end in seconds
:dt.:hp2.shift:ehp2.
:dd.Size of the Time shift in seconds
:edl.
:p.
:hp8.Don't write SET TZ= statement in entry field with TZ variable. Program will add this
statement and prepare fully qualified TZ variable.:ehp8.
:nt.
if you changed TZ environment variable in CONFIG.SYS, :hp5.restart your computer to accept changes:ehp5..
:ent.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=880.Time Zones
:elink.
:li.
:link reftype=hd res=890.Glossary
:elink.
:esl.
.*
.* Panel definition : World Time
.*
:h1 id=710 res=710  x=0% y=0% width=100% height=100%  group=1.World Time
:i1 id=710.World Time
:p.
Here you can see Standard time (NOT Daylight Savings Time) for all Time Zones from West (UTC -12 hours) to East (UTC +12 hours).
If you move mouse pointer over time displayed in Time Zone, in Title bar is displayed information about this Time Zone (Military code, UTC +/- hours, countries and regions in this Time Zone).
Background colors in Time Zones are&colon. blue=night, white=day, light blue=twilight. Night, day and twilight are displayed for 1st city's latitude.
:p.
When you press :hp2.Position:ehp2. button, you can select position of World Time window on the screen - top left, top right, bottom left, bottom right or center (this option is also available in the Settings notebook - World page).
You can also :hp2.Show map:ehp2. or :hp2.Hide map:ehp2..
:p.
:i2 refid=710.World map
:hp2.World map:ehp2.
:p.
When you select :hp2.Show World map:ehp2. checkbox in Settings, or if you press :hp2.Show map:ehp2. button, World map will be displayed
(If &greename. does not find file World*.met in working directory, checkbox in Settings and button in this window are disabled).
Some features are available only if World map is displayed&colon.
:parml tsize=5.
:pt.:hp5.Coordinates:ehp5.
:pd.When you move cursor over World map, in lower left corner are displayed coordinates of location on the map
(Latitude in degrees and minutes from 180&deg. W(est) to 180&deg. E(ast) and Longitude in degrees and minutes from 90&deg. N(orth) to 90&deg. S(outh)).
:pt.:hp5.Distance:ehp5.
:pd.You can calculate distance between two selected locations in the world. To do this, move cursor to the first location,
press and HOLD 1st mouse button (left mouse button by default) down, move cursor to the second location, and release 1st mouse button. That's all!
.br
In status line you will see following information&colon.
:ol compact.
:li.First location's coordinates&colon. Latitude 180&deg.W(est) - 180&deg.E(ast) and Longitude 90&deg.N(orth) - 90&deg.S(outh)
:li.Second location's coordinates&colon.Latitude 180&deg.W(est) - 180&deg.E(ast) and Longitude 90&deg.N(orth) - 90&deg.S(outh)
:li.Distance in kilometers (km), miles (mi) and nautical miles (nm) - 1 mi = 1.609 km, 1 nm = 1.852 km.
:eol.
:pt.:hp5.PopUp Menu:ehp5.
:pd.When you press 2nd mouse button (right mouse button by default), PopUp menu with following items is displayed&colon.
:dl compact tsize=15.
:dt.:hp2.Position:ehp2.
:dd.Position of this window on the screen (TopLeft, TopRight, BottomLeft, BottomRight and Center)
:dt.:hp2.Hide map:ehp2.
:dd.Hide World map (you can also press :hp2.Hide map:ehp2. button)
:dt.:hp2.Show cities:ehp2.
:dd.Show position of 9 selected cities in &greename. on the map. To see distance between 9 selected cities, open :hp2.Cities:ehp2. window, and press :hp2.Distance:ehp2. button.
:dt.:hp2.Hide cities:ehp2.
:dd.Hide 9 selected cities in &greename. on the map
:dt.:hp2.Help:ehp2.
:dd.Show help about World Time (you can also press :hp2.Help:ehp2. button)
:dt.:hp2.Close:ehp2.
:dd.Close World Time and return to &greename. (you can also press :hp2.Close:ehp2. button)
:edl.
:eparml.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=711.Create your own World map
:elink.
:li.
:link reftype=hd res=500.Settings
:elink.
:li.
:link reftype=hd res=880.Time Zones
:elink.
:li.
:link reftype=hd res=890.Glossary
:elink.
:li.
:link reftype=hd res=800.Limitations
:elink.
:li.
:esl.
.*
.* Panel definition : Create your own World map
.*
:h2 id=711 res=711  x=0% y=0% width=100% height=100%  group=2.Create your own World map
:i2 refid=710.Create your own World map
:p.
You can also create your own map and add it to the list of available World maps. To do this, follow these rules&colon.
:dl tsize=20.
:dt.:hp2.Image type:ehp2.
:dd.OS/2 metafile
:dt.:hp2.Image size:ehp2.
:dd.721 (width) * 361 (height)
:dt.:hp2.Map projection:ehp2.
:dd.Equidistant Cylindrical Projection (a linaer scaling of longitudes and latitudes - the meridians and the parallels are equally spaced.
It is also known as the Plate Car&ea.e projection. All meridians and parallels are straight lines).
:dt.:hp2.Map area:ehp2.
:dd.
180&deg. East  (left border)
.br
180&deg. West  (right border)
.br
 90&deg. North (top border)
.br
 90&deg. South (bottom border)
:edl.
:p.
When finished, add your creation to the list of available World maps&colon.
:ol compact.
:li.Exit &greename. (if it is running) and open CLOCK.INI with INI editor.
:li.Select Application (Section) :hp2.WorldMap:ehp2.. There are 4 Keys (World0.met to World3.met).
:li.Add new Key, where Key name. is name of your file (World4.met for example), and Value is description.
:li.Close CLOCK.INI, start &greename., open :hp2.Settings:ehp2. notebook and select :hp2.World:ehp2. page.
:li.Select your map from the list, press :hp2.Save settings:ehp2. button and close :hp2.Settings:ehp2. notebook.
:li.Open PopUp menu and select :hp2.World:ehp2. menu item. You should see your World map.
:eol.
:nt.
After you added new World map, I would appreciate if you send me new MET file, so I can include this file in next version of &greename..
:ent.
.*
.* Panel definition : Stopwatch
.*
:h1 id=730 res=730  x=0% y=0% width=100% height=100%  group=1.Stopwatch
:i1 id=730.Stopwatch
:p.
If you press second mouse button (right-click by default) on Stopwatch area, you can select position of Stopwatch,
and display of elapsed time in seconds, 1/10 secs or 1/100 secs (also available in Settings notebook).
:nt.
when you start Stopwatch, :hp2.Close:ehp2. button is disbled until you stop it
(press :hp2.Stop:ehp2. button to enable :hp2.Close:ehp2. button).
:ent.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=500.Settings
:elink.
:esl.
.*
.* Panel definition : Calendar
.*
:h1 id=740 res=740  x=0% y=0% width=100% height=100%  group=1.Calendar
:i1 id=740.Calendar
:p.
Calendar displays current month and year. For every day you can write short note.
If day already has note, it is displayed with asterisk after date (:hp4.11*:ehp4. for example).
.br
To select other month/year, use buttons&colon.
:dl compact tsize=15.
:dt.:hp2.1st button:ehp2.
:dd.Select previous year and same month
:dt.:hp2.2nd button:ehp2.
:dd.Select previous month and same year
:dt.:hp2.3rd button:ehp2.
:dd.Select next month and same year
:dt.:hp2.4th button:ehp2.
:dd.Select next year and same month
:edl.
:p.
If you want to edit/view note for date, select it (use arrow keys) and double-click on selected date (or press :hp2.Enter:ehp2. key).
:p.
Then you can enter your note. Press :hp2.Save note:ehp2. button to save note for selected date (visible in title bar), or press :hp2.Delete note:ehp2. button to delete note for selected date.
:p.
Note for current date is displayed when &greename. starts.
.*
.* Panel definition : Universal date &amp. time
.*
:h1 id=745 res=745  x=0% y=0% width=100% height=100%  group=1.Universal date &amp. time
:i1 id=745.Universal date &amp. time
:p.
The Gregorian calendar can be displayed in many different ways&colon. does 10/09/99 mean 10th of September 99 or 9th of October 99.
Or, does 3&colon.00 mean 3am, 3pm, 3pm UTC or 3 in any other time base?
You have to know what format the time/date has been written in, English or American etc., and common mistakes can easily happen.
:p.
Here are three ways how to display date &amp. time identical in all countries and/or time zones&colon.
:parml compact tsize=5.
:pt.:hp2.Coordinated Universal Time (UTC):ehp2.
:pd.is kept on the Greenwich meridian (longitude zero) and times given in UTC are almost always in terms of a 24-hour clock.
:pt.:hp2.Universal Date &amp. Time (UDT):ehp2.
:pd.is a metric based system promoted by Universal Time Organisation that is co-ordinated on UTC.
The day is divided in to any metric number that is required, normally a thousand units or a million units.
The day number of the year and the year can be displayed.
:pt.:hp2.Swatch beat - Internet time:ehp2.
:pd.is inaugurated by Swatch in late 1998. Day is divided into 1000 "beats" and new meridian in is created in Biel, Switzerland, home of Swatch as Biel Mean Time (BMT).
A day in Internet Time begins at midnight BMT (@000 Swatch Beats)  (BMT = Central European Wintertime = CET = UTC + 1).
:eparml.
:p.
You can select any (or all) of this times to display in Title bar, when you select :hp2.Universal:ehp2. item in PopUp menu and check one of following&colon.
:dl compact tsize=10.
:dt.:hp2.UTD:ehp2.
:dd.to display Universal Date &amp. Time
:dt.:hp2.UTC:ehp2.
:dd.to display Coordinated Universal Time (UTC)
:dt.:hp2.Swatch:ehp2.
:dd.to display Swatch beat - Internet time
:edl.
:p.
To display selected time(s) in Title bar, press :hp2.Display:ehp2. button. UTC will be displayed without seconds;
 UTD and Internet time ("Swatch beat") will be displayed as whole numbers (without fraction of unit).
:nt.
when you start &greename., selected time(s) will be displayed in Title bar in next full minute (i.e. 00 sec)
:ent.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=890.Glossary
:elink.
:esl.
.*
.* Panel definition for:Translation tool
.*
:h1 id=750 res=750 x=left y=bottom width=100% height=100% group=2.Translation tool
:i1 id=750.Translation tool
:p.
Language support for &greename. (buttons text, messages, frames text ...) is stored in Language INI files (ENGLISH.INI, CROATIAN.INI, etc.) and source of help file (this file - English.inf) is file English.ipf.
.br
If you want to add your Language support :link refid=author reftype=fn. visit my site:elink.
and download Translation tool (translat.zip).
:p.
:hp2.
To create new Language INI file&colon.
:ehp2.
:ol compact.
:li.Select source language (one of languages in the list).
:li.Press :hp2.New language!:ehp2. button, to create new language file. SOURCE LANGUAGE will be copied to new language file.
:li.Enter language name, comment, your name and email adress (REQUIRED!). Then press :hp2.OK - start translation:ehp2. button.
:li.Sections (pages in Notebook) are: Menu, Hint, Message, Button, Frame and Help. Overwrite text with your text.
:li.When finished, select your language in program and try it.
:eol.
:p.
:hp2.
To change existing Language INI file&colon.
:ehp2.
:ol compact.
:li.Select your language (as source language and your language).
:li.Change comment, your name and email adress if you want, then press :hp2.OK - start translation:ehp2. button.
:li.Sections (pages in Notebook) are: Menu, Hint, Message, Button, Frame and Help. Overwrite existing text with your text - press :hp2.Write changes:ehp2. button after EVERY CHANGE.
:li.When finished, select your language in INI editor and check changes.
:eol.
:p.
:hp2.
Important!
:ehp2.
:p.
Press :hp2.Write changes:ehp2. button after EVERY CHANGE to save changes. If you don't press this button and go to next item, changes WILL BE LOST!
:p.
When you create new Language INI file, program will write new Key to file CLOCK.INI, Language, where&colon.
.br
- Key name is name of new language
.br
- Key value is "English.inf" - it is default help file for &greename..
:p.
In section (Page) Help are stored titles of topics in English.inf and they are used as parameter when you press :hp2.Help:ehp2. button in &greename..
You should translate this section only if you want to
:link reftype=hd res=751.
translate source help file (English.ipf).
:elink.
Then items in Help section should be identical as translated titles in new IPF/INF file.
:nt.
After you added new Language support to &greename., I would appreciate if you send me new INI file, so I can include this file in next version of &greename..
:ent.
.*
.* Panel definition for:Translate help file
.*
:h1 id=751 res=751 x=left y=bottom width=100% height=100% group=2.Translate help file
:i1 id=751.Translate help file
:p.
:hp2.
To translate help file you need IPF compiler.
:ehp2.
:p.
If you want to translate English.ipf to your language, after you finished translation, make changes in Application "Language" in file CLOCK.INI.
:parml compact tsize=5.
:pt.
For example&colon.
:pd.
when you translated ENGLISH to MYLANG (where MYLANG is your Language), MYLANG.INI file is created.
When you translated English.ipf to Mylang.ipf and compile Mylang.ipf, Mylang.inf file is created.
.br
Edit in CLOCK.INI&colon.
.br
change in Application Language, Key MYLANG, Value English.inf to Mylang.inf.
:eparml.
:p.
Be sure you also translated Help section in MYLANG.INI.
In section (Page) Help are stored titles of topics help and they are used as parameter when you press :hp2.Help:ehp2. button in &greename..
Translate this section only when you translated source help file (English.ipf).
:nt.
After you translated help file, I would appreciate if you send me new IPF/INF file, so I can include this file in next version of &greename..
:ent.
.*
.* Panel definition : DSTswitch to World Clock Interface
.*
:h1 id=870 res=870  x=0% y=0% width=100% height=100%  group=1.DSTswitch to World Clock Interface
:i1 id=870.DSTswitch to World Clock Interface
.*
:p.
DSTswitch is an automatic time changing utility for OS/2 developed by Mark Eckstein.
DSTswitch enables you to synchronize the time between computers and automatically adjust system
clock when Standard time changes to Daylight Savings time and vice versa.
:p.
:hp2.Difference between World Clock and DSTswitch is&colon.:ehp2.
:ul.
:li.
&greename. calculates UTC (and local times for cities 2-9) from properties for 1st city (i.e. 1st city MUST be in your Time Zone for correct dispay of time and date).
&greename. does not use values from TZ environment variable in CONFIG.SYS.
.br
When Standard time changes to Daylight Savings time (and Daylight Savings to Standard), World clock does NOT adjust computer's system clock (you will just see message box).
You have to adjust system clock manually.
:li.DSTswitch calculates UTC from TZ environment variable in CONFIG.SYS.
.br
When Standard time changes to Daylight Savings time (and Daylight Savings to Standard), DSTswitch automatically adjusts system clock.
:eul.
:p.
In this archive (clock111.zip) is included DSTswitch to World Clock Interface (DSTsWClk.exe).
.br
If you have DSTswitch installed (and running), you can use calculated UTC from DSTswitch and select city from any Time Zone as 1st city.
To do this, first start DSTsWClk.exe, then start &greename..
Now you can select 1st city in any Time Zone, and time and date for all 9 cities will be displayed correctly.
:nt.
If you exit DSTswitch and/or DSTswitch to World Clock Interface (DSTsWClk.EXE) while &greename. is running,
UTC (and local times for cities 2-9) will be again calculated from DSTswitch (within next minute or two).
.br
Also, if you start  DSTswitch and DSTswitch to World Clock Interface (DSTsWClk.EXE) while &greename. is running,
UTC (and local times for cities 2-9) will be calculated from properties for 1st city (within next minute or two).
.br
:hp8.If you selected 1st city from different Time Zone (and do not use DSTswitch to World Clock Interface), local time and date for all 9 cities will be wrong.:ehp8.
:ent.
:p.
For more information about DSTswitch visit
:link reftype=launch object='Netscape.exe' data='http://www.mark-eckstein.de'.http&colon.//www.mark-eckstein.de:elink.
.*
.* Panel definition : Time Zones
.*
:h1 id=880 res=880  x=0% y=0% width=100% height=100%  group=1.Time Zones
:i1 id=880.Time Zones
.*
:p.
There are 25 integer World Time Zones from -12 through 0 to +12. Each one is 15&deg.
of Longitude as measured East and West from the Prime Meridian of the World at Greenwich,
England.
:p.
The armed forces give letters to time zones, where Z(ulu) = Zero meridian. Other letters/words
are used for&colon. A to M go eastwards and N to Y go westwards. The letter J is omitted.
:p.
There is no international standard that specifies descriptors for civil time zones
(sometimes the same descriptor is used for different time zones). Each country is free
to define its own names and declare ist own compliance to time zones (some countries
are 15, 30, and 45 minutes off of UTC).
.br
Some of Time Zone descriptors - for standard (ST) and summer (DST) time are&colon.
:table cols='10 8 6 6 45' rules=both frame=box.
:row.
:c.Code
:c.UTC+/-
:c.ST
:c.DST
:c.Example
:row.
:c.Y(ankee)
:c.-12&colon.00
:c. -
:c. -
:c.Pacific Ocean nations
:row.
:c.X(ray)
:c.-11&colon.00
:c. -
:c. -
:c.Pacific Ocean nations
:row.
:c.W(hisky)
:c.-10&colon.00
:c.:lines.
THT
HST
:elines.
:c.:lines.
THT
HST
:elines.
:c.:lines.
Tahiti
Hawaii
:elines.
:row.
:c.V(ictor)
:c.-09&colon.00
:c.YST
:c.YDT
:c.USA Alaska, Yukon
:row.
:c.U(niform)
:c.-08&colon.00
:c.PST
:c.PDT
:c.USA Pacific
:row.
:c.T(ango)
:c.-07&colon.00
:c.MST
:c.MDT
:c.Mataveri, USA Mountain
:row.
:c.S(ierra)
:c.-06&colon.00
:c.CST
:c.CDT
:c.Archipelago of Columbus, USA Central
:row.
:c.R(omeo)
:c.-05&colon.00
:c.EST
:c.EDT
:c.USA Eastern, Ecuador
:row.
:c.Q(Qebec)
:c.-04&colon.00
:c.:lines.
WST
AST
:elines.
:c.:lines.
WDT
ADT
:elines.
:c.
:lines.
Western Brazil
Andes, Antilles, Asuncion, USA Atlantic
:elines.
:row.
:c.P(apa)
:c.-03&colon.00
:c.:lines.
WGT
EST
:elines.
:c.:lines.
WGT
EDT
:elines.
:c.:lines.
Western Greenland
Eastern South America
:elines.
:row.
:c.O(scar)
:c.-02&colon.00
:c.:lines.
MGT
FST
:elines.
:c.:lines.
MGT
FDT
:elines.
:c.:lines.
Middle Greenland
Fernando de Noronha
:elines.
:row.
:c.N(ovember)
:c.-01&colon.00
:c.:lines.
EGT
ACT
AAT
:c.:lines.
EGT
ACT
AAT
:c.:lines.
Eastern Greenland
Azores and Canaries
Atlantic Africa
:row.
:c.Z(ulu)
:c.+00&colon.00
:c.:lines.
BST
IST
WAT
WET
:elines.
:c.:lines.
BDT
IDT
WAT
WDT
:elines.
:c.:lines.
Great Britain
Ireland
Western Africa
Western Europe
:elines.
:row.
:c.A(lpha)
:c.+01&colon.00
:c.:lines.
CAT
CET
:elines.
:c.:lines.
CAT
CDT
:elines.
:c.:lines.
Central Africa
Central Europe
:elines.
:row.
:c.B(ravo)
:c.+02&colon.00
:c.:lines.
EET
IST
SAT
:elines.
:c.:lines.
EEST
IDT
SAT
:elines.
:c.:lines.
Eastern Europe
Israel
South Africa
:elines.
:row.
:c.C(harlie)
:c.+03&colon.00
:c.:lines.
AST
EAT
MSK
:elines.
:c.:lines.
ADT
EAT
MSD
:elines.
:c.:lines.
Arabia
Eastern Africa
Moscow
:elines.
:row.
:c. -
:c.+03&colon.30
:c.IST
:c.IDT
:c.Iran
:row.
:c.D(elta)
:c.+04&colon.00
:c.:lines.
BSK
GST
KSK
SMT
:elines.
:c.:lines.
BSD
GDT
KSD
SMST
:elines.
:c.:lines.
Baku
Gulf
Kuybyshev
Seychelles and Mascarene Time
:elines.
:row.
:c. -
:c.+04&colon.30
:c.AFT
:c.AFT
:c.Afghanistan
:row.
:c.E(cho)
:c.+05&colon.00
:c.:lines.
ASK
ESK
PKT
:elines.
:c.:lines.
ASD
ESD
PKT
:elines.
:c.:lines.
Ashkhabad
Yekaterinburg
Pakistan
:elines.
:row.
:c. -
:c.+05&colon.30
:c.IST
:c.IST
:c.India
:row.
:c.F(oxtrot)
:c.+06&colon.00
:c.:lines.
BGT
NSK
OSK
TSK
:elines.
:c.:lines.
BGT
NSD
OSD
TSD
:elines.
:c.:lines.
Bengal, Bangladesh
Novosibirsk
Omsk
Tashkent
:elines.
:row.
:c. -
:c.+06&colon.30
:c.:lines.
BMT
CCT
:elines.
:c.:lines.
BMT
CCT
:elines.
:c.:lines.
Burma
Cocos
:elines.
:row.
:c.G(olf)
:c.+07&colon.00
:c.:lines.
ICT
JVT
TSK
:elines.
:c.:lines.
ICT
JVT
TSD
:elines.
:c.:lines.
Indochina
Java
Tomsk
:elines.
:row.
:c.H(otel)
:c.+08&colon.00
:c.:lines.
BNT
CST
ISK
PST
SGT
UST
WST
:elines.
:c.:lines.
BNT
CDT
ISD
PDT
SGT
UDT
WST
:elines.
:c.:lines.
Borneo, Brunei
China
Irkutsk
Philippines
Singapore
Ulan Bator
Western Australia
:elines.
:row.
:c.I(ndia)
:c.+09&colon.00
:c.:lines.
JST
KST
MLT
PLT
YSK
CST
:elines.
:c.:lines.
JST
KDT
MLT
PLT
YSD
CST
:elines.
:c.:lines.
Japan
Korea
Moluccas
Palau
Yakutsk
Central Australia
:elines.
:row.
:c.K(ilo)
:c.+10&colon.00
:c.:lines.
EST
GST
VSK
:elines.
:c.:lines.
EST
GST
VSD
:elines.
:c.:lines.
Eastern Australia
Guam
Vladivostok
:elines.
:row.
:c.L(ima)
:c.+11&colon.00
:c.:lines.
GSK
NCT
:elines.
:c.:lines.
GSD
NCD
:elines.
:c.:lines.
Magadan
New Caledonia
:elines.
:row.
:c. -
:c.+11&colon.30
:c.NRT
:c.NRT
:c.Norfolk
:row.
:c.M(ike)
:c.+12&colon.00
:c.:lines.
NZT
PSK
:elines.
:c.:lines.
NZD
PSD
:elines.
:c.:lines.
New Zealand
Petropavlovsk-Kamchatski
:elines.
:etable.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=720.Set TZ environment variable
:elink.
:li.
:link reftype=hd res=890.Glossary
:elink.
:esl.
.*
.* Panel definition : Glossary
.*
:h1 id=890 res=890  x=0% y=0% width=100% height=100%  group=1.Glossary
:i1 id=890.Glossary
:p.
Following information was compiled from various sources available freely on the Internet.
Credits are fully given to the known authors of any material that was used.
To find more information on the Internet, enter any of following term(s) in any search engine.
:parml tsize=5.
:i2 refid=890.ISO 8601
:pt.:hp2.ISO 8601:ehp2.
:pd.
International Standard ISO 8601 (first edition 1988-06-15) defines formats for numerical representation of
dates, times and date/time combinations, local time and Coordinated Universal Time (UTC).
.br
All date and time formats are represented with the largest units given first,
from left to right the ranking is year, month, week, day, hour, minute, second.
All values are fixed width, with leading zeros used as required.
:p.
Complete representation of calendar date shall be a single 8-digits numeric data in format CCYYMMDD,
where CCYY represents a calendar year, MM the ordinal number of calendar month within a calendar year
and DD the ordinal number of a day within the calendar month.
When required, hyphen (-) shall be used as separator. The space character shall not be used in the representation.
:p.
Complete representation of time shall be a single 6-digits numeric data in format hhmmss,
where hh represents hours, mm minutes and ss seconds.
When required, colon (&colon.) shall be used as separator. The space character shall not be used in the representation.
:p.
The ISO 8601 standard in PDF format can be found on :hp4.ftp&colon.//ftp.qsl.net/pub/g1smd/8601v03.pdf:ehp4.
:i2 refid=890.TZ
:i2 refid=890.Time Zone
:pt.:hp2.Time Zone (TZ):ehp2.
:pd.
There are 25 integer World Time Zones from -12 through 0 to +12. Each one is 15&deg.
of Longitude as measured East and West from the Prime Meridian of the World at Greenwich,
England. More about :link reftype=hd res=880.Time Zones:elink. and how to
:link reftype=hd res=720.set TZ environment variable:elink.
:i2 refid=890.DST
:i2 refid=890.Daylight Savings Time
:pt.:hp2.Daylight Saving Time (DST):ehp2.
:pd.
Daylight Saving Time (also called "summer time") is a method of advancing clocks in a global
manner, in order to artificially expand the daylight hours. In general, clocks are set forward
one hour in Spring and are set back one hour in Fall.
.br
There are no international standards for "saving time". Each country is free to define its
own rules.
:i2 refid=890.GMT
:i2 refid=890.Greenwich Mean Time
:pt.:hp2.Greenwich Mean Time (GMT):ehp2.
:pd.
Common standard for time calculations related to Greenwich, England.
Greenwich Mean Time is a widely used historical term, but one that has been used in several ways.
Because of the ambiguity, its use is no longer recommended in technical contexts.
:i2 refid=890.UTC
:i2 refid=890.Coordinated Universal Time
:pt.:hp2.Coordinated Universal Time (UTC):ehp2.
:pd.The times are often given in "Universal Time" (abbreviated UTC) which is sometimes referred to
"Greenwich Mean Time" (abbreviated GMT).
The two terms are often used loosely to refer to time kept on the Greenwich meridian (longitude zero).
Times given in UTC are almost always given in terms of a 24-hour clock.
.br
In the most common civil usage, UT refers to a time scale called "Coordinated Universal Time"
(abbreviated UTC), which is the basis for the worldwide system of civil time.
This time scale is kept by time laboratories around the world, and is determined using highly precise atomic clocks.
:i2 refid=890.UDT
:i2 refid=890.Universal Date &amp. Time
:pt.:hp2.Universal Date &amp. Time (UDT):ehp2.
:pd.Universal Time Organisation is promoting a metric based system that is co-ordinated on UTC.
The day is divided in to any metric number that is required, normally a thousand units or a million units.
The day number of the year and the year can be displayed, thus giving it a date format.
.br
They have developed a system called Universal Date &amp. Time (UDT) that can be used internationally and mean only one thing.
:i2 refid=890.Swatch beat
:i2 refid=890.Internet time
:pt.:hp2.Swatch beat - Internet time:ehp2.
:pd.Internet Time (inaugurated by Swatch in late 1998) represents a new global concept
of time. The Swatch Beat, the new unit of time means the following&colon.
.br
-   Day is divided into 1000 "beats". One Swatch beat is the equivalent of 86.4 seconds (1 minute 26.4 seconds).
That means that 12 noon is the equivalent of @500 Swatch beats.
.br
-   A new meridian in is created in Biel, Switzerland, home of Swatch. Biel Mean Time (BMT)
will be the universal reference for Internet Time. A day in Internet Time begins at midnight
BMT (@000 Swatch Beats). BMT = Central European Wintertime = CET = UTC + 1 hour.
:i2 refid=890.Latitude
:i2 refid=890.Longitude
:pt.:hp2.Latitude and longitude:ehp2.
:pd.
Latitude gives the location of a point north or south of the equator. It is measured in angles ranging from 0&deg. at the equator to 90&deg. at the poles.
.br
Longitude gives the location of a point east or west of a north-south line called the prime meridian, is measured in angles ranging from 0&deg. at the prime meridian to 180&deg. at the International Date Line.
.br
Each degree of latitude and longitude is divided into 60 minutes, and each minute divided into 60 seconds, thereby allowing the assignment of a precise numerical location to any point on earth.
.br
The east-west lines of latitude and the north-south line of longitude intersect at right angles to form a grid.
:i2 refid=890.Sunrise
:i2 refid=890.Sunset
:pt.:hp2.Sun rise and set:ehp2.
:pd.
Sunrise is the instant in the morning under ideal meteorological conditions, with standard refraction of the sun's rays, when the upper edge of the sun's disk is coincident with an ideal horizon.
.br
Sunset is the instant in the evening under ideal meteorological conditions, with standard refraction of the sun's rays, when the upper edge of the sun's disk is coincident with an ideal horizon.
.br
Atmospheric conditions are assumed to be average, and the location is in a level region on the Earth's surface.
:eparml.
:p.
:nt.
:hp2.Here may be incorrect data (UTC difference, DST begin/end, Time Zones, Time Zone descriptors and/or coordinates for some cities).:ehp2.
.br
I would appreciate if you :link refid=author reftype=fn.send corrections:elink.
:ent.
.*
.* Panel definition : Limitations
.*
:h1 id=800 res=800  x=0% y=0% width=100% height=100%  group=1.Limitations
:i1 id=800.Limitations
:hp8.
:caution.
DO NOT EDIT CLOCK.INI WITH ANY INI EDITOR WHILE WORLD CLOCK IS RUNNING !!!
:ecaution.
:ehp8.
:parml tsize=5.
:pt.:hp2.Bugs in OS/2 and Rexx:ehp2.
:pd.Under some environment (Warp3 with FP35 and FP38, Warp4 with FP10 and FP11) there are bugs in OS/2 and/or Rexx.
Known problems (until now) are&colon. time calculation and display on the World map for cities in western hemisphere may be wrong.
If you have problem like this, check selected city (sometimes is longidude displayed in East), select correct values and save changes.
:pt.:hp2.Time delay in changes:ehp2.
:pd.&greename. is reading system date &amp. time from your computer's internal clock once in a minute (at 00 sec) to reduce CPU usage.
Some changes you made (selected time display in Title bar, start or end DSTswitch to &greename. Interface ...) will be visible in next minute.
If you can't wait so long, exit &greename. and start it again.
:pt.:hp2."Classic" vs. Object Rexx:ehp2.
:pd.&greename. can run under "Classic" or Object Rexx. If you have Object Rexx installed, performance is significantly slower (loading time is about 3x longer, etc.)
:pt.:hp2.FastIni.dll:ehp2.
:pd.FastIni.dll is library for fast acces to OS/2 INI files.
As &greename. stores all information in CLOCK.INI file (settings, cities ...), it is recommended to use this file (copy it to directory in LIBPATH statement in CONFIG.SYS, or keep it in &greename.'s directory).
&greename. can run without this library, but performance will be slower.
:pt.:hp2.Calculating date / time:ehp2.
:pd.
&greename. calculates UTC (and local dates/times for cities 2-9) from properties for 1st city
(it MUST be in your Time Zone for correct date &amp. time display for other cities).
If you are using :link reftype=hd res=870.DSTswitch to World Clock Interface.:elink.
(and if you have DSTswitch installed) you can select any city in any Time Zone as 1st city.
To do this, first start DSTswitch, then DSTsWClk.exe and finally &greename..
Now you can select 1st city in any Time Zone, and time and date for all 9 cities will be displayed correctly.
:pt.:hp2.Set System clock to UTC:ehp2.
:pd.
If you set computer's system clock to UTC, local time for cities will be calculated from computer's
time and (in most cases) local time for 1st city and computer's system time will be different.
.br
OS/2 does not use TZ envrionment variable and computer's time is always used when writing datestamp and timestamp for files, etc.
If other programs on your computer use TZ environment variable, they'll probably calculate wrong local time, if you set system clock to UTC.
.br
If you work with somebody in different Time Zone, maybe you want to synchronize computer's clocks.
:pt.:hp2.Daylight Savings time:ehp2.
:pd.
When Standard time changes to Daylight Savings time (and Daylight Savings to Standard), World clock does NOT adjust computer's system clock (you will just see message box).
You have to adjust system clock manually, or use some utility to do this (like DSTswitch).
:pt.:hp2.Distances in World map:ehp2.
:pd.
Formulas for distance calculation are using spherical coordinates on the earth.
They don't take into account the squashed nature of the earth (it is kind of fat around the equator, as a result of the centrifugal force it gets from spinning on its axis).
So that will throw a little error into these calculations.
Size of World map is 721 (width) * 361 (height) pixels (1&deg. = 2 pixels) and the smallest distance between two location you can select is 1 pixel or 30 minutes (about 55-56 km).
:pt.:hp2.Sun rise and set:ehp2.
:pd.
The times of rise and set cannot be precisely computed, because the actual times depend on unpredictable atmospheric conditions that affect the amount of refraction at the horizon.
.br
There are some errors in calculating the times of sunrise/sunset at high latitudes (> 66.5&deg.).
These errors are due to the algorithms used and if there is latitude for city higher than 66.5&deg., sunrise/sunset is calculated for latitude 66.5&deg..
:pt.:hp2.Possible errors:ehp2.
:pd.
Here may be incorrect data (UTC difference, DST begin/end, Time Zones, Time Zone descriptors and/or coordinates) for some cities/countries.
I would appreciate if you :link refid=author reftype=fn.send corrections:elink..
:eparml.
:p.
All &greename.'s settings are saved in file CLOCK.INI.
If some of then are missing or wrong, program loads default settings and writes them to CLOCK.INI.
.*
.* Panel definition : Troubleshooting
.*
:h1 id=850 res=850  x=0% y=0% width=100% height=100%  group=1.Troubleshooting
:i1 id=850.Troubleshooting
:hp8.
:caution.
DO NOT EDIT CLOCK.INI WITH ANY INI EDITOR WHILE WORLD CLOCK IS RUNNING !!!
:ecaution.
:ehp8.
:hp2.If you find bug in program, or if DrRexx screen pop up with SYNTAX ERROR message,
try this&colon.:ehp2.
:ol.
:li.:hp8.READ THE MANUAL please:ehp8. - maybe you find some useful information &colon.-)
:li.If &greename. is still running, select Settings from PopUp menu, and press :hp2.Default settings:ehp2. button, exit program and start it again.
:li.If &greename. is not running, start &greename. with parameter D (:hp2.Clock.exe D:ehp2.). &greename. will load default settings.
:li.Edit CLOCK.INI with INI editor and delete following Applications (sections)&colon.
:ul compact.
:li.Settings
:li.SelCity
:li.Alarm
:li.Launch
:eul.
:p.
Then start &greename. with parameter D (:hp2.Clock.exe D:ehp2.) again -  program will load default settings.
Your settings will be lost, but program should work.
.br
:hp8.DO NOT delete &greename.'s related Keys and Values in USER (OS2.INI) file (Application&colon. ToolsByGoran) !:ehp8.
:li.:link refid=author reftype=fn.Visit my Home page:elink. to see if there is any bug fix or update.
:li.:link refid=author reftype=fn.Send me a message:elink. with following information&colon.
:ol compact.
:li.OS/2 version (and FixPak) you are using,
:li.Rexx ("classic" or Object Rexx),
:li.&greename. version you are using,
:li.Description of bug or error (and SYNTAX ERROR message from DrRexx dialog).
:eol.
:p.
I will try to help you and correct error.
:eol.
:p.
:hp5.Related topics&colon.:ehp5.
:sl compact.
:li.
:link reftype=hd res=210.Install
:elink.
:li.
:link reftype=hd res=510.Default settings
:elink.
:esl.
.*
.* Panel definition : Copyright and contact
.*
:h1 id=900 res=900  x=0% y=0% width=100% height=100%  group=1.Copyright and contact
:i1 id=900.Copyright and contact
:dl compact tsize=15.
:dthd.:hp2.Author:ehp2.
:ddhd.Goran Ivankovic
:dt.:hp2.Address:ehp2.
:dd.Ulica Josipa Poduje 8
:dt.
:dd.HR-52100 Pula
:dt.
:dd.Croatia
:dt.:hp2.email:ehp2.
:dd.:link reftype=launch object='netscape.exe' data='mailto:duga1@pu.tel.hr?subject=World Clock 1.11'.duga1@pu.tel.hr:elink.
:dt.:hp2.Home page:ehp2.
:dd.:link reftype=launch object='Netscape.exe' data='http://redrival.com/os2util/'.http&colon.//redrival.com/os2util/:elink.
:edl.
:p.
:hp2.&greename.:ehp2. is free software but it is :hp2.not:ehp2. public domain.
The author retains all copyright to the application and all files within it.
:p.
You may use :hp2.&greename.:ehp2. yourself and you may distribute it to others
so long as all files are left unchanged. You may not distribute :hp2.&greename.:ehp2.
in any way which leads to your making a profit from it. This means that you can
only charge enough to cover the costs of media, postage etc. involved in distribution.
Also you may not use it as an incentive to buy something else. If you are in any
doubt you should contact the author.
:p.
The author's permission must be obtained before :hp2.&greename.:ehp2. is included
on a magazine disc and P.D. libraries. You should, as a matter of courtesy,
inform the author when you are planning to distribute the application and
send one copy of magazine disc to the author.
:p.
The author makes no representations about the accuracy or suitability of
this material for any purpose. It is provided "as is", without any
express or implied warranties. The author will assume no liability for
damages either from the direct use of this product or as a consequence of
the use of this product.
:parml tsize=5.
:pt.:hp2.Thanks to all users for ideas, comments, corrections, suggestions and bug reports.:ehp2.
:pt.:hp7.Special thanks to&colon.:ehp7.
:dl compact tsize=20.
:dt.Klaus Staedtler
:dd.translated World Clock to German, created new World maps, idea, support and nice icons
:dt.Mark Eckstein
:dd.DSTswitch to World Clock Interface, additional information about TZ environment variable
:dt.Brian Crook
:dd.tested World Clock under Object Rexx, useful information about UTC
:dt.David Coward
:dd.tested World map
:dt.Bjrn Sderstrm
:dd.translated World Clock to Swedish
:dt.Przemysaw Paweczyk
:dd.translated World Clock to Polish
:edl.
:eparml.
:ul compact.
:li.OS/2 is Trademark of International Bussines Machines Corporation
:li.DrDialog is Copyright of International Bussines Machines Corporation
:li.FastIni.dll is Copyright of Dennis Bareis - OS/2 Developer in Australia
:li.DSTswitch and DSTsWClk (DSTswitch to World Clock Interface) is copyright of Mark Eckstein
:li.World maps are copyrighted by Jet Propulsion Laboratory, California Institute of Technology, Pasadena, CA.
:eul.
.*
.* Panel definition : Sources
.*
:h1 id=910 res=910  x=0% y=0% width=100% height=100%  group=1.Sources
:i1 id=910.Sources
:p.
Information about Time Zones, Daylight Savings Time, Internet Time, latitudes and longitudes, sunrise/sunset ... was compiled from various sources available freely on the Internet.
Credits are fully given to the known authors of any material that was used.
:p.
To find more information on the Internet, visit&colon.
:dl compact tsize=45.
:dt.Greenwich Time: GMT
:dd.:link reftype=launch object='Netscape.exe' data='http://time.greenwich2000.com/'.http&colon.//time.greenwich2000.com/:elink.
:dt.Time Service Department
:dd.:link reftype=launch object='Netscape.exe' data='http://tycho.usno.navy.mil/'.http&colon.//tycho.usno.navy.mil/:elink.
:dt.WORLDTIME: interactive atlas, time info
:dd.:link reftype=launch object='Netscape.exe' data='http://www.worldtime.com/'.http&colon.//www.worldtime.com/:elink.
:dt.The NIST Time and Frequency Division
:dd.:link reftype=launch object='Netscape.exe' data='http://www.bldrdoc.gov/timefreq/index.html'.http&colon.//www.bldrdoc.gov/timefreq/index.html:elink.
:dt.Universal Time Organisation
:dd.:link reftype=launch object='Netscape.exe' data='http://www.universal-time.org/'.http&colon.//www.universal-time.org/:elink.
:dt.Internet Time - Swatch
:dd.:link reftype=launch object='Netscape.exe' data='http://www.swatch.com/internettime/internettime.php3'.http&colon.//www.swatch.com/internettime/internettime.php3:elink.
:dt.Online Map Creation
:dd.:link reftype=launch object='Netscape.exe' data='http://www.aquarius.geomar.de/omc/'.http&colon.//www.aquarius.geomar.de/omc/:elink.
:dt.Find Latitude and Longitude for your city
:dd.:link reftype=launch object='Netscape.exe' data='http://www.nima.mil/gns/html/'.http&colon.//www.nima.mil/gns/html/:elink.
:dt.Sunrise, Sunset and Twilight Times
:dd.:link reftype=launch object='Netscape.exe' data='http://www.auslig.gov.au/geodesy/astro/sunrise.htm'.http&colon.//www.auslig.gov.au/geodesy/astro/sunrise.htm:elink.
:dt.Ssystem&colon. OpenGL Solar System Simulator
:dd.:link reftype=launch object='Netscape.exe' data='http://www1.las.es/~amil/ssystem/'.http&colon.//www1.las.es/~amil/ssystem/:elink.
:edl.
.*
:fn id=author.
:dl compact tsize=15.
:dthd.:hp2.Author:ehp2.
:ddhd.Goran Ivankovic
:dt.:hp2.Address:ehp2.
:dd.Ulica Josipa Poduje 8
:dt.
:dd.HR-52100 Pula
:dt.
:dd.Croatia
:dt.:hp2.email:ehp2.
:dd.:link reftype=launch object='netscape.exe' data='mailto:duga1@pu.tel.hr?subject=World Clock 1.11'.duga1@pu.tel.hr:elink.
:dt.:hp2.Home page:ehp2.
:dd.:link reftype=launch object='Netscape.exe' data='http://redrival.com/os2util/'.http&colon.//redrival.com/os2util/:elink.
:edl.
:efn.
.*
:euserdoc.
