//  System Defined C Headers
# include <errno.h>
# include <stddef.h>


//  IBM OS2 Defined C Headers
# define  INCL_DOSERRORS
# define  INCL_DOSSEMAPHORES
# include <os2.h>


//  Application Defined C++ Headers
# include "resdefs.h"


//  System Defined C++ Headers
# include <iostream.h>


//  IBM OCL Defined C++ Headers
# include <icmdhdr.hpp>
# include <iexcept.hpp>
# include <iframe.hpp>
# include <iframhdr.hpp>
# include <ilistbox.hpp>
# include <imenubar.hpp>
# include <imle.hpp>
# include <imsgbox.hpp>
# include <irect.hpp>
# include <istattxt.hpp>
# include <isrtset.h>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <commwin.hpp>
# include <mlewin.hpp>
# include <showexp.hpp>
# include <sortstrn.hpp>
# include <templptr.hpp>


//  Application Defined C++ Headers
# include "clidb.hpp"
# include "strngdlg.hpp"
# include "waitdlg.hpp"
# include "qrywin.hpp"



int main () 
{
  CLIDatabase   clidb       ;
  int           nErrId  = 0 ;

  try
  {
    QueryWindow   mainwindow
                    (
                    WID_MAIN                      ,
                    WID_QUERY_MLE                 ,
                    IWindow :: desktopWindow  ()  ,
                    IWindow :: desktopWindow  ()  ,
                    clidb
                    ) ;

    IApplication :: current ().run () ;

  } /* endtry */
  catch ( IException & riex )
  {
    showException ( riex ) ;

    nErrId  = riex.errorId () ;

  } /* endcatch ( IException & riex ) */
  catch ( ... )
  {
    cerr << "Unknown error 'catch ( ... )' caught in " << IEXCEPTION_LOCATION () << endl ;

    nErrId  = -1 ;

  } /* endcatch ( ... ) */

  return  nErrId ;

} /* int main () */
