//  System Defined C Headers
# include <stddef.h>


//  OS/2 Defined C Headers
# include <os2.h>



//  Application Defined C Headers
# include <strfcns.h>
# include <strngdlg.h>


//  IBM OCL Defined C++ Headers
# include <icmdhdr.hpp>
# include <iframe.hpp>
# include <imenubar.hpp>
# include <istattxt.hpp>
# include <istring.hpp>
# include <ititle.hpp>


//  Locally Defined C++ Headers
# include <commwin.hpp>
# include <waitdlg.hpp>



WaitDialog :: WaitDialog ( const IResourceId & rciresid , IWindow * pwinOwner , IWindow * pwinParent , const char * cszMsg )
  : DialogBox ( rciresid , pwinOwner , pwinParent ) , istattext ( DID_WAIT_TEXT , this )
{
  if ( strIsValid ( cszMsg ) )
  {
    setMessage ( cszMsg ) ;

  } /* endif */

} /* WaitDialog :: WaitDialog ( const IResourceId & , IWindow * , IWindow * , const char * ) */



const char * WaitDialog :: message () const
{
  return  staticText ().text () ;

} /* const char * WaitDialog :: message () const */



const char * WaitDialog :: setMessage ( const char * cszMsg )
{
  staticText ().setText ( cszMsg ) ;

  return  message () ;

} /* const char * WaitDialog :: setMessage ( const char * cszMsg ) */



const IStaticText & WaitDialog :: staticText () const
{
  return  istattext ;

} /* const IStaticText & WaitDialog :: staticText () const */



IStaticText & WaitDialog :: staticText ()
{
  return  istattext ;

} /* const char * WaitDialog :: staticText () */
