//  OS/2 Defined C Headers
# include <os2.h>


//  Locally Defined C Headers
# include <strngdlg.h>


//  IBM OCL Defined C++ Headers
# include <icmdhdr.hpp>
# include <ifont.hpp>
# include <iframe.hpp>
# include <ilistbox.hpp>
# include <imenubar.hpp>
# include <imoushdr.hpp>
# include <isrtset.h>
# include <istring.hpp>
# include <ititle.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <commwin.hpp>
# include <gblfont.hpp>
# include <cliklist.hpp>
# include <sortstrn.hpp>
# include <strngdlg.hpp>




StringDialog :: StringDialog ( const IResourceId & rciresid , IWindow * piwinOwner , IWindow * piwinParent )
  : DialogBox ( rciresid , piwinOwner , piwinParent ) , ilistStrings ( DID_STRING_BOX , this ) , istrgSelected ( "" )
{
  listbox ().setFont ( cifontGblSystemMono ) ;

} /* StringDialog :: StringDialog ( const IResourceId & rciresid , IWindow * piwinOwner , IWindow * piwinParent ) */



IBoolean StringDialog :: command ( ICommandEvent & ricmdevt )
{
  IBoolean  bEventProcessed = true                  ; //  Assume event will be processed  
  long      lSelectIndex    = 0                     ;
  ULONG     ulCommand       = ricmdevt.commandId () ; //  Get the command into an easily viewed (for debugger) variable

  switch ( ulCommand )
  {
    case  DID_OK     :
      lSelectIndex = listbox ().selection () ;

      if ( IBaseListBox :: notFound != lSelectIndex )
      {
        //  Put the selected string into a local variable so we can see it in the debugger
        IString   istrgSelected = listbox ().itemText ( lSelectIndex ) ;

        setString ( istrgSelected ) ;

      } /* endif */

    case  DID_CANCEL :
      dismiss ( 0 ) ;
      break ;

    default           :
      bEventProcessed  = false ;

  } /* endswitch */

  return  bEventProcessed ;

} /* IBoolean StringDialog :: command ( ICommandEvent & ricmdevt ) */



IListBox & StringDialog :: listbox ()
{
  return  ilistStrings  ;

} /* IListBox & StringDialog :: listbox () */



void StringDialog :: selectString ( const SortedIStrings & rciset )
{
  int   n ;

  //  Always reinitialize the selected string to ""
  setString ( "" ) ;

  //  Fill the listbox with the strings in the supplied set
  for ( n = 1 ; n <= rciset.numberOfElements () ; n++ )
  {
    listbox ().addAscending ( rciset.elementAtPosition ( n ) ) ;

  } /* endfor */

  //  Select the first string
  listbox ().select ( 0 ) ;

  showModally () ;

} /* void StringDialog :: selectString ( const SortedIStrings & rciset ) */


const char * StringDialog :: setString ( const char * cszNewVal )
{
  return  istrgSelected = cszNewVal ;

} /* const char * StringDialog :: setString ( const char * cszNewVal ) */



const char * StringDialog :: string () const
{
  return  istrgSelected ;

} /* const char * StringDialog :: string () const */
