
//  IPrivateResource does not work under all versions of AIX, this is  our substitute.  Therefore we allow substitution of
//  our local header "creslock.hpp" under AIX. This conditional will get us by until it becomes available under AIX!
//  Note that "creslock.hpp" includes the AIX header "pthread.h".  Per the AIX programming documentation, "pthread.h"MUST
//  be the first file included, thus we must put this conditional compilation expression at the top of the file.
# ifdef _AIX
  //  Locally Defined C++ Headers
  # include <creslock.hpp>
# else
  //  IBM OCL Defined C++ Headers
  # include <ireslock.hpp>
# endif /* # ifdef _AIX */


//  System Defined C Headers
# include <errno.h>
# include <stddef.h>


//  IBM DB2 Defined C Headers
# include <sqlcli1.h>


//  IBM OS2 Defined C Headers
# include <os2.h>


//  Locally Defined C Headers
# include <mledefs.h>
# include <strngdlg.h>


//  Application Defined C Headers
# include <resdefs.h>


//  System Defined C++ Headers
# include <fstream.h>


//  IBM OCL Defined C++ Headers
# include <icmdhdr.hpp>
# include <iexcept.hpp>
# include <ifiledlg.hpp>
# include <ifont.hpp>
# include <iframe.hpp>
# include <iframhdr.hpp>
# include <ilistbox.hpp>
# include <imenubar.hpp>
# include <imle.hpp>
# include <imoushdr.hpp>
# include <imsgbox.hpp>
# include <irect.hpp>
# include <ireslib.hpp>
# include <istattxt.hpp>
# include <istring.hpp>
# include <ititle.hpp>

# ifdef _USE_MULTITHREADS
  # include <ithread.hpp>
# endif   /* # ifdef _USE_MULTITHREADS */


//  Locally Defined C++ Headers
# include <checkmem.hpp>
# include <namedobj.hpp>
# include <templary.hpp>
# include <templptr.hpp>
# include <gblfont.hpp>
# include <commwin.hpp>
# include <dbaseobj.hpp>
# include <threadobj.hpp>
# include <dbconn.hpp>
# include <cliconn.hpp>
# include <cliklist.hpp>
# include <sortstrn.hpp>
# include <sqlstmt.hpp>
# include <clistmt.hpp>
# include <clidb.hpp>
# include <mlewin.hpp>
# include <showexp.hpp>
# include <msgexp.hpp>
# include <strngdlg.hpp>




//  Application Defined C++ Headers
# include <waitdlg.hpp>
# include <qrywin.hpp>




# ifdef _USE_MULTITHREADS
  typedef IThreadMemberFn < QueryWindow > QueryWinThreadFcn ;
# endif   /* # ifdef _USE_MULTITHREADS */




ApplicationMLEWindow :: ApplicationMLEWindow
  (
  const IResourceId           & rciresidWin ,
  const IResourceId           & rciresidMLE ,
  MLEWindow                   * pmlewinNext ,
  const IFrameWindow :: Style & rcstyle     ,
  IWindow                     * pwinOwner   ,
  IWindow                     * pwinParent
  )
  : MLEWindow ( rciresidWin , rciresidMLE , pwinOwner , pwinParent , rcstyle ) ,
    mlewinptr ( pmlewinNext )
{
  mle ().setFont        ( cifontGblSystemMono ) ;
  mle ().enableWordWrap ( false )               ;

} /* ApplicationMLEWindow :: ApplicationMLEWindow */



Boolean ApplicationMLEWindow :: dispatchHandlerEvent ( IEvent & rievent )
{
  if ( WM_DESTROY == rievent.eventId () )
  {
    nextWin ().close  ()  ;

  } /* endif */

  return  IFrameHandler :: dispatchHandlerEvent ( rievent ) ;

} /* Boolean ApplicationMLEWindow :: dispatchHandlerEvent ( IEvent & rievent ) */



MLEWinPtr & ApplicationMLEWindow :: mleWinPtr ()
{
  return  mlewinptr ;  

} /* MLEWinPtr & ApplicationMLEWindow :: mleWinPtr () */



const MLEWinPtr & ApplicationMLEWindow :: mleWinPtr () const 
{
  return  mlewinptr ;  

} /* const MLEWinPtr & ApplicationMLEWindow :: mleWinPtr () const */



MLEWindow & ApplicationMLEWindow :: nextWin ()
{
  return  mleWinPtr ()  ;

} /* MLEWindow & ApplicationMLEWindow :: nextWin () */



const MLEWindow & ApplicationMLEWindow :: nextWin () const
{
  return  mleWinPtr ()  ;

} /* const MLEWindow & ApplicationMLEWindow :: nextWin () const */



void ApplicationMLEWindow :: nextWinCmd ()
{
  nextWin ().setFocus () ;

} /* void ApplicationMLEWindow :: nextWinCmd () */



const MLEWindow & ApplicationMLEWindow :: setNextWin ( MLEWindow * pmlewin )
{
  return  * mlewinptr.init ( pmlewin ) ;

} /* const MLEWindow & ApplicationMLEWindow :: setNextWin ( MLEWindow * pmlewin ) */



QueryWindow :: QueryWindow
  (
  const IResourceId           & rciresidWin ,
  const IResourceId           & rciresidMLE ,
  CLIDatabase                 & rclidbInit
  )
  : ApplicationMLEWindow  ( rciresidWin , rciresidMLE , 0 ) ,
    rclidb                ( rclidbInit )                    ,
    waitdlg               ( DLG_WAIT    , this , this )
{
  IFrameHandler :: handleEventsFor ( this ) ;

  ResultsWindow   * preswin = new ResultsWindow ( WID_RESLT , WID_RESLT_MLE , this ) ;

  setNextWin  ( preswin )     ;
  show        ()              ;
  mle         ().setFocus ()  ;

} /* QueryWindow :: QueryWindow ( ULONG , ULONG , IFrameWindow * , IFrameWindow * , const IRectangle & , const IFramewindow :: style ) */



QueryWindow :: ~QueryWindow ()
{
  IFrameHandler :: stopHandlingEventsFor ( this ) ;

} /* QueryWindow :: ~QueryWindow () */



CLIDatabase & QueryWindow :: clidatabase ()
{
  return  rclidb  ;

} /* CLIDatabase & QueryWindow :: clidatabase () */



IBoolean QueryWindow :: command ( ICommandEvent & ricmdevt )
{
  IBoolean  bEventProcessed = true                  ; //  Assume event will be processed  
  ULONG     ulCommand       = ricmdevt.commandId () ; //  Get the command into an easily viewed (for debugger) variable

  switch ( ulCommand )
  {
    case  MID_CONNECT   :
      connectCmd  ()  ;
      break ;
                     
    case  MID_NEXT_WIN  :
      if ( nextWin ().isVisible () )
      {
        nextWinCmd  ()  ;        

      } /* endif */

      break ;

    case  MID_RUN       :
      if ( clidatabase ().isConnected () )
      {
        runQueryCmd ()  ;

      } /* endif */

      break ;

    default             :
      bEventProcessed  = false ;

  } /* endswitch */

  return  bEventProcessed ;

} /* IBoolean QueryWindow :: command ( ICommandEvent & ricmdevt ) */


void QueryWindow :: connectCmd ()
{
# ifdef _USE_MULTITHREADS
  QueryWinThreadFcn   * pquerywinthreadfcn  = new QueryWinThreadFcn ( * this , connectThread ) ;

  IThread               ithread ( pquerywinthreadfcn , true ) ;
# else
  connectThread () ;

# endif   /* # ifdef _USE_MULTITHREADS */

} /* void QueryWindow :: connectCmd () */



void QueryWindow :: connectDb ( const char * cszDbName )
{
  try
  {
    IResourceLibrary  ireslib     = IApplication :: current ().userResourceLibrary ()   ;
    IString           istrgMsg    = ireslib.loadString ( SID_CONNECT_TRY ) + cszDbName  ;

    waitDialog  ().setMessage ( istrgMsg )  ;
    waitDialog  ().show       ()            ;
    waitDialog  ().setFocus   ()            ;
    clidatabase ().setServer  ( cszDbName ) ;
    clidatabase ().connect    ()            ;
    waitDialog  ().hide       ()            ;

  } /* endtry */
  catch ( IException & riex )
  {
    showException ( riex ) ;

  } /* endcatch ( IException & riex ) */

} /* void QueryWindow :: connectDb ( const char * cszDbName ) */



void QueryWindow :: connectThread ()
{
  try
  {
    IResourceLibrary  ireslib     = IApplication :: current ().userResourceLibrary ()       ;
    IString           istrgDbName ( "" ) ;
    SortedIStrings    srtset      ;

    getDbNames    ( srtset )    ;

    StringDialog  stringdialog  ( DLG_STRINGS , IFrameWindow :: desktopWindow () , this ) ;

    stringdialog.selectString ( srtset )    ;

    istrgDbName   = stringdialog.string ()  ;
    istrgDbName   = istrgDbName.word    ( 2 ) ;

    if ( 0 == istrgDbName.length () )
    {
      return  ;

    } /* endif */

    connectDb ( istrgDbName ) ;

    if ( clidatabase ().isConnected () )
    {
      IString   istrgMsg    = ireslib.loadString ( SID_DB_CONNECT_OK ) + istrgDbName  ;
      IString   istrgTitle  = ireslib.loadString ( WID_MAIN ) + ireslib.loadString ( SID_DB_CONNECT_TITLE ) + istrgDbName  ;

      menubar     ().enableItem ( MID_RUN     ) ;
      title       ().setText    ( istrgTitle  ) ;
      showMessage ( this , istrgMsg )           ;
    } /* endif */
    else
    {
      IString   istrgMsg  = ireslib.loadString ( SID_DB_CONNECT_BAD ) + istrgDbName  ;

      menubar     ().disableItem ( MID_RUN )  ;
      showMessage ( this , istrgMsg )         ;

    } /* endelse */
  
  } /* endtry */
  catch ( IException & riex )
  {
    showException ( riex ) ;

  } /* endcatch ( IException & riex ) */

  setFocus  ()  ;

} /* void QueryWindow :: connectThread () */



void QueryWindow :: getDbNames ( SortedIStrings & rsrtset )
{
  IResourceLibrary  ireslib     = IApplication :: current ().userResourceLibrary ()   ;
  IString           istrgMsg    = ireslib.loadString ( SID_GETTING_DB_NAMES )         ;

  rsrtset.removeAll ()  ;

  waitDialog  ().setMessage       ( istrgMsg  ) ;
  waitDialog  ().show             ()            ;
  waitDialog  ().setFocus         ()            ;
  clidatabase ().getDatabaseInfos ( rsrtset   ) ;
  waitDialog  ().hide             ()            ;

} /* void QueryWindow :: initDbNames () */



void QueryWindow :: runQueryCmd ()
{
# ifdef _USE_MULTITHREADS
  QueryWinThreadFcn   * pquerywinthreadfcn  = new QueryWinThreadFcn ( * this , runQueryThread ) ;

  IThread               ithread ( pquerywinthreadfcn , true ) ;
# else
  runQueryThread () ;

# endif   /* # ifdef _USE_MULTITHREADS */

} /* void QueryWindow :: runQueryCmd () */



void QueryWindow :: runQueryThread ()
{
  try
  {
    //  Get the text from the MLE MINUS any leading or trailing whitespace
    IString   istrgSQL  = mle ().text ().strip  () ;
    unsigned  uLength   = istrgSQL.length       () ;

    //  If the last character is a ';' remove it, and decrement the length variable.  Many sql processors require ';' as a
    //  statement terminator, but is will cause an error under CLI!
    if ( ';' == istrgSQL [uLength] )
    {
      istrgSQL = istrgSQL.subString ( 1 , --uLength ) ;

    } /* endif */

    if ( 0 == uLength )
    {
      IMessageBox   imsgbox ( this ) ;

      imsgbox.setTitle  ( SID_WARNING ) ;
      imsgbox.show      ( SID_SQL_NO_TEXT   , IMessageBox :: information ) ;

      return  ;

    } /* endif */

    IResourceLibrary  ireslib   = IApplication :: current ().userResourceLibrary () ;
    IString           istrgFile = ireslib.loadString ( SID_RESLTS_FILE ) ;
    IString           istrgMsg  = ireslib.loadString ( SID_RUNNING_QRY ) ;

    waitDialog  ().setMessage ( istrgMsg )              ;
    waitDialog  ().show       ()                        ;
    waitDialog  ().setFocus   ()                        ;
    clidatabase ().runQuery   ( istrgSQL  , istrgFile ) ;
    waitDialog  ().hide       ()                        ;

    menubar     ().enableItem ( MID_NEXT_WIN )                ;
    nextWin     ().mle        ().removeAll      ()            ;
    nextWin     ().mle        ().importFromFile ( istrgFile , IMultiLineEdit :: MLEFormat ) ;
    nextWin     ().mle        ().setTop         ( 0 )         ;
    nextWin     ().show       ()                              ;
    nextWin     ().setFocus   ()                              ;

  } /* endtry */
  catch ( IException & riex )
  {
    showException ( riex ) ;

  } /* endcatch ( IException & riex ) */

} /* void QueryWindow :: runQueryThread () */



WaitDialog & QueryWindow :: waitDialog ()
{
  return  waitdlg ;

} /* WaitDialog & QueryWindow :: waitDialog () */



ResultsWindow :: ResultsWindow
  (
  const IResourceId           & rciresidWin ,
  const IResourceId           & rciresidMLE ,
  MLEWindow                   * pmlewinNext ,
  const IFrameWindow :: Style & rcstyle     ,
  IWindow                     * pwinOwner   ,
  IWindow                     * pwinParent
  )
  : ApplicationMLEWindow ( rciresidWin , rciresidMLE , pmlewinNext , rcstyle , pwinOwner , pwinParent )
{
  //  Do not want to automatically destroy the next window pointer in this case
  mleWinPtr ().shouldDestroy      ( false ) ;
  mle       ().disableDataUpdate  ()        ;

} /* ResultsWindow :: ResultsWindow ( ULONG , ULONG , IFrameWindow * , IFrameWindow * , const IRectangle & , const IFramewindow :: style ) */



IBoolean ResultsWindow :: command ( ICommandEvent & ricmdevt )
{
  IBoolean  bEventProcessed = true                  ; //  Assume event will be processed  
  ULONG     ulCommand       = ricmdevt.commandId () ; //  Get the command into an easily viewed (for debugger) variable

  switch ( ulCommand )
  {
    case  MID_NEXT_WIN  :
      nextWinCmd  ()  ;
      break ;

    default           :
      bEventProcessed  = false ;

  } /* endswitch */

  return  bEventProcessed ;

} /* IBoolean ResultsWindow :: command ( ICommandEvent & ricmdevt ) */


