//  System Defined C Headers
# include <errno.h>
# include <stddef.h>


//  IBM OS2 Defined C Headers
# include <os2.h>   //  For definition of ULONG , etc.


//  Locally Defined C Headers
# include <strfcns.h>


//  Application Defined C Headers
# include <mledefs.h>


//  System Defined C++ Headers
# include <iostream.h>


//  IBM OCL Defined C++ Headers
# include <icmdhdr.hpp>
# include <iexcept.hpp>
# include <ifiledlg.hpp>
# include <ifont.hpp>
# include <ifontdlg.hpp>
# include <iframe.hpp>
# include <imenubar.hpp>
# include <imle.hpp>
# include <imsgbox.hpp>
# include <irect.hpp>
# include <ititle.hpp>

# ifdef _USE_MULTITHREADS
  # include <ithread.hpp>
# endif   /* # ifdef _USE_MULTITHREADS */


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <commwin.hpp>
# include <templptr.hpp>
# include <mlewin.hpp>
# include <showexp.hpp>
# include <msgexp.hpp>




# ifdef _USE_MULTITHREADS
  typedef IThreadMemberFn < MLEWindow > MLEWinThreadFcn ;
# endif   /* # ifdef _USE_MULTITHREADS */



MLECommandHandler :: MLECommandHandler ( MLEWindow & rimlewinNew ) : rimlewin ( rimlewinNew )
{

} /* MLECommandHandler :: MLECommandHandler ( MLEWindow & rimlewindowNew ) */



IBoolean MLECommandHandler :: command ( ICommandEvent & ricmdevt )
{
  IBoolean  bEventProcessed = true                  ; //  Assume event will be processed  
  ULONG     ulCommand       = ricmdevt.commandId () ; //  Get the command into an easily viewed (for debugger) variable

  switch ( ulCommand )
  {
    case  MID_COPY          :
      mleWindow ().copyCmd        ()  ;
      break ;

    case  MID_CUT           :
      mleWindow ().cutCmd         ()  ;
      break ;

    case  MID_DESELECT_ALL  :
      mleWindow ().deselectAllCmd ()  ;
      break ;

    case  MID_FONT          :
      mleWindow ().fontCmd        ()  ;
      break ;

    case  MID_NEW           :
      mleWindow ().newCmd         ()  ;
      break ;

    case  MID_OPEN          :
      mleWindow ().openCmd        () ;
      break ;

    case  MID_PASTE         :
      mleWindow ().pasteCmd       ()  ;
      break ;

    case  MID_SAVE          :
      mleWindow ().saveCmd        ()  ;
      break ;

    case  MID_SAVEAS        :
      mleWindow ().saveAsCmd      ()  ;
      break ;

    case  MID_SELECT_ALL    :
      mleWindow ().selectAllCmd   ()  ;
      break ;

    case  MID_WORD_WRAP     :
      mleWindow ().wordWrapCmd    ()  ;
      break ;

    default                 :
      bEventProcessed  = false ;

  } /* endswitch */

  return  bEventProcessed ;

} /* IBoolean MLECommandHandler :: command ( ICommandEvent & ricmdevt ) */



MLEWindow & MLECommandHandler :: mleWindow ()
{
  return  rimlewin ;

} /* MLEWindow & MLECommandHandler :: mleWindow () */



MLEWindow :: MLEWindow
  (
  const IResourceId             & rciresidWin ,
  const IResourceId             & rciresidMLE ,
  IWindow                       * pwinOwner   ,
  IWindow                       * pwinParent  ,
  const IFrameWindow :: Style   & rcstyle     ,
  const IMultiLineEdit :: Style & rcmlestyle  ,
  const IRectangle              & rcirect
  )
  : TitleMenuWindow ( pwinOwner , rciresidWin , pwinParent , rcstyle , rcirect  ) ,
    imle            ( rciresidMLE , this  , this  , IRectangle () , rcmlestyle  ) ,
    istrgCurrFile   ( ""      )                                                   ,
    mlecmdhandler   ( * this  )
{
  mlecmdhandler.handleEventsFor ( this ) ;

  setClient ( & mle ()  ) ;
  mle       ().enableWordWrap ( false ) ;

} /* MLEWindow :: MLEWindow */



MLEWindow :: ~MLEWindow ()
{
  mlecmdhandler.stopHandlingEventsFor ( this ) ;

# ifdef _DEBUG
  IMessageBox imsgbox ( IWindow :: desktopWindow () ) ;

  imsgbox.setTitle ( "Debug Info" ) ;
  imsgbox.show     ( "MLEWindow Destructor called" , IMessageBox :: information ) ;

# endif /* # ifdef _DEBUG */

} /* MLEWindow :: ~MLEWindow () */



void MLEWindow :: copyCmd ()
{
  try
  {
    mle ().copy ()  ;

  } /* endtry */
  catch ( IException & riex )
  {
    showMessage ( this , SID_NO_COPY , SID_ERROR ) ;

  } /* endcatch ( IException & riex ) */

  setFocus () ;

} /* void MLEWindow :: copyCmd () */



void MLEWindow :: cutCmd ()
{
  try
  {
    mle ().cut ()  ;

  } /* endtry */
  catch ( IException & riex )
  {
    showMessage ( this , SID_NO_CUT , SID_ERROR ) ;

  } /* endcatch ( IException & riex ) */

  setFocus () ;

} /* void MLEWindow :: cutCmd () */



void MLEWindow :: deselectAllCmd ()
{
  try
  {
    mle ().setCursorPosition ( mle ().cursorPosition () ) ;

  } /* endtry */
  catch ( IException & riex )
  {
    //  Don't really care if an exception is thrown

  } /* endcatch ( IException & riex ) */

  setFocus () ;

} /* void MLEWindow :: deselectAllCmd () */



const char * MLEWindow :: fileName () const
{
  return  istrgCurrFile ;

} /* const char * MLEWindow :: fileName () const */



void MLEWindow :: fontCmd ()
{
  IFont                     ifontCurr         ( & mle ()    ) ;
  IFontDialog :: Settings   ifontdlgSettings  ( & ifontCurr ) ;

  ifontdlgSettings.setTitle ( SID_FONTDLG_TITLE ) ;

  IFontDialog               ifontdlg
                              (
                              desktopWindow ()                                            ,
                              this                                                        ,
                              IFontDialog :: defaultStyle () | IFontDialog :: bitmapOnly  ,
                              ifontdlgSettings
                              ) ;

  if ( ifontdlg.pressedOK () )
  {
    mle ().setFont ( ifontCurr ) ;

    IString istrgFontName = ifontCurr.name () ;

  } /* endif */

  setFocus () ;

} /* void MLEWindow :: fontCmd () */



IMultiLineEdit & MLEWindow :: mle ()
{
  return  imle ;

} /* IMultiLineEdit & MLEWindow :: mle () */



void MLEWindow :: newCmd ()
{
  try
  {
    mle         ().removeAll ()  ;
    setFileName ( "" )              ;

  } /* endtry */
  catch ( IException & riex )
  {
    showMessage ( this , SID_NO_NEW , SID_ERROR ) ;

  } /* endcatch ( IException & riex ) */

  setFocus () ;

} /* void MLEWindow :: newCmd () */



void MLEWindow :: openCmd ()
{
# ifdef _USE_MULTITHREADS
  MLEWinThreadFcn   * mlewinthreadfcn   = new MLEWinThreadFcn ( * this , openThread ) ;

  IThread               ithread ( mlewinthreadfcn , true ) ;
# else
  openThread () ;

# endif /* # ifdef _USE_MULTITHREADS */

} /* void MLEWindow :: openCmd () */



void MLEWindow :: openThread ()
{
  try
  {
    IFileDialog :: Settings   fdSettings  ;

    fdSettings.setOpenDialog  ()  ;

    if ( strIsValid ( fileName () ) )
    {
      fdSettings.setFileName ( fileName () ) ;    

    } /* endif */
    else
    {
      fdSettings.setFileName ( "*.*" ) ;

    } /* endelse */

    IFileDialog   fileDlg ( desktopWindow () , this , fdSettings ) ;

    if ( fileDlg.pressedOK () && fileDlg.fileName ().length () )
    {
      setFileName ( fileDlg.fileName () ) ;

      mle ().removeAll      ()              ;
      mle ().importFromFile ( fileName () ) ;
      mle ().setTop         ( 0 )           ;

    } /* endif */  

  } /* endtry */
  catch ( IException & riex )
  {
    IResourceLibrary  ireslib   = IApplication :: current ().userResourceLibrary  ()  ;
    IString           istrgMsg  = ireslib.loadString ( SID_NO_OPEN ) + fileName   ()  ;

    showMessage ( desktopWindow () , istrgMsg , SID_ERROR ) ;

  } /* endcatch ( IException & riex ) */

  setFocus () ;

} /* void MLEWindow :: openCmd () */



void MLEWindow :: pasteCmd ()
{
  try
  {
    mle ().paste ()  ;

  } /* endtry */
  catch ( IException & riex )
  {
    showMessage ( this , SID_NO_PASTE , SID_ERROR ) ;

  } /* endcatch ( IException & riex ) */

  setFocus () ;

} /* void MLEWindow :: pasteCmd () */



void MLEWindow :: saveAsCmd ()
{
  try
  {
    IFileDialog :: Settings fdSettings ;

    fdSettings.setSaveAsDialog () ;

    fdSettings.setFileName ( fileName () ) ;

    IFileDialog fileDlg ( desktopWindow () , this , fdSettings ) ;

    if ( fileDlg.pressedOK () && fileDlg.fileName ().length () )
    {
      setFileName ( fileDlg.fileName () ) ;

      mle ().exportToFile ( fileName () ) ;

    } /* endif */

  } /* endtry */
  catch ( IException & riex )
  {
    IResourceLibrary  ireslib   = IApplication :: current ().userResourceLibrary  ()  ;
    IString           istrgMsg  = ireslib.loadString ( SID_NO_SAVE ) + fileName   ()  ;

    showMessage ( this , istrgMsg , SID_ERROR ) ;

  } /* endcatch ( IException & riex ) */

  setFocus () ;

} /* void MLEWindow :: saveAsCmd () */



void MLEWindow :: saveCmd ()
{
  try
  {
    if ( strIsValid ( fileName () ) )
    {
      mle ().exportToFile ( fileName () ) ;

    } /* endif */
    else
    {
      saveAsCmd () ;

    } /* endelse */

  } /* endtry */
  catch ( IException & riex )
  {
    IResourceLibrary  ireslib   = IApplication :: current ().userResourceLibrary  () ;
    IString           istrgMsg  = ireslib.loadString ( SID_NO_SAVE ) + fileName   () ;

    showMessage ( this , istrgMsg , SID_ERROR ) ;

  } /* endcatch ( IException & riex ) */

  setFocus () ;

} /* void MLEWindow :: saveCmd () */



void MLEWindow :: selectAllCmd ()
{
  try
  {
    mle ().selectRange ()  ;

  } /* endtry */
  catch ( IException & riex )
  {
    //  Don't really care if an exception is thrown

  } /* endcatch ( IException & riex ) */

  setFocus () ;

} /* void MLEWindow :: selectAllCmd () */



const char * MLEWindow :: setFileName ( const char * cszFileName )
{
  return  istrgCurrFile = cszFileName ;

} /* const char * MLEWindow :: setFileName ( const char * cszFileName ) */



IWindow & MLEWindow :: setFocus ()
{
  IWindow :: setFocus () ;

  mle ().setFocus () ;

  return  * this ;

} /* IWindow & MLEWindow :: setFocus () */



void MLEWindow :: wordWrapCmd ()
{
  Boolean   bWrap = mle ().isWordWrap () ;

  mle     ().enableWordWrap ( ! bWrap ) ;
  menubar ().checkItem      ( MID_WORD_WRAP , ! bWrap ) ;

  setFocus () ;

} /* void MLEWindow :: wordWrapCmd () */



