# ifndef __qrywin_hpp
  # define __qrywin_hpp



class   ApplicationMLEWindow  ;
class   QueryWindow           ;
class   ResultsWindow         ;




//  Create a constant style that is the default style, but with the TASKLIST, VISIBLE and SYSMENU bits turned OFF
const IFrameWindow :: Style ciframestyleGblResults  = IFrameWindow :: titleBar
                                                    | IFrameWindow :: accelerator
                                                    | IFrameWindow :: systemMenu
                                                    | IFrameWindow :: minimizeButton
                                                    | IFrameWindow :: maximizeButton
                                                    | IFrameWindow :: sizingBorder
                                                    | IFrameWindow :: appDBCSStatus   ;




class ApplicationMLEWindow : public IFrameHandler , public MLEWindow
{
public    :
//  Constructors
  ApplicationMLEWindow
    (
    const IResourceId           & rciresidWin                                     ,
    const IResourceId           & rciresidMLE                                     ,
    MLEWindow                   * pmlewinNext = 0                                 ,
    const IFrameWindow :: Style & rcstyle     = IFrameWindow :: defaultStyle  ()  ,
    IWindow                     * pwinOwner   = IWindow :: desktopWindow      ()  ,
    IWindow                     * pwinParent  = IWindow :: desktopWindow      ()
    ) ;

//  Methods
  const MLEWindow       & setNextWin            ( MLEWindow  * pmlewin )  ;

protected :
//  Protected Virtual Methods
  virtual Boolean         dispatchHandlerEvent  ( IEvent & rievent )      ;
  virtual void            nextWinCmd            ()                        ;

//  Protected Constant Methods
  const MLEWinPtr       & mleWinPtr             ()  const                 ;
  const MLEWindow       & nextWin               ()  const                 ;

//  Protected Methods
  MLEWinPtr             & mleWinPtr             ()                        ;
  MLEWindow             & nextWin               ()                        ;

private   :
  MLEWinPtr  mlewinptr  ;

} ; /* class ApplicationMLEWindow : public IFrameHandler , public MLEWindow */



class QueryWindow : public ApplicationMLEWindow
{
public    :
  QueryWindow
    (
    const IResourceId   & rciresidWin ,
    const IResourceId   & rciresidMLE ,
    CLIDatabase         & rclidbInit
    ) ;

  ~QueryWindow () ;

protected :
//  Protected Virtual Methods
  virtual IBoolean        command               ( ICommandEvent & ricmdevt )  ;

//  Protected Methods
  CLIDatabase           & clidatabase           ()                            ;
  void                    connectCmd            ()                            ;
  void                    connectDb             ( const char * cszDbName )    ;
  void                    connectThread         ()                            ;
  void                    getDbNames            ( SortedIStrings  & rsrtset ) ;
  void                    runQueryCmd           ()                            ;
  void                    runQueryThread        ()                            ;
  WaitDialog            & waitDialog            ()                            ;

private   :
  CLIDatabase       & rclidb        ;
  WaitDialog          waitdlg       ;

} ; /* class QueryWindow : public ApplicationMLEWindow */



class ResultsWindow : public ApplicationMLEWindow
{
public    :
  ResultsWindow
    (
    const IResourceId           & rciresidWin                                 ,
    const IResourceId           & rciresidMLE                                 ,
    MLEWindow                   * pmlewinNext                                 ,
    const IFrameWindow :: Style & rcstyle     = ciframestyleGblResults        ,
    IWindow                     * pwinOwner   = IWindow :: desktopWindow  ()  ,
    IWindow                     * pwinParent  = IWindow :: desktopWindow  ()
    ) ;

protected :
//  Protected Virtual Methods
  virtual IBoolean        command           ( ICommandEvent & ricmdevt )  ;

} ; /* class ResultsWindow : public ApplicationMLEWindow */




# endif  /*  # ifndef __qrywin_hpp  */
