
//  IPrivateResource does not work under all versions of AIX, this is  our substitute.  Therefore we allow substitution of
//  our local header "creslock.hpp" under AIX. This conditional will get us by until it becomes available under AIX!
//  Note that "creslock.hpp" includes the AIX header "pthread.h".  Per the AIX programming documentation, "pthread.h"MUST
//  be the first file included, thus we must put this conditional compilation expression at the top of the file.
# ifdef _AIX
  //  Locally Defined C++ Headers
  # include <creslock.hpp>
# else
  //  IBM OCL Defined C++ Headers
  # include <ireslock.hpp>
# endif /* # ifdef _AIX */


//  System Defined C Headers
# include <errno.h>
# include <stddef.h>


//  IBM DB2 Defined C Headers
# include <sqlcli1.h>


//  IBM OS2 Defined C Headers
# define  INCL_DOSERRORS
# define  INCL_DOSSEMAPHORES
# include <os2.h>


//  Application Defined C++ Headers
# include "resdefs.h"


//  System Defined C++ Headers
# include <fstream.h>


//  IBM OCL Defined C++ Headers
# include <icmdhdr.hpp>
# include <iexcept.hpp>
# include <iframe.hpp>
# include <iframhdr.hpp>
# include <ilistbox.hpp>
# include <imenubar.hpp>
# include <imle.hpp>
# include <imsgbox.hpp>
# include <irect.hpp>
# include <istattxt.hpp>
# include <istring.hpp>
# include <ititle.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <commwin.hpp>
# include <dbaseobj.hpp>
# include <threadobj.hpp>
# include <dbconn.hpp>
# include <cliconn.hpp>
# include <dbinfo.hpp>
# include <sqlstmt.hpp>
# include <clistmt.hpp>
# include <clidb.hpp>
# include <coltrans.hpp>
# include <templptr.hpp>
# include <mlewin.hpp>
# include <showexp.hpp>
# include <msgexp.hpp>
# include <keystrng.hpp>



//  Application Defined C++ Headers
# include <waitdlg.hpp>
# include <qrywin.hpp>


//  This dummy object is needed because there is no KeySortedSet instantiated in this directory.  The template generator
//  for IBM VAC++ 3.0 (The compiler with which we are writing this program) will not pull template instantions from another
//  directory.  Therefore we must instantiate a dummy object in the current directory to avoid numerous link errors!
KeySortedDBInfo       keysorteddbinfoGblDummy ;  
KeyedString           keyedstringGblDummy     ;  
SQLDataTypeTranslator sqldatagGblDummy        ;  


int main () 
{
  CLIDatabase   clidb       ;
  int           nErrId  = 0 ;

  try
  {
    //  Set the Frame Window default style so that it includes an accelerator table
    IFrameWindow :: setDefaultStyle ( IFrameWindow :: classDefaultStyle | IFrameWindow :: accelerator ) ;

    //  Set the Multiline Edit default style so that it includes horizontal scroll bars
    IMultiLineEdit :: setDefaultStyle ( IMultiLineEdit :: classDefaultStyle | IMultiLineEdit :: horizontalScroll ) ;

    QueryWindow   mainwindow ( WID_MAIN , WID_QUERY_MLE , clidb ) ;

    IApplication :: current ().run () ;

  } /* endtry */
  catch ( IException & riex )
  {
    showException ( riex ) ;

    nErrId  = riex.errorId () ;

  } /* endcatch ( IException & riex ) */
  catch ( ... )
  {
    cerr << "Unknown error 'catch ( ... )' caught in " << IEXCEPTION_LOCATION () << endl ;

    nErrId  = -1 ;

  } /* endcatch ( ... ) */

  return  nErrId ;

} /* int main () */
