/***************************************************************************************************************************
 
    FILE NAME :
      KEYITEMTEST.CPP
 
 
    DESCRIPTION :
      This module test the OCL Collection Classes.


 
    METHODS DEFINED IN THIS MODULE :
      int   main  ( int nArgC , char ** ppcArgV )

 
    Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.


***************************************************************************************************************************/
# include <iostream.h>
# include <iksset.h>
# include <showexp.hpp>
# include <templptr.hpp>

# include "keyitemtest.hpp"



typedef IKeySortedSet         < CountedKeyedString        , int > CountedKeyedSet           ;
typedef IKeySortedSet         < CountedKeyedStringPtr     , int > CountedKeyedPtrSet        ;
typedef IKeySortedSet         < CountedKeyedStringAutoPtr , int > CountedKeyedAutoPtrSet    ;





int main ( int nArgC , char ** ppcArgV ) 
{
  int nRet  = 0 ;

  //  Create Three KeyedSortedSet Collections.  Note that we are declaring these OUTSIDE of the try block so that
  //  they will be destroyed AFTER the end of that scope.
  CountedKeyedSet           countedkeyedset         ;
  CountedKeyedPtrSet        countedkeyedptrset      ;
  CountedKeyedAutoPtrSet    countedkeyedautoptrset  ;


  try
  {
    //  Create Three AUTOMATIC        CountedKeyedString Objects
    CountedKeyedString        countedkeyedstring1         ( "Automatic" ) ;
    CountedKeyedString        countedkeyedstring2         ( "Automatic" ) ;
    CountedKeyedString        countedkeyedstring3         ( "Automatic" ) ;

    //  Create Three HEAP             CountedKeyedString Objects
    CountedKeyedStringPtr     countedkeyedstringptr4      = new CountedKeyedString ( "Heap" ) ;
    CountedKeyedStringPtr     countedkeyedstringptr5      = new CountedKeyedString ( "Heap" ) ;
    CountedKeyedStringPtr     countedkeyedstringptr6      = new CountedKeyedString ( "Heap" ) ;

    //  Create Three TEMPLATE POINTER CountedKeyedString Objects
    CountedKeyedStringAutoPtr countedkeyedstringautoptr7  ( new CountedKeyedString ( "Heap Template" ) ) ;
    CountedKeyedStringAutoPtr countedkeyedstringautoptr8  ( new CountedKeyedString ( "Heap Template" ) ) ;
    CountedKeyedStringAutoPtr countedkeyedstringautoptr9  ( new CountedKeyedString ( "Heap Template" ) ) ;

    //  Add the Automatic Objects to the appropriate collection
    countedkeyedset.add         ( countedkeyedstring1 ) ;
    countedkeyedset.add         ( countedkeyedstring2 ) ;
    countedkeyedset.add         ( countedkeyedstring3 ) ;

    //  Add the Heap      Objects to the appropriate collection
    countedkeyedptrset.add      ( countedkeyedstringptr4 ) ;
    countedkeyedptrset.add      ( countedkeyedstringptr5 ) ;
    countedkeyedptrset.add      ( countedkeyedstringptr6 ) ;

    //  Add the Template  Objects to the appropriate collection
    countedkeyedautoptrset.add  ( countedkeyedstringautoptr7 ) ;
    countedkeyedautoptrset.add  ( countedkeyedstringautoptr8 ) ;
    countedkeyedautoptrset.add  ( countedkeyedstringautoptr9 ) ;

    //  Tell the Template Objects NOT to destroy themselves when they go out of scope.  We can tell when these are
    //  destroyed by whether or not their destructor message is printed BEFORE or AFTER the following message to cout.
    countedkeyedstringautoptr7.shouldDestroy  ( false ) ;
    countedkeyedstringautoptr8.shouldDestroy  ( false ) ;
    countedkeyedstringautoptr9.shouldDestroy  ( false ) ;

    //  Send message to cout to say that we are leaving the try block
    cout << "\nNo Exceptions were thrown.  We are successfully leaving the try block\n" << endl ;

  } /* endtry */
  catch ( IException & riex )
  {
    cerr  << riex ;

    nRet  = riex.errorId () ;

  } /* endcatch ( IException & riex ) */

    //  Send message to cout to say that we are leaving the try block
  cout << "\nWe are now OUT of the try  block and we are about leave the program altogether\n" << endl ;

  return  nRet ;

} /* int main ( int nArgC , char ** ppcArgV ) */



CountedKeyedString :: CountedKeyedString ( const char * cszString )
  : AttrKeyedItem < int > ( nObjCount ) , istring  ( cszString )
{
  nObjCount++ ;

  cout << "Created a CountedKeyedString with a key value of " << key () << " and a string value of " << istring << endl ;

} /* CountedKeyedString :: CountedKeyedString ( const char * cszString ) */



CountedKeyedString :: ~CountedKeyedString ()
{
  cout << "Destroying a CountedKeyedString with a key value of " << key () << " and a string value of " << istring << endl ;

} /* CountedKeyedString :: ~CountedKeyedString () */


int CountedKeyedString :: nObjCount = 1 ;



/**************************************   END OF FILE KEYITEMTEST.CPP   ***************************************************/
