/***************************************************************************************************************************

  Copyright - Peter Garner, 1997.
     This code is released into the public domain, and you are free to use and modify this without credit to the author

***************************************************************************************************************************/
//  System Defined C Headers
# include <stdlib.h>
# include <time.h>


//  System Defined C++ Headers
# include <iostream.h>


//  IBM OCL Defined C++ Headers
# include <iexcbase.hpp>
# include <iexcept.hpp>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>

# include "tcperror.hpp"





/*************************************************************************************************************
  
  TITLE         :
    TCPIPError :: TCPIPError ( const char * cszMsg , long lErr )


  ARGUMENTS     :
    const char  * cszMsg
      A pointer to an error message string

   long           lErr
      The errorID


  DESCRIPTION   :
    This is the default TCPIPError constructor.  It constructs a TCPIPError object whose error message and 
    error ID are set to cszMsg and lErr, respectively.
  
**************************************************************************************************************/
TCPIPError :: TCPIPError ( const char * cszMsg , long lErr ) : IAccessError ( cszMsg , lErr )
{
  //  The parent class constructor should suffice for this class as it defines no new data.

} /* TCPIPError :: TCPIPError ( const char * cszMsg , long lErr ) */



/*************************************************************************************************************
  
  TITLE         :
    TCPIPError :: TCPIPError ( const TCPIPError & crtcpiperror )
  
  
  ARGUMENTS     :
    const TCPIPError & crtcpiperror
  
  
  DESCRIPTION   :
    This is the TCPIPError copy constructor.  It constructs a TCPIPError object that is a DEEP copy of that
    supplied in as the input argument 'crtcpiperror'.  (Note that ALL exception objects need a copy
    constructor in order to be 'thrown').
  
**************************************************************************************************************/
TCPIPError :: TCPIPError ( const TCPIPError & crtcpiperror ) : IAccessError ( crtcpiperror )
{
  //  This copy constructor is needed so that we can throw an object of this type.  The parent class
  //  (IAccessError) constructor should work fine for this class as it defines no new data.

} /* TCPIPError :: TCPIPError ( const TCPIPError & crtcpiperror ) */


