//  This file tests the IP message class.  It connects to the addresses and ports defined on the command line.
//  It sends a message typed at the keyboard to the server.  The Server then acknoweledges receipt of that
//  message by printing the message at the console.
//
//  Usage is :  d_tcptest <local address> <local port> [<remote address> <remote port>]
//
//  These host names MUST be in the hosts file are a TCPIP exception will be thrown.  
//  If the /s option is used the process executes as the server, otherwise it executes as the client.
//



//  System Defined C Headers
# include <errno.h>
# include <stdlib.h>
# include <string.h>
# include <time.h>


//  System Defined C++ Headers
//  These must be included BEFORE the TCPIP headers when using PCTCP for
//  DOS.  Under OS/2 and Unix it doesn't matter.
# include <iostream.h>


//  TCPIP C Headers
extern "C"
{
# include "tcpport.h"

# include <netdb.h>
# include <sys/types.h>
# include <sys/ioctl.h>
# include <sys/socket.h>
# include <netinet/in.h>
}

//  Locally Defined C Headers
# include <cpuport.h>
# include <strfcns.h>



//  IBM OCL Defined C++ Headers
# include <iexcbase.hpp>
# include <iexcept.hpp>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <showexp.hpp>


# include "tcperror.hpp"
# include "sockaddr.hpp"
# include "ipsock.hpp"


//  Define the MAXIMUM length of a single message
# define  MAX_TST_MSG   1023



//  Some PC DOS FTP/TCPIP implementations declare, but do not define h_errno!
//  I.e it is defined as an extern, but is not found in any libs!
# ifdef  __PC_DOS__
  int   h_errno ;
# endif


void runAsClient  ( TCPSocket   & rtcpsocket  ) ;
void runAsServer  ( TCPSocket   & rtcpsocket  ) ;
void usage        ( const char  * cszProgName ) ;


# define  PROG_NAME   0
# define  LOCAL_ADDR  1
# define  LOCAL_PORT  2
# define  ARGS_REQ    3
# define  REMOT_ADDR  3
# define  REMOT_PORT  4





int main ( int nArgC , char ** ppcArgV )
{
  //  Check to see if the proper number of arguments were entered at the command line.
  if ( nArgC < ARGS_REQ )
  {
    usage ( ppcArgV [PROG_NAME] ) ;

  } /* endif */

  char  * szLocalAddr = ppcArgV [LOCAL_ADDR]              ;
  char  * szRemotAddr = ppcArgV [REMOT_ADDR]              ;
  int     nLocalPort  = atoi    ( ppcArgV [LOCAL_PORT] )  ;
  int     nRemotPort  = 0                                 ;

  //  Check to be sure that we were able to convert at least the entered Local port number to a non zero number!
  if ( 0 == nLocalPort )
  {
    usage ( ppcArgV [PROG_NAME] ) ;

  } /* endif */

  try
  {
    SockAddr saddrRemot ;

    SockAddr saddrLocal ( nLocalPort , szLocalAddr ) ;
    TCPSocket tcpsocket ( saddrLocal ) ;

    if ( nArgC > REMOT_PORT && 0 != ( nRemotPort = atoi  ( ppcArgV [REMOT_PORT] ) ) )
    {
      saddrRemot.init         ( nRemotPort , szRemotAddr )  ;
      tcpsocket.setRemotAddr  ( saddrRemot )                ;

      runAsClient ( tcpsocket ) ;

    } /* endif */
    else
    {
      runAsServer ( tcpsocket ) ;

    } /* endelse */
 
  } /* endtry */
  catch ( IException & riex )
  {
    cerr  << '\n' << riex << '\n' ;
    
    return  riex.errorId () ;

  } /* endcatch ( IException & riex ) */


  return  0 ;

} ; /* int main ( int nArgC , char ** ppcArgV ) */



void runAsClient ( TCPSocket & rtcpsocket )
{
  char    pcBuff [MAX_TST_MSG+1]  ;
  size_t  stLen                   ;

  rtcpsocket.connect () ;

  cout << "\nType a message to send to the server on each line.\nStart a line with 'q' to quit\n" << endl ;

  do
  {
    // Set all of the buffer to '\0' again.
    memset ( pcBuff , '\0' , sizeof ( pcBuff ) ) ;

    cin.getline ( pcBuff , MAX_TST_MSG ) ;
    strToUpper  ( pcBuff ) ;

    rtcpsocket.write ( pcBuff , (SINT16) strlen ( pcBuff ) ) ;

    // Set all of the buffer to '\0' again.
    memset ( pcBuff , '\0' , sizeof ( pcBuff ) ) ;

    stLen = rtcpsocket.read  ( pcBuff , (SINT16) sizeof ( pcBuff ) ) ;

    cout << pcBuff << '\n' << endl ;

  } while ( 'Q' != * pcBuff ) ; /* enddo */

} /* void runAsClient ( TCPSocket & rtcpsocket ) */



void runAsServer ( TCPSocket & rtcpsocket )
{
  char    cFirst                      ;
  char    pcBuff    [MAX_TST_MSG + 1] ;
  int     nNewSock                    ;
  size_t  stLen                       ;


  rtcpsocket.bind   () ;
  rtcpsocket.listen () ;


  cout << "\nThis program is executing in server mode.\nWe are now listening for a single, remote connection\n" << endl ;


  nNewSock  =  rtcpsocket.accept () ;

  TCPSocket tcpsockConnected ( rtcpsocket ) ;

  tcpsockConnected.setHandle ( nNewSock ) ;

  do
  {
    stLen = tcpsockConnected.read ( pcBuff , MAX_TST_MSG ) ;

    if ( stLen )
    {

      pcBuff  [stLen] = '\0'    ;

      //  Get the first character received to see if it is a 'Q'
      cFirst  = * pcBuff        ;

      cout    << pcBuff << endl ;

      stLen = tcpsockConnected.write ( pcBuff , stLen ) ;

    } /* endif */

  } while ( 'Q' != cFirst ) ; /* enddo */

} /* void runAsServer ( TCPSocket & rtcpsocket ) */



void usage ( const char * cszProgName )
{
  cerr  <<  '\n' << cszProgName << ", a simple TCP Echo program to test TCP programming interfaces\n"
        <<  "Usage : " << cszProgName << " <local address> <local port> [<remote address> <remote port>]\n"
        <<  "If no remote addresses are specified this program will run as the server!\n\n" ;

  exit ( -1 ) ;

} /* void usage ( const char * cszProgName ) */
