//  This file tests the IP message class.  It connects to the port defined as TEST_PORT in "tcptest.h"
//  It sends a message typed at the keyboard to the server.  The Server then acknoweledges receipt of that
//  message by printing the message at the console.
//
//      TCPTEST <client host name> <server host name> [/s]
//
//  These host names MUST be in the hosts file are a TCPIP exception will be thrown.  
//  If the /s option is used the process executes as the server, otherwise it executes as the client.
//



//  System Defined C Headers
# include <errno.h>
# include <stdlib.h>
# include <string.h>
# include <time.h>


//  System Defined C++ Headers
//  These must be included BEFORE the TCPIP headers when using PCTCP for
//  DOS.  Under OS/2 and Unix it doesn't matter.
# include <fstream.h>


//  TCPIP C Headers
extern "C"
{
# include "tcpport.h"

# include <netdb.h>
# include <sys/types.h>
# include <sys/ioctl.h>
# include <sys/socket.h>
# include <netinet/in.h>
}

//  Locally Defined C Headers
# include <cpuport.h>
# include <strfcns.h>
# include "d_strmtst.h"


//  IBM OCL Defined C++ Headers
# include <iexcbase.hpp>
# include <iexcept.hpp>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <templary.hpp>
# include <fstrmchk.hpp>
# include <buffile.hpp>
# include <showexp.hpp>


# include "tcperror.hpp"
# include "sockaddr.hpp"
# include "ipsock.hpp"
# include "tcpobj.hpp"



//  Some PC DOS FTP/TCPIP implementations declare, but do not define h_errno!
//  I.e it is defined as an extern, but is not found in any libs!
# ifdef  __PC_DOS__
  int   h_errno ;
# endif



void runAsServer  ( SockAddr    & rsokaddrLocal ) ;
void usage        ( const char  * cszProgName   ) ;



# define  PROG_NAME   0
# define  LOCAL_ADDR  1
# define  LOCAL_PORT  2
# define  ARGS_REQ    3



int main ( int nArgC , char ** ppcArgV )
{
  int nErrCode  = 0 ;

  //  Check to see if the proper number of arguments were entered at the command line.
  if ( nArgC < ARGS_REQ )
  {
    usage ( ppcArgV [PROG_NAME] ) ;

  } /* endif */

  char  * szLocalAddr = ppcArgV [LOCAL_ADDR] ;
  int     nLocalPort  = atoi ( ppcArgV [LOCAL_PORT] ) ; 

  //  Check to be sure that we were able to convert at least the entered Local port number to a non zero number!
  if ( 0 == nLocalPort )
  {
    usage ( ppcArgV [PROG_NAME] ) ;

  } /* endif */

  try
  {
    SockAddr saddrLocal ( nLocalPort , szLocalAddr ) ;

    runAsServer ( saddrLocal ) ;

  } /* endtry */
  catch ( IException & riex )
  {
    cerr  << '\n' << riex << '\n' ;
    
    nErrCode  = riex.errorId () ;

  } /* endcatch ( IException & riex ) */

  return  nErrCode ;

} ; /* int main ( int nArgC , char ** ppcArgV ) */



void runAsServer ( SockAddr & rsokaddrLocal )
{
  TCPServer tcpsrvr ( rsokaddrLocal ) ;
  TCPStream tcpstrm                   ;

  char    * pcBuff                    ;
  int     nNewSock                    ;
  size_t  stLen                       ;

  tcpsrvr.listen () ;

  cout << "\nThis program is executing in server mode.\nWe are now listening for a single, remote connection\n" << endl ;

  nNewSock  =  tcpsrvr.accept ( tcpstrm ) ;

  tcpstrm.getTCPSocket ().setHandle ( nNewSock ) ; 

  BuffedFile buffile ( FSIZE ) ;

  pcBuff = buffile.getBuffer () ;

  stLen = tcpstrm.read ( pcBuff , FSIZE ) ;

  cout  << "\nPacket size is : " << cs16GblMAX_PACKET << " bytes\n" ;
  cout  << stLen << " Bytes received\nProgram completed successfully!\n" << endl ;

  buffile.flush ( FNAME1 ) ;

} /* void runAsServer ( SockAddr & rsokaddrLocal ) */



void usage ( const char * cszProgName )
{
  cerr  <<  '\n' << cszProgName << ", a simple TCP Echo program to test TCP programming interfaces\n"
        <<  "Usage : " << cszProgName << " <local address> <local port>\n\n" ;


  exit ( -1 ) ;

} /* void usage ( const char * cszProgName ) */





