//  This file tests the TCPStream and TCPServer classes.  This program copies a file from the client to the server
//  and back again.
//
//



//  System Defined C Headers
# include <errno.h>
# include <stdlib.h>
# include <string.h>
# include <time.h>


//  System Defined C++ Headers
//  These must be included BEFORE the TCPIP headers when using PCTCP for
//  DOS.  Under OS/2 and Unix it doesn't matter.
# include <fstream.h>


//  TCPIP C Headers
extern "C"
{
# include "tcpport.h"

# include <netdb.h>
# include <sys/types.h>
# include <sys/ioctl.h>
# include <sys/socket.h>
# include <netinet/in.h>
}

//  Locally Defined C Headers
# include <cpuport.h>
# include <strfcns.h>
# include "d_strmtst.h"


//  IBM OCL Defined C++ Headers
# include <iexcbase.hpp>
# include <iexcept.hpp>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <templary.hpp>
# include <fstrmchk.hpp>
// # include <buffile.hpp>
# include <showexp.hpp>


# include "tcperror.hpp"
# include "sockaddr.hpp"
# include "ipsock.hpp"
# include "tcpobj.hpp"



//  Some PC DOS FTP/TCPIP implementations declare, but do not define h_errno!
//  I.e it is defined as an extern, but is not found in any libs!
# ifdef  __PC_DOS__
  int   h_errno ;
# endif



void runAsClient  ( SockAddr & rsokaddrLocal  , SockAddr & rsokaddrRemot ) ;
void usage        ( const char  * cszProgName   ) ;



# define  PROG_NAME   0
# define  LOCAL_ADDR  1
# define  LOCAL_PORT  2
# define  REMOT_ADDR  3
# define  REMOT_PORT  4
# define  ARGS_REQ    5



//  Global buffer to hold our data
char  * caGblBuff  ;


void initBuff ()
{
  char  * szFill  = "TCPISOK!"          ;
  UINT32  u32     = 0                   ;
  UINT32  u32Len  = strlen  ( szFill )  ;

  while ( u32 < FSIZE + 1 )
  {
    memcpy ( caGblBuff + u32 , szFill , u32Len ) ;

    u32 += u32Len ;

  } /* endwhile  */

} /* void initBuff () */



int main ( int nArgC , char ** ppcArgV )
{
  int nErrCode  = 0 ;

  //  Check to see if the proper number of arguments were entered at the command line.
  if ( nArgC < ARGS_REQ )
  {
    usage ( ppcArgV [PROG_NAME] ) ;

  } /* endif */

  char  * szLocalAddr = ppcArgV [LOCAL_ADDR] ;
  char  * szRemotAddr = ppcArgV [REMOT_ADDR] ;
  int     nLocalPort  = atoi ( ppcArgV [LOCAL_PORT] ) ; 
  int     nRemotPort  = atoi ( ppcArgV [REMOT_PORT] ) ; 

  //  Check to be sure that we were able to convert at the entered port numbers into non zero numbers!
  if ( 0 == nLocalPort || 0 == nRemotPort )
  {
    usage ( ppcArgV [PROG_NAME] ) ;

  } /* endif */

  try
  {
    //  Allocate our buffer
    CharArray charryInBuff ( FSIZE * 2 ) ;

    caGblBuff = charryInBuff ;

    SockAddr saddrLocal ( nLocalPort  , szLocalAddr ) ;
    SockAddr saddrRemot ( nRemotPort  , szRemotAddr ) ;

    //  Initialize the global write buffer 'caGblBuff' with a repeating 8 byte string
    initBuff            () ;
    runAsClient         ( saddrLocal  , saddrRemot  ) ;
 
  } /* endtry */
  catch ( IException & riex )
  {
    cerr  << '\n' << riex << '\n' ;
    
    nErrCode  = riex.errorId () ;

  } /* endcatch ( IException & riex ) */

  return  nErrCode ;

} ; /* int main ( int nArgC , char ** ppcArgV ) */



void runAsClient ( SockAddr & rsokaddrLocal , SockAddr & rsokaddrRemot )
{
  TCPStream   tcpstrm                               ;
  TCPSocket   tcpsocket   ( rsokaddrLocal )         ;
  size_t      stLen       = 0                       ;

  tcpsocket.setRemotAddr  ( rsokaddrRemot ) ;
  tcpsocket.bind          () ;
  tcpstrm.setTCPSocket    ( tcpsocket ) ;
  tcpsocket.connect       () ;

//  BuffedFile buffile ( FNAME1 ) ;

//  stLen = tcpstrm.write ( buffile.getBuffer () , FSIZE ) ;

  stLen = tcpstrm.write ( caGblBuff , FSIZE ) ;

  cout  << "\nPacket size is : " << cs16GblMAX_PACKET << " bytes\n" ;
  cout  << stLen << " Bytes sent\nProgram completed successfully!\n" << endl ;


} /* void runAsClient ( SockAddr & rsokaddrLocal , SockAddr & rsokaddrRemot ) */



void usage ( const char * cszProgName )
{
  cerr  <<  '\n' << cszProgName << ", a simple TCP Echo program to test TCP programming interfaces\n"
        <<  "Usage : " << cszProgName << " <local address> <local port> <remote address> <remote port>\n\n" ;

  exit ( -1 ) ;

} /* void usage ( const char * cszProgName ) */





