# include <iostream.h>

# include <iexcbase.hpp>
# include <imsgbox.hpp>
# include <ireslib.hpp>
# include <istring.hpp>
# include <iwindow.hpp>


# include <showexp.hpp>





IMessageBox & operator << ( IMessageBox & rimsgbox , const IException & rciexp )
{
  IString istrgMessage  ;

  istrgMessage  << rciexp ;

  rimsgbox.show ( istrgMessage , IMessageBox :: catastrophic ) ;

  return  rimsgbox ;

} /* IMessageBox & operator << ( IMessageBox & rimsgbox , const IException & rciexp ) */




int showException ( const IException & rciex )
{
  //  Initialized Data
  IMessageBox imsgbox   ( IWindow :: desktopWindow () ) ;

  imsgbox <<  rciex ;

  return  rciex.errorId () ;

} /* int showException ( const IException & rciex ) */



void showMessage ( IWindow * piwinowner , const char * cszText , const char * cszTitle , IMessageBox :: Severity severity )
{
  IMessageBox   imsgbox ( piwinowner ) ;

  if ( cszTitle )
  {
    imsgbox.setTitle ( cszTitle ) ;

  } /* endif */

  imsgbox.show ( cszText , severity ) ;

} /* void showMessage ( IWindow * , const char * , const char * , IMessageBox :: Severity ) */



void showMessage
  (
  IWindow                 * piwinowner  ,
  const char              * cszText     ,
  const IResourceId       & ciresTitle  ,
  IMessageBox :: Severity   severity
  )
{
  IMessageBox   imsgbox ( piwinowner ) ;

  if ( ciresTitle.id () )
  {
    imsgbox.setTitle ( ciresTitle ) ;

  } /* endif */

  imsgbox.show ( cszText , severity ) ;

} /* void showMessage ( IWindow * , const char * , const IResourceId & , IMessageBox :: Severity ) */



void showMessage
  (
  IWindow                 * piwinowner  ,
  const IResourceId       & ciresText   ,
  const IResourceId       & ciresTitle  ,
  IMessageBox :: Severity   severity
  )
{
  IMessageBox   imsgbox ( piwinowner ) ;

  if ( ciresTitle.id () )
  {
    imsgbox.setTitle ( ciresTitle ) ;

  } /* endif */

  imsgbox.show ( ciresText , severity ) ;

} /* void showMessage ( IWindow * , const IResourceId & , const IResourceId & , IMessageBox :: Severity ) */



/**************************************** END OF FILE MSGEXP.CPP ****************************************/
