//  OS/2 Defined C Headers
# include <os2.h>


//  IBM OCL Defined C++ Headers
# include <icmdhdr.hpp>
# include <iframe.hpp>
# include <imenubar.hpp>
# include <ititle.hpp>


//  Locally Defined C++ Headers
# include <commwin.hpp>




CommandWindow :: CommandWindow ( ULONG ulId ) : IFrameWindow ( ulId )
{
  ICommandHandler :: handleEventsFor ( this ) ;

} /* CommandWindow :: CommandWindow ( ULONG ulId ) : IFrameWindow ( ulId ) */



CommandWindow :: CommandWindow ( const char * cszTitle , const IResourceId & rciresid )
  : IFrameWindow ( cszTitle , rciresid )
{
  ICommandHandler :: handleEventsFor ( this ) ;

} /* CommandWindow :: CommandWindow ( const char * cszTitle , const IResourceId & rciresid ) */



CommandWindow :: CommandWindow ( const IResourceId & rciresid , IWindow * piwinOwner , IWindow * piwinParent )
  : IFrameWindow ( rciresid , piwinOwner , piwinParent )
{
  ICommandHandler :: handleEventsFor ( this ) ;  

} /* CommandWindow :: CommandWindow ( const IResourceId & rciresid , IWindow * piwinOwner , IWindow * piwinParent ) */



CommandWindow :: CommandWindow
  (
  IWindow                     * pwinParent  ,
  const IResourceId           & rciresid    ,
  IWindow                     * pwinOwner   ,
  const IFrameWindow :: Style & rcstyle     ,
  const IRectangle            & rcirect
  )
: IFrameWindow ( rciresid , pwinParent , pwinOwner , rcirect , rcstyle )
{
  handleEventsFor ( this ) ;

} /* CommandWindow :: CommandWindow */



CommandWindow :: ~CommandWindow ()
{
  ICommandHandler :: stopHandlingEventsFor ( this ) ;

} /* CommandWindow :: ~CommandWindow () */



DialogBox :: DialogBox ( const IResourceId & rciresid , IWindow * piwinOwner , IWindow * piwinParent )
  : CommandWindow ( rciresid , piwinOwner , piwinParent )
{

} /* DialogBox :: DialogBox ( const IResourceId & rciresid , IWindow * piwinOwner , IWindow * piwinParent ) */



IBoolean DialogBox :: command (ICommandEvent & ricmdevt )
{
  IBoolean  bEventProcessed  = true  ;                //  Assume event will be processed  
  ULONG     ulCommand       = ricmdevt.commandId () ; //  Get the command into an easily viewed (for debugger) variable

  switch ( ulCommand )
  {
    case  DID_CANCEL :
    case  DID_OK     :
       dismiss ( ulCommand ) ;
       break ;

    default           :
      bEventProcessed  = false ;

  } /* endswitch */

  return  bEventProcessed ;

} /* IBoolean DialogBox :: command (ICommandEvent & ricmdevt ) */



MenuedObject :: MenuedObject ( const IResourceId & rciresid , IFrameWindow * pwinOwner )
  : imenubar ( rciresid , pwinOwner )
{

} /* MenuedObject :: MenuedObject ( const IResourceId & rciresid , IIFrameWindow * pwinOwner ) */



IMenuBar & MenuedObject :: menubar ()
{
  return  imenubar  ;

} /* IMenuBar & MenuedObject :: menubar () */



const IMenuBar & MenuedObject :: menubar () const
{
  return  imenubar  ;

} /* const IMenuBar & MenuedObject :: menubar () const */


TitledObject :: TitledObject ( IWindow * pwinOwner , const IResourceId & rciresid )
  : ititle ( pwinOwner , rciresid )
{

} /* TitledObject :: TitledObject ( IWindow * pwinOwner , const IResourceId & rciresid ) */



TitledObject :: TitledObject ( IWindow * pwinOwner , const char * cszTitle )
  : ititle ( pwinOwner , cszTitle )
{

} /* TitledObject :: TitledObject ( IWindow * pwinOwner , const char * cszTitle ) */



ITitle & TitledObject :: title ()
{
  return  ititle  ;

} /* ITitle & TitledObject :: title () */



const ITitle & TitledObject :: title () const
{
  return  ititle  ;

} /* const ITitle & TitledObject :: title () const */



TitleMenuWindow :: TitleMenuWindow ( ULONG ulId )
 : CommandWindow ( ulId ) , MenuedObject ( ulId , this ) , TitledObject ( this , ulId )
{

} /* TitleMenuWindow :: TitleMenuWindow ( ULONG ulId ) */



TitleMenuWindow :: TitleMenuWindow ( const char * cszTitle , const IResourceId & rciresid )
  : CommandWindow ( cszTitle , rciresid ) , MenuedObject ( rciresid , this ) , TitledObject ( this , cszTitle )
{

} /* TitleMenuWindow :: TitleMenuWindow ( const char * cszTitle , const IResourceId & rciresid ) */



TitleMenuWindow :: TitleMenuWindow ( const IResourceId & rciresid , IWindow * piwinOwner , IWindow * piwinParent )
  : CommandWindow ( rciresid , piwinOwner , piwinParent ) ,
    MenuedObject ( rciresid , this )                      ,
    TitledObject ( this , rciresid )
{

} /* TitleMenuWindow :: TitleMenuWindow ( const IResourceId & , IWindow * , IWindow * ) */



TitleMenuWindow :: TitleMenuWindow
  (
  IWindow                     * pwinOwner   ,
  const IResourceId           & rciresid    ,
  IWindow                     * pwinParent  ,
  const IFrameWindow :: Style & rcstyle     ,
  const IRectangle            & rcirect
  )
  : CommandWindow ( pwinParent , rciresid , pwinOwner , rcstyle , rcirect ) ,
    MenuedObject  ( rciresid , this )                                       ,
    TitledObject  ( this , rciresid )
{

} /* TitleMenuWindow :: TitleMenuWindow */
