/***************************************************************************************************************************

   FILE NAME :
     STRFCNS.C


   APPLICATION :
     GENERIC C MODULE FOR HANDLING STRING AND MEMORY BUFFERS



   DESCRIPTION :
     This module contains some generic functions that deal with string and memory handling.


   FUNCTIONS DEFINED IN THIS MODULE :
     unsigned    memCount        ( const char * , char , size_t ) ;
     short       memIsBlank      ( const char * , size_t ) ;
     void      * memrchr         ( const void * , char c , size_t ) ;
     char      * strCopyFill     ( char * , const char * , char , size_t ) ;
     unsigned    strCount        ( const char * , char ) ;
     short       strIsBlank      ( const char * ) ;
     short       strIsValid      ( const char * ) ;
     char      * strLen          ( const char * ) ;
     char      * strLTrim        ( char * ) ;
     char      * strStripNewLine ( char * ) ;
     char      * strReset        ( char * , const char * ) ;
     char      * strRTrim        ( char * ) ;
     char      * strTermCpy      ( char * , const char * , size_t ) ;
     char      * strTermFill     ( char * , const char * , char , size_t ) ;


***************************************************************************************************************************/
# define  INCL_DOS
# include <os2.h>
# include <time.h>


# include <timefcn.h>





/***************************************************************************************************************************
  char * nDate ( const FDATE cfdate , char * szDate )
****************************************************************************************************************************

  ARGUMENTS   :
    const FDATE cfdate
      A constant IBM FDATE bitmap structure.  This should contain the date information we wish to convert to an ASCIIZ
      string.

    char        * szDate
      The address of the destination string.  This will contain the converted value as an ASCIIZ string upon completion.


  RETURNS     :
    'szDate', the address of the argument string in all cases.


  DESCRIPTION :
    This function converts the date value stored in 'FDATE cfdate to an ASCIIZ string and stores that string at the address
    pointed to by the argument 'szDate'.  This function will not cause an error if 'szDate' is NULL.

***************************************************************************************************************************/
char * nDate ( const FDATE cfdate , char * szDate )
{
  struct tm   tmStart  ;

  if ( 0 == szDate )
  {
    return  0 ;

  } /* endif */

  tmStart.tm_mday = cfdate.day          ;   /* day of the month [1-31]                */
  tmStart.tm_mon  = cfdate.month - 1    ;   /* months since January [0-11]            */
  tmStart.tm_year = cfdate.year  + 80   ;   /* years since 1900                       */

  strftime ( szDate , 16 , "%d.%b.%Y" , & tmStart ) ;

  return  szDate ;

} /* char * nDate ( const FDATE & crfdate ) */



/***************************************************************************************************************************
  char * nTime ( const FTIME cftime , char * szTime )
****************************************************************************************************************************

  ARGUMENTS   :
    const FTIME cftime
      A constant IBM FTIME bitmap structure.  This should contain the time information we wish to convert to an ASCIIZ
      string.

    char        * szTime
      The address of the destination string.  This will contain the converted value as an ASCIIZ string upon completion.


  RETURNS     :
    'szTime', the address of the argument string in all cases.


  DESCRIPTION :
    This function converts the time value stored in 'FTIME cftime to an ASCIIZ string and stores that string at the address
    pointed to by the argument 'szTime'.  This function will not cause an error if 'szTime' is NULL.

***************************************************************************************************************************/
char * nTime ( const FTIME cftime , char * szTime )
{
  struct tm   tmStart  ;


  tmStart.tm_sec  = cftime.twosecs      ;   /* seconds after the minute [0-61]        */
  tmStart.tm_min  = cftime.minutes      ;   /* minutes after the hour [0-59]          */
  tmStart.tm_hour = cftime.hours        ;   /* hours since midnight [0-23]            */

  strftime ( szTime , 16 , "%H:%M:%S" , & tmStart ) ;

  return  szTime ;

} /* char * nTime ( const FTIME & crftime ) */



/**************************************     END OF FILE TIMEFCN.C             *********************************************/
