/***************************************************************************************************************************
 
    FILE NAME :
      THREADOBJ.CPP
 
 
    APPLICATION :
      GENERAL IMPLEMENTATION OF A THREAD SAFE SERIALIZABLE OBJECT
 

    DESCRIPTION :
      This module contains the methods used to implement the class ThreadSafeObject.  This is a superclass that uses an 
      IPrivateResource to serialize access to objects on a PER OBJECT basis.  I.e. there is one resource per object, not
      per class

 
    METHODS DEFINED IN THIS MODULE :
      const char              * ThreadSafeObject :: className         ()  const
      IPrivateResource        & ThreadSafeObject :: objectResource    ()
 
***************************************************************************************************************************/
//  IPrivateResource does not work under all versions of AIX, this is  our substitute.  Therefore we allow substitution of
//  our local header "creslock.hpp" under AIX. This conditional will get us by until it becomes available under AIX!
//  Note that "creslock.hpp" includes the AIX header "pthread.h".  Per the AIX programming documentation, "pthread.h"MUST
//  be the first file included, thus we must put this conditional compilation expression at the top of the file.
# ifdef _AIX
  //  Locally Defined C++ Headers
  # include <creslock.hpp>
# else
  //  IBM OCL Defined C++ Headers
  # include <ireslock.hpp>
# endif /* # ifdef _AIX */


//  System Defined C Headers
# include <stddef.h>


//  Locally Defined C++ Headers
# include <namedobj.hpp>
# include <threadobj.hpp>




/***************************************************************************************************************************
  const char * ThreadSafeObject :: className () const
****************************************************************************************************************************

  RETURNS     :
    The class name "ThreadSafeObject" as a const char *


  DESCRIPTION :
    This returns the class name and can be used for primitive RTTI, etc.

***************************************************************************************************************************/
const char * ThreadSafeObject :: className () const
{
  return  "ThreadSafeObject"  ;

} /* const char * ThreadSafeObject :: className () const */



/***************************************************************************************************************************
  IPrivateResource & ThreadSafeObject :: objectResource ()
****************************************************************************************************************************

  RETURNS     :
    A reference to the IPrivateResource object encapsulated by the receiver


  DESCRIPTION :
    This is the public accessor for getting at the receivers' IPrivateResource.  Each object of this class has it's OWN
    instance of IPrivateResource.  This allows the class to be serialized on a per object basis WITHOUT blocking other
    objects of this class.

***************************************************************************************************************************/
IPrivateResource & ThreadSafeObject :: objectResource ()
{
  return  iprivateresource  ;

} /* IPrivateResource & ThreadSafeObject :: objectResource () */



/**************************************  END OF FILE THREADOBJ.CPP             ********************************************/
