//  Sysem Defined C Headers
# include <errno.h>
# include <stddef.h>


//  IBM OS2 Defined C Headers
# define  INCL_DOSERRORS
# define  INCL_DOSSEMAPHORES
# include <os2.h>


//  Locally Defined C++ Headers
# include <strfcns.h>


//  Sysem Defined C++ Headers
# include <iomanip.h>


//  IBM OCL Defined C++ Headers
# include <iexcept.hpp>


//  Locally Defined C++ Headers
# include <checkmem.hpp>
# include <namedobj.hpp>
# include <templary.hpp>
# include <eventsem.hpp>


# define CHECK_SEM_ERROR(errVal,func) if (0 != errVal){ITHROWSYSTEMERROR(errVal,func,IErrorInfo::accessError,IException::unrecoverable);}



EventSemaphore :: EventSemaphore ( Boolean bSet , const char * cszName , ULONG ulAttrs ) 
  : hev ( 0 ) , ulPostCount ( 0 )
{
  //  Only initialize if our string is valid.  Otherwise we want to leave charyName in its' default state of pointing to 0
  if ( strIsValid ( cszName ) )
  {
    charyName.init  ( strlen ( cszName ) + 1 , cszName ) ;

  } /* endif */

  APIRET  apiret  = DosCreateEventSem ( semName () , phandle () , ulAttrs , bSet ) ;

  CHECK_SEM_ERROR ( apiret , "DosCreateEventSem" ) ;

} /* EventSemaphore :: EventSemaphore ( Boolean bSet , const char * cszName , ULONG ulAttrs ) */



EventSemaphore :: ~EventSemaphore ()
{
  APIRET  apiret  = DosCloseEventSem ( handle () ) ;

} /* EventSemaphore :: ~EventSemaphore () */



ULONG EventSemaphore :: count ()
{
  APIRET  apiret  = DosQueryEventSem ( handle () , pcount () ) ;

  CHECK_SEM_ERROR ( apiret , "DosQueryEventSem" ) ;

  return  * pcount () ;

} /* ULONG EventSemaphore :: count () */



const char * EventSemaphore :: className () const
{
  return  "EventSemaphore"  ;

} /* const char * EventSemaphore :: className () const */



HEV EventSemaphore :: handle () const
{
  return  hev ;

} /* HEV EventSemaphore :: handle () const */



ULONG * EventSemaphore :: pcount ()
{
  return  & ulPostCount ;

} /* ULONG * EventSemaphore :: pcount () */



HEV * EventSemaphore :: phandle () 
{
  return  & hev ;

} /* HEV * EventSemaphore :: phandle ()  */



void EventSemaphore :: post () const
{
  APIRET  apiret  = DosPostEventSem ( handle () ) ;

  CHECK_SEM_ERROR ( apiret , "DosPostEventSem" ) ;

} /* void EventSemaphore :: post () const */



ULONG EventSemaphore :: reset ()
{
  APIRET  apiret  = DosResetEventSem ( handle () , pcount () ) ;

  CHECK_SEM_ERROR ( apiret , "DosResetEventSem" ) ;

  return  * pcount () ;

} /* ULONG EventSemaphore :: reset () */



const char * EventSemaphore :: semName () const
{
  return  charyName ;

} /* const char * EventSemaphore :: semName () const */




ULONG EventSemaphore :: wait ( ULONG ulMilliSecs ) const
{
  APIRET  apiret  = DosWaitEventSem ( handle () , ulMilliSecs ) ;

  if ( ERROR_TIMEOUT != apiret )
  {
    CHECK_SEM_ERROR ( apiret , "DosWaitEventSem" ) ;

  } /* endif */

  return  apiret  ;
  
} /* ULONG EventSemaphore :: wait ( ULONG ulMilliSecs ) const */


