# ifndef __tcpobj_hpp
  # define __tcpobj_hpp


/***************************************************************************************************************************

  FILE NAME :
    tcpobj.hpp


  DESCRIPTION :
    This header contains the declarations for the ABSTRACT class IPSocket and the CONCRETE class TCPSocket.  These classes
    abstract a generic Internet Protocol Socket and a TCP (Stream) Socket, respectively.  There is also a class in this
    heirarchy called UDPSocket, that abstracts a Datagram Socket.  Since Datagram Socket are rarely used, UDPSocket id
    declared elsewhere.


  CLASSES DECLARED IN THIS HEADER :
    class IPSocket  : public NamedObject
    class TCPSocket : public IPSocket
    

  Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.

***************************************************************************************************************************/
//  Locally Defined C++ Headers
# include <ipsock.hpp>




//  Constant declaration for our MAXIMUM TCPIP packet size
const SINT16  cs16GblMAX_PACKET = 0x2000  ;   // We are using an 8K (8192 bytes) packet size!
// const SINT16  cs16GblMAX_PACKET = 0x20  ;   // We are testing a 32 byte packet size!



//  Forward Class Declarations
class TCPStream ;



//  The class TCPObject represents the superclass for our two EXPORTED TCPIP classes, TCPServer and TCPStream.
class TCPObject : public NamedObject
{
public    :
//  Constructors
  TCPObject ()                                                                                    ;
  TCPObject ( const SockAddr  & rcsokaddrLocal  , const SockAddr & rcsokaddrRemot = SockAddr () ) ;
  TCPObject ( const TCPObject & rctcpobject )                                                     ;

//  Virtual Constant Methods
  virtual const char  * className     () const                                                    ;

//  Virtual Methods
  virtual int           close         ()                                                          ;

//  Constant Methods
  const TCPSocket     & tcpSocket     ()  const                                                   ;
  short                 waitTime      ()  const                                                   ;

//  Methods
  TCPObject           & init          ( const TCPObject & rctcpobject )                           ;
  TCPSocket           & tcpSocket     ()                                                          ;
  TCPSocket           & setTCPSocket  ( const TCPSocket & rctcpsocket )                           ;
  short                 setWaitTime   ( short sWaitTimeSeconds  = -1  )                           ;

//  Operators
  TCPObject           & operator =    ( const TCPObject & rctcpobject )                           ;

private   :
  short       sWaitSeconds  ;
  TCPSocket   tcpsocket     ;

} ; /* class TCPObject : public NamedObject */



class TCPServer : public TCPObject
{
public    :
//  Constructors
  TCPServer ( const SockAddr & rcsokaddrLocal )                   ;

//  Virtual Constant Methods
  virtual const char  * className     () const                    ;

//  Virtual Methods
  virtual SINT32        accept        ( TCPStream & rtcpstream )  ;
  virtual void          listen        ()                          ;

} ; /* class TCPServer : public TCPObject */



class TCPStream : public TCPObject
{
public    :
//  Constructors
  TCPStream ()                                                                                    ;
  TCPStream ( const SockAddr  & rcsokaddrLocal  , const SockAddr & rcsokaddrRemot = SockAddr () ) ;
  TCPStream ( const TCPObject & rctcpobject )                                                     ;

//  Virtual Constant Methods
  virtual const char  * className     ()                                          const ;
  virtual SINT32        read          ( void        * pvBuff  , SINT32 s32Len   ) const ;
  virtual SINT32        write         ( const void  * pcvBuff , SINT32 s32Len   ) const ;

protected :
  void                  readTimeOut   ( const SINT16  cs16NextRead              ) const ;

} ; /* class TCPStream : public TCPObject */




# endif  /*  # ifndef __tcpobj_hpp  */
