# ifndef __tcperror_hpp
  # define __tcperror_hpp

/***************************************************************************************************************************
 
    FILE NAME :
      tcperror.hpp
 
 
    DESCRIPTION :
      This module contains some macros used to check for and throw TCPIP exceptions.
    

    Copyright 1997, Peter Garner
      This code may be used for any NON-MILITARY purpose.
  
***************************************************************************************************************************/
//  Locally Defined C++ Headers
# include <liberror.hpp>
# include <excptn.hpp>



# define  THROW_TCPIP_ERROR( szMsg , nSockHandle )\
          {\
            LibErrorInfo  liberrinfo ;\
            TCPError tcperror ( liberrinfo.errorId () , liberrinfo.text () , nSockHandle , szMsg ) ;\
            THROW (tcperror) ;\
          } /* THROW_TCPIP_ERROR( szMsg , lErr ) */


# define  ESCAPE_BAD_TCPIP( nRetVal , szMsg , nSockHandle )\
          if ( nRetVal < 0 )\
          {\
            LibErrorInfo  liberrinfo ;\
            TCPError tcperror ( liberrinfo.errorId () , liberrinfo.text () , nSockHandle , szMsg ) ;\
            THROW (tcperror) ;\
          } /* endif */


# endif  /*  # ifndef __tcperror_hpp  */
