# ifndef __tableobj_hpp
  # define __tableobj_hpp



/***************************************************************************************************************************
 
    FILE NAME :
      TABLEOBJ.HPP
 
 
    DESCRIPTION :
      This header contains the declarations for the class TableObject, an abstract super class that represents a Database
      Table.
 
 
    Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.
 
***************************************************************************************************************************/
//  Locally Defined C++ Headers
# ifndef __dbaseobj_hpp     //  This include file includes the AIX semaphore includes, under AIX this must be included first 
  # include <dbaseobj.hpp>  //  Under OS/2 it does not matter                                                                
# endif


//  System Defined C Headers
# include <errno.h>



const int cnGblSQLStatSize  = 5 ;



class TableObject : virtual public DatabaseObject
{
public    :
//  Constructors
  TableObject () ;

//  Pure Virtual Constant Methods
  virtual Boolean         isValidForGet       ()  const = 0 ;   //  Checks to make sure that all primary key data is present
                                                                //  in receiver

  virtual Boolean         isValidForPut       ()  const = 0 ;   //  Checks to make sure that all required column data is
                                                                //  present in receiver

//  Pure Virtual Methods
  virtual long            get                 ()        = 0 ;   //  GETS a single row from the table
  virtual long            put                 ()        = 0 ;   //  INSERTS a single row into the table
  virtual long            update              ()        = 0 ;   //  UPDATES a single row in the table

//  Virtual Constant Methods
  virtual const char    * className           ()  const     ;   //  Returns the receivers' Class Name "TableObject"

//  Virtual Methods
  virtual void            clear               ()            ;   //  Clears all of the Receivers' DB Variables

//  Constant Methods
  long                  lastSQLCode           ()  const     ;   //  Accessor for the lSQLCodeLast member
  const char          * lastSQLStat           ()  const     ;   //  Accessor for the lSQLStatLast member

protected :
  long                  setSQLCode            ( long lSQLCode = 0 ) ;   //  Accessor for the lSQLCodeLast member 
  const char          * setSQLStat            ( const char *  = 0 ) ;   //  Accessor for the lSQLStatLast member 

private   :
  long    lSQLCodeLast                          ;               //  SQL Code  from the last Database Access
  char    szSQLStatLast [cnGblSQLStatSize + 1]  ;               //  SQL State from the last Database Access

} ; /* class TableObject : virtual public DatabaseObject */



//  Macros for throwing exceptions when the proper fields are not loaded
# define CHECK_VALID_GET() {if ( ! isValidForGet () ) { IInvalidRequest iinvalreq ( "PKey Fields Not Loaded"      , EINVAL ) ;ITHROW ( iinvalreq );}}
# define CHECK_VALID_PUT() {if ( ! isValidForPut () ) { IInvalidRequest iinvalreq ( "NON NULL Fields Not Loaded"  , EINVAL ) ;ITHROW ( iinvalreq );}}

# endif  /*  # ifndef __tableobj_hpp  */
