# ifndef __sockaddr_hpp
  # define __sockaddr_hpp

/***************************************************************************************************************************
 
    FILE NAME :
      sockaddr.hpp
 
 
    DESCRIPTION :
      This header contains the declarations for the class SockAddr.  This class encapsulates a TCPIP socket address.
 
 
    Copyright 1997, Peter Garner
      This code may be used for any NON-MILITARY purpose.
 
***************************************************************************************************************************/
//  System Defined C Headers
# include <resolv.h>
# include <sys/socket.h>



//  Locally Defined C Headers
# include <cpuport.h>


//  Locally Defined C++ Headers
# include <namedobj.hpp>



class SockAddr : virtual public NamedObject
{
public    :
//  Constructors
   SockAddr ( ushort usPort = 0 , const char * cszHostName = 0  ) ;
   SockAddr ( const SockAddr & rcsokaddr                        ) ;

//  Virtual Constant MetRhods
  virtual const char  * className             ()  const                                                         ;
  virtual ushort        port                  ()  const                                                         ;

//  Constant Methods
  const sockaddr_in   * iNetAddr              ()  const                                                         ;

//  Methods
  SINT32                host                  ( const char      * cszHostName                                 ) ;
  sockaddr_in         * iNetAddr              ()                                                                ;
  sockaddr            * sockAddr              ()                                                                ;
  void                  init                  ( ushort            usPort  = 0 , const char * cszHostName  = 0 ) ;
  void                  init                  ( const SockAddr  & rcsokaddr                                   ) ;
  SINT32                setAddr               ( SINT32            s32INetAddr                                 ) ;

//  Operators
  SockAddr            & operator  =           ( const SockAddr  & rcsockaddr                                  ) ;

//  Static Methods
  static size_t         addrSize              ()                                                                ;
  static const char   * localHostName         ( char            * szHostName  , size_t stMaxLen               ) ;
  static int            isINAddress           ( const char      * pccNewAddr                                  ) ;
  static ushort         servicePort           ( const char      * cszService  , const char * cszProtocol = 0  ) ;

private   :
  union
  {
    sockaddr_in   saint ;  
    sockaddr      skadr ;

  } /* union */ saddrUnion ;

} ; /* class SockAddr : virtual public NamedObject */




# endif  /*  # ifndef __sockaddr_hpp  */
