# ifndef __msgexp_hpp
  # define __msgexp_hpp


/***************************************************************************************************************************
 
    FILE NAME :
      MSGEXP.HPP
 
 
    APPLICATION :
      GENERAL OPERATORS AND UTILITY METHODS FOR DISPLAYING IEXCEPTIONS IN OCL IMESSAGEBOXES
   
 
    DESCRIPTION :
      This header contains the declarations for the some operators and utility methods that display IExceptions in OCL
      message boxes.
 
***************************************************************************************************************************/

//  IBM OCL Defined C++ Headers
# include <iexcept.hpp>
# include <imsgbox.hpp>
# include <ireslib.hpp>




int   showException   ( const IException & rciexp ) ;



void showMessage
      (
      IWindow                 * piwinowner    ,
      const char              * cszText       ,
      const char              * cszTitle = 0  ,
      IMessageBox :: Severity   severity = IMessageBox :: information
      ) ;


void showMessage
      (
      IWindow                 * piwinowner                      ,
      const char              * cszText                         ,
      const IResourceId       & ciresTitle                      ,
      IMessageBox :: Severity   severity    = IMessageBox :: information
      ) ;

void showMessage
      (
      IWindow                 * piwinowner                      ,
      const IResourceId       & ciresText                       ,
      const IResourceId       & ciresTitle  = IResourceId ( 0 ) ,
      IMessageBox :: Severity   severity    = IMessageBox :: information
      ) ;


IMessageBox & operator << ( IMessageBox & rimsgbox , const IException & rciexp ) ;


# endif  /*  # ifndef __msgexp_hpp  */
