# ifndef __keystrng_hpp
# define __keystrng_hpp



/***************************************************************************************************************************
 
    FILE NAME :
      KEYSTRNG.HPP


    APPLICATION :
      GENERAL - DECLARATION OF AN ISTRING DESCENDANT THAT CONTAINS A SHORT KEY VALUE TO EASE INSTANTIATON OF A KEY SORTED
      SET TEMPLATE


    DESCRIPTION :
      This header contains the declarations for the class KeyedString.  This class is an IString descendant that contains
      a short integer key value.  This class is used to instantiate the template IKeySortedSet < KeyedString , short >.
      
 
    CLASSES DEFINED IN THIS MODULE :
      class KeyedString : public IString
 
***************************************************************************************************************************/



//  System Defined C Headers
# include <stddef.h>


//  IBM OCL Defined C++ Headers
# include <iksset.h>
# include <istring.hpp>


//  Locally Defined C++ Headers
# include <namedobj.hpp>




class KeyedString : public IString , public NamedObject
{
public    :
//  Constructors
  KeyedString ()                                                ;
  KeyedString ( const char        * cszInit   , short sNewKey ) ;
  KeyedString ( const IString     & rcistring , short sNewKey ) ;
  KeyedString ( const KeyedString & crkeydstr                 ) ;

//  Virtual Constant Methods
  virtual const char    * className ()  const ;

//  Constant Methods
  short const           & key       ()  const ;

//  Methods
  short                   init      ( const KeyedString & crkeydstr ) ;

protected :
  short                   setKey    ( short sKeyNew ) ;

private   :
  short   sKey  ;

} ; /* class KeyedString : public IString , public NamedObject */



//  Type definition of the template that is the sole reason for this classes existance!
typedef IKeySortedSet < KeyedString , short > ShortKeySortedStrings ;


//  Utility method to return the short key value given a reference to a constant KeyedString element.  This utility method
//  is required by IBMs' OCL template definition.
short const & key ( KeyedString const & crkeystring ) ;



# endif  /*  # ifndef __keystrng_hpp  */
