# ifndef __ipsock_hpp
  # define __ipsock_hpp


/***************************************************************************************************************************

  FILE NAME :
    ipsock.hpp


  DESCRIPTION :
    This header contains the declarations for the ABSTRACT class IPSocket and the CONCRETE class TCPSocket.  These classes
    abstract a generic Internet Protocol Socket and a TCP (Stream) Socket, respectively.  There is also a class in this
    heirarchy called UDPSocket, that abstracts a Datagram Socket.  Since Datagram Socket are rarely used, UDPSocket id
    declared elsewhere.

  CLASSES DECLARED IN THIS HEADER :
    class IPSocket  : public NamedObject
    class TCPSocket : public IPSocket


  Copyright 1997, Peter Garner
    This code may be used for any NON-MILITARY purpose.
 
***************************************************************************************************************************/
//  Locally Defined C++ Headers
# include <autoobj.hpp>
# include <sockaddr.hpp>




class IPSocket : public AutoObject
{
public    :
//  Constructor
  IPSocket ()                                                                                                               ;
  IPSocket ( const IPSocket & rcipsocket )                                                                                  ;
  IPSocket ( const SockAddr & rcsokaddrLocal, const SockAddr & rcsokaddrRemot = SockAddr () )                               ;

//  Destructor
  virtual ~IPSocket ()                                                                                                      ;
                                                                                                            
//  Pure Virtual Constant Methods                                                                           
  virtual const char  * className       () const = 0                                                                        ;
  virtual int           protocol        () const = 0                                                                        ;
  virtual int           isStream        () const = 0                                                                        ;

//  Virtual Constant Methods                                                                           
  virtual UINT16        dataAvailable   ()                                                                            const ;
  virtual void          ioctl           ( int nOption , char * pcBuff , int nBuffLen      )                           const ;
  virtual int           getSockOptions  ( int nOption , void * pvOptVal , int * pnOptLen , int nLevel = SOL_SOCKET  ) const ;
  virtual int           read            ( char        * pcBuff  , SINT16 s16Length        )                           const ;
  virtual int           write           ( const char  * pccBuff , SINT16 s16Length        )                           const ;

//  Virtual Methods                                                                                         
  virtual void          bind            ()                                                                                  ;
  virtual int           close           ()                                                                                  ;
  virtual void          connect         ()                                                                                  ;
  virtual int           setSockOptions  ( int nOption , const void * pcvOptVal , int nOptLen , int nLevel = SOL_SOCKET )    ;

//  Constant Methods
  SINT32                handle          ()  const                                                                           ;
  const SockAddr      & localAddr       ()  const                                                                           ;
  const SockAddr      & remotAddr       ()  const                                                                           ;
                                                                                                            
//  Methods                                                                                                 
  SockAddr            & localAddr       ()                                                                                  ;
  SockAddr            & remotAddr       ()                                                                                  ;
  IPSocket            & init            ( const IPSocket  & rcipsocket        )                                             ;
  SINT32                setHandle       ( SINT32            s32NewSocket  = 0 )                                             ;
  SockAddr            & setLocalAddr    ( const SockAddr  & rcsokaddrNew      )                                             ;
  SockAddr            & setRemotAddr    ( const SockAddr  & rcsokaddrNew      )                                             ;
                                                                                                            
//  Operators                                                                                               
  IPSocket            & operator =      ( const IPSocket  & rcipsocket        )                                             ;
                                                                                                            
protected :
//  Protected Pure Virtual Methods
  virtual void            freeResource  ()                                                                                  ;      
                                                                                                            
private   :                                                                                                 
  SockAddr              sokaddrLocal                                                                                        ;
  SockAddr              sokaddrRemot                                                                                        ;
  SINT32                s32Socket                                                                                           ;
                                                                                                            
} ; /* class IPSocket : public NamedObject */



class TCPSocket : public IPSocket
{
public    :
//  Constructors
  TCPSocket ()                                                                                                              ;
  TCPSocket ( const TCPSocket & rctcpsocket    )                                                                            ;
  TCPSocket ( const SockAddr  & rcsokaddrLocal , const SockAddr & rcsokaddrRemot = SockAddr () )                            ;

//  Virtual Constant Methods
  virtual const char  * className       () const                                                                            ;
  virtual int           protocol        () const                                                                            ;
  virtual int           isStream        () const                                                                            ;

//  Virtual Methods
  virtual SINT32        accept          ()                                                                                  ;
  virtual void          listen          ()                                                                                  ;

//  Constant Methods
  int                   maxPending      () const                                                                            ;

//  Methods
  int                   setMaxPending   ( int nNumToPend  = enMAX_PEND  )                                                   ;

//  Operators
  TCPSocket           & operator =      ( const IPSocket  & rcipsocket  )                                                   ;

//  Enumerations
  enum { enMAX_PEND =  SOMAXCONN }                                                                                          ;

private   :
  int nMaxPendingConnections ;

} ; /* class TCPSocket : public IPSocket */



# endif  /*  # ifndef __ipsock_hpp  */

