# ifndef __generror_hpp
  # define __generror_hpp

/***************************************************************************************************************************
 
    FILE NAME :
      generror.hpp
 
 
    DESCRIPTION :
      This header contains some includes and macro definitions for portably dealing with Exceptions.  It is often desirable
      to redefine the base exception class and error throwing macros depending upon the compiler or library in use.  This
      header attempts to do just that by defining THROW and RETHROW macros as well as by typedefing a BaseException class.
      
 
***************************************************************************************************************************/
//  Define the exception classes in terms of what environment we are using
# ifdef __ANSI_CPP__

  # include <exception>
  typedef exception BaseException ;

# else  //  Assume we are using the IBM Exception Heirarchy

  # include <iexcept.hpp>
  typedef IException BaseException ;

  # define  THROW(ex)     ITHROW(ex)
  # define  RETHROW(ex)   IRETHROW(ex)

# endif  /* # ifdef __ANSI_CPP__ */


# endif  /* # ifndef __generror_hpp */
