# ifndef __eventsem_hpp
  # define __eventsem_hpp



class EventSemaphore : public NamedObject
{
public    :
//  Constructors
  EventSemaphore    ( Boolean bSet = false , const char * cszName = 0 , ULONG ulAttrs = 0 ) ;

//  Destructor
  ~EventSemaphore () ;

//  Virtual Constant Methods
  virtual const char    * className     ()                                          const ;

//  Constant Methods
  HEV                     handle        ()                                          const ;
  void                    post          ()                                          const ;
  const char            * semName       ()                                          const ;
  ULONG                   wait          ( ULONG ulMilliSecs = SEM_INDEFINITE_WAIT ) const ;

//  Methods
  ULONG                   count         ()                                                ;
  ULONG                   reset         ()                                                ;

protected :
//  Protected Methods
  HEV                   * phandle       ()                                                ;
  ULONG                 * pcount        ()                                                ;

private   :
  HEV       hev         ;
  CharArray charyName   ;
  ULONG     ulPostCount ;

} ; /* class EventSemaphore : public NamedObject */





# endif  /*  # ifndef __eventsem_hpp  */
