# ifndef __creslock_hpp
  # define __creslock_hpp

/***************************************************************************************************************************

  Copyright - Peter Garner, 1997.
     This code is released into the public domain, and you are free to use and modify this without credit to the author

***************************************************************************************************************************/


//  This is OUR implementation of a SUBSET of the IPrivateResource and IResourceLock class interfaces.  It seems that
//  neither of these classes work properly in the version of ICLUI that is being used under AIX to build the WORS project.
//  Therefore we have implemented a VERY SMALL subset of this interface so that this project will be upward compatible with
//  future releases of ICLUI and/or OCL under AIX.


# include <pthread.h>


class PrivateResource
{
public    :
//  Constructors
  PrivateResource                   ()  ;

//  Destructor
  virtual ~PrivateResource          ()  ;

//  Virtual Methods
  virtual             lock          ()  ;
  virtual             unlock        ()  ;

protected :
  pthread_mutex_t   * getMutexAddr  ()  ;

private   :
  pthread_mutex_t     mutex ;

} ; /* class PrivateResource */



class ResourceLock
{
public    :
//  Constructors
  ResourceLock ( PrivateResource & rprivresNew ) : rprivres ( rprivresNew ) { getPrivResource ().lock () ; }

//  Destructor
  virtual ~ResourceLock () { getPrivResource ().unlock () ; }

protected :
  PrivateResource   & getPrivResource () { return rprivres ; }

private   :
  PrivateResource   & rprivres  ;

} ; /* class ResourceLock */



# define  IPrivateResource  PrivateResource   
# define  IResourceLock     ResourceLock      



/******************************************************************************/
/*******************************  PVCS INFORMATION  ***************************/
/******************************************************************************

  $Archive:   /home/wor/worpvcs/arch/creslock.hpp.v  $
   
  $Author:   c615490  $
   
  $Date:   Thu May  8 11:08:26 1997  $

  $Description: $
   
  $Revision:   1.1  $
   
  $Workfile:   creslock.hpp  $
   
  $Log:   /home/wor/worpvcs/arch/creslock.hpp.v  $
#  
#     Rev 1.1   Thu May  8 11:08:26 1997   c615490
#  Added public domain copyright
#  
#     Rev 1.0   Tue Apr  1 14:55:32 1997   c615490
#  Initial revision.
   
 ******************************************************************************/
/*******************************  PVCS INFORMATION  ***************************/
/******************************************************************************/



# endif  /*  # ifndef __creslock_hpp  */
