# ifndef __commwin_hpp
  # define __commwin_hpp


//  Locally Defined C Headers
//# include <cpuport.h>


//  OS2 Defined C Headers
# include <os2.h>   // For the definition of ULONG


//  IBM OCL Defined C++ Headers
# include <icmdhdr.hpp>
# include <iframe.hpp>
# include <imenubar.hpp>
# include <ititle.hpp>




class CommandWindow : public IFrameWindow , public ICommandHandler
{
public    :
//  Constructors
  CommandWindow ( ULONG ulId ) ;
  CommandWindow ( const char * cszTitle , const IResourceId & rciresid ) ;

  CommandWindow
    (
    const IResourceId & rciresid    ,
    IWindow           * piwinOwner  ,
    IWindow           * piwinParent = IWindow :: desktopWindow ()
    ) ;

  CommandWindow
    (
    IWindow                     * pwinOwner                                       ,
    const IResourceId           & rciresid                                        ,
    IWindow                     * pwinParent  = IWindow :: desktopWindow      ()  ,
    const IFrameWindow :: Style & rcstyle     = IFrameWindow :: defaultStyle  ()  ,
    const IRectangle            & rcirect     = IFrameWindow :: nextShellRect ()
    ) ;

  ~CommandWindow () ;

protected :
//  Protected Pure Virtual Methods
  virtual IBoolean      command             ( ICommandEvent & ricmdevt )  = 0 ;

} ; /* class CommandWindow : public IFrameWindow , public ICommandHandler */




class DialogBox : public CommandWindow
{
public    :
//  Constructors
  DialogBox ( const IResourceId & rciresid , IWindow * piwinOwner  , IWindow * piwinParent = IWindow :: desktopWindow () ) ;

protected :
//  Protected Virtual Methods
  virtual IBoolean    command       ( ICommandEvent & ricmdevt ) ;

} ; /* class DialogBox : public CommandWindow */



//  This class is a mixin that can be added to get Menubar functionality
class MenuedObject
{
public    :
//  Constructors
  MenuedObject ( const IResourceId & rciresid , IFrameWindow * pwinOwner ) ;

  const IMenuBar        & menubar           ()  const ;
  IMenuBar              & menubar           ()        ;

private   :
  IMenuBar  imenubar  ;

} ; /* class MenuedObject */



//  This class is a mixin that can be added to get Titlebar functionality
class TitledObject
{
public    :
//  Constructors
  TitledObject ( IWindow * pwinOwner , const IResourceId & rciresid ) ;
  TitledObject ( IWindow * pwinOwner , const char        * cszTitle ) ;

  const ITitle          & title             ()  const ;
  ITitle                & title             ()        ;

private   :
  ITitle    ititle  ;

} ; /* class TitledObject */



class TitleMenuWindow : public CommandWindow , public MenuedObject , public TitledObject
{
public    :
//  Constructors
  TitleMenuWindow ( ULONG ulId ) ;
  TitleMenuWindow ( const char * cszTitle , const IResourceId & rciresid ) ;

  TitleMenuWindow
    (
    const IResourceId & rciresid    ,
    IWindow           * piwinOwner  ,
    IWindow           * piwinParent = IWindow :: desktopWindow ()
    ) ;

  TitleMenuWindow
    (
    IWindow                     * pwinOwner                                       ,
    const IResourceId           & rciresid                                        ,
    IWindow                     * pwinParent  = IWindow :: desktopWindow      ()  ,
    const IFrameWindow :: Style & rcstyle     = IFrameWindow :: defaultStyle  ()  ,
    const IRectangle            & rcirect     = IFrameWindow :: nextShellRect ()
    ) ;

} ; /* class TitleMenuWindow : public CommandWindow , public MenuedObject , public TitledObject */



# endif  /*  # ifndef __commwin_hpp  */
