# ifndef __cliinfo_hpp
  # define __cliinfo_hpp


//  Locally Defined C++ Headers
# include <generror.hpp>  //  Defines the THROW macro


typedef IAccessError  CLIError  ;


const SQLSMALLINT csqlsMSG_LEN  = SQL_MAX_MESSAGE_LENGTH      + 1 ;
const SQLSMALLINT csqlsNAME_LEN = SQL_MAX_QUALIFIER_NAME_LEN  + 1 ;
const SQLSMALLINT csqlsSTAT_LEN = SQL_SQLSTATE_SIZE           + 1 ;



struct CLIErrorStruct
{
//  Constructor
  CLIErrorStruct ( SQLHENV  sqlhenvErr = 0 , SQLHDBC sqlhdbcErr = 0 , SQLHSTMT sqlhstmtErr = 0 ) ;
  CLIErrorStruct ( const CLIErrorStruct & rcclierrorstruct ) ;

//  Public Data
    SQLHENV     sqlhenv                   ;   //  Input,  Environment Handle
    SQLHDBC     sqlhdbc                   ;   //  Input,  Connection  Handle
    SQLHSTMT    sqlhstmt                  ;   //  Input,  Statement   Handle
    SQLINTEGER  sqlnErr                   ;   //  Output, Error ID
    SQLCHAR     sqlszStat [csqlsSTAT_LEN] ;   //  Output, SQL Status
    SQLCHAR     sqlszErr  [csqlsMSG_LEN ] ;   //  Output, Error Message Text
    SQLSMALLINT sqlsErrLen                ;   //  Output, Actual Error Message Text Length

} ; /* struct CLIErrorStruct */



class CLIErrorInfo : public CLIErrorStruct , public NamedObject
{
public    :
//  Constructors
  CLIErrorInfo ( SQLHENV sqlhenvErr , SQLHDBC sqlhdbcErr = 0 , SQLHSTMT sqlhstmtErr = 0 ) ;
  CLIErrorInfo ( const CLIErrorInfo & crclierrorinfo ) ;

//  Virtual Constant Methods
  virtual long          errorId      () const ;
  virtual const char  * className    () const ;
  virtual IString       getFullMsg   () const ;

} ; /* class CLIErrorInfo */


# define CHECK_CLI_ERROR(sqlretval,HENV,HDBC,HSTMT,szMSG)\
{\
 if ( SQL_SUCCESS != sqlretval && SQL_SUCCESS_WITH_INFO != sqlretval )\
 {\
    CLIErrorInfo  clierrorinfo  ( HENV , HDBC , HSTMT ) ;\
    IString       istrgMsg      ( IString ( szMSG ) + clierrorinfo.getFullMsg () ) ;\
    CLIError      clierr        ( istrgMsg , clierrorinfo.errorId () ) ;\
    THROW ( clierr ) ;\
 }\
} /* CHECK_CLI_ERROR */



# define CHECK_CURSOR_ERROR(sqlretval,HENV,HDBC,HSTMT,szMSG)\
{\
 if ( SQL_SUCCESS != sqlretval && SQL_SUCCESS_WITH_INFO != sqlretval && SQL_NO_DATA_FOUND != sqlretval )\
 {\
    CLIErrorInfo  clierrorinfo  ( HENV , HDBC , HSTMT ) ;\
    IString       istrgMsg      ( IString ( szMSG ) + clierrorinfo.getFullMsg () ) ;\
    CLIError      clierr        ( istrgMsg , clierrorinfo.errorId () ) ;\
    ITHROW  ( clierr ) ;\
 }\
} /* CHECK_CLI_ERROR */



# define THROWCLI(HENV,HDBC,HSTMT,szMSG)\
{\
  CLIErrorInfo clierrorinfo ( HENV , HDBC , HSTMT ) ;\
  IString istrgMsg ( IString ( szMSG ) + clierrorinfo.getFullMsg () ) ;\
  IAccessError iacerr ( istrgMsg , clierrorinfo.errorId () ) ;\
  THROW ( iacerr ) ;\
} /* THROWCLI */



# endif  /*  # ifndef __cliinfo_hpp  */
