# ifndef __checkmem_hpp
  # define __checkmem_hpp


// System Defined C Headers
# include <errno.h>


// IBM OCL Defined C++ Headers
# include <iexcept.hpp>



# define THROW_MEM_ERR() { IOutOfMemory ioutofmem ( "Out of Memory" , ENOMEM ) ; ITHROW ( ioutofmem ) ; }

//  This macro checks if a pointer is 0 and throws a NoMemError if it is.  It is intended to throw an ENOMEM
//  when a pointer allocation returns null
# define CHECK_MEM( ptr )   if ( 0 == ptr ) { THROW_MEM_ERR () ; }
# define RETURN_MEM( ptr )  CHECK_MEM( ptr ) return ptr




# endif  /*  # ifndef __checkmem_hpp  */
