# ifndef __charcol_hpp
  # define __charcol_hpp


# include <checkmem.hpp>
# include <datacol.hpp>
# include <templary.hpp>



class CharArrayColumn : public DataColumn
{
public    :
//  Constructors
  CharArrayColumn () ;
  CharArrayColumn ( const TableColumn     & crtablecolumn   ) ;
  CharArrayColumn ( const CharArrayColumn & crcharraycolumn ) ;

//  Virtual Constant Methods
  virtual const char      * className     ()  const ;
  virtual const char      * getVal        ()  const ;

//  Virtual Methods
  virtual const char      * setVal        ( const char * cszNewVal ) ;

//  Constant Methods
  const CharArray         & chararray     ()  const ;
  const char              * data          ()  const ;

//  Methods
  CharArray               & chararray     ()        ;
  char                    * data          ()        ;
  unsigned                  init          ( const TableColumn & crtablecolumn ) ;

  unsigned                  init
                              (
                              unsigned      uColNo      ,
                              const char  * cszColName  ,
                              SQLDataType   sqldatatype ,
                              unsigned      uColLength  ,
                              unsigned      uColScale   ,
                              Boolean       bNullable   ,
                              unsigned      uDisplayLen
                              ) ;


private   :
  CharArray   charryData  ;

} ; /* class CharArrayColumn : public DataColumn */






# endif  /*  # ifndef __charcol_hpp  */
